/////////////////////////////////////////////////////////////////////////////
// $Header: $
//
// Copyright (c) 2000 ConnectTel, Inc. All Rights Reserved.
//  
// MODULE DESCRIPTION:
//
// Example of the usage of the client of the Remote Resources
// Monitor for RTEMS.
//
// MODIFICATION/HISTORY:
//
// $Log: $
//
/////////////////////////////////////////////////////////////////////////////

#include <iostream.h>
#include <stdio.h>

#include "rtems_rrm.hh"

static CORBA::Object_ptr getObjectReference(CORBA::ORB_ptr orb);

int main(int argc, char **argv)
{
  try {
    CORBA::ORB_var orb = CORBA::ORB_init(argc, argv, "omniORB3");

    CORBA::Object_var obj = getObjectReference(orb);


     Rtems::Monitor_var m = Rtems::Monitor::_narrow( obj );
     if( CORBA::is_nil( m ) ) 
     {
        cerr << "RtemsMonitor: cannot invoke on a nil object reference.\n" << endl;
        return 0;
     }
     CORBA::String_var htmlPage = m->getInstancesAsHTML( Rtems::RTEMS_THREAD );

     cerr << (char*)htmlPage << endl;

     Rtems::CounterInfo c = m->getCounter( Rtems::RTEMS_THREAD );
     printf( "RtemsMonitor: Counter: Max=%d, Cur=%d\n", c.u_default().max_available,
                                                        c.u_default().cur_inuse );


     c = m->getCounter( Rtems::CPU );
     printf( "RtemsMonitor: Cpu: Max=%d, Idle=%d\n", c.u_cpu().total_ticks,
                                                    c.u_cpu().idle_ticks );

    for(;; )
 	 {

     c = m->getCounter( Rtems::CPU );
     printf( "RtemsMonitor: Cpu: Max=%d, Idle=%d\n", c.u_cpu().total_ticks,
                                                    c.u_cpu().idle_ticks );
     omni_thread::sleep( 0, 100000 );
	 }

    orb->destroy();
  }
  catch(CORBA::COMM_FAILURE& ex) {
    cerr << "Caught system exception COMM_FAILURE -- unable to contact the "
         << "object." << endl;
  }
  catch(CORBA::SystemException&) {
    cerr << "Caught CORBA::SystemException." << endl;
  }
  catch(CORBA::Exception&) {
    cerr << "Caught CORBA::Exception." << endl;
  }
  catch(omniORB::fatalException& fe) {
    cerr << "Caught omniORB::fatalException:" << endl;
    cerr << "  file: " << fe.file() << endl;
    cerr << "  line: " << fe.line() << endl;
    cerr << "  mesg: " << fe.errmsg() << endl;
  }
  catch(...) {
    cerr << "Caught unknown exception." << endl;
  }

  return 0;
}

static 
CORBA::Object_ptr
getObjectReference(CORBA::ORB_ptr orb)
{
  CosNaming::NamingContext_var rootContext;
  
  try {
    // Obtain a reference to the root context of the Name service:
    CORBA::Object_var initServ;
    initServ = orb->resolve_initial_references("NameService");

    // Narrow the object returned by resolve_initial_references()
    // to a CosNaming::NamingContext object:
    rootContext = CosNaming::NamingContext::_narrow(initServ);
    if (CORBA::is_nil(rootContext)) 
      {
        cerr << "Failed to narrow naming context." << endl;
        return CORBA::Object::_nil();
      }
  }
  catch(CORBA::ORB::InvalidName& ex) {
    cerr << "Service required is invalid [does not exist]." << endl;
    return CORBA::Object::_nil();
  }


  // Create a name object, containing the name test/context:
  CosNaming::Name name;
  name.length(2);

  name[0].id   = (const char*) "Rtems";       // string copied
  name[0].kind = (const char*) "Module";      // string copied
  name[1].id   = (const char*) "Monitor";
  name[1].kind = (const char*) "Object";
  // Note on kind: The kind field is used to indicate the type
  // of the object. This is to avoid conventions such as that used
  // by files (name.type -- e.g. test.ps = postscript etc.)

  
  CORBA::Object_ptr obj;
  try {
    // Resolve the name to an object reference, and assign the reference 
    // returned to a CORBA::Object:
    obj = rootContext->resolve(name);
  }
  catch(CosNaming::NamingContext::NotFound& ex)
    {
      // This exception is thrown if any of the components of the
      // path [contexts or the object] aren't found:
      cerr << "Context not found." << endl;
      return CORBA::Object::_nil();
    }
  catch (CORBA::COMM_FAILURE& ex) {
    cerr << "Caught system exception COMM_FAILURE, unable to contact the "
         << "naming service." << endl;
    return CORBA::Object::_nil();
  }
  catch(omniORB::fatalException& ex) {
    cerr << "Caught a omniORB::fatalException exception." << endl;
    throw;
  }
  catch (...) {
    cerr << "Caught a system exception while using the naming service."<< endl;
    return CORBA::Object::_nil();
  }
  return obj;
}
