/////////////////////////////////////////////////////////////////////////////
// $Header: $
//
// Copyright (c) 2000 ConnectTel, Inc. All Rights Reserved.
// by: Rosimildo da Silva. ( rdasilva@connecttel.com )
//  
// MODULE DESCRIPTION: 
//
// This class wraps the bootstraping and ORB initialization.
// It is a very simplistic interface, and very weak error handling
// is implemented at this time..
//
// MODIFICATION/HISTORY:
//
// $Log: $
//
/////////////////////////////////////////////////////////////////////////////

import org.omg.CosNaming.*;
import org.omg.CORBA.*;
import java.util.*;

public class RtemsORBWrapper
{
  public static Rtems.Monitor monitorRef;
  public static ORB orb;

  // Returns the ORB 
  public static ORB getORB( String args[], String namingHost, String namingPort )
  {
     Properties props = new Properties();
     // props.put("org.omg.CORBA.ORBClass", "com.sun.CORBA.iiop.ORB" );
     if( namingHost != null )
         props.put("org.omg.CORBA.ORBInitialHost", namingHost );
     if( namingPort != null )
         props.put("org.omg.CORBA.ORBInitialPort", namingPort );

     System.out.println( "Initializing ORB" );  
     orb = ORB.init( args, props );  // create and initialize the ORB
     System.out.println( "ORB created." );  
	 return orb;
  }

  // Interface for setting up/down connection with the server.
  public static boolean setupConnection()
  {
    try
    {
      // get the root naming context

      System.out.println( "ORB: resolving NamingService" );  

      org.omg.CORBA.Object objRef = orb.resolve_initial_references( "NameService" );

      System.out.println( "ORB: narrow name service." );  
      NamingContext ncRef = NamingContextHelper.narrow( objRef );

      System.out.println("Name Service found." );

      // resolve the Object Reference in Naming
      //
      // Be very careful here. CORBA naming is case sensitive, and
      // some times this can cause you to lose a few hairs. :-).
      //
      NameComponent nc1 = new NameComponent( "Rtems", "Module");
      NameComponent nc = new NameComponent(  "Monitor", "Object" );

      NameComponent path[] = {nc1, nc};
      System.out.println("About to connect to the RTEMS target" );
      monitorRef = Rtems.MonitorHelper.narrow( ncRef.resolve( path ) );
      System.out.println("Initialization is completed, instance is ready." );
	  return true;	
    }
    catch (Exception e) 
    {
       System.out.println("ERROR : " + e) ;
       e.printStackTrace( System.out );
    }
    return false;
  }
  public static void releaseConnection() { monitorRef = null; }
  public static boolean isConnected() { return monitorRef != null; }

}

