/////////////////////////////////////////////////////////////////////////////
// $Header: $
//
// Copyright (c) 2000 ConnectTel, Inc. All Rights Reserved.
// by: Rosimildo da Silva.
//  
// MODULE DESCRIPTION: 
//
// This class is responsible for showing the panel for view resources 
// information of RTEMS. It is based on the "HTML" control of Swing,
// and it uses the remote call that returns the information from 
// RTEMS formated as a HTML page.
//
// MODIFICATION/HISTORY:
//
// $Log: $
//
/////////////////////////////////////////////////////////////////////////////


import javax.swing.JTabbedPane;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JFrame;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.border.*;

import java.awt.*;
import java.awt.event.*;

public class ResourcesViewControl extends JPanel implements ChangeListener 
{
    // this is the text shown in the "about" window.
    static final String  aboutMsg = "<html><head><title>About RRM</title></head><body>" +
      "<h3>Remote Resources Monitor for RTEMS - Version 0.01</h3><hr><p>" +
      "This program is a demo to show the integtation of a CORBA ORB " +
      "<A HREF=\"http://www.uk.research.att.com/omniORB/omniORB.html\">omniORB</a> and " +
      " RTEMS, specially " + 
      " the integration of CORBA aware languages such as Java, Python, etc.<p>" +
      "It is not intended to teach CORBA, Java or any other technology.<p>" +
      "<p>By: Rosimildo da Silva ( rdasilva@connecttel.com ) - ConnectTel, Inc.<br>" +
      "<A HREF=\"www.connecttel.com\">www.connecttel.com</a><p>" +
      "</body></html>";


    // Instance variables...
    JTabbedPane tabbedPane;
    HtmlPanel html0;
    HtmlPanel html1;
    HtmlPanel html2;
    HtmlPanel html3;
    HtmlPanel html4;
    HtmlPanel html5;
    HtmlPanel html6;
    HtmlPanel html7;
    HtmlPanel html8;
    HtmlPanel html9;
    HtmlPanel html10;
    HtmlPanel html11;
    HtmlPanel html12;
    HtmlPanel html13;
    HtmlPanel htmlAbout;

//    public static ORB orb;

    // Class constants...
    static final String  TITLE_CPU              = "CPU";
    static final String  TITLE_RTEMS_CLOCK      = "RTEMS Clock";
    static final String  TITLE_RTEMS_THREADS    = "RTEMS Threads";
    static final String  TITLE_RTEMS_SEMAPHORES = "RTEMS Semaphores";
    static final String  TITLE_RTEMS_PARTITIONS = "RTEMS Partitions";
    static final String  TITLE_RTEMS_REGIONS    = "RTEMS Regions";
    static final String  TITLE_RTEMS_MSG_QUEUES = "RTEMS Message Queues";
    static final String  TITLE_POSIX_THREADS    = "POSIX Threads";
    static final String  TITLE_POSIX_SEMAPHORES = "POSIX Semaphores";
    static final String  TITLE_POSIX_MSG_QUEUES = "POSIX Message Queues";
    static final String  TITLE_POSIX_MUTEXES    = "POSIX Mutexes";
    static final String  TITLE_POSIX_KEYS       = "POSIX Keys";
    static final String  TITLE_POSIX_INTERRUPTS = "POSIX Interrupts";
    static final String  TITLE_POSIX_COND_VARS  = "POSIX Condition Variables";
    static final String  TITLE_ABOUT            = "About";

    static final int  INDEX_CPU                = 0;
    static final int  INDEX_RTEMS_CLOCK        = 1;
    static final int  INDEX_RTEMS_THREADS      = 2;
    static final int  INDEX_RTEMS_SEMAPHORES   = 3;
    static final int  INDEX_RTEMS_PARTITIONS   = 4;
    static final int  INDEX_RTEMS_REGIONS      = 5;
    static final int  INDEX_RTEMS_MSG_QUEUES   = 6;
    static final int  INDEX_POSIX_THREADS      = 7;
    static final int  INDEX_POSIX_SEMAPHORES   = 8;
    static final int  INDEX_POSIX_MSG_QUEUES   = 9;
    static final int  INDEX_POSIX_MUTEXES      = 10;
    static final int  INDEX_POSIX_KEYS         = 11;
    static final int  INDEX_POSIX_INTERRUPTS   = 12;
    static final int  INDEX_POSIX_COND_VARS    = 13;
    static final int  INDEX_ABOUT              = 14;

    //
    // Initializes the panel to collect instances information for the
    // RTEMS Spy application.
    //
    public ResourcesViewControl() 
    {
        ImageIcon icon = new ImageIcon("images/middle.gif");
        tabbedPane = new JTabbedPane();
        GridLayout grid;

        html0 = new HtmlPanel();
        html1 = new HtmlPanel();
        html2 = new HtmlPanel();
        html3 = new HtmlPanel();
        html4 = new HtmlPanel();
        html5 = new HtmlPanel();
        html6 = new HtmlPanel();
        html7 = new HtmlPanel();
        html8 = new HtmlPanel();
        html9 = new HtmlPanel();
        html10 = new HtmlPanel();
        html11 = new HtmlPanel();
        html12 = new HtmlPanel();
        html13 = new HtmlPanel();
        htmlAbout = new HtmlPanel();

        tabbedPane.addTab( TITLE_CPU             , icon, html0, TITLE_CPU              );
        tabbedPane.addTab( TITLE_RTEMS_CLOCK     , icon, html1, TITLE_RTEMS_CLOCK      );
        tabbedPane.addTab( TITLE_RTEMS_THREADS   , icon, html2, TITLE_RTEMS_THREADS    );
        tabbedPane.addTab( TITLE_RTEMS_SEMAPHORES, icon, html3, TITLE_RTEMS_SEMAPHORES );
        tabbedPane.addTab( TITLE_RTEMS_PARTITIONS, icon, html4, TITLE_RTEMS_PARTITIONS );
        tabbedPane.addTab( TITLE_RTEMS_REGIONS   , icon, html5, TITLE_RTEMS_REGIONS    );
        tabbedPane.addTab( TITLE_RTEMS_MSG_QUEUES, icon, html6, TITLE_RTEMS_MSG_QUEUES );
        tabbedPane.addTab( TITLE_POSIX_THREADS   , icon, html7, TITLE_POSIX_THREADS    );
        tabbedPane.addTab( TITLE_POSIX_SEMAPHORES, icon, html8, TITLE_POSIX_SEMAPHORES );
        tabbedPane.addTab( TITLE_POSIX_MSG_QUEUES, icon, html9,TITLE_POSIX_MSG_QUEUES );
        tabbedPane.addTab( TITLE_POSIX_MUTEXES   , icon, html10,TITLE_POSIX_MUTEXES    );
        tabbedPane.addTab( TITLE_POSIX_KEYS      , icon, html11,TITLE_POSIX_KEYS       );
        tabbedPane.addTab( TITLE_POSIX_INTERRUPTS, icon, html12,TITLE_POSIX_INTERRUPTS );
        tabbedPane.addTab( TITLE_POSIX_COND_VARS , icon, html13,TITLE_POSIX_COND_VARS  );
        tabbedPane.addTab( TITLE_ABOUT , icon, htmlAbout,TITLE_ABOUT  );

        tabbedPane.addChangeListener( this );

        tabbedPane.setSelectedIndex( INDEX_ABOUT  );
        // htmlAbout.setText( aboutMsg );

        setBorder( new TitledBorder(new EtchedBorder(), "Detailed Resources Information") );

        //Add the tabbed pane to this panel.
        grid = new GridLayout( 1, 1 ); 
        setLayout( grid ); 
        add( tabbedPane );
    }


    //
    // This event handler is called by the "tabbed panel" when a page is
    // selected. The remote object is called and its corresponding "HTML"
    // page is displayed.
    //
    public void stateChanged( ChangeEvent e ) 
    {
       String msg;
       System.out.println("ChangeEvent: " + tabbedPane.getSelectedIndex() );
       switch( tabbedPane.getSelectedIndex() )
       {
          case INDEX_CPU:              
             msg = RtemsORBWrapper.monitorRef.getInstancesAsHTML( Rtems.CounterType.CPU );
             html0.setText( msg );
             break;

          case INDEX_RTEMS_CLOCK:
             msg = RtemsORBWrapper.monitorRef.getInstancesAsHTML( Rtems.CounterType.CLOCK );
             html1.setText( msg );
             break;

          case INDEX_RTEMS_THREADS:    
             msg = RtemsORBWrapper.monitorRef.getInstancesAsHTML( Rtems.CounterType.RTEMS_THREAD );
             html2.setText( msg );
             break;

          case INDEX_RTEMS_SEMAPHORES: 
             msg = RtemsORBWrapper.monitorRef.getInstancesAsHTML( Rtems.CounterType.RTEMS_SEMAPHORE );
             html3.setText( msg );
             break;

          case INDEX_RTEMS_PARTITIONS: 
             msg = RtemsORBWrapper.monitorRef.getInstancesAsHTML( 
                            Rtems.CounterType.RTEMS_PARTITION );
             html4.setText( msg );
             break;

          case INDEX_RTEMS_REGIONS:    
             msg = RtemsORBWrapper.monitorRef.getInstancesAsHTML( 
                            Rtems.CounterType.RTEMS_REGION );
             html5.setText( msg );
             break;

          case INDEX_RTEMS_MSG_QUEUES:
             msg = RtemsORBWrapper.monitorRef.getInstancesAsHTML( 
                            Rtems.CounterType.RTEMS_MESSAGE_QUEUE );
             html6.setText( msg );
             break;

          case INDEX_POSIX_THREADS:    
             msg = RtemsORBWrapper.monitorRef.getInstancesAsHTML( 
                            Rtems.CounterType.POSIX_THREAD );
             html7.setText( msg );
             break;


          case INDEX_POSIX_SEMAPHORES:
             msg = RtemsORBWrapper.monitorRef.getInstancesAsHTML( 
                            Rtems.CounterType.POSIX_SEMAPHORE );
             html8.setText( msg );
             break;

          case INDEX_POSIX_MSG_QUEUES: 
             msg = RtemsORBWrapper.monitorRef.getInstancesAsHTML( 
                            Rtems.CounterType.POSIX_MESSAGE_QUEUE );
             html9.setText( msg );
             break;

          case INDEX_POSIX_MUTEXES:
             msg = RtemsORBWrapper.monitorRef.getInstancesAsHTML( 
                            Rtems.CounterType.POSIX_MUTEX );
             html10.setText( msg );
             break;
              
          case INDEX_POSIX_KEYS:       
             msg = RtemsORBWrapper.monitorRef.getInstancesAsHTML( 
                            Rtems.CounterType.POSIX_KEY );
             html11.setText( msg );
             break;

          case INDEX_POSIX_INTERRUPTS:
             msg = RtemsORBWrapper.monitorRef.getInstancesAsHTML( 
                            Rtems.CounterType.POSIX_INTERRUPT );
             html12.setText( msg );
             break;

          case INDEX_POSIX_COND_VARS:  
             msg = RtemsORBWrapper.monitorRef.getInstancesAsHTML( 
                            Rtems.CounterType.POSIX_COND_VARIABLE );
             html13.setText( msg );
             break;

          case INDEX_ABOUT:              
             htmlAbout.setText( aboutMsg );
             break;

       }
    }

    //
    // Test driver for this class..
    //
    public static void main(String[] args) 
    {
      // Let's try to talk to our remote instance...
      try
      {
        RtemsORBWrapper.getORB( args, "rps1", "6000" );  // create and initialize the ORB

        if( !RtemsORBWrapper.setupConnection() )
		{
          System.out.println("Could not set remote connection." );
          System.exit( 1 );
        }
        System.out.println("Connected successfully." );
      } 
      catch( Exception e ) 
      {
        System.out.println( "CORBA ERROR: " + e );
        e.printStackTrace(System.out);
        System.exit( 1 );
      }


      JFrame frame = new JFrame("ResourcesViewControl Test driver..");
      frame.addWindowListener(new WindowAdapter() {
          public void windowClosing(WindowEvent e) {System.exit(0);}
      });

      frame.getContentPane().add(new ResourcesViewControl(), 
                                 BorderLayout.CENTER);
      frame.setSize(400, 125);
      frame.setVisible(true);
    }
}
