/////////////////////////////////////////////////////////////////////////////
// $Header: $
//
// Copyright (c) 2000 ConnectTel, Inc. All Rights Reserved.
//  
// MODULE DESCRIPTION:
//
// This class is responsible for creating the panel where the selection
// and activation of a counter is done. 
//
// MODIFICATION/HISTORY:
//
// $Log: $
//
/////////////////////////////////////////////////////////////////////////////


import javax.swing.JTabbedPane;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JFrame;
import javax.swing.JButton;
import javax.swing.JRadioButton;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.border.*;

import java.awt.*;
import java.awt.event.*;


public class CounterSelection extends JPanel 
{

  // Strings to identify which button has been pressed...
  public static final String UP_ACTION     = "UP_MONITOR";
  public static final String CENTER_ACTION = "CENTER_MONITOR";
  public static final String DOWN_ACTION   = "DOWN_MONITOR";


  // Public "Strings" represeting the selection of the combo
  // box. Thys can be used to check each item is currently selected.
  public static final String OPTION_NONE            = "NONE";
  public static final String OPTION_CPU             = "Cpu Utilization";
  public static final String OPTION_MEMORY          = "Memory Utilization";
  public static final String OPTION_RTEMS_THREAD    = "RTEMS Threads";
  public static final String OPTION_RTEMS_SEMAPHORE = "RTEMS Semaphores";
  public static final String OPTION_RTEMS_MSG_QUEUE = "RTEMS Message Queues";
  public static final String OPTION_RTEMS_TIMER     = "RTEMS Timers";
  public static final String OPTION_RTEMS_PARTITION = "RTEMS Partitions";
  public static final String OPTION_RTEMS_REGION    = "RTEMS Regions";
  public static final String OPTION_POSIX_THREAD    = "POSIX Threads";
  public static final String OPTION_POSIX_SEMAPHORE = "POSIX Semaphores";
  public static final String OPTION_POSIX_MUTEX     = "POSIX Mutexes";
  public static final String OPTION_POSIX_MSG_QUEUE = "POSIX Message Queues";
  public static final String OPTION_POSIX_KEY       = "POSIX Keys";
  public static final String OPTION_POSIX_INTERRUPT = "POSIX Interrupts";
  public static final String OPTION_POSIX_COND_VAR  = "POSIX Condition Variables";

  private JButton upGraph, centerGraph, downGraph;

  //
  // List of options to be presented on the "drop down box"
  //
  private String [] sel = {  
                    OPTION_NONE, 
                    OPTION_CPU, 
                    OPTION_MEMORY,         
                    OPTION_RTEMS_THREAD,    
                    OPTION_RTEMS_SEMAPHORE,
                    OPTION_RTEMS_MSG_QUEUE, 
                    OPTION_RTEMS_TIMER,     
                    OPTION_RTEMS_PARTITION, 
                    OPTION_RTEMS_REGION,    
                    OPTION_POSIX_THREAD,    
                    OPTION_POSIX_SEMAPHORE, 
                    OPTION_POSIX_MUTEX,     
                    OPTION_POSIX_MSG_QUEUE, 
                    OPTION_POSIX_KEY,       
                    OPTION_POSIX_INTERRUPT, 
                    OPTION_POSIX_COND_VAR 
                  };

  //
  // Provides the current selection....
  //
  public JComboBox combo;

  // 
  // Build the panel that this instance represents...
  //
  public CounterSelection() 
  {

      setFont(new Font("serif", Font.PLAIN, 8));

      JLabel l1 = new JLabel( "Select a Resource:" );

      GridBagLayout grid;
      GridBagConstraints c;

      upGraph     = new JButton( "Up" );
      centerGraph = new JButton( "Center" );
      downGraph   = new JButton( "Down" );

      upGraph.setActionCommand( UP_ACTION );
      centerGraph.setActionCommand( CENTER_ACTION );
      downGraph.setActionCommand( DOWN_ACTION );

      combo = new JComboBox( sel );

      setBorder( new TitledBorder(new EtchedBorder(), "Resources Utilization") );

      grid = new GridBagLayout(); 
      setLayout( grid ); 
      c = new GridBagConstraints();

      buildConstraints( c, 0, 0, 3, 1, 100, 20 );
      c.fill = GridBagConstraints.HORIZONTAL;
      c.anchor = GridBagConstraints.CENTER;
      grid.setConstraints( l1, c );
      add( l1 );

      buildConstraints( c, 0, 1, 3, 1, 100, 30 );
      c.fill = GridBagConstraints.HORIZONTAL;
      c.anchor = GridBagConstraints.CENTER;
      grid.setConstraints( combo, c );
      add( combo );

      buildConstraints( c, 0, 2, 1, 1, 33, 50 );
      c.fill = GridBagConstraints.HORIZONTAL;
      c.anchor = GridBagConstraints.NORTH;
      grid.setConstraints( upGraph, c );
      add( upGraph );


      buildConstraints( c, 1, 2, 1, 1, 33, 50 );
      c.fill = GridBagConstraints.HORIZONTAL;
      c.anchor = GridBagConstraints.NORTH;
      grid.setConstraints( centerGraph, c );
      add( centerGraph );


      buildConstraints( c, 2, 2, 1, 1, 33, 50 );
      c.fill = GridBagConstraints.HORIZONTAL;
      c.anchor = GridBagConstraints.NORTH;
      grid.setConstraints( downGraph, c );
      add( downGraph );
  }

  //
  // Registers a listener to recevie the actions whenever 
  // the buttons are pressed 
  //
  public void addListener( ActionListener a )
  {
    upGraph.addActionListener( a );
    centerGraph.addActionListener( a );
    downGraph.addActionListener( a );
  }


  private void buildConstraints( GridBagConstraints gbc, 
                         int gx, int gy, int gw, int gh, int wx, int wy )
  {
     gbc.gridx = gx;
     gbc.gridy = gy;
     gbc.gridwidth = gw;
     gbc.gridheight = gh;
     gbc.weightx = wx;
     gbc.weighty = wy;
  }

  //
  // Test driver for this class...
  //
  public static void main(String[] args) {
      JFrame frame = new JFrame("Counter Selection test driver." );
      frame.addWindowListener(new WindowAdapter() {
          public void windowClosing(WindowEvent e) {System.exit(0);}
      });

      frame.getContentPane().add(new CounterSelection(), 
                                 BorderLayout.CENTER);
      frame.setSize(300, 300);
      frame.setVisible(true);
  }
}
