/////////////////////////////////////////////////////////////////////////////
// $Header: d:/archive/cvs/master/callback/test/cb_tests.cpp,v 1.3 1999/11/14 17:41:24 rosimildo Exp $
//
// Copyright (c) 1999 - Rosimildo da Silva
//  
// MODULE DESCRIPTION:
// This module has examples of how to use the C++ callback framework.
//
// MODIFICATION/HISTORY:
//
// $Log: cb_tests.cpp,v $
// Revision 1.3  1999/11/14 17:41:24  rosimildo
// Changed location of the include file --- callback.h
//
// Revision 1.2  1999/11/14 17:13:56  rosimildo
// Added a few comments describing each step of the test.
//
//
/////////////////////////////////////////////////////////////////////////////


#include <stdio.h>

#include "../callback.h"


//
// This is a global C++ function to be used as a callback function.
//
int bar( int * p ) 
{ 
   printf( "global bar( %d )\n", ++(*p) ); 
   return 1; 
}


//
// This is a base class to be used with the callback examples...
//
class FooBase
{
public:
  FooBase()  { printf( "Ctor FooBase()\n" ); }
  ~FooBase() { printf( "Dtor FooBase()\n" ); }
  virtual int foo( int * p ) 
  { 
    printf( "foo base( %d )\n", ++(*p) ); 
    return 1; 
  }

  int bar( int * p ) 
  { 
    printf( "bar base( %d )\n", ++(*p) ); 
    return 1; 
  }

};


//
// This is a subclass to be used with the callback examples...
//
class FooSubclass : public FooBase
{
public:
  FooSubclass()  { printf( "Ctor FooSubclass()\n" ); }
  ~FooSubclass() { printf( "Dtor FooSubclass()\n" ); }
  virtual int foo( int * p ) 
  { 
    printf( "foo subclass( %d )\n", ++(*p) ); 
    return 1; 
  }
};

//
// Test driver for the C++ Callback framework...
//
int main()
{
  // 
  // Global function test...
  //
  FunctionCallback< int > f( bar );
  int x = 3;
  f.notify( &x ); 

  // 
  // Member function test... with a base class...
  //
  FooBase b;
  MemberCallback< int, FooBase > c( &FooBase::foo, &b );   
  c.notify( &x ); 

  // 
  // Member function test... with a subclass...
  //
  FooSubclass d;
  MemberCallback< int, FooSubclass > sub( &FooSubclass::foo, &d );   
  sub.notify( &x ); 

  //
  // Replacing method for this callback....
  //
  sub.setMember( &FooBase::bar, &d );
  sub.notify( &x ); 


  //
  // Cloning test...
  //
  Callback< int > *cb_copy = sub.clone();
  cb_copy->notify( &x ); 

  //
  // Multi-cast test...
  //
  CallbackContainer< int > cc;

  cc.add( &f );
  cc.add( &c );
  cc.add( &sub );
  cc.add( cb_copy );

  cc.notify( &x );

  printf( "Container size %d\n", cc.size() );

  cc.remove( &c );
  printf( "Container size %d\n", cc.size() );

  cc.remove( &f );
  printf( "Container size %d\n", cc.size() );

  cc.remove( &sub );
  printf( "Container size %d\n", cc.size() );

  // Copy needs to be deleted...
  delete cc.remove( cb_copy );
  printf( "Container size %d\n", cc.size() );

  return 0;
}

