/*
/////////////////////////////////////////////////////////////////////////////
// $Header: $
//
// Copyright (c) 1999 ConnectTel, Inc. All Rights Reserved.
//  
// MODULE DESCRIPTION:
//
//  RTEMS Init Task for a omniORB2 application that uses network functionality.
//
//  by: Rosimildo da Silva:
//      rdasilva@connecttel.com
//      http://www.connecttel.com
//
// MODIFICATION/HISTORY:
// $Log: $
//
/////////////////////////////////////////////////////////////////////////////
*/

#define  CONFIGURE_INIT
#include <stdio.h>
#include "rtemscfg.h"

#define RTEMS_INIT_WITH_NET 1

#if RTEMS_INIT_WITH_NET
#include "net_cfg.h"
#include <stdio.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#endif

/* Enable the following define if you want to debug this application */
/* #define USE_REMOTE_GDB__ */
#ifdef USE_REMOTE_GDB__
extern "C" void init_remote_gdb( void );
#define BREAKPOINT() asm("   int $3");
#endif

/* this is the command line options to be passed to the ORB */
char *cc_argv[] = 
{
	"rtems_main"       /* always the name of the program */
};
int cc_argc = sizeof( cc_argv ) / sizeof( cc_argv[ 0 ]  );


extern int rtems_main(int argc, char **argv);

/*
/////////////////////////////////////////////////////////////////////////////
// DESCRIPTION: Init task for any omniORB/RTEMS application that uses network.
/////////////////////////////////////////////////////////////////////////////
*/
void *POSIX_Init( void *argument )
{
  size_t st = 0;

#ifdef USE_REMOTE_GDB__
  init_remote_gdb();
  BREAKPOINT();
#endif

  printf( "\nStarting RTEMS init task...\n" );

#if RTEMS_INIT_WITH_NET
  /* Make all network initialization */
  rtems_bsdnet_initialize_network();
  printf( "Netowrk Initialization is complete.\n\n" );
#endif

  st = _Thread_Executing->Start.Initial_stack.size;
  printf( "Init Task Stack Size is: %d\n", st );

  rtems_main( cc_argc, cc_argv );
  printf( "*** Done ***\n\n\n" );
  pthread_exit( NULL );
  return NULL; /* just so the compiler thinks we returned something */
}
