/*  hostscfg
 *
 *  This module provides a routine to translate host's names for systems
 *  that does not have a "name server" available. 
 *  The current function, gethostbyname() seems to hang with configurations
 *  that does not have a NS.
 *
 *  by: Rosimildo da Silva:
 *      rdasilva@connecttel.com
 *      http://www.connecttel.com
 *
 */

#include <bsp.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <rtems/rtems_bsdnet.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>

/* local defines */
struct LocalHostsTable 
{
    char *addr;
    char *host_name;
};

struct LocalHostAddrPair
{
   long addr;
   char host_name[ 256 ];
};


struct LocalHostEntry
{
  char *h_name;
  char  *h_aliases[ 1 ];
  struct LocalHostAddrPair *l[ 2 ];
};

/*
 *  This is the table where you would add all entries for your
 *  embedded environment. 
 *  hosts names to their equilavents addresses.
 */
static struct LocalHostsTable localHostsTable[] =
{
  { "192.168.0.11", "lucila" },
  { "192.168.0.2",  "rps1" 	},
  { "192.168.0.1",  "gp" },
};
static const int sizeOfLocalHostTable = \
       sizeof( localHostsTable ) / sizeof( localHostsTable[ 0 ] );

static struct LocalHostAddrPair currentHostAddr =
{ 
   0x0,
   { '\0' }
};

static struct LocalHostEntry currentEntry = 
{
   "",
   { 0 },
   { &currentHostAddr, 0 }
};

static struct hostent current_hostent = 
{
   0,
   (char **)currentEntry.h_aliases, 
   AF_INET,
   sizeof( int ),
   ( char **)currentEntry.l
};



/*
 * this function is equivalent to gethostbyname(). It does uses a
 * table in memory to perform the conversion.
 */
struct hostent *gethostbyname( const char *name )
{
  int i;
  /* this is some sanity checking.... */
  if( !name )
  {
     return NULL;
  }
  /* search on the table for a matching name */
  for( i = 0; i < sizeOfLocalHostTable; i++ )
  {
    if( strcmp( name, localHostsTable[ i ].host_name ) == 0 )
	{
	   currentEntry.h_name = localHostsTable[ i ].host_name;
       current_hostent.h_name= localHostsTable[ i ].host_name;
       currentHostAddr.addr = inet_addr( localHostsTable[ i ].addr );
	   strcpy( currentHostAddr.host_name, currentEntry.h_name );
       return &current_hostent;
    }
  }
  return NULL;
}


/*
 * this function is equivalent to gethostbyaddr(). It does uses a
 * table in memory to perform the conversion.
 */
struct hostent *gethostbyaddr( const char *addr, int a1, int a2 )
{
  int i;
  /* this is some sanity checking.... */
  if( !addr )
  {
     return NULL;
  }
  /* search on the table for a matching name */
  for( i = 0; i < sizeOfLocalHostTable; i++ )
  {
    if( strcmp( addr, localHostsTable[ i ].addr ) == 0 )
	{
	   currentEntry.h_name = localHostsTable[ i ].host_name;
       current_hostent.h_name= localHostsTable[ i ].host_name;
       currentHostAddr.addr = inet_addr( localHostsTable[ i ].addr );
	   strcpy( currentHostAddr.host_name, currentEntry.h_name );
       return &current_hostent;
    }
  }
  return NULL;
}
