#///////////////////////////////////////////////////////////////////////////
# $Header: /usr/local/cvs-repository/ssf/tests/borland.mak,v 1.3 2001/01/20 21:02:46 rosimildo Exp $
#
# Copyright (c) 2000-2001 ConnectTel, Inc. All Rights Reserved.
#  
# The SSF library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.
#
# You should have received a copy of the GNU Library General Public
# License along with this library; if not, write to the Free
# Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
# 02111-1307, USA
#  
# This makefile is responsible for building the C++ library and
# examples for SSF.
#
# Important macros:
#
#    BCC_PATH:  Location of the Borland C++ compiler...
#
#    BCC_DEBUG: compile code with debug information.
#
# HISTORY:
#
# $Log: borland.mak,v $
# Revision 1.3  2001/01/20 21:02:46  rosimildo
# Added VC++ projects, and a simple GCC makefile to compile the
# system using CygWin. I do not have the client code for linux/cygwin
# to test the client at this point.
#
# Revision 1.2  2001/01/20 17:30:10  rosimildo
# Changes to add a test directory for the C++ code.
#
# Revision 1.1  2001/01/20 17:19:18  rosimildo
# Moved these files to a new test directory
#
#///////////////////////////////////////////////////////////////////////////
.AUTODEPEND

!ifndef  BCC_PATH 
BCC_PATH  = d:\bcc55
!endif

BCC       = $(BCC_PATH)\bin\bcc32
LIB       = $(BCC_PATH)\bin\tlib
LINK      = $(BCC_PATH)\bin\ilink32
IMPLIB    = $(BCC_PATH)\bin\implib

TOP=..

# Directories
SRCDIR   = .
INCDIR   = .;$(TOP)\src
LIBDIR   = $(TOP)\lib
OBJDIR   = obj
BINDIR   = $(TOP)\bin

!ifdef BCC_DEBUG
DBGCFLAGS= -v
DBGLFLAGS= -v
!else
DBGCFLAGS= -Os
!endif

CDEFS=-DWIN32

CFLAGS= -c $(DBGCFLAGS) -I$(INCDIR) -n$(OBJDIR) -tWM $(CDEFS)

LFLAGS= $(DBGLFLAGS) -L$(BCC_PATH)\lib -L$(LIBDIR)

TLFLAGS=/P256

TARGET_LIB =$(LIBDIR)\libssf.lib


STARTUP = c0x32.obj
LIBS    = libmysql+libssf+cw32mt+import32

TEST_OBJS = $(OBJDIR)\product.obj \
            $(OBJDIR)\ssf_test.obj

all: make_dirs $(BINDIR)\ssf_test.exe

$(BINDIR)\ssf_test.exe: $(TEST_OBJS) $(TARGET_LIB)
   -@copy $(TOP)\src\mysql\libmysql.dll $(BINDIR) 2>NUL
   $(IMPLIB) $(TOP)\lib\libmysql.lib $(TOP)\src\mysql\libmysql.dll
   $(LINK) $(LFLAGS) $(STARTUP) $(TEST_OBJS),$<,,$(LIBS),,;

clean:
   -rd  $(BINDIR) /s/q
   -rd  $(OBJDIR) /s/q

{$(SRCDIR)}.c{$(OBJDIR)}.obj:
    $(BCC) $(CFLAGS) $**

{$(SRCDIR)}.cpp{$(OBJDIR)}.obj:
    $(BCC) $(CFLAGS) $**

{$(SRCDIR)}.cc{$(OBJDIR)}.obj:
    $(BCC) -P $(CFLAGS) $**

make_dirs:
    -@mkdir $(BINDIR) 2>NUL
    -@mkdir $(OBJDIR) 2>NUL

