///////////////////////////////////////////////////////////////////////////
// $Header: /usr/local/cvs-repository/ssf/src/ssf_base.cpp,v 1.1 2001/01/20 21:02:46 rosimildo Exp $
//
// Copyright (c) 2000-2001 ConnectTel, Inc. All Rights Reserved.
// by: Rosimildo da Silva
//  
// The SSF library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
// 02111-1307, USA
//
//
//  
// DESCRIPTION: Generic base class implementation methods to cnnect
// to DB engines.
// 
// NOTE: This has been loosely based on the original work from:
//
// database.cc
// mysql C++ wrapper library
// 
// Author: Roland Haenel <rh@ginster.net>
// 
// This program is in the public domain.
// Distribute and use it freely.
//
// HISTORY:
//
// $Log: ssf_base.cpp,v $
// Revision 1.1  2001/01/20 21:02:46  rosimildo
// Added VC++ projects, and a simple GCC makefile to compile the
// system using CygWin. I do not have the client code for linux/cygwin
// to test the client at this point.
//
// Revision 1.1.1.1  2001/01/13 21:01:17  rosimildo
// Initial checkin for SSF
//
//
///////////////////////////////////////////////////////////////////////////

#include <stdarg.h>
#include <time.h>
#include <stdio.h>
#include <stdlib.h>

#include "ssf_base.h"

namespace ssf
{

/**
 * maximum size of the "formated" command 
 * FIXME: we could use snprintf() instead. 
 *
 */
#define  MAX_FORMATED_SQL_CMD    1024


// ------------------- ResultSet implementation ------------------
/**
 * get column value on current row as long
 */
long ResultSet::getLong( const char *name )
{
   const char *val = getString( name );
   long ret = 0;
   if( val )  ret = atol( val );
   return ret;
}

/**
 * get column value on current row as int
 */
int ResultSet::getInt( const char *name )
{
  return (int)getLong( name );
}

/**
 * get column value on current row as double
 */
double ResultSet::getDouble( const char *name )
{
   const char *val = getString( name );
   double ret = 0;
   if( val )  ret = atof( val );
   return ret;
}

/**
 * get column value on current row as float
 */
float ResultSet::getFloat( const char *name )
{
   return (float)getDouble( name );
}


/**
 * get column value on current row as long
 */
long ResultSet::getLong( int columnIndex )
{
   const char *val = getString( columnIndex );
   long ret = 0;
   if( val )  ret = atol( val );
   return ret;
}

/**
 * get column value on current row as int
 */
int ResultSet::getInt( int columnIndex )
{
  return (int)getLong( columnIndex );
}

/**
 * get column value on current row as double
 */
double ResultSet::getDouble( int columnIndex )
{
   const char *val = getString( columnIndex );
   double ret = 0;
   if( val )  ret = atof( val );
   return ret;
}

/**
 * get column value on current row as float
 */
float ResultSet::getFloat( int columnIndex )
{
   return (float)getDouble( columnIndex );
}


// ------------------- Connection implementation ------------------
/**
 * executes a command. The command is passed as a "printf" style.
 * NOTE: the max size of the SQL string cannot be larger than
 * the MAX_FORMATED_SQL_CMD, otherwise it blows the stack...
 */
ResultSet *Connection::executeQueryFormat(const char *sqlFormat, ...)
{
	va_list ap;
	char sqlCommand[ MAX_FORMATED_SQL_CMD ];
	va_start(ap, sqlFormat);
	vsprintf( sqlCommand, sqlFormat, ap );
	va_end( ap );
	return executeQuery( sqlCommand );
}


/**
 * executes a command. The command is passed as a "printf" style.
 * NOTE: the max size of the SQL string cannot be larger than
 * the MAX_FORMATED_SQL_CMD, otherwise it blows the stack...
 */
UINT64 Connection::executeUpdateFormat(const char *sqlFormat, ... )
{
	va_list ap;
	char sqlCommand[ MAX_FORMATED_SQL_CMD ];
	va_start(ap, sqlFormat);
	vsprintf( sqlCommand, sqlFormat, ap );
	va_end( ap );
	return executeUpdate( sqlCommand );
}

}
