dnl
dnl $Id: mrb.m4,v 1.25 2005/07/06 04:57:45 cjohns Exp $
dnl
dnl ------------------------------------------------------------------------
dnl
dnl My Right Boot, a boot ROM for embedded hardware.
dnl
dnl ------------------------------------------------------------------------
dnl
dnl Copyright (c) 2002, Cybertec Pty Ltd.
dnl All rights reserved.
dnl 
dnl                       LICENSE INFORMATION
dnl
dnl My Right Boot is free software; you can redistribute it and/or modify it 
dnl under terms of the GNU General Public License as published by the Free 
dnl Software Foundation; either version 2, or (at your option) any later
dnl version.  
dnl
dnl My Right Boot is distributed in the hope that it will be useful, but
dnl WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
dnl or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
dnl for more details. You should have received a copy of the GNU General 
dnl Public License along with My Right Boot; see file COPYING. If not, write
dnl to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
dnl
dnl As a special exception, including a My Right Boot header files in a file,
dnl instantiating My Right Boot generics or templates, or linking other files
dnl with My Right Boot objects to produce an executable application, does not
dnl by itself cause the resulting executable application to be covered by the
dnl GNU General Public License. This exception does not however invalidate any
dnl other reasons why the executable file might be covered by the GNU Public
dnl License.
dnl
dnl The Cybertec copyright and license notice must remain in this file and any
dnl derived file.
dnl
dnl ------------------------------------------------------------------------
dnl
dnl MRB_CONFIG_BOARD(BOARD)
dnl

AC_DEFUN([MRB_CONFIG_BOARD],
[
  CT_BOARD_MAKEFILE([$1],
    [
     dnl
     dnl MRB uses DEBUG to control some code paths when
     dnl debugging software.
     dnl
     AS_IF([test x$debug = xtrue], 
           [MRB_CFG_CFLAGS="$MRB_CFG_CFLAGS -DDEBUG=1"
            MRB_CFG_CXXFLAGS="$MRB_CFG_CXXFLAGS -DDEBUG=1"
            MRB_CFG_ASFLAGS="$MRB_CFG_ASFLAGS -DDEBUG=1"])
    
     AC_SUBST(MRB_CFG_CPU_FAMILY)
     AC_SUBST(MRB_CFG_CPU)
     AC_SUBST(MRB_CFG_SUBDIRS)
     AC_SUBST(MRB_CFG_CFLAGS)
     AC_SUBST(MRB_CFG_CXXFLAGS)
     AC_SUBST(MRB_CFG_ASFLAGS)
     AC_SUBST(MRB_CFG_LDFLAGS)
     AC_SUBST(MRB_CFG_LINKCMDS)
     AC_SUBST(MRB_CFG_LINKCMDS_DEBUG)
     AC_SUBST(MRB_CFG_SRECFLAGS)
     AC_SUBST(MRB_CFG_RCT_SIZE)
     AC_SUBST(MRB_CFG_RAM_BASE)
     AC_SUBST(MRB_CFG_RAM_SIZE)
     AC_SUBST(MRB_CFG_ROM_BASE)
     AC_SUBST(MRB_CFG_ROM_SIZE)
     AC_SUBST(MRB_CFG_ROM_DEVICE_SIZE)
     AC_SUBST(MRB_CFG_LOAD_AT)
    
     AM_CONDITIONAL(ZLIB, [test x$MRB_OPT_ZLIB = xyes])
     AM_CONDITIONAL(ZIP7, [test x$MRB_OPT_ZIP7 = xyes])

     AM_CONDITIONAL(CF, [test x$MRB_CFG_CPU_FAMILY = xcf])
     AM_CONDITIONAL(CF_5206E, [test x$MRB_CFG_CPU = x5206e])
     AM_CONDITIONAL(CF_5272,  [test x$MRB_CFG_CPU = x5272])

     AM_CONDITIONAL(LCD, [test x$MRB_OPT_LCD = xyes])

     AM_CONDITIONAL(M683XX, [test x$MRB_CFG_CPU_FAMILY = xm683xx])
     AM_CONDITIONAL(M68360, [test x$MRB_CFG_CPU = x68360])

     AM_CONDITIONAL(SERIAL,        [test x$MRB_OPT_SERIAL = xyes])
     AM_CONDITIONAL(SC26C92,       [test x$MRB_OPT_SC26C92 = xyes])
     AM_CONDITIONAL(M68360_SERIAL, [test x$MRB_OPT_SERIAL_M68360 = xyes])
    
     AM_CONDITIONAL(SPLIT_BOOT, [test x$MRB_OPT_SPLIT_BOOT = xyes])

     AM_CONDITIONAL(TIMER, [test x$MRB_OPT_TIMER = xyes])
    
     AM_CONDITIONAL(NET,        [test x$MRB_OPT_NET = xyes])
     AM_CONDITIONAL(NET_MII,    [test x$MRB_OPT_NET_MII = xyes])
     AM_CONDITIONAL(CS8900,     [test x$MRB_OPT_NET_CS8900 = xyes])
     AM_CONDITIONAL(NS8390,     [test x$MRB_OPT_NET_NS8390 = xyes])
     AM_CONDITIONAL(MOT_FEC,    [test x$MRB_OPT_MOT_FEC = xyes])
     AM_CONDITIONAL(M68360_NET, [test x$MRB_OPT_NET_M68360 = xyes])
     
     AM_CONDITIONAL(AMD29F400, [test x$MRB_OPT_FLASH_AMD29F400 = xyes])
     AM_CONDITIONAL(AT29C020,  [test x$MRB_OPT_FLASH_AT29C020 = xyes])
     AM_CONDITIONAL(M29W160,   [test x$MRB_OPT_FLASH_M29W160 = xyes])

     AM_CONDITIONAL(MOT_QSPI, [test x$MRB_OPT_MOT_QSPI = xyes])
     AM_CONDITIONAL(MOT_USB,  [test x$MRB_OPT_MOT_USB = xyes])
   ])
])

dnl
dnl MRB_ADD_ON
dnl
AC_DEFUN([MRB_ADD_ON],
[
  AM_CONDITIONAL(ADD_ON, [test -d ${srcdir}/$1add-on])

  MRB_ADD_ON_LIBS=
  MRB_ADD_ON_OBJS=

  AS_IF([test -d ${srcdir}/$1add-on/remote],
         MRB_ADD_ON_LIBS="$1add-on/remote/libremote.a $MRB_ADD_ON_LIBS"
         MAO_REMOTE=true,
         MAO_REMOTE=false)
  AS_IF([test -d ${srcdir}/$1add-on/fs],
         MRB_ADD_ON_LIBS="$1add-on/fs/libfs.a $MRB_ADD_ON_LIBS"
         MAO_FS=true,
         MAO_FS=false)
  AS_IF([test -d ${srcdir}/$1add-on/mot-qspi],
         MRB_ADD_ON_LIBS="$1add-on/mot-qspi/libmot-qspi.a $MRB_ADD_ON_LIBS"
         MAO_QSPI=true,
         MOA_QSPI=false)
  AS_IF([test -d ${srcdir}/$1add-on/cybertec],
         MRB_ADD_ON_LIBS="$1add-on/cybertec/libcybertec.a $MRB_ADD_ON_LIBS"
         MRB_ADD_ON_OBJS="$1add-on/cybertec/cybertec.o $MRB_ADD_ON_OBJS"
         MAO_CYBERTEC=true,
         MOA_CYBERTEC=false)

  AM_CONDITIONAL(MAO_REMOTE, [test x$MAO_REMOTE = xtrue])
  AM_CONDITIONAL(MAO_FS, [test x$MAO_FS = xtrue])
  AM_CONDITIONAL(MAO_QSPI, [test x$MAO_QSPI = xtrue])
  AM_CONDITIONAL(MAO_CYBERTEC, [test x$MAO_CYBERTEC = xtrue])

  AC_SUBST(MRB_ADD_ON_LIBS)
  AC_SUBST(MRB_ADD_ON_OBJS)
])
