#include <rtems.h>

/* functions */

rtems_task Init(
  rtems_task_argument argument
);

int simhost_main(int argc, char **arg);
rtems_task simhost_init_task(rtems_task_argument unused);

/* configuration information */

#include <bsp.h> /* for device driver prototypes */

#define CONFIGURE_INIT
#define CONFIGURE_APPLICATION_NEEDS_CONSOLE_DRIVER
#define CONFIGURE_APPLICATION_NEEDS_CLOCK_DRIVER

#define CONFIGURE_APPLICATION_NEEDS_TIMER_DRIVER

#define CONFIGURE_MICROSECONDS_PER_TICK 1000 /* 1 millisecond */
#define CONFIGURE_TICKS_PER_TIMESLICE 20     /* 20 milliseconds */

#define CONFIGURE_MAXIMUM_TASKS             12
#define CONFIGURE_MAXIMUM_TIMERS            8
#define CONFIGURE_MAXIMUM_SEMAPHORES        32
#define CONFIGURE_MAXIMUM_MESSAGE_QUEUES    16 /* for each connection 2 message queues */

#define CONFIGURE_RTEMS_INIT_TASKS_TABLE

#define CONFIGURE_EXTRA_TASK_STACKS         (12 * RTEMS_MINIMUM_STACK_SIZE)

#include <confdefs.h>

#include <stdio.h>
#include <assert.h>

rtems_task Init(rtems_task_argument argument)
{
  rtems_status_code statusCode;

  printf("\n*** START ***\n");
  fflush(stdout);

  simhost_main(0, (char**)NULL);

  printf("*** END ***\n");
  fflush(stdout);

/*
  statusCode = rtems_task_suspend(RTEMS_SELF);
  assert(statusCode == RTEMS_SUCCESSFUL);
 */

  /* there is nothing left to do for this thread */
  statusCode = rtems_task_delete(RTEMS_SELF);
  assert(statusCode == RTEMS_SUCCESSFUL);
}
