#!/bin/sh
# wrapper script to strip CC=xxx host_alias=yyy etc. 
# which the binutils configure script doesn't seem to grok :=(
script=$0

hostoption=
crossconfig=
newliboption=

while :
do

# Break out if there are no more args
	case $# in
	0)
		break
		;;
	esac

# Get the first arg, and shuffle
	option=$1
	shift
	optarg=`expr "x$option" : 'x[^=]*=\(.*\)'`

# Make all options have two hyphens
# Check for *-x sourcedir, which means that
# we do a cross configuration; have to strip the 'host' option
#
	orig_option=$option	# Save original for error messages
	case $option in
	--srcdir=*-x)
		crossconfig=yes
	;;
	--host=*)
		hostoption="$optarg"
		option=
	;;
	--*) ;;
	-*) option=-$option
	;;
	host_alias=*rtems*)
		newliboption=--with-newlib
		args="$args --with-target-subdir"
		option=
	;;
	*)
		option=
	;;
	esac

	args="$args $option"
		
done

if [ "$crossconfig" = "yes" ] ; then
	newliboption=
	hostprefix=--target
else
	hostprefix=--host
fi

if [ "$hostoption"X != "X" ] ; then
	hostoption="$hostprefix=$hostoption"
fi

args="$args --disable-nls $hostoption $newliboption"

echo running /bin/sh `dirname $script`/configure $args
/bin/sh `dirname $script`/configure $args
