///////////////////////////////////////////////////////////////////////////
// $Header: $
//
// Copyright (c) 2000-2001 ConnectTel, Inc. All Rights Reserved.
// by: Rosimildo da Silva
//
// The SSF library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
// 02111-1307, USA
//
//
//  
// DESCRIPTION: Framework to map classes to relational database tables.
//
// HISTORY:
//
// $Log: $
//
///////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <stdlib.h>

#include "storable.h"

namespace ssf
{

/** 
 * Adds a new "row" to DB.
 */
bool Storable::addNewRow( Connection *c )
{
   std::string s;
   s = std::string( "INSERT INTO " ) + getTableName();
   const char *fields = getColumnListForInsert();
   const char *values = getInsertValues();
   if( fields )
   {
      s += std::string( " (" ) + fields + std::string( ")" );
   }
   s += std::string( " VALUES(" ) + values + std::string( ")" );
   UINT64  n = c->executeUpdate( s.c_str() );
//   printf( "Insert = %s, rows=%d\n",  s.c_str(), n );
   if( c->success() )
   {
     setPKAfterInsert( c );
//     printf( "Insert new ID is =%d \n",  getUniqueId() );
     return true;
   }
   else
   {
     printf( "ERROR:  Insert = %s, rows=%d\n",  c->errorDescription(), n );
   }
   return false;
}


/** 
 * refreshes instance data from DB.
 * It requires the PK for the instance to be valid.
 */
bool Storable::queryRow( Connection *c )
{
    std::string s;
    const char *fields = getColumnList();
    s = std::string( "SELECT " ) + fields + std::string(" FROM ") + getTableName();
    const char *where = getWhereClause();
	 if( where )
	 {
	   s += std::string(" WHERE ") + where;
	 }
    ResultSet *res = c->executeQuery( s.c_str() );
    if( res && c->success() )
    { 
      res->reset();
      if( res->next() )
      {
         mapping( res );
      }
    }
    delete res;
    return c->success();
}


/** 
 * updates the instance values into the DB.
 */
bool Storable::updateRow( Connection *c )
{
    std::string s;
    const char *fields = getUpdateValues();
    s = std::string( "UPDATE " ) + getTableName() + std::string(" SET ") + fields;
    const char *where = getWhereClause();
	 if( where  )
	 {
	   s += std::string(" WHERE " ) + where;
	 }
    UINT64  n = c->executeUpdate( s.c_str() );
//    printf( "Update = %s, rows=%d\n",  s.c_str(), n );
    return c->success() ? true : false;
}

/** 
 * deletes permanently the instance info from the DB.
 */
bool Storable::deleteRow( Connection *c )
{
    std::string s;
    s = std::string("DELETE FROM ") + getTableName();
    const char *where = getWhereClause();
	 if( where )
	 {
	   s += std::string(" WHERE ") + where;
	 }

    UINT64  n = c->executeUpdate( s.c_str() );
//    printf( "Delete = %s, rows=%d\n",  s.c_str(), n );
    return c->success() ? true : false;
}


} // namespace

