#ifndef __ssf_mysql_h__
#define __ssf_mysql_h__

///////////////////////////////////////////////////////////////////////////
// $Header: $
//
// Copyright (c) 2000-2001 ConnectTel, Inc. All Rights Reserved.
// by: Rosimildo da Silva
//  
// DESCRIPTION: C++ Wrapper to talk to a MySQL database.
//
// NOTE: This has been loosely based on the original work from:
// database.cc
// mysql C++ wrapper library
// 
// Author: Roland Haenel <rh@ginster.net>
// This program is in the public domain.
// Distribute and use it freely.
//
// HISTORY:
//
// $Log: makefile.mak,v $
//
///////////////////////////////////////////////////////////////////////////


#include "ssf_base.h"
#include "mysql.h"

namespace ssf
{

/**
 * Keeps the result of a command executed on a Connection instance.
 */
class MySQLResultSet : public ResultSet 
{
private:
	MYSQL_RES *result;
public:
   MySQLResultSet( MYSQL_RES *res );
	~MySQLResultSet();

	int getRows();			// Number of fetched rows...
	int getColumns();		// Number of columns per row...

	char *getColumnName(int n);		// Name of nth column
	int   getColumnIndex(const char *name);

	int   getColumnSize(int n);            // Size of nth column
	int   getColumnSize(const char *name);	// Size of nth column by name

	 // Sets internal cursor to row
	bool seekRow( int row ); 

   // iterator -- scans through all rows in the set...
   void reset();
   // go to the next row...
   bool next();

   // access members...
   const char *getString( const char *name );
   const char *getString( int columnIndex );
   // TODO: more access members for Date, TimeStamp...

private:
	char **getTuple();              // Return the next tuple or NULL
	char **getTuple(int tuple);	  // Return tuple

   MYSQL_FIELD *getFieldByIndex( int n );
   MYSQL_FIELD *getFieldByName( const char *name );

   bool reset_called;
	char **cur_tuple;
};


/**
 * Class Wrapper to talk to a MySQL Database. It tries to 
 * resembles some of the JDBC Connection class, but not that
 * much yet....
 */
class MySQLConnection : public Connection
{
public:

	MySQLConnection();
	~MySQLConnection();

	virtual const char *errorDescription( int err ) const;
	virtual bool  connect(const char *url, const char *user, const char *passwd );
	virtual void disconnect();

   virtual UINT64 idAfterInsert();

	virtual ResultSet *executeQuery(const char *sqlStatement ); 
	virtual UINT64 executeUpdate(const char *sqlStatement );

private:
	MYSQL mysql;
	bool connected;
	char error[ 100 ];  // Error description

   MYSQL_RES *execute( const char *sqlQuery, bool & haveError );

};

};

#endif // __ssf_mysql_h__

