/////////////////////////////////////////////////////////////////////////////
// $Header: $
//
// Copyright (c) 2000 ConnectTel, Inc. All Rights Reserved.
//  
// MODULE DESCRIPTION:
// Test program for the C++ resource monitoring utility classes.
// This test program does not use any CORBA stuff. It is a normal
// RTEMS application to show the usage of the classes.
//
// MODIFICATION/HISTORY:
//
// $Log: $
//
/////////////////////////////////////////////////////////////////////////////


#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <string.h>

// RTEMS includes...
#include <bsp.h>
#include <rtems.h>
#include <rtems/posix/mutex.h>
#include <rtems/rtems/config.h>
#include <rtems/posix/semaphore.h>
#include <rtems/posix/cond.h>
#include <rtems/posix/key.h>

#include "resources.h"
#include "omnithread.h"


/////////////////////////////////////////////////////////////////////////////
// DESCRIPTION: A thread class based on the omni framework 
/////////////////////////////////////////////////////////////////////////////
class RpsThread : public omni_thread 
{
public:
    RpsThread() : omni_thread() { }

private:
    void run(void* arg);
};

void RpsThread::run( void *arg )
{
  rtems_id id = _Thread_Executing->Object.id;

  printf( "Thread starting = %X\n", id );
  while( 1 )
  {
      sleep( 10, 100000 );
  }
}


int main(int argc, char **argv)
{
   fprintf(stdout, "Corba test starting.\n" ); 
   bool rc;

   RpsThread t1;
   RpsThread t2;
   RpsThread t3;

   t3.start();
   t2.start();
   t1.start();

   util::u32 mx;
   util::u32 use;

   printf( "\nCounters for the RTEMS API Resources:\n\n" ); 
   util::RtemsThread::getCounters( mx, use );
   printf( "RTEMS Threads --> Maximum=%d, Inuse=%d\n", mx, use ); 

   util::RtemsSemaphore::getCounters( mx, use );
   printf( "RTEMS Semaphores --> Maximum=%d, Inuse=%d\n", mx, use ); 

   util::RtemsTimer::getCounters( mx, use );
   printf( "RTEMS Timers --> Maximum=%d, Inuse=%d\n", mx, use ); 

   util::RtemsMessageQueue::getCounters( mx, use );
   printf( "RTEMS Message Queue --> Maximum=%d, Inuse=%d\n", mx, use ); 

   util::RtemsPartition::getCounters( mx, use );
   printf( "RTEMS Partition --> Maximum=%d, Inuse=%d\n", mx, use ); 

   util::RtemsRegion::getCounters( mx, use );
   printf( "RTEMS Region --> Maximum=%d, Inuse=%d\n", mx, use ); 

   util::PosixThread::getCounters( mx, use );
   printf( "POSIX Thread --> Maximum=%d, Inuse=%d\n", mx, use ); 

   util::PosixMutex::getCounters( mx, use );
   printf( "POSIX Mutex --> Maximum=%d, Inuse=%d\n", mx, use ); 

   util::PosixKey::getCounters( mx, use );
   printf( "POSIX Key --> Maximum=%d, Inuse=%d\n", mx, use ); 

   util::PosixCondVariable::getCounters( mx, use );
   printf( "POSIX Cond Variable --> Maximum=%d, Inuse=%d\n", mx, use ); 

   util::PosixSemaphore::getCounters( mx, use );
   printf( "POSIX Semaphore --> Maximum=%d, Inuse=%d\n", mx, use ); 

   util::ResourcePtrList  list;
   util::ResourceIterator i;
   while( 1 )
   {
     rtems_task_wake_after( 1000 );
     util::RtemsThread::getInstances( list );
     util::PosixThread::getInstances( list );
     printf( "================ ALL TASKS ===========================================\n" ); 
     printf( "   ID    NAME  BASE_PRIO CUR_PRIO STATE     WAIT_ID  STACK_SIZE EVENTS\n" ); 
     for( i = list.begin(); i != list.end(); ++i )
     {
         const util::RtemsThread & t = *(( util::RtemsThread *)(*i));
         printf( "%08lX %4.4s    %04X     %04X    %08lX  %08lX %08lX   %08lX\n",
                 t.id(), t.name(), t.basePriority(), t.currentPriority(), 
                 t.state(), t.waitId(), t.stackSize(),  t.eventsPending() );
         delete *i;
     }
     printf( "\n\n" ); 
     list.clear();

     rtems_task_wake_after( 1000 );
     util::RtemsSemaphore::getInstances( list );
     printf( "=============== RTEMS SEMAPHORES ====================================\n" ); 
     printf( "   ID    NAME ATTRIBUTES COUNT\n" ); 
     for( i = list.begin(); i != list.end(); ++i )
     {
       const util::RtemsSemaphore & r = *(( util::RtemsSemaphore *)(*i));
       printf( "%08lX %4.4s %08lX   %08lX\n",
               r.id(), r.name(), r.attributes(), r.count() );
       delete *i;
     }
     printf( "\n\n" ); 
     list.clear();


     util::RtemsRegion::getInstances( list );
     printf( "=============== RTEMS REGIONS =======================================\n" ); 
     printf( "   ID    NAME ATTRIBUTES ADDRESS  LENGTH    PAGE_SIZE SEG_SIZE BLOCKS\n" ); 
     for( i = list.begin(); i != list.end(); ++i )
     {
       const util::RtemsRegion & r = *(( util::RtemsRegion *)(*i));
       printf( "%08lX %4.4s %08X   %08X %08lX  %08lX  %08lX %08lX\n",
               r.id(), r.name(), r.attributes(), r.startingAddress(), r.length(), 
               r.pageSize(), r.maxSegSize(),  r.usedBlocks() );
       delete *i;
     }
     printf( "\n\n" ); 
     list.clear();


     rtems_task_wake_after( 1000 );
     util::PosixKey::getInstances( list );
     printf( "   ID      IS_ACTIVE\n" ); 
     for( i = list.begin(); i != list.end(); ++i )
     {
       const util::PosixKey & r = *(( util::PosixKey *)(*i));
       printf( "%08lX    %08lX\n", r.id(), r.isActive() );
       delete *i;
     }
     printf( "\n\n" ); 
     list.clear();

     rtems_task_wake_after( 1000 );
     util::PosixCondVariable::getInstances( list );
     printf( "=============== POSIX CONDITION VARIABLES ===========================\n" ); 
     printf( "   ID      MUTEX_ID\n" ); 
     for( i = list.begin(); i != list.end(); ++i )
     {
       const util::PosixCondVariable & r = *(( util::PosixCondVariable *)(*i));
       printf( "%08lX    %08lX\n", r.id(), r.mutexId() );
       delete *i;
     }
     printf( "\n\n" ); 
     list.clear();

     rtems_task_wake_after( 1000 );
     util::PosixMutex::getInstances( list );
     printf( "=============== POSIX MUTEXES ===================================\n" ); 
     printf( "   ID     HOLDER_ID  LOCK       NEST_COUNT\n" ); 
     for( i = list.begin(); i != list.end(); ++i )
     {
       const util::PosixMutex & r = *(( util::PosixMutex *)(*i));
       printf( "%08lX  %08lX   %08lX   %08lX\n",
               r.id(), r.holderId(), r.isLocked(), r.nestCount() );
       delete *i;
     }
     printf( "\n\n" ); 
     list.clear();

   }

   fprintf(stdout, "About to leave main()\n" ); 
   return 0;
}
