#///////////////////////////////////////////////////////////////////////////
# $Header: /usr/local/cvs-repository/ssf/java/borland.mak,v 1.1.1.1 2001/01/13 21:01:17 rosimildo Exp $
#
# Copyright (c) 2000-2001 ConnectTel, Inc. All Rights Reserved.
#by: Rosimildo daSilva
#  
# The SSF library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.
#
# You should have received a copy of the GNU Library General Public
# License along with this library; if not, write to the Free
# Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
# 02111-1307, USA
#
#
# MODULE DESCRIPTION: 
# This makefile is responsible for building the java files for SSF.
#
# MODIFICATION/HISTORY:
#
# $Log: borland.mak,v $
# Revision 1.1.1.1  2001/01/13 21:01:17  rosimildo
# Initial checkin for SSF
#
#
#///////////////////////////////////////////////////////////////////////////

.SUFFIXES: .java .class

TOP=..

CLASS_PATH   = .;$(TOP)\java\mysql\mysql.jar
JAVAC        = javac
JAVA         = java
JAVACOPTS    = -classpath $(CLASS_PATH)
BINDIR       = .
JAR          = jar

SSF_PACKAGE=ssf
SSF_JAR = $(TOP)\java\ssf.jar

{.}.java{$(SSF_PACKAGE)}.class:
    $(JAVAC) $(JAVACOPTS) -d . *.java

SSF_FILES= \
       $(SSF_PACKAGE)\Storable.class                \
       $(SSF_PACKAGE)\StorableFactory.class         \


refresh:  mk_dirs $(SSF_FILES) $(SSF_JAR)

build:  clean refresh

clean:
    -del $(SSF_JAR)          2>NUL
    -rd  $(SSF_PACKAGE) /s/q 2>NUL
    -del Product.class       2>NUL


$(SSF_JAR): $(SSF_FILES)
	echo Creating ssf.jar package...
	$(JAR) cf $(SSF_JAR) ssf\*.class

mk_dirs: 
	-md ssf     2>NUL


test: $(SSF_JAR)
    $(JAVAC) $(JAVACOPTS);$(SSF_JAR) -d . Product.java
    $(JAVA)  $(JAVACOPTS);$(SSF_JAR) Product
