#!/bin/sh -x

python=$1
prefix=$2

CFLAGS="-I ${prefix}/m68k-rtems/include/python2.4 \
        -I ${prefix}/m68k-rtems/lib/include \
        -I ${prefix}/include/mrb \
        -g -m5200 -pipe -O3 -Wall -Winline"
LDFLAGS="-g -m5200 -pipe -O3 -Wall \
        -B${prefix}/lib/mrb/ -specs microcore-specs -qrtems"

m68k-rtems-gcc ${CFLAGS} -c example.c
m68k-rtems-gcc ${CFLAGS} -c config.c
m68k-rtems-gcc ${CFLAGS} -c untar.c

${python} pycall.py

tar --exclude \*.py --exclude \*~ --exclude \*.pyo -cf python_pyc.tar python
m68k-rtems-ld -r -o python-pyc.o -b binary python_pyc.tar

m68k-rtems-gcc ${LDFLAGS} -o example example.o python-pyc.o config.o untar.o -lpython2.4 -lm
m68k-rtems-size example
m68k-rtems-objcopy --output-target=binary example example.bin
gzip -c -fv --best example.bin > example.bin.gz
