#///////////////////////////////////////////////////////////////////////////
# $Header: /usr/local/cvs-repository/ssf/src/gcc.mak,v 1.1 2001/01/20 21:02:46 rosimildo Exp $
#
# Copyright (c) 2000-2001 ConnectTel, Inc. All Rights Reserved.
#  
# The SSF library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.
#
# You should have received a copy of the GNU Library General Public
# License along with this library; if not, write to the Free
# Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
# 02111-1307, USA
#  
# This makefile is responsible for building the C++ library for SSF
# using GCC.
#
# HISTORY:
#
# $Log: gcc.mak,v $
# Revision 1.1  2001/01/20 21:02:46  rosimildo
# Added VC++ projects, and a simple GCC makefile to compile the
# system using CygWin. I do not have the client code for linux/cygwin
# to test the client at this point.
#
#
#///////////////////////////////////////////////////////////////////////////
TOP=..

CPP_SRCS = ssf_base.cpp ssf_mysql.cpp ssf_factory.cpp storable.cpp

C_SRCS = xmlmemory.c uri.c

TARGET_LIB=obj/libssf.a

CFLAGS   =
CXXFLAGS = $(CFLAGS)

ARFLAGS       = rcs
RANLIB=ranlib
AR=ar
CC=gcc
CXX=g++

all: $(TARGET_LIB)

OBJFILES = $(patsubst %.c,obj/%.o,$(C_SRCS))

OBJFILES += $(patsubst %.cpp,obj/%.o,$(CPP_SRCS))

vpath	%.c	$(TOP)/src/ $(TOP)/src/mysql/ $(TOP)/src/libxml/

vpath	%.cpp	$(TOP)/src/ $(TOP)/src/mysql/ $(TOP)/src/libxml/

INCLUDES = -I$(TOP)/src -I$(TOP)/src/mysql -I$(TOP)/src/libxml/include

$(TARGET_LIB): obj/ $(OBJFILES)
	$(AR) $(ARFLAGS) $(TARGET_LIB) $(OBJFILES)
	$(RANLIB) $(TARGET_LIB)

clean: 
	rm -rf obj*  $(TARGET_LIB)

obj/%.o: %.c
	@echo "... $@"
	@$(CC) $(EXTRACFLAGS) $(CFLAGS) $(INCLUDES) -c -o $@ $<

obj/%.o: %.cpp
	@echo "... $@"
	@$(CXX) $(EXTRACFLAGS) $(CXXFLAGS) $(INCLUDES) -c -o $@ $<

obj/:
	mkdir -p $@

