#///////////////////////////////////////////////////////////////////////////
# $Header: /usr/local/cvs-repository/ssf/src/borland.mak,v 1.2 2001/01/20 17:30:10 rosimildo Exp $
#
# Copyright (c) 2000-2001 ConnectTel, Inc. All Rights Reserved.
#  
# The SSF library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.
#
# You should have received a copy of the GNU Library General Public
# License along with this library; if not, write to the Free
# Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
# 02111-1307, USA
#  
# This makefile is responsible for building the C++ library and
# examples for SSF.
#
# Important macros:
#
#    BCC_PATH:  Location of the Borland C++ compiler...
#
#    BCC_DEBUG: compile code with debug information.
#
# HISTORY:
#
# $Log: borland.mak,v $
# Revision 1.2  2001/01/20 17:30:10  rosimildo
# Changes to add a test directory for the C++ code.
#
# Revision 1.1.1.1  2001/01/13 21:01:17  rosimildo
# Initial checkin for SSF
#
#
#///////////////////////////////////////////////////////////////////////////
.AUTODEPEND

!ifndef  BCC_PATH 
BCC_PATH  = d:\bcc55
!endif

BCC       = $(BCC_PATH)\bin\bcc32
LIB       = $(BCC_PATH)\bin\tlib
LINK      = $(BCC_PATH)\bin\ilink32

TOP=..

# Directories
SRCDIR   = .;libxml;mysql
INCDIR   = .;$(TOP)\src\libxml\include;$(TOP)\src\mysql
LIBDIR   = $(TOP)\lib
OBJDIR   = obj
BINDIR   = $(TOP)\bin

!ifdef BCC_DEBUG
DBGCFLAGS= -v
DBGLFLAGS= -v
!else
DBGCFLAGS= -Os
!endif

CDEFS=-DWIN32

CFLAGS= -c $(DBGCFLAGS) -I$(INCDIR) -n$(OBJDIR) -tWM $(CDEFS)

LFLAGS= $(DBGLFLAGS) -L$(BCC_PATH)\lib;$(TOP)\src\mysql -L$(LIBDIR)

TLFLAGS=/P256

TARGET_LIB =$(LIBDIR)\libssf.lib


STARTUP = c0x32.obj
LIBS    = libmysql+libssf+cw32mt+import32

OBJS = $(OBJDIR)\ssf_base.obj \
       $(OBJDIR)\ssf_mysql.obj \
       $(OBJDIR)\ssf_factory.obj \
       $(OBJDIR)\storable.obj \
       $(OBJDIR)\xmlmemory.obj \
       $(OBJDIR)\uri.obj

all: make_dirs $(TARGET_LIB)

clean:
   -rd  $(LIBDIR) /s/q
   -rd  $(OBJDIR) /s/q

$(TARGET_LIB): $(OBJS)
    -del $(TARGET_LIB)
	&$(LIB) $(TLFLAGS) $< {-+$? }

{$(SRCDIR)}.c{$(OBJDIR)}.obj:
    $(BCC) $(CFLAGS) $**

{$(SRCDIR)}.cpp{$(OBJDIR)}.obj:
    $(BCC) $(CFLAGS) $**

{$(SRCDIR)}.cc{$(OBJDIR)}.obj:
    $(BCC) -P $(CFLAGS) $**

make_dirs:
    -@mkdir $(LIBDIR) 2>NUL
    -@mkdir $(OBJDIR) 2>NUL

