/////////////////////////////////////////////////////////////////////////////
// $Header: /usr/local/cvs-repository/ssf/java/Product.java,v 1.1.1.1 2001/01/13 21:01:17 rosimildo Exp $
//
// Copyright (c) 2000-2001 ConnectTel, Inc. All Rights Reserved.
//
// The SSF library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
// 02111-1307, USA
//
//
//  
// MODULE DESCRIPTION: Sample of the SSF project.
//
// MODIFICATION/HISTORY:
//
// $Log: Product.java,v $
// Revision 1.1.1.1  2001/01/13 21:01:17  rosimildo
// Initial checkin for SSF
//
//
/////////////////////////////////////////////////////////////////////////////


import java.sql.*;
import java.util.*;
import java.lang.*;


/**
 * This class maps the Product of the SSF project.
 */
public class Product extends ssf.Storable
{

   public static final String TABLE_NAME = "Product";

   // access members - we might want to put pairs of get/set accessors
   public int   id      = 0;
   public String name   = null;
   public float  price  = 0.0f;
   public int qty       = 0;

   /**
    * Creates one instance that is not mapped to a row on the DB.
    * This Ctor is used to create "new" instances to be written to
    * the DB.
    */
   public Product() {}

   /**
    * Creates one instance based on the ID.
    */
   public Product( int prod_id , Connection c ) throws SQLException
   {
      try
      {
          id = prod_id;
          queryRow( c );
      }
      catch( SQLException e ) 
      {
         throw e;
      }
   }

   /** 
    * Returns the table of name associated with this class.
    */
   protected String getTableName() { return TABLE_NAME; }


   /** 
    * Returns the string representing all column names that are necessary
    * to be mapped to the instance.
    *
    * Example: "col1, col2, ..., colx"
    */
   protected String getColumnList() { return "ID, NAME, PRICE, QTY"; }


   /** 
    * Returns the string representing all column names that are necessary
    * during an INSERT call. It usually differs from the regular column list
    * because for inserts, in some cases the primary keys( PKs ) might be
    * generated automatically by the DB engine.
    *
    * Example: "col1, col2, ..., colx"
    */
    protected  String getColumnListForInsert()
    {
      return ( id != 0 ) ? getColumnList() : "NAME, PRICE, QTY";
    }

   /** 
    * Returns the string representing the "where clause" that
    * matches to the instance ID.
    *
    * Example:  "WHERE ID = 1"
    *
    */
    protected String getWhereClause() { return "ID = " + id; }


   /** 
    * Returns the string representing all "values" that need to be
    *	present during the insertion of a new "row" to the table.
    */
    protected String getInsertValues()
    {
       if( id != 0 )
          return id + ", '" + name + "', " + price + ", " + qty;
       else
          return "'" + name + "', " + price + ", " + qty;
    }

 
   /** 
    * Returns string representing the "SET" of values of an 
    * update statement.
    */
    protected String getUpdateValues()
    {
       return  "ID = " + id + ", NAME = '" + name + "', PRICE = " + 
                price + ", QTY = " + qty;
    }

   /** 
    * This function is called after one updated is performed. It allows
    * the instance to fetch a possible new "ID" for the object.
    */
    public void setPKAfterInsert( Connection c, Statement s )
    {
       long pk = ((org.gjt.mm.mysql.Statement)s).getLastInsertID();
       id = (int)pk;
    }

   /** 
    * This method is implemented by each "Storable" descendents to map the 
    * fields returned from a ResultSet and maps it to the data members of 
    * the instance.
    */
    public boolean mapping( ResultSet rs ) throws SQLException
    {
      try
      {
         id         = rs.getInt( "ID" );
         name       = rs.getString("NAME");
         price      = rs.getFloat("PRICE");
         qty        = rs.getInt("QTY");
      }
      catch( SQLException e ) 
      {
         throw e;
      }
      return true;
    }

   /** 
    * Unique ID represeting the current instance.
    */
    public long getUniqueId() { return (long)id; }



   /** 
    */
    public String toString() { return getUpdateValues(); }

   /** 
    * Test driver for this class.
    */
   public static void main(String args[]) 
   {
      String driver    = "org.gjt.mm.mysql.Driver";
      String url       = "jdbc:mysql://localhost:3306/mysql";
      String user      = "test";
      String password  = null;
      try 
      {
         Class.forName(driver).newInstance();
         Connection c = DriverManager.getConnection( url, user,  password );
         Product p = new Product();
//         p.id = 1;
         p.name = "Coke";
         p.price = 0.50f;
         p.qty = 10;
         System.out.println( "Product: " + p.toString() );
         p.addNewRow( c );
         System.out.println( "After Insert: " + p.toString() );
      }
      catch( Exception e )
      {
         e.printStackTrace();
         System.out.println( "EEEE: " + e );
      }
   }
}
