/////////////////////////////////////////////////////////////////////////////
// $Header: $
//
// MODULE DESCRIPTION: 
//
// This module was based on the HtmlPanel.java that comes with the
// JDK1.2 distribution. I have done a few modications to use it
// on this demo.
//
// Copyright 1997, 1998 by Sun Microsystems, Inc.,
// 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
// All rights reserved.
//
//
// MODIFICATION/HISTORY:
//
// $Log: $
//
/////////////////////////////////////////////////////////////////////////////


import java.io.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.accessibility.*;


import java.awt.*;
import java.net.URL;
import java.net.MalformedURLException;
import java.io.IOException;


import java.awt.event.*;


/*
 * Modified a little from the samples of the JDK.
 */
public class HtmlPanel extends JPanel {
    JEditorPane html;


    //
    // Initializes the panel...
    //
    public HtmlPanel() 
    {
      setLayout(new BorderLayout());
      getAccessibleContext().setAccessibleName( "HTML panel" );
      getAccessibleContext().setAccessibleDescription(
	       "Panel to display instances information.");
	
      html = new JEditorPane();
      html.setEditable(false);
      html.setContentType( "text/html" );
      JScrollPane scroller = new JScrollPane();
      JViewport vp = scroller.getViewport();
      vp.add(html);
//      vp.setBackingStoreEnabled(true);
      add( scroller, BorderLayout.CENTER );
    }


    //
    // Setup string to be shown...
    //
    public void setText( String s )
    {
       html.setText( s );
    }


    //
    // Test driver for this class.
    //
    public static void main(String[] args) 
    {
      JFrame frame = new JFrame("HTML Panel Demo");
      frame.addWindowListener(new WindowAdapter() {
          public void windowClosing(WindowEvent e) {System.exit(0);}
      });

      HtmlPanel htm = new HtmlPanel();
      frame.getContentPane().add( htm, BorderLayout.CENTER);

/*
      String file_name = "t1.html";
      File file = new File( file_name );
      char [] buffer = new char[ (int)file.length() ];
      try {
         FileReader in = new FileReader( file_name );
         in.read( buffer );
      }
      catch( IOException e )
      {
         System.out.println( "ERROR: " + e );
      }
      String s = new String( buffer );
*/

      String s = "<html><head><title>Swing Contributors</title></head><body>" +
      "<h1>Swing Contributors</h1><hr><p>" +
      "New! Here's a list of people from the net have been sending in bugfixes to" +
      "Swing! You too can get your name on this list. If you are the first person" +
      "to find and fix a bug in Swing, please file a bug at the java.sun.com web" +
      "site. To see the list of Swing Bug Fixers, click <A HREF=\"bugfixers.html\">here.</a><p>" +
      "</body></html>";


      htm.setText( s );

      frame.setSize(400, 125);
      frame.setVisible(true);
    }

}
