/////////////////////////////////////////////////////////////////////////////
// $Header: $
//
// Copyright (c) 2000 ConnectTel, Inc. All Rights Reserved.
//  
// MODULE DESCRIPTION:
// 
// This file was based on the Java2D sample Memory Monitor that comes with
// the JDK 1.2 - It was a cheap, quick and dirty solution to show trends 
// of variables that changes in a range from 0 to max value.
//
// MODIFICATION/HISTORY:
//
// $Log: $
//
/////////////////////////////////////////////////////////////////////////////

import java.awt.*;
import java.awt.event.*;
import java.awt.image.BufferedImage;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;


/**
 * Tracks a variable from 0 ... max_value -- displayed in graph form.
 */
public class BaseMonitor extends JPanel {

    public MonitorComponent mc;

    public BaseMonitor( String title ) 
    {
        setLayout(new BorderLayout());
        setMonitorTitle( title );
        mc = new MonitorComponent();
        add(mc);
    }

    public void setMonitorTitle( String title )
    {
       setBorder(new TitledBorder(new EtchedBorder(), title ) );
    }

    public class MonitorObs extends java.util.Observable
    {
        public MonitorObs( ) {}
        public void notifyObservers( java.lang.Object obj )      
        { setChanged(); super.notifyObservers( obj ); }
    }

    public class MonitorComponent extends JPanel implements Runnable
    {
        public MonitorObs observable = new MonitorObs();
        public Thread thread;
        private int w, h;
        private BufferedImage bimg;
        private Graphics2D big;
        private Font font = new Font("Times New Roman", Font.PLAIN, 11);

        private int columnInc;
        private int pts[];
        private int ptNum;
        private int ascent, descent;
        private Rectangle graphOutlineRect = new Rectangle();
        private Rectangle2D mfRect = new Rectangle2D.Float();
        private Rectangle2D muRect = new Rectangle2D.Float();
        private Line2D graphLine = new Line2D.Float();
        private Color graphColor = new Color(46, 139, 87);
        private Color mfColor = new Color(0, 100, 0);

        private float  maxValue     = 100.0F;
        private float  currentValue = 0.0F;

        private String topMessage      = "...";
        private String bottomMessage   = "...";

        // These methods update the Base Monitor values..
        public synchronized void setMaxValue( float value) { maxValue=value; }
        public synchronized void setCurrentValue( float value) { currentValue=value; }
        public synchronized void setBottomMsg( String m) { bottomMessage=m; }
        public synchronized void setTopMsg( String m) { topMessage=m; }


        public MonitorComponent() {
            setBackground(Color.black);
            addMouseListener(new MouseAdapter() {
                public void mouseClicked(MouseEvent e) {
                    if (thread == null) start(); else stop();
                }
            });
            // start();
        }

        public Dimension getMinimumSize() {
            return getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return getPreferredSize();
        }

        public Dimension getPreferredSize() {
            return new Dimension(140,80);
        }

            
        public synchronized void paint(Graphics g) {

            if (big == null) {
                return;
            }

            big.setBackground(getBackground());
            big.clearRect(0,0,w,h);

            observable.notifyObservers( this );

            // RPS: Remove this later...  ////////////////////////////////
            // currentValue += 0.5f;
            // if( currentValue > 100.0F )
            //   currentValue = 0.0f;
            ///////////////////////////////////////////////////////////////
             

            // .. Draw allocated and used strings ..
            big.setColor(Color.green);
            if( topMessage != null )
                big.drawString( topMessage,  4.0f, (float) ascent+0.5f);
            if( bottomMessage != null )   
                big.drawString(bottomMessage, 4, h-descent);

            // Calculate remaining size
            float ssH = ascent + descent;
            float remainingHeight = (float) (h - (ssH*2) - 0.5f);
            float blockHeight = remainingHeight/10;
            float blockWidth = 20.0f;
            float remainingWidth = (float) (w - blockWidth - 10);

            // .. Memory Free ..
            big.setColor(mfColor);
            int varUsage = (int) (( 1 - currentValue / maxValue) * 10);
            int i = 0;
            for ( ; i < varUsage ; i++) { 
                mfRect.setRect(5,(float) ssH+i*blockHeight,
                                blockWidth,(float) blockHeight-1);
                big.fill(mfRect);
            }

            // .. Memory Used ..
            big.setColor(Color.green);
            for ( ; i < 10; i++)  {
                muRect.setRect(5,(float) ssH+i*blockHeight,
                                blockWidth,(float) blockHeight-1);
                big.fill(muRect);
            }

            // .. Draw History Graph ..
            big.setColor(graphColor);
            int graphX = 30;
            int graphY = (int) ssH;
            int graphW = w - graphX - 5;
            int graphH = (int) remainingHeight;
            graphOutlineRect.setRect(graphX, graphY, graphW, graphH);
            big.draw(graphOutlineRect);

            int graphRow = graphH/10;

            // .. Draw row ..
            for (int j = graphY; j <= graphH+graphY; j += graphRow) {
                graphLine.setLine(graphX,j,graphX+graphW,j);
                big.draw(graphLine);
            }
        
            // .. Draw animated column movement ..
            int graphColumn = graphW/15;

            if (columnInc == 0) {
                columnInc = graphColumn;
            }

            for (int j = graphX+columnInc; j < graphW+graphX; j+=graphColumn) {
                graphLine.setLine(j,graphY,j,graphY+graphH);
                big.draw(graphLine);
            }

            --columnInc;

            if (pts == null) {
                pts = new int[graphW];
                ptNum = 0;
            } else if (pts.length != graphW) {
                int tmp[] = null;
                if (ptNum < graphW) {     
                    tmp = new int[ptNum];
                    System.arraycopy(pts, 0, tmp, 0, tmp.length);
                } else {        
                    tmp = new int[graphW];
                    System.arraycopy(pts, pts.length-tmp.length, tmp, 0, tmp.length);
                    ptNum = tmp.length - 2;
                }
                pts = new int[graphW];
                System.arraycopy(tmp, 0, pts, 0, tmp.length);
            } else {
                big.setColor(Color.yellow);
                pts[ptNum] = (int)(graphY+graphH*( 1 - currentValue/maxValue ) );
                for (int j=graphX+graphW-ptNum, k=0;k < ptNum; k++, j++) {
                    if (k != 0) {
                        if (pts[k] != pts[k-1]) {
                            big.drawLine(j-1, pts[k-1], j, pts[k]);
                        } else {
                            big.fillRect(j, pts[k], 1, 1);
                        }
                    }
                }
                if (ptNum+2 == pts.length) {
                    // throw out oldest point
                    for (int j = 1;j < ptNum; j++) {
                        pts[j-1] = pts[j];
                    }
                    --ptNum;
                } else {
                    ptNum++;
                }
            }
            g.drawImage(bimg, 0, 0, this);
        }


        public void start() 
        {
            thread = new Thread(this);
            thread.setPriority(Thread.MIN_PRIORITY);
            thread.setName("A Monitor");
            thread.start();
        }


        public synchronized void stop() {
            thread = null;
            // notify();
            notifyAll();
            System.out.println( "stop is complete" );  
        }


        public void run() {

            Thread me = Thread.currentThread();

            while (thread == me && !isShowing() || getSize().width == 0) {
                try {
                    Thread.sleep(500);
                } catch (InterruptedException e) { thread = null; return; }
            }

            while (thread == me && isShowing()) {
                Dimension d = getSize();
                if (d.width != w || d.height != h) {
                    w = d.width;
                    h = d.height;
                    bimg = (BufferedImage) createImage(w, h);
                    big = bimg.createGraphics();
                    big.setFont(font);
                    FontMetrics fm = big.getFontMetrics(font);
                    ascent = (int) fm.getAscent();
                    descent = (int) fm.getDescent();
                }
                repaint();
                try {
                    thread.sleep(1000);
                } catch (InterruptedException e) { break; }
            }
            thread = null;
            System.out.println( "Thread is complete: " + thread );  
        }

       public synchronized void resetAll() 
       {
          System.out.println( "Reset all stoping..." );  
          stop();
/*
          w = 0;
          h = 0;
          columnInc = 0;
          ptNum = 0;
          ascent = 0;
          descent = 0;
*/
          System.out.println( "Reset all is complete." );  
        }

    }


    public static void main(String s[]) {
        final BaseMonitor demo = new BaseMonitor( "Base - Title" );
        WindowListener l = new WindowAdapter() {
            public void windowClosing(WindowEvent e) {System.exit(0);}
            public void windowDeiconified(WindowEvent e) { demo.mc.start(); }
            public void windowIconified(WindowEvent e) { demo.mc.stop(); }
        };
        Frame f = new Frame("BaseMonitor Demo test");
        f.addWindowListener(l);
        f.add("Center", demo);
        f.pack();
        f.setSize(new Dimension(200,200));
        f.show();
    }
}
