///////////////////////////////////////////////////////////////////////////
// $Header: $
//
// Copyright (c) 2000 ConnectTel, Inc. All Rights Reserved.
// by: Rosimildo da Silva
//  
// The SSF library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
// 02111-1307, USA
//
//
//  
// DESCRIPTION: Class sample for the Storable Framework. 
// It maps to a table called "Prodcut"( see header ).
// "Prodcut" that has the columns:
//   "CREATE TABLE Product ( " 
//   "  ID       INTEGER DEFAULT 0 AUTO_INCREMENT PRIMARY KEY,"
//   "  NAME     VARCHAR( 80 ) NOT NULL,"
//   "  PRICE    FLOAT DEFAULT 0.0,"
//   "  QTY      INTEGER DEFAULT 0 )" ); 
//
// HISTORY:
//
// $Log: makefile.mak,v $
//
///////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <stdlib.h>

#include "product.h"

/*
 * Constant mapping the Product class to a DB table.
 */
const char *Product::TABLE_NAME = "Product";

/**
 * This class maps the Product table.
 */
Product::Product() 
{ 
  setDefault();
}

/**
 * Creates one instance based on the ID.
 */
Product::Product( long prod_id , ssf::Connection *c )
{
  setDefault();
  id = prod_id;
  queryRow( c );
}

void Product::setDefault()
{
  id    = 0;
  price = 0.0;
  name  = "";
  qty   = 0;
}


/** 
 * WHERE clause string for the instance.
 */
const char *Product::getWhereClause()
{
   char buffer[ 100 ];
   sprintf( buffer, "ID = %d", id );
   whereClause = buffer;
   return whereClause.c_str();
}


/** 
 * String of values for inserts..
 */
const char *Product::getInsertValues()
{
   char buffer[ 100 ];
   if( id )
      sprintf( buffer, "%d, \'%s\', %.2f, %d", id, name.c_str(), price, qty );
   else
      sprintf( buffer, "\'%s\', %.2f, %d", name.c_str(), price, qty );
   insertValues = buffer;
   return insertValues.c_str();
}

/** 
 * 
 */
const char *Product::getColumnListForInsert() 
{ 
  return ( id ) ? getColumnList() : "NAME, PRICE, QTY"; 
}

/** 
 * String of values for update
 */
const char *Product::getUpdateValues()
{
   char buffer[ 100 ];
   sprintf( buffer, "ID = %d, NAME = \'%s\', PRICE= %.2f, QTY = %d", 
                    id, name.c_str(), price, qty );
   updateValues = buffer;
   return updateValues.c_str();
}


/** 
 * Maps the values from the ResultSet to each data member
 * of the instance.
 */
bool Product::mapping( ssf::ResultSet *rs )
{
#if 0
   id    = rs->getLong( "ID" );
   name  = rs->getString( "NAME" );
   price = rs->getFloat( "PRICE" );
   qty   = rs->getLong( "QTY" );
#else
   id    = rs->getLong( 0 );
   name  = rs->getString( 1 );
   price = rs->getFloat( 2 );
   qty   = rs->getLong( 3 );
#endif
   return true;
}

/** 
 * Dump internal representation of the instance for
 * debug purposes.
 */
std::string Product::toString() 
{
   return getUpdateValues();
}

