/**
 * uri.c: library of generic URI related routines 
 *
 * Reference: RFC 2396
 *
 * See Copyright for the status of this software.
 *
 * Daniel.Veillard@w3.org
 */

#ifndef __XML_URI_H__
#define __XML_URI_H__

// #include <libxml/tree.h>

#ifdef __cplusplus
extern "C" {
#endif

/**
 *
 */
typedef struct _xmlURI xmlURI;
typedef xmlURI *xmlURIPtr;
struct _xmlURI {
    char *scheme;
    char *opaque;
    char *authority;
    char *server;
    char *user;
    int port;
    char *path;
    char *query;
    char *fragment;
};

/** RDS: moved from libxml/tree.h to remove header file */

/*
 * Size of an internal character representation.
 *
 * We use 8bit chars internal representation for memory efficiency,
 * Note that with 8 bits wide xmlChars one can still use UTF-8 to handle
 * correctly non ISO-Latin input.
 */

typedef unsigned char xmlChar;

#ifndef WIN32
#ifndef CHAR
#define CHAR xmlChar
#endif
#endif

#define BAD_CAST (xmlChar *)



/*
 * This function is in tree.h:
 * xmlChar *	xmlNodeGetBase	(xmlDocPtr doc,
 *                               xmlNodePtr cur);
 */
xmlURIPtr	xmlCreateURI		(void);
xmlChar *	xmlBuildURI		(const xmlChar *URI,
	                        	 const xmlChar *base);
xmlURIPtr	xmlParseURI		(const char *URI);
int		xmlParseURIReference	(xmlURIPtr uri,
					 const char *str);
xmlChar *	xmlSaveUri		(xmlURIPtr uri);
void		xmlPrintURI		(FILE *stream,
					 xmlURIPtr uri);
char *		xmlURIUnescapeString	(const char *str,
					 int len,
					 char *target);
int		xmlNormalizeURIPath	(char *path);
xmlChar *	xmlURIEscape		(const xmlChar *str);
void		xmlFreeURI		(xmlURIPtr uri);

#ifdef __cplusplus
}
#endif
#endif /* __XML_URI_H__ */
