/////////////////////////////////////////////////////////////////////////////
// $Header: $
//
// Copyright (c) 1999 ConnectTel, Inc. All Rights Reserved.
//  
// MODULE DESCRIPTION:
//
//  RTEMS Init Task for the "thread" for the omniORB2 examples.
//
//  by: Rosimildo da Silva:
//      rdasilva@connecttel.com
//      http://www.connecttel.com
//
// MODIFICATION/HISTORY:
// $Log: $
//
/////////////////////////////////////////////////////////////////////////////

#define  CONFIGURE_INIT
#include "rtemscfg.h"
#include <stdio.h>
#include <omnithread.h>


// #define USE_REMOTE_GDB__
#ifdef USE_REMOTE_GDB__
extern "C" void init_remote_gdb( void );
#define BREAKPOINT() asm("   int $3");
#endif

// C++ "main routine"
extern int cc_main( int argc, char **argv );

/* prio example need the number of interactions */
char *argv[] = { "cc_main", "10" };


/////////////////////////////////////////////////////////////////////////////
// DESCRIPTION: Init task for the "thread" examples.
/////////////////////////////////////////////////////////////////////////////
void *POSIX_Init( void * )
{
  // RTEMS calls the global Ctor/Dtor in a context that is not
  // a posix thread. Calls to functions such as pthread_self()
  // returns NULL. So, for RTEMS let's make the thread 
  // initialization here. This is Ok as long as the cc_main()
  // routine stays running for the life time of the application.
  omni_thread::init_t omni_thread_init;

#ifdef USE_REMOTE_GDB__
  init_remote_gdb();
  BREAKPOINT();
#endif

  printf( "\n\n*** omniORB thread example started. ***\n" );
  cc_main( 2, argv );
  printf( "*** Done ***\n\n\n" );
  pthread_exit( NULL );
  return NULL; /* just so the compiler thinks we returned something */
}
