
CXXSRCS = anyExample_impl.cc anyExample_clt.cc

DIR_CPPFLAGS = $(CORBA_CPPFLAGS)

ifdef RTEMS
CORBA_STATIC_STUB_OBJS += ../rtems/init.o ../rtems/no_dns.o ../rtems/timerticks.o ../rtems/gdb_glue.o
endif

CORBA_INTERFACES = anyExample

# -Bboa tells the compiler to generate BOA skeletons
OMNIORB_IDL += -Bboa


anyExample_impl   = $(patsubst %,$(BinPattern),anyExample_impl)
anyExample_clt    = $(patsubst %,$(BinPattern),anyExample_clt)


all:: $(anyExample_impl) $(anyExample_clt)

clean::
	$(RM) $(anyExample_impl) $(anyExample_clt)

export::$(anyExample_impl) 
	@$(ExportExecutable)
	@(packages="anyExample"; $(ExportATMosPackages))

export:: $(anyExample_clt)
	@$(ExportExecutable)

$(anyExample_impl): anyExample_impl.o $(CORBA_STATIC_STUB_OBJS) $(CORBA_LIB_DEPEND)
	@(libs="$(CORBA_LIB)"; $(CXXExecutable))

$(anyExample_clt): anyExample_clt.o $(CORBA_STATIC_STUB_OBJS) $(CORBA_LIB_DEPEND)
	@(libs="$(CORBA_LIB)"; $(CXXExecutable))

