#
# rtems.mk: 
#

RTEMS_BUILD	        = $(HOME)/tools/build-i386-elf-rtems
RTEMS_INSTALL_POINT = $(HOME)/gcc-i386
RTEMS_CC_PREFIX     = i386-rtemself-
RTEMS_BSP           = pc386
PROJECT_RELEASE     = $(RTEMS_BUILD)/$(RTEMS_BSP)
PROJECT_TOOLS       = $(RTEMS_BUILD)/$(RTEMS_BSP)/build-tools
RTEMS               = 1
x86Processor        = 1
# RtemsMinimumCorba   = 1

# Define EmbeddedSystem causes the build process to only build
# src/lib.
#
EmbeddedSystem = 1

# RTEMS uses similar make/build structure as Unix, so turn this on
UnixPlatform = 1

#
# Global defines to build the ORB runtime libraries.
#
IMPORT_CPPFLAGS += -D__x86__ -DPthreadDraftVersion=10 \
                   -DPthreadSupportThreadPriority -DThreadStackSize=4096*4

#
# The HOSTBINDIR variable is used to locate the HOST IDL compiler.
# BINDIR and LIBDIR contain the binaries and libraries of the target.
#
HOSTBINDIR = bin/x86_win32
BINDIR     = bin/i386-rtems-4.0
LIBDIR     = lib/i386-rtems-4.0
#
# Under Windows, when Microsoft VC++ compiler is used, extra flags needs 
# to be defined. Undefine this macro when compiling under an UNIX 
# or LINUX host.
HOST_IDL_FLAGS = -h .hh -s SK.cc


LibPattern=%lib.a
ThreadSystem=Posix

CFLAGS = 
CPPFLAGS = 
DEFS = -DHAVE_CONFIG_H
LDFLAGS =
LIBS = 
CC_FOR_BUILD = gcc

CC = 		   $(RTEMS_INSTALL_POINT)/bin/$(RTEMS_CC_PREFIX)gcc
AS = 		   $(RTEMS_INSTALL_POINT)/bin/$(RTEMS_CC_PREFIX)as
AR = 		   $(RTEMS_INSTALL_POINT)/bin/$(RTEMS_CC_PREFIX)ar
NM = 		   $(RTEMS_INSTALL_POINT)/bin/$(RTEMS_CC_PREFIX)nm
LD = 		   $(RTEMS_INSTALL_POINT)/bin/$(RTEMS_CC_PREFIX)ld
SIZE = 		$(RTEMS_INSTALL_POINT)/bin/$(RTEMS_CC_PREFIX)size
OBJCOPY = 	$(RTEMS_INSTALL_POINT)/bin/$(RTEMS_CC_PREFIX)objcopy
RANLIB = 	$(RTEMS_INSTALL_POINT)/bin/$(RTEMS_CC_PREFIX)ranlib
CXX =       $(RTEMS_INSTALL_POINT)/bin/$(RTEMS_CC_PREFIX)g++

export CC
export AS
export LD
export NM
export AR
export SIZE
export OBJCOPY
export CXX


MKDIRHIER	= mkdir -p
INSTALL		= install -c
INSTLIBFLAGS	= -m 0644
INSTEXEFLAGS	= -m 0755

CP		 = cp
MV		 = mv -f
CPP = $(RTEMS_INSTALL_POINT)/bin/cpp
CXXLINK  = $(RTEMS_INSTALL_POINT)/bin/$(RTEMS_CC_PREFIX)g++ --pipe
CFLAGS = -O4 -Wall -Wno-unused -ansi -fasm -g \
-B$(RTEMS_BUILD)/$(RTEMS_BSP)/lib/ -specs bsp_specs -qrtems $(IMPORT_CPPFLAGS) \
$(DIR_CPPFLAGS) -I$(RTEMS_BUILD)/$(RTEMS_BSP)/lib/include \
-I$(RTEMS_BUILD)/$(RTEMS_BSP)/lib/include/networking \
-I$(RTEMS_BUILD)/$(RTEMS_BSP)/lib/include/sys

CXXFLAGS = $(CFLAGS)

ARFLAGS  = -ruv

#
# Replacements for implicit rules
#

%.o: %.c
	$(CC) -c $(CFLAGS) -o $@ $<

%.o: %.cc
	$(CXX) -c $(CXXFLAGS) -o $@ $<


#
# General rules for cleaning.
#

define CleanRule
$(RM) *.o *.a *.class *.num *.bt *.bin *.elf32
endef

# XXX VeryCleanRule should delete Java stubs too.

define VeryCleanRule
$(RM) *.d
$(RM) $(CORBA_STUB_FILES)
endef


#
# Patterns for various file types
#

LibPattern = lib%.a
LibSuffixPattern = %.a
LibSearchPattern = -l%
BinPattern = %
TclScriptPattern = %


#
# Stuff to generate statically-linked libraries.
#

define StaticLinkLibrary
(set -x; \
 $(RM) $@; \
 $(AR) $(ARFLAGS) $@ $^; \
 $(RANLIB) $@; \
)
endef

ifdef EXPORT_TREE
define ExportLibrary
(dir="$(EXPORT_TREE)/$(LIBDIR)"; \
 files="$^"; \
 for file in $$files; do \
   $(ExportFileToDir); \
 done; \
)
endef
endif


#
# Stuff to generate executable binaries.
#
# These rules are used like this
#
# target: objs lib_depends
#         @(libs="libs"; $(...Executable))
#
# The command we want to generate is like this
#
# linker -o target ... objs libs
# i.e. we need to filter out the lib_depends from the command
#

IMPORT_LIBRARY_FLAGS = $(patsubst %,-L%,$(IMPORT_LIBRARY_DIRS))

ifdef EXPORT_TREE
define ExportExecutable
(dir="$(EXPORT_TREE)/$(BINDIR)"; \
 files="$^"; \
 for file in $$files; do \
   $(ExportExecutableFileToDir); \
 done; \
)
endef
endif

CXXMAKEDEPEND = $(TOP)/$(HOSTBINDIR)/omkdepend -D__cplusplus -D__GNUG__ -D__GNUC__
CMAKEDEPEND  = $(TOP)/$(HOSTBINDIR)/omkdepend -D__GNUC__

OMNITHREAD_LIB = $(patsubst %,$(LibSearchPattern),omnithread)
lib_depend := $(patsubst %,$(LibPattern),omnithread)
OMNITHREAD_LIB_DEPEND := $(GENERATE_LIB_DEPEND)

#
# CORBA stuff
#
CorbaImplementation = OMNIORB

lib_depend := $(patsubst %,$(LibPattern),omniORB3)
omniORB_lib_depend := $(GENERATE_LIB_DEPEND)
lib_depend := $(patsubst %,$(LibPattern),omniDynamic3)
omniDynamic_lib_depend := $(GENERATE_LIB_DEPEND)


OMNIORB_IDL_ONLY = omniidl3 -h .hh -s SK.cc
ifdef RtemsMinimumCorba
OMNIORB_IDL_ANY_FLAGS =
else
OMNIORB_IDL_ANY_FLAGS = -a
endif
OMNIORB_IDL = $(OMNIORB_IDL_ONLY) $(OMNIORB_IDL_ANY_FLAGS)
OMNIORB_CPPFLAGS = -D__OMNIORB3__ -I$(CORBA_STUB_DIR) $(OMNITHREAD_CPPFLAGS)

ifdef RtemsMinimumCorba
OMNIORB_LIB = $(patsubst %,$(LibSearchPattern),omniORB3) \
		$(OMNITHREAD_LIB) $(SOCKET_LIB)
else
OMNIORB_LIB = $(patsubst %,$(LibSearchPattern),omniORB3) \
		$(patsubst %,$(LibSearchPattern),omniDynamic3) \
		$(OMNITHREAD_LIB) $(SOCKET_LIB)
endif
OMNIORB_LIB_NODYN = $(patsubst %,$(LibSearchPattern),omniORB3) \
		$(OMNITHREAD_LIB) $(SOCKET_LIB)

OMNIORB_LIB_NODYN_DEPEND = $(omniORB_lib_depend) $(OMNITHREAD_LIB_DEPEND)
OMNIORB_LIB_DEPEND = $(omniORB_lib_depend) $(OMNITHREAD_LIB_DEPEND) \
		$(omniDynamic_lib_depend)

OMNIORB_STATIC_STUB_OBJS = \
	$(CORBA_INTERFACES:%=$(CORBA_STUB_DIR)/%SK.o)
OMNIORB_STATIC_STUB_SRCS = \
	$(CORBA_INTERFACES:%=$(CORBA_STUB_DIR)/%SK.cc)
OMNIORB_DYN_STUB_OBJS = \
	$(CORBA_INTERFACES:%=$(CORBA_STUB_DIR)/%DynSK.o)
OMNIORB_DYN_STUB_SRCS = \
	$(CORBA_INTERFACES:%=$(CORBA_STUB_DIR)/%DynSK.cc)

OMNIORB_STUB_SRCS = $(OMNIORB_STATIC_STUB_SRCS) $(OMNIORB_DYN_STUB_SRCS)
OMNIORB_STUB_OBJS = $(OMNIORB_STATIC_STUB_OBJS) $(OMNIORB_DYN_STUB_OBJS)

OMNIORB_STUB_SRC_PATTERN = $(CORBA_STUB_DIR)/%SK.cc
OMNIORB_STUB_OBJ_PATTERN = $(CORBA_STUB_DIR)/%SK.o
OMNIORB_DYN_STUB_SRC_PATTERN = $(CORBA_STUB_DIR)/%DynSK.cc
OMNIORB_DYN_STUB_OBJ_PATTERN = $(CORBA_STUB_DIR)/%DynSK.o
OMNIORB_STUB_HDR_PATTERN = $(CORBA_STUB_DIR)/%.hh


# omniORB access control policy modules

OMNIORB_DUMMYGK_LIB = $(patsubst %,$(LibSearchPattern),omniGK_stub)
lib_depend := $(patsubst %,$(LibPattern),omniGK_stub)
OMNIORB_DUMMYGK_LIB_DEPEND := $(GENERATE_LIB_DEPEND)

OMNIORB_TCPWRAPGK_LIB = $(patsubst %,$(LibSearchPattern),tcpwrapGK)
lib_depend := $(patsubst %,$(LibPattern),tcpwrapGK)
OMNIORB_TCPWRAPGK_LIB_DEPEND := $(GENERATE_LIB_DEPEND)

omniORBGatekeeperImplementation = OMNIORB_DUMMYGK

OMNIORB_LIB += $($(omniORBGatekeeperImplementation)_LIB)
OMNIORB_LIB_NODYN += $($(omniORBGatekeeperImplementation)_LIB)
OMNIORB_LIB_DEPEND += $($(omniORBGatekeeperImplementation)_LIB_DEPEND)
OMNIORB_LIB_NODYN_DEPEND += $($(omniORBGatekeeperImplementation)_LIB_DEPEND)
# LifeCycle stuff

OMNIORB2_IDL_LC_FLAGS = -l
OMNIORB2_LC_LIB = $(patsubst %,$(LibSearchPattern),omniLC)

#
# Tcl stuff
#

define TclScriptExecutable
((set -x; $(RM) $@); \
 if [ "$$wish" = "" ]; then \
   wish="$(WISH4)"; \
 fi; \
 case "$$wish" in \
 /*) ;; \
 *) \
   if [ "$(EXPORT_TREE)" != "" ]; then \
     wish="$(EXPORT_TREE)/$(BINDIR)/$$wish"; \
   else \
     wish="./$$wish"; \
   fi ;; \
 esac; \
 echo echo "#!$$wish >$@"; \
 echo "#!$$wish" >$@; \
 echo echo "set auto_path [concat {$$tcllibpath} \$$auto_path] >>$@"; \
 echo "set auto_path [concat {$$tcllibpath} \$$auto_path]" >>$@; \
 echo "cat $< >>$@"; \
 cat $< >>$@; \
 set -x; \
 chmod a+x $@; \
)
endef
