#
# i386-rtems-4.0.mk - make variables and rules specific to OARcorp's RTEMS
# This file is BSP dependent. It should be modified to match the requirements
# of a particular BSP.
#

include $(THIS_IMPORT_TREE)/mk/rtems.mk

#  The following flags are used when we compile. 

# Default location of the omniORB2 configuration file.
# This is irrelvant for the cross system.
#
CONFIG_DEFAULT_LOCATION = /etc/omniorb.cfg


#
# Creates the executables for the pc386. Also, it creates the
# .bt file to be downloaded using netboot.
#
ifeq ($(RTEMS_BSP),pc386)

RELOCADDR       = 0x00100000
START16FILE     = $(PROJECT_RELEASE)/lib/start16.bin
START16ADDR     = 0x00097C00
HEADERADDR      = 0x00097E00
define CXXExecutable
(set -x; \
 $(RM) $@.elf32; \
 $(CXXLINK) -o $@.elf32 $(CXXLINKOPTIONS) -Wl,-Ttext,$(RELOCADDR) \
 $(IMPORT_LIBRARY_FLAGS) $(CXXFLAGS) \
    $(filter-out $(LibSuffixPattern),$^) $$libs; \
 $(OBJCOPY) -O binary $@.elf32 $@.bin; \
 $(PROJECT_TOOLS)/bin2boot -v $@.bt $(HEADERADDR) \
   $(START16FILE) $(START16ADDR) 0 $@.bin $(RELOCADDR) 0; \
 $(NM) -g -n $@.elf32 > $@.num; \
)
endef

define CExecutable
(set -x; \
 $(RM) $@.elf32; \
 $(CLINK) -o $@.elf32 $(CLINKOPTIONS) -Wl,-Ttext,$(RELOCADDR) \
 $(IMPORT_LIBRARY_FLAGS) $(CXXFLAGS) \
    $(filter-out $(LibSuffixPattern),$^) $$libs; \
 $(OBJCOPY) -O binary $@.elf32 $@.bin; \
 $(PROJECT_TOOLS)/bin2boot -v $@.bt $(HEADERADDR) \
   $(START16FILE) $(START16ADDR) 0 $@.bin $(RELOCADDR) 0; \
 $(NM) -g -n $@.elf32 > $@.num; \
)
endef

else

# Here add your specific bsp stuff 

define CXXExecutable
(set -x; \
 $(RM) $@; \
 $(CXXLINK) -o $@ $(CXXLINKOPTIONS) $(IMPORT_LIBRARY_FLAGS) \
    $(filter-out $(LibSuffixPattern),$^) $$libs; \
)
endef

define CExecutable
(set -x; \
 $(RM) $@; \
 $(CLINK) -o $@ $(CLINKOPTIONS) $(IMPORT_LIBRARY_FLAGS) \
    $(filter-out $(LibSuffixPattern),$^) $$libs; \
)
endef

endif





