#ifndef __timerticks__
#define __timerticks__
/////////////////////////////////////////////////////////////////////////////
// $Header: $
//
// Copyright (c) 1999 ConnectTel, Inc. All Rights Reserved.
//  
// MODULE DESCRIPTION: This module implements an interface that
// encapsulates the Timer0 of the PC. It is able to measure intervals
// of time, and check for timeouts. The resolution of it is 838 ns
// and it rolls-over around 1 Hour.
// DO NOT MEASURE ANY TIMEOUT LONGER THAN 1 HOUR. THE RESULTS WILL BE
// UNPREDICTABLE.
//
// MODIFICATION/HISTORY:
// $Log: $
//
/////////////////////////////////////////////////////////////////////////////

#include <sys/types.h>

// returns the timer ticks, approx 838 ns
extern u_long get_timer_ticks(void);

class FreeRunningTimer 
{
public:
  FreeRunningTimer( u_long interval = 0 ) { start( interval ); }
  ~FreeRunningTimer(){}
  u_long start( u_long interval ) { period = interval; return( t1 = get_timer_ticks() ); }
  u_long reset() {  return( t1 = get_timer_ticks() );  }
  bool timeout() { return (bool)( ( ( get_timer_ticks() - t1 ) >= period ) ? true : false ); }
  u_long elapsed() {  return ( get_timer_ticks() - t1 ); }

#ifdef __rtems__
// got from RTEMS <bsp.h> for pc386
#define TICK_TO_US(tk)        (((tk)*88+52)/105)
  int64_t microSecs() { return TICK_TO_US( (int64_t)elapsed() ); }
#endif

private: 
  u_long t1, period; 
};

#endif  //  __timerticks__



