/////////////////////////////////////////////////////////////////////////////
// $Header: d:/dev/rcs/csession.h_v 1.1 1998/11/13 20:50:19 rds Exp $
//
// Copyright (c) 1999 ConnectTel, Inc. All Rights Reserved.
//  
// MODULE DESCRIPTION: 
// Poor's man high resolution timer routine. It rolls-over around 1 Hour.
// DO NOT MEASURE ANY TIMEOUT LONGER THAN 1 HOUR. THE RESULTS WILL BE
// UNPREDICTABLE.
//
// MODIFICATION/HISTORY:
// $Log: csession.h_v $
//
/////////////////////////////////////////////////////////////////////////////


#include <sys/types.h>

extern "C" 
{
extern rtems_unsigned32 volatile Clock_driver_ticks;
extern unsigned int clockbits( void );
}


/////////////////////////////////////////////////////////////////////////////
// DESCRIPTION:  Returns time in raw clock counts, approx 838 ns per tick. 
/////////////////////////////////////////////////////////////////////////////
u_long get_timer_ticks( void )
{
	u_long hi;
	u_long lo;
	do 
	{
     __asm__ ( "cli" );
	  hi = Clock_driver_ticks;
	  lo = clockbits();
     __asm__ ( "sti" );
	} while( hi != Clock_driver_ticks );
	return( hi << 16 ) - lo;
}

