/***************************************************************************
 *
 * $Header: $
 *
 * Copyright (c) 1999 ConnectTel, Inc. All Rights Reserved.
 *  
 * MODULE DESCRIPTION: This module specializes the RTEMS configuration for the
 *                     omniORB examples. It could be used as a starting point
 *                     of an application using omniORB and RTEMS. 
 *
 * by: Rosimildo da Silva:
 *     rdasilva@connecttel.com
 *     http://www.connecttel.com
 *
 * MODIFICATION/HISTORY:
 *
 * $Log: $
 ****************************************************************************/

#include <tmacros.h>
#include <unistd.h>
#include <errno.h>
#include <sched.h>

/* functions */
#ifdef __cplusplus
extern "C" {
#endif

/* configuration information */
#define CONFIGURE_TEST_NEEDS_CONSOLE_DRIVER
#define CONFIGURE_TEST_NEEDS_CLOCK_DRIVER

#define CONFIGURE_MAXIMUM_DEVICES                     40
#define CONFIGURE_MAXIMUM_TASKS                       300
#define CONFIGURE_MAXIMUM_TIMERS                      32
#define CONFIGURE_MAXIMUM_SEMAPHORES                  100
#define CONFIGURE_MAXIMUM_MESSAGE_QUEUES              20
#define CONFIGURE_MAXIMUM_PARTITIONS                  10
#define CONFIGURE_MAXIMUM_REGIONS                     10

/* This seetings overwrite the ones defined in confdefs.h */
#define CONFIGURE_MAXIMUM_POSIX_MUTEXES 		         128
#define CONFIGURE_MAXIMUM_POSIX_CONDITION_VARIABLES  	128
#define CONFIGURE_MAXIMUM_POSIX_KEYS         		   128
#define CONFIGURE_MAXIMUM_POSIX_QUEUED_SIGNALS 		   100
#define CONFIGURE_MAXIMUM_POSIX_THREADS      		   256
#define CONFIGURE_MAXIMUM_POSIX_TIMERS                128

void *POSIX_Init( void *argument );
#define CONFIGURE_INIT_TASK_STACK_SIZE	               (64*1024)
#define CONFIGURE_POSIX_INIT_THREAD_STACK_SIZE        (64*1024)
#define CONFIGURE_POSIX_INIT_THREAD_TABLE

#include <confdefs.h>


#ifdef __cplusplus
}
#endif
/* end of include file */
