/////////////////////////////////////////////////////////////////////////////
// $Header: $
//
// Copyright (c) 1999 ConnectTel, Inc. All Rights Reserved.
//  
// MODULE DESCRIPTION:
//
//  RTEMS Init Task for a omniORB2 application that uses network functionality.
//
//  by: Rosimildo da Silva:
//      rdasilva@connecttel.com
//      http://www.connecttel.com
//
// MODIFICATION/HISTORY:
// $Log: $
//
/////////////////////////////////////////////////////////////////////////////


#define  CONFIGURE_INIT
extern "C" 
{
#include "rtemscfg.h"
#include "net_cfg.h"
}
#include <stdio.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <omnithread.h>
#include <omniORB2/CORBA.h>

// Enable the following define if you want to debug this application
// #define USE_REMOTE_GDB__
#ifdef USE_REMOTE_GDB__
extern "C" void init_remote_gdb( void );
#define BREAKPOINT() asm("   int $3");
#endif

/* this is the command line options to be passed to the ORB */
char *cc_argv[] = 
{
	"cc_main",              /* always the name of the program */
	"-ORBInitialHost",
	"rps1",                 /* hostname of the machine running omniNames */
	"-ORBInitialPort",
	"6000"                  /* port number that omniNames is using */
};
int cc_argc = sizeof( cc_argv ) / sizeof( cc_argv[ 0 ]  );


extern int cc_main(int argc, char **argv);



CORBA::Boolean rtems_transient_handler
( 
   void *cookie, 
   CORBA::ULong retries, 
   const CORBA::TRANSIENT & ex 
)
{
   printf( "Trasient Handler called: %ld\n", retries );
   return 1;
}


CORBA::Boolean rtems_COMM_FAILURE_handler
( 
   void *cookie, 
   CORBA::ULong retries, 
   const CORBA::COMM_FAILURE & ex 
)
{
   printf( "COMM_FAILURE HANDLER called: %ld\n", retries );
   return 1;
}


CORBA::Boolean rtems_SystemException_handler
( 
   void *cookie, 
   CORBA::ULong retries, 
   const CORBA::SystemException & ex 
)
{
   printf( "SystemException HANDLER called: %ld\n", retries );
   return 1;
}


static void installHandlers()
{
  printf( "Installing RTEMS exception handlers\n" );
  omniORB::installTransientExceptionHandler( 0, rtems_transient_handler );  
  omniORB::installCommFailureExceptionHandler( 0, rtems_COMM_FAILURE_handler );  
  omniORB::installSystemExceptionHandler( 0, rtems_SystemException_handler );  
}


/////////////////////////////////////////////////////////////////////////////
// DESCRIPTION: Init task for any omniORB/RTEMS application that uses network.
/////////////////////////////////////////////////////////////////////////////
void *POSIX_Init( void *argument )
{

#ifdef USE_REMOTE_GDB__
  init_remote_gdb();
  BREAKPOINT();
#endif

  // RTEMS calls the global Ctor/Dtor in a context that is not
  // a posix thread. Calls to functions such as pthread_self()
  // returns NULL. So, for RTEMS let's make the thread 
  // initialization here. This is Ok as long as the cc_main()
  // routine stays running for the life time of the application.
  omni_thread::init_t omni_thread_init;

  printf( "\n\n*** CORBA omniORB2 - Echo test programs ***\n" );
  /* Make all network initialization */
  rtems_bsdnet_initialize_network();
  printf( "Netowrk Initialization is complete.\n\n" );

  pthread_attr_t attr;
  size_t st = 0;
  pthread_attr_init(&attr);
  pthread_attr_getstacksize( &attr, &st );

//   st = _Thread_Executing->the_thread->Start.Initial_stack.size
  st = _Thread_Executing->Start.Initial_stack.size;

  printf( "Init Task Stack Size is: %d\n", st );


  // Uncomment the following lines if you want disable the 
  // connection management of omniORB. - See documentation

  // omniORB::idleConnectionScanPeriod( omniORB::idleIncoming, 0 );
  // omniORB::idleConnectionScanPeriod( omniORB::idleOutgoing, 0 );



  // Set the trace level for omniORB - see documentation
  
  omniORB::traceLevel = 20;


  // install the exception handlers for the omniORB run-time.
  // Check documentation to see how they could be activated
  // and which cases you should use them.

  // installHandlers();


  // Call omniORB example
  cc_main( cc_argc, cc_argv );
  printf( "*** Done ***\n\n\n" );
  pthread_exit( NULL );
  return NULL; /* just so the compiler thinks we returned something */
}


