/*
	mysql C++ wrapper library

	Author: Roland Haenel <rh@ginster.net>

	This program is in the public domain.
	Distribute and use it freely.
*/

#include <stdio.h>
#include <stdlib.h>

#include "database.h"

#define MYDATABASE	   "mysql"
#define MYTABLE		   "cpptest"
#define MYSQL_SERVER		"rps1"


#ifdef __rtems__
int rtems_main(int argc, char **argv)
#else
int main(int argc, char **argv)
#endif
{
	int i;
	char **tuple;
	Database *db;
	DBResult *res;

   fprintf(stdout, "Database test starting...\n" ); 
	db = new Database();
			// Initialise the database - for future releases
	if (db->init() != DB_COMMAND_OK) {
		fprintf(stderr, "Unable to initialize database: %s\n", 
		        db->errorMessage());
		exit(1);
        }

   fprintf(stdout, "About to connect to MySQL\n" ); 

			// Connect to database on localhost
	if (db->connect( MYSQL_SERVER, "3306", MYDATABASE) != DB_CONNECTION_OK) {
		fprintf(stderr, "Unable connect to database '%s': %s\n", 
		        MYDATABASE, db->errorMessage());
		exit(1);
	}

   fprintf(stdout, "Connected.\n" ); 
			// Create a test table, two columns and one index
	res = db->exec("CREATE TABLE %s (tname char(100), "
	               "rand_nr int NOT NULL, INDEX(rand_nr))", MYTABLE);
	if (res->status() != DB_COMMAND_OK) {
		fprintf(stderr, "Can't create table '%s': %s", MYTABLE, db->errorMessage());
		delete res;
		delete db;
		exit(1);
	}

   fprintf(stdout, "Table created.\n" ); 

			// Insert random data
	for (i = 0; i < 1000; i++) {
		db->exec(res, "INSERT INTO %s VALUES('User %d', %ld)",
		         MYTABLE, i, rand());
		if (res->status() != DB_COMMAND_OK) {
			fprintf(stderr, "Can't insert into table '%s': %s", MYTABLE, db->errorMessage());
			delete res;
			delete db;
			exit(1);
		}
	}

   fprintf(stdout, "Inserts completed.\n" ); 
			// Read sorted data and print it out
	db->exec(res, "SELECT * FROM %s ORDER BY rand_nr DESC", MYTABLE);
	tuple = res->getTuple();
	while (tuple != NULL) {
		for (i = 0; i < res->nrFields(); i++) printf("%20s | ", tuple[i]);
		printf("\n");
		tuple = res->getTuple();
	}

   fprintf(stdout, "Selects completed.\n" ); 
			// Drop the table
	db->exec(res, "DROP TABLE %s", MYTABLE);
	if (res->status() != DB_COMMAND_OK) {
		fprintf(stderr, "Can't drop table '%s': %s", MYTABLE, db->errorMessage());
		delete res;
		delete db;
		exit(1);
	}

   fprintf(stdout, "Test is complete and successful.\n" ); 

	delete res;			// Drop buffer
	delete db;			// Close connection

   fprintf(stdout, "About to leave main()\n" ); 
   return 0;
}
