#!/bin/sh

set -e

usage()
{
	echo "Usage: $0 executable ethernet_address" >&2
	exit 1
}

#
# Check arguments
#
case "$#" in
	2) ;;
	*) usage ;;
esac

if [ ! -f "$1" ]
then
	usage
fi
SourceFile="$1"

case "$2" in
	[0-9a-fA-F][0-9a-fA-F]:[0-9a-fA-F][0-9a-fA-F]:[0-9a-fA-F][0-9a-fA-F]:[0-9a-fA-F][0-9a-fA-F]:[0-9a-fA-F][0-9a-fA-F]:[0-9a-fA-F][0-9a-fA-F]) ;;
	*)	echo "Ethernet address must be written as xx:xx:xx:xx:xx" >&2
		exit 1;;
esac
case "$2" in
	[0-9a-fA-F][13579bBdDfF]*)
		echo "Warning -- Ethernet address has Group Address bit set." ;;
	[0-9a-fA-F][26aAeE]*) ;;
	*)	echo "Warning -- Ethernet address does not have Locally-Administered Address bit set."
		;;
esac

SVIFS="$IFS"
IFS=":"
set $2
IFS="$SVIFS"

#
# Find ROM base address
#
ROMBASE="0x"`m68k-rtems-nm "$SourceFile" | grep __RomBase | sed -e 's/ .*$//'`

#
# Patch the file
#
cp "$SourceFile" prom.exe
m68k-bdm-aout-gdb -quiet -nx prom.exe <<!!!
set write on
exec-file prom.exe
set \$entry= {int}($ROMBASE+4)
print \$entry
set {char}(\$entry-6)=0x$1
set {char}(\$entry-5)=0x$2
set {char}(\$entry-4)=0x$3
set {char}(\$entry-3)=0x$4
set {char}(\$entry-2)=0x$5
set {char}(\$entry-1)=0x$6
!!!

m68k-rtems-objcopy --output-target=srec prom.exe prom.hex
#m68k-rtems-objcopy --output-target=binary prom.exe prom.bin

#for byte in 0 1 2 3
#do
#	m68k-rtems-objcopy --interleave=4 --byte=$byte --output-target=srec prom.hex prom$byte.hex
#done
