

#include <rtems.h>
#include <bsp.h>
#include <assert.h>
#include <pthread.h>

void *start_main( void * argument )
{
  extern int my_main ( int argc, char **argv );

  (void) my_main ( 0, 0 );

  exit( 0 );

  return 0;
}

rtems_task Init()
{
  pthread_t       thread_id;
  pthread_attr_t  attr;
  int             status;

  status = pthread_attr_init( &attr );
  assert( !status );

#ifdef MAIN_STACKSPACE
  status = pthread_attr_setstacksize( &attr, MAIN_STACKSPACE );
  assert( !status );
#endif

  status = pthread_create( &thread_id, &attr, start_main, NULL );
  assert( !status );

  pthread_exit( 0 );
  return 0;
}
/* configuration information */

#define CONFIGURE_TEST_NEEDS_CONSOLE_DRIVER
#define CONFIGURE_TEST_NEEDS_CLOCK_DRIVER

#define CONFIGURE_RTEMS_INIT_TASKS_TABLE

#define CONFIGURE_MAXIMUM_POSIX_THREADS 10
#define CONFIGURE_MAXIMUM_POSIX_MUTEXES 10
#define CONFIGURE_MAXIMUM_POSIX_KEYS    10

#define STACK_CHECKER_ON

#define CONFIGURE_INIT

#include <confdefs.h>

#include <stdlib.h>

void * _valloc_r( void *reent, int nbytes )
{
  return malloc( nbytes );
}

void * _pvalloc_r( void *reent, int nbytes )
{
  return malloc( nbytes );
}
