//-< FILE.CPP >------------------------------------------------------*--------*
// FastDB                    Version 1.0         (c) 1999  GARRET    *     ?  *
// (Main Memory Database Management System)                          *   /\|  *
//                                                                   *  /  \  *
//                          Created:     20-Nov-98    K.A. Knizhnik  * / [] \ *
//                          Last update: 10-Dec-98    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// System dependent implementation of mapped on memory file
//-------------------------------------------------------------------*--------*

#include "stdtp.h"
#include "file.h"
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/stat.h>


int dbFile::open(char const* name, size_t initSize)
{
    int status;
    int fd = ::open(name, O_RDONLY, 0666);
    mmapSize = initSize;
    if (fd < 0) { 
	if (errno == ENOENT) { 
	    mmapAddr = (char*)valloc(mmapSize);
	    if (mmapAddr == NULL) { 
		::close(fd);
		return no_memory;
	    }
	    memset(mmapAddr, 0, mmapSize);
	    return ok;
	}	    
	return errno;
    }
    size_t fileSize;
    if ((size_t)::read(fd, &fileSize, sizeof fileSize) == sizeof fileSize) { 
	if (fileSize > initSize) { 
	    mmapSize = fileSize;
	}
	mmapAddr = (char*)valloc(mmapSize);
	if (mmapAddr == NULL) { 
	    ::close(fd);
	    return no_memory;
	}
	memset(mmapAddr, 0, mmapSize);
	*(size_t*)mmapAddr = fileSize;
	fileSize -= sizeof fileSize;
	if ((size_t)::read(fd, mmapAddr+sizeof(fileSize), fileSize) 
	    != fileSize) 
	{ 
	    status = errno;
	    mmapAddr = NULL;
	    ::close(fd);
	    if (status == ok) { 
		status = end_of_file;
	    }
	    return status;
	} 
    } else { 
	mmapAddr = (char*)valloc(mmapSize);
	if (mmapAddr == NULL) { 
	    ::close(fd);
	    return no_memory;
	}
	memset(mmapAddr, 0, mmapSize);
    }
    ::close(fd);
    return ok;
}

int dbFile::create(const char* name)
{
    mmapAddr = NULL;
    fd = ::open(name, O_RDWR|O_TRUNC|O_CREAT, 0666);
    if (fd < 0) { 
	return errno;
    }
    return ok;
}

int dbFile::read(void* buf, size_t& readBytes, size_t size)
{  
    long rc = ::read(fd, buf, size);
    if (rc < 0) { 
	readBytes = 0;
	return errno;
    }
    readBytes = rc;
    return ok;
}

int dbFile::write(void const* buf, size_t& writtenBytes, size_t size)
{  
    long rc = ::write(fd, buf, size);
    if (rc < 0) { 
	writtenBytes = 0;
	return errno;
    }
    writtenBytes = rc;
    return ok;
}

int dbFile::setSize(size_t size)
{
    char* newBuf = (char*)valloc(size);
    memset(mmapAddr, 0, size);
    memcpy(newBuf, mmapAddr, mmapSize);
    mmapSize = size;
    free(mmapAddr);
    mmapAddr = newBuf;
    return ok;
}

int dbFile::flush() 
{
    // ???
    return ok;
}

int dbFile::close(char const* name)
{
    // ??? raname original file
    int result = ok;
    if (name != NULL) { 
	fd = ::open(name, O_WRONLY|O_TRUNC|O_CREAT, 0666);
	if (fd < 0) { 
	    return errno;
	}
	size_t fileSize = *(size_t*)mmapAddr;
	if ((size_t)::write(fd, mmapAddr, fileSize) != fileSize)
	{ 
	    result = errno;
	    ::close(fd);
	    return result == ok ? (int)end_of_file : errno;
	}
    }
    if (mmapAddr != NULL) { 
	free(mmapAddr);
    }
    if (fd >= 0 && ::close(fd) != ok) { 
	result = errno;
    }
    return result;
}

char* dbFile::errorText(int code, char* buf, size_t bufSize)
{
    return strncpy(buf, strerror(code), bufSize);
}






