/*
 *  $Id: console.h,v 1.2 1999/02/18 15:11:24 joel Exp $
 */

#ifndef _M823_CONSOLE_H_
#define _M823_CONSOLE_H_

#include <rtems/libio.h>

int m823_smc_set_attributes(int, const struct termios*);
void m823_smc_initialize(int);
int m823_char_poll_read(int);
int m823_char_poll_write(int, const char*, int);
rtems_isr m823_smc1_console_interrupt_handler(rtems_vector_number);
rtems_isr m823_smc2_console_interrupt_handler(rtems_vector_number);
int m823_buf_poll_read(int, char**);
int m823_buf_poll_write(int, char*, int);
void m823_console_initialize(void);
rtems_device_driver m823_console_read(rtems_device_major_number,
				      rtems_device_minor_number,
				      void*);
rtems_device_driver m823_console_write(rtems_device_major_number,
				       rtems_device_minor_number,
				       void*);


typedef struct Buf_t_ {
  struct Buf_t_ *next;
  volatile char *buf;
  volatile int   len;
  int   pos;
} Buf_t;

#define SMC1_MINOR    0
#define SMC2_MINOR    1


#endif
