#include "gdb_tty.h"
#include "bochs.h"
#include <errno.h>
#include <assert.h>
#include <sgtty.h>
#include <sys/ioctl.h> 
#include <sys/param.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <stdio.h>
#include <pwd.h>

#include <netinet/tcp.h>
#include <netdb.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <signal.h>
#include <fcntl.h>


static int remote_desc = -1;

extern "C" {
int tty_alloc(const char* name){
	int port;
	struct sockaddr_in sockaddr;
	int tmp;
	struct protoent *protoent;
	int tmp_desc;
	char* port_name;

	port_name = NULL;

	port_name = getenv("BOCHS_GDB_PORT");
	
	if(port_name == NULL){
		bx_printf("tty_alloc: BOCHS_GDB_PORT not set\n");	
		return -1;
	}

	port = atoi(port_name);


	if(port <= 0 || port > 64*1024){
		bx_printf("tty_alloc: port number %d  illegal\n",port);	
		return -1;
	}

	tmp_desc = socket (PF_INET, SOCK_STREAM, 0);
	if (tmp_desc < 0){
		bx_printf("tty_alloc: could not create socket\n");	
		return -1;	
	}
	/* 
	 * Allow rapid reuse of this port. 
	 */
 
	tmp = 1;
	setsockopt (tmp_desc, SOL_SOCKET, SO_REUSEADDR, (char *)&tmp,
		 sizeof(tmp));

	sockaddr.sin_family = PF_INET; 
	sockaddr.sin_port = htons(port);
	sockaddr.sin_addr.s_addr = INADDR_ANY;

	if (bind (tmp_desc, (struct sockaddr *)&sockaddr, sizeof(sockaddr)) 
		|| listen (tmp_desc, 1)){ 
	
		bx_printf("tty_alloc: bind/listen failed\n");
		return -1;
	}
	tmp = sizeof (sockaddr);
	remote_desc = accept (tmp_desc, (struct sockaddr *)&sockaddr,(socklen_t *)&tmp);
	if (remote_desc == -1){
		close(tmp_desc);
		bx_printf("tty_alloc: accept failed\n");	
		return -1;
	}

	protoent = getprotobyname ("tcp");
	if (!protoent){
		close(tmp_desc);
		bx_printf("tty_alloc: getprotobyname(\"tcp\")  failed\n");
		return -1;
	}

	/* 
	 * Enable TCP keep alive process. 
	 */ 
	tmp = 1;
	setsockopt (tmp_desc, SOL_SOCKET, SO_KEEPALIVE, (char *)&tmp,sizeof(tmp));
	
	/*
	 * Tell TCP not to delay small packets.  This greatly speeds up
	 * interactive response. 
	 */ 
	
	tmp = 1;
	setsockopt (remote_desc, protoent->p_proto, TCP_NODELAY,
		(char *)&tmp, sizeof(tmp));

	close (tmp_desc);         /* No longer need this */


	bx_printf("tty_alloc: got descriptor %d\n",remote_desc);
	return remote_desc;
}


int tty_get_fd(int tty_id){
	bx_printf("tty_get_fd: %d\n",tty_id);

	if(remote_desc != tty_id || tty_id == -1)
		return -1;

	return remote_desc;
}


int tty(int tty_id, int type, unsigned char* buffer){
	if(remote_desc != tty_id || tty_id == -1)
		return -1;

	int res = -1;

	if(type == 1){
		res = read(remote_desc,buffer,1);
	}
	
	if(type == 0){
		res = write(remote_desc,buffer,1);
	}
	
	return res;
}


bool tty_prefetch_char(int tty_id){
	if(remote_desc != tty_id || tty_id == -1)
		return false;

	fd_set rfds;
	struct timeval tv;
	int retval;
	FD_ZERO(&rfds);
	FD_SET(remote_desc, &rfds);
	tv.tv_sec = 0;
	tv.tv_usec = 0;

	retval = select(remote_desc+1, &rfds, NULL, NULL, &tv);
	
	if(retval > 0)
		return true;
	else 
		return false;

}

}