/*
 * Root task
 *
 * $Revision: 1.3 $    $Date: 1998/08/26 14:42:04 $    $Author: eric $
 */
#include <bsp.h>
#include <stdio.h>
#include <stdlib.h>

/*
 ***********************************************************************
 *                         RTEMS CONFIGURATION                         *
 ***********************************************************************
 */
#define CONFIGURE_RTEMS_INIT_TASKS_TABLE

#define CONFIGURE_MAXIMUM_TASKS			20
#define CONFIGURE_MAXIMUM_SEMAPHORES		10
#define CONFIGURE_MAXIMUM_MESSAGE_QUEUES	10

#define CONFIGURE_MICROSECONDS_PER_TICK	52489

#define CONFIGURE_INIT
#define CONFIGURE_INIT_TASK_INITIAL_MODES (RTEMS_PREEMPT | \
					RTEMS_NO_TIMESLICE | \
					RTEMS_NO_ASR | \
					RTEMS_INTERRUPT_LEVEL(0))
#define CONFIGURE_INIT_TASK_STACK_SIZE  (40*1024)
#define CONFIGURE_INIT_TASK_PRIORITY    100
rtems_task Init (rtems_task_argument argument);

#define CONFIGURE_HAS_OWN_DEVICE_DRIVER_TABLE
rtems_driver_address_table Device_drivers[] = {
  CONSOLE_DRIVER_TABLE_ENTRY,
  CLOCK_DRIVER_TABLE_ENTRY,
};

#include <confdefs.h>

extern int main (int argc, char **argv);

/*
 * RTEMS Startup Task
 */
rtems_task
Init (rtems_task_argument ignored)
{
	putenv ("TERM=xterm");
	putenv ("NCURSES_TRACE=20");
	main (0, NULL);
	rtems_task_suspend (RTEMS_SELF);
}
