/*
 *  Yield test based on code fragments in problem report submitted
 *  by Sergei Organov <osv@Javad.RU>.
 *
 *  There appears to be a problem when there are two tasks at the
 *  same priority yielding concurrent with an interrupt driven
 *  console releasing a semaphore.
 *
 *  NOTE: Although not mentioned in the report, there may need
 *        to be a clock tick enabled.  This test does not yet
 *        enable the clock tick.
 */

#define TEST_INIT
#undef  NDEBUG

#include <bsp.h>

#include <assert.h>
#include <stdio.h>

rtems_task task1(
  rtems_task_argument ignored
)
{
  for(;;) {
    printf("Task1 is generating lots of output\n");
    rtems_task_wake_after(RTEMS_YIELD_PROCESSOR);
  }
}

rtems_task task2(
  rtems_task_argument ignored
)
{
  for(;;) {
    rtems_task_wake_after(RTEMS_YIELD_PROCESSOR);
  }
}

rtems_task Init(
  rtems_task_argument ignored
)
{
  rtems_status_code status;
  rtems_id          id;

  /*
   *  Create and start the first task
   */

  status = rtems_task_create(
    rtems_build_name( 'T', 'A', '1', ' ' ), 1,
    RTEMS_MINIMUM_STACK_SIZE, RTEMS_DEFAULT_MODES,
    RTEMS_DEFAULT_ATTRIBUTES | RTEMS_FLOATING_POINT, &id
  );
  assert( !status );

  status = rtems_task_start( id, task1, 0 );
  assert( !status );

  /*
   *  Create and start the second task
   */

  status = rtems_task_create(
    rtems_build_name( 'T', 'A', '2', ' ' ), 1,
    RTEMS_MINIMUM_STACK_SIZE, RTEMS_DEFAULT_MODES,
    RTEMS_DEFAULT_ATTRIBUTES | RTEMS_FLOATING_POINT, &id
  );
  assert( !status );

  status = rtems_task_start( id, task2, 0 );
  assert( !status );

  status = rtems_task_delete( RTEMS_SELF );

  exit( 0 );
}

/* configuration information */

#define CONFIGURE_TEST_NEEDS_CONSOLE_DRIVER
#define CONFIGURE_TEST_NEEDS_CLOCK_DRIVER

#define CONFIGURE_RTEMS_INIT_TASKS_TABLE

#define CONFIGURE_INIT

#include <confdefs.h>

/* end of file */
