/* Open/close test */

#include <rtems.h>
#include <clockdrv.h>
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <console.h>

rtems_driver_address_table Device_drivers[] = {
    CONSOLE_DRIVER_TABLE_ENTRY,
    CLOCK_DRIVER_TABLE_ENTRY
};

rtems_task      Init(rtems_task_argument a)
{
    int         i;
    int         fd;
    char        msg[16];
    int         len;
    int         l;

    printf("Open/close test (%d)\n",(int)a);

    strcpy(msg,"OK!\n");
    len = strlen(msg);

    for(i = 0; i < 20; i++){
        fd = open("/dev/tty01",O_RDWR);
        if(fd < 0){
            printf("open failed on %dth try.\n",i);
            continue;
        }
        l = write(fd,msg,len);
        if(l != len){
            printf("write failed on %dth try. (%d)\n",i,l);
            break;
        }
        close(fd);
    }
    printf("Done.\n");
    rtems_task_delete(RTEMS_SELF);
}

#define CONFIGURE_INIT
#define CONFIGURE_RTEMS_INIT_TASKS_TABLE
#define CONFIGURE_HAS_OWN_DEVICE_DRIVER_TABLE
#define CONFIGURE_MAXIMUM_TIMERS        10
#define CONFIGURE_MAXIMUM_MESSAGE_QUEUES        10
#define CONFIGURE_MAXIMUM_DEVICES       50
#include <confdefs.h>

