/*
 *  Simple test program -- simplified version of sample test hello.
 */

#define TEST_INIT

#include <bsp.h>

#include <stdio.h>
#include <sched.h>

void print_sched_info(
  char *s,
  int policy
)
{
  int min, max, levels;
  struct timespec t;

  printf( "Information on %s\n", s );
  min = sched_get_priority_min( policy );
  max = sched_get_priority_max( policy );
  (void) sched_rr_get_interval( 1, &t );
  levels = max - min;
  printf( "\tSupports %d priority levels (%d - %d)\n", levels, min, max  );
  if ( levels >= 32 )
    printf( "\tImplementation is compliant on priority levels\n");
  else
    printf( "\tImplementation is NOT compliant on priority levels\n" );

  printf( "\tScheduling quantum is %d seconds and %d nanoseconds\n",
              t.tv_sec, t.tv_nsec );
}



rtems_task Init(
  rtems_task_argument ignored
)
{
  print_sched_info( "SCHED_OTHER", SCHED_OTHER );
  print_sched_info( "SCHED_FIFO", SCHED_FIFO );
  print_sched_info( "SCHED_RR", SCHED_RR );

  exit( 0 );
}

/* configuration information */

#define CONFIGURE_TEST_NEEDS_CONSOLE_DRIVER

#define CONFIGURE_RTEMS_INIT_TASKS_TABLE
#define CONFIGURE_MICROSECONDS_PER_TICK 1000
#define CONFIGURE_TICKS_PER_TIMESLICE   1

#define CONFIGURE_INIT

#include <confdefs.h>

/* end of file */
