/*
 *  Simple test program -- simplified version of sample test hello.
 */

#define TEST_INIT

#include <bsp.h>

#include <fcntl.h>
#include <stdio.h>

rtems_task
Init(rtems_task_argument ignored)
{
   int fd;
   FILE *fp;
   char str[256];


   /***********************************************************************
    * Print the boot-up message.
    **********************************************************************/
   printf("\n\n");
   printf("%s\n", _RTEMS_version);

   printf("Here we go!\n");
   fp = fopen("test", "w");
   fprintf(fp, "Hello world!!!\n");
   fclose(fp);

   fp = fopen("test", "r");
   fgets(str, 200, fp);
   printf("read: %s\n", str);
   fclose(fp);

   fd = open("test", O_WRONLY|O_APPEND);
   printf( "fcntl flags =0x%x\n", fcntl( fd, F_GETFL ) );
   close(fd);

   fd = open("test1", O_CREAT);
   printf( "fcntl flags =0x%x\n", fcntl( fd, F_GETFL ) );
   close(fd);

   fd = open("test", O_RDONLY);
   if (fd == -1) {
      printf("Starting on the wrong foot....\n");
   }

   printf( "fcntl flags =0x%x\n", fcntl( fd, F_GETFL ) );

   fp = fdopen(fd, "r");
   if (fp == NULL) {
      printf("Nothing ever goes my way!\n");
      close(fd);
   } else {
      printf("Soon, I will be able to take over the world!\n");
      fgets(str, 200, fp);
      printf("%s\n", str);
      fclose(fp);
   }

   exit(0);
}

/* configuration information */

#define CONFIGURE_TEST_NEEDS_CONSOLE_DRIVER

#define CONFIGURE_RTEMS_INIT_TASKS_TABLE

#define CONFIGURE_INIT

#include <confdefs.h>

/* end of file */
