Summary: GNU Binary Utility Development Utilities
Name: binutils
Version: 2.9.5.0.24
Release: 1
Copyright: GPL
Group: Development/Tools
Source: ftp://ftp.valinux.com/pub/support/hjl/binutils/binutils-%{version}.tar.gz
Buildroot: /var/tmp/binutils-root
Summary(de): GNU Binary Utility Development Utilities
Summary(fr): Utilitaires de dveloppement binaire de GNU
Summary(tr): GNU gelitirme aralar

%description
Binutils is a collection of utilities necessary for compiling programs. It
includes the assembler and linker, as well as a number of other
miscellaneous programs for dealing with executable formats.

%prep
%setup -q

%build
NumCPUs=`grep -i BogoMIPS /proc/cpuinfo | wc -l | xargs expr`
echo "MAKE=make -j $NumCPUs" > makefile
echo "include Makefile" >> makefile
./configure --prefix=/usr --enable-shared
%ifarch ppc
  sed -e "s!LIB_PATH =!export LIB_PATH = /lib:/usr/lib:/usr/local/lib!" \
      < ld/Makefile >ld/Makefile.tmp
  mv -f ld/Makefile.tmp ld/Makefile
%endif
make tooldir=/usr all info

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/usr
make prefix=$RPM_BUILD_ROOT/usr tooldir=$RPM_BUILD_ROOT/usr/ install install-info
./binutils/strip-new $RPM_BUILD_ROOT/usr/bin/*
gzip -q9f $RPM_BUILD_ROOT/usr/info/*.info*

## Get rid of that arch-specific directory
#rm -rf $RPM_BUILD_ROOT/usr/lib/bin

#install -m 644 libiberty/libiberty.a $RPM_BUILD_ROOT/usr/lib
install -m 644 include/libiberty.h $RPM_BUILD_ROOT/usr/include

chmod +x $RPM_BUILD_ROOT/usr/lib/lib*.so*

%clean
rm -rf $RPM_BUILD_ROOT

%post
/sbin/ldconfig
/sbin/install-info --info-dir=/usr/info /usr/info/as.info.gz
/sbin/install-info --info-dir=/usr/info /usr/info/bfd.info.gz
/sbin/install-info --info-dir=/usr/info /usr/info/binutils.info.gz
/sbin/install-info --info-dir=/usr/info /usr/info/gasp.info.gz
/sbin/install-info --info-dir=/usr/info /usr/info/gprof.info.gz
/sbin/install-info --info-dir=/usr/info /usr/info/ld.info.gz
/sbin/install-info --info-dir=/usr/info /usr/info/standards.info.gz

%preun
if [ $1 = 0 ] ;then
  /sbin/install-info --delete --info-dir=/usr/info /usr/info/as.info.gz
  /sbin/install-info --delete --info-dir=/usr/info /usr/info/bfd.info.gz
  /sbin/install-info --delete --info-dir=/usr/info /usr/info/binutils.info.gz
  /sbin/install-info --delete --info-dir=/usr/info /usr/info/gasp.info.gz
  /sbin/install-info --delete --info-dir=/usr/info /usr/info/gprof.info.gz
  /sbin/install-info --delete --info-dir=/usr/info /usr/info/ld.info.gz
  /sbin/install-info --delete --info-dir=/usr/info /usr/info/standards.info.gz
fi

%postun -p /sbin/ldconfig

%files
%defattr(-,root,root)
%doc README
/usr/bin/*
/usr/man/man1/*
/usr/include/*
/usr/lib/*
/usr/info/*info*
