; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV32I

@a = global [4096 x i32] zeroinitializer, align 4
@b = global [4096 x i32] zeroinitializer, align 4

; This test demonstrates very slightly improved codegen in the case that
; a correct isLegalAddImmediate is implemented, thanks to LoopStrengthReduce.

define i32 @main() nounwind {
; RV32I-LABEL: main:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    lui a0, %hi(b)
; RV32I-NEXT:    addi a0, a0, %lo(b)
; RV32I-NEXT:    lui a1, %hi(a)
; RV32I-NEXT:    addi a1, a1, %lo(a)
; RV32I-NEXT:    lui a2, 1
; RV32I-NEXT:    mv a3, zero
; RV32I-NEXT:  .LBB0_1: # %for.body
; RV32I-NEXT:    # =>This Inner Loop Header: Depth=1
; RV32I-NEXT:    addi a4, a3, -2048
; RV32I-NEXT:    sw a4, 0(a1)
; RV32I-NEXT:    addi a1, a1, 4
; RV32I-NEXT:    sw a3, 0(a0)
; RV32I-NEXT:    addi a0, a0, 4
; RV32I-NEXT:    addi a3, a3, 1
; RV32I-NEXT:    bne a3, a2, .LBB0_1
; RV32I-NEXT:  # %bb.2: # %for.end
; RV32I-NEXT:    mv a0, zero
; RV32I-NEXT:    ret
entry:
  br label %for.body

for.body:
  %i.08 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
  %sub = add nsw i32 %i.08, -2048
  %arrayidx = getelementptr inbounds [4096 x i32], [4096 x i32]* @a, i32 0, i32 %i.08
  store i32 %sub, i32* %arrayidx, align 4
  %arrayidx1 = getelementptr inbounds [4096 x i32], [4096 x i32]* @b, i32 0, i32 %i.08
  store i32 %i.08, i32* %arrayidx1, align 4
  %inc = add nuw nsw i32 %i.08, 1
  %exitcond = icmp eq i32 %inc, 4096
  br i1 %exitcond, label %for.end, label %for.body

for.end:
  ret i32 0
}
