/*!
 * Copyright 2017 Chris Johns <chrisj@rtems.org>
 */

/*
 * Embed the XML catalogue in this JS code to get around the Chrome on Windows
 * security "feature" where loading of a local disk file under the same path as
 * the HTML Chrome just loaded from disk is not allowed.
 */
function coverPageCatalogue() {
    xml = '<?xml version="1.0" ?> \
<rtems-docs date="24th December 2024"> \
  <catalogue>6.1-rc8</catalogue> \
  <doc> \
    <name>user</name> \
    <title>RTEMS User Manual</title> \
    <release>6.1-rc8</release> \
    <version>6.1-rc8</version> \
    <html>user/index.html</html> \
    <pdf>user.pdf</pdf> \
  </doc> \
  <doc> \
    <name>c-user</name> \
    <title>RTEMS Classic API Guide</title> \
    <release>6.1-rc8</release> \
    <version>6.1-rc8</version> \
    <html>c-user/index.html</html> \
    <pdf>c-user.pdf</pdf> \
  </doc> \
  <doc> \
    <name>bsp-howto</name> \
    <title>RTEMS BSP and Driver Guide</title> \
    <release>6.1-rc8</release> \
    <version>6.1-rc8</version> \
    <html>bsp-howto/index.html</html> \
    <pdf>bsp-howto.pdf</pdf> \
  </doc> \
  <doc> \
    <name>posix-users</name> \
    <title>RTEMS POSIX API Guide</title> \
    <release>6.1-rc8</release> \
    <version>6.1-rc8</version> \
    <html>posix-users/index.html</html> \
    <pdf>posix-users.pdf</pdf> \
  </doc> \
  <doc> \
    <name>posix-compliance</name> \
    <title>RTEMS POSIX 1003.1 Compliance Guide</title> \
    <release>6.1-rc8</release> \
    <version>6.1-rc8</version> \
    <html>posix-compliance/index.html</html> \
    <pdf>posix-compliance.pdf</pdf> \
  </doc> \
  <doc> \
    <name>eng</name> \
    <title>RTEMS Software Engineering</title> \
    <release>6.1-rc8</release> \
    <version>6.1-rc8</version> \
    <html>eng/index.html</html> \
    <pdf>eng.pdf</pdf> \
  </doc> \
  <doc> \
    <name>filesystem</name> \
    <title>RTEMS Filesystem Design Guide</title> \
    <release>6.1-rc8</release> \
    <version>6.1-rc8</version> \
    <html>filesystem/index.html</html> \
    <pdf>filesystem.pdf</pdf> \
  </doc> \
  <doc> \
    <name>shell</name> \
    <title>RTEMS Shell Guide</title> \
    <release>6.1-rc8</release> \
    <version>6.1-rc8</version> \
    <html>shell/index.html</html> \
    <pdf>shell.pdf</pdf> \
  </doc> \
  <doc> \
    <name>cpu-supplement</name> \
    <title>RTEMS CPU Architecture Supplement</title> \
    <release>6.1-rc8</release> \
    <version>6.1-rc8</version> \
    <html>cpu-supplement/index.html</html> \
    <pdf>cpu-supplement.pdf</pdf> \
  </doc> \
  <doc> \
    <name>develenv</name> \
    <title>RTEMS Development Environment Guide</title> \
    <release>6.1-rc8</release> \
    <version>6.1-rc8</version> \
    <html>develenv/index.html</html> \
    <pdf>develenv.pdf</pdf> \
  </doc> \
  <doc> \
    <name>legacy-networking</name> \
    <title>RTEMS Legacy Networking User Manual</title> \
    <release>6.1-rc8</release> \
    <version>6.1-rc8</version> \
    <html>legacy-networking/index.html</html> \
    <pdf>legacy-networking.pdf</pdf> \
  </doc> \
</rtems-docs> \
';
    paintCatalogue($.parseXML(xml), true);
}
