struct regdescr {
  const int saddr;
  const int eaddr;
  const char *descr;
} ;

static struct regdescr regdescs[] = {
 {0x00000, 0x00003,
  "IMMRBAR—Internal memory map base address register"},
 {0x00004, 0x00007,
  "Reserved, should be cleared"},
 {0x00008, 0x0000B,
  "ALTCBAR—Alternate configuration base address register"},
 {0x0000C, 0x0001C,
  "Reserved, should be cleared"},
 {0x00020, 0x00023,
  "LBLAWBAR0—LBC local access window 0 base address register"},
 {0x00024, 0x00027,
  "LBLAWAR0—LBC local access window 0 attribute register"},
 {0x00028, 0x0002B,
  "LBLAWBAR1—LBC local access window 1 base address register"},
 {0x0002C, 0x0002F,
  "LBLAWAR1—LBC local access window 1 attribute register"},
 {0x00030, 0x00033,
  "LBLAWBAR2—LBC local access window 2 base address register"},
 {0x00034, 0x00037,
  "LBLAWAR2—LBC local access window 2 attribute register"},
 {0x00038, 0x0003B,
  "LBLAWBAR3—LBC local access window 3 base address register"},
 {0x0003C, 0x0003F,
  "LBLAWAR3—LBC local access window 3 attribute register"},
 {0x00040, 0x0005C,
  "Reserved, should be cleared"},
 {0x00060, 0x00063,
  "PCILAWBAR0—PCI local access window0 base address register"},
 {0x00064, 0x00067,
  "PCILAWAR0—PCI local access window0 attribute register"},
 {0x00068, 0x0006B,
  "PCILAWBAR1—PCI local access window1 base address register"},
 {0x0006C, 0x0006F,
  "PCILAWAR1—PCI local access window1 attribute register"},
 {0x00070, 0x0009C,
  "Reserved, should be cleared"},
 {0x000A0, 0x000A3,
  "DDRLAWBAR0—DDR local access window0 base address register"},
 {0x000A4, 0x000A7,
  "DDRLAWAR0—DDR local access window0 attribute register"},
 {0x000A8, 0x000AB,
  "DDRLAWBAR1—DDR local access window1 base address register"},
 {0x000AC, 0x000AF,
  "DDRLAWAR1—DDR local access window1 attribute register"},
 {0x000B0, 0x000FC,
  "Reserved, should be cleared"},
 {0x00100, 0x00103,
  "System general purpose register low (SGPRL)"},
 {0x00104, 0x00107,
  "System general purpose register high (SGPRH)"},
 {0x00108, 0x0010B,
  "System part and revision ID register (SPRIDR)"},
 {0x0010C, 0x0010F,
  "Reserved, should be cleared"},
 {0x00110, 0x00113,
  "System priority configuration register (SPCR)"},
 {0x00114, 0x00117,
  "System I/O configuration register low (SICRL)"},
 {0x00118, 0x0011B,
  "System I/O configuration register high (SICRH)"},
 {0x0011C, 0x00127,
  "Reserved"},
 {0x00128, 0x0012B,
  "DDR control driver register (DDRCDR)"},
 {0x0012C, 0x0012F,
  "DDR debug status register (DDRDSR)"},
 {0x00130, 0x001FC,
  "Reserved"},
 {0x00200, 0x00203,
  "Reserved, should be cleared"},
 {0x00204, 0x00207,
  "SWCRR—System watchdog control register"},
 {0x00208, 0x0020B,
  "SWCNR—System watchdog count register"},
 {0x0020C, 0x0020D,
  "Reserved, should be cleared"},
 {0x0020E, 0x0020F,
  "SWSRR—System watchdog service register"},
 {0x00300, 0x00303,
  "RTCNR—Real time counter control register"},
 {0x00304, 0x00307,
  "RTLDR—Real time counter load register"},
 {0x00308, 0x0030B,
  "RTPSR—Real time counter prescale register"},
 {0x0030C, 0x0030F,
  "RTCTR—Real time counter register"},
 {0x00310, 0x00313,
  "RTEVR—Real time counter event register"},
 {0x00314, 0x00317,
  "RTALR—Real time counter alarm register"},
 {0x00318, 0x0031F,
  "Reserved, should be cleared"},
 {0x00400, 0x00403,
  "PTCNR—Periodic interval timer control register"},
 {0x00404, 0x00408,
  "PTLDR—Periodic interval timer load register"},
 {0x00408, 0x0040B,
  "PTPSR—Periodic interval timer prescale register"},
 {0x0040C, 0x0040F,
  "PTCTR—Periodic interval timer counter register"},
 {0x00410, 0x00413,
  "PTEVR—Periodic interval timer event register"},
 {0x00414, 0x0041F,
  "Reserved, should be cleared"},
 {0x00500, 0x00500,
  "GTCFR1—Timer 1 and 2 global timers configuration register"},
 {0x00501, 0x00503,
  "Reserved, should be cleared"},
 {0x00504, 0x00504,
  "GTCFR2—Timer 3 and 4 global timers configuration register"},
 {0x00505, 0x0050F,
  "Reserved, should be cleared"},
 {0x00510, 0x00511,
  "GTMDR1—Timer 1 global timers mode register"},
 {0x00512, 0x00513,
  "GTMDR2—Timer 2 global timers mode register"},
 {0x00514, 0x00515,
  "GTRFR1—Timer 1 global timers reference register"},
 {0x00516, 0x00517,
  "GTRFR2—Timer 2 global timers reference register"},
 {0x00518, 0x00519,
  "GTCPR1—Timer 1 global timers capture register"},
 {0x0051A, 0x0051B,
  "GTCPR2—Timer 2 global timers capture register"},
 {0x0051C, 0x0051D,
  "GTCNR1—Timer 1 global timers counter register"},
 {0x0051E, 0x0051F,
  "GTCNR2—Timer 2 global timers counter register"},
 {0x00520, 0x00521,
  "GTMDR3—Timer 3 global timers mode register"},
 {0x00522, 0x00523,
  "GTMDR4—Timer 4 global timers mode register"},
 {0x00524, 0x00525,
  "GTRFR3—Timer 3 global timers reference register"},
 {0x00526, 0x00527,
  "GTRFR4—Timer 4 global timers reference register"},
 {0x00528, 0x00529,
  "GTCPR3—Timer 3 global timers capture register"},
 {0x0052A, 0x0052B,
  "GTCPR4—Timer 4 global timers capture register"},
 {0x0052C, 0x0052D,
  "GTCNR3—Timer 3 global timers counter register"},
 {0x0052E, 0x0052F,
  "GTCNR4—Timer 4 global timers counter register"},
 {0x00530, 0x00531,
  "GTEVR1—Timer 1 global timers event register"},
 {0x00532, 0x00533,
  "GTEVR2—Timer 2 global timers event register"},
 {0x00534, 0x00535,
  "GTEVR3—Timer 3 global timers event register"},
 {0x00536, 0x00537,
  "GTEVR4—Timer 4 global timers event register"},
 {0x00538, 0x00539,
  "GTPSR1—Timer 1 global timers prescale register"},
 {0x0053A, 0x0053B,
  "GTPSR2—Timer 2 global timers prescale register"},
 {0x0053C, 0x0053D,
  "GTPSR3—Timer 3 global timers prescale register"},
 {0x0053E, 0x0053F,
  "GTPSR4—Timer 4 global timers prescale register"},
 {0x00600, 0x00600,
  "GTCFR1—Timer 1 and 2 global timers configuration register"},
 {0x00601, 0x00603,
  "Reserved, should be cleared"},
 {0x00604, 0x00604,
  "GTCFR2—Timer 3 and 4 global timers configuration register"},
 {0x00605, 0x0060F,
  "Reserved, should be cleared"},
 {0x00610, 0x00611,
  "GTMDR1—Timer 1 global timers mode register"},
 {0x00612, 0x00613,
  "GTMDR2—Timer 2 global timers mode register"},
 {0x00614, 0x00615,
  "GTRFR1—Timer 1 global timers reference register"},
 {0x00616, 0x00617,
  "GTRFR2—Timer 2 global timers reference register"},
 {0x00618, 0x00619,
  "GTCPR1—Timer 1 global timers capture register"},
 {0x0061A, 0x0061B,
  "GTCPR2—Timer 2 global timers capture register"},
 {0x0061C, 0x0061D,
  "GTCNR1—Timer 1 global timers counter register"},
 {0x0061E, 0x0061F,
  "GTCNR2—Timer 2 global timers counter register"},
 {0x00620, 0x00621,
  "GTMDR3—Timer 3 global timers mode register"},
 {0x00622, 0x00623,
  "GTMDR4—Timer 4 global timers mode register"},
 {0x00624, 0x00625,
  "GTRFR3—Timer 3 global timers reference register"},
 {0x00626, 0x00627,
  "GTRFR4—Timer 4 global timers reference register"},
 {0x00628, 0x00629,
  "GTCPR3—Timer 3 global timers capture register"},
 {0x0062A, 0x0062B,
  "GTCPR4—Timer 4 global timers capture register"},
 {0x0062C, 0x0062D,
  "GTCNR3—Timer 3 global timers counter register"},
 {0x0062E, 0x0062F,
  "GTCNR4—Timer 4 global timers counter register"},
 {0x00630, 0x00631,
  "GTEVR1—Timer 1 global timers event register"},
 {0x00632, 0x00633,
  "GTEVR2—Timer 2 global timers event register"},
 {0x00634, 0x00635,
  "GTEVR2—Timer 3 global timers event register"},
 {0x00636, 0x00637,
  "GTEVR2—Timer 4 global timers event register"},
 {0x00638, 0x00639,
  "GTPSR1—Timer 1 global timers prescale register"},
 {0x0063A, 0x0063B,
  "GTPSR2—Timer 2 global timers prescale register"},
 {0x0063C, 0x0063D,
  "GTPSR3—Timer 3 global timers prescale register"},
 {0x0063E, 0x0063F,
  "GTPSR4—Timer 4 global timers prescale register"},
 {0x00700, 0x00703,
  "SICFR—System global interrupt configuration register"},
 {0x00704, 0x00707,
  "SIVCR—System global interrupt vector register"},
 {0x00708, 0x0070B,
  "SIPNR_H—System internal interrupt pending register"},
 {0x0070C, 0x0070F,
  "SIPNR_L—System internal interrupt pending register"},
 {0x00710, 0x00713,
  "SIPRR_A—System internal interrupt group A priority register"},
 {0x00714, 0x00717,
  "Reserved, should be cleared"},
 {0x00718, 0x0071B,
  "Reserved, should be cleared"},
 {0x0071C, 0x0071F,
  "SIPRR_D—System internal interrupt group D priority register"},
 {0x00720, 0x00723,
  "SIMSR_H—System internal interrupt mask register"},
 {0x00724, 0x00727,
  "SIMSR_L—System internal interrupt mask register"},
 {0x0072C, 0x0072F,
  "SEPNR—System external interrupt pending register"},
 {0x00730, 0x00733,
  "SMPRR_A—System mixed interrupt group A priority register"},
 {0x00734, 0x00737,
  "SMPRR_B—System mixed interrupt group B priority register"},
 {0x00738, 0x0073B,
  "SEMSR—System external interrupt mask register"},
 {0x0073C, 0x0073F,
  "SECNR—System external interrupt control register"},
 {0x00740, 0x00743,
  "SERSR—System error status register"},
 {0x00744, 0x00747,
  "SERMR—System error mask register"},
 {0x00748, 0x0074B,
  "SERCR—System error control register"},
 {0x0074C, 0x0074F,
  "Reserved, should be cleared"},
 {0x00750, 0x00753,
  "SIFCR_H—System internal interrupt force register"},
 {0x00754, 0x00757,
  "SIFCR_L—System internal interrupt force register"},
 {0x00758, 0x0075B,
  "SEFCR—System external interrupt force register"},
 {0x0075C, 0x0075F,
  "SERFR—System error force register"},
 {0x00760, 0x00763,
  "SCVCR—System critical interrupt vector register"},
 {0x00764, 0x00767,
  "SMVCR—System management interrupt vector register"},
 {0x00768, 0x007FF,
  "Reserved, should be cleared"},
 {0x00800, 0x00803,
  "ACR—Arbiter configuration register"},
 {0x00804, 0x00807,
  "ATR—Arbiter timers register"},
 {0x00808, 0x0080B,
  "Reserved, should be cleared"},
 {0x0080C, 0x0080F,
  "AER—Arbiter event register"},
 {0x00810, 0x00813,
  "AIDR—Arbiter interrupt definition register"},
 {0x00814, 0x00817,
  "AMR—Arbiter mask register"},
 {0x00818, 0x0081B,
  "AEATR—Arbiter event attributes register"},
 {0x0081C, 0x0081F,
  "AEADR—Arbiter event address register"},
 {0x00820, 0x00823,
  "AERR—Arbiter event response register"},
 {0x00900, 0x00903,
  "RCWLR—Reset configuration word low register"},
 {0x00904, 0x00907,
  "RCWHR—Reset configuration word high register"},
 {0x00908, 0x00909,
  "Reserved, should be cleared"},
 {0x00910, 0x00913,
  "RSR—Reset status register"},
 {0x00914, 0x00917,
  "RMR—Reset mode register"},
 {0x00918, 0x0091B,
  "RPR—Reset protection register"},
 {0x0091C, 0x0091F,
  "RCR—Reset control register"},
 {0x00920, 0x00923,
  "RCER—Reset control enable register"},
 {0x00924, 0x009FC,
  "Reserved, should be cleared"},
 {0x00A00, 0x00A03,
  "SPMR—System PLL mode register"},
 {0x00A04, 0x00A07,
  "OCCR—Output clock control register"},
 {0x00A08, 0x00A0B,
  "SCCR—System clock control register"},
 {0x00A0C, 0x00AFC,
  "Reserved, should be cleared"},
 {0x00B00, 0x00B03,
  "PMCCR—Power management controller configuration register"},
 {0x00B04, 0x00B07,
  "PMCER—Power management controller event register"},
 {0x00B08, 0x00B09,
  "PMCMR—Power management controller mask register"},
 {0x00B10, 0x00BFC,
  "Reserved, should be cleared"},
 {0x00C00, 0x00C03,
  "GP1DIR—GPIO1 direction register"},
 {0x00C04, 0x00C07,
  "GP1DR—GPIO1 open drain register"},
 {0x00C08, 0x00C0B,
  "GP1DAT—GPIO1 data register"},
 {0x00C0C, 0x00C0F,
  "GP1IER—GPIO1 interrupt event register"},
 {0x00C10, 0x00C13,
  "GP1IMR—GPIO1 interrupt mask register"},
 {0x00C14, 0x00C17,
  "GP1ICR—GPIO1 external interrupt control register"},
 {0x00C1C, 0x00CFF,
  "Reserved, should be cleared"},
 {0x00D00, 0x00D03,
  "GP2DIR—GPIO2 direction register"},
 {0x00D04, 0x00D07,
  "GP2ODR—GPIO2 open drain register"},
 {0x00D08, 0x00D0B,
  "GP2DAT—GPIO2 data register"},
 {0x00D0C, 0x00D0F,
  "GP2IER—GPIO2 interrupt event register"},
 {0x00D10, 0x00D13,
  "GP2IMR—GPIO2 interrupt mask register"},
 {0x00D14, 0x00D17,
  "GP2ICR—GPIO2 external interrupt control register"},
 {0x00D1C, 0x00EFF,
  "Reserved, should be cleared"},
 {0x00F00, 0x00FFF,
  "Reserved, should be cleared"},
 {0x01000, 0x0100F,
  "Reserved, should be cleared"},
 {0x01010, 0x01013,
  "MCK enable register (MCKENR)"},
 {0x01014, 0x010FF,
  "Reserved, should be cleared."},
 {0x01100, 0x01103,
  "Reserved. Reset value should be preserved."},
 {0x01104, 0x01107,
  "Reserved. Reset value should be preserved."},
 {0x01108, 0x0110B,
  "DLL override register (DLLOVR)"},
 {0x0110C, 0x0110F,
  "DLL status register (DLLSR)"},
 {0x01110, 0x01113,
  "DLL clock register (DLLCK)"},
 {0x01114, 0x011FF,
  "Reserved, should be cleared"},
 {0x01200, 0x012FF,
  "Reserved, should be cleared"},
 {0x01300, 0x01FFF,
  "Reserved, should be cleared"},
 {0x02000, 0x02007,
  "CS0_BNDS—Chip select 0 memory bounds"},
 {0x02008, 0x0200F,
  "CS1_BNDS—Chip select 1 memory bounds"},
 {0x02010, 0x02017,
  "CS2_BNDS—Chip select 2 memory bounds"},
 {0x02018, 0x0201F,
  "CS3_BNDS—Chip select 3 memory bounds"},
 {0x02020, 0x0207F,
  "Reserved, should be cleared"},
 {0x02080, 0x02083,
  "CS0_CONFIG—Chip select 0 configuration"},
 {0x02084, 0x02087,
  "CS1_CONFIG—Chip select 1 configuration"},
 {0x02088, 0x0208B,
  "CS2_CONFIG—Chip select 2 configuration"},
 {0x0208C, 0x0208F,
  "CS3_CONFIG—Chip select 3 configuration"},
 {0x02090, 0x020FF,
  "Reserved"},
 {0x02100, 0x02103,
  "TIMING_CFG_3—DDR SDRAM timing configuration 3"},
 {0x02104, 0x02107,
  "TIMING_CFG_0—DDR SDRAM timing configuration 0"},
 {0x02108, 0x0210B,
  "TIMING_CFG_1—DDR SDRAM timing configuration 1"},
 {0x0210C, 0x0210F,
  "TIMING_CFG_2—DDR SDRAM timing configuration 2"},
 {0x02110, 0x02113,
  "DDR_SDRAM_CFG—DDR SDRAM control configuration"},
 {0x02114, 0x02117,
  "DDR_SDRAM_CFG_2—DDR SDRAM control configuration 2"},
 {0x02118, 0x0211B,
  "DDR_SDRAM_MODE—DDR SDRAM mode configuration"},
 {0x0211C, 0x0211F,
  "DDR_SDRAM_MODE_2—DDR SDRAM mode configuration 2"},
 {0x02120, 0x02123,
  "DDR_SDRAM_MD_CNTL—DDR SDRAM mode control"},
 {0x02124, 0x02127,
  "DDR_SDRAM_INTERVAL—DDR SDRAM interval configuration"},
 {0x02128, 0x0212B,
  "DDR_DATA_INIT—DDR SDRAM data initialization"},
 {0x02130, 0x02133,
  "DDR_SDRAM_CLK_CNTL—DDR SDRAM clock control"},
 {0x02140, 0x02147,
  "Reserved"},
 {0x02148, 0x0214B,
  "DDR_INIT_ADDRESS—DDR training initialization address"},
 {0x02BF8, 0x02BFB,
  "DDR_IP_REV1—DDR IP block revision 1"},
 {0x02BFC, 0x02BFF,
  "DDR_IP_REV2—DDR IP block revision 2"},
 {0x02E00, 0x02E03,
  "DATA_ERR_INJECT_HI—Memory data path error injection mask high"},
 {0x02E04, 0x02E07,
  "DATA_ERR_INJECT_LO—Memory data path error injection mask low"},
 {0x02E08, 0x02E0B,
  "ECC_ERR_INJECT—Memory data path error injection mask ECC"},
 {0x02E20, 0x02E23,
  "CAPTURE_DATA_HI—Memory data path read capture high"},
 {0x02E24, 0x02E27,
  "CAPTURE_DATA_LO—Memory data path read capture low"},
 {0x02E28, 0x02E2B,
  "CAPTURE_ECC—Memory data path read capture ECC"},
 {0x02E40, 0x02E43,
  "ERR_DETECT—Memory error detect w1c"},
 {0x02E44, 0x02E47,
  "ERR_DISABLE—Memory error disable"},
 {0x02E48, 0x02E4B,
  "ERR_INT_EN—Memory error interrupt enable"},
 {0x02E4C, 0x02E4F,
  "CAPTURE_ATTRIBUTES—Memory error attributes capture"},
 {0x02E50, 0x02E53,
  "CAPTURE_ADDRESS—Memory error address capture"},
 {0x02E54, 0x02E57,
  "Reserved"},
 {0x02E58, 0x02E5B,
  "ERR_SBE—Single-Bit ECC memory error management I2C1 Controller"},
 {0x03000, 0x03000,
  "I2C1ADR—I2C1 address register"},
 {0x03004, 0x03007,
  "I2C1FDR—I2C1 frequency divider register"},
 {0x03008, 0x0300B,
  "I2C1CR—I2C1 control register"},
 {0x0300C, 0x0300F,
  "I2C1SR—I2C1 status register"},
 {0x03010, 0x03013,
  "I2C1DR—I2C1 data register"},
 {0x03014, 0x03014,
  "I2C1DFSRR—I2C1 digital filter sampling rate register"},
 {0x0301C, 0x030FF,
  "Reserved, should be cleared"},
 {0x03100, 0x03103,
  "I2C2ADR—I2C2 address register"},
 {0x03104, 0x03107,
  "I2C2FDR—I2C2 frequency divider register"},
 {0x03108, 0x0310B,
  "I2C2CR—I2C2 control register"},
 {0x0310C, 0x0310F,
  "I2C2SR—I2C2 status register"},
 {0x03110, 0x03113,
  "I2C2DR—I2C2 data register"},
 {0x03114, 0x03114,
  "I2C2DFSRR—I2C2 digital filter sampling rate register"},
 {0x0311C, 0x031FF,
  "Reserved, should be cleared"},
 {0x03200, 0x03FFF,
  "Reserved, should be cleared"},
 {0x04000, 0x044FF,
  "Reserved, should be cleared"},
 {0x04500, 0x04500,
  "URBR—ULCR[DLAB] = 0 UART1 receiver buffer register"},
 {0x04500, 0x04500,
  "UTHR—ULCR[DLAB] = 0 UART1 transmitter holding register"},
 {0x04500, 0x04500,
  "UDLB—ULCR[DLAB] = 1 UART1 divisor least significant byte register"},
 {0x04501, 0x04501,
  "UIER—ULCR[DLAB] = 0 UART1 interrupt enable register"},
 {0x04501, 0x04501,
  "UDMB—ULCR[DLAB] = 1 UART1 divisor most significant byte register"},
 {0x04502, 0x04502,
  "UIIR—ULCR[DLAB] = 0 UART1 interrupt ID register"},
 {0x04502, 0x04502,
  "UFCR—ULCR[DLAB] = 0 UART1 FIFO control register"},
 {0x04502, 0x04502,
  "UAFR—ULCR[DLAB] = 1 UART1 alternate function register"},
 {0x04503, 0x04503,
  "ULCR—ULCR[DLAB] = x UART1 line control register"},
 {0x04504, 0x04504,
  "UMCR—ULCR[DLAB] = x UART1 MODEM control register"},
 {0x04505, 0x04505,
  "ULSR—ULCR[DLAB] = x UART1 line status register"},
 {0x04506, 0x04506,
  "UMSR—ULCR[DLAB] = x UART1 MODEM status register"},
 {0x04507, 0x04507,
  "USCR—ULCR[DLAB] = x UART1 scratch register"},
 {0x04510, 0x04510,
  "UDSR—ULCR[DLAB] = x UART1 DMA status register"},
 {0x04600, 0x04600,
  "URBR—ULCR[DLAB] = 0 UART2 receiver buffer register"},
 {0x04600, 0x04600,
  "UTHR—ULCR[DLAB] = 0 UART2 transmitter holding register"},
 {0x04600, 0x04600,
  "UDLB—ULCR[DLAB] = 1 UART2 divisor least significant byte register"},
 {0x04601, 0x04601,
  "UIER—ULCR[DLAB] = 0 UART2 interrupt enable register"},
 {0x04601, 0x04601,
  "UDMB_ULCR[DLAB] = 1 UART2 divisor most significant byte register"},
 {0x04602, 0x04602,
  "UIIR—ULCR[DLAB] = 0 UART2 interrupt ID register"},
 {0x04602, 0x04602,
  "UFCR—ULCR[DLAB] = 0 UART2 FIFO control register"},
 {0x04602, 0x04602,
  "UAFR—ULCR[DLAB] = 1 UART2 alternate function register"},
 {0x04603, 0x04603,
  "ULCR—ULCR[DLAB] = x UART2 line control register"},
 {0x04604, 0x04604,
  "UMCR—ULCR[DLAB] = x UART2 MODEM control register"},
 {0x04605, 0x04605,
  "ULSR—ULCR[DLAB] = x UART2 line status register"},
 {0x04606, 0x04606,
  "UMSR—ULCR[DLAB] = x UART2 MODEM status register"},
 {0x04607, 0x04607,
  "USCR—ULCR[DLAB] = x UART2 scratch register"},
 {0x04610, 0x04610,
  "UDSR—ULCR[DLAB] = x UART2 DMA status register"},
 {0x04700, 0x04FFF,
  "Reserved, should be cleared"},
 {0x05000, 0x05003,
  "BR0—Base register 0"},
 {0x05008, 0x0500B,
  "BR1—Base register 1"},
 {0x05010, 0x05013,
  "BR2—Base register 2"},
 {0x05018, 0x0501B,
  "BR3—Base register 3"},
 {0x05020, 0x05023,
  "BR4—Base register 4"},
 {0x05028, 0x0502B,
  "BR5—Base register 5"},
 {0x05030, 0x05033,
  "BR6—Base register 6"},
 {0x05038, 0x0503B,
  "BR7—Base register 7"},
 {0x05004, 0x05007,
  "OR0—Options register 0"},
 {0x0500C, 0x0500F,
  "OR1—Options register 1"},
 {0x05014, 0x05017,
  "OR2—Options register 2"},
 {0x0501C, 0x0501F,
  "OR3—Options register 3"},
 {0x05024, 0x05027,
  "OR4—Options register 4"},
 {0x0502C, 0x0502F,
  "OR5—Options register 5"},
 {0x05034, 0x05037,
  "OR6—Options register 6"},
 {0x0503C, 0x0503F,
  "OR7—Options register 7"},
 {0x05068, 0x0506B,
  "MAR—UPM address register"},
 {0x0506C, 0x0506C,
  "Reserved"},
 {0x05070, 0x05073,
  "MAMR—UPMA mode register"},
 {0x05074, 0x05077,
  "MBMR—UPMB mode register"},
 {0x05078, 0x0507B,
  "MCMR—UPMC mode register"},
 {0x0507C, 0x05080,
  "Reserved"},
 {0x05084, 0x05087,
  "MRTPR—Memory refresh timer prescaler register"},
 {0x05088, 0x0508B,
  "MDR—UPM data register"},
 {0x0508C, 0x05090,
  "Reserved"},
 {0x05094, 0x05097,
  "LSDMR—SDRAM mode register"},
 {0x050A0, 0x050A3,
  "LURT—UPM refresh timer"},
 {0x050A4, 0x050A7,
  "LSRT—SDRAM refresh timer"},
 {0x050B0, 0x050B3,
  "LTESR—Transfer error status register"},
 {0x050B4, 0x050B7,
  "LTEDR—Transfer error check disable register"},
 {0x050B8, 0x050BB,
  "LTEIR—Transfer error interrupt enable register"},
 {0x050BC, 0x050BF,
  "LTEATR—Transfer error attributes register"},
 {0x050C0, 0x050C3,
  "LTEAR—Transfer error address register"},
 {0x050C4, 0x050CC,
  "Reserved"},
 {0x050D0, 0x050D3,
  "LBCR—Local bus configuration register"},
 {0x050D4, 0x050D7,
  "LCRR—Clock ratio register"},
 {0x06000, 0x06FFF,
  "Reserved, should be cleared"},
 {0x07000, 0x0701F,
  "Reserved, should be cleared"},
 {0x07020, 0x07023,
  "SPMODE—SPI mode register"},
 {0x07024, 0x07027,
  "SPIE—SPI event register"},
 {0x07028, 0x0702B,
  "SPIM—SPI mask register"},
 {0x0702C, 0x0702F,
  "SPCOM—SPI command register"},
 {0x07030, 0x07033,
  "SPITD—SPI transmit register"},
 {0x07034, 0x07037,
  "SPIRD—SPI receive register"},
 {0x07038, 0x07FFF,
  "Reserved, should be cleared"},
 {0x08030, 0x08033,
  "OMISR—Outbound message interrupt status register"},
 {0x08034, 0x08037,
  "OMIMR—Outbound message interrupt mask register"},
 {0x08050, 0x08053,
  "IMR0—Inbound message register 0"},
 {0x08054, 0x08057,
  "IMR1—Inbound message register 1"},
 {0x08058, 0x0805B,
  "OMR0—Outbound message register 0"},
 {0x0805C, 0x0805F,
  "OMR1—Outbound message register 1"},
 {0x08060, 0x08063,
  "ODR—Outbound doorbell register"},
 {0x08068, 0x0806B,
  "IDR—Inbound doorbell register"},
 {0x08080, 0x08083,
  "IMISR—Inbound message interrupt status register"},
 {0x08084, 0x08087,
  "IMIMR—Inbound message interrupt mask register"},
 {0x08100, 0x08103,
  "DMAMR0—DMA 0 mode register"},
 {0x08104, 0x08107,
  "DMASR0—DMA 0 status register"},
 {0x08108, 0x0810B,
  "DMACDAR0—DMA 0 current descriptor address register"},
 {0x08110, 0x08113,
  "DMASAR0—DMA 0 source address register"},
 {0x08118, 0x0811B,
  "DMADAR0—DMA 0 destination address register"},
 {0x08120, 0x08123,
  "DMABCR0—DMA 0 byte count register"},
 {0x08124, 0x08127,
  "DMANDAR0—DMA 0 next descriptor address register"},
 {0x08180, 0x08183,
  "DMAMR1—DMA 1 mode register"},
 {0x08184, 0x08187,
  "DMASR1—DMA 1 status register"},
 {0x08188, 0x0818B,
  "DMACDAR1—DMA 1 current descriptor address register"},
 {0x08190, 0x08193,
  "DMASAR1—DMA 1 source address register"},
 {0x08198, 0x0819B,
  "DMADAR1—DMA 1 destination address register"},
 {0x081A0, 0x081A3,
  "DMABCR1—DMA 1 byte count register"},
 {0x081A4, 0x081A7,
  "DMANDAR1—DMA 1 next descriptor address register"},
 {0x08200, 0x08203,
  "DMAMR2—DMA 2 mode register"},
 {0x08204, 0x08207,
  "DMASR2—DMA 2 status register"},
 {0x08208, 0x0820B,
  "DMACDAR2—DMA 2 current descriptor address register"},
 {0x08210, 0x08213,
  "DMASAR2—DMA 2 source address register"},
 {0x08218, 0x0821B,
  "DMADAR2—DMA 2 destination address register"},
 {0x08220, 0x08223,
  "DMABCR2—DMA 2 byte count register"},
 {0x08224, 0x08227,
  "DMANDAR2—DMA 2 next descriptor address register"},
 {0x08280, 0x08283,
  "DMAMR3—DMA 3 mode register"},
 {0x08284, 0x08287,
  "DMASR3—DMA 3 status register"},
 {0x08288, 0x0828B,
  "DMACDAR3—DMA 3 current descriptor address register"},
 {0x08290, 0x08293,
  "DMASAR3—DMA 3 source address register"},
 {0x08298, 0x0829B,
  "DMADAR3—DMA 3 destination address register"},
 {0x082A0, 0x082A3,
  "DMABCR3—DMA 3 byte count register"},
 {0x082A4, 0x082A7,
  "DMANDAR3—DMA 3 next descriptor address register"},
 {0x082A8, 0x082AB,
  "DMAGSR—DMA general status register"},
 {0x082B0, 0x082FF,
  "Reserved, should be cleared"},
 {0x08300, 0x08303,
  "PCI1 CONFIG_ADDRESS"},
 {0x08304, 0x08307,
  "PCI1 CONFIG_DATA"},
 {0x08308, 0x0830B,
  "PCI1 INT_ACK"},
 {0x0830C, 0x0837F,
  "Reserved, should be cleared"},
 {0x08380, 0x08383,
  "PCI2 CONFIG_ADDRESS"},
 {0x08384, 0x08387,
  "PCI2 CONFIG_DATA"},
 {0x08388, 0x0838B,
  "PCI2 INT_ACK"},
 {0x0838C, 0x083FF,
  "Reserved, should be cleared"},
 {0x08400, 0x08403,
  "POTAR0—PCI outbound translation address register 0"},
 {0x08408, 0x0840B,
  "POBAR0—PCI outbound base address register 0"},
 {0x08410, 0x08413,
  "POCMR0—PCI outbound comparison mask register 0"},
 {0x08418, 0x0841B,
  "POTAR1—PCI outbound translation address register 1"},
 {0x08420, 0x08423,
  "POBAR1—PCI outbound base address register 1"},
 {0x08428, 0x0842B,
  "POCMR1—PCI outbound comparison mask register 1"},
 {0x08430, 0x08433,
  "POTAR2—PCI outbound translation address register 2"},
 {0x08438, 0x0843B,
  "POBAR2—PCI outbound base address register 2"},
 {0x08440, 0x08443,
  "POCMR2—PCI outbound comparison mask register 2"},
 {0x08448, 0x0844B,
  "POTAR3—PCI outbound translation address register 3"},
 {0x08450, 0x08453,
  "POBAR3—PCI outbound base address register 3"},
 {0x08458, 0x0845B,
  "POCMR3—PCI outbound comparison mask register 3"},
 {0x08460, 0x08463,
  "POTAR4—PCI outbound translation address register 4"},
 {0x08468, 0x0846B,
  "POBAR4—PCI outbound base address register 4"},
 {0x08470, 0x08473,
  "POCMR4—PCI outbound comparison mask register 4"},
 {0x08478, 0x0847B,
  "POTAR5—PCI outbound translation address register 5"},
 {0x08480, 0x08483,
  "POBAR5—PCI outbound base address register 5"},
 {0x08488, 0x0848B,
  "POCMR5—PCI outbound comparison mask register 5"},
 {0x084F0, 0x084F3,
  "PMCR—Power management control register"},
 {0x084F8, 0x084FB,
  "DTCR—Discard timer control register"},
 {0x08500, 0x08503,
  "PCI_ESR—PCI error status register"},
 {0x08504, 0x08507,
  "PCI_ECDR—PCI error capture disable register"},
 {0x08508, 0x0850B,
  "PCI_EER—PCI error enable register"},
 {0x0850C, 0x0850F,
  "PCI_EATCR—PCI error attributes capture register"},
 {0x08510, 0x08513,
  "PCI_EACR—PCI error address capture register"},
 {0x08514, 0x08517,
  "PCI_EEACR—PCI error extended address capture register"},
 {0x08518, 0x0851B,
  "PCI_EDLCR—PCI error data low capture register"},
 {0x0851C, 0x0851F,
  "PCI_EDHCR—PCI error data high capture register"},
 {0x08520, 0x08523,
  "PCI_GCR—PCI general control register"},
 {0x08524, 0x08527,
  "PCI_ECR—PCI error control register"},
 {0x08528, 0x0852B,
  "PCI_GSR—PCI general status register"},
 {0x08538, 0x0853B,
  "PITAR2—PCI inbound translation address register 2"},
 {0x0853C, 0x0853C,
  "Reserved, should be cleared"},
 {0x08540, 0x08543,
  "PIBAR2—PCI inbound base address register 2"},
 {0x08544, 0x08547,
  "PIEBAR2—PCI inbound extended base address register 2"},
 {0x08548, 0x0854B,
  "PIWAR2—PCI inbound window attributes register 2"},
 {0x08550, 0x08553,
  "PITAR1—PCI inbound translation address register 1"},
 {0x08554, 0x08557,
  "Reserved, should be cleared"},
 {0x08558, 0x0855B,
  "PIBAR1—PCI inbound base address register 1"},
 {0x0855C, 0x0855F,
  "PIEBAR1—PCI inbound extended base address register 1"},
 {0x08560, 0x08563,
  "PIWAR1—PCI inbound window attributes register 1"},
 {0x08568, 0x0856B,
  "PITAR0—PCI inbound translation address register 0"},
 {0x0856C, 0x0856F,
  "Reserved, should be cleared"},
 {0x08570, 0x08573,
  "PIBAR0—PCI inbound base address register 0"},
 {0x08578, 0x0857B,
  "PIWAR0—PCI inbound window attributes register 0"},
 {0x0857C, 0x0857C,
  "Reserved, should be cleared"},
 {0x08600, 0x08603,
  "PCI_ESR—PCI error status register"},
 {0x08604, 0x08607,
  "PCI_ECDR—PCI error capture disable register"},
 {0x08608, 0x0860B,
  "PCI_EER—PCI error enable register"},
 {0x0860C, 0x0860F,
  "PCI_EATCR—PCI error attributes capture register"},
 {0x08610, 0x08613,
  "PCI_EACR—PCI error address capture register"},
 {0x08614, 0x08617,
  "PCI_EEACR—PCI error extended address capture register"},
 {0x08618, 0x0861B,
  "PCI_EDLCR—PCI error data low capture register"},
 {0x0861C, 0x0861F,
  "PCI_EDHCR—PCI error data high capture register"},
 {0x08620, 0x08623,
  "PCI_GCR—PCI general control register"},
 {0x08624, 0x08627,
  "PCI_ECR—PCI error control register"},
 {0x08628, 0x0862B,
  "PCI_GSR—PCI general status register"},
 {0x08638, 0x0863F,
  "PITAR2—PCI inbound translation address register 2"},
 {0x08640, 0x08643,
  "PIBAR2—PCI inbound base address register 2"},
 {0x08644, 0x08647,
  "PIEBAR2—PCI inbound extended base address register 2"},
 {0x08648, 0x0864B,
  "PIWAR2—PCI inbound window attributes register 2"},
 {0x08650, 0x08653,
  "PITAR1—PCI inbound translation address register 1"},
 {0x08658, 0x0865B,
  "PIBAR1—PCI inbound base address register 1"},
 {0x0865C, 0x0865F,
  "PIEBAR1—PCI inbound extended base address register 1"},
 {0x08660, 0x08663,
  "PIWAR1—PCI inbound window attributes register 1"},
 {0x08668, 0x0866B,
  "PITAR0—PCI inbound translation address register 0"},
 {0x08670, 0x08673,
  "PIBAR0—PCI inbound base address register 0"},
 {0x08678, 0x0867B,
  "PIWAR0—PCI inbound window attributes register 0"},
 {0x0867C, 0x086FF,
  "Reserved, should be cleared"},
 {0x08700, 0x21FFF,
  "Reserved, should be cleared"},
 {0x22000, 0x220FF,
  "Reserved, should be cleared"},
 {0x22100, 0x22100,
  "CAPLENGTH—Capability register length"},
 {0x22102, 0x22103,
  "HCIVERSION—Host interface version number"},
 {0x22104, 0x22107,
  "HCSPARAMS—Host crtl. structural parameters"},
 {0x22108, 0x2210B,
  "HCCPARAMS—Host crtl. capability parameters"},
 {0x22140, 0x22143,
  "USBCMD—USB command"},
 {0x22144, 0x22147,
  "USBSTS—USB status"},
 {0x22148, 0x2214B,
  "USBINTR—USB interrupt enable"},
 {0x2214C, 0x2214F,
  "FRINDEX—USB frame index"},
 {0x22154, 0x22157,
  "PERIODICLISTBASE—Frame list base address"},
 {0x22158, 0x2215B,
  "ASYNCLISTADDR—Next asynchronous list addr"},
 {0x2215C, 0x2215F,
  "ASYNCTTSTS— Asynchronous buffer status for embedded TT"},
 {0x22160, 0x22163,
  "BURSTSIZE—Programmable burst size"},
 {0x22164, 0x22167,
  "TXFILLTUNING—Host TT transmit pre-buffer packet tuning"},
 {0x22168, 0x2216B,
  "TXTTFILLTUNING—Host TT transmit pre-buffer packet tuning"},
 {0x22170, 0x22173,
  "ULPI VIEWPORT—ULPI Register Access"},
 {0x22180, 0x22183,
  "CONFIGFLAG—Configured flag register"},
 {0x22184, 0x22187,
  "PORTSC1—Port status/control 1"},
 {0x22188, 0x2218B,
  "PORTSC2—Port status/control 2"},
 {0x221A8, 0x221AB,
  "USBMODE—USB device mode"},
 {0x22400, 0x22403,
  "SNOOP1—Snoop 1"},
 {0x22404, 0x22407,
  "SNOOP2—Snoop 2"},
 {0x22408, 0x2240B,
  "AGE_CNT_THRESH—Age count threshold"},
 {0x2240C, 0x2240F,
  "SI_CTRL—System interface control"},
 {0x22410, 0x22413,
  "PRI_CTRL—Priority control"},
 {0x22500, 0x22503,
  "CONTROL—Control"},
 {0x22504, 0x22FFF,
  "Reserved, should be cleared"},
 {0x23000, 0x230FF,
  "Reserved, should be cleared"},
 {0x23100, 0x23100,
  "CAPLENGTH—Capability register length"},
 {0x23102, 0x23103,
  "HCIVERSION—Host interface version number"},
 {0x23104, 0x23107,
  "HCSPARAMS—Host crtl. structural parameters"},
 {0x23108, 0x2310B,
  "HCCPARAMS—Host crtl. capability parameters"},
 {0x23120, 0x23121,
  "DCIVERSION—Device interface version number"},
 {0x23124, 0x23127,
  "DCCPARAMS—Device controller parameters"},
 {0x23140, 0x23143,
  "USBCMD—USB command"},
 {0x23144, 0x23147,
  "USBSTS—USB status"},
 {0x23148, 0x2314B,
  "USBINTR—USB interrupt enable"},
 {0x2314C, 0x2314F,
  "FRINDEX—USB frame index"},
 {0x23154, 0x23157,
  "PERIODICLISTBASE—Frame list base address"},
 {0x23154, 0x23157,
  "DEVICEADDR—USB device address"},
 {0x23158, 0x2315B,
  "ASYNCLISTADDR—Next asynchronous list addr (host mode)"},
 {0x23158, 0x2315B,
  "ENDPOINT ADDR—Address at endpoint list (device mode)"},
 {0x23160, 0x23163,
  "BURSTSIZE—Programmable burst size"},
 {0x23164, 0x23167,
  "TXFILLTUNING—Host TT transmit pre-buffer packet tuning"},
 {0x23170, 0x23173,
  "ULPI VIEWPORT—ULPI Register Access"},
 {0x23180, 0x23183,
  "CONFIGFLAG—Configured flag register"},
 {0x23184, 0x23187,
  "PORTSC1—Port status/control"},
 {0x231A4, 0x231A7,
  "OTGSC—On-the-Go status and control"},
 {0x231A8, 0x231AB,
  "USBMODE—USB device mode"},
 {0x231AC, 0x231AF,
  "ENDPTSETUPSTAT—Endpoint setup status"},
 {0x231B0, 0x231B3,
  "ENDPOINTPRIME—Endpoint initialization"},
 {0x231B4, 0x231B7,
  "ENDPTFLUSH—Endpoint de-initialize"},
 {0x231B8, 0x231BB,
  "ENDPTSTATUS—Endpoint status"},
 {0x231BC, 0x231BF,
  "ENDPTCOMPLETE—Endpoint complete"},
 {0x231C0, 0x231C3,
  "ENDPTCTRL0—Endpoint control 0"},
 {0x231C4, 0x231C7,
  "ENDPTCTRL1—Endpoint control 1"},
 {0x231C8, 0x231CB,
  "ENDPTCTRL2—Endpoint control 2"},
 {0x231CC, 0x231CF,
  "ENDPTCTRL3—Endpoint control 3"},
 {0x231D0, 0x231D3,
  "ENDPTCTRL4—Endpoint control 4"},
 {0x231D4, 0x231D7,
  "ENDPTCTRL5—Endpoint control 5"},
 {0x23400, 0x23403,
  "SNOOP1—Snoop 1"},
 {0x23404, 0x23407,
  "SNOOP2—Snoop 2"},
 {0x23408, 0x2340B,
  "AGE_CNT_THRESH—Age count threshold"},
 {0x2340C, 0x2340F,
  "PRI_CTRL—Priority control"},
 {0x23410, 0x23413,
  "SI_CTRL—System interface control"},
 {0x23500, 0x23503,
  "CONTROL—Control"},
 {0x23504, 0x23FFF,
  "Reserved, should be cleared"},
 {0x24000, 0x2400C,
  "TSEC1: Reserved, should be cleared"},
 {0x24010, 0x24013,
  "TSEC1: IEVENT—Interrupt event register"},
 {0x24014, 0x24017,
  "TSEC1: IMASK—Interrupt mask register"},
 {0x24018, 0x2401B,
  "TSEC1: EDIS—Error disabled register"},
 {0x2401C, 0x2401F,
  "TSEC1: Reserved, should be cleared"},
 {0x24020, 0x24023,
  "TSEC1: ECNTRL—Ethernet control register"},
 {0x24024, 0x24027,
  "TSEC1: MINFLR—Minimum frame length register"},
 {0x24028, 0x2402B,
  "TSEC1: PTV—Pause time value register"},
 {0x2402C, 0x2402F,
  "TSEC1: DMACTRL—DMA control register"},
 {0x24030, 0x24033,
  "TSEC1: TBIPA—TBI PHY address register"},
 {0x24034, 0x24038,
  "TSEC1: Reserved, should be cleared"},
 {0x24040, 0x24088,
  "TSEC1: Reserved, should be cleared"},
 {0x2408C, 0x2408F,
  "TSEC1: FIFO_TX_THR—FIFO transmit threshold register"},
 {0x24090, 0x24093,
  "TSEC1: Reserved, should be cleared"},
 {0x24094, 0x24097,
  "TSEC1: FIFO_TX_SP—FIFO transmit space available register"},
 {0x24098, 0x2409B,
  "TSEC1: FIFO_TX_STARVE—FIFO transmit starve register"},
 {0x2409C, 0x2409F,
  "TSEC1: FIFO_TX_STARVE_SHUTOFF—FIFO transmit starve shutoff register"},
 {0x240A0, 0x240FC,
  "TSEC1: Reserved, should be cleared"},
 {0x24100, 0x24103,
  "TSEC1: TCTRL—Transmit control register"},
 {0x24104, 0x24107,
  "TSEC1: TSTAT—Transmit status register"},
 {0x24108, 0x2410B,
  "TSEC1: Reserved, should be cleared"},
 {0x24110, 0x24113,
  "TSEC1: TXIC—Transmit interrupt coalescing configuration register"},
 {0x24114, 0x24120,
  "TSEC1: Reserved, should be cleared"},
 {0x24124, 0x24127,
  "TSEC1: CTBPTR—Current TxBD pointer register"},
 {0x24128, 0x24180,
  "TSEC1: Reserved, should be cleared"},
 {0x24184, 0x24187,
  "TSEC1: TBPTR—TxBD pointer register"},
 {0x24188, 0x24200,
  "TSEC1: Reserved, should be cleared"},
 {0x24204, 0x24207,
  "TSEC1: TBASE—TxBD base address register"},
 {0x24208, 0x242AC,
  "TSEC1: Reserved, should be cleared"},
 {0x242B0, 0x242B3,
  "TSEC1: OSTBD—Out-of-sequence TxBD register"},
 {0x242B4, 0x242B7,
  "TSEC1: OSTBDP—Out-of-sequence Tx data buffer pointer register"},
 {0x242B8, 0x242FC,
  "TSEC1: Reserved, should be cleared"},
 {0x24300, 0x24303,
  "TSEC1: RCTRL—Receive control register"},
 {0x24304, 0x24307,
  "TSEC1: RSTAT—Receive status register"},
 {0x24308, 0x24308,
  "TSEC1: Reserved, should be cleared"},
 {0x2430C, 0x2430F,
  "TSEC1: RBDLEN—RxBD data length register"},
 {0x24310, 0x24313,
  "TSEC1: RXIC—Receive interrupt coalescing configuration register"},
 {0x24314, 0x24320,
  "TSEC1: Reserved, should be cleared"},
 {0x24324, 0x24327,
  "TSEC1: CRBPTR—Current RxBD pointer register"},
 {0x24328, 0x2433C,
  "TSEC1: Reserved, should be cleared"},
 {0x24340, 0x24343,
  "TSEC1: MRBLR—Maximum receive buffer length register"},
 {0x24344, 0x24380,
  "TSEC1: Reserved, should be cleared"},
 {0x24384, 0x24387,
  "TSEC1: RBPTR—RxBD pointer register"},
 {0x24388, 0x24400,
  "TSEC1: Reserved, should be cleared"},
 {0x24404, 0x24407,
  "TSEC1: RBASE—RxBD base address register"},
 {0x24408, 0x244FC,
  "TSEC1: Reserved, should be cleared"},
 {0x24500, 0x24503,
  "TSEC1: MACCFG1—MAC configuration register 1"},
 {0x24504, 0x24507,
  "TSEC1: MACCFG2—MAC configuration register 2"},
 {0x24508, 0x2450B,
  "TSEC1: IPGIFG—Inter-packet gap/inter-frame gap register"},
 {0x2450C, 0x2450C,
  "TSEC1: HAFDUP—Half-duplex register"},
 {0x24510, 0x24513,
  "TSEC1: MAXFRM—Maximum frame length register"},
 {0x24514, 0x2451C,
  "TSEC1: Reserved, should be cleared"},
 {0x24520, 0x24523,
  "TSEC1: MIIMCFG—MII management configuration register"},
 {0x24524, 0x24527,
  "TSEC1: MIIMCOM—MII management command register"},
 {0x24528, 0x2452B,
  "TSEC1: MIIMADD—MII management address register"},
 {0x2452C, 0x2452F,
  "TSEC1: MIIMCON—MII management control register"},
 {0x24530, 0x24533,
  "TSEC1: MIIMSTAT—MII management status register"},
 {0x24534, 0x24537,
  "TSEC1: MIIMIND—MII management indicator register"},
 {0x24538, 0x24538,
  "TSEC1: Reserved, should be cleared"},
 {0x2453C, 0x2453F,
  "TSEC1: IFSTAT—Interface status register"},
 {0x24540, 0x24543,
  "TSEC1: MACSTNADDR1—Station address register, part 1"},
 {0x24544, 0x24547,
  "TSEC1: MACSTNADDR2—Station address register, part 2"},
 {0x24548, 0x2467C,
  "TSEC1: Reserved, should be cleared"},
 {0x24680, 0x24683,
  "TSEC1: TR64—Xmit and Rcv 64-byte frame counter register"},
 {0x24684, 0x24684,
  "TSEC1: TR127—Xmit and Rcv 65-127-byte frame counter register"},
 {0x24688, 0x2468B,
  "TSEC1: TR255—Xmit and Rcv 128-255-byte frame counter register"},
 {0x2468C, 0x2468F,
  "TSEC1: TR511—Xmit and Rcv 256-511-byte frame counter register"},
 {0x24690, 0x24693,
  "TSEC1: TR1K—Xmit and Rcv 512-1023-byte frame counter register"},
 {0x24694, 0x24697,
  "TSEC1: TRMAX—Xmit and Rcv 1024-1518-byte frame counter register"},
 {0x24698, 0x2469B,
  "TSEC1: TRMGV—Xmit and Rcv 1519-1522-byte good VLAN frame count register"},
 {0x2469C, 0x2469F,
  "TSEC1: RBYT—Receive byte counter register"},
 {0x246A0, 0x246A3,
  "TSEC1: RPKT—Receive packet counter register"},
 {0x246A4, 0x246A7,
  "TSEC1: RFCS—Receive FCS error counter register"},
 {0x246A8, 0x246AB,
  "TSEC1: RMCA—Receive multicast packet counter register"},
 {0x246AC, 0x246AF,
  "TSEC1: RBCA—Receive broadcast packet counter register"},
 {0x246B0, 0x246B3,
  "TSEC1: RXCF—Receive control frame packet counter register"},
 {0x246B4, 0x246B7,
  "TSEC1: RXPF—Receive PAUSE frame packet counter register"},
 {0x246B8, 0x246BB,
  "TSEC1: RXUO—Receive unknown OP code counter register"},
 {0x246BC, 0x246BF,
  "TSEC1: RALN—Receive alignment error counter register"},
 {0x246C0, 0x246C3,
  "TSEC1: RFLR—Receive frame length error counter register"},
 {0x246C4, 0x246C7,
  "TSEC1: RCDE—Receive code error counter register"},
 {0x246C8, 0x246CB,
  "TSEC1: RCSE—Receive carrier sense error counter register"},
 {0x246CC, 0x246CF,
  "TSEC1: RUND—Receive undersize packet counter register"},
 {0x246D0, 0x246D3,
  "TSEC1: ROVR—Receive oversize packet counter register"},
 {0x246D4, 0x246D7,
  "TSEC1: RFRG—Receive fragments counter register"},
 {0x246D8, 0x246DB,
  "TSEC1: RJBR—Receive jabber counter register"},
 {0x246DC, 0x246DF,
  "TSEC1: RDRP—Receive drop register"},
 {0x246E0, 0x246E3,
  "TSEC1: TBYT—Transmit byte counter register"},
 {0x246E4, 0x246E7,
  "TSEC1: TPKT—Transmit packet counter register"},
 {0x246E8, 0x246EB,
  "TSEC1: TMCA—Transmit multicast packet counter register"},
 {0x246EC, 0x246EF,
  "TSEC1: TBCA—Transmit broadcast packet counter register"},
 {0x246F0, 0x246F3,
  "TSEC1: TXPF—Transmit PAUSE control frame counter register"},
 {0x246F4, 0x246F7,
  "TSEC1: TDFR—Transmit deferral packet counter register"},
 {0x246F8, 0x246FB,
  "TSEC1: TEDF—Transmit excessive deferral packet counter register"},
 {0x246FC, 0x246FF,
  "TSEC1: TSCL—Transmit single collision packet counter register"},
 {0x24700, 0x24703,
  "TSEC1: TMCL—Transmit multiple collision packet counter register"},
 {0x24704, 0x24707,
  "TSEC1: TLCL—Transmit late collision packet counter register"},
 {0x24708, 0x2470B,
  "TSEC1: TXCL—Transmit excessive collision packet counter register"},
 {0x2470C, 0x2470F,
  "TSEC1: TNCL—Transmit total collision counter register"},
 {0x24710, 0x24710,
  "TSEC1: Reserved, should be cleared"},
 {0x24714, 0x24717,
  "TSEC1: TDRP—Transmit drop frame counter register"},
 {0x24718, 0x2471B,
  "TSEC1: TJBR—Transmit jabber frame counter register"},
 {0x2471C, 0x2471F,
  "TSEC1: TFCS—Transmit FCS error counter register"},
 {0x24720, 0x24723,
  "TSEC1: TXCF—Transmit control frame counter register"},
 {0x24724, 0x24727,
  "TSEC1: TOVR—Transmit oversize frame counter register"},
 {0x24728, 0x2472B,
  "TSEC1: TUND—Transmit undersize frame counter register"},
 {0x2472C, 0x2472F,
  "TSEC1: TFRG—Transmit fragments frame counter register"},
 {0x24730, 0x24733,
  "TSEC1: CAR1—Carry register one register"},
 {0x24734, 0x24737,
  "TSEC1: CAR2—Carry register two register"},
 {0x24738, 0x2473A,
  "TSEC1: CAM1—Carry register one mask register"},
 {0x2473C, 0x2473F,
  "TSEC1: CAM2—Carry register two mask register"},
 {0x24740, 0x247FC,
  "TSEC1: Reserved, should be cleared"},
 {0x24800, 0x24803,
  "TSEC1: IADDR0—Individual address register 0"},
 {0x24804, 0x24807,
  "TSEC1: IADDR1—Individual address register 1"},
 {0x24808, 0x2480B,
  "TSEC1: IADDR2—Individual address register 2"},
 {0x2480C, 0x2480F,
  "TSEC1: IADDR3—Individual address register 3"},
 {0x24810, 0x24813,
  "TSEC1: IADDR4—Individual address register 4"},
 {0x24814, 0x24817,
  "TSEC1: IADDR5—Individual address register 5"},
 {0x24818, 0x2481B,
  "TSEC1: IADDR6—Individual address register 6"},
 {0x2481C, 0x2481F,
  "TSEC1: IADDR7—Individual address register 7"},
 {0x24820, 0x2487C,
  "TSEC1: Reserved, should be cleared"},
 {0x24880, 0x24883,
  "TSEC1: GADDR0—Group address register 0"},
 {0x24884, 0x24887,
  "TSEC1: GADDR1—Group address register 1"},
 {0x24888, 0x2488B,
  "TSEC1: GADDR2—Group address register 2"},
 {0x2488C, 0x2488F,
  "TSEC1: GADDR3—Group address register 3"},
 {0x24890, 0x24893,
  "TSEC1: GADDR4—Group address register 4"},
 {0x24894, 0x24897,
  "TSEC1: GADDR5—Group address register 5"},
 {0x24898, 0x2489B,
  "TSEC1: GADDR6—Group address register 6"},
 {0x2489C, 0x2489F,
  "TSEC1: GADDR7—Group address register 7"},
 {0x248A0, 0x24AFF,
  "TSEC1: Reserved, should be cleared"},
 {0x24B00, 0x24BF3,
  "TSEC1: Reserved, should be cleared"},
 {0x24BF8, 0x24BFB,
  "TSEC1: ATTR—Attribute register"},
 {0x24BFC, 0x24BFF,
  "TSEC1: ATTRELI—Attribute extract length and extract index register"},
 {0x24C00, 0x24FFF,
  "TSEC1: Future Expansion. Reserved, should be cleared"},
 {0x25000, 0x2500C,
  "TSEC2: Reserved, should be cleared"},
 {0x25010, 0x25013,
  "TSEC2: IEVENT—Interrupt event register"},
 {0x25014, 0x25017,
  "TSEC2: IMASK—Interrupt mask register"},
 {0x25018, 0x2501B,
  "TSEC2: EDIS—Error disabled register"},
 {0x2501C, 0x2501F,
  "TSEC2: Reserved, should be cleared"},
 {0x25020, 0x25023,
  "TSEC2: ECNTRL—Ethernet control register"},
 {0x25024, 0x25027,
  "TSEC2: MINFLR—Minimum frame length register"},
 {0x25028, 0x2502B,
  "TSEC2: PTV—Pause time value register"},
 {0x2502C, 0x2502F,
  "TSEC2: DMACTRL—DMA control register"},
 {0x25030, 0x25033,
  "TSEC2: TBIPA—TBI PHY address register"},
 {0x25034, 0x25038,
  "TSEC2: Reserved, should be cleared"},
 {0x25040, 0x25088,
  "TSEC2: Reserved, should be cleared"},
 {0x2508C, 0x2508F,
  "TSEC2: FIFO_TX_THR—FIFO transmit threshold register"},
 {0x25090, 0x25093,
  "TSEC2: Reserved, should be cleared"},
 {0x25094, 0x25097,
  "TSEC2: FIFO_TX_SP—FIFO transmit space available register"},
 {0x25098, 0x2509B,
  "TSEC2: FIFO_TX_STARVE—FIFO transmit starve register"},
 {0x2509C, 0x2509F,
  "TSEC2: FIFO_TX_STARVE_SHUTOFF—FIFO transmit starve shutoff register"},
 {0x250A0, 0x250FC,
  "TSEC2: Reserved, should be cleared"},
 {0x25100, 0x25103,
  "TSEC2: TCTRL—Transmit control register"},
 {0x25104, 0x25107,
  "TSEC2: TSTAT—Transmit status register"},
 {0x25108, 0x2510B,
  "TSEC2: Reserved, should be cleared"},
 {0x25110, 0x25113,
  "TSEC2: TXIC—Transmit interrupt coalescing configuration register"},
 {0x25114, 0x25120,
  "TSEC2: Reserved, should be cleared"},
 {0x25124, 0x25127,
  "TSEC2: CTBPTR—Current TxBD pointer register"},
 {0x25128, 0x25180,
  "TSEC2: Reserved, should be cleared"},
 {0x25184, 0x25187,
  "TSEC2: TBPTR—TxBD pointer register"},
 {0x25188, 0x25200,
  "TSEC2: Reserved, should be cleared"},
 {0x25204, 0x25207,
  "TSEC2: TBASE—TxBD base address register"},
 {0x25208, 0x252AC,
  "TSEC2: Reserved, should be cleared"},
 {0x252B0, 0x252B3,
  "TSEC2: OSTBD—Out-of-sequence TxBD register"},
 {0x252B4, 0x252B7,
  "TSEC2: OSTBDP—Out-of-sequence Tx data buffer pointer register"},
 {0x252B8, 0x252FC,
  "TSEC2: Reserved, should be cleared"},
 {0x25300, 0x25303,
  "TSEC2: RCTRL—Receive control register"},
 {0x25304, 0x25307,
  "TSEC2: RSTAT—Receive status register"},
 {0x25308, 0x25308,
  "TSEC2: Reserved, should be cleared"},
 {0x2530C, 0x2530F,
  "TSEC2: RBDLEN—RxBD data length register"},
 {0x25310, 0x25313,
  "TSEC2: RXIC—Receive interrupt coalescing configuration register"},
 {0x25314, 0x25320,
  "TSEC2: Reserved, should be cleared"},
 {0x25324, 0x25327,
  "TSEC2: CRBPTR—Current RxBD pointer register"},
 {0x25328, 0x2533C,
  "TSEC2: Reserved, should be cleared"},
 {0x25340, 0x25343,
  "TSEC2: MRBLR—Maximum receive buffer length register"},
 {0x25344, 0x25380,
  "TSEC2: Reserved, should be cleared"},
 {0x25384, 0x25387,
  "TSEC2: RBPTR—RxBD pointer register"},
 {0x25388, 0x25400,
  "TSEC2: Reserved, should be cleared"},
 {0x25404, 0x25407,
  "TSEC2: RBASE—RxBD base address register"},
 {0x25408, 0x254FC,
  "TSEC2: Reserved, should be cleared"},
 {0x25500, 0x25503,
  "TSEC2: MACCFG1—MAC configuration register 1"},
 {0x25504, 0x25507,
  "TSEC2: MACCFG2—MAC configuration register 2"},
 {0x25508, 0x2550B,
  "TSEC2: IPGIFG—Inter-packet gap/inter-frame gap register"},
 {0x2550C, 0x2550C,
  "TSEC2: HAFDUP—Half-duplex register"},
 {0x25510, 0x25513,
  "TSEC2: MAXFRM—Maximum frame length register"},
 {0x25514, 0x2551C,
  "TSEC2: Reserved, should be cleared"},
 {0x25520, 0x25523,
  "TSEC2: MIIMCFG—MII management configuration register"},
 {0x25524, 0x25527,
  "TSEC2: MIIMCOM—MII management command register"},
 {0x25528, 0x2552B,
  "TSEC2: MIIMADD—MII management address register"},
 {0x2552C, 0x2552F,
  "TSEC2: MIIMCON—MII management control register"},
 {0x25530, 0x25533,
  "TSEC2: MIIMSTAT—MII management status register"},
 {0x25534, 0x25537,
  "TSEC2: MIIMIND—MII management indicator register"},
 {0x25538, 0x25538,
  "TSEC2: Reserved, should be cleared"},
 {0x2553C, 0x2553F,
  "TSEC2: IFSTAT—Interface status register"},
 {0x25540, 0x25543,
  "TSEC2: MACSTNADDR1—Station address register, part 1"},
 {0x25544, 0x25547,
  "TSEC2: MACSTNADDR2—Station address register, part 2"},
 {0x25548, 0x2567C,
  "TSEC2: Reserved, should be cleared"},
 {0x25680, 0x25683,
  "TSEC2: TR64—Xmit and Rcv 64-byte frame counter register"},
 {0x25684, 0x25684,
  "TSEC2: TR127—Xmit and Rcv 65-127-byte frame counter register"},
 {0x25688, 0x2568B,
  "TSEC2: TR255—Xmit and Rcv 128-255-byte frame counter register"},
 {0x2568C, 0x2568F,
  "TSEC2: TR511—Xmit and Rcv 256-511-byte frame counter register"},
 {0x25690, 0x25693,
  "TSEC2: TR1K—Xmit and Rcv 512-1023-byte frame counter register"},
 {0x25694, 0x25697,
  "TSEC2: TRMAX—Xmit and Rcv 1024-1518-byte frame counter register"},
 {0x25698, 0x2569B,
  "TSEC2: TRMGV—Xmit and Rcv 1519-1522-byte good VLAN frame count register"},
 {0x2569C, 0x2569F,
  "TSEC2: RBYT—Receive byte counter register"},
 {0x256A0, 0x256A3,
  "TSEC2: RPKT—Receive packet counter register"},
 {0x256A4, 0x256A7,
  "TSEC2: RFCS—Receive FCS error counter register"},
 {0x256A8, 0x256AB,
  "TSEC2: RMCA—Receive multicast packet counter register"},
 {0x256AC, 0x256AF,
  "TSEC2: RBCA—Receive broadcast packet counter register"},
 {0x256B0, 0x256B3,
  "TSEC2: RXCF—Receive control frame packet counter register"},
 {0x256B4, 0x256B7,
  "TSEC2: RXPF—Receive PAUSE frame packet counter register"},
 {0x256B8, 0x256BB,
  "TSEC2: RXUO—Receive unknown OP code counter register"},
 {0x256BC, 0x256BF,
  "TSEC2: RALN—Receive alignment error counter register"},
 {0x256C0, 0x256C3,
  "TSEC2: RFLR—Receive frame length error counter register"},
 {0x256C4, 0x256C7,
  "TSEC2: RCDE—Receive code error counter register"},
 {0x256C8, 0x256CB,
  "TSEC2: RCSE—Receive carrier sense error counter register"},
 {0x256CC, 0x256CF,
  "TSEC2: RUND—Receive undersize packet counter register"},
 {0x256D0, 0x256D3,
  "TSEC2: ROVR—Receive oversize packet counter register"},
 {0x256D4, 0x256D7,
  "TSEC2: RFRG—Receive fragments counter register"},
 {0x256D8, 0x256DB,
  "TSEC2: RJBR—Receive jabber counter register"},
 {0x256DC, 0x256DF,
  "TSEC2: RDRP—Receive drop register"},
 {0x256E0, 0x256E3,
  "TSEC2: TBYT—Transmit byte counter register"},
 {0x256E4, 0x256E7,
  "TSEC2: TPKT—Transmit packet counter register"},
 {0x256E8, 0x256EB,
  "TSEC2: TMCA—Transmit multicast packet counter register"},
 {0x256EC, 0x256EF,
  "TSEC2: TBCA—Transmit broadcast packet counter register"},
 {0x256F0, 0x256F3,
  "TSEC2: TXPF—Transmit PAUSE control frame counter register"},
 {0x256F4, 0x256F7,
  "TSEC2: TDFR—Transmit deferral packet counter register"},
 {0x256F8, 0x256FB,
  "TSEC2: TEDF—Transmit excessive deferral packet counter register"},
 {0x256FC, 0x256FF,
  "TSEC2: TSCL—Transmit single collision packet counter register"},
 {0x25700, 0x25703,
  "TSEC2: TMCL—Transmit multiple collision packet counter register"},
 {0x25704, 0x25707,
  "TSEC2: TLCL—Transmit late collision packet counter register"},
 {0x25708, 0x2570B,
  "TSEC2: TXCL—Transmit excessive collision packet counter register"},
 {0x2570C, 0x2570F,
  "TSEC2: TNCL—Transmit total collision counter register"},
 {0x25710, 0x25710,
  "TSEC2: Reserved, should be cleared"},
 {0x25714, 0x25717,
  "TSEC2: TDRP—Transmit drop frame counter register"},
 {0x25718, 0x2571B,
  "TSEC2: TJBR—Transmit jabber frame counter register"},
 {0x2571C, 0x2571F,
  "TSEC2: TFCS—Transmit FCS error counter register"},
 {0x25720, 0x25723,
  "TSEC2: TXCF—Transmit control frame counter register"},
 {0x25724, 0x25727,
  "TSEC2: TOVR—Transmit oversize frame counter register"},
 {0x25728, 0x2572B,
  "TSEC2: TUND—Transmit undersize frame counter register"},
 {0x2572C, 0x2572F,
  "TSEC2: TFRG—Transmit fragments frame counter register"},
 {0x25730, 0x25733,
  "TSEC2: CAR1—Carry register one register"},
 {0x25734, 0x25737,
  "TSEC2: CAR2—Carry register two register"},
 {0x25738, 0x2573A,
  "TSEC2: CAM1—Carry register one mask register"},
 {0x2573C, 0x2573F,
  "TSEC2: CAM2—Carry register two mask register"},
 {0x25740, 0x257FC,
  "TSEC2: Reserved, should be cleared"},
 {0x25800, 0x25803,
  "TSEC2: IADDR0—Individual address register 0"},
 {0x25804, 0x25807,
  "TSEC2: IADDR1—Individual address register 1"},
 {0x25808, 0x2580B,
  "TSEC2: IADDR2—Individual address register 2"},
 {0x2580C, 0x2580F,
  "TSEC2: IADDR3—Individual address register 3"},
 {0x25810, 0x25813,
  "TSEC2: IADDR4—Individual address register 4"},
 {0x25814, 0x25817,
  "TSEC2: IADDR5—Individual address register 5"},
 {0x25818, 0x2581B,
  "TSEC2: IADDR6—Individual address register 6"},
 {0x2581C, 0x2581F,
  "TSEC2: IADDR7—Individual address register 7"},
 {0x25820, 0x2587C,
  "TSEC2: Reserved, should be cleared"},
 {0x25880, 0x25883,
  "TSEC2: GADDR0—Group address register 0"},
 {0x25884, 0x25887,
  "TSEC2: GADDR1—Group address register 1"},
 {0x25888, 0x2588B,
  "TSEC2: GADDR2—Group address register 2"},
 {0x2588C, 0x2588F,
  "TSEC2: GADDR3—Group address register 3"},
 {0x25890, 0x25893,
  "TSEC2: GADDR4—Group address register 4"},
 {0x25894, 0x25897,
  "TSEC2: GADDR5—Group address register 5"},
 {0x25898, 0x2589B,
  "TSEC2: GADDR6—Group address register 6"},
 {0x2589C, 0x2589F,
  "TSEC2: GADDR7—Group address register 7"},
 {0x258A0, 0x25AFF,
  "TSEC2: Reserved, should be cleared"},
 {0x25B00, 0x25BF3,
  "TSEC2: Reserved, should be cleared"},
 {0x25BF8, 0x25BFB,
  "TSEC2: ATTR—Attribute register"},
 {0x25BFC, 0x25BFF,
  "TSEC2: ATTRELI—Attribute extract length and extract index register"},
 {0x25C00, 0x25FFF,
  "TSEC2: Future Expansion. Reserved, should be cleared"},
 {0x30000, 0x30FFF,
  "Reserved, should be cleared"},
 {0x31008, 0x3100B,
  "IMR—Interrupt mask register"},
 {0x31010, 0x31013,
  "ISR—Interrupt status register"},
 {0x31018, 0x3101B,
  "ICR—Interrupt clear register"},
 {0x31020, 0x31023,
  "ID—Identification register"},
 {0x31028, 0x3102B,
  "EUASR—EU assignment status register"},
 {0x31030, 0x31033,
  "MCR—Master control register"},
 {0x31108, 0x3110B,
  "CCCR1—Crypto-channel 1 configuration register"},
 {0x31110, 0x31113,
  "CCPSR1—Crypto-channel 1 pointer status register"},
 {0x31140, 0x31143,
  "CDPR1—Crypto-channel 1 current descriptor pointer register"},
 {0x31148, 0x3114B,
  "FF1—Crypto-channel 1 fetch FIFO address register"},
 {0x31180, 0x311BF,
  "DBn—Crypto-channel 1 descriptor buffers [0–7]"},
 {0x31208, 0x3120F,
  "CCCR2—Crypto-channel 2 configuration register"},
 {0x31210, 0x31217,
  "CCPSR2—Crypto-channel 2 pointer status register"},
 {0x31240, 0x31247,
  "CDPR2—Crypto-channel 2 current descriptor pointer register"},
 {0x31248, 0x3124F,
  "FF2—Crypto-channel 2 fetch FIFO address register"},
 {0x31280, 0x312BF,
  "DBn—Crypto-channel 2 descriptor buffers[0–7]"},
 {0x31308, 0x3130F,
  "CCCR3—Crypto-channel 3 configuration register"},
 {0x31310, 0x31317,
  "CCPSR3—Crypto-channel 3 pointer status register"},
 {0x31340, 0x31347,
  "CDPR3—Crypto-channel 3 current descriptor pointer register"},
 {0x31348, 0x3134F,
  "FF3—Crypto-channel 3 fetch FIFO address register"},
 {0x31380, 0x313BF,
  "DBn—Crypto-channel 3 descriptor buffers[0–7]"},
 {0x31408, 0x3140F,
  "CCCR4—Crypto-channel 4 configuration register"},
 {0x31410, 0x31417,
  "CCPSR4—Crypto-channel 4 pointer status register"},
 {0x31440, 0x31447,
  "CDPR4—Crypto-channel 4 current descriptor pointer register"},
 {0x31448, 0x3144F,
  "FF4—Crypto-channel 4 fetch FIFO address register"},
 {0x31480, 0x314BF,
  "DBn—Crypto-channel 4 descriptor buffers[0–7]"},
 {0x32000, 0x32007,
  "DEUMR—DEU mode register"},
 {0x32008, 0x3200F,
  "DEUKSR—DEU key size register"},
 {0x32010, 0x32017,
  "DEUDSR—DEU data size register"},
 {0x32018, 0x3201F,
  "DEURCR—DEU reset control register"},
 {0x32028, 0x3202F,
  "DEUSR—DEU status register"},
 {0x32030, 0x32037,
  "DEUISR—DEU interrupt status register"},
 {0x32038, 0x3203F,
  "DEUICR—DEU interrupt control register"},
 {0x32050, 0x32057,
  "DEUEUG—DEU EU-Go register"},
 {0x32100, 0x32107,
  "DEUIV—DEU initialization vector register"},
 {0x32400, 0x32407,
  "DEUK1—DEU key 1 register"},
 {0x32408, 0x3240F,
  "DEUK2—DEU key 2 register"},
 {0x32410, 0x32417,
  "DEUK3—DEU key 3 register"},
 {0x32800, 0x32FFF,
  "DEU FIFO"},
 {0x34000, 0x34007,
  "AESUMR—AESU mode register"},
 {0x34008, 0x3400F,
  "AESUKSR—AESU key size register"},
 {0x34010, 0x34017,
  "AESUDSR—AESU data size register"},
 {0x34018, 0x3401F,
  "AESURCR—AESU reset control register"},
 {0x34028, 0x3402F,
  "AESUSR—AESU status register"},
 {0x34030, 0x34037,
  "AESUISR—AESU interrupt status register"},
 {0x34038, 0x3403F,
  "AESUICR—AESU interrupt control register"},
 {0x34050, 0x34057,
  "AESUEMR—AESU end-of-message register"},
 {0x34100, 0x34107,
  "AESU context memory registers"},
 {0x34400, 0x34407,
  "AESU key memory"},
 {0x34800, 0x34FFF,
  "AESU FIFO"},
 {0x36000, 0x36007,
  "MDEUMR—MDEU mode register"},
 {0x36008, 0x3600F,
  "MDEUKSR—MDEU key size register"},
 {0x36010, 0x36017,
  "MDEUDSR—MDEU data size register"},
 {0x36018, 0x3601F,
  "MDEURCR—MDEU reset control register"},
 {0x36028, 0x3602F,
  "MDEUSR—MDEU status register"},
 {0x36030, 0x36037,
  "MDEUISR—MDEU interrupt status register"},
 {0x36038, 0x3603F,
  "MDEUICR—MDEU interrupt control register"},
 {0x36050, 0x36057,
  "MDEUEUG—MDEU EU-Go register"},
 {0x36400, 0x3647F,
  "MDEU key memory"},
 {0x36800, 0x36FFF,
  "MDEU FIFO W 0x0000_0000 14.5.4.13/14-63"},
 {0x36100, 0x36120,
  "MDEU context memory registers"},
 {0x38000, 0x38007,
  "AFEUMR—AFEU mode register"},
 {0x38008, 0x3800F,
  "AFEUKSR—AFEU key size register"},
 {0x38010, 0x38017,
  "AFEUDSR—AFEU data size register"},
 {0x38018, 0x3801F,
  "AFEURCR—AFEU reset control register"},
 {0x38028, 0x3802F,
  "AFEUSR—AFEU status register"},
 {0x38030, 0x38037,
  "AFEUISR—AFEU interrupt status register"},
 {0x38038, 0x3803F,
  "AFEUICR—AFEU interrupt control register"},
 {0x38050, 0x38057,
  "AFEUEMR—AFEU end of message register"},
 {0x38100, 0x381FF,
  "AFEU context memory registers"},
 {0x38200, 0x38207,
  "AFEU context memory pointers"},
 {0x38400, 0x38407,
  "AFEUK0—AFEU key register 0"},
 {0x38408, 0x3840F,
  "AFEUK1—AFEU key register 1"},
 {0x38800, 0x38FFF,
  "AFEU FIFO"},
 {0x3A000, 0x3A007,
  "RNGMR—RNG mode register"},
 {0x3A010, 0x3A017,
  "RNGDSR—RNG data size register"},
 {0x3A018, 0x3A01F,
  "RNGRCR—RNG reset control register"},
 {0x3A028, 0x3A02F,
  "RNGSR—RNG status register"},
 {0x3A030, 0x3A037,
  "RNGISR—RNG interrupt status register"},
 {0x3A038, 0x3A03F,
  "RNGICR—RNG interrupt control register"},
 {0x3A050, 0x3A057,
  "RNGEUG—RNG EU-Go register"},
 {0x3A800, 0x3AFFF,
  "RNG FIFO"},
 {0x3C000, 0x3C007,
  "PKEUMR—PKEU mode register"},
 {0x3C008, 0x3C00F,
  "PKEUKSR—PKEU key size register"},
 {0x3C010, 0x3C017,
  "PKEUDSR—PKEU data size register"},
 {0x3C018, 0x3C01F,
  "PKEURCR—PKEU reset control register"},
 {0x3C028, 0x3C02F,
  "PKEUSR—PKEU status register"},
 {0x3C030, 0x3C037,
  "PKEUISR—PKEU interrupt status register"},
 {0x3C038, 0x3C03F,
  "PKEUICR—PKEU interrupt control register"},
 {0x3C040, 0x3C047,
  "PKEUABS—PKEU AB size register"},
 {0x3C050, 0x3C057,
  "PKEUEUG—PKEU EU-Go"},
 {0x3C200, 0x3C23F,
  "PKEU parameter memory A0"},
 {0x3C240, 0x3C27F,
  "PKEU parameter memory A1"},
 {0x3C280, 0x3C2BF,
  "PKEU parameter memory A2"},
 {0x3C2C0, 0x3C2FF,
  "PKEU parameter memory A3"},
 {0x3C300, 0x3C33F,
  "PKEU parameter memory B0"},
 {0x3C340, 0x3C37F,
  "PKEU parameter memory B1"},
 {0x3C380, 0x3C3BF,
  "PKEU parameter memory B2"},
 {0x3C3C0, 0x3C3FF,
  "PKEU parameter memory B3"},
 {0x3C400, 0x3C4FF,
  "PKEU parameter memory E"},
 {0x3C800, 0x3C8FF,
  "PKEU parameter memory N"},
 {0x3C900, 0x99999,
  "Out of range"},
 {0x100000, 0x100000, 0}
};
