# MIPS32 DSP REV 2 ASE test
# mach:  mips32r2 mips64r2
#as:		-mdspr2
#ld:		-N -Ttext=0x80010000
#output:	*\\npass\\n

# Copyright (C) 2006 MIPS Technologies, Inc.
# All rights reserved.
# Contributed by Chao-ying Fu (fu@mips.com).
#
# This file is part of the GNU simulators.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

	.include "testutils.inc"
	.include "utils-dsp.inc"

	setup

	.set noreorder

	.ent DIAG
DIAG:

	writemsg "[1] Test absq_s.qb"
	dspck_dsio absq_s.qb, 0x40670106, 0xc099ff06, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x00000000, 0x00000000, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x001c0205, 0x001c0205, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x000e0001, 0x000e00ff, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x01000101, 0x0100ff01, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x03000204, 0x030002fc, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x1d060400, 0xe3060400, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x0019017f, 0x0019ff81, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x00716e1d, 0x007192e3, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x77060003, 0x77060003, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x6100011a, 0x9f00ff1a, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x06017d00, 0x06ff8300, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x54010601, 0x54ff0601, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x10000101, 0xf000ffff, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x6b7d0001, 0x6b8300ff, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x01550101, 0x0155ffff, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x20014900, 0xe0ff4900, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x00086000, 0x00f86000, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x72030102, 0x8efdff02, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x00720079, 0x008e0087, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x1f496115, 0x1f499f15, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x10010000, 0x10ff0000, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x7f010700, 0x8001f900, 0x00000000, 0x00100000
	dspck_dsio absq_s.qb, 0x4141017e, 0x41bfff7e, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x6d3f0156, 0x6d3fffaa, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x0103091f, 0x010309e1, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x010e400d, 0xff0e40f3, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x01060101, 0xff06ff01, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x047f0240, 0xfc81fec0, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x78141d01, 0x7814e3ff, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x25000000, 0xdb000000, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x00040200, 0x00fc0200, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x003f0207, 0x003f0207, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x000d0140, 0x000dffc0, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x7100001e, 0x7100001e, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x0101401a, 0xffffc01a, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x660e0025, 0x660e00db, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x021b0100, 0x021b0100, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x00000f09, 0x00000f09, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x0100081c, 0xff00f81c, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x05000000, 0x05000000, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x00000000, 0x00000000, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x00000000, 0x00000000, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x21661801, 0xdf661801, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x3f013c01, 0x3fff3cff, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x01010101, 0xffffff01, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x00000103, 0x00000103, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x01340004, 0xffcc0004, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x01000104, 0x0100ff04, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x011f1011, 0xffe11011, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x08000001, 0x080000ff, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x00000000, 0x00000000, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x057f0200, 0x05810200, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x0c660001, 0x0c660001, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x72011c20, 0x8eff1ce0, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x0d007803, 0x0d007803, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x4a020070, 0xb6020070, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x21083c0e, 0xdf083c0e, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x563e0105, 0xaa3eff05, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x013c000d, 0xff3c00f3, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x01380104, 0xff380104, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x08006e35, 0x08009235, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x121b0100, 0x121bff00, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x79000301, 0x870003ff, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x0512616b, 0x05129f6b, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x0c010700, 0x0cff0700, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x6e0e0016, 0x920e0016, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x4a011901, 0xb6ffe7ff, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x02010902, 0x02fff702, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x393d0800, 0xc7c3f800, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x00070000, 0x00070000, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x00003400, 0x0000cc00, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x003c0000, 0x003c0000, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x00000900, 0x0000f700, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x01397f01, 0xffc780ff, 0x00000000, 0x00100000
	dspck_dsio absq_s.qb, 0x01000146, 0xff00ff46, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x01030000, 0xff030000, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x7f010119, 0x80ffffe7, 0x00000000, 0x00100000
	dspck_dsio absq_s.qb, 0x0f011c00, 0x0fff1c00, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x01491f0e, 0xff491f0e, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x00013e03, 0x00013e03, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x24000101, 0x2400ffff, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x000e3d00, 0x000e3d00, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x00000000, 0x00000000, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x00003d01, 0x00003d01, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x00000000, 0x00000000, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x4a031100, 0xb603ef00, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x0104026e, 0xfffc0292, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x00200d01, 0x0020f3ff, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x01133001, 0x011330ff, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x21710261, 0x218f029f, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x7b030300, 0x7b030300, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x30007801, 0x30007801, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x016e0104, 0xff92fffc, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x31014024, 0xcfff4024, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x03790457, 0x03870457, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x00010200, 0x00ff0200, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x00081c01, 0x00081cff, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x40011d61, 0x40ffe39f, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x7f406e41, 0x80c092bf, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x003d0001, 0x00c300ff, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x031c0701, 0x031c07ff, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x0f1e0145, 0x0f1eff45, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x3d1f1307, 0xc31f1307, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x26010003, 0x26ff0003, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x003d5501, 0x00c35501, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x02707f04, 0x02708004, 0x00000000, 0x00100000
	dspck_dsio absq_s.qb, 0x35190139, 0x35e7ffc7, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x007e0101, 0x007eff01, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x7f33013e, 0x7f33ff3e, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x40004006, 0x4000c006, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x00110100, 0x0011ff00, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x11300d0d, 0xef30f30d, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x15007f66, 0x15008066, 0x00000000, 0x00100000
	dspck_dsio absq_s.qb, 0x0c01041c, 0x0cff041c, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x02071800, 0x02071800, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x010b0100, 0xff0bff00, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x01010201, 0x01ff0201, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x00007f1f, 0x00007f1f, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x71011c00, 0x8f011c00, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x01071667, 0xff071699, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x00003f00, 0x0000c100, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x18010000, 0x18ff0000, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x40013701, 0xc0ff37ff, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x007f3e00, 0x00813e00, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x05000000, 0x05000000, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x0100215a, 0xff00df5a, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x00010101, 0x000101ff, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x0100046d, 0x0100046d, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x00180604, 0x00180604, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x00000000, 0x00000000, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x1a01070f, 0x1aff070f, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x0205011e, 0x0205ff1e, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x01000255, 0xff000255, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x66030030, 0x66030030, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x3e3f2406, 0x3e3f2406, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x00000000, 0x00000000, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x00330000, 0x00330000, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x100f0003, 0x10f10003, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x3f010119, 0xc10101e7, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x0e010000, 0x0eff0000, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x1c2b0107, 0x1c2b0107, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x7201081a, 0x8eff081a, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x71000303, 0x8f000303, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x04010102, 0x04ff0102, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x030d0c7d, 0x030d0c83, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x0001017c, 0x00ffff7c, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x017f5500, 0xff7f5500, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x00020101, 0x0002ff01, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x01010000, 0x01010000, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x08011720, 0xf8ff1720, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x00240120, 0x0024ffe0, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x0156210b, 0xffaadf0b, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x0f0e0101, 0xf10effff, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x00190067, 0x00e70099, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x10010107, 0xf0ff0107, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x01557e03, 0x01557e03, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x01017101, 0xffff7101, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x01003c56, 0xff003caa, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x05007001, 0x05007001, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x02021f08, 0x02021ff8, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x0033043f, 0x0033043f, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x00020101, 0x0002ff01, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x07150440, 0x071504c0, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x513f0024, 0x513f0024, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x71016101, 0x8f019fff, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x031e0e01, 0x031e0e01, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x7700060d, 0x770006f3, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x01033c06, 0x01033c06, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x0838061e, 0x0838061e, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x0300001d, 0x030000e3, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x00003d1f, 0x0000c3e1, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x00005649, 0x0000aa49, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x013f010a, 0xffc1ff0a, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x01030101, 0xff03ffff, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x30000001, 0x300000ff, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x010d4a02, 0xfff3b602, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x32020000, 0x32020000, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x31000407, 0xcf000407, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x1f010c00, 0xe1ff0c00, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x71037d00, 0x71038300, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x671c0004, 0x991c0004, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x00010001, 0x00ff00ff, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x00000f00, 0x00000f00, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x38400101, 0x384001ff, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x010e7002, 0xff0e7002, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x79000000, 0x87000000, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x18016e00, 0x18ff9200, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x003c1d7f, 0x003ce380, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x0001010d, 0x0001010d, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x1b30047f, 0x1b300480, 0x00000000, 0x00100000
	dspck_dsio absq_s.qb, 0x33370001, 0x333700ff, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x71003000, 0x8f003000, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x013f070e, 0xff3f070e, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x0101210d, 0xffffdff3, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x01020171, 0xff02ff8f, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x7d017200, 0x83ff8e00, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x10000401, 0x1000fc01, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x000d7e02, 0x00f37e02, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x00010101, 0x0001ffff, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x20000161, 0x2000019f, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x00030501, 0x000305ff, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x01010118, 0xffff0118, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x09000436, 0x09000436, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x21010100, 0xdfffff00, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x181e0100, 0x181eff00, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x09020911, 0x09fef7ef, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x05010100, 0x05ffff00, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x00000000, 0x00000000, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x61137201, 0x9f138e01, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x003f2400, 0x003f2400, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x7d3d0110, 0x833d01f0, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x700e1938, 0x700ee738, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x08011d01, 0xf801e3ff, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x01097f03, 0x01097f03, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x05070a3f, 0x05070a3f, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x01260600, 0x01260600, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x0d000200, 0xf3000200, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x02010939, 0x02ff09c7, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x070a0101, 0xf90a0101, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x2c000100, 0x2c00ff00, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x00010126, 0x00ffff26, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x01010172, 0xff01ff8e, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x01550f01, 0x01550fff, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x0f01003e, 0x0f01003e, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x1c010140, 0x1cff0140, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x00113f05, 0x00ef3f05, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x01303619, 0xff303619, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x00011c60, 0x00ff1c60, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x66010100, 0x66ffff00, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x1f00404b, 0x1f00c04b, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x0310016e, 0x03f00192, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x00000000, 0x00000000, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x2e310125, 0x2ecf01db, 0x00000000, 0x00000000
	dspck_dsio absq_s.qb, 0x0007007f, 0x00070080, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x30790a00, 0x30870a00, 0x00100000, 0x00100000
	dspck_dsio absq_s.qb, 0x00007806, 0x00007806, 0x00100000, 0x00100000

	writemsg "[2] Test addu.ph"
	dspck_dstio addu.ph, 0x7b52f3d9, 0x800ffffa, 0xfb43f3df, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0xedb67ff9, 0x80000000, 0x6db67ff9, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x8000f7fc, 0x8000fff9, 0x0000f803, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0x9a51405f, 0x9999007f, 0x00b83fe0, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0xc71cb3bd, 0xc71cb6db, 0x0000fce2, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0x371a7fe0, 0xffe08000, 0x373affe0, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0x807fc96a, 0x80002fd1, 0x007f9999, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x00000000, 0x00000000, 0x00000000, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x01bbca9a, 0xfff0c007, 0x01cb0a93, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0xdd03ff12, 0x00000005, 0xdd03ff0d, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x1e35ffff, 0x1c717fff, 0x01c48000, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0xff350ff8, 0xff35fffa, 0x00000ffe, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x3fc0fff0, 0x3fc07ff0, 0x00008000, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0xfb96fc96, 0xfbc8fc6f, 0xffce0027, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x7fe07fff, 0x00000000, 0x7fe07fff, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x800f82c5, 0x800f02c5, 0x00008000, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0xc0070000, 0xc0070000, 0x00000000, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x8000781b, 0x7ffff81b, 0x00018000, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0x4977ffff, 0x4924fffe, 0x00530001, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0xe02afffe, 0x000b7fff, 0xe01f7fff, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0x1c61e392, 0xfff0e38e, 0x1c710004, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0xfffb8012, 0x7fff7fff, 0x7ffc0013, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0xc003c002, 0x0000c001, 0xc0030001, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x0e377f19, 0x7fff7fff, 0x8e38ff1a, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0xf8020006, 0xfc018003, 0xfc018003, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0x1fe3fffe, 0x1fe07ffe, 0x00038000, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0xfb5d007e, 0xdb6d807f, 0x1ff07fff, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0xfffb000a, 0xfffb000a, 0x00000000, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0xfac1ff80, 0x003f7f80, 0xfa828000, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0x00007ffd, 0x00000000, 0x00007ffd, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x7ff2400e, 0xfff33ff8, 0x7fff0016, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0x009efff2, 0x801f0001, 0x807ffff1, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0xff040000, 0x107e0000, 0xee860000, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0xf003fffe, 0x00007fff, 0xf0037fff, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x80007ff9, 0x7fff7fff, 0x0001fffa, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0xb8e39fdf, 0x80007fff, 0x38e31fe0, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0xfffffff0, 0x80000000, 0x7ffffff0, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0x803f0000, 0x00000000, 0x803f0000, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0x6ea58000, 0x00ef0000, 0x6db68000, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0xfffa8004, 0xfffa7fff, 0x00000005, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x4007ffe4, 0x8000ffe4, 0xc0070000, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0xbfefe453, 0x3ff0e3d7, 0x7fff007c, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0x07187ffd, 0xf3e07fff, 0x1338fffe, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0xff36fffd, 0x00007ffd, 0xff368000, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0xf7fdffff, 0xf001ffff, 0x07fc0000, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0xffe20f1d, 0xffe2000e, 0x00000f0f, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0xfffcfffe, 0x00007fff, 0xfffc7fff, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x7ffd83a0, 0x00007fff, 0x7ffd03a1, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0x7ffe8000, 0x80000000, 0xfffe8000, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0x00fffffe, 0x00007fff, 0x00ff7fff, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0xbffb7fff, 0x7fff7fff, 0x3ffc0000, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0xfff9400a, 0x0000c003, 0xfff98007, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x800300ee, 0x8003ffeb, 0x00000103, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x7fa6fffd, 0xffa60002, 0x8000fffb, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0x7fff19c1, 0x7fff19c1, 0x00000000, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0xfff3ffff, 0x00017fff, 0xfff28000, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0xc00ffffe, 0x00007fff, 0xc00f7fff, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0x09050000, 0x09050000, 0x00000000, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0x003b003f, 0x002f8000, 0x000c803f, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x80008000, 0x00000000, 0x80008000, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x07fdffff, 0x07fc0000, 0x0001ffff, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0xffc13ffe, 0x00000000, 0xffc13ffe, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0x7ff7524a, 0xfff89249, 0x7fffc001, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0x7ff8ffff, 0xfff97fff, 0x7fff8000, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0xffc0ffe8, 0x00000000, 0xffc0ffe8, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x5cfcf0ff, 0x1ff0000f, 0x3d0cf0f0, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0x800c79bf, 0x7fff8000, 0x000df9bf, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0xfff303fc, 0x3ff00000, 0xc00303fc, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0xfb2eff54, 0x1b27ffc7, 0xe007ff8d, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0xbffe7fff, 0x3ffe0000, 0x80007fff, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x217d601f, 0x1fe0e01f, 0x019d8000, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0x80007ffe, 0x7fff8000, 0x0001fffe, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0xbfbd8000, 0x3fc08000, 0x7ffd0000, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x80000007, 0x80000007, 0x00000000, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0xffffffff, 0x80008000, 0x7fff7fff, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x33330001, 0x33330002, 0x0000ffff, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x03f77fff, 0xfff90000, 0x03fe7fff, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0x1fa1c71c, 0x1fa10000, 0x0000c71c, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x80007ff7, 0x00007fff, 0x8000fff8, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0x5552fff0, 0x55550000, 0xfffdfff0, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0xfe5b8039, 0x044b8000, 0xfa100039, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0x0000dfff, 0x0000e001, 0x0000fffe, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0xff781062, 0x7f800ffe, 0x7ff80064, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x04fdfffe, 0x00ff7fff, 0x03fe7fff, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0x0e3e835f, 0x8e388000, 0x8006035f, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0xff803ffd, 0x7f803ffe, 0x8000ffff, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0xfffc7ffd, 0x0001fffd, 0xfffb8000, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0x7f7e7fff, 0x7ffeffff, 0xff808000, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0xb8e38008, 0x80007fff, 0x38e30009, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x807f0084, 0x807f007f, 0x00000005, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0x000500fa, 0x0000fffb, 0x000500ff, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0xfffcc00f, 0x7fffc00f, 0x7ffd0000, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0x5fe03fb5, 0x1ff0ffb7, 0x3ff03ffe, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0xfffafff9, 0xfffb8000, 0xffff7ff9, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0x9026fc12, 0x807f0000, 0x0fa7fc12, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0xa0080717, 0xc0070717, 0xe0010000, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0x7fe0f803, 0xffe0f801, 0x80000002, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0x1ffcfff8, 0x1ffc7ff9, 0x00007fff, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0xfe703fff, 0xffff3ffe, 0xfe710001, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0x000f001f, 0x800f0000, 0x8000001f, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0x4051fac5, 0x3ff8fd71, 0x0059fd54, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0x7ff6ffc0, 0x7ff9ffc0, 0xfffd0000, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x474280b4, 0xfe1e8000, 0x492400b4, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x0562089a, 0x0598ff63, 0xffca0937, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0xf42c7fc1, 0x00007fc0, 0xf42c0001, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0x8cc70602, 0x800007fe, 0x0cc7fe04, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0x7ff07ffa, 0x7ff0fffa, 0x00008000, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0xd59400cc, 0x803f00ca, 0x55550002, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x80008e38, 0x80008e38, 0x00000000, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x000d8000, 0x00020000, 0x000b8000, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0xff0e7dc5, 0xfffffdc6, 0xff0f7fff, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0x7ffaff74, 0xfffbff81, 0x7ffffff3, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0x7fffffd0, 0x7fffffd0, 0x00000000, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0x0000a00d, 0x0000800f, 0x00001ffe, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0x92477ff8, 0xfffe7ff8, 0x92490000, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0x8ff8fffc, 0x0ffe0000, 0x7ffafffc, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x001e4924, 0x002c0000, 0xfff24924, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0xfffe001e, 0xffff000f, 0xffff000f, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x7f7e0187, 0x7f800000, 0xfffe0187, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0x0002400f, 0x0000c00f, 0x00028000, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x003ffff8, 0x00008000, 0x003f7ff8, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0xfff8807f, 0x00000000, 0xfff8807f, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x7ffffff2, 0x00000000, 0x7ffffff2, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x0002e401, 0x0000e003, 0x000203fe, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0xc924009d, 0x8000009c, 0x49240001, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0xfb3d8129, 0xfb380129, 0x00058000, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0xf1301fb3, 0x00d2ffd3, 0xf05e1fe0, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x7ff57fbc, 0x80007f80, 0xfff5003c, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0x06a880dd, 0x06a100de, 0x00077fff, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0xffdf38e6, 0x7fe00003, 0x7fff38e3, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x80008003, 0x80007fff, 0x00000004, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x8003fd4e, 0x0004fce2, 0x7fff006c, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0x099e0ffd, 0x07fef001, 0x01a01ffc, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0xc00f7fff, 0xc00f0000, 0x00007fff, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x00077ff6, 0x0000fff6, 0x00078000, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x3ff01082, 0x00000084, 0x3ff00ffe, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x00eb007e, 0x00ac807f, 0x003f7fff, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0xc9230041, 0x7fff803f, 0x49248002, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0x8006d804, 0x8000e001, 0x0006f803, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x38e3fb2c, 0x38e30004, 0x0000fb28, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0x0f0fc718, 0x0f0ffffc, 0x0000c71c, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0xffff7ff7, 0x8000fff8, 0x7fff7fff, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0x8097c01b, 0x00880014, 0x800fc007, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0x1249004a, 0x92490000, 0x8000004a, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0xfff90001, 0xfff87fff, 0x00018002, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x2842bfe0, 0xe8468000, 0x3ffc3fe0, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x1591bff8, 0xffeb8000, 0x15a63ff8, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0x003e08b2, 0x7fff094d, 0x803fff65, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0xd01d9c49, 0xc01f7fff, 0x0ffe1c4a, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0xffe72810, 0xffe9ef2d, 0xfffe38e3, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0x0000b8ea, 0x000038e3, 0x00008007, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0x0f1e2ea6, 0x078f1753, 0x078f1753, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0x80048000, 0x00000000, 0x80048000, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x803ff003, 0x003f0000, 0x8000f003, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0xff00db6b, 0xff00fffe, 0x0000db6d, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0x80007ffe, 0x00007fff, 0x8000ffff, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0x003ffcbc, 0x8000fcbf, 0x803ffffd, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0x7fffe01f, 0x7fffe01f, 0x00000000, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0x00018000, 0x00018000, 0x00000000, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x0001469d, 0x8000069f, 0x80013ffe, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x0002d959, 0x00009999, 0x00023fc0, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0xfffefffa, 0x7fff7fff, 0x7fff7ffb, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x7f5eff70, 0x80000070, 0xff5eff00, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x7fc0fcdb, 0x8000fc9f, 0xffc0003c, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0xc0128000, 0xc00f0000, 0x00038000, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x00320000, 0x00320000, 0x00000000, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0xeeb5f9dc, 0xeeb5f9dc, 0x00000000, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0xffe8ff35, 0xffe90000, 0xffffff35, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0xfeff7fff, 0x0e7d7fff, 0xf0820000, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0x192cf0f0, 0x2b380000, 0xedf4f0f0, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0x100cbc25, 0x0ffc3c25, 0x00108000, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0x00247ff0, 0x001f0000, 0x00057ff0, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0xe666c91e, 0x66664924, 0x80007ffa, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x99997ffe, 0x00008000, 0x9999fffe, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0x8002ffe6, 0x00010000, 0x8001ffe6, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0xff4d006c, 0x00000000, 0xff4d006c, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0x7fffffff, 0x00007fff, 0x7fff8000, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x70f00000, 0xf0f0fffa, 0x80000006, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0xffff1c71, 0x80001c71, 0x7fff0000, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0x00000051, 0x80000051, 0x80000000, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0xf7fd800e, 0xf801000f, 0xfffc7fff, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0xffff0003, 0x7fff0000, 0x80000003, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0x7ffdffff, 0x80007fff, 0xfffd8000, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0x0405ccdb, 0x0007cccc, 0x03fe000f, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0x07ee8000, 0x00000000, 0x07ee8000, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0xfe7506d9, 0x000007fe, 0xfe75fedb, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x80068000, 0x80000000, 0x00068000, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0x7fa0f342, 0x3fc0f1c8, 0x3fe0017a, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0x4fdc6000, 0x3fe0e001, 0x0ffc7fff, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x80000002, 0x80000002, 0x00000000, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x7ffc7fd0, 0x80007fe0, 0xfffcfff0, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0xe86683ca, 0xc86803cb, 0x1ffe7fff, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0xffffebf1, 0x8000f0b6, 0x7ffffb3b, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0xffc0b6db, 0xffc0b6db, 0x00000000, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0x80003ffe, 0x00000000, 0x80003ffe, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x00000000, 0x00000000, 0x00000000, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x803f7fa5, 0x80008000, 0x003fffa5, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0x27f67fe5, 0x07fe7fff, 0x1ff8ffe6, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0x87fed555, 0x80005555, 0x07fe8000, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0x00000ffe, 0x00000000, 0x00000ffe, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x7fa5c0f9, 0x7fffc003, 0xffa600f6, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0xbff32062, 0x3ff01ff0, 0x80030072, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x00000060, 0x00000000, 0x00000060, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0xfedc0000, 0xff6e8000, 0xff6e8000, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0xd9ffffff, 0x03fe0000, 0xd601ffff, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0x21398005, 0x168b8007, 0x0aaefffe, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0x00010004, 0x00000004, 0x00010000, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0xc001ffff, 0xc0017fff, 0x00008000, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0xffff8007, 0x7fff8000, 0x80000007, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x7ff00fbe, 0x00000fb7, 0x7ff00007, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0x1ffcffc0, 0x00000000, 0x1ffcffc0, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0x803f0000, 0x803f8000, 0x00008000, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0xb0f171b8, 0xc00171c7, 0xf0f0fff1, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x0405801e, 0x00078000, 0x03fe001e, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x7fe47fff, 0xffe4ffff, 0x80008000, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0x8127fffd, 0x01270001, 0x8000fffc, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0xffeea4fa, 0xfffe71c7, 0xfff03333, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0x60020106, 0x7ffffffd, 0xe0030109, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0xfffe7ffe, 0x7ffffffe, 0x7fff8000, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0xff368390, 0x00000390, 0xff368000, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0xb6db3ffd, 0x00003ffe, 0xb6dbffff, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0xc01cfffe, 0xc01ffffd, 0xfffd0001, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x0f0f8000, 0x0f0f8000, 0x00000000, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0x70c77e01, 0x71c77fff, 0xff00fe02, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0x021b8000, 0x00000000, 0x021b8000, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0xe01ffb12, 0xe01fffff, 0x0000fb13, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0xc9260138, 0x4924ffb6, 0x80020182, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0x85c47fff, 0x7ff97fff, 0x05cb0000, 0x00000000, 0x00000000
	dspck_dstio addu.ph, 0xfaba2aae, 0xfab9aaaa, 0x00018004, 0x00100000, 0x00100000
	dspck_dstio addu.ph, 0xbf32807f, 0xc001007f, 0xff318000, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0x00070006, 0x80070000, 0x80000006, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0x8002e38b, 0x0003e38e, 0x7ffffffd, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0xffdf7fff, 0x7fe08000, 0x7fffffff, 0x00000000, 0x00100000
	dspck_dstio addu.ph, 0x04e4b8dd, 0xffc938e3, 0x051b7ffa, 0x00000000, 0x00100000

	writemsg "[3] Test addu_s.ph"
	dspck_dstio addu_s.ph, 0x8007804c, 0x80007fff, 0x0007004d, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0xffff8005, 0xf2d97fff, 0xffec0006, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0x0000fe78, 0x00000d88, 0x0000f0f0, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0xffffa001, 0xfffc8003, 0x07fe1ffe, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0xffffffff, 0xfffafbb5, 0x8000febc, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xfffffffe, 0x7fff0000, 0x8000fffe, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0xffffffff, 0x3fc08000, 0xfff8807f, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0x28695555, 0x00040000, 0x28655555, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0x80f1a195, 0x00f207fc, 0x7fff9999, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xfffe801e, 0x7fff001f, 0x7fff7fff, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0x00017fff, 0x00017fff, 0x00000000, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0x8000807d, 0x7fff007f, 0x00017ffe, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0xffff007f, 0x80000000, 0x8e38007f, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0xffe68ff5, 0x00000ffc, 0xffe67ff9, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0x84647fff, 0x04657fff, 0x7fff0000, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xfffb9fef, 0xfff81ff0, 0x00037fff, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0xffffffff, 0xfff87fff, 0x7ffc8006, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xfff87fff, 0xfff87fff, 0x00000000, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0x81eaffff, 0x7fffcccc, 0x01eb807f, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0xffff0005, 0x7fff0005, 0xfffd0000, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0xbff81029, 0x3ff80031, 0x80000ff8, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0xffff0008, 0x80000004, 0x80000004, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0xc0e4ffff, 0xc0078000, 0x00dd8000, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0x85e97fcf, 0x8000000f, 0x05e97fc0, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xfff3f003, 0x0003f003, 0xfff00000, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xfffffdd1, 0xfffc0000, 0x0007fdd1, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0xa491e01b, 0x24921ffc, 0x7fffc01f, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0xa0770025, 0x807f0000, 0x1ff80025, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0x0008ff2d, 0x0008ff2d, 0x00000000, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0xfffffffe, 0x80007fff, 0x7fff7fff, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0x0006000d, 0x00060007, 0x00000006, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xdcf3ffff, 0x1ce4f801, 0xc00fffff, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0x8000e03d, 0x00061ffe, 0x7ffac03f, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0x2017b6db, 0x1fe00000, 0x0037b6db, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xffff738e, 0xfff101c7, 0x7fff71c7, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0xfff5ffff, 0xfff2f80a, 0x00037fff, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0xffff0014, 0xc71c0000, 0x7fff0014, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xfffaffff, 0x0000ff07, 0xfffa0e69, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xff67b332, 0xff673333, 0x00007fff, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xffffffff, 0xe003ebdd, 0xf0e5fc3a, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0xffffffff, 0xfc017fff, 0xfffd8000, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0x00010000, 0x00000000, 0x00010000, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0xffffffff, 0xc0077fff, 0x8000ffbb, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xfff00005, 0xfff00005, 0x00000000, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0x000fffff, 0x0000ff03, 0x000fffff, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0x0086ffff, 0x007ffebd, 0x0007aaaa, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xbffdf92c, 0x3ffe000c, 0x7ffff920, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0xfff90004, 0x00000002, 0xfff90002, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0x0015bffe, 0x00033ffe, 0x00128000, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xbfbf80b1, 0x3fc000b2, 0x7fff7fff, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0x0000000f, 0x0000000f, 0x00000000, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0xfffffffe, 0x000f0000, 0xfff9fffe, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xfffeffff, 0x0000f889, 0xfffefffe, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0x800df007, 0x8000f007, 0x000d0000, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0xffffffff, 0xf001ffff, 0x80008000, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0x3ffef93e, 0x3ffef93e, 0x00000000, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0xff7fffff, 0x7f807fff, 0x7fffc01f, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xffffffff, 0xf50cfc94, 0xfec87f80, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0x0000ffff, 0x00008000, 0x0000aaaa, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xffff8004, 0x7ffc0001, 0xffff8003, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0x804307c7, 0x800007c7, 0x00430000, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0x8012ffff, 0x00127ff8, 0x8000c001, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0xffff07fe, 0xfe1107fe, 0xff790000, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0x808d0ffe, 0x008d0002, 0x80000ffc, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xffff8062, 0xfffe8000, 0xfff90062, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xffffffff, 0x8000f801, 0xffe97fff, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0x00420689, 0x00000000, 0x00420689, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xffffffff, 0xe003fffd, 0x7ffff003, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0x7fff0004, 0x00000004, 0x7fff0000, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xffffffff, 0x7fffc007, 0x80007fff, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0x223fff18, 0x05ce0001, 0x1c71ff17, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0x27eeffff, 0x1ff07fff, 0x07fedb6d, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0x8000f977, 0x80000023, 0x0000f954, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0xffffa492, 0x80008000, 0xffe72492, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0x801cffff, 0x001cffff, 0x80000000, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xffff7fff, 0x99990000, 0x92497fff, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xfff81d5c, 0xfff81d5c, 0x00000000, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0xffffffff, 0xfffe8000, 0x000ffffe, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0x0002fffe, 0x00020000, 0x0000fffe, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xffff8000, 0x80000000, 0xfff48000, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0xfc01ffff, 0x0000fff1, 0xfc01cd65, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0x00210000, 0x001f0000, 0x00020000, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xbfc0ffff, 0x3fc07fff, 0x80008000, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0xffffe08e, 0xffcee00f, 0x1ff0007f, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xfff90000, 0x7ffa0000, 0x7fff0000, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xfffeffff, 0xfffef95b, 0x00008000, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xffffffff, 0x7fffe007, 0xfff98000, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0xfffffffe, 0x7fff0000, 0x8006fffe, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xfffa0000, 0x7ffd0000, 0x7ffd0000, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0x6db7ffff, 0x6db60675, 0x0001f98d, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0xffff07fc, 0x7fff0000, 0x800007fc, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0xffffffff, 0xfff9ff5c, 0x807f8000, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xffffffff, 0x07fcf001, 0xfffe8000, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0xff82ffff, 0xff827fff, 0x00008002, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xfca6ffff, 0xfc01c01f, 0x00a5cab9, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0xea55ffdf, 0x0ee80000, 0xdb6dffdf, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0x83fe0dbb, 0x03fe0710, 0x800006ab, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0xffffffff, 0x8002c71c, 0xfff9ffff, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0xffffc00f, 0xfffd0000, 0x00a0c00f, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0xffff000c, 0xfffa0004, 0xff7a0008, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0xffff8014, 0x80000014, 0xfffa8000, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xffffc71c, 0xffff0000, 0x8000c71c, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0x3fccffff, 0x3fc0801f, 0x000c8000, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0xffffd34c, 0xffff1c71, 0xfffab6db, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xff80ffff, 0x80001ce2, 0x7f80ffff, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0xffff107d, 0x7fff0ffe, 0xff9a007f, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xffff0005, 0x80000000, 0xfa280005, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0x8013cccd, 0x7fffcccc, 0x00140001, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0xffffff80, 0x80000000, 0x8001ff80, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0x8ff8f49f, 0x0ff8f499, 0x80000006, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0xfc38ffff, 0x00007fff, 0xfc38ffec, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0xffffffe0, 0xaaaa8000, 0x80007fe0, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0xfffeffff, 0x7ffffff9, 0x7fff8000, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0xfc56ff89, 0x003f0018, 0xfc17ff71, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0x81407fc0, 0x80007fc0, 0x01400000, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0xffff07fc, 0x800f0000, 0x800007fc, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0xc0038003, 0x00000000, 0xc0038003, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0xffffffff, 0xf0037fff, 0xfffdfff9, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xfffffff3, 0xc03f0003, 0x6666fff0, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0xfffffffe, 0x80007fff, 0xff547fff, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0x04d88000, 0x00520000, 0x04868000, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0x78dfaaaa, 0x38e3aaaa, 0x3ffc0000, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0xffff2f11, 0xffc62f11, 0xc00f0000, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0x0071ffff, 0x006af001, 0x00071c71, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xffffffff, 0x80008000, 0x8000ffc0, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0x555f0001, 0x55550001, 0x000a0000, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0x405d7fff, 0x3ffc7fff, 0x00610000, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0x00018000, 0x00018000, 0x00000000, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xffffffff, 0xc007c01f, 0x7fffaaaa, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xffff0000, 0x80000000, 0x80000000, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0x80000000, 0x80000000, 0x00000000, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xffff0ff8, 0xfffd0ff8, 0xffce0000, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0x0001f003, 0x0001f003, 0x00000000, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0x000500ff, 0x000500ff, 0x00000000, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xffff0009, 0xfffd0009, 0xff410000, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xffffffff, 0xe001fe20, 0xe001fe20, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xffffffff, 0xfffc7fff, 0x000d8000, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0xffff0014, 0x1ff80005, 0xfff9000f, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xffffcfff, 0x80070ffc, 0xfe29c003, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0xffffffff, 0x7fffffd1, 0x8000fcc2, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0xfffffff9, 0xfffc7fff, 0x3fe07ffa, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0xffffffff, 0xfffdf003, 0xfffec01f, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0xf3ce8050, 0xaaaa7fff, 0x49240051, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0x08198000, 0x00000000, 0x08198000, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0x8622ffff, 0x06228002, 0x8000f803, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0x8007aab9, 0x0000000f, 0x8007aaaa, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0x01b9f9cd, 0x0000f9be, 0x01b9000f, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xbfe0ff8c, 0x3fe000c2, 0x8000feca, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xffff3ff8, 0xffff3ff8, 0x00000000, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0x00ad0002, 0x007e0001, 0x002f0001, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0xffffcd46, 0xf262cccc, 0x8000007a, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xffff800c, 0xfffd000d, 0x00a97fff, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xffffffff, 0x80008000, 0xff95f003, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0x87fc0003, 0x07fc0003, 0x80000000, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0xffff0004, 0x80000002, 0x80000002, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xdb6fffff, 0xdb6dfffb, 0x00027fff, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0x3ffb8000, 0x00030000, 0x3ff88000, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xffff87fe, 0x800007fe, 0x801f8000, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0xffff9156, 0x800f1156, 0x803f8000, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0x08020007, 0x00060007, 0x07fc0000, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xe003f410, 0xe003f409, 0x00000007, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0x800e9ffc, 0x7fff8000, 0x000f1ffc, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0xffffffff, 0xb6db7fff, 0xe01f8000, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xfffa1ff0, 0xfffa1ff0, 0x00000000, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0xffffffff, 0xffb67fff, 0xfff68001, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0xfffe8002, 0xfffe7fff, 0x00000003, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0x0099ffff, 0x00990004, 0x0000fffe, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xffffffd1, 0xfff9ffd1, 0xff800000, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0x03adffff, 0x0003fffe, 0x03aa7fff, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0xfffeb8e2, 0x7fff7fff, 0x7fff38e3, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0x8004fffe, 0x80047fff, 0x00007fff, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0xfff98e59, 0x00008e38, 0xfff90021, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xff068000, 0xff008000, 0x00060000, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xffffffff, 0x8000ff47, 0xfff4f001, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0xffffdb6d, 0x9999db6d, 0x80000000, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0x8a67ffff, 0x0a68f003, 0x7fff1ff8, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0x3b4a00de, 0x00000001, 0x3b4a00dd, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xffff1fe0, 0x11900000, 0xf8011fe0, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0x80008000, 0x80008000, 0x00000000, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0x81e61555, 0x01e70005, 0x7fff1550, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0x0ffd0000, 0x00050000, 0x0ff80000, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0xfffc001f, 0xfff3001e, 0x00090001, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0x80000801, 0x000107fe, 0x7fff0003, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0x4bd80002, 0x25ec0001, 0x25ec0001, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0xffffffff, 0xc00ff754, 0xfefb7fff, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0x00498ff6, 0x000a0ff8, 0x003f7ffe, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0x0000f003, 0x00000000, 0x0000f003, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0xffffffff, 0x8000fff9, 0xffff800f, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0x0000faa5, 0x0000faa5, 0x00000000, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xffffffff, 0xe0078000, 0xf8497fff, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xffff100d, 0xfff90015, 0x80000ff8, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0xffffffff, 0xfffd8000, 0x8000fffc, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0x001280f2, 0x00008000, 0x001200f2, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xffff02c4, 0x80000162, 0x80000162, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0x0065ffff, 0x0065fff0, 0x0000ffd4, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0xffffffff, 0xffc07fff, 0xfffaffff, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0x07ffffff, 0x0003ff92, 0x07fcfffa, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0xffffffff, 0x7ffff801, 0x80005555, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xfcf3ffff, 0xfcb4ef00, 0x003f8000, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0xfb0e0016, 0xf0010016, 0x0b0d0000, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0x000fffcf, 0x00000000, 0x000fffcf, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xffff00ef, 0xfeef00e8, 0x7ff80007, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0x02f97fc0, 0x02f97fc0, 0x00000000, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0xffff0025, 0xfffc0006, 0x0094001f, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xffffffff, 0xfffd7fff, 0x24928000, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xffffff53, 0xff90ff48, 0x06c1000b, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0x7fffbff8, 0x7fff8000, 0x00003ff8, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xffffffff, 0x8000e003, 0x80008000, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0x7fffffff, 0x00007fff, 0x7ffff3b3, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0xffff4001, 0xfffc3ffe, 0x7fff0003, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0x8019ffff, 0x8000ffef, 0x0019f2cb, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0x00007fff, 0x00000000, 0x00007fff, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0x00008000, 0x00000000, 0x00008000, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xffffffff, 0xfffcc71c, 0x9999fffa, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0xffff800e, 0x71c7000f, 0xfe127fff, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0x000dffff, 0x000d8000, 0x00007fff, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0x3ffc001b, 0x3ffc001b, 0x00000000, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0xffffffff, 0xffff8000, 0x0f0f8000, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0x7ff8ffff, 0x3ffcffc0, 0x3ffcffc0, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0xffffffff, 0xff36fe6c, 0x8e387fc0, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xffffffff, 0xc00fff4c, 0x80007ff9, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0xffffffc0, 0xff000000, 0xfffeffc0, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0x8000ffff, 0x8000e74a, 0x0000f007, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0x07fcffff, 0x0000ffb9, 0x07fcfffe, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0x8000fe8a, 0x8000fe8a, 0x00000000, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0xffffffff, 0x7ffcf001, 0xffff8000, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0x80e783fe, 0x00c88000, 0x801f03fe, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0xffffbde1, 0xb6db0706, 0x8000b6db, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xffffffff, 0x7ffe9999, 0xfffffff0, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xffff8000, 0x7ffb0000, 0xf1a08000, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0x81e5018e, 0x7ff000be, 0x01f500d0, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0x8000fffe, 0x80007fff, 0x00007fff, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0xffff7fff, 0xc01f7fff, 0xffd20000, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0x3ffeffff, 0x3ffeff42, 0x00005555, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xffffb6dd, 0x7fff0002, 0x807fb6db, 0x00100000, 0x00100000
	dspck_dstio addu_s.ph, 0xe38e0054, 0x00000000, 0xe38e0054, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0xf0f0eaa6, 0x00003ffc, 0xf0f0aaaa, 0x00000000, 0x00000000
	dspck_dstio addu_s.ph, 0x8000ffff, 0x0000ffd0, 0x8000e001, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0xffff5555, 0xc00f5555, 0xc03f0000, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0xffffffff, 0x7ffffffc, 0xdb6d807f, 0x00000000, 0x00100000
	dspck_dstio addu_s.ph, 0xea6821cc, 0x0a651ff0, 0xe00301dc, 0x00000000, 0x00000000

	writemsg "[4] Test adduh.qb"
	dspck_dstio adduh.qb, 0x8da5b67e, 0x1c7e6f00, 0xffccfefc, 0x0, 0x0
	dspck_dstio adduh.qb, 0x001f005b, 0x01000000, 0x003e00b6, 0x0, 0x0
	dspck_dstio adduh.qb, 0x00b2386a, 0x006600c7, 0x00ff700e, 0x0, 0x0
	dspck_dstio adduh.qb, 0x3ebe7905, 0x7c7e000b, 0x00fff300, 0x0, 0x0
	dspck_dstio adduh.qb, 0xe766078e, 0xf00006ff, 0xdfcc091e, 0x0, 0x0
	dspck_dstio adduh.qb, 0x810e0182, 0x03000005, 0xff1d03ff, 0x0, 0x0
	dspck_dstio adduh.qb, 0x070257a4, 0x0f047f92, 0x000030b6, 0x0, 0x0
	dspck_dstio adduh.qb, 0x0086aa55, 0x00e35501, 0x0029ffaa, 0x0, 0x0
	dspck_dstio adduh.qb, 0xa800279d, 0xff003cff, 0x5200123c, 0x0, 0x0
	dspck_dstio adduh.qb, 0x7f4702ad, 0xf90000db, 0x068e057f, 0x0, 0x0
	dspck_dstio adduh.qb, 0x0f5c6034, 0x1eaa002a, 0x010ec03e, 0x0, 0x0
	dspck_dstio adduh.qb, 0xa16f8054, 0x83db0125, 0xc003ff83, 0x0, 0x0
	dspck_dstio adduh.qb, 0x8bff3738, 0xffff6600, 0x17ff0971, 0x0, 0x0
	dspck_dstio adduh.qb, 0x3638797f, 0x6d71c000, 0x000032ff, 0x0, 0x0
	dspck_dstio adduh.qb, 0x7f1f9d00, 0xff3f3c00, 0x0000ff00, 0x0, 0x0
	dspck_dstio adduh.qb, 0x8a4c3700, 0x15996400, 0xff000a00, 0x0, 0x0
	dspck_dstio adduh.qb, 0x8100000f, 0x03000002, 0xff00001d, 0x0, 0x0
	dspck_dstio adduh.qb, 0x680d79c1, 0xcf0302b6, 0x0218f1cc, 0x0, 0x0
	dspck_dstio adduh.qb, 0x00004300, 0x00000000, 0x00008700, 0x0, 0x0
	dspck_dstio adduh.qb, 0x7f190a09, 0x00300f13, 0xff030600, 0x0, 0x0
	dspck_dstio adduh.qb, 0x6fff0c09, 0x83ff0305, 0x5cff160e, 0x0, 0x0
	dspck_dstio adduh.qb, 0x067f1d57, 0x0600033f, 0x06ff3870, 0x0, 0x0
	dspck_dstio adduh.qb, 0x8507bfd4, 0xef0f80aa, 0x1c00fffe, 0x0, 0x0
	dspck_dstio adduh.qb, 0x7e03027f, 0xfd0705ff, 0x00000000, 0x0, 0x0
	dspck_dstio adduh.qb, 0xd74ee096, 0xbf0ac366, 0xef92fdc7, 0x0, 0x0
	dspck_dstio adduh.qb, 0x479c8089, 0x003a8014, 0x8eff80ff, 0x0, 0x0
	dspck_dstio adduh.qb, 0x38088540, 0x66000c81, 0x0a11ff00, 0x0, 0x0
	dspck_dstio adduh.qb, 0x00bd22e3, 0x00ff01ff, 0x007c44c7, 0x0, 0x0
	dspck_dstio adduh.qb, 0x7e997f42, 0x00330060, 0xfcffff24, 0x0, 0x0
	dspck_dstio adduh.qb, 0xff9907be, 0xffff0eff, 0xff33007e, 0x0, 0x0
	dspck_dstio adduh.qb, 0xef004f80, 0xdf001f01, 0xff0080ff, 0x0, 0x0
	dspck_dstio adduh.qb, 0x157e0049, 0x2afd0000, 0x00000092, 0x0, 0x0
	dspck_dstio adduh.qb, 0x21033b66, 0x03004400, 0x400633cc, 0x0, 0x0
	dspck_dstio adduh.qb, 0x0b6ac342, 0x0f54ff05, 0x0781877f, 0x0, 0x0
	dspck_dstio adduh.qb, 0x4aed7e7a, 0x8fe3f778, 0x06f8067c, 0x0, 0x0
	dspck_dstio adduh.qb, 0x7f06807f, 0x000cff00, 0xff0001ff, 0x0, 0x0
	dspck_dstio adduh.qb, 0x83bbff01, 0x08f8ff02, 0xff7eff01, 0x0, 0x0
	dspck_dstio adduh.qb, 0x7d387fb8, 0xf37000ff, 0x0700ff71, 0x0, 0x0
	dspck_dstio adduh.qb, 0x06030066, 0x040600cc, 0x09000000, 0x0, 0x0
	dspck_dstio adduh.qb, 0x0c160400, 0x00030100, 0x18290800, 0x0, 0x0
	dspck_dstio adduh.qb, 0x12000c85, 0x23000e3e, 0x02010bcc, 0x0, 0x0
	dspck_dstio adduh.qb, 0x04aa0800, 0x04aa0800, 0x04aa0800, 0x0, 0x0
	dspck_dstio adduh.qb, 0x89fb0001, 0x92ff0103, 0x81f80000, 0x0, 0x0
	dspck_dstio adduh.qb, 0xa97f2212, 0xc1ff3800, 0x92000c24, 0x0, 0x0
	dspck_dstio adduh.qb, 0x051c7e02, 0x0038f704, 0x0b000600, 0x0, 0x0
	dspck_dstio adduh.qb, 0x91f30f06, 0xffe70001, 0x24ff1f0c, 0x0, 0x0
	dspck_dstio adduh.qb, 0x02f6118d, 0x02f1051b, 0x02fc1eff, 0x0, 0x0
	dspck_dstio adduh.qb, 0x839d4462, 0x08ff71c3, 0xff3c1801, 0x0, 0x0
	dspck_dstio adduh.qb, 0x41c28381, 0x83c3fff3, 0x00c10710, 0x0, 0x0
	dspck_dstio adduh.qb, 0x00034c4d, 0x0007920c, 0x0000078e, 0x0, 0x0
	dspck_dstio adduh.qb, 0x0d037f7f, 0x0006ffff, 0x1a010000, 0x0, 0x0
	dspck_dstio adduh.qb, 0x1f037418, 0x0000e130, 0x3e060700, 0x0, 0x0
	dspck_dstio adduh.qb, 0x2a77bc80, 0x55009902, 0x00efdfff, 0x0, 0x0
	dspck_dstio adduh.qb, 0x003f9700, 0x007e3000, 0x0100ff00, 0x0, 0x0
	dspck_dstio adduh.qb, 0x3dff010f, 0x4aff0300, 0x31ff001f, 0x0, 0x0
	dspck_dstio adduh.qb, 0x003c9988, 0x0079ffff, 0x00003411, 0x0, 0x0
	dspck_dstio adduh.qb, 0x7f86e102, 0x00ffc305, 0xff0eff00, 0x0, 0x0
	dspck_dstio adduh.qb, 0x183f0303, 0x12010406, 0x1e7e0201, 0x0, 0x0
	dspck_dstio adduh.qb, 0x0d210d07, 0x0c3f0000, 0x0e031b0f, 0x0, 0x0
	dspck_dstio adduh.qb, 0x006a1e3e, 0x010e3c01, 0x00c7017c, 0x0, 0x0
	dspck_dstio adduh.qb, 0x0239b91f, 0x0005ff30, 0x046d730f, 0x0, 0x0
	dspck_dstio adduh.qb, 0x7f003382, 0x0001000c, 0xff0066f9, 0x0, 0x0
	dspck_dstio adduh.qb, 0x7a87c1f8, 0xe7f1ffff, 0x0e1e83f1, 0x0, 0x0
	dspck_dstio adduh.qb, 0x147c7d40, 0x00002b01, 0x28f9cf80, 0x0, 0x0
	dspck_dstio adduh.qb, 0x20050701, 0x20050701, 0x20050701, 0x0, 0x0
	dspck_dstio adduh.qb, 0x7a7ff77f, 0x0effffff, 0xe700f000, 0x0, 0x0
	dspck_dstio adduh.qb, 0x16007f00, 0x1e00ff00, 0x0f000000, 0x0, 0x0
	dspck_dstio adduh.qb, 0x7f7f6f07, 0x00007f0f, 0xffff6000, 0x0, 0x0
	dspck_dstio adduh.qb, 0x8387817f, 0x080fffff, 0xffff0300, 0x0, 0x0
	dspck_dstio adduh.qb, 0x693c077f, 0xbf780e00, 0x130001ff, 0x0, 0x0
	dspck_dstio adduh.qb, 0xff5b207d, 0xff3e3ebf, 0xff78033c, 0x0, 0x0
	dspck_dstio adduh.qb, 0x1fb60071, 0x006d0000, 0x3eff00e3, 0x0, 0x0
	dspck_dstio adduh.qb, 0x4a8effa8, 0x921dffc3, 0x03ffff8e, 0x0, 0x0
	dspck_dstio adduh.qb, 0xcf017814, 0xcf017814, 0xcf017814, 0x0, 0x0
	dspck_dstio adduh.qb, 0xa3077007, 0x550f0100, 0xf100e00e, 0x0, 0x0
	dspck_dstio adduh.qb, 0xbe427c80, 0x7e810201, 0xff03f7ff, 0x0, 0x0
	dspck_dstio adduh.qb, 0x86510485, 0x0d9f00ff, 0xff04090c, 0x0, 0x0
	dspck_dstio adduh.qb, 0xb51c487f, 0xfe008eff, 0x6d380200, 0x0, 0x0
	dspck_dstio adduh.qb, 0x0e007f07, 0x0000000e, 0x1d00ff00, 0x0, 0x0
	dspck_dstio adduh.qb, 0x0940007b, 0x00000000, 0x128000f7, 0x0, 0x0
	dspck_dstio adduh.qb, 0x19432c06, 0x0087290b, 0x32003002, 0x0, 0x0
	dspck_dstio adduh.qb, 0x77f7878f, 0xeff0ffff, 0x00ff0f1f, 0x0, 0x0
	dspck_dstio adduh.qb, 0x77435378, 0xef0087f1, 0x00871f00, 0x0, 0x0
	dspck_dstio adduh.qb, 0x81fbf8e3, 0x03f7ffc7, 0xfffff1ff, 0x0, 0x0
	dspck_dstio adduh.qb, 0x7f007f00, 0x0000ff00, 0xff000000, 0x0, 0x0
	dspck_dstio adduh.qb, 0x83603318, 0xffc10b30, 0x07005c00, 0x0, 0x0
	dspck_dstio adduh.qb, 0xff3301f1, 0xff3301f1, 0xff3301f1, 0x0, 0x0
	dspck_dstio adduh.qb, 0x4c361bf9, 0x000034f9, 0x996d02f9, 0x0, 0x0
	dspck_dstio adduh.qb, 0x1f00885d, 0x3e01ff87, 0x00001233, 0x0, 0x0
	dspck_dstio adduh.qb, 0x6438ff91, 0x011cff24, 0xc755ffff, 0x0, 0x0
	dspck_dstio adduh.qb, 0x108a367f, 0x001617ff, 0x21ff5500, 0x0, 0x0
	dspck_dstio adduh.qb, 0x817f4f09, 0xff000012, 0x04ff9f00, 0x0, 0x0
	dspck_dstio adduh.qb, 0x7f0c9d83, 0x00183cff, 0xfe00ff07, 0x0, 0x0
	dspck_dstio adduh.qb, 0x024080c0, 0x008001ff, 0x0500ff81, 0x0, 0x0
	dspck_dstio adduh.qb, 0x857f4d7f, 0x0b0099ff, 0xffff0100, 0x0, 0x0
	dspck_dstio adduh.qb, 0x7ff37f3a, 0x00e7ff04, 0xffff0071, 0x0, 0x0
	dspck_dstio adduh.qb, 0xb70c580b, 0x7019aa15, 0xff000601, 0x0, 0x0
	dspck_dstio adduh.qb, 0x04b18063, 0x06e02560, 0x0283db66, 0x0, 0x0
	dspck_dstio adduh.qb, 0x0780498a, 0x0eff9216, 0x000100ff, 0x0, 0x0
	dspck_dstio adduh.qb, 0x03872a85, 0x000f3f0c, 0x07ff16ff, 0x0, 0x0
	dspck_dstio adduh.qb, 0x0c60031e, 0x13c10600, 0x0600013c, 0x0, 0x0
	dspck_dstio adduh.qb, 0x000b0003, 0x00000000, 0x00170006, 0x0, 0x0
	dspck_dstio adduh.qb, 0x3b102a4f, 0x071e0000, 0x7002559f, 0x0, 0x0
	dspck_dstio adduh.qb, 0x37227020, 0x013a0000, 0x6d0be040, 0x0, 0x0
	dspck_dstio adduh.qb, 0x737fbba4, 0xe7ff78ff, 0x0000ff49, 0x0, 0x0
	dspck_dstio adduh.qb, 0x3cd5fc36, 0x00e3f907, 0x78c7ff66, 0x0, 0x0
	dspck_dstio adduh.qb, 0x1b7f80cc, 0x180001ff, 0x1effff99, 0x0, 0x0
	dspck_dstio adduh.qb, 0x01797f60, 0x00000000, 0x03f3ffc0, 0x0, 0x0
	dspck_dstio adduh.qb, 0x7f06cc81, 0x000cffff, 0xff019904, 0x0, 0x0
	dspck_dstio adduh.qb, 0x55183c52, 0x01307866, 0xaa01003e, 0x0, 0x0
	dspck_dstio adduh.qb, 0x8d748120, 0x1c2aff1c, 0xffbf0324, 0x0, 0x0
	dspck_dstio adduh.qb, 0x31018408, 0x34020a00, 0x2e01ff11, 0x0, 0x0
	dspck_dstio adduh.qb, 0x7a483f55, 0x04357e00, 0xf05c00aa, 0x0, 0x0
	dspck_dstio adduh.qb, 0x73800660, 0xe7010dc1, 0x00ff0000, 0x0, 0x0
	dspck_dstio adduh.qb, 0x80557f7f, 0x010000ff, 0xffaaff00, 0x0, 0x0
	dspck_dstio adduh.qb, 0x1f7700ff, 0x000000ff, 0x3fef00ff, 0x0, 0x0
	dspck_dstio adduh.qb, 0x55afda00, 0x0c5fff00, 0x9fffb600, 0x0, 0x0
	dspck_dstio adduh.qb, 0x387f8200, 0x00ffff00, 0x71000600, 0x0, 0x0
	dspck_dstio adduh.qb, 0x03ff6381, 0x00ff0303, 0x07ffc3ff, 0x0, 0x0
	dspck_dstio adduh.qb, 0x05012a00, 0x0b025500, 0x00000000, 0x0, 0x0
	dspck_dstio adduh.qb, 0x117f810d, 0x14ef7f17, 0x0f0f8304, 0x0, 0x0
	dspck_dstio adduh.qb, 0x0300d043, 0x0500f708, 0x0101aa7f, 0x0, 0x0
	dspck_dstio adduh.qb, 0x01603f00, 0x00000000, 0x03c17f00, 0x0, 0x0
	dspck_dstio adduh.qb, 0x7b00c300, 0x06008700, 0xf000ff00, 0x0, 0x0
	dspck_dstio adduh.qb, 0x0013077f, 0x00000dff, 0x00270100, 0x0, 0x0
	dspck_dstio adduh.qb, 0x00470001, 0x008e0002, 0x00000000, 0x0, 0x0
	dspck_dstio adduh.qb, 0x2a00010f, 0x5500031e, 0x00000000, 0x0, 0x0
	dspck_dstio adduh.qb, 0x0f085f21, 0x1f10bf43, 0x00000000, 0x0, 0x0
	dspck_dstio adduh.qb, 0x00010574, 0x00020701, 0x010004e7, 0x0, 0x0
	dspck_dstio adduh.qb, 0x1f058063, 0x3f0aff00, 0x000101c7, 0x0, 0x0
	dspck_dstio adduh.qb, 0x7f710681, 0x00750703, 0xff6d05ff, 0x0, 0x0
	dspck_dstio adduh.qb, 0x66488000, 0x6081ff00, 0x6d0f0200, 0x0, 0x0
	dspck_dstio adduh.qb, 0xa0360e00, 0x423c1800, 0xff300400, 0x0, 0x0
	dspck_dstio adduh.qb, 0x417f420d, 0x7cff8017, 0x07000404, 0x0, 0x0
	dspck_dstio adduh.qb, 0x9a879f08, 0xf90fff10, 0x3cff4000, 0x0, 0x0
	dspck_dstio adduh.qb, 0xe1006600, 0xff00cc01, 0xc3000100, 0x0, 0x0
	dspck_dstio adduh.qb, 0x08ff837f, 0x01ffccff, 0x0fff3a00, 0x0, 0x0
	dspck_dstio adduh.qb, 0x0086ff01, 0x0015ff00, 0x00f8ff03, 0x0, 0x0
	dspck_dstio adduh.qb, 0x449ebf02, 0x01ffff00, 0x873e8004, 0x0, 0x0
	dspck_dstio adduh.qb, 0x00ff38bb, 0x00ff71ff, 0x00ff0078, 0x0, 0x0
	dspck_dstio adduh.qb, 0x4c7f0603, 0x99000d07, 0x00ff0000, 0x0, 0x0
	dspck_dstio adduh.qb, 0x782f9c02, 0xc1403a00, 0x301eff04, 0x0, 0x0
	dspck_dstio adduh.qb, 0x00ed1200, 0x00e71200, 0x01f31301, 0x0, 0x0
	dspck_dstio adduh.qb, 0x478381bd, 0x00ffff7c, 0x8e0703ff, 0x0, 0x0
	dspck_dstio adduh.qb, 0x09857307, 0x00ff0b00, 0x120cdb0f, 0x0, 0x0
	dspck_dstio adduh.qb, 0x85032667, 0xff070c00, 0x0c0040cf, 0x0, 0x0
	dspck_dstio adduh.qb, 0x01051e49, 0x02003792, 0x000b0600, 0x0, 0x0
	dspck_dstio adduh.qb, 0xf39f157f, 0xf7df1d00, 0xef600eff, 0x0, 0x0
	dspck_dstio adduh.qb, 0x12150019, 0x002b0020, 0x24000112, 0x0, 0x0
	dspck_dstio adduh.qb, 0x8118710b, 0x0400e300, 0xff300017, 0x0, 0x0
	dspck_dstio adduh.qb, 0x8bae4f14, 0xff607f20, 0x18fc2008, 0x0, 0x0
	dspck_dstio adduh.qb, 0x04ff0804, 0x02ff0200, 0x07ff0f08, 0x0, 0x0
	dspck_dstio adduh.qb, 0x057f7e82, 0x03fffd05, 0x070000ff, 0x0, 0x0
	dspck_dstio adduh.qb, 0x00b8df16, 0x01ffff1e, 0x0071c00e, 0x0, 0x0
	dspck_dstio adduh.qb, 0xa88f008f, 0x713e0120, 0xe0e000ff, 0x0, 0x0
	dspck_dstio adduh.qb, 0x0b053b7d, 0x160570f9, 0x00050601, 0x0, 0x0
	dspck_dstio adduh.qb, 0x02959a05, 0x0481ff0b, 0x00aa3500, 0x0, 0x0
	dspck_dstio adduh.qb, 0x159e0678, 0x1c3e0c09, 0x0fff00e7, 0x0, 0x0
	dspck_dstio adduh.qb, 0x667f0300, 0xccff0700, 0x00000000, 0x0, 0x0
	dspck_dstio adduh.qb, 0x0015bb00, 0x002b7800, 0x0100ff00, 0x0, 0x0
	dspck_dstio adduh.qb, 0x40141067, 0x802820cf, 0x00000000, 0x0, 0x0
	dspck_dstio adduh.qb, 0x85031f83, 0xff013e08, 0x0c0601ff, 0x0, 0x0
	dspck_dstio adduh.qb, 0x1439488d, 0x0703011c, 0x22708fff, 0x0, 0x0
	dspck_dstio adduh.qb, 0x000f007f, 0x00000000, 0x011f00ff, 0x0, 0x0
	dspck_dstio adduh.qb, 0x7f06037f, 0x00000000, 0xff0c07ff, 0x0, 0x0
	dspck_dstio adduh.qb, 0x1c630d77, 0x00000000, 0x38c71bef, 0x0, 0x0
	dspck_dstio adduh.qb, 0x0b5ea17e, 0x166943f7, 0x0053ff06, 0x0, 0x0
	dspck_dstio adduh.qb, 0x0f100004, 0x05200009, 0x19010100, 0x0, 0x0
	dspck_dstio adduh.qb, 0xd3368f70, 0xc7051fe1, 0xdf67ff00, 0x0, 0x0
	dspck_dstio adduh.qb, 0xc700b608, 0xc700b608, 0xc700b608, 0x0, 0x0
	dspck_dstio adduh.qb, 0x48010506, 0x0201020d, 0x8e010800, 0x0, 0x0
	dspck_dstio adduh.qb, 0x017f0300, 0x00000000, 0x03ff0600, 0x0, 0x0
	dspck_dstio adduh.qb, 0x89800100, 0xf77f0100, 0x1c810100, 0x0, 0x0
	dspck_dstio adduh.qb, 0x051fda0b, 0x0a3eff08, 0x0000b60e, 0x0, 0x0
	dspck_dstio adduh.qb, 0x85102702, 0x0c1f4f04, 0xff020000, 0x0, 0x0
	dspck_dstio adduh.qb, 0x0602f1ff, 0x0001f1ff, 0x0d03f1ff, 0x0, 0x0
	dspck_dstio adduh.qb, 0x107f44be, 0x01ff057f, 0x200083fd, 0x0, 0x0
	dspck_dstio adduh.qb, 0x780006d8, 0x000000f1, 0xf0000cc0, 0x0, 0x0
	dspck_dstio adduh.qb, 0x07124444, 0x01000105, 0x0d248783, 0x0, 0x0
	dspck_dstio adduh.qb, 0x04005f08, 0x04000000, 0x0501bf11, 0x0, 0x0
	dspck_dstio adduh.qb, 0x00007f0b, 0x0000ff07, 0x01010010, 0x0, 0x0
	dspck_dstio adduh.qb, 0x0bba7338, 0x00ffdf01, 0x17750770, 0x0, 0x0
	dspck_dstio adduh.qb, 0x34ff4600, 0x49ff0d01, 0x20ff7f00, 0x0, 0x0
	dspck_dstio adduh.qb, 0x443d1440, 0x7e0d2400, 0x0a6d0581, 0x0, 0x0
	dspck_dstio adduh.qb, 0x784a485b, 0x003d55b6, 0xf0573c01, 0x0, 0x0
	dspck_dstio adduh.qb, 0x38c3407f, 0x6d8780ff, 0x04ff0000, 0x0, 0x0
	dspck_dstio adduh.qb, 0x1f0b6045, 0x3f00bf7f, 0x0016010c, 0x0, 0x0
	dspck_dstio adduh.qb, 0xdb2200fe, 0xf00700fd, 0xc73e00ff, 0x0, 0x0
	dspck_dstio adduh.qb, 0x7f010f30, 0xff000b60, 0x00021300, 0x0, 0x0
	dspck_dstio adduh.qb, 0x8f037f04, 0xff060009, 0x1f00ff00, 0x0, 0x0
	dspck_dstio adduh.qb, 0x0b7f0997, 0x00000b30, 0x16ff07ff, 0x0, 0x0
	dspck_dstio adduh.qb, 0x7f818800, 0xff248100, 0x00df8f00, 0x0, 0x0
	dspck_dstio adduh.qb, 0x011a047e, 0x00290100, 0x020c07fd, 0x0, 0x0
	dspck_dstio adduh.qb, 0x034e8e81, 0x040e55ff, 0x028fc704, 0x0, 0x0
	dspck_dstio adduh.qb, 0x01000b03, 0x00000000, 0x02001607, 0x0, 0x0
	dspck_dstio adduh.qb, 0x7f181404, 0x00302808, 0xff000000, 0x0, 0x0
	dspck_dstio adduh.qb, 0x00000604, 0x00010c09, 0x00000000, 0x0, 0x0
	dspck_dstio adduh.qb, 0x0c9e23ff, 0x09ff3fff, 0x0f3e07ff, 0x0, 0x0
	dspck_dstio adduh.qb, 0x00501a0c, 0x0099340b, 0x0008000e, 0x0, 0x0
	dspck_dstio adduh.qb, 0xcc9f1802, 0xffff0101, 0x993f3004, 0x0, 0x0
	dspck_dstio adduh.qb, 0xff9f057f, 0xff400aff, 0xffff0000, 0x0, 0x0
	dspck_dstio adduh.qb, 0xe1814707, 0xffff0105, 0xc3048e0a, 0x0, 0x0
	dspck_dstio adduh.qb, 0x88136d64, 0x6627001f, 0xaa00dbaa, 0x0, 0x0
	dspck_dstio adduh.qb, 0x46201976, 0x060100e0, 0x8740330c, 0x0, 0x0
	dspck_dstio adduh.qb, 0x9b1f034c, 0xff010015, 0x373e0783, 0x0, 0x0
	dspck_dstio adduh.qb, 0x03010aaf, 0x000007ff, 0x07030d60, 0x0, 0x0
	dspck_dstio adduh.qb, 0xff00780e, 0xff00780e, 0xff00780e, 0x0, 0x0
	dspck_dstio adduh.qb, 0x3c50f37f, 0x661ee700, 0x1283ffff, 0x0, 0x0
	dspck_dstio adduh.qb, 0x6f06075b, 0x000804b6, 0xdf050a00, 0x0, 0x0
	dspck_dstio adduh.qb, 0x18f8df71, 0x00ffff03, 0x31f1bfdf, 0x0, 0x0
	dspck_dstio adduh.qb, 0xb2ff3260, 0xffff4900, 0x66ff1cc1, 0x0, 0x0
	dspck_dstio adduh.qb, 0x7f01af10, 0xff03ff09, 0x00006018, 0x0, 0x0
	dspck_dstio adduh.qb, 0xf6803502, 0xfeff6a01, 0xef020003, 0x0, 0x0
	dspck_dstio adduh.qb, 0x803e1f20, 0x0101003f, 0xff7c3f01, 0x0, 0x0
	dspck_dstio adduh.qb, 0x0903b67f, 0x0001ffff, 0x13056d00, 0x0, 0x0
	dspck_dstio adduh.qb, 0x3219a481, 0x0000ff03, 0x653349ff, 0x0, 0x0
	dspck_dstio adduh.qb, 0x2600783e, 0x4d00f17c, 0x00000000, 0x0, 0x0
	dspck_dstio adduh.qb, 0x00aa7d03, 0x00fff902, 0x00550205, 0x0, 0x0
	dspck_dstio adduh.qb, 0x0900ff73, 0x1100ff00, 0x0100ffe7, 0x0, 0x0
	dspck_dstio adduh.qb, 0x8bd883d4, 0xffc108fe, 0x18f0ffaa, 0x0, 0x0
	dspck_dstio adduh.qb, 0x7f887f05, 0xfff9030a, 0x0018fc00, 0x0, 0x0
	dspck_dstio adduh.qb, 0x04804970, 0x00ff0002, 0x090192df, 0x0, 0x0
	dspck_dstio adduh.qb, 0x0a006000, 0x0000c000, 0x15010100, 0x0, 0x0
	dspck_dstio adduh.qb, 0x477f067f, 0x00000000, 0x8eff0cff, 0x0, 0x0
	dspck_dstio adduh.qb, 0xbf8f7b7c, 0xff1ff700, 0x80ff00f9, 0x0, 0x0
	dspck_dstio adduh.qb, 0x7222978a, 0x050dff55, 0xe03830c0, 0x0, 0x0
	dspck_dstio adduh.qb, 0x5838067f, 0x06000c00, 0xaa7000ff, 0x0, 0x0
	dspck_dstio adduh.qb, 0x7e007f7f, 0xfd00ffff, 0x00000000, 0x0, 0x0
	dspck_dstio adduh.qb, 0xff046e11, 0xff05db07, 0xff04011c, 0x0, 0x0
	dspck_dstio adduh.qb, 0x21a82b1c, 0x2d583e00, 0x15f91838, 0x0, 0x0
	dspck_dstio adduh.qb, 0x2ab61f00, 0x54ff3e00, 0x006d0000, 0x0, 0x0
	dspck_dstio adduh.qb, 0x677f0051, 0xaaff009f, 0x24000003, 0x0, 0x0
	dspck_dstio adduh.qb, 0x82d24585, 0x06c16daa, 0xffe31e60, 0x0, 0x0
	dspck_dstio adduh.qb, 0x0008407f, 0x001180ff, 0x00000000, 0x0, 0x0
	dspck_dstio adduh.qb, 0x099ec87f, 0x12409200, 0x00fdffff, 0x0, 0x0
	dspck_dstio adduh.qb, 0x7f813301, 0xfeff4700, 0x00031f03, 0x0, 0x0
	dspck_dstio adduh.qb, 0x0000f96d, 0x0000f96d, 0x0000f96d, 0x0, 0x0
	dspck_dstio adduh.qb, 0x10aa02ff, 0x205502ff, 0x00ff02ff, 0x0, 0x0
	dspck_dstio adduh.qb, 0x6d06127f, 0x1c002400, 0xbf0d00ff, 0x0, 0x0
	dspck_dstio adduh.qb, 0x81038b7e, 0x0305180b, 0xff01fff1, 0x0, 0x0
	dspck_dstio adduh.qb, 0x0600001d, 0x00000000, 0x0d00003b, 0x0, 0x0
	dspck_dstio adduh.qb, 0x31016600, 0x61010000, 0x0101cc00, 0x0, 0x0
	dspck_dstio adduh.qb, 0x7f5c7f05, 0x00b6ff00, 0xff03000b, 0x0, 0x0
	dspck_dstio adduh.qb, 0x000461cc, 0x00065599, 0x00036dff, 0x0, 0x0

	writemsg "[5] Test adduh_r.qb"
	dspck_dstio adduh_r.qb, 0x857e6272, 0x0a00c300, 0xfffc01e3, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x07ff1fd5, 0x0eff3daa, 0x00ff00ff, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x0f4d4d94, 0x1c99998f, 0x01000099, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x80cc5601, 0xff990201, 0x00ffaa00, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x72298019, 0xdf3f0013, 0x0412ff1f, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x80800727, 0x03ff0e3e, 0xfd00000f, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x24144b19, 0x3000872b, 0x18270e06, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0xd7aaa680, 0xf7e17c00, 0xb673cfff, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x4810c930, 0x80189206, 0x0f07ff5a, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x7744ff75, 0xcc00ff03, 0x2187ffe7, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x8005f880, 0x0002f100, 0xff08ffff, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x070202ff, 0x0e0003ff, 0x000300ff, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0xcc9f8180, 0xffffffff, 0x993e0200, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x0400c03f, 0x0400ff60, 0x0300801d, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x63119474, 0x1c1c99c3, 0xaa058f25, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x451304a4, 0x0c1201db, 0x7e14076d, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x198bf898, 0x0024f1ff, 0x32f1ff30, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x3f093000, 0x01100000, 0x7c016000, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x06612ba4, 0x000155e7, 0x0cc00160, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0xa43b624b, 0x49210330, 0xff55c066, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x048008ff, 0x000000ff, 0x07ff0fff, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x4b9a8c00, 0x60341800, 0x36ffff00, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x00098102, 0x000c8104, 0x00068000, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x9e628534, 0x3cbf0a01, 0xff04ff66, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x03186066, 0x062fbfcc, 0x00000000, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x38602c1a, 0x0ac00f33, 0x66004900, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x0482bb10, 0x0007831f, 0x07fdf301, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x7fff0500, 0x7fff0500, 0x7fff0500, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x68ff3e82, 0xcfff7c04, 0x00ff00ff, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0xb686cc0b, 0x6d0cff13, 0xffff9902, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x1fb81570, 0x3aff10c0, 0x03711a1f, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x72618a20, 0x08c1ff40, 0xdb001400, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x8330bc72, 0x075f7863, 0xff00ff80, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x87ff2f80, 0x0fff3e01, 0xffff1fff, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0xe3ffa6ff, 0xffff4dff, 0xc7ffffff, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x00ff0002, 0x00ff0000, 0x00ff0003, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x95110cb8, 0x2b000cff, 0xfe220c71, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x0a0080c3, 0x0800ff87, 0x0c0000ff, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x0380f79f, 0x00ffeffe, 0x0500ff40, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x4976e104, 0x00e3ff03, 0x9208c305, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x7d10312f, 0x01160208, 0xf9096055, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x1e800116, 0x00000000, 0x3cff012b, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x421a3f80, 0x00337eff, 0x83010000, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x8243a41f, 0x047f813e, 0xff07c700, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x01803971, 0x00000000, 0x01ff71e1, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x001ec707, 0x001ec707, 0x001ec707, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x3c101ef7, 0x781f39ff, 0x000003ef, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x3c1e8a80, 0x60033000, 0x1738e3ff, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x87118204, 0xff020401, 0x0f1fff06, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x20002055, 0x3f0040aa, 0x00000000, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x04804a00, 0x017f0c00, 0x06808700, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x613e50f0, 0x007c00e0, 0xc1009fff, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x0800818e, 0x000003ff, 0x0f00ff1d, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x346a037a, 0x49cf05f3, 0x1e040001, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x808221d5, 0x000504ff, 0xffff3eaa, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x19ff0200, 0x19ff0200, 0x19ff0200, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0xc909988d, 0x920e301b, 0xff03ffff, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x81680256, 0x02cf023e, 0xff00016d, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x06b57b82, 0x00dbefc7, 0x0b8f073c, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x011a0000, 0x01330000, 0x00000000, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x7f800478, 0xfdff07ef, 0x00000000, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x41826201, 0x03040200, 0x7effc102, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x80710068, 0x00000000, 0xffe100cf, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0xfff9ff00, 0xfff9ff00, 0xfff9ff00, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x017a060b, 0x01700015, 0x01830c00, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x70419937, 0xdf7c3200, 0x0006ff6d, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x39000280, 0x3e0002ff, 0x33000201, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x1a6e4780, 0x00000000, 0x33db8eff, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x0005184f, 0x00081099, 0x00011f04, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0xff458097, 0xff0eaa31, 0xff7c55fd, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x6e087001, 0x0000df01, 0xdb100000, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x060380c3, 0x05050187, 0x0601ffff, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0xff68ffa4, 0xff00ff49, 0xffcfffff, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x6338f018, 0xaa0fe100, 0x1b60fe30, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x19000437, 0x00000000, 0x3200086d, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x02407d82, 0x0078f8ff, 0x04070205, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x20809700, 0x33ff2e00, 0x0d00ff00, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x03808080, 0x00000000, 0x06ffffff, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x06020001, 0x00040000, 0x0c000001, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x66025af9, 0xc70099ff, 0x04041bf3, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x10031f0d, 0x00000000, 0x1f063e19, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x01800f20, 0x00ff1c3e, 0x01000102, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x834a26fc, 0x0f9202ff, 0xf70149f8, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x7e228301, 0xc103ff00, 0x3b400702, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x38686cf8, 0x00cf3fff, 0x700099f0, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x9f500890, 0xff240e81, 0x3f7c019f, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x77ff0005, 0x07ff0009, 0xe7ff0000, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x8000ff01, 0xff00ff00, 0x0000ff02, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x0c2e7c42, 0x00550017, 0x1707f76d, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x09820473, 0x0f0506df, 0x03ff0107, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x011a020f, 0x0000001c, 0x01330302, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0xcc977a1b, 0xffc70333, 0x9966f003, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x032b7800, 0x0555f000, 0x00000000, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x7a118001, 0xf11fff00, 0x03020002, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0xdb110d14, 0xff1d1626, 0xb6040401, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x7e800700, 0xfc010000, 0x00ff0e00, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x47309703, 0x00002e00, 0x8e60ff05, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0xb9503808, 0xff9f700f, 0x72010000, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0xd38c7211, 0xef30e022, 0xb6e70400, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x8480e004, 0x0800df00, 0xffffe108, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0xa0803e80, 0x4fff0e00, 0xf0006dff, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x8b808013, 0x17ffff1e, 0xff000008, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x02808289, 0x0000ff12, 0x04ff05ff, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x081072f7, 0x1020e3ef, 0x000000ff, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x10362c04, 0x10220601, 0x10495206, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x4e2bff0e, 0x4e2bff0e, 0x4e2bff0e, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0xff38921f, 0xff38921f, 0xff38921f, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x0b02011a, 0x04030110, 0x12000024, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x067a92e7, 0x0cef24ff, 0x0004ffcf, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x07012102, 0x0c000403, 0x01013d00, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x72804880, 0x030102ff, 0xe0ff8e00, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x0029713c, 0x0029713c, 0x0029713c, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x01012b39, 0x02010000, 0x00005571, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x0e640000, 0x01000000, 0x1bc70000, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x4d030084, 0x0a0000ff, 0x8f060009, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x0b191de3, 0x000101c7, 0x163039ff, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x92ff6a00, 0x92ff6a00, 0x92ff6a00, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x9e80ffff, 0xff00fffe, 0x3dffffff, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x80146725, 0x00038f00, 0xff243e49, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x08098806, 0x10111000, 0x0000ff0c, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x99046100, 0x4007c100, 0xf1000000, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x800e8002, 0xff0c0100, 0x0010ff03, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x4f7d0010, 0x1ecc001d, 0x7f2e0003, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x55803302, 0x1bff3804, 0x8e002d00, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x0e0cda80, 0x0018c300, 0x1c00f0ff, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x60e64808, 0x00ff0000, 0xc0cc8f10, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x80002103, 0x00003f06, 0xff000200, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0xa2010026, 0x6801000f, 0xdb00003c, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x0380ed18, 0x0000db0f, 0x06ffff21, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x14a53780, 0x00ff6dff, 0x274b0000, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x579c0168, 0x0ff800cf, 0x9f3f0100, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x044e002d, 0x0599005a, 0x02020000, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x8b3f9f4d, 0x16183e12, 0xff66ff87, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x1f6e0300, 0x02db0000, 0x3c000500, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x4a838001, 0x14ff0000, 0x7f06ff01, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x000000ff, 0x000000ff, 0x000000ff, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x367a0d00, 0x00001300, 0x6cf30700, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0xf6034518, 0xf9057000, 0xf3001a30, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x8c037705, 0xff010d01, 0x1804e108, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x3810dc04, 0x6d01bf00, 0x021ef907, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x0051bc02, 0x000f8700, 0x0092f003, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0xb0065e80, 0x60002cff, 0xff0b8f00, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x0470a501, 0x04dfcc01, 0x04007e00, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x20013008, 0x40016003, 0x0000000d, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x67010004, 0xc7000007, 0x07020000, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x41868080, 0x71ff00ff, 0x110cff01, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x70931e50, 0x00ff009f, 0xe0263c01, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x2380020d, 0x46000413, 0x00ff0006, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x67080000, 0x01000000, 0xcc0f0000, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x95824283, 0x2aff83e3, 0xff050122, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x039b037f, 0x02ff0500, 0x033701fd, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x68440005, 0xcc690007, 0x031f0002, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x01fb2bc3, 0x02fd00ff, 0x00f95587, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x3c500180, 0x71920100, 0x070e00ff, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x80000600, 0x00000000, 0xff000c00, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x790380a1, 0xcc00ffc3, 0x2605017e, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0xe4d92110, 0xf8b60300, 0xcffc3f1f, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x0e07048e, 0x0e07048e, 0x0e07048e, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x46077c13, 0x83000025, 0x080ef700, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x7378a285, 0xdff08e0a, 0x0600b6ff, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x0260ff17, 0x01bfff28, 0x0200ff05, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x86ff0001, 0xccff0000, 0x3fff0002, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x0fde807f, 0x1ec3ffe0, 0x00f8001e, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x093c0c0a, 0x0f000c0f, 0x03780b05, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x31db780c, 0x00e7ef00, 0x61cf0018, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x8af1b62b, 0x33ffff00, 0xe0e36d55, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0xbf015202, 0xff008704, 0x7f011d00, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0xf5177e70, 0xf32a00cf, 0xf703fc10, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x00003705, 0x00006d0a, 0x00000000, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x80fb071e, 0xffff0d3c, 0x00f70100, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x46101b3a, 0x1c013306, 0x701f026d, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x87802080, 0xff0300e7, 0x0ffc3f18, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x1020019f, 0x1e3200ff, 0x010d013e, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x80001852, 0xff000038, 0x0000306b, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x00841b83, 0x00083607, 0x00ff00ff, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x6e1a863e, 0x0003fc7c, 0xdb300f00, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x740efcbc, 0xe718f8f9, 0x0104ff7e, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x6ee08783, 0x0dcf0f06, 0xcff0ffff, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x88f60c74, 0xfff00000, 0x10fc18e7, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x0f9bffc3, 0x09ffff87, 0x1437ffff, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x01cb8080, 0x02993900, 0x00fdc7ff, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x8000822d, 0xff00ff01, 0x00000558, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x43760a2c, 0x81df0030, 0x050d1327, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x03191013, 0x05010020, 0x00301f05, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x3e810003, 0x7bff0000, 0x00030005, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x1800000f, 0x3000001e, 0x00000000, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0xfe80aab3, 0xfdff7166, 0xff00e3ff, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x39ff1a9f, 0x01ff15b6, 0x70fe1e87, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0xf307141e, 0xe70c0c05, 0xff011b37, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x80801a37, 0xff01106d, 0x00ff2400, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x01009488, 0x0000fd8f, 0x01002b81, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x711f025c, 0x020001b6, 0xdf3e0301, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x03789804, 0x03003003, 0x03efff04, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x6e000061, 0xdb0000c1, 0x00000000, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x82ffb82e, 0x04ffff0a, 0xffff7051, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x288cff3b, 0x4918ff74, 0x06ffff02, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x00f7ff18, 0x00f7ff18, 0x00f7ff18, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x12550c04, 0x00000007, 0x23aa1800, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x1e3e0350, 0x007c049f, 0x3b000100, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x0b54ab1b, 0x0e0fff30, 0x07995606, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x3987c706, 0x721c8e0a, 0x00f1ff01, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x80108b17, 0xff203624, 0x0000df09, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x60038016, 0xbf050008, 0x0001ff24, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0xffff8301, 0xffffff00, 0xffff0701, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x2b060d80, 0x00000000, 0x550c1aff, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x84ff003a, 0x08ff006d, 0xffff0006, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x450d0026, 0x450d0026, 0x450d0026, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x19018304, 0x3001ff07, 0x01000600, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x3f640980, 0x7cc70401, 0x02010eff, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x80788084, 0x000000ff, 0xfff0ff08, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x47ff3880, 0x7fff00ff, 0x0eff7001, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x403b920a, 0x0249ff00, 0x7e2d2414, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x4881823b, 0x02030504, 0x8effff71, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x44648141, 0x0000027e, 0x87c7ff03, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x08842113, 0x0ccc041e, 0x033c3e07, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0xbf6bc74c, 0x7ec08e18, 0xff16ff7f, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x0180010f, 0x00000000, 0x02ff011d, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x805b3c00, 0x00000000, 0xffb67800, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x8d66480e, 0xff3e8f00, 0x1b8e001b, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x00ff8513, 0x00ff0a0b, 0x00ffff1a, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x8080fffe, 0x0000fffd, 0xffffffff, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0xfc860f34, 0xff0c1859, 0xf9ff060e, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x00000680, 0x00000bff, 0x00000000, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x80c3dba8, 0xff87b68f, 0x00ffffc0, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x10ff37c5, 0x1fff00f0, 0x00ff6d99, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x01017f1c, 0x0201fd30, 0x00010007, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x7100170f, 0xe100261d, 0x00000801, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x84800587, 0x090008ff, 0xffff010f, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x4d41ff93, 0x997eff26, 0x0103ffff, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x8c7c0878, 0x18f70000, 0xff000fef, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x8148060e, 0xff8f0500, 0x0200071c, 0x0, 0x0
	dspck_dstio adduh_r.qb, 0x9f8c8005, 0xffffff09, 0x3e180000, 0x0, 0x0

	writemsg "[6] Test append"
	dspck_tsimm append, 0x00000090, 0x00000000, 0x079f2390, 8
	dspck_tsimm append, 0x00000001, 0x00000000, 0x008a1001, 1
	dspck_tsimm append, 0x09f0acd0, 0x09f0acd0, 0xf8000003, 0
	dspck_tsimm append, 0x80000019, 0x00000019, 0x00000019, 31
	dspck_tsimm append, 0xfffffff0, 0x00000003, 0x7ffffff0, 31
	dspck_tsimm append, 0x3b92e92e, 0x0073b92e, 0x0073b92e, 12
	dspck_tsimm append, 0x4000001f, 0x80000000, 0xc000001f, 31
	dspck_tsimm append, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0
	dspck_tsimm append, 0x40000001, 0x3ffffff0, 0xc0000001, 31
	dspck_tsimm append, 0xdff59020, 0xeffac810, 0x80000000, 1
	dspck_tsimm append, 0x0dbb0000, 0x00000dbb, 0x00000000, 16
	dspck_tsimm append, 0x000f0084, 0x0000000f, 0x00000084, 16
	dspck_tsimm append, 0x00000007, 0x00000000, 0xe0000007, 5
	dspck_tsimm append, 0x00000003, 0x80000000, 0x00003423, 3
	dspck_tsimm append, 0x00165235, 0x00165235, 0x00000007, 0
	dspck_tsimm append, 0xfdd29c98, 0xfdd29c98, 0xffffbef0, 0
	dspck_tsimm append, 0xff00ff00, 0xff00ff00, 0xfffd7cd8, 0
	dspck_tsimm append, 0xf8071c71, 0xff00ff00, 0x71c71c71, 19
	dspck_tsimm append, 0xfec36c54, 0xffd86d8a, 0xcccccccc, 3
	dspck_tsimm append, 0xffffdffe, 0x07fffffe, 0x07fffffe, 13
	dspck_tsimm append, 0xffffffec, 0xfffffffe, 0x3ffffffc, 4
	dspck_tsimm append, 0x80000000, 0x80000000, 0x7ffffff9, 0
	dspck_tsimm append, 0xfffffff0, 0xfffffff0, 0x3ffffffc, 0
	dspck_tsimm append, 0xffc3d805, 0xfffff87b, 0x00000005, 11
	dspck_tsimm append, 0x00000003, 0x80000000, 0xfffffffb, 2
	dspck_tsimm append, 0xffffffff, 0x7fffffff, 0x7fffffff, 31
	dspck_tsimm append, 0x80000000, 0xff36a999, 0x80000000, 31
	dspck_tsimm append, 0x80000000, 0x80000000, 0xf8000003, 0
	dspck_tsimm append, 0xe000000e, 0xfc000001, 0xb6db6db6, 3
	dspck_tsimm append, 0xffffffff, 0x7fffffff, 0x0000ffff, 1
	dspck_tsimm append, 0x00000006, 0xc0000001, 0x00000002, 2
	dspck_tsimm append, 0x000001bd, 0x00000000, 0x000001bd, 31
	dspck_tsimm append, 0xf8000001, 0xf8000001, 0x80000000, 0
	dspck_tsimm append, 0x07e0001b, 0x0000003f, 0x0000001b, 21
	dspck_tsimm append, 0x8ffffffe, 0x7fffffff, 0x0ffffffe, 31
	dspck_tsimm append, 0x0000006f, 0x0000006f, 0xffffff80, 0
	dspck_tsimm append, 0xffca4380, 0xffff290e, 0x7fffffc0, 6
	dspck_tsimm append, 0x00000000, 0x80000000, 0x80000000, 16
	dspck_tsimm append, 0x3ffffffd, 0x1ffffffe, 0x7fffffff, 1
	dspck_tsimm append, 0x00000005, 0x00000000, 0xfffffc5d, 3
	dspck_tsimm append, 0x8000001f, 0x8000001f, 0x00000000, 0
	dspck_tsimm append, 0x7fffffff, 0x7fffffff, 0xfffffffc, 0
	dspck_tsimm append, 0x08f97af2, 0xffe09f08, 0xfff97af2, 24
	dspck_tsimm append, 0x00000000, 0x00000000, 0x80000000, 0
	dspck_tsimm append, 0x80000002, 0x80000002, 0xffffffe3, 0
	dspck_tsimm append, 0x000011f9, 0x0ffffffe, 0x000011f9, 31
	dspck_tsimm append, 0x7fffffff, 0x7fffffff, 0xffdf9521, 0
	dspck_tsimm append, 0x0000002d, 0x80000000, 0xfff9cbad, 7
	dspck_tsimm append, 0x24924924, 0xb6db6db6, 0x24924924, 31
	dspck_tsimm append, 0xfe000001, 0x0000007f, 0x00000001, 25
	dspck_tsimm append, 0x7ffffff9, 0x00000000, 0xfffffff9, 31
	dspck_tsimm append, 0x80000000, 0x80000000, 0x71c71c71, 0
	dspck_tsimm append, 0xb6dbffff, 0x6db6db6d, 0x7fffffff, 17
	dspck_tsimm append, 0x000000b3, 0x80000000, 0x00f042b3, 8
	dspck_tsimm append, 0xb0000000, 0x0a72ad2b, 0x00000000, 28
	dspck_tsimm append, 0x00000000, 0x00000000, 0x3ffffff8, 3
	dspck_tsimm append, 0xc71c71c7, 0xc71c71c7, 0x007ec075, 0
	dspck_tsimm append, 0xfff3ff87, 0xfffffffc, 0xffffff87, 18
	dspck_tsimm append, 0x029129e0, 0x0052253c, 0x00000000, 3
	dspck_tsimm append, 0x7fffffc4, 0x0ffffff8, 0x0003a09c, 3
	dspck_tsimm append, 0xfffffe02, 0xffffff80, 0xffe06586, 2
	dspck_tsimm append, 0x80000006, 0x7fffffff, 0x80000006, 31
	dspck_tsimm append, 0x80000000, 0x80000000, 0x0000ffff, 0
	dspck_tsimm append, 0xf9820006, 0xfffff982, 0x80000006, 16
	dspck_tsimm append, 0x7fffffff, 0x7fffffff, 0x7ffffffc, 0
	dspck_tsimm append, 0xfffffff9, 0x7fffffff, 0xfffffff9, 7
	dspck_tsimm append, 0x8000000f, 0x8000000f, 0x00000000, 0
	dspck_tsimm append, 0x00000000, 0x00000000, 0x80000000, 31
	dspck_tsimm append, 0x00000000, 0x80000000, 0x00000000, 31
	dspck_tsimm append, 0x92492492, 0x49249249, 0x00000000, 1
	dspck_tsimm append, 0xfffffffc, 0x7fffffff, 0x00000000, 2
	dspck_tsimm append, 0x80000000, 0x00ff00ff, 0x00000000, 31
	dspck_tsimm append, 0xfffffffc, 0x7fffffff, 0x0ffffffc, 28
	dspck_tsimm append, 0x0000198c, 0x00000006, 0x0000198c, 31
	dspck_tsimm append, 0x80000000, 0x80000000, 0x80000000, 0
	dspck_tsimm append, 0xe0c44a9f, 0xfc188953, 0x80000007, 3
	dspck_tsimm append, 0xffffffe7, 0xffffffe7, 0x0000001f, 0
	dspck_tsimm append, 0xfffe0000, 0x7fffffff, 0x80000000, 17
	dspck_tsimm append, 0x7ffffffc, 0x7ffffffc, 0x000b2d36, 0
	dspck_tsimm append, 0xe0000000, 0x80000007, 0x80000000, 29
	dspck_tsimm append, 0x8000003f, 0x8000003f, 0x00000000, 0
	dspck_tsimm append, 0x00f73453, 0xfffd9cce, 0x00f73453, 31
	dspck_tsimm append, 0x00000003, 0x00000000, 0xc0000003, 2
	dspck_tsimm append, 0xf0000001, 0xf0000001, 0x80000000, 0
	dspck_tsimm append, 0x0004000f, 0xf0000001, 0x8000000f, 18
	dspck_tsimm append, 0x00003800, 0x00000007, 0x00000000, 11
	dspck_tsimm append, 0x00000000, 0x00000000, 0x80000000, 0
	dspck_tsimm append, 0xbb4000ff, 0x001745da, 0x000000ff, 21
	dspck_tsimm append, 0x00000002, 0x00000001, 0x38e38e38, 1
	dspck_tsimm append, 0x7ffff89a, 0xfffffffa, 0xfffff89a, 31
	dspck_tsimm append, 0x00000000, 0x7fffff80, 0x00000000, 31
	dspck_tsimm append, 0x80000007, 0x80000007, 0x80000007, 0
	dspck_tsimm append, 0x7fffffff, 0x7fffffff, 0xfffff895, 0
	dspck_tsimm append, 0xfbd4ecf0, 0xfef53b3c, 0x3ffffff8, 2
	dspck_tsimm append, 0xffe00000, 0xfffffff0, 0x80000000, 17
	dspck_tsimm append, 0x0000007f, 0x80000000, 0x7fffffff, 7
	dspck_tsimm append, 0x40000007, 0x80000000, 0xc0000007, 31
	dspck_tsimm append, 0x0000007a, 0xc000000f, 0x92492492, 3
	dspck_tsimm append, 0x0000000f, 0x00000007, 0x71c71c71, 1
	dspck_tsimm append, 0xfffffec4, 0xfffffec4, 0xfffffec4, 0
	dspck_tsimm append, 0x80000000, 0x80000000, 0xff6693b4, 0
	dspck_tsimm append, 0x0ffffff8, 0x80000000, 0x0ffffff8, 31
	dspck_tsimm append, 0xfffffffe, 0x7fffffff, 0xf320ad72, 1
	dspck_tsimm append, 0x0000000a, 0x00000000, 0x0000000a, 13
	dspck_tsimm append, 0xffffffff, 0x7fffffff, 0xffffffe5, 1
	dspck_tsimm append, 0xfffffe38, 0x7fffffff, 0x38e38e38, 9
	dspck_tsimm append, 0xfffffffe, 0x7fffffff, 0xfffffffe, 10
	dspck_tsimm append, 0x0000000e, 0x00000000, 0x8e38e38e, 7
	dspck_tsimm append, 0x001b738b, 0x00000db9, 0xfff9d38b, 9
	dspck_tsimm append, 0x24924924, 0xffd5e328, 0x24924924, 31
	dspck_tsimm append, 0x00037864, 0x00037864, 0xffff0000, 0
	dspck_tsimm append, 0xfd43c708, 0xff50f1c2, 0x80000000, 2
	dspck_tsimm append, 0x80000000, 0x80000000, 0x80000000, 0
	dspck_tsimm append, 0xfffffffe, 0x7fffffff, 0x80000000, 1
	dspck_tsimm append, 0x00180007, 0x00000006, 0x00000007, 18
	dspck_tsimm append, 0xffffff0c, 0xffffff0c, 0x7fffffff, 0
	dspck_tsimm append, 0xfffec000, 0xffffffec, 0x80000000, 12
	dspck_tsimm append, 0x0000003f, 0x80000003, 0x0000000f, 4
	dspck_tsimm append, 0xe46796e9, 0xff849723, 0x000796e9, 21
	dspck_tsimm append, 0xffffffff, 0x7fffffff, 0xc71c71c7, 2
	dspck_tsimm append, 0xfffffff0, 0xfffffff0, 0x80000006, 0
	dspck_tsimm append, 0x000007f8, 0x000000ff, 0x00000000, 3
	dspck_tsimm append, 0x05900000, 0xfffa4164, 0x00000000, 18
	dspck_tsimm append, 0x000003ff, 0x0000003f, 0x7fffffff, 4
	dspck_tsimm append, 0x78000001, 0x0004372e, 0xf8000001, 31
	dspck_tsimm append, 0xfefffffb, 0xfffffffb, 0xfffffffb, 22
	dspck_tsimm append, 0x020f6aac, 0x0000107b, 0x006feaac, 13
	dspck_tsimm append, 0x0000003c, 0x0000000f, 0x3fffffe0, 2
	dspck_tsimm append, 0xf50dfa1d, 0xfea1bf43, 0xfffffffd, 3
	dspck_tsimm append, 0xb512a800, 0xfff6a255, 0x00000000, 11
	dspck_tsimm append, 0x80023a3b, 0x0ad67261, 0x00023a3b, 31
	dspck_tsimm append, 0xf9999999, 0x0000001f, 0x99999999, 29
	dspck_tsimm append, 0x00026381, 0x000004c7, 0x00000001, 7
	dspck_tsimm append, 0x80000000, 0x00000007, 0x00000000, 31
	dspck_tsimm append, 0xffff7bfc, 0xffff7bfc, 0xffffd30b, 0
	dspck_tsimm append, 0x000005f8, 0x80000002, 0x3ffffff8, 9
	dspck_tsimm append, 0x7ffffffe, 0x00000000, 0xfffffffe, 31
	dspck_tsimm append, 0x029735d1, 0x029735d1, 0xffffe9b6, 0
	dspck_tsimm append, 0x80002246, 0xffffffff, 0x00002246, 31
	dspck_tsimm append, 0xfffffe7b, 0xfffffe7b, 0x00006e8f, 0
	dspck_tsimm append, 0x000009c8, 0x00000139, 0xff00ff00, 3
	dspck_tsimm append, 0xe0000007, 0x7ffffffb, 0xe0000007, 31
	dspck_tsimm append, 0xffffffff, 0x7fffffff, 0x00000017, 3
	dspck_tsimm append, 0x0000001f, 0x0000000f, 0x7fffffff, 1
	dspck_tsimm append, 0x000076aa, 0x00000000, 0xf03a76aa, 17
	dspck_tsimm append, 0xfffffff0, 0x7fffffff, 0x80000000, 4
	dspck_tsimm append, 0x0000003e, 0x00000007, 0xfb1e10f6, 3
	dspck_tsimm append, 0x0000ffff, 0x0000ffff, 0x92492492, 0
	dspck_tsimm append, 0x0000001f, 0x80000000, 0x0000001f, 31
	dspck_tsimm append, 0xffff81dc, 0xfffff03b, 0xffffc1bc, 3
	dspck_tsimm append, 0x00001e3d, 0x00000000, 0x00001e3d, 28
	dspck_tsimm append, 0xffb26ef1, 0xfff64dde, 0x00000001, 3
	dspck_tsimm append, 0x0ffffff8, 0x00000001, 0xfffffff8, 27
	dspck_tsimm append, 0x00001c46, 0x00000e23, 0x80000000, 1
	dspck_tsimm append, 0xfffe03fe, 0xffffff01, 0xfffffffe, 9
	dspck_tsimm append, 0x8410795a, 0x7fffffff, 0x0410795a, 31
	dspck_tsimm append, 0xffffc223, 0xffffff84, 0xffff81a3, 7
	dspck_tsimm append, 0x00000000, 0x00000000, 0xfbd3119d, 0
	dspck_tsimm append, 0x00000000, 0x00000000, 0xfff4148a, 1
	dspck_tsimm append, 0xffff8a84, 0xfffff150, 0xe468dc34, 3
	dspck_tsimm append, 0x00000000, 0x00000000, 0x00000000, 0
	dspck_tsimm append, 0x00003ffe, 0x80000000, 0xfffffffe, 14
	dspck_tsimm append, 0x00000000, 0x80000000, 0xfe261ae0, 3
	dspck_tsimm append, 0x0000003e, 0x0000003e, 0x0000006d, 0
	dspck_tsimm append, 0x00000000, 0x07fffffe, 0x80000000, 31
	dspck_tsimm append, 0x00e4fe00, 0x0001c9fc, 0x80000000, 7
	dspck_tsimm append, 0x7f00ff00, 0xff804b6c, 0xff00ff00, 31
	dspck_tsimm append, 0xfffff000, 0x7ffffffc, 0x80000000, 10
	dspck_tsimm append, 0x00000002, 0x00000001, 0x1ffffffe, 1
	dspck_tsimm append, 0xf072726f, 0x7fffffff, 0x0072726f, 28
	dspck_tsimm append, 0x80000002, 0x80000002, 0x7fffffff, 0
	dspck_tsimm append, 0x00013d29, 0x000027a5, 0xff4cd0b9, 3
	dspck_tsimm append, 0x20000000, 0x2b1945c4, 0x00000000, 27
	dspck_tsimm append, 0xfffff000, 0x7fffffff, 0x00000000, 12
	dspck_tsimm append, 0xf5b64a46, 0xf5b64a46, 0x8000001f, 0
	dspck_tsimm append, 0xe0000007, 0xe0000007, 0x80000000, 0
	dspck_tsimm append, 0x00000017, 0x80000001, 0x00009bc7, 4
	dspck_tsimm append, 0x0000003f, 0xf0000003, 0x7fffffff, 4
	dspck_tsimm append, 0x80000000, 0xf8000003, 0x00000000, 31
	dspck_tsimm append, 0xfffffb48, 0x7fffffff, 0xfffffb48, 31
	dspck_tsimm append, 0x00000004, 0x00000004, 0x80000000, 0
	dspck_tsimm append, 0xa5800000, 0x00007296, 0x80000000, 22
	dspck_tsimm append, 0xc71c401f, 0x71c71c71, 0x8000001f, 14
	dspck_tsimm append, 0x8000001f, 0x8000001f, 0x000000f2, 0
	dspck_tsimm append, 0x08dacc7f, 0x00a411b5, 0xffbe4c7f, 15
	dspck_tsimm append, 0x00003fe0, 0x000000ff, 0xffffffe0, 6
	dspck_tsimm append, 0x07305dfd, 0xffdc1cc1, 0x037a5dfd, 14
	dspck_tsimm append, 0xcccccccc, 0xcccccccc, 0x00066420, 0
	dspck_tsimm append, 0xfffffff6, 0x7ffffffb, 0x00000000, 1
	dspck_tsimm append, 0x00000007, 0x80000000, 0xf0000007, 3
	dspck_tsimm append, 0xff000001, 0x7fffffff, 0xf8000001, 24
	dspck_tsimm append, 0xffffffff, 0x7fffffff, 0x7fffffff, 28
	dspck_tsimm append, 0x8c7ffff9, 0xfffffa31, 0x7ffffff9, 22
	dspck_tsimm append, 0x8000003f, 0xffffffff, 0x8000003f, 31
	dspck_tsimm append, 0x0000000f, 0x0000000f, 0xffffffc0, 0
	dspck_tsimm append, 0xf0000003, 0xf0000003, 0x80000000, 0
	dspck_tsimm append, 0x00002b44, 0x80000000, 0x00042b44, 14
	dspck_tsimm append, 0x76680c00, 0xed1d9a03, 0x80000000, 10
	dspck_tsimm append, 0x000d3ca7, 0x000d3ca7, 0x7fffffff, 0
	dspck_tsimm append, 0xffffb15c, 0x7fffffff, 0x0029b15c, 15
	dspck_tsimm append, 0xfffffffb, 0x7fffffff, 0xff80a663, 3
	dspck_tsimm append, 0x000018b3, 0x00000c59, 0x000944f9, 1
	dspck_tsimm append, 0x80000000, 0x80000000, 0x80000000, 0
	dspck_tsimm append, 0xfffffa00, 0xfffffffd, 0x00000000, 9
	dspck_tsimm append, 0x38e38e38, 0x1c71c71c, 0xf0f0f0f0, 1
	dspck_tsimm append, 0x00000b58, 0x00000b58, 0xffe0425f, 0
	dspck_tsimm append, 0x0000001c, 0x00000007, 0x80000000, 2
	dspck_tsimm append, 0x7fffffff, 0x7fffffff, 0x0545da72, 0
	dspck_tsimm append, 0x2bffffff, 0x001bef2b, 0x7fffffff, 24
	dspck_tsimm append, 0x000000c7, 0x00000000, 0xc71c71c7, 8
	dspck_tsimm append, 0xffff5ffe, 0xffffffd7, 0xfffffffe, 10
	dspck_tsimm append, 0xffffff80, 0xffffffe0, 0x00000000, 2
	dspck_tsimm append, 0xffffffcc, 0x0ffffffc, 0xfffceb9c, 4
	dspck_tsimm append, 0x036d1448, 0x00036d14, 0xffff2348, 8
	dspck_tsimm append, 0xcb0fffff, 0xffff5961, 0x7fffffff, 19
	dspck_tsimm append, 0x00000000, 0x00000000, 0x00000000, 0
	dspck_tsimm append, 0xfffffffe, 0x7fffffff, 0x80000000, 1
	dspck_tsimm append, 0xffffffff, 0xffffffff, 0x7fffffff, 1
	dspck_tsimm append, 0xfffffffd, 0x7fffffff, 0x00000225, 3
	dspck_tsimm append, 0xe0000000, 0x00ff00ff, 0x80000000, 29
	dspck_tsimm append, 0xfffffff7, 0xfffffff7, 0x71c71c71, 0
	dspck_tsimm append, 0xffc00002, 0xfffffffe, 0x80000002, 21
	dspck_tsimm append, 0x00000003, 0x00000000, 0x00000027, 2
	dspck_tsimm append, 0xfffffff8, 0x7fffffff, 0x0ffffff8, 9
	dspck_tsimm append, 0x51a45fff, 0x00328d22, 0x7fffffff, 13
	dspck_tsimm append, 0x00003f00, 0x00000000, 0xffffff00, 14
	dspck_tsimm append, 0x00000004, 0x00000004, 0x00000000, 0
	dspck_tsimm append, 0x7fffffff, 0x7fffffff, 0xfeec3b3a, 0
	dspck_tsimm append, 0x80000000, 0x80000000, 0xfc07f8c2, 0
	dspck_tsimm append, 0x8000006b, 0xfc000001, 0x0000006b, 31
	dspck_tsimm append, 0xffff9db6, 0x7fffffff, 0xffff9db6, 18
	dspck_tsimm append, 0x00000000, 0x00000000, 0xe38e38e3, 0
	dspck_tsimm append, 0xffffffff, 0x7fffffff, 0xffffffff, 14
	dspck_tsimm append, 0x05ec1bfc, 0x00017b06, 0x07fffffc, 10
	dspck_tsimm append, 0xff800000, 0xffffffe0, 0x80000000, 18
	dspck_tsimm append, 0xffffffff, 0x7fffffff, 0x7fffffff, 19
	dspck_tsimm append, 0x8f0f0f0f, 0x7fffffff, 0x0f0f0f0f, 31
	dspck_tsimm append, 0x38e38e39, 0x1c71c71c, 0xfffffffb, 1
	dspck_tsimm append, 0x1c71c71c, 0x1c71c71c, 0xffffc119, 0
	dspck_tsimm append, 0x00000004, 0x00000004, 0x80000000, 0
	dspck_tsimm append, 0x00000005, 0x80000000, 0x00000005, 27
	dspck_tsimm append, 0xfffffe00, 0xfffffffe, 0x00000000, 8

	writemsg "[7] Test balign"
	dspck_tsimm balign, 0x1f01fd01, 0x001f01fd, 0x015ca9c0, 1
	dspck_tsimm balign, 0x00000000, 0x00000000, 0x00000000, 3
	dspck_tsimm balign, 0x710000f7, 0x71c71c71, 0x0000f73c, 3
	dspck_tsimm balign, 0x1b000000, 0x0000001b, 0x0000001b, 3
	dspck_tsimm balign, 0xf900248f, 0x7ffffff9, 0x00248f28, 3
	dspck_tsimm balign, 0x00003d00, 0x0000003d, 0x00000001, 1
	dspck_tsimm balign, 0xffff807f, 0x7fffff80, 0x7fffffff, 1
	dspck_tsimm balign, 0x4b000000, 0x0000004b, 0x00000000, 3
	dspck_tsimm balign, 0xffff8000, 0xffffff80, 0x002fdb08, 1
	dspck_tsimm balign, 0x0ab8dd00, 0x000ab8dd, 0x000064a2, 1
	dspck_tsimm balign, 0xffffffe2, 0x7fffffff, 0xe29d63ad, 1
	dspck_tsimm balign, 0xf803ffff, 0x3ffffff8, 0x03fffffe, 3
	dspck_tsimm balign, 0x3d800000, 0xfffe6a3d, 0x80000000, 3
	dspck_tsimm balign, 0x00000000, 0x00000000, 0x00000000, 3
	dspck_tsimm balign, 0xffe96d00, 0xffffe96d, 0x00000000, 1
	dspck_tsimm balign, 0x000000c7, 0x80000000, 0xc71c71c7, 1
	dspck_tsimm balign, 0x3e8aac80, 0x003e8aac, 0x80000000, 1
	dspck_tsimm balign, 0x00000000, 0x80000000, 0x0000000f, 3
	dspck_tsimm balign, 0xfca3d07f, 0xfffca3d0, 0x7fffffff, 1
	dspck_tsimm balign, 0xffff8055, 0xffffff80, 0x55555555, 1
	dspck_tsimm balign, 0xffffffff, 0x7fffffff, 0xfffffff8, 1
	dspck_tsimm balign, 0x80ffffff, 0xffffff80, 0xffffff80, 3
	dspck_tsimm balign, 0x91000000, 0x0cf0c191, 0x00000000, 3
	dspck_tsimm balign, 0xffff5503, 0xffffff55, 0x0374dc74, 1
	dspck_tsimm balign, 0x000000c0, 0x80000000, 0xc0000001, 1
	dspck_tsimm balign, 0x0000087f, 0x00000008, 0x7fffffff, 1
	dspck_tsimm balign, 0xe7050500, 0xffe70505, 0x00000069, 1
	dspck_tsimm balign, 0x007fffff, 0x00000000, 0x7fffffff, 3
	dspck_tsimm balign, 0xffffe0ff, 0xffffffe0, 0xffffffe0, 1
	dspck_tsimm balign, 0xfffffe00, 0x3ffffffe, 0x00000000, 1
	dspck_tsimm balign, 0xffff80ff, 0xffffff80, 0xffe4aca7, 1
	dspck_tsimm balign, 0x01800000, 0x00000001, 0x80000005, 3
	dspck_tsimm balign, 0x0fffffff, 0x0000000f, 0xffffff39, 3
	dspck_tsimm balign, 0xd05dfc00, 0x1bd05dfc, 0x004e7d52, 1
	dspck_tsimm balign, 0xf8fffa05, 0x0ffffff8, 0xfffa0520, 3
	dspck_tsimm balign, 0x00000000, 0x00000000, 0x00000000, 1
	dspck_tsimm balign, 0xffffeeff, 0xffffffee, 0xff7ccdf7, 1
	dspck_tsimm balign, 0x00000180, 0x80000001, 0x80000001, 1
	dspck_tsimm balign, 0xfc7fffff, 0x3ffffffc, 0x7fffffc0, 3
	dspck_tsimm balign, 0xc71c7100, 0x71c71c71, 0x00000000, 1
	dspck_tsimm balign, 0x555555ff, 0x55555555, 0xffff0000, 1
	dspck_tsimm balign, 0x33f80000, 0x02f67833, 0xf8000001, 3
	dspck_tsimm balign, 0x03029747, 0xf0000003, 0x029747e5, 3
	dspck_tsimm balign, 0x00516bff, 0x0000516b, 0xfffffd33, 1
	dspck_tsimm balign, 0xf86db6db, 0x7ffffff8, 0x6db6db6d, 3
	dspck_tsimm balign, 0xf87fffff, 0x0ffffff8, 0x7fffffff, 3
	dspck_tsimm balign, 0x107fffff, 0x00018c10, 0x7fffffff, 3
	dspck_tsimm balign, 0xf2a6e180, 0xfff2a6e1, 0x80000000, 1
	dspck_tsimm balign, 0x0000000f, 0x80000000, 0x0ffffffe, 1
	dspck_tsimm balign, 0x000000e0, 0x00000000, 0xe0000001, 1
	dspck_tsimm balign, 0x00000000, 0x00000000, 0x00000000, 1
	dspck_tsimm balign, 0x5b00193c, 0xffff9e5b, 0x00193cb0, 3
	dspck_tsimm balign, 0x0000007f, 0x80000000, 0x7fffffff, 1
	dspck_tsimm balign, 0x0000070f, 0x80000007, 0x0ffffffc, 1
	dspck_tsimm balign, 0xff0f0f0f, 0x7fffffff, 0x0f0f0f0f, 3
	dspck_tsimm balign, 0xefc00000, 0xffffffef, 0xc0000001, 3
	dspck_tsimm balign, 0x00000c0f, 0x0000000c, 0x0ffffffc, 1
	dspck_tsimm balign, 0x05000000, 0x00000005, 0x00000001, 3
	dspck_tsimm balign, 0x00000000, 0x00000000, 0x00000007, 1
	dspck_tsimm balign, 0x0effffff, 0xffff300e, 0xfffffffe, 3
	dspck_tsimm balign, 0x1fffeb60, 0x8000001f, 0xffeb607e, 3
	dspck_tsimm balign, 0x10bbe280, 0x0110bbe2, 0x80000004, 1
	dspck_tsimm balign, 0xffe25c1f, 0xffffe25c, 0x1ffffffc, 1
	dspck_tsimm balign, 0xffffffff, 0x00ff00ff, 0xfffffffb, 3
	dspck_tsimm balign, 0x00000000, 0x00000000, 0x00f2f43d, 1
	dspck_tsimm balign, 0xffb97400, 0xffffb974, 0x00000000, 1
	dspck_tsimm balign, 0xfffa5400, 0xfffffa54, 0x00000000, 1
	dspck_tsimm balign, 0x4d000543, 0x0005434d, 0x0005434d, 3
	dspck_tsimm balign, 0x00000080, 0x80000000, 0x80000000, 1
	dspck_tsimm balign, 0xfffe1fff, 0xfffffe1f, 0xfffffffe, 1
	dspck_tsimm balign, 0x000000aa, 0x80000000, 0xaaaaaaaa, 1
	dspck_tsimm balign, 0xfffff6c0, 0xfffffff6, 0xc000001f, 1
	dspck_tsimm balign, 0xffffff00, 0x7fffffff, 0x00000000, 1
	dspck_tsimm balign, 0xff800000, 0x7fffffff, 0x80000000, 3
	dspck_tsimm balign, 0x00800000, 0x80000000, 0x80000000, 3
	dspck_tsimm balign, 0xffffffff, 0x7fffffff, 0xffffff00, 3
	dspck_tsimm balign, 0x00000380, 0x80000003, 0x80000000, 1
	dspck_tsimm balign, 0xf08e38e3, 0x1ffffff0, 0x8e38e38e, 3
	dspck_tsimm balign, 0xfffff800, 0xfffffff8, 0x00005016, 1
	dspck_tsimm balign, 0xff000000, 0x7fffffff, 0x00000000, 3
	dspck_tsimm balign, 0x00000700, 0x00000007, 0x00002153, 1
	dspck_tsimm balign, 0xff800000, 0xffffffff, 0x80000000, 3
	dspck_tsimm balign, 0xffffff80, 0x7fffffff, 0x80000000, 1
	dspck_tsimm balign, 0xfe000000, 0x0ffffffe, 0x00000000, 3
	dspck_tsimm balign, 0xfffffde7, 0xfffffffd, 0xe75d405c, 1
	dspck_tsimm balign, 0xfd982d7f, 0xfffd982d, 0x7fffffff, 1
	dspck_tsimm balign, 0xff7fffff, 0x7fffffff, 0x7ffffffe, 3
	dspck_tsimm balign, 0x00000000, 0x00000000, 0x00000002, 3
	dspck_tsimm balign, 0x5e7fffff, 0xff8bdc5e, 0x7fffffff, 3
	dspck_tsimm balign, 0xffffffff, 0x7fffffff, 0xffffffe6, 1
	dspck_tsimm balign, 0x00007f00, 0x8000007f, 0x00001059, 1
	dspck_tsimm balign, 0x0000007f, 0x00000000, 0x7fffffff, 1
	dspck_tsimm balign, 0x51800000, 0x32b3c151, 0x80000006, 3
	dspck_tsimm balign, 0x000000c0, 0x00000000, 0xc000001f, 1
	dspck_tsimm balign, 0x00fff286, 0x80000000, 0xfff2864d, 3
	dspck_tsimm balign, 0x00001ae4, 0x00000000, 0x001ae4b6, 3
	dspck_tsimm balign, 0x00000300, 0xf8000003, 0x00000000, 1
	dspck_tsimm balign, 0x00000000, 0x00000000, 0x00000000, 1
	dspck_tsimm balign, 0x06f655e9, 0x80000006, 0xf655e94f, 3
	dspck_tsimm balign, 0xff000000, 0x7fffffff, 0x000000a9, 3
	dspck_tsimm balign, 0x00000780, 0xc0000007, 0x80000001, 1
	dspck_tsimm balign, 0x60ffffff, 0xffff8860, 0xffffffc8, 3
	dspck_tsimm balign, 0xfffffef8, 0xfffffffe, 0xf8000001, 1
	dspck_tsimm balign, 0x000000db, 0x00000000, 0xdb6db6db, 1
	dspck_tsimm balign, 0xfd800000, 0xfffffffd, 0x80000001, 3
	dspck_tsimm balign, 0xf1800000, 0x0002e7f1, 0x80000000, 3
	dspck_tsimm balign, 0x0d000002, 0x0000000d, 0x000002f2, 3
	dspck_tsimm balign, 0xffffffff, 0x7fffffff, 0xfffffffd, 1
	dspck_tsimm balign, 0x00000000, 0x00000000, 0x0000001c, 1
	dspck_tsimm balign, 0xfffffa00, 0xfffffffa, 0x00000000, 1
	dspck_tsimm balign, 0xffffffff, 0x7fffffff, 0xffffe59b, 1
	dspck_tsimm balign, 0x00ffffff, 0x00000000, 0xfffffff9, 3
	dspck_tsimm balign, 0xffffff7f, 0x7fffffff, 0x7fffffff, 1
	dspck_tsimm balign, 0xfffffff9, 0xffffffff, 0xfffff92d, 3
	dspck_tsimm balign, 0xaaaaaaff, 0xaaaaaaaa, 0xffffedc7, 1
	dspck_tsimm balign, 0xffffff7f, 0x7fffffff, 0x7ffffff9, 1
	dspck_tsimm balign, 0x800e0ff8, 0xffffff80, 0x0e0ff8b5, 3
	dspck_tsimm balign, 0xfff36500, 0xfffff365, 0x00000005, 1
	dspck_tsimm balign, 0x00000000, 0x00000000, 0x00000001, 1

	writemsg "[8] Test cmpgdu.eq.qb"
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x1ef101ff, 0x07270316, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x06cc0001, 0x24000102, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x1f8fc0ff, 0x28001e24, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000004, 0x03ff0001, 0x37ff0405, 0x0, 0x04000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x0083ffdf, 0xfe000007, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x001000ff, 0x3fff0a12, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000002, 0xbfff0008, 0xc7000002, 0x0, 0x02000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x091c038e, 0x02600600, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000008, 0xff0801ff, 0xff00cc08, 0x0, 0x08000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x06ffc700, 0x0300830d, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x021f1e01, 0x3c000100, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x0cff0a3e, 0xf73ee700, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x1e00ff04, 0x00ff0fdf, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x01ff0106, 0x001d49ff, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000002, 0x7f000000, 0x088100cc, 0x0, 0x02000000
	dspck_dstio cmpgdu.eq.qb, 0x00000008, 0xff3e3e01, 0xff010700, 0x0, 0x08000000
	dspck_dstio cmpgdu.eq.qb, 0x00000004, 0x3800e3ff, 0x00000000, 0x0, 0x04000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x02fffe33, 0xf00b32ff, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0xef1ff81e, 0x000e0f8e, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x04c02400, 0xff9f1355, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000009, 0x00000000, 0x0004ff00, 0x0, 0x09000000
	dspck_dstio cmpgdu.eq.qb, 0x00000008, 0x00000000, 0x00021a3a, 0x0, 0x08000000
	dspck_dstio cmpgdu.eq.qb, 0x00000004, 0x05000001, 0x0f0002f7, 0x0, 0x04000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x49aa3101, 0x00008fef, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x6bc30000, 0xf0ff01ff, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x13c10138, 0x3a380eff, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x3c1f0000, 0xe000ff16, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x05efff26, 0xff001f03, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x0000000f, 0xff495500, 0xff495500, 0x0, 0x0f000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x00e7ff2b, 0x4bff1eff, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x33ffff78, 0x306d0018, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x17207c00, 0x021b006c, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000004, 0xff008003, 0x0200ff0f, 0x0, 0x04000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0xffe71605, 0xf30703ff, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000001, 0x0e031e01, 0x3801aa01, 0x0, 0x01000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0xfff939df, 0x2f001f00, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000002, 0x70240080, 0x00000066, 0x0, 0x02000000
	dspck_dstio cmpgdu.eq.qb, 0x00000002, 0x720aff00, 0x0033ff3f, 0x0, 0x02000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x21007219, 0x19ffff00, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000004, 0x7f004508, 0x0000ff49, 0x0, 0x04000000
	dspck_dstio cmpgdu.eq.qb, 0x0000000f, 0x510000ff, 0x510000ff, 0x0, 0x0f000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0xff180000, 0xc0ffdf33, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x3e013603, 0x07ff4d3c, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000001, 0x00f106ff, 0x9900ffff, 0x0, 0x01000000
	dspck_dstio cmpgdu.eq.qb, 0x00000008, 0xffff0754, 0xff0117ff, 0x0, 0x08000000
	dspck_dstio cmpgdu.eq.qb, 0x0000000f, 0x1c0c0008, 0x1c0c0008, 0x0, 0x0f000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x0808ccff, 0x00000000, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0xff020012, 0x00f001ff, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x03ff0027, 0xf1014005, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0xbf3312ff, 0x18ffff06, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x00073004, 0x7eb60799, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x03feff00, 0x021cfcff, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000004, 0xfeff0203, 0x00ff0409, 0x0, 0x04000000
	dspck_dstio cmpgdu.eq.qb, 0x00000001, 0xfdff7638, 0x000e0138, 0x0, 0x01000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x031effff, 0xc131077d, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x09c3c7ff, 0xdb000700, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x120c0055, 0x1133ff06, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x20ff0336, 0x0904403f, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x1a007e00, 0x8301c0ff, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x0b00ffc3, 0x00c018e3, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x0000000e, 0xff05db6d, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0xc3340000, 0x83ffff01, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x01e10078, 0x090caa0e, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000001, 0xff01ef00, 0x00000000, 0x0, 0x01000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x3bdf081e, 0x658eff71, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x0000000f, 0x0020dfff, 0x0020dfff, 0x0, 0x0f000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x00ff0cb6, 0xf801db00, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x00381a66, 0x01017501, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000004, 0x01006600, 0x2d0006ff, 0x0, 0x04000000
	dspck_dstio cmpgdu.eq.qb, 0x00000002, 0x00000000, 0x663300ff, 0x0, 0x02000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x001e00e7, 0x01064905, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x0b26ffc0, 0x51160001, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x252f0300, 0x26004f0e, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x00000000, 0x830a4a03, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000001, 0x7b2b0200, 0x07aa0600, 0x0, 0x01000000
	dspck_dstio cmpgdu.eq.qb, 0x00000002, 0x070000ff, 0xfff900f9, 0x0, 0x02000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0xff706dff, 0x24ff01df, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x3c050071, 0x10003eff, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x703f0018, 0xe0003500, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0xff0ff803, 0x0b008335, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0xffff08aa, 0x063003f0, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000004, 0xef008e10, 0x00000000, 0x0, 0x04000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x09ff0000, 0x003f11ff, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000002, 0x00000033, 0x04020000, 0x0, 0x02000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x05000114, 0x55ff070c, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000008, 0xff3d3870, 0xff007840, 0x0, 0x08000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x8055ff6d, 0x0cff38f3, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000008, 0x00010024, 0x007999ff, 0x0, 0x08000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x0200ff01, 0x7d380002, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x0a062702, 0x00650bff, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000002, 0xf9160002, 0xff8700ff, 0x0, 0x02000000
	dspck_dstio cmpgdu.eq.qb, 0x00000001, 0x00000000, 0x1f293800, 0x0, 0x01000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x13000700, 0x01ffaa3d, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x0101ff14, 0x00497102, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0xff7066ff, 0xc100db24, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x6a787000, 0x00247c6f, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x210000ff, 0x01ff1e1c, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x06ff7703, 0xff00f90e, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x27fc39ff, 0x00053e00, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0xffff3023, 0x65009f30, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0xc78e0ccf, 0x003048ff, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000001, 0xe7920000, 0x00007f00, 0x0, 0x01000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0xff1ae1f8, 0x00000000, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x0049ff87, 0x01ff8f00, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x00ff3855, 0xc30619ff, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000004, 0x0400ffff, 0x0000030e, 0x0, 0x04000000
	dspck_dstio cmpgdu.eq.qb, 0x00000001, 0x02300100, 0xfffddb00, 0x0, 0x01000000
	dspck_dstio cmpgdu.eq.qb, 0x0000000f, 0xfc000eff, 0xfc000eff, 0x0, 0x0f000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x2605032f, 0xff3381ff, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x00ff11f9, 0xaa0e01ff, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x1fff0a01, 0x00000000, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x2a000201, 0x49ff0600, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x0007ff3c, 0xffe70107, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x00000000, 0x7c0c18db, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0xc71d01ff, 0x00004900, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000004, 0x8700e71f, 0x2500f739, 0x0, 0x04000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x83060570, 0xf9ff2002, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000008, 0xff003c00, 0xffffff02, 0x0, 0x08000000
	dspck_dstio cmpgdu.eq.qb, 0x00000001, 0x2d09ffff, 0x020006ff, 0x0, 0x01000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x00380c1c, 0x3800f9ff, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x000f04e3, 0x7f11382f, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000002, 0x001eff00, 0xcc01ff04, 0x0, 0x02000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x00107f00, 0x7f01048f, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000008, 0x00000000, 0x00ffdbff, 0x0, 0x08000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x0e30c107, 0x03ff1200, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000002, 0xc157ff00, 0x1c08ff03, 0x0, 0x02000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x4100ff00, 0x0804c070, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x01ff03ff, 0x00f800c0, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000004, 0x00000a3d, 0x0c0000cc, 0x0, 0x04000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x60ff3801, 0xff0099e7, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x000500fc, 0x0100133c, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x00b60113, 0x1eff0400, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000002, 0xff06ffff, 0x01ffff02, 0x0, 0x02000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x26000500, 0xffc3ff03, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x00183e01, 0xff1ef0ff, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000008, 0xff00ffff, 0xff05251a, 0x0, 0x08000000
	dspck_dstio cmpgdu.eq.qb, 0x00000004, 0x300000ff, 0x00000e04, 0x0, 0x04000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x001ec700, 0xff0303e7, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000001, 0x000a16ff, 0x01001fff, 0x0, 0x01000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0xff550703, 0x00000000, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x55010602, 0x1a208787, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000001, 0x00ff02ff, 0xff026dff, 0x0, 0x01000000
	dspck_dstio cmpgdu.eq.qb, 0x00000005, 0x3effffff, 0x0eff20ff, 0x0, 0x05000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x49fd0004, 0xcf00fe66, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x00064000, 0xf920ffff, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x0000fff9, 0xff1f00ff, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000008, 0x008700ff, 0x00ff4000, 0x0, 0x08000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x00ff87e0, 0x0e00ffff, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x04ff0900, 0x3192ff06, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x00000b06, 0xffff0104, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x00ff1800, 0x8ec3f3f8, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0xc18155e7, 0x0007130c, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x0f1e0f08, 0xff3e0700, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000004, 0x00ff8706, 0xb6ffffff, 0x0, 0x04000000
	dspck_dstio cmpgdu.eq.qb, 0x00000001, 0x00000000, 0x2401ff00, 0x0, 0x01000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x010a0c18, 0x1c010000, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x0b00f110, 0x320304aa, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000004, 0x03ff0000, 0x13ffffc1, 0x0, 0x04000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x1203fffd, 0x002e0180, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0xff0130e7, 0x01c0fff1, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x60001f1d, 0xfd04ff01, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000001, 0xe7093f00, 0x00000000, 0x0, 0x01000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x01df0c18, 0x00f9feff, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000008, 0x000060df, 0x0008ff00, 0x0, 0x08000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x80ff0400, 0x002403c7, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0xe71e1f00, 0x02ff1cff, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x8f9260ff, 0x9200c302, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x0000000f, 0x55117cff, 0x55117cff, 0x0, 0x0f000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0xffff01ff, 0x012c0078, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0xffe30702, 0x0c000083, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x0371c092, 0xffe08f60, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x00000000, 0x38ff0301, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0xff017c03, 0x8edf02ff, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000008, 0xff000000, 0xffb60c92, 0x0, 0x08000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x8100ff38, 0xff8f4aff, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x000340ff, 0x02002002, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000008, 0x00000000, 0x008f1c01, 0x0, 0x08000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x33183b51, 0x0a0afecc, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000005, 0x00000000, 0x06003000, 0x0, 0x05000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0xffff6020, 0x0008570f, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000001, 0x6f71ffff, 0xffcf00ff, 0x0, 0x01000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x40aa3000, 0xff009202, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x8e03fee7, 0x132d0001, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x0c71109f, 0xc0f9ffff, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000008, 0x0103009f, 0x01021f00, 0x0, 0x08000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x0e0ac7c7, 0x06fd0bfe, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x000aff66, 0x040002c0, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0xffff01ff, 0x1109fd00, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x013a1c0f, 0x04010003, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000008, 0x0009f1ff, 0x0000783e, 0x0, 0x08000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0xf81e01ff, 0x0001837f, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000004, 0xffff0160, 0xaafffffc, 0x0, 0x04000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x001eff1f, 0x9f0a0301, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000004, 0xf9ffffc7, 0x00ff0200, 0x0, 0x04000000
	dspck_dstio cmpgdu.eq.qb, 0x00000008, 0xff030092, 0xffff0133, 0x0, 0x08000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x1b00001e, 0x6f07ff14, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x3c000fff, 0x00ff0201, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x1ff03f60, 0x01b6fe00, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x03062003, 0x87df80ff, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x0a240104, 0x33010242, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x3200039f, 0x00ff0003, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000002, 0xcf00ff00, 0x0006ff03, 0x0, 0x02000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x1f044401, 0x00008f2c, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x0301ff03, 0x7c0001ff, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000001, 0x8307c100, 0x00000000, 0x0, 0x01000000
	dspck_dstio cmpgdu.eq.qb, 0x00000004, 0x0300e7ff, 0x52004902, 0x0, 0x04000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x1f0f07c7, 0xff010100, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000009, 0x00ff0000, 0x0000ff00, 0x0, 0x09000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0xf806c1ff, 0xffff06df, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x66383f0a, 0xaa07ff03, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x60db1e0a, 0x00000000, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000004, 0x01000cff, 0x00000000, 0x0, 0x04000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x002b71c0, 0xcf12ff0a, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x68098102, 0xfc788e00, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x24543c00, 0x7fbfff01, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x01ff8ff7, 0x24000033, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x0101b670, 0xdf02ff05, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000002, 0x60050000, 0xff040001, 0x0, 0x02000000
	dspck_dstio cmpgdu.eq.qb, 0x00000008, 0xff1f0c00, 0xff02ff06, 0x0, 0x08000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0xf9fff834, 0xdf06c102, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000006, 0xc1000301, 0x4200030a, 0x0, 0x06000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x00ff0200, 0x601c001f, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000009, 0x003e04ff, 0x001800ff, 0x0, 0x09000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x0aff1a00, 0x3ec0000d, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000009, 0x0137fc71, 0x0102ff71, 0x0, 0x09000000
	dspck_dstio cmpgdu.eq.qb, 0x00000008, 0x0055000e, 0x00e3dbff, 0x0, 0x08000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0xe7e0ff1f, 0xff050701, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x813400ff, 0x666a0d01, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000002, 0x1b73ffc0, 0x002dff78, 0x0, 0x02000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x251f0340, 0x2300ffff, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x02ff3f00, 0x0001ff1d, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x0002ff80, 0xf88300ff, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000001, 0x01092400, 0x3e07cf00, 0x0, 0x01000000
	dspck_dstio cmpgdu.eq.qb, 0x00000002, 0x050aff00, 0xff7cffff, 0x0, 0x02000000
	dspck_dstio cmpgdu.eq.qb, 0x00000000, 0x2b00ffff, 0x020178fc, 0x0, 0x00000000
	dspck_dstio cmpgdu.eq.qb, 0x00000001, 0x02ff8f00, 0x00c70300, 0x0, 0x01000000

	writemsg "[9] Test cmpgdu.lt.qb"
	dspck_dstio cmpgdu.lt.qb, 0x00000006, 0xff0000ff, 0x3a0cffff, 0x0, 0x06000000
	dspck_dstio cmpgdu.lt.qb, 0x00000006, 0x1b0c03f8, 0x178f2d0d, 0x0, 0x06000000
	dspck_dstio cmpgdu.lt.qb, 0x00000000, 0x0a02ff7f, 0x00000000, 0x0, 0x00000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000e, 0x18003cff, 0xff0b7e00, 0x0, 0x0e000000
	dspck_dstio cmpgdu.lt.qb, 0x00000002, 0x03300018, 0x0200df06, 0x0, 0x02000000
	dspck_dstio cmpgdu.lt.qb, 0x00000006, 0xdfdbe7ff, 0x00ffffbf, 0x0, 0x06000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000c, 0xfd026046, 0xff1e1a07, 0x0, 0x0c000000
	dspck_dstio cmpgdu.lt.qb, 0x00000008, 0x00ffff0d, 0x1dffe300, 0x0, 0x08000000
	dspck_dstio cmpgdu.lt.qb, 0x00000009, 0x00009f00, 0xff002b06, 0x0, 0x09000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000a, 0x0201007f, 0x8e007f10, 0x0, 0x0a000000
	dspck_dstio cmpgdu.lt.qb, 0x00000008, 0x3666c1aa, 0xff060000, 0x0, 0x08000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000d, 0x00001a02, 0xffff006d, 0x0, 0x0d000000
	dspck_dstio cmpgdu.lt.qb, 0x00000000, 0xb6df10e3, 0xb6df10e3, 0x0, 0x00000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000e, 0x0e1e027c, 0xef492d00, 0x0, 0x0e000000
	dspck_dstio cmpgdu.lt.qb, 0x00000000, 0x03ff031c, 0x00010001, 0x0, 0x00000000
	dspck_dstio cmpgdu.lt.qb, 0x00000008, 0x03ffff6c, 0x1604df00, 0x0, 0x08000000
	dspck_dstio cmpgdu.lt.qb, 0x00000000, 0xf8fc02fd, 0x00240030, 0x0, 0x00000000
	dspck_dstio cmpgdu.lt.qb, 0x00000007, 0x0f000300, 0x00030f18, 0x0, 0x07000000
	dspck_dstio cmpgdu.lt.qb, 0x00000001, 0xf1ffff06, 0x9200f114, 0x0, 0x01000000
	dspck_dstio cmpgdu.lt.qb, 0x00000007, 0xff310800, 0x005cff0c, 0x0, 0x07000000
	dspck_dstio cmpgdu.lt.qb, 0x00000006, 0xff0008ff, 0x0107c70b, 0x0, 0x06000000
	dspck_dstio cmpgdu.lt.qb, 0x00000000, 0xff71003e, 0xff71003e, 0x0, 0x00000000
	dspck_dstio cmpgdu.lt.qb, 0x00000003, 0xffff0000, 0x1f00ffc3, 0x0, 0x03000000
	dspck_dstio cmpgdu.lt.qb, 0x00000004, 0x0e0108ff, 0x00ff051c, 0x0, 0x04000000
	dspck_dstio cmpgdu.lt.qb, 0x00000004, 0x6d01ffe1, 0x0bff017f, 0x0, 0x04000000
	dspck_dstio cmpgdu.lt.qb, 0x00000000, 0x038e02ff, 0x038e02ff, 0x0, 0x00000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000e, 0x180c1dff, 0xf31ec1ff, 0x0, 0x0e000000
	dspck_dstio cmpgdu.lt.qb, 0x00000003, 0xffff0209, 0x0000ff8f, 0x0, 0x03000000
	dspck_dstio cmpgdu.lt.qb, 0x00000002, 0x01390035, 0x000eff01, 0x0, 0x02000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000a, 0x00ff06ff, 0x30030cff, 0x0, 0x0a000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000b, 0x022c496d, 0xff0bf3ff, 0x0, 0x0b000000
	dspck_dstio cmpgdu.lt.qb, 0x00000005, 0x0d00e701, 0x061a0b2a, 0x0, 0x05000000
	dspck_dstio cmpgdu.lt.qb, 0x00000000, 0x0000ff18, 0x00000000, 0x0, 0x00000000
	dspck_dstio cmpgdu.lt.qb, 0x00000008, 0x009f010e, 0x33070100, 0x0, 0x08000000
	dspck_dstio cmpgdu.lt.qb, 0x00000007, 0xf1ef0001, 0x03ff0105, 0x0, 0x07000000
	dspck_dstio cmpgdu.lt.qb, 0x00000004, 0x2c0e138e, 0x00f70000, 0x0, 0x04000000
	dspck_dstio cmpgdu.lt.qb, 0x00000000, 0x1e077e18, 0x0500010b, 0x0, 0x00000000
	dspck_dstio cmpgdu.lt.qb, 0x00000009, 0x00ff0310, 0x3f0300ff, 0x0, 0x09000000
	dspck_dstio cmpgdu.lt.qb, 0x00000000, 0x00ffff76, 0x001ff303, 0x0, 0x00000000
	dspck_dstio cmpgdu.lt.qb, 0x00000001, 0xff0aff0e, 0x030000ff, 0x0, 0x01000000
	dspck_dstio cmpgdu.lt.qb, 0x00000006, 0x1e0002ff, 0x12cf3802, 0x0, 0x06000000
	dspck_dstio cmpgdu.lt.qb, 0x00000000, 0x018000fd, 0x018000fd, 0x0, 0x00000000
	dspck_dstio cmpgdu.lt.qb, 0x00000009, 0x0fffaa01, 0xf1383981, 0x0, 0x09000000
	dspck_dstio cmpgdu.lt.qb, 0x00000003, 0xffef0003, 0x0700ff40, 0x0, 0x03000000
	dspck_dstio cmpgdu.lt.qb, 0x00000006, 0xff02c167, 0x04cfff01, 0x0, 0x06000000
	dspck_dstio cmpgdu.lt.qb, 0x00000005, 0x79030300, 0x00e10106, 0x0, 0x05000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000c, 0x000104ff, 0xffff0110, 0x0, 0x0c000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000d, 0x0d0100cc, 0x0fff00df, 0x0, 0x0d000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000c, 0x0004ff3d, 0x0466ff03, 0x0, 0x0c000000
	dspck_dstio cmpgdu.lt.qb, 0x00000003, 0x78002c07, 0x2400f9f3, 0x0, 0x03000000
	dspck_dstio cmpgdu.lt.qb, 0x00000004, 0xff4000ff, 0x008100fe, 0x0, 0x04000000
	dspck_dstio cmpgdu.lt.qb, 0x00000003, 0x81c1014b, 0x1038c0ff, 0x0, 0x03000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000c, 0x020254ff, 0xffff0eff, 0x0, 0x0c000000
	dspck_dstio cmpgdu.lt.qb, 0x00000004, 0x0210ffcf, 0x00ff8019, 0x0, 0x04000000
	dspck_dstio cmpgdu.lt.qb, 0x00000004, 0x7100ff80, 0x01db557c, 0x0, 0x04000000
	dspck_dstio cmpgdu.lt.qb, 0x00000007, 0x3b17095e, 0x00db41b6, 0x0, 0x07000000
	dspck_dstio cmpgdu.lt.qb, 0x00000002, 0x40440500, 0x05016d00, 0x0, 0x02000000
	dspck_dstio cmpgdu.lt.qb, 0x00000006, 0xff0000ff, 0x010201fe, 0x0, 0x06000000
	dspck_dstio cmpgdu.lt.qb, 0x00000002, 0x07000000, 0x00004000, 0x0, 0x02000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000f, 0x00000000, 0x09f06699, 0x0, 0x0f000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000f, 0x60090b04, 0xffff1011, 0x0, 0x0f000000
	dspck_dstio cmpgdu.lt.qb, 0x00000000, 0x10cf00ff, 0x00000000, 0x0, 0x00000000
	dspck_dstio cmpgdu.lt.qb, 0x00000000, 0xf8040024, 0xf8040024, 0x0, 0x00000000
	dspck_dstio cmpgdu.lt.qb, 0x00000000, 0xffc0e7e3, 0x7c000000, 0x0, 0x00000000
	dspck_dstio cmpgdu.lt.qb, 0x00000003, 0x0721f104, 0x0501ff64, 0x0, 0x03000000
	dspck_dstio cmpgdu.lt.qb, 0x00000003, 0x55100000, 0x000f1a03, 0x0, 0x03000000
	dspck_dstio cmpgdu.lt.qb, 0x00000000, 0x20fff90f, 0x01aacc0a, 0x0, 0x00000000
	dspck_dstio cmpgdu.lt.qb, 0x00000004, 0x2603aa00, 0x0718aa00, 0x0, 0x04000000
	dspck_dstio cmpgdu.lt.qb, 0x00000000, 0xaa87f13c, 0x0003f003, 0x0, 0x00000000
	dspck_dstio cmpgdu.lt.qb, 0x00000003, 0x02ff0d0e, 0x000c20c3, 0x0, 0x03000000
	dspck_dstio cmpgdu.lt.qb, 0x00000000, 0xbf012492, 0xbf012492, 0x0, 0x00000000
	dspck_dstio cmpgdu.lt.qb, 0x00000000, 0xffff02fe, 0x00000000, 0x0, 0x00000000
	dspck_dstio cmpgdu.lt.qb, 0x00000006, 0x030001f7, 0x00ff1d02, 0x0, 0x06000000
	dspck_dstio cmpgdu.lt.qb, 0x00000004, 0xe326bfdf, 0x00f1010c, 0x0, 0x04000000
	dspck_dstio cmpgdu.lt.qb, 0x00000000, 0x0300ff00, 0x00000000, 0x0, 0x00000000
	dspck_dstio cmpgdu.lt.qb, 0x00000003, 0xc3090081, 0x000392ff, 0x0, 0x03000000
	dspck_dstio cmpgdu.lt.qb, 0x00000000, 0xc30200ff, 0xc30200ff, 0x0, 0x00000000
	dspck_dstio cmpgdu.lt.qb, 0x00000004, 0x1e101603, 0x02f90103, 0x0, 0x04000000
	dspck_dstio cmpgdu.lt.qb, 0x00000008, 0x16ffff8e, 0x307eff00, 0x0, 0x08000000
	dspck_dstio cmpgdu.lt.qb, 0x00000002, 0x870100ff, 0x3f000e00, 0x0, 0x02000000
	dspck_dstio cmpgdu.lt.qb, 0x00000005, 0x00000000, 0x001b00e3, 0x0, 0x05000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000c, 0x1e01ff24, 0xc3ff0000, 0x0, 0x0c000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000e, 0x00070040, 0x7f130227, 0x0, 0x0e000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000c, 0x00004902, 0x01f90400, 0x0, 0x0c000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000a, 0x00000eff, 0x02002408, 0x0, 0x0a000000
	dspck_dstio cmpgdu.lt.qb, 0x00000002, 0xf0f800ff, 0x01080c70, 0x0, 0x02000000
	dspck_dstio cmpgdu.lt.qb, 0x00000008, 0x01ff4700, 0x44003c00, 0x0, 0x08000000
	dspck_dstio cmpgdu.lt.qb, 0x00000008, 0x06f93fff, 0xff6d00ff, 0x0, 0x08000000
	dspck_dstio cmpgdu.lt.qb, 0x00000003, 0x0f030007, 0x00003449, 0x0, 0x03000000
	dspck_dstio cmpgdu.lt.qb, 0x00000000, 0xf91d3c00, 0x00000000, 0x0, 0x00000000
	dspck_dstio cmpgdu.lt.qb, 0x00000000, 0x00036d02, 0x00000000, 0x0, 0x00000000
	dspck_dstio cmpgdu.lt.qb, 0x00000004, 0x03200078, 0x02780002, 0x0, 0x04000000
	dspck_dstio cmpgdu.lt.qb, 0x00000000, 0x0206ff92, 0x0206ff92, 0x0, 0x00000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000e, 0x1f000000, 0x2ef83500, 0x0, 0x0e000000
	dspck_dstio cmpgdu.lt.qb, 0x00000006, 0x30010b16, 0x00021800, 0x0, 0x06000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000f, 0x66074600, 0xf06dff02, 0x0, 0x0f000000
	dspck_dstio cmpgdu.lt.qb, 0x00000000, 0x6ef1ff60, 0x00707102, 0x0, 0x00000000
	dspck_dstio cmpgdu.lt.qb, 0x00000000, 0xff001b7c, 0x00000000, 0x0, 0x00000000
	dspck_dstio cmpgdu.lt.qb, 0x00000003, 0x20fe3200, 0x00497c8f, 0x0, 0x03000000
	dspck_dstio cmpgdu.lt.qb, 0x00000007, 0xff371000, 0x383cff04, 0x0, 0x07000000
	dspck_dstio cmpgdu.lt.qb, 0x00000005, 0x8380f038, 0x00ff03ff, 0x0, 0x05000000
	dspck_dstio cmpgdu.lt.qb, 0x00000000, 0x13000132, 0x13000132, 0x0, 0x00000000
	dspck_dstio cmpgdu.lt.qb, 0x00000005, 0x0300c30f, 0x00b683fc, 0x0, 0x05000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000f, 0x28007000, 0xdf8effff, 0x0, 0x0f000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000d, 0x00057e08, 0x07db011e, 0x0, 0x0d000000
	dspck_dstio cmpgdu.lt.qb, 0x00000005, 0xff030e02, 0xffc30caa, 0x0, 0x05000000
	dspck_dstio cmpgdu.lt.qb, 0x00000002, 0x7e0000aa, 0x0000ff01, 0x0, 0x02000000
	dspck_dstio cmpgdu.lt.qb, 0x00000008, 0x00ff00ff, 0xcf1b0001, 0x0, 0x08000000
	dspck_dstio cmpgdu.lt.qb, 0x00000001, 0xff8e000b, 0x060c00fc, 0x0, 0x01000000
	dspck_dstio cmpgdu.lt.qb, 0x00000008, 0x590f00ff, 0xff0000e0, 0x0, 0x08000000
	dspck_dstio cmpgdu.lt.qb, 0x00000008, 0x00004000, 0x7a003c00, 0x0, 0x08000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000a, 0x020f01ff, 0x7c0aff01, 0x0, 0x0a000000
	dspck_dstio cmpgdu.lt.qb, 0x00000006, 0x1d000040, 0x001fff00, 0x0, 0x06000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000d, 0x37000110, 0xaae1003e, 0x0, 0x0d000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000d, 0x001d00cc, 0xc7ff00ff, 0x0, 0x0d000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000c, 0x0e1d12ff, 0x3c620100, 0x0, 0x0c000000
	dspck_dstio cmpgdu.lt.qb, 0x00000000, 0x87ff0080, 0x00000000, 0x0, 0x00000000
	dspck_dstio cmpgdu.lt.qb, 0x00000004, 0x3300df87, 0x00df8300, 0x0, 0x04000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000c, 0x200431ff, 0xef240580, 0x0, 0x0c000000
	dspck_dstio cmpgdu.lt.qb, 0x00000006, 0xff0002bf, 0xff027e33, 0x0, 0x06000000
	dspck_dstio cmpgdu.lt.qb, 0x00000000, 0xf9db08ff, 0xcf030519, 0x0, 0x00000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000c, 0x38001849, 0xff360000, 0x0, 0x0c000000
	dspck_dstio cmpgdu.lt.qb, 0x00000007, 0xb6007300, 0x0007f709, 0x0, 0x07000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000a, 0x01ff0000, 0xffaaf300, 0x0, 0x0a000000
	dspck_dstio cmpgdu.lt.qb, 0x00000000, 0xffbfffb6, 0xffbfffb6, 0x0, 0x00000000
	dspck_dstio cmpgdu.lt.qb, 0x00000000, 0x00ff01b6, 0x00ff01b6, 0x0, 0x00000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000c, 0x0001e101, 0x01ff0000, 0x0, 0x0c000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000a, 0x013e3038, 0x02003300, 0x0, 0x0a000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000a, 0x00ff01e1, 0x0100ff00, 0x0, 0x0a000000
	dspck_dstio cmpgdu.lt.qb, 0x00000000, 0xff240080, 0xff00006a, 0x0, 0x00000000
	dspck_dstio cmpgdu.lt.qb, 0x00000000, 0xccffff0a, 0xccffff0a, 0x0, 0x00000000
	dspck_dstio cmpgdu.lt.qb, 0x00000004, 0x3f0078ff, 0x0f171b10, 0x0, 0x04000000
	dspck_dstio cmpgdu.lt.qb, 0x00000004, 0xff010740, 0xffff0004, 0x0, 0x04000000
	dspck_dstio cmpgdu.lt.qb, 0x00000000, 0xff7dffff, 0x00001c19, 0x0, 0x00000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000c, 0x0307ff07, 0xff789f00, 0x0, 0x0c000000
	dspck_dstio cmpgdu.lt.qb, 0x00000008, 0x01e04900, 0x06023800, 0x0, 0x08000000
	dspck_dstio cmpgdu.lt.qb, 0x00000003, 0xc7020066, 0x0c0034ff, 0x0, 0x03000000
	dspck_dstio cmpgdu.lt.qb, 0x00000003, 0xfffc003c, 0x1f0010ff, 0x0, 0x03000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000c, 0x80000107, 0xff240000, 0x0, 0x0c000000
	dspck_dstio cmpgdu.lt.qb, 0x00000000, 0x80f9343f, 0x80f9343f, 0x0, 0x00000000
	dspck_dstio cmpgdu.lt.qb, 0x00000002, 0x006001fe, 0x0000027e, 0x0, 0x02000000
	dspck_dstio cmpgdu.lt.qb, 0x00000008, 0x01ff0499, 0x36ff0200, 0x0, 0x08000000
	dspck_dstio cmpgdu.lt.qb, 0x00000002, 0xe1fd3070, 0x0100ff01, 0x0, 0x02000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000a, 0x0fe3ccff, 0x1faacfaa, 0x0, 0x0a000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000c, 0x6f03e31a, 0xffff0800, 0x0, 0x0c000000
	dspck_dstio cmpgdu.lt.qb, 0x00000006, 0x0703f9ff, 0x00e7ff30, 0x0, 0x06000000
	dspck_dstio cmpgdu.lt.qb, 0x00000001, 0x00ffff0f, 0x0000c0ff, 0x0, 0x01000000
	dspck_dstio cmpgdu.lt.qb, 0x00000001, 0x7cc7fe55, 0x070000ff, 0x0, 0x01000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000b, 0xcfff0302, 0xff013c09, 0x0, 0x0b000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000c, 0x07000039, 0xff020002, 0x0, 0x0c000000
	dspck_dstio cmpgdu.lt.qb, 0x00000008, 0x330adbff, 0xff001501, 0x0, 0x08000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000e, 0x3c2800ff, 0xcc3b151e, 0x0, 0x0e000000
	dspck_dstio cmpgdu.lt.qb, 0x00000009, 0x0380ff00, 0xbf000024, 0x0, 0x09000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000b, 0x9f700001, 0xff075520, 0x0, 0x0b000000
	dspck_dstio cmpgdu.lt.qb, 0x00000000, 0xffff78e0, 0x04000183, 0x0, 0x00000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000a, 0x0100063f, 0xc3001e00, 0x0, 0x0a000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000b, 0x00ff0502, 0xff08e1f8, 0x0, 0x0b000000
	dspck_dstio cmpgdu.lt.qb, 0x00000003, 0x3e380300, 0x24030f03, 0x0, 0x03000000
	dspck_dstio cmpgdu.lt.qb, 0x00000002, 0x7f1f0010, 0x01071800, 0x0, 0x02000000
	dspck_dstio cmpgdu.lt.qb, 0x00000007, 0x30000100, 0x01ffffff, 0x0, 0x07000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000b, 0x00010201, 0x0d00ff83, 0x0, 0x0b000000
	dspck_dstio cmpgdu.lt.qb, 0x00000004, 0xf901c783, 0x92030500, 0x0, 0x04000000
	dspck_dstio cmpgdu.lt.qb, 0x00000000, 0xaa03f080, 0x0d000800, 0x0, 0x00000000
	dspck_dstio cmpgdu.lt.qb, 0x00000002, 0xff0037f3, 0xff00fe7f, 0x0, 0x02000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000a, 0x00010c03, 0x01006500, 0x0, 0x0a000000
	dspck_dstio cmpgdu.lt.qb, 0x00000003, 0xffff3800, 0xff00ff01, 0x0, 0x03000000
	dspck_dstio cmpgdu.lt.qb, 0x00000000, 0x012b0460, 0x00000000, 0x0, 0x00000000
	dspck_dstio cmpgdu.lt.qb, 0x00000007, 0x08000bf9, 0x010b16ff, 0x0, 0x07000000
	dspck_dstio cmpgdu.lt.qb, 0x00000000, 0xff0070ff, 0x00000071, 0x0, 0x00000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000c, 0x077100ff, 0xff8100f9, 0x0, 0x0c000000
	dspck_dstio cmpgdu.lt.qb, 0x00000003, 0x2bff0000, 0x023f0401, 0x0, 0x03000000
	dspck_dstio cmpgdu.lt.qb, 0x00000002, 0xfffe0003, 0x15000100, 0x0, 0x02000000
	dspck_dstio cmpgdu.lt.qb, 0x00000000, 0xff1607ff, 0xff1607ff, 0x0, 0x00000000
	dspck_dstio cmpgdu.lt.qb, 0x00000006, 0x100b0b03, 0x01ff6600, 0x0, 0x06000000
	dspck_dstio cmpgdu.lt.qb, 0x00000005, 0x05007f01, 0x00ff04f0, 0x0, 0x05000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000b, 0x008f0200, 0x190c3ef8, 0x0, 0x0b000000
	dspck_dstio cmpgdu.lt.qb, 0x00000004, 0xff0060ff, 0x00ff0400, 0x0, 0x04000000
	dspck_dstio cmpgdu.lt.qb, 0x00000004, 0xe008ff38, 0x00ffff00, 0x0, 0x04000000
	dspck_dstio cmpgdu.lt.qb, 0x00000003, 0x0f000000, 0x03001578, 0x0, 0x03000000
	dspck_dstio cmpgdu.lt.qb, 0x00000004, 0x5901f9ff, 0x00ff028e, 0x0, 0x04000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000d, 0x00000000, 0xffff00ff, 0x0, 0x0d000000
	dspck_dstio cmpgdu.lt.qb, 0x00000004, 0x0001339f, 0x00f11e07, 0x0, 0x04000000
	dspck_dstio cmpgdu.lt.qb, 0x00000000, 0xff0038f0, 0x08000004, 0x0, 0x00000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000f, 0x031006c0, 0xe0ff6dff, 0x0, 0x0f000000
	dspck_dstio cmpgdu.lt.qb, 0x00000006, 0x8e00001c, 0x03010d02, 0x0, 0x06000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000f, 0xcfb63103, 0xf9ffff92, 0x0, 0x0f000000
	dspck_dstio cmpgdu.lt.qb, 0x00000001, 0xff99ef01, 0xc37b0713, 0x0, 0x01000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000f, 0x00700e08, 0xffff3887, 0x0, 0x0f000000
	dspck_dstio cmpgdu.lt.qb, 0x00000002, 0xf80c0002, 0x0f009902, 0x0, 0x02000000
	dspck_dstio cmpgdu.lt.qb, 0x00000006, 0xff3c050e, 0x38ffff03, 0x0, 0x06000000
	dspck_dstio cmpgdu.lt.qb, 0x00000005, 0xff00b600, 0xff7c3299, 0x0, 0x05000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000b, 0x0000002e, 0x080013ff, 0x0, 0x0b000000
	dspck_dstio cmpgdu.lt.qb, 0x00000004, 0xff24dfff, 0xffff36ff, 0x0, 0x04000000
	dspck_dstio cmpgdu.lt.qb, 0x00000006, 0x1b000c00, 0x1a83f900, 0x0, 0x06000000
	dspck_dstio cmpgdu.lt.qb, 0x00000008, 0x02ffff1b, 0xffff010e, 0x0, 0x08000000
	dspck_dstio cmpgdu.lt.qb, 0x00000000, 0x03fe0206, 0x00000000, 0x0, 0x00000000
	dspck_dstio cmpgdu.lt.qb, 0x00000000, 0x0000711d, 0x0000711d, 0x0, 0x00000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000f, 0x01000f00, 0xffff4081, 0x0, 0x0f000000
	dspck_dstio cmpgdu.lt.qb, 0x00000004, 0xff80fdff, 0x9fff0887, 0x0, 0x04000000
	dspck_dstio cmpgdu.lt.qb, 0x00000008, 0x008efff8, 0xf981033f, 0x0, 0x08000000
	dspck_dstio cmpgdu.lt.qb, 0x00000004, 0xff722fff, 0x0178008f, 0x0, 0x04000000
	dspck_dstio cmpgdu.lt.qb, 0x00000008, 0x00000000, 0x07000000, 0x0, 0x08000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000f, 0x00100626, 0x01e11830, 0x0, 0x0f000000
	dspck_dstio cmpgdu.lt.qb, 0x00000002, 0x00e00708, 0x00007e00, 0x0, 0x02000000
	dspck_dstio cmpgdu.lt.qb, 0x00000003, 0x00000000, 0x00003813, 0x0, 0x03000000
	dspck_dstio cmpgdu.lt.qb, 0x00000000, 0x0333dbf9, 0x0333dbf9, 0x0, 0x00000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000f, 0x00000000, 0x24830e06, 0x0, 0x0f000000
	dspck_dstio cmpgdu.lt.qb, 0x00000006, 0x170106cf, 0x047fff1e, 0x0, 0x06000000
	dspck_dstio cmpgdu.lt.qb, 0x00000003, 0xff0a0002, 0x3b00ff2c, 0x0, 0x03000000
	dspck_dstio cmpgdu.lt.qb, 0x00000005, 0x3c83fff9, 0x02fcc1ff, 0x0, 0x05000000
	dspck_dstio cmpgdu.lt.qb, 0x00000000, 0x71dbff30, 0x00000000, 0x0, 0x00000000
	dspck_dstio cmpgdu.lt.qb, 0x00000001, 0xff13ff0d, 0x400400b6, 0x0, 0x01000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000b, 0x01ff0200, 0xff00e72d, 0x0, 0x0b000000
	dspck_dstio cmpgdu.lt.qb, 0x00000002, 0x01ff0155, 0x01000240, 0x0, 0x02000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000b, 0x00cf0100, 0x24000408, 0x0, 0x0b000000
	dspck_dstio cmpgdu.lt.qb, 0x00000001, 0x00001800, 0x00000004, 0x0, 0x01000000
	dspck_dstio cmpgdu.lt.qb, 0x00000009, 0x011effe3, 0x11001eff, 0x0, 0x09000000
	dspck_dstio cmpgdu.lt.qb, 0x00000009, 0x00ff0a00, 0xff00007c, 0x0, 0x09000000
	dspck_dstio cmpgdu.lt.qb, 0x00000001, 0x338fff66, 0x0004f983, 0x0, 0x01000000
	dspck_dstio cmpgdu.lt.qb, 0x00000006, 0xff870010, 0x00f03800, 0x0, 0x06000000
	dspck_dstio cmpgdu.lt.qb, 0x00000000, 0x70019200, 0x00006000, 0x0, 0x00000000
	dspck_dstio cmpgdu.lt.qb, 0x00000001, 0xcf01ff36, 0x0001ffff, 0x0, 0x01000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000b, 0x003e8700, 0x1800ffff, 0x0, 0x0b000000
	dspck_dstio cmpgdu.lt.qb, 0x00000004, 0x220102ff, 0x012c0040, 0x0, 0x04000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000a, 0x034402e7, 0x7100c303, 0x0, 0x0a000000
	dspck_dstio cmpgdu.lt.qb, 0x00000003, 0x000f3017, 0x00015555, 0x0, 0x03000000
	dspck_dstio cmpgdu.lt.qb, 0x00000005, 0x0700ff07, 0x03ffe1ff, 0x0, 0x05000000
	dspck_dstio cmpgdu.lt.qb, 0x00000009, 0xe1002678, 0xff0008ff, 0x0, 0x09000000
	dspck_dstio cmpgdu.lt.qb, 0x00000008, 0x0106ffe3, 0x0d0007c3, 0x0, 0x08000000
	dspck_dstio cmpgdu.lt.qb, 0x00000003, 0xffdb07aa, 0x0e03c7c0, 0x0, 0x03000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000c, 0x2f01081e, 0xe0020100, 0x0, 0x0c000000
	dspck_dstio cmpgdu.lt.qb, 0x00000006, 0xff33006d, 0x8f38ff20, 0x0, 0x06000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000a, 0x00090010, 0x1a008004, 0x0, 0x0a000000
	dspck_dstio cmpgdu.lt.qb, 0x00000000, 0x003a7f18, 0x00000000, 0x0, 0x00000000
	dspck_dstio cmpgdu.lt.qb, 0x0000000c, 0x031affff, 0xffff03ff, 0x0, 0x0c000000
	dspck_dstio cmpgdu.lt.qb, 0x00000005, 0x7805001f, 0x065600f3, 0x0, 0x05000000
	dspck_dstio cmpgdu.lt.qb, 0x00000009, 0x0049ff99, 0xf80e00f8, 0x0, 0x09000000

	writemsg "[10] Test cmpgdu.le.qb"
	dspck_dstio cmpgdu.le.qb, 0x00000003, 0xe0870000, 0x3718fd30, 0x0, 0x03000000
	dspck_dstio cmpgdu.le.qb, 0x00000006, 0xff001e7e, 0xef7cc338, 0x0, 0x06000000
	dspck_dstio cmpgdu.le.qb, 0x0000000b, 0x000200aa, 0xc100ffff, 0x0, 0x0b000000
	dspck_dstio cmpgdu.le.qb, 0x0000000c, 0x0218ff01, 0xdfc13c00, 0x0, 0x0c000000
	dspck_dstio cmpgdu.le.qb, 0x0000000d, 0x0008f8ff, 0x003f00ff, 0x0, 0x0d000000
	dspck_dstio cmpgdu.le.qb, 0x0000000b, 0x007e0828, 0x002c7f3c, 0x0, 0x0b000000
	dspck_dstio cmpgdu.le.qb, 0x0000000d, 0x29071000, 0x6d3c0102, 0x0, 0x0d000000
	dspck_dstio cmpgdu.le.qb, 0x00000000, 0x8f1fffc0, 0x0000c301, 0x0, 0x00000000
	dspck_dstio cmpgdu.le.qb, 0x00000007, 0xff780000, 0x00fff01e, 0x0, 0x07000000
	dspck_dstio cmpgdu.le.qb, 0x0000000e, 0x0c1c00ff, 0xff339200, 0x0, 0x0e000000
	dspck_dstio cmpgdu.le.qb, 0x0000000c, 0x00005640, 0xff3e0d0b, 0x0, 0x0c000000
	dspck_dstio cmpgdu.le.qb, 0x0000000f, 0x00ffff02, 0x00ffff02, 0x0, 0x0f000000
	dspck_dstio cmpgdu.le.qb, 0x0000000d, 0x0000cc38, 0xff0000ff, 0x0, 0x0d000000
	dspck_dstio cmpgdu.le.qb, 0x0000000c, 0x7800b6ff, 0xffff9902, 0x0, 0x0c000000
	dspck_dstio cmpgdu.le.qb, 0x0000000e, 0x200b01e0, 0xffff0700, 0x0, 0x0e000000
	dspck_dstio cmpgdu.le.qb, 0x00000000, 0x2003ff31, 0x18008f1e, 0x0, 0x00000000
	dspck_dstio cmpgdu.le.qb, 0x0000000b, 0x0520c001, 0x3e01df06, 0x0, 0x0b000000
	dspck_dstio cmpgdu.le.qb, 0x0000000f, 0x00000000, 0x19004600, 0x0, 0x0f000000
	dspck_dstio cmpgdu.le.qb, 0x00000004, 0xffff0cff, 0x8fff0501, 0x0, 0x04000000
	dspck_dstio cmpgdu.le.qb, 0x00000001, 0xfffffd3e, 0x0023cc53, 0x0, 0x01000000
	dspck_dstio cmpgdu.le.qb, 0x00000009, 0x4c7e6300, 0x601b0000, 0x0, 0x09000000
	dspck_dstio cmpgdu.le.qb, 0x00000002, 0xfffe007f, 0x00000000, 0x0, 0x02000000
	dspck_dstio cmpgdu.le.qb, 0x00000000, 0xff2017ef, 0x92000703, 0x0, 0x00000000
	dspck_dstio cmpgdu.le.qb, 0x00000000, 0x2cc05a55, 0x17000306, 0x0, 0x00000000
	dspck_dstio cmpgdu.le.qb, 0x00000002, 0xff011ae7, 0x0000ff01, 0x0, 0x02000000
	dspck_dstio cmpgdu.le.qb, 0x00000009, 0x8302780e, 0xff010e7f, 0x0, 0x09000000
	dspck_dstio cmpgdu.le.qb, 0x00000007, 0x08060007, 0x021755ff, 0x0, 0x07000000
	dspck_dstio cmpgdu.le.qb, 0x00000006, 0x92040001, 0x00f1ff00, 0x0, 0x06000000
	dspck_dstio cmpgdu.le.qb, 0x00000003, 0x7f800000, 0x07007ecf, 0x0, 0x03000000
	dspck_dstio cmpgdu.le.qb, 0x0000000e, 0x380000ef, 0xffff10df, 0x0, 0x0e000000
	dspck_dstio cmpgdu.le.qb, 0x0000000a, 0x183e001f, 0x32060200, 0x0, 0x0a000000
	dspck_dstio cmpgdu.le.qb, 0x00000000, 0x01cf0883, 0x0030006d, 0x0, 0x00000000
	dspck_dstio cmpgdu.le.qb, 0x00000001, 0x3f3a1200, 0x0c000024, 0x0, 0x01000000
	dspck_dstio cmpgdu.le.qb, 0x0000000d, 0x1400e000, 0xfe0c00aa, 0x0, 0x0d000000
	dspck_dstio cmpgdu.le.qb, 0x00000006, 0xff0002ff, 0x00fc3ee1, 0x0, 0x06000000
	dspck_dstio cmpgdu.le.qb, 0x0000000f, 0x00000000, 0x8708c300, 0x0, 0x0f000000
	dspck_dstio cmpgdu.le.qb, 0x00000007, 0x64ff0308, 0x1eff34ff, 0x0, 0x07000000
	dspck_dstio cmpgdu.le.qb, 0x0000000a, 0x00ff0002, 0xfff9df00, 0x0, 0x0a000000
	dspck_dstio cmpgdu.le.qb, 0x00000007, 0x7c07300c, 0x0bffff55, 0x0, 0x07000000
	dspck_dstio cmpgdu.le.qb, 0x00000003, 0x780e0f00, 0x0305ff00, 0x0, 0x03000000
	dspck_dstio cmpgdu.le.qb, 0x0000000f, 0x00000000, 0x0300c0ff, 0x0, 0x0f000000
	dspck_dstio cmpgdu.le.qb, 0x0000000f, 0x100f003c, 0x100f003c, 0x0, 0x0f000000
	dspck_dstio cmpgdu.le.qb, 0x00000004, 0x3c00ff38, 0x10020806, 0x0, 0x04000000
	dspck_dstio cmpgdu.le.qb, 0x00000000, 0x01ff9f1b, 0x00330401, 0x0, 0x00000000
	dspck_dstio cmpgdu.le.qb, 0x00000001, 0x0b1c1c00, 0x030200ff, 0x0, 0x01000000
	dspck_dstio cmpgdu.le.qb, 0x00000009, 0x000d0c80, 0x170102ff, 0x0, 0x09000000
	dspck_dstio cmpgdu.le.qb, 0x00000003, 0xffff000e, 0x0505f86d, 0x0, 0x03000000
	dspck_dstio cmpgdu.le.qb, 0x0000000f, 0x00000000, 0x067f49aa, 0x0, 0x0f000000
	dspck_dstio cmpgdu.le.qb, 0x0000000e, 0x000100fc, 0x1f26024f, 0x0, 0x0e000000
	dspck_dstio cmpgdu.le.qb, 0x0000000d, 0xcf00ff00, 0xfffd00ff, 0x0, 0x0d000000
	dspck_dstio cmpgdu.le.qb, 0x0000000f, 0x55033600, 0xff07f900, 0x0, 0x0f000000
	dspck_dstio cmpgdu.le.qb, 0x00000008, 0x007899ff, 0xfd003500, 0x0, 0x08000000
	dspck_dstio cmpgdu.le.qb, 0x0000000e, 0x039900ff, 0x10f70400, 0x0, 0x0e000000
	dspck_dstio cmpgdu.le.qb, 0x00000007, 0x7c200007, 0x00830036, 0x0, 0x07000000
	dspck_dstio cmpgdu.le.qb, 0x0000000e, 0x001eff05, 0x3affff00, 0x0, 0x0e000000
	dspck_dstio cmpgdu.le.qb, 0x00000002, 0xff3e0309, 0x0000f301, 0x0, 0x02000000
	dspck_dstio cmpgdu.le.qb, 0x00000007, 0xf7000042, 0xdfff0692, 0x0, 0x07000000
	dspck_dstio cmpgdu.le.qb, 0x00000001, 0x1c78ffff, 0x000029ff, 0x0, 0x01000000
	dspck_dstio cmpgdu.le.qb, 0x00000005, 0x0100ffb6, 0x00000eff, 0x0, 0x05000000
	dspck_dstio cmpgdu.le.qb, 0x0000000a, 0x000e0c83, 0x0706c004, 0x0, 0x0a000000
	dspck_dstio cmpgdu.le.qb, 0x0000000f, 0x037e0100, 0x78f30e00, 0x0, 0x0f000000
	dspck_dstio cmpgdu.le.qb, 0x0000000d, 0x01007101, 0x03380715, 0x0, 0x0d000000
	dspck_dstio cmpgdu.le.qb, 0x00000001, 0xc1ffff03, 0x0018008f, 0x0, 0x01000000
	dspck_dstio cmpgdu.le.qb, 0x0000000b, 0xf8ff0600, 0xffbf81ff, 0x0, 0x0b000000
	dspck_dstio cmpgdu.le.qb, 0x00000001, 0xfce0600e, 0xbf7e408e, 0x0, 0x01000000
	dspck_dstio cmpgdu.le.qb, 0x00000003, 0xc0db5f3f, 0x0003ff3f, 0x0, 0x03000000
	dspck_dstio cmpgdu.le.qb, 0x00000001, 0x81ffe718, 0x33c7006b, 0x0, 0x01000000
	dspck_dstio cmpgdu.le.qb, 0x00000003, 0x35ff0006, 0x03010e10, 0x0, 0x03000000
	dspck_dstio cmpgdu.le.qb, 0x0000000e, 0x1c07e0ff, 0x83ffe31f, 0x0, 0x0e000000
	dspck_dstio cmpgdu.le.qb, 0x00000008, 0x14518308, 0xff0c3f02, 0x0, 0x08000000
	dspck_dstio cmpgdu.le.qb, 0x00000003, 0xff2e0000, 0x8e0224ff, 0x0, 0x03000000
	dspck_dstio cmpgdu.le.qb, 0x00000006, 0xff2c00f9, 0x6aff0e7e, 0x0, 0x06000000
	dspck_dstio cmpgdu.le.qb, 0x00000006, 0x04000370, 0x01ff800e, 0x0, 0x06000000
	dspck_dstio cmpgdu.le.qb, 0x00000003, 0xefe10700, 0x3e024b99, 0x0, 0x03000000
	dspck_dstio cmpgdu.le.qb, 0x00000006, 0x3c02e018, 0x0070f300, 0x0, 0x06000000
	dspck_dstio cmpgdu.le.qb, 0x00000004, 0xff00c03a, 0x00050f01, 0x0, 0x04000000
	dspck_dstio cmpgdu.le.qb, 0x0000000c, 0xff00fff8, 0xff000309, 0x0, 0x0c000000
	dspck_dstio cmpgdu.le.qb, 0x00000008, 0x0036ff01, 0x66055f00, 0x0, 0x08000000
	dspck_dstio cmpgdu.le.qb, 0x00000000, 0xffff010e, 0x00000000, 0x0, 0x00000000
	dspck_dstio cmpgdu.le.qb, 0x0000000f, 0x00ff0700, 0x02ffffff, 0x0, 0x0f000000
	dspck_dstio cmpgdu.le.qb, 0x0000000f, 0xe0ff1400, 0xe0ff1400, 0x0, 0x0f000000
	dspck_dstio cmpgdu.le.qb, 0x00000005, 0x9f48870f, 0x00ff08ff, 0x0, 0x05000000
	dspck_dstio cmpgdu.le.qb, 0x0000000b, 0x008e0137, 0x01014978, 0x0, 0x0b000000
	dspck_dstio cmpgdu.le.qb, 0x00000007, 0xff000003, 0x7f0f803f, 0x0, 0x07000000
	dspck_dstio cmpgdu.le.qb, 0x00000002, 0xc30200ff, 0x00000000, 0x0, 0x02000000
	dspck_dstio cmpgdu.le.qb, 0x0000000b, 0x03ff3001, 0xff008e9f, 0x0, 0x0b000000
	dspck_dstio cmpgdu.le.qb, 0x00000007, 0x83000d00, 0x550c2900, 0x0, 0x07000000
	dspck_dstio cmpgdu.le.qb, 0x0000000a, 0xffff0473, 0xff06c324, 0x0, 0x0a000000
	dspck_dstio cmpgdu.le.qb, 0x00000000, 0xb6f13eff, 0x01030805, 0x0, 0x00000000
	dspck_dstio cmpgdu.le.qb, 0x0000000e, 0x380000f7, 0xe7ff0351, 0x0, 0x0e000000
	dspck_dstio cmpgdu.le.qb, 0x00000007, 0x380030b6, 0x050087ff, 0x0, 0x07000000
	dspck_dstio cmpgdu.le.qb, 0x00000008, 0x02ccffff, 0xff130000, 0x0, 0x08000000
	dspck_dstio cmpgdu.le.qb, 0x00000007, 0x0700023f, 0x00008762, 0x0, 0x07000000
	dspck_dstio cmpgdu.le.qb, 0x0000000c, 0x00017e3f, 0x00ff0600, 0x0, 0x0c000000
	dspck_dstio cmpgdu.le.qb, 0x00000003, 0xfccf01ff, 0x717187ff, 0x0, 0x03000000
	dspck_dstio cmpgdu.le.qb, 0x00000009, 0x65ff0f00, 0xff080004, 0x0, 0x09000000
	dspck_dstio cmpgdu.le.qb, 0x00000000, 0xf3808f17, 0x00000000, 0x0, 0x00000000
	dspck_dstio cmpgdu.le.qb, 0x00000001, 0xb667ff07, 0x001ce7db, 0x0, 0x01000000
	dspck_dstio cmpgdu.le.qb, 0x0000000f, 0x010f6dff, 0x010f6dff, 0x0, 0x0f000000
	dspck_dstio cmpgdu.le.qb, 0x0000000f, 0xff000000, 0xff000000, 0x0, 0x0f000000
	dspck_dstio cmpgdu.le.qb, 0x00000005, 0x2302ff00, 0x011100e0, 0x0, 0x05000000
	dspck_dstio cmpgdu.le.qb, 0x00000005, 0x06000100, 0x0000008e, 0x0, 0x05000000
	dspck_dstio cmpgdu.le.qb, 0x0000000a, 0x01ff03ff, 0x05119238, 0x0, 0x0a000000
	dspck_dstio cmpgdu.le.qb, 0x0000000b, 0x00ff0000, 0x178700ff, 0x0, 0x0b000000
	dspck_dstio cmpgdu.le.qb, 0x00000009, 0x00df8110, 0x000d0078, 0x0, 0x09000000
	dspck_dstio cmpgdu.le.qb, 0x0000000f, 0x60c3c305, 0x60c3c305, 0x0, 0x0f000000
	dspck_dstio cmpgdu.le.qb, 0x0000000a, 0x0022f940, 0x8703ff00, 0x0, 0x0a000000
	dspck_dstio cmpgdu.le.qb, 0x0000000d, 0x0230f324, 0x1881f17c, 0x0, 0x0d000000
	dspck_dstio cmpgdu.le.qb, 0x00000005, 0x20002c00, 0x008300ff, 0x0, 0x05000000
	dspck_dstio cmpgdu.le.qb, 0x00000006, 0xcc4900ff, 0x086d1e00, 0x0, 0x06000000
	dspck_dstio cmpgdu.le.qb, 0x00000002, 0x83ff001f, 0x3800021e, 0x0, 0x02000000
	dspck_dstio cmpgdu.le.qb, 0x0000000f, 0xffff0000, 0xffff1100, 0x0, 0x0f000000
	dspck_dstio cmpgdu.le.qb, 0x0000000f, 0x01200216, 0x01200216, 0x0, 0x0f000000
	dspck_dstio cmpgdu.le.qb, 0x00000001, 0x1e241e92, 0x000005ff, 0x0, 0x01000000
	dspck_dstio cmpgdu.le.qb, 0x0000000f, 0x0000e306, 0x3333fff3, 0x0, 0x0f000000
	dspck_dstio cmpgdu.le.qb, 0x00000008, 0xfe0307ff, 0xff000003, 0x0, 0x08000000
	dspck_dstio cmpgdu.le.qb, 0x0000000f, 0x00000000, 0x00ff04ff, 0x0, 0x0f000000
	dspck_dstio cmpgdu.le.qb, 0x0000000f, 0x07030e00, 0xc724ff00, 0x0, 0x0f000000
	dspck_dstio cmpgdu.le.qb, 0x0000000d, 0x0001170f, 0x7e2a0099, 0x0, 0x0d000000
	dspck_dstio cmpgdu.le.qb, 0x0000000d, 0x0000ff33, 0x023f81aa, 0x0, 0x0d000000
	dspck_dstio cmpgdu.le.qb, 0x00000005, 0x0800ff00, 0x04cc8eff, 0x0, 0x05000000
	dspck_dstio cmpgdu.le.qb, 0x00000005, 0xf1067800, 0x00f13d07, 0x0, 0x05000000
	dspck_dstio cmpgdu.le.qb, 0x0000000d, 0x0300ff00, 0xffaa6d40, 0x0, 0x0d000000
	dspck_dstio cmpgdu.le.qb, 0x00000006, 0xf9000628, 0x051c0803, 0x0, 0x06000000
	dspck_dstio cmpgdu.le.qb, 0x0000000f, 0x00000000, 0x046c9f00, 0x0, 0x0f000000
	dspck_dstio cmpgdu.le.qb, 0x0000000e, 0x8f1c17ef, 0xb6ffff19, 0x0, 0x0e000000
	dspck_dstio cmpgdu.le.qb, 0x00000002, 0x0660df18, 0x0002ff00, 0x0, 0x02000000
	dspck_dstio cmpgdu.le.qb, 0x0000000f, 0x00000202, 0xf0ff1602, 0x0, 0x0f000000
	dspck_dstio cmpgdu.le.qb, 0x0000000f, 0xff043e00, 0xff043e00, 0x0, 0x0f000000
	dspck_dstio cmpgdu.le.qb, 0x00000001, 0x04010110, 0x000000ff, 0x0, 0x01000000
	dspck_dstio cmpgdu.le.qb, 0x00000009, 0x28aab600, 0xff02001b, 0x0, 0x09000000
	dspck_dstio cmpgdu.le.qb, 0x0000000b, 0x38380501, 0xff0171ff, 0x0, 0x0b000000
	dspck_dstio cmpgdu.le.qb, 0x00000002, 0xff200ce1, 0x0010ff71, 0x0, 0x02000000
	dspck_dstio cmpgdu.le.qb, 0x00000003, 0xff1b012d, 0x1e04ffe0, 0x0, 0x03000000
	dspck_dstio cmpgdu.le.qb, 0x00000009, 0x1010240c, 0xff001f18, 0x0, 0x09000000
	dspck_dstio cmpgdu.le.qb, 0x00000001, 0x4cffff15, 0x060049ff, 0x0, 0x01000000
	dspck_dstio cmpgdu.le.qb, 0x00000003, 0xffff2639, 0x0000fef1, 0x0, 0x03000000
	dspck_dstio cmpgdu.le.qb, 0x0000000f, 0x05000087, 0x0a1e00c3, 0x0, 0x0f000000
	dspck_dstio cmpgdu.le.qb, 0x00000009, 0x00f1201e, 0x08f000ff, 0x0, 0x09000000
	dspck_dstio cmpgdu.le.qb, 0x00000004, 0xe000ff0b, 0x0087db00, 0x0, 0x04000000
	dspck_dstio cmpgdu.le.qb, 0x0000000f, 0xf9000002, 0xf9000002, 0x0, 0x0f000000
	dspck_dstio cmpgdu.le.qb, 0x00000001, 0xf8ffff00, 0x923f2df7, 0x0, 0x01000000
	dspck_dstio cmpgdu.le.qb, 0x0000000b, 0x01ff1700, 0x0140ff00, 0x0, 0x0b000000
	dspck_dstio cmpgdu.le.qb, 0x0000000f, 0x00000000, 0x92007edf, 0x0, 0x0f000000
	dspck_dstio cmpgdu.le.qb, 0x00000003, 0xffff0000, 0x008eef00, 0x0, 0x03000000
	dspck_dstio cmpgdu.le.qb, 0x00000009, 0x012c1f00, 0x34180000, 0x0, 0x09000000
	dspck_dstio cmpgdu.le.qb, 0x00000001, 0xf312ff06, 0x2300cfff, 0x0, 0x01000000
	dspck_dstio cmpgdu.le.qb, 0x00000002, 0xff6e007f, 0x00000000, 0x0, 0x02000000
	dspck_dstio cmpgdu.le.qb, 0x0000000f, 0x07000000, 0xff00021b, 0x0, 0x0f000000
	dspck_dstio cmpgdu.le.qb, 0x0000000f, 0x03032401, 0x03032401, 0x0, 0x0f000000
	dspck_dstio cmpgdu.le.qb, 0x0000000f, 0x00240006, 0x30ff1cff, 0x0, 0x0f000000
	dspck_dstio cmpgdu.le.qb, 0x0000000e, 0x7f0034ff, 0xff05ff03, 0x0, 0x0e000000
	dspck_dstio cmpgdu.le.qb, 0x00000008, 0x920d6e78, 0xfd000b60, 0x0, 0x08000000
	dspck_dstio cmpgdu.le.qb, 0x0000000f, 0x009f0102, 0x3efe08ff, 0x0, 0x0f000000
	dspck_dstio cmpgdu.le.qb, 0x0000000c, 0x0000b6ff, 0x00fc3403, 0x0, 0x0c000000
	dspck_dstio cmpgdu.le.qb, 0x0000000f, 0x7b180000, 0x87efc303, 0x0, 0x0f000000
	dspck_dstio cmpgdu.le.qb, 0x00000004, 0xff00031c, 0x01180000, 0x0, 0x04000000
	dspck_dstio cmpgdu.le.qb, 0x0000000a, 0x008f001c, 0x660b6c00, 0x0, 0x0a000000
	dspck_dstio cmpgdu.le.qb, 0x00000002, 0x1f9900ff, 0x00010507, 0x0, 0x02000000
	dspck_dstio cmpgdu.le.qb, 0x0000000e, 0x000300ff, 0x000e0300, 0x0, 0x0e000000
	dspck_dstio cmpgdu.le.qb, 0x00000008, 0x02479266, 0x18000007, 0x0, 0x08000000
	dspck_dstio cmpgdu.le.qb, 0x00000000, 0x1537c3e1, 0x000c0100, 0x0, 0x00000000
	dspck_dstio cmpgdu.le.qb, 0x00000007, 0x7e060200, 0x171b0b00, 0x0, 0x07000000
	dspck_dstio cmpgdu.le.qb, 0x00000007, 0xff00026d, 0xeff935ff, 0x0, 0x07000000
	dspck_dstio cmpgdu.le.qb, 0x0000000f, 0x0000013e, 0x180316ff, 0x0, 0x0f000000
	dspck_dstio cmpgdu.le.qb, 0x0000000c, 0x0600660e, 0xff000001, 0x0, 0x0c000000
	dspck_dstio cmpgdu.le.qb, 0x0000000b, 0x009200f3, 0x000300ff, 0x0, 0x0b000000
	dspck_dstio cmpgdu.le.qb, 0x00000007, 0xff000018, 0x2a0104c1, 0x0, 0x07000000
	dspck_dstio cmpgdu.le.qb, 0x0000000e, 0x000000ef, 0xdf00001f, 0x0, 0x0e000000
	dspck_dstio cmpgdu.le.qb, 0x0000000f, 0x03020000, 0x4320fd00, 0x0, 0x0f000000
	dspck_dstio cmpgdu.le.qb, 0x00000008, 0x03bf3c02, 0x05aa0000, 0x0, 0x08000000
	dspck_dstio cmpgdu.le.qb, 0x00000008, 0x03f8fff0, 0xff99c06d, 0x0, 0x08000000
	dspck_dstio cmpgdu.le.qb, 0x00000000, 0xfcff0cff, 0x000300fc, 0x0, 0x00000000
	dspck_dstio cmpgdu.le.qb, 0x00000004, 0x0d00f3ff, 0x02db1e08, 0x0, 0x04000000
	dspck_dstio cmpgdu.le.qb, 0x00000000, 0x7803ffe7, 0x00000038, 0x0, 0x00000000
	dspck_dstio cmpgdu.le.qb, 0x00000004, 0xff00ff0c, 0x00ff0a00, 0x0, 0x04000000
	dspck_dstio cmpgdu.le.qb, 0x00000007, 0x1f710000, 0x0fff0000, 0x0, 0x07000000
	dspck_dstio cmpgdu.le.qb, 0x0000000b, 0x02110049, 0x0e000083, 0x0, 0x0b000000
	dspck_dstio cmpgdu.le.qb, 0x0000000c, 0xfe7d0214, 0xffff0000, 0x0, 0x0c000000
	dspck_dstio cmpgdu.le.qb, 0x0000000f, 0x01240000, 0x0fff0105, 0x0, 0x0f000000
	dspck_dstio cmpgdu.le.qb, 0x00000009, 0x080c1c03, 0xe009017e, 0x0, 0x09000000
	dspck_dstio cmpgdu.le.qb, 0x00000000, 0xfcff03ff, 0x02000001, 0x0, 0x00000000
	dspck_dstio cmpgdu.le.qb, 0x0000000a, 0x19ff01ff, 0xe700213c, 0x0, 0x0a000000
	dspck_dstio cmpgdu.le.qb, 0x00000007, 0xe7000000, 0x00cc0c00, 0x0, 0x07000000
	dspck_dstio cmpgdu.le.qb, 0x0000000f, 0x78ffefc0, 0x78ffefc0, 0x0, 0x0f000000
	dspck_dstio cmpgdu.le.qb, 0x0000000b, 0x043e3300, 0x1e07f97f, 0x0, 0x0b000000
	dspck_dstio cmpgdu.le.qb, 0x0000000f, 0x00010101, 0x03ff0281, 0x0, 0x0f000000
	dspck_dstio cmpgdu.le.qb, 0x00000007, 0xf8000237, 0x003f5bff, 0x0, 0x07000000
	dspck_dstio cmpgdu.le.qb, 0x00000003, 0x017c0100, 0x000003ff, 0x0, 0x03000000
	dspck_dstio cmpgdu.le.qb, 0x0000000f, 0x00000000, 0xff713e00, 0x0, 0x0f000000
	dspck_dstio cmpgdu.le.qb, 0x00000006, 0x3c0006ff, 0x00007e00, 0x0, 0x06000000
	dspck_dstio cmpgdu.le.qb, 0x00000007, 0x33000000, 0x008f02ff, 0x0, 0x07000000
	dspck_dstio cmpgdu.le.qb, 0x00000002, 0x04e700ff, 0x02cff100, 0x0, 0x02000000
	dspck_dstio cmpgdu.le.qb, 0x0000000f, 0x00070000, 0x013601aa, 0x0, 0x0f000000
	dspck_dstio cmpgdu.le.qb, 0x0000000e, 0x00c03bff, 0x03ffff00, 0x0, 0x0e000000
	dspck_dstio cmpgdu.le.qb, 0x0000000c, 0x2300ff07, 0xcf780100, 0x0, 0x0c000000
	dspck_dstio cmpgdu.le.qb, 0x00000006, 0xc17104ff, 0x34fde034, 0x0, 0x06000000
	dspck_dstio cmpgdu.le.qb, 0x0000000f, 0x7f070000, 0x7f0f0100, 0x0, 0x0f000000
	dspck_dstio cmpgdu.le.qb, 0x00000006, 0x0e000003, 0x00ff0601, 0x0, 0x06000000
	dspck_dstio cmpgdu.le.qb, 0x00000001, 0xffffffff, 0x710000ff, 0x0, 0x01000000
	dspck_dstio cmpgdu.le.qb, 0x00000008, 0x00ffffff, 0x8000004f, 0x0, 0x08000000
	dspck_dstio cmpgdu.le.qb, 0x00000002, 0xf71c9918, 0x0014aa00, 0x0, 0x02000000
	dspck_dstio cmpgdu.le.qb, 0x0000000e, 0x0000007e, 0x00ff004b, 0x0, 0x0e000000
	dspck_dstio cmpgdu.le.qb, 0x00000003, 0x0a360303, 0x0000e7ff, 0x0, 0x03000000
	dspck_dstio cmpgdu.le.qb, 0x00000004, 0x7effe13c, 0x03ff0700, 0x0, 0x04000000
	dspck_dstio cmpgdu.le.qb, 0x00000008, 0x7efcff1c, 0x9201040d, 0x0, 0x08000000
	dspck_dstio cmpgdu.le.qb, 0x00000009, 0xffff1800, 0xff0c0117, 0x0, 0x09000000
	dspck_dstio cmpgdu.le.qb, 0x0000000f, 0x83446d02, 0x83446d02, 0x0, 0x0f000000
	dspck_dstio cmpgdu.le.qb, 0x0000000f, 0x137e0101, 0x99ff7e9f, 0x0, 0x0f000000
	dspck_dstio cmpgdu.le.qb, 0x00000006, 0xff000d02, 0xcf020f00, 0x0, 0x06000000
	dspck_dstio cmpgdu.le.qb, 0x0000000e, 0x01600107, 0xffff4f04, 0x0, 0x0e000000
	dspck_dstio cmpgdu.le.qb, 0x0000000e, 0x318e00ff, 0xffffff2e, 0x0, 0x0e000000
	dspck_dstio cmpgdu.le.qb, 0x0000000f, 0xff000000, 0xff0666cf, 0x0, 0x0f000000
	dspck_dstio cmpgdu.le.qb, 0x00000008, 0x9f242470, 0xff00000f, 0x0, 0x08000000
	dspck_dstio cmpgdu.le.qb, 0x0000000e, 0x00000c0b, 0xff0ef102, 0x0, 0x0e000000
	dspck_dstio cmpgdu.le.qb, 0x0000000f, 0x00000000, 0x3f872c0d, 0x0, 0x0f000000
	dspck_dstio cmpgdu.le.qb, 0x00000007, 0x0f1913ff, 0x001e7cff, 0x0, 0x07000000
	dspck_dstio cmpgdu.le.qb, 0x00000001, 0xff8f7e66, 0x2c0626ff, 0x0, 0x01000000
	dspck_dstio cmpgdu.le.qb, 0x00000000, 0x07ffaa07, 0x03040001, 0x0, 0x00000000
	dspck_dstio cmpgdu.le.qb, 0x0000000d, 0x0f008300, 0xdf290ef7, 0x0, 0x0d000000
	dspck_dstio cmpgdu.le.qb, 0x00000006, 0x0aff1701, 0x00fffc00, 0x0, 0x06000000
	dspck_dstio cmpgdu.le.qb, 0x00000006, 0xff007cff, 0x03ffff80, 0x0, 0x06000000
	dspck_dstio cmpgdu.le.qb, 0x0000000e, 0xf90003ff, 0xff7ffe13, 0x0, 0x0e000000
	dspck_dstio cmpgdu.le.qb, 0x0000000b, 0x02fd0100, 0xdb03aa01, 0x0, 0x0b000000
	dspck_dstio cmpgdu.le.qb, 0x0000000f, 0xff000003, 0xff7effff, 0x0, 0x0f000000
	dspck_dstio cmpgdu.le.qb, 0x0000000e, 0x1602001c, 0x99220302, 0x0, 0x0e000000
	dspck_dstio cmpgdu.le.qb, 0x00000003, 0xf3ff0000, 0x006000ff, 0x0, 0x03000000
	dspck_dstio cmpgdu.le.qb, 0x00000002, 0xff8f001c, 0x092f0100, 0x0, 0x02000000
	dspck_dstio cmpgdu.le.qb, 0x00000008, 0x00e7077e, 0x0020002f, 0x0, 0x08000000
	dspck_dstio cmpgdu.le.qb, 0x00000002, 0xaa0100ff, 0x0800ff06, 0x0, 0x02000000
	dspck_dstio cmpgdu.le.qb, 0x0000000f, 0xff000001, 0xff18f906, 0x0, 0x0f000000
	dspck_dstio cmpgdu.le.qb, 0x00000009, 0x00ffff05, 0x00718107, 0x0, 0x09000000
	dspck_dstio cmpgdu.le.qb, 0x00000003, 0x71193401, 0x6000ffdb, 0x0, 0x03000000
	dspck_dstio cmpgdu.le.qb, 0x0000000b, 0x008e0111, 0x0000992b, 0x0, 0x0b000000
	dspck_dstio cmpgdu.le.qb, 0x00000000, 0x71ff5508, 0x0d060003, 0x0, 0x00000000
	dspck_dstio cmpgdu.le.qb, 0x00000005, 0x81ff3600, 0x5bff03ff, 0x0, 0x05000000
	dspck_dstio cmpgdu.le.qb, 0x0000000a, 0x078700ff, 0xff0383cf, 0x0, 0x0a000000
	dspck_dstio cmpgdu.le.qb, 0x0000000c, 0xff00ff04, 0xffff8101, 0x0, 0x0c000000
	dspck_dstio cmpgdu.le.qb, 0x00000006, 0xff00008f, 0x19ff3a00, 0x0, 0x06000000
	dspck_dstio cmpgdu.le.qb, 0x0000000e, 0x00c00020, 0x0fe00000, 0x0, 0x0e000000

	writemsg "[11] Test dpa.w.ph"
	dspckacc_astio dpa.w.ph, $ac2, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0xfea8b6db, 0x00000000, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac1, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0xf0017fff, 0x00000000, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac3, 0x0005b1d8, 0x6e41ec9a, 0x0005b1d8, 0x81590494, 0x80007ffa, 0xd5d3fc01, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac3, 0x0327f3a3, 0x96512bf6, 0x0327f3a3, 0x5682ab94, 0x00628000, 0x7fff7fff, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac3, 0x80000000, 0x00000000, 0x7fffffff, 0xc71b8002, 0xfffe71c7, 0x7fff8000, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac2, 0xfffec14f, 0x38e18814, 0xfffec14f, 0x638c8814, 0x0000aaaa, 0x80058000, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac2, 0x7fffffff, 0xffffffff, 0x80000000, 0x3ffc0006, 0x00007ff9, 0xfff67fff, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac1, 0xffffffff, 0xffffffe0, 0x00000000, 0x3ffc7fe7, 0x8000fff9, 0x80007fff, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac2, 0x0f0f0f0f, 0x0f0f0f0f, 0x0f0f0f0f, 0x0f0e3536, 0x001f0000, 0xf8f90007, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac2, 0x80000000, 0x00000000, 0x80000000, 0x2aab0000, 0x0000aaaa, 0x09558000, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac3, 0x003b4563, 0x02d52d0c, 0x003b4563, 0x03832a54, 0x015c0000, 0x7ffe8000, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac0, 0xffffffff, 0xfffffffe, 0xffffffff, 0xc0037ffe, 0xffc07ff9, 0x00008000, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac3, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x00000000, 0x0000ffff, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac0, 0x7fffffff, 0xffffff80, 0x7fffffff, 0x8002ff7c, 0x80007fff, 0x7fff8004, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac1, 0x80000000, 0x00000001, 0x7fffffff, 0xf1c770f2, 0x1c710f0f, 0x8000ffff, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac1, 0x71c71c71, 0xc71c71c7, 0x71c71c71, 0xc71bf1c8, 0xffff3fc0, 0x7fff0000, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac0, 0xfffef965, 0x04b726aa, 0xfffef965, 0x44ae23d7, 0x800fff00, 0x80030003, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac3, 0x55555555, 0x55555555, 0x55555555, 0x55555555, 0x00000000, 0x02857fff, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac3, 0x00000000, 0x00000002, 0x00000000, 0x00048ec7, 0xffb70002, 0xf003ffd0, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac3, 0x00000000, 0x00000000, 0xffffffff, 0xc0020000, 0x7fff7ffc, 0x00008000, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac1, 0x80000000, 0x00000000, 0x80000000, 0x0ff061e0, 0x80000002, 0xe01ff0f0, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac2, 0xffffffff, 0xfff5c2de, 0xffffffff, 0xe7f502dd, 0x7ffff003, 0xc0018000, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac2, 0x00000000, 0x00000000, 0xffffffff, 0xc0597f4e, 0x7fff7fff, 0x800600ac, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac3, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x80000000, 0x00000000, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac2, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff69fff2, 0x00000000, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac0, 0xe0000000, 0x00000003, 0xdfffffff, 0xfffd0083, 0xffff8000, 0x7f800005, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac2, 0xffffffff, 0xffffffff, 0x00000000, 0x01b6077b, 0xf8848000, 0xfffffc94, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac2, 0xffffffff, 0xfffffffe, 0xffffffff, 0xf873d01e, 0x7ffffc01, 0xf0f00110, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac1, 0xc0000000, 0x00000007, 0xc0000000, 0x00000007, 0x3ec40000, 0x00007fff, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac1, 0x2622e9f3, 0x17799bff, 0x2622e9f2, 0xecfa45f0, 0xfe5d807f, 0xff7e5555, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac0, 0x80000000, 0x00000000, 0x80000000, 0x000aedee, 0x0002fc01, 0x0055fd44, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac2, 0x80000000, 0x00000004, 0x80000000, 0x00bef99e, 0xe007f14d, 0x0000f302, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac3, 0x00000000, 0x741b9c5f, 0x00000000, 0xb41a9c60, 0x7fff7fff, 0x7fff0000, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac2, 0x00000000, 0x00000000, 0xffffffff, 0xffff8001, 0x7fff0000, 0xffff8000, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac1, 0xffffffff, 0xfffeaa5a, 0xffffffff, 0xfffebef1, 0x00000003, 0x000506dd, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac0, 0x00000000, 0x00000035, 0xffffffff, 0xfe814613, 0x8002e00f, 0x02fefffe, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac1, 0x80000000, 0x00000000, 0x7fffffff, 0xe013ffe0, 0x7fff3ff8, 0x00208000, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac3, 0x00000000, 0x00000007, 0xffffffff, 0xffff8009, 0x00000001, 0xc01f8002, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac1, 0xdb6db6db, 0x6db6db6d, 0xdb6db6db, 0x2db75b6d, 0x80000000, 0x7fffff80, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac3, 0xffffffff, 0xfffffff8, 0xffffffff, 0xcce10557, 0x6666f007, 0x803f0053, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac1, 0x00000000, 0x013720ed, 0x00000000, 0x413620ee, 0x00007fff, 0xe0077fff, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac1, 0xffffa810, 0x9221fb51, 0xffffa810, 0x677750a7, 0x00007fff, 0x03ecaaaa, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac2, 0x00000000, 0x00000003, 0xffffffff, 0xfffffdbd, 0x000000c2, 0x8000fffd, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac2, 0xffffffff, 0xff4cd7de, 0xffffffff, 0xff4cb0c4, 0x00000596, 0x7ffdfff9, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac2, 0x00000000, 0x00000001, 0x00000000, 0x00000001, 0x7ffffffc, 0x00000000, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac3, 0xf8000000, 0x00000001, 0xf8000000, 0x0325b84d, 0xf9b5fffa, 0x8000f69e, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac3, 0x66666666, 0x66666666, 0x66666666, 0x66666666, 0x00000000, 0x1ffe800f, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac2, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7fff2401, 0x00000000, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac0, 0x00000000, 0x00000002, 0x00000000, 0x00018002, 0x80000000, 0xfffdffff, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac0, 0x00000000, 0x0000003f, 0x00000000, 0x0001003d, 0x00007fff, 0x19090002, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac2, 0x0000003c, 0x81f26808, 0x0000003c, 0xc1e2e808, 0x00008000, 0x1c6e801f, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac2, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaa47e2, 0xf9580007, 0xfffff0f0, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac0, 0xffffffff, 0xfd35146e, 0xffffffff, 0xfd35146e, 0x00008000, 0x7fff0000, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac3, 0xfff110c9, 0x419edfd7, 0xfff110c9, 0x3a3bee9d, 0x00007fff, 0xfff7f13a, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac2, 0x00076db4, 0xbdf3e757, 0x00076db4, 0xc151e09b, 0x7fff7fff, 0x07acff10, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac2, 0x80000000, 0x00000000, 0x80000000, 0x06e3f0e2, 0x3fc0e38e, 0xff20c007, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac1, 0x7fffffff, 0xffffffff, 0x80000000, 0x00197fca, 0x7fff8000, 0x00350002, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac1, 0x00000000, 0x0000063c, 0xffffffff, 0xf878154c, 0xf801f0f0, 0x00007fff, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac2, 0x1fffffff, 0xfffffffc, 0x1fffffff, 0xffff7d40, 0x0002ffeb, 0x0003063a, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac3, 0x80000000, 0x00000000, 0x7fffffff, 0xfffeb9ae, 0xffa40001, 0x038cfffe, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac0, 0x00000000, 0x00000165, 0xffffffff, 0xdb6d74b1, 0x8000000a, 0x4924f1ee, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac3, 0x80000000, 0x00000004, 0x80000000, 0x00000004, 0xfffefff6, 0x00000000, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac3, 0xf8000000, 0x00000001, 0xf8000000, 0x003cc37b, 0x0000807f, 0x8000ff86, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac0, 0x00000000, 0x00000004, 0x00000000, 0x03fdfa30, 0x7fff0008, 0x07fc0045, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac0, 0x71c71c71, 0xc71c71c7, 0x71c71c71, 0xaaaaf1c7, 0x80007ffc, 0x38e30000, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac2, 0x00000000, 0x00000000, 0xffffffff, 0xafcb206b, 0xc5fc7fff, 0x7fff9999, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac2, 0x00000000, 0x00000000, 0xffffffff, 0xffff4b80, 0xffed0006, 0xff66e003, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac1, 0xffffe808, 0xd9a80061, 0xffffe808, 0x99a88061, 0x7fff0000, 0x80000b22, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac2, 0x07ffffff, 0xfffffffc, 0x07ffffff, 0xfffffffc, 0x00000000, 0xfffa0f9e, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac1, 0x7fffffff, 0xffffffff, 0x80000000, 0x00347c63, 0xc0077fff, 0xff82002a, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac0, 0x00000000, 0x56606095, 0x00000000, 0x36812046, 0xfff07fff, 0xf001c03f, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac1, 0x7fffffff, 0xffffffff, 0x80000000, 0x003cf1c6, 0x00018000, 0x71c7ff87, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac2, 0x3fffffff, 0xfffffff8, 0x40000000, 0x3fb06f1b, 0xfc978000, 0x17558000, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac0, 0xffffe8a9, 0x744ad39c, 0xffffe8a9, 0x74192138, 0xf0550000, 0x032ce007, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac2, 0xffffffff, 0xfffeb769, 0x00000000, 0x002ab769, 0x8000ffa8, 0x00008000, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac3, 0xffffffff, 0xfb19fa7e, 0x00000000, 0x3b15fa85, 0x7fff7fff, 0x7ffffffa, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac1, 0xffffffff, 0xfffffcd4, 0x00000000, 0x000f4b54, 0x8000e163, 0x0000ff80, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac3, 0x00000000, 0x02d5b67b, 0x00000000, 0x3569507f, 0x8e380132, 0x8e380132, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac2, 0x00000000, 0x00000000, 0xffffffff, 0xffff8fc5, 0x7fff07e2, 0xffff0002, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac0, 0x00000000, 0x000000fc, 0x00000000, 0x1f400ba0, 0x7ffffb32, 0x3fe02492, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac0, 0x00000000, 0x00000004, 0xffffffff, 0xff8ddae8, 0x0772fff9, 0xf0f04924, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac0, 0x00000000, 0x00000006, 0x00000000, 0x3ffa802c, 0x7fff7ffb, 0x00027ff8, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac3, 0xffff476a, 0xccd415fe, 0xffff476a, 0xb052960e, 0x8000ffd8, 0x38e36666, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac2, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x00000000, 0x7fff0010, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac3, 0x0fffffff, 0xfffffffe, 0x0fffffff, 0xffff9cbe, 0x0000ffc0, 0x5555018d, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac3, 0x0000ffff, 0x0000ffff, 0x0000fffe, 0xfffd03ef, 0xc03f0000, 0x00107fff, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac2, 0x00000000, 0x00000000, 0xffffffff, 0xdb6fb668, 0x00078006, 0xfff04924, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac1, 0x00000000, 0x00000007, 0x00000000, 0x0035128a, 0x8000ed7d, 0xff96ffff, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac2, 0x0000e9ce, 0x507e3769, 0x0000e9ce, 0x340c704d, 0x00007fff, 0x257ac71c, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac1, 0x71c71c71, 0xc71c71c7, 0x71c71c71, 0xc71c71c7, 0xfffdffff, 0x00000000, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac1, 0x7fffffff, 0xffffffff, 0x80000000, 0x0000fff3, 0xfffe01d3, 0x80060000, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac2, 0x00000611, 0x0ecd277d, 0x00000610, 0xdd4598c5, 0x71c77fff, 0x80000eb8, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac2, 0x00000000, 0x00000000, 0xffffffff, 0xffffe978, 0x0780fffc, 0xfffd0002, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac2, 0xfffc06ca, 0x9100de16, 0xfffc06ca, 0x91009566, 0xffffb6db, 0xff8b0001, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac0, 0x06729d6e, 0x2f7fe3e8, 0x06729d6e, 0x2f803306, 0x0ff8001f, 0x0005fffa, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac2, 0x00000000, 0x0000000f, 0x00000000, 0x00030003, 0x00008002, 0xcbb4fffa, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac0, 0x00000000, 0x00000000, 0xffffffff, 0xe0057ad6, 0x7ff0fffe, 0xc003027d, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac1, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x00000ff8, 0x1b440000, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac3, 0x00327ee6, 0xa703c34a, 0x00327ee6, 0xa6e88491, 0x0000c003, 0x0000006d, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac3, 0x80000000, 0x00000000, 0x80000000, 0x0008f375, 0x3ff0120b, 0x0000007f, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac0, 0x80000000, 0x00000000, 0x80000000, 0x00800000, 0x0000ff00, 0x1ffc8000, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac0, 0xffffffe3, 0xe65d492d, 0xffffffe3, 0xcd70897d, 0x7ffb71c7, 0x3ff08000, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac2, 0x00000000, 0x00000000, 0x00000000, 0x40000000, 0xfff08000, 0x00008000, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac3, 0x80000000, 0x00000002, 0x80000000, 0x1248db70, 0x00002492, 0x80007fff, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac0, 0xfffd6e60, 0x3316951d, 0xfffd6e5f, 0xf318951a, 0xf9d98003, 0x00007fff, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac2, 0x7fffffff, 0xfffffffc, 0x7fffffff, 0xffe1404a, 0xffc4e003, 0x7fff0006, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac2, 0x00000000, 0x00000006, 0x00000000, 0x00000006, 0x800ffffa, 0x00000000, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac2, 0x80000000, 0x00000007, 0x7fffffff, 0xffffee07, 0xff000001, 0x00120000, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac2, 0x00000000, 0x02001147, 0xffffffff, 0xc220904e, 0x8000001f, 0x7fc00419, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac1, 0xffffffff, 0xffffffc7, 0x00000000, 0x000eb887, 0xc71c3fe0, 0xffc00002, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac2, 0x00000000, 0x00000000, 0xffffffff, 0xfc01f95e, 0xfffe1ffc, 0x3333e00f, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac3, 0x7fffffff, 0xfffffffc, 0x7fffffff, 0xe007fffc, 0x80000000, 0x3ff0ff2a, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac2, 0x00000001, 0x1f1b24b5, 0x00000001, 0x1f1a8022, 0x0001db6d, 0x80000001, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac2, 0xffffffff, 0xffffff8d, 0x00000000, 0x003fff0e, 0xffff007f, 0x80007fff, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac3, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xfffe8002, 0xfffd8000, 0x7fff0000, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac1, 0xf8000000, 0x00000001, 0xf8000000, 0x00000001, 0xf3a4ff26, 0x00000000, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac1, 0x80000000, 0x00000000, 0x7fffffff, 0xffff8000, 0x00018000, 0x80000000, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac2, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xfff8000f, 0xfffe7fff, 0x0000fff0, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac0, 0x00000000, 0x00000000, 0xffffffff, 0xffd105f4, 0x0000fb1c, 0x7fff099b, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac1, 0x7fffffff, 0xfffffff0, 0x80000000, 0x000042ad, 0x000000ff, 0xf8010043, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac3, 0x00000000, 0x00000000, 0x00000000, 0x40003f01, 0x007f8000, 0x007f8000, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac1, 0x7fffffff, 0xfffffffb, 0x7fffffff, 0xfffffffb, 0x00000000, 0x0ffc7fff, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac3, 0x80000000, 0x00000000, 0x7fffffff, 0xc00fffe1, 0x0000801f, 0xff7d7fff, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac1, 0x80000000, 0x00000000, 0x7fffffff, 0xffffb6da, 0xccccdb6d, 0x00000002, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac1, 0x00000000, 0x00000000, 0x00000000, 0x40000000, 0x80008000, 0x80000000, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac1, 0x80000000, 0x00000000, 0x7fffffff, 0xfa667d3a, 0x7ffaf655, 0xeb218000, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac2, 0xffffffff, 0xfffffff0, 0x00000000, 0x03c3a1d2, 0x00003ffe, 0x80000f0f, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac2, 0xffffffe8, 0x38706230, 0xffffffe8, 0x38706230, 0x00000000, 0x0000f9c2, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac2, 0x000000e3, 0x9d3c57e4, 0x000000e3, 0x9dda56a8, 0x00007fff, 0x17c7013c, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac3, 0x00000000, 0x000000ff, 0xffffffff, 0xfffec914, 0x00120003, 0xf001f801, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac0, 0xf66afd8a, 0xf6925efe, 0xf66afd8a, 0xf6935f02, 0x0002ff00, 0x0002ff00, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac0, 0xffffffff, 0xffffff80, 0xffffffff, 0xfff8ab72, 0x002bfffc, 0xd2e2f001, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac2, 0x80000000, 0x0000003f, 0x7fffffff, 0xffc000bf, 0x00007fff, 0x0000ff80, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac2, 0xffffffff, 0xffffffff, 0x00000000, 0x402d0000, 0x7fff8000, 0x7fffffa4, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac3, 0x00000000, 0x00000d70, 0xffffffff, 0xfff68d70, 0x06548000, 0x00000013, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac1, 0xfffffff8, 0xc5d3660c, 0xfffffff8, 0xc5d32d23, 0x38e3fffd, 0xffff0002, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac1, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xfc19edf3, 0x003c0ff8, 0x5555c03f, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac0, 0xffffffff, 0xfffffff8, 0xffffffff, 0xfe9500f6, 0x80028000, 0x007f0257, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac1, 0xffff0000, 0xffff0000, 0xffff0000, 0xc000c012, 0xe0018000, 0x00127ff8, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac3, 0x00000000, 0x00778b21, 0x00000000, 0x00778b21, 0x0037ffc3, 0x00000000, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac3, 0x00000000, 0x0031c77c, 0x00000000, 0x005c477c, 0x00008000, 0x0001ffab, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac1, 0x80000000, 0x00000000, 0x7fffffff, 0xbffd8000, 0x80000006, 0x7fff8000, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac2, 0x80000000, 0x00000000, 0x7fffffff, 0xffffffbe, 0xfffe0006, 0x0000fff5, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac0, 0x7fffffff, 0xfffffffa, 0x7fffffff, 0xfc827fb8, 0xfc01c821, 0x00000ffe, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac1, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xfd5b467a, 0x7fff2d18, 0x0005f0f0, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000e01f, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac2, 0x0fffffff, 0xfffffffe, 0x10000000, 0x0ab3301e, 0x38e30f0f, 0x0e457fff, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac2, 0x80000000, 0x00000003, 0x80000000, 0x00000003, 0x000003fe, 0x00000000, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac0, 0xffffffff, 0xffffffeb, 0xffffffff, 0xffffffeb, 0xf0078000, 0x00000000, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac2, 0x80000000, 0x00000000, 0x80000000, 0x009b60e1, 0x00140c77, 0x00140c77, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac3, 0xfffffffd, 0x7aed58f9, 0xfffffffd, 0x88bfbd54, 0x1ba50000, 0x7ffffffe, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac3, 0x0000000a, 0xc9d0d535, 0x0000000a, 0xd158d535, 0x00008000, 0x0000f0f0, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac2, 0xe0000000, 0x00000003, 0xdfffffff, 0xfffd0003, 0xf0010006, 0x00008000, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac1, 0xf0000000, 0x00000003, 0xefffffff, 0xc0075d1e, 0xff458000, 0x00df7ff0, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac0, 0xe38e38e3, 0x8e38e38e, 0xe38e38e3, 0x8e3cdf96, 0xfffafffe, 0x807f807f, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac0, 0xe0000000, 0x00000003, 0xdfffffff, 0xc0005a83, 0x8000ffc0, 0x7fff0096, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac3, 0x80000000, 0x00000000, 0x7fffffff, 0xc0007ec0, 0x8000fff8, 0x7fff0028, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac0, 0xfffffffc, 0xa1321610, 0xfffffffc, 0xa13a9487, 0x0009ff80, 0x7ffff803, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac0, 0x00000b0c, 0xdf2900d5, 0x00000b0d, 0x1f280c3a, 0xfffa7fff, 0xfe1a7fff, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac0, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xf68b7b4f, 0x00001546, 0x80028e38, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac0, 0x00000000, 0x00000000, 0x00000000, 0x1bab38e8, 0x01897ff8, 0x800038e3, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac2, 0xffffffff, 0xff916db6, 0xffffffff, 0xff9f2e07, 0xfff9001f, 0x3ff07fff, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac0, 0xfffffffd, 0x1bb2d7a6, 0xfffffffc, 0xfdfa1318, 0xc71c7fff, 0x7ffffd72, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac2, 0x000004d5, 0xafe0f76c, 0x000004d5, 0xafe1776b, 0x7fff0000, 0x0001ffff, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac1, 0xfe090217, 0xbea0acbe, 0xfe090217, 0xbe01216e, 0x80007ff8, 0x02a9016a, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac0, 0x80000000, 0x00000003, 0x7fffffff, 0xfc8cdbb2, 0x803f0f0f, 0x0035c71c, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac3, 0x80000000, 0x00000000, 0x80000000, 0x1006a030, 0x1ff08000, 0x7ffdffe2, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac0, 0x49249249, 0x24924924, 0x49249249, 0x41044924, 0x00008000, 0xff80c71c, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac2, 0xc0000000, 0x00000007, 0xbfffffff, 0xff9b00d1, 0xf95005e6, 0x7fff7fff, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac1, 0x00000000, 0x0002b5a3, 0xffffffff, 0xfffd35a3, 0x000bfffe, 0x80000000, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac1, 0xfe5c9ac4, 0x23718f95, 0xfe5c9ac4, 0x43614fb5, 0x80007fff, 0x00003fe0, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac3, 0xb6db6db6, 0xdb6db6db, 0xb6db6db6, 0xdb6db6db, 0x07fc0006, 0x00000000, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac2, 0xffffffff, 0xffffffc0, 0xffffffff, 0xfffffddd, 0x0063000c, 0xffffffe0, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac1, 0x00000000, 0x0000a7cc, 0xffffffff, 0xe2e9bf23, 0x3a310000, 0x8007ffd2, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac3, 0xffffffff, 0xfffffff9, 0x00000000, 0x0000005e, 0xfff6ffff, 0xfff6ffff, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac0, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x0000800f, 0x00070000, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac3, 0x00000000, 0x000000ff, 0xffffffff, 0xfff7837c, 0x0003ffec, 0x7fff7fe0, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac3, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x00000000, 0x00007fff, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac3, 0x00000000, 0x03fe3739, 0x00000000, 0x03fe3739, 0x00000000, 0x8000fff8, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac1, 0xfffffff8, 0xae7abf0a, 0xfffffff8, 0xaeca3e6b, 0x0000009f, 0x00007fff, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac3, 0xfffffcbe, 0xdc7790df, 0xfffffcbe, 0xebc796d1, 0x23bb0000, 0x6db6000b, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac2, 0xdb6db6db, 0x6db6db6d, 0xdb6db6db, 0x74d2e9a5, 0xc0038e38, 0x0000f001, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac2, 0x7fffffff, 0xffffffff, 0x80000000, 0x003ff001, 0xfffff801, 0xfffff801, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac3, 0x80000000, 0x00000001, 0x7fffffff, 0xff9a1a00, 0x66660001, 0xff007fff, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac3, 0x7fffffff, 0xffffffff, 0x80000000, 0x00207fbe, 0x7ffffffc, 0x00410000, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac1, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x00efff27, 0xf0f00002, 0xf020f094, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac0, 0xffffffff, 0xfffffee6, 0x00000000, 0x3ffffee6, 0x80000000, 0x80007ffc, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac2, 0x00000000, 0x00000006, 0xffffffff, 0xffdf8047, 0x7fff8000, 0xffbf0000, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac0, 0x07ffffff, 0xfffffffc, 0x07ffffff, 0xf22c8a44, 0xff371c71, 0x80058005, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac1, 0x000000a8, 0x9e0579ec, 0x000000a8, 0x94aa7e8c, 0x8000b6db, 0x007f1fe0, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac2, 0x00000000, 0x64ef51b8, 0x00000000, 0x64e751c8, 0x0000fff0, 0x7fff7fff, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac0, 0x00000000, 0x00000000, 0x00000000, 0x40006dc5, 0xfece7fff, 0xfece7fff, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac1, 0xf0000000, 0x00000003, 0xf0000000, 0x30059ff7, 0x7ffd7fff, 0x7fffe00f, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac2, 0x00000000, 0x00000001, 0x00000000, 0x040d865d, 0x800f0000, 0xf7e48000, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac1, 0xc0000000, 0x00000001, 0xc0000000, 0x00000001, 0x00006db6, 0xfffe0000, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac3, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xc62f7393, 0x7fff800f, 0x0c4e7ffe, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac0, 0x00c48b94, 0x7666df7e, 0x00c48b94, 0x7649dfb8, 0x00007fff, 0xffc1ffc6, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac3, 0xffffffff, 0xfffbe8e0, 0x00000000, 0x18aaea4e, 0x7ff938e3, 0x03dc6666, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac1, 0xffff92e3, 0x3fa343fb, 0xffff92e3, 0x877827bc, 0xe01f8000, 0xc01f803f, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac1, 0x0f0f0f0f, 0x0f0f0f0f, 0x0f0f0f0f, 0x07109f0c, 0xc00f7fff, 0x0000f003, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac3, 0x80000000, 0x00000000, 0x7fffffff, 0xe67fd9c0, 0x38e39999, 0x00003fc0, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac3, 0xffffffff, 0xffffff89, 0x00000000, 0x22a6597a, 0x7fff803f, 0x7f803a4f, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac3, 0xffffffff, 0xfffd5bb6, 0xffffffff, 0xfd56c572, 0xed937fff, 0x24d40000, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac1, 0x00000000, 0x349b6162, 0x00000000, 0x349b5ed4, 0x0000006d, 0x803ffffa, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac2, 0xfff1ea15, 0x85bc6da8, 0xfff1ea15, 0x85bc6daa, 0x0001c01f, 0x00020000, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac3, 0x00000000, 0x00000000, 0xffffffff, 0xfef18cd1, 0x7fff055a, 0xfde30002, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac1, 0x0f0f0f0f, 0x0f0f0f0f, 0x0f0f0f0f, 0x0eef430a, 0xff800bfb, 0x8000f801, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac2, 0x00000000, 0x00000000, 0x00000000, 0x001ef9b3, 0x000707fe, 0x003503e0, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac3, 0x00000000, 0x05da3d3b, 0x00000000, 0x09fac5da, 0x099c068f, 0x6db60059, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac1, 0x7fffffff, 0xffffffc0, 0x80000000, 0x1ff681bc, 0xc00f0004, 0x8000807f, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac1, 0x80000000, 0x0000007f, 0x80000000, 0x00022188, 0xffcb000f, 0x00112492, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac3, 0x80000000, 0x00000000, 0x80000000, 0x00000758, 0x6666fffc, 0x0000fe2a, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac3, 0xf0f0f0f0, 0xf0f0f0f0, 0xf0f0f0f1, 0x29d3ff29, 0x7fff0000, 0x71c70000, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac0, 0xffffffff, 0xfffffffa, 0x00000000, 0x1b52c21f, 0x0002c03f, 0x01179249, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac1, 0x00000f0f, 0x716bbd7a, 0x00000f0f, 0x6d6c4579, 0xc03ff801, 0x00007fff, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac1, 0x3fffffff, 0xfffffff8, 0x3fffffff, 0xfe678323, 0x8000fcd5, 0x00067fff, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac1, 0xffffffff, 0xfe7b529d, 0xffffffff, 0xfe7a7ccd, 0xfff50ffc, 0x11fcffff, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac2, 0x00000000, 0x00000004, 0x00000000, 0x00008004, 0x80001c71, 0xffff0000, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac1, 0x00000000, 0x00000000, 0xffffffff, 0xfffffefb, 0x9999fefb, 0x00000001, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac1, 0x7fffffff, 0xfffffffb, 0x7fffffff, 0xfe207fbc, 0x03fe7fff, 0x8000003f, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac3, 0x00000000, 0x00000000, 0x00000000, 0x0000400a, 0x00010006, 0x3ff80003, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac3, 0x00000000, 0x0000003f, 0xffffffff, 0xfc713b43, 0x9999f87c, 0xff807fff, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac0, 0x00000e4c, 0xf60a9f91, 0x00000e4d, 0x6eee9f91, 0x8e388000, 0x80008000, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac0, 0xc0000000, 0x00000001, 0xc0000000, 0x3fe08041, 0xfffe7fff, 0x80007fc0, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac1, 0xff00ff00, 0xff00ff00, 0xff00ff00, 0xfefccbd4, 0x00017fff, 0xccccfff8, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac1, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xfffff75f, 0x0001ffe9, 0xf6bffff9, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac0, 0x80000000, 0x00000000, 0x80000000, 0x30c1fe84, 0x71c7fffb, 0x6db61ffe, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac3, 0xfd9e612d, 0x27f639e9, 0xfd9e612d, 0x681b685a, 0x80000619, 0x80000619, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac0, 0x80000000, 0x00000004, 0x80000000, 0x00000004, 0x7fe0fe15, 0x00000000, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac2, 0xffffffff, 0xffffffff, 0x00000000, 0x000017b4, 0x000f05f1, 0xffff0004, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac0, 0x71c71c71, 0xc71c71c7, 0x71c71c72, 0x070cefdb, 0x0052801f, 0xfffa8000, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x80003333, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac3, 0x80000000, 0x00000000, 0x80000000, 0x0049ffd8, 0xff6cffff, 0x80000028, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac0, 0x00000000, 0x001fc0e8, 0x00000000, 0x0017e2a1, 0xe0070000, 0x003f8000, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac2, 0x80000000, 0x00000000, 0x80000000, 0x012bfff0, 0xb6db801f, 0xff05fe37, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac2, 0xffcf2742, 0xf03b2b2a, 0xffcf2742, 0xf03b2b2a, 0x0004fffe, 0x00000000, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac2, 0xffffec23, 0x46cbc035, 0xffffec23, 0x46cb4035, 0x00008000, 0x80000001, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac1, 0x1fffffff, 0xfffffff8, 0x1fffffff, 0xfe6afff8, 0x032a0f0f, 0x80000000, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac3, 0x00000000, 0x00000034, 0x00000000, 0x0001381d, 0xf8030002, 0xfff97fff, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac0, 0x80000000, 0x00000005, 0x7fffffff, 0xffb1efe1, 0xffec0218, 0x803fd5f3, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac2, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x00000000, 0xff8cfada, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac2, 0xffff0000, 0xffff0000, 0xffff0001, 0x00949c5a, 0x8000ec5a, 0x000ff801, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac0, 0x7fffffff, 0xffffffff, 0x80000000, 0x00d6ffff, 0x000a8000, 0x8000fe48, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac1, 0x80000000, 0x00000000, 0x80000000, 0x00005fa3, 0xe01f7fff, 0xfffd0000, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac1, 0x00000007, 0xc4ab6b32, 0x00000007, 0xc49beb32, 0x3fc08000, 0x0000001f, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac2, 0xffffffff, 0xfffffff8, 0x00000000, 0x0001cdc2, 0x6666fff8, 0x00071fe0, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac1, 0x00000000, 0x00000002, 0xffffffff, 0xff970002, 0x00d20000, 0x8000fffe, 0x00010000, 0x00010000
	dspckacc_astio dpa.w.ph, $ac1, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xff910bc3, 0x0000f90f, 0x7fff0ffc, 0x00000000, 0x00000000
	dspckacc_astio dpa.w.ph, $ac0, 0x80000000, 0x00000000, 0x7fffffff, 0xf2080040, 0x1bec7ff0, 0x8000fffc, 0x00000000, 0x00000000

	writemsg "[12] Test dps.w.ph"
	dspckacc_astio dps.w.ph, $ac0, 0x00000000, 0x00000006, 0x00000000, 0x031d1f69, 0x24920059, 0xea34fffd, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac3, 0xffffffff, 0xffd46ab9, 0xffffffff, 0xe7e05a7a, 0xe00ff001, 0x8000803f, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac3, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xfffc605c, 0x0000054d, 0x077200af, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac0, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xfffeef54, 0x02500035, 0x0076ffff, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac2, 0x00000011, 0xd9821737, 0x00000011, 0xd9821ce5, 0xffff0024, 0xffeaffd7, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac3, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xfff5a297, 0xfc010000, 0xfd68fffd, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac0, 0x00000000, 0x00000000, 0xffffffff, 0xdffe8000, 0xc0018000, 0x8000fffc, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac3, 0x80000000, 0x00000000, 0x7fffffff, 0xfffc8007, 0x7fff0000, 0x00070000, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac3, 0x00000000, 0x00000000, 0xffffffff, 0xf62487d3, 0x0ff8801f, 0x1ffef043, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac2, 0x80000000, 0x00000000, 0x7fffffff, 0xfefffffc, 0x0ffeff80, 0x0ffeff80, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac0, 0xffb4d691, 0x925251d6, 0xffb4d691, 0x125851bc, 0x7ffb7fff, 0x7ffb7fff, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac0, 0xffffffff, 0xfffa95a7, 0x00000000, 0x0007559f, 0x3ffc7fff, 0x80063fe0, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac3, 0x80000000, 0x00000000, 0x80000000, 0x3fff8000, 0x80008000, 0x00007fff, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac1, 0x00000000, 0x0000d78e, 0xffffffff, 0xc0005796, 0x00037fff, 0x7ffd7fff, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac0, 0x7fffffff, 0xfffffffd, 0x7fffffff, 0xfeb5447c, 0xf98cfffb, 0xccccf003, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac1, 0xffffffff, 0xffffff61, 0x00000000, 0x03591d89, 0xe8480000, 0x24238000, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac1, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x0001ffeb, 0x00000000, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac3, 0xffff0000, 0xffff0000, 0xffff0001, 0x020e6b68, 0xfabdf001, 0x6666ff4a, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac0, 0x00000000, 0x5874e925, 0x00000000, 0x5870e925, 0xf8038000, 0x0000fff8, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac0, 0x00000000, 0x0002dd5b, 0xffffffff, 0xfff80bd9, 0xfffefc9e, 0x08f7fcc8, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac3, 0xffffb42d, 0xf197cd6f, 0xffffb42d, 0xf1982d0f, 0x1fe0ffff, 0xfffe1fe0, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac3, 0xffffffff, 0xfffffffe, 0xffffffff, 0xffff800d, 0xfff07fff, 0xf001ffff, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac3, 0x92492492, 0x49249249, 0x92492492, 0x49249249, 0x00000000, 0x00000000, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac2, 0x00001d14, 0x83abf203, 0x00001d14, 0x9d391ce9, 0xffe9c01f, 0x00c06666, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac2, 0xffffffff, 0xfffffffe, 0xffffffff, 0xc3fef807, 0x8007f809, 0x80007fff, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac0, 0x80000000, 0x00000000, 0x7fffffff, 0xfedc7fdb, 0xffdb8000, 0x7ffffd94, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac2, 0xffffffff, 0xfffffffb, 0xffffffff, 0xfffffe07, 0xfff8fffd, 0xffedff8c, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac1, 0x00000000, 0x00000000, 0x00000000, 0x0000fae6, 0x07d70002, 0xffe0fffd, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac2, 0xc0000000, 0x0000001f, 0xbfffffff, 0xc007801f, 0x80000000, 0x800f0000, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac0, 0x7fffffff, 0xffffffff, 0x80000000, 0x1242ffff, 0xfff48000, 0x80002492, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac3, 0xfffff85b, 0x0e81b11b, 0xfffff85b, 0x4e7abf64, 0x7fff001d, 0x800038e3, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac2, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x800fc001, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac1, 0xffffe536, 0x55eaa9bd, 0xffffe536, 0x574b935b, 0x1b478000, 0xe38efcb2, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac2, 0xffffffff, 0xfffffec3, 0x00000000, 0x40102c07, 0x7fff3fc0, 0x8004ffb5, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac2, 0x7fffffff, 0xffffffff, 0x80000000, 0x1fefffff, 0x80008000, 0x00003fe0, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac3, 0x80000000, 0x00000000, 0x7fffffff, 0xff9e18fc, 0x7fc0ff2c, 0x005ac003, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac0, 0x00000000, 0x00000000, 0xffffffff, 0xf80c0fe8, 0x7fff0ff8, 0xfff07fff, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac1, 0x00000000, 0x0000007f, 0x00000000, 0x004c5144, 0xff590099, 0xffd4801f, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac1, 0x0fffffff, 0xfffffffc, 0x10000000, 0x01ff7bb5, 0x00187fff, 0x0003fc01, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac3, 0xe0000000, 0x00000003, 0xe0000000, 0x00000003, 0x3ff8ff84, 0x00000000, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac3, 0xffffffff, 0xfffffff9, 0x00000000, 0x0001c713, 0x00027fff, 0x1c71fffc, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac2, 0x0177ccbc, 0xcbfb5c14, 0x0177ccbc, 0x8bfb5c14, 0x80000000, 0x80000000, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac1, 0xfdd9de19, 0x48ff2817, 0xfdd9de19, 0x48ffba61, 0xb6db0000, 0x00023fe0, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac1, 0x00000000, 0x1def42f5, 0x00000000, 0x5dc67abc, 0x02e8807f, 0xf8037fff, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac0, 0xffffffff, 0xffed319b, 0xffffffff, 0x7fee319a, 0x80007fff, 0x80007fff, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac2, 0xffff8e7d, 0x45453af3, 0xffff8e7d, 0x354dd35b, 0xfff87fff, 0x0f0f1ff0, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac3, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0003edfe, 0xdb6d8000, 0x0065ffe9, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac1, 0xffffffff, 0xffff568a, 0xffffffff, 0xffff568a, 0x00000000, 0x8000ff6b, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac0, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x00000000, 0x0002e38e, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac3, 0x80000000, 0x00000000, 0x7fffffff, 0xffdd0046, 0x00468000, 0x7fff0000, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac0, 0x24924924, 0x92492492, 0x24924924, 0x92491b5e, 0x09340000, 0x0001ffe4, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac3, 0xffffffff, 0xffffff80, 0x00000000, 0x001f7ee1, 0x0006003f, 0xfd85803f, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac3, 0x7fffffff, 0xffffffff, 0x80000000, 0x0005a068, 0x000fe007, 0x8000fff1, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac1, 0x7fffffff, 0xfffffff9, 0x7fffffff, 0xbf504bb8, 0x801f7f80, 0x801f019f, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac3, 0x7fffffff, 0xfffffffd, 0x7fffffff, 0xbaec1244, 0x7ffff491, 0x7fff8e38, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac3, 0xffffffff, 0xfffffffd, 0x00000000, 0x0026dc42, 0x7fffdb6d, 0x00060125, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac0, 0x80000000, 0x00000000, 0x7fffffff, 0xc0000000, 0x00008000, 0x00008000, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac1, 0x80000000, 0x00000000, 0x7fffffff, 0xffff6db8, 0x000236e3, 0x49240000, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac2, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x00000000, 0xe38efff7, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac2, 0xffffffff, 0xee497f93, 0xffffffff, 0xefc014a3, 0xc003fb49, 0xff915555, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac3, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x00000000, 0xfffc0000, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac3, 0x00000000, 0x00000024, 0xffffffff, 0xf0037ff3, 0x0000c007, 0x0000c007, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac2, 0x00001455, 0xf149a2cb, 0x00001455, 0xb15122cb, 0x8000005b, 0x800f0000, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac1, 0x7fffffff, 0xffffffff, 0x80000000, 0x0011fe1d, 0x0024ffff, 0x800f003a, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac3, 0x80000000, 0x00000000, 0x7fffffff, 0xfc0ee2b9, 0x0ffef803, 0x3ff801bd, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac1, 0x7fffffff, 0xffffffff, 0x80000000, 0x0002e003, 0x00061ffc, 0x80000001, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac2, 0xffffffff, 0xfffffff0, 0xffffffff, 0xfffffff0, 0x0040e774, 0x00000000, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac0, 0xfffff967, 0x9b888bb0, 0xfffff967, 0x7d9789b0, 0x80003ff0, 0x03fe7fe0, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac1, 0xffffffff, 0xfe7627ab, 0xffffffff, 0xbe29a78b, 0xff467fe0, 0x80007fff, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac0, 0x00000000, 0x00000006, 0xffffffff, 0xbffb800f, 0x80000009, 0x80007fff, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac0, 0x00000000, 0x00000000, 0x00000000, 0x1fde46df, 0xfffd807f, 0x01a13ffc, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac3, 0x3fffffff, 0xfffffff0, 0x3fffffff, 0xfffffff0, 0x00000000, 0x00003ffe, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac1, 0x80000000, 0x00000000, 0x80000000, 0x01e66d68, 0x80008005, 0x001503b8, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac0, 0x80000000, 0x00000007, 0x80000000, 0x3fff8007, 0x00007fff, 0x71c78000, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac2, 0x00000000, 0x00000034, 0x00000000, 0x0003fffc, 0x7ff9fffe, 0xfff80000, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac2, 0x00000000, 0x0000007f, 0x00000000, 0x000266a7, 0xffc0fffd, 0x0999fff8, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac2, 0x00000000, 0x00000009, 0xffffffff, 0xfffc7c5f, 0x003f7fff, 0x000f0007, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac0, 0xfffffe55, 0x7b4d9ef3, 0xfffffe55, 0x7b3778fe, 0x00ca0003, 0x1d05c001, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac2, 0x00000000, 0xb348e486, 0x00000000, 0xb349a429, 0x00030000, 0xc01fe7de, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac2, 0x0009f1bc, 0x4768935b, 0x0009f1bc, 0x59bbd016, 0x04117fff, 0xfd92db6d, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac3, 0xf8000000, 0x00000001, 0xf7ffffff, 0xffb2f4ce, 0x0181ffc0, 0x3333ffd2, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac1, 0x3fffffff, 0xfffffff8, 0x3fffffff, 0xf8008007, 0x0003f001, 0xfffb8000, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac0, 0xc0000000, 0x0000000f, 0xc0000000, 0x0000604d, 0xff460002, 0x007ffe04, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac3, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x00030001, 0x00000000, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac0, 0x38e38e38, 0xe38e38e3, 0x38e38e38, 0xe18c3ce1, 0x7ffffffa, 0x03fe8000, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac1, 0xf84cad82, 0x198c7566, 0xf84cad82, 0x2569485b, 0xee79e001, 0x38e33fc0, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac0, 0x00000000, 0x00000005, 0xffffffff, 0xc03ec8a1, 0xdb6d7fff, 0xfff47f80, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac2, 0xffffffff, 0xfffffffe, 0xffffffff, 0xfe067001, 0xfc0df003, 0x8000ffff, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac3, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x7fff0000, 0x00000000, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac0, 0x00038e1c, 0xdaf28bc2, 0x00038e1c, 0xfaf14bc4, 0x7fff7fff, 0xc003ffff, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac1, 0x00000000, 0x0000006f, 0x00000000, 0x1974006f, 0x80000000, 0x32e83fe0, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac3, 0x00000000, 0x00000302, 0x00000000, 0x1f96026e, 0xaaaa8000, 0xff223fc0, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac1, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xe3f868fb, 0x1ff8c71c, 0xfd1c803f, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac2, 0x80000000, 0x00000000, 0x80000000, 0x00d4e530, 0xfffd7ff0, 0x8000fe53, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac3, 0xffffff8e, 0xe33f475b, 0xffffff8e, 0xe33f475b, 0xfdb2e007, 0x00000000, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac3, 0x00000000, 0x0000007f, 0xffffffff, 0xffd23219, 0x00a0000e, 0x492401b5, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac2, 0xfff29624, 0x3f07165b, 0xfff29624, 0x3f59bda8, 0x00f5ce18, 0xc03f006f, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac2, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0xe38e8000, 0x00000000, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac2, 0xe0000000, 0x00000003, 0xe0000000, 0x4034fd16, 0x8000006b, 0x7fff8007, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac1, 0x0000001c, 0x61d58d9d, 0x0000001c, 0x69d48d9d, 0x8000c01f, 0x0ffe0000, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac2, 0xe221254c, 0x39a33aaf, 0xe221254c, 0x00c02bc7, 0xfff97fff, 0xffe771c7, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac2, 0x80000000, 0x00000005, 0x7fffffff, 0xfc03ff05, 0x00001ff0, 0x00001ff0, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac3, 0x24924924, 0x92492492, 0x24924924, 0x91b5a5e8, 0x024efffe, 0x3ffefe5d, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac2, 0x7fffffff, 0xfffffffd, 0x7fffffff, 0xfffffffd, 0x00000000, 0xff803fc0, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac0, 0x00000000, 0x0398379a, 0x00000000, 0x4397b86c, 0x000f7fff, 0xfff28000, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac1, 0xffff0000, 0xffff0000, 0xffff0001, 0x303158c1, 0x71c70ff8, 0x92490910, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac1, 0xffffed68, 0x8d8942da, 0xffffed68, 0x8d8aac1a, 0xffc00000, 0x05a50000, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac1, 0xffffffff, 0xf62cae7c, 0x00000000, 0x364aaa7f, 0x7ff07fff, 0xffc08003, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac1, 0xffffffff, 0xfffffff0, 0xffffffff, 0xfd8dfff0, 0xfb158000, 0x80000007, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac1, 0xfffffff5, 0x5e8df3c0, 0xfffffff5, 0x5e8df3c0, 0x7ff001e6, 0x00000000, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac2, 0x00ff00ff, 0x00ff00ff, 0x00ff00fe, 0xc10080fd, 0x00007fff, 0x7fff7ffe, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac2, 0x0fffffff, 0xfffffffc, 0x0fffffff, 0xc9247fed, 0xfffb9249, 0xfffd8000, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac0, 0x80000000, 0x00000000, 0x80000000, 0x0357b2bf, 0x0a07ffcd, 0xaaaa0007, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac0, 0x00000000, 0x00000000, 0x00000000, 0x3fff8000, 0x7fff0000, 0x80008007, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac3, 0x00000000, 0x0000003f, 0x00000000, 0x000d473e, 0x800038e3, 0x0003ffcb, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac3, 0x7fffffff, 0xffffffff, 0x80000000, 0x03ceffff, 0x80008000, 0xfff907a5, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac0, 0x7fffffff, 0xffffff80, 0x7fffffff, 0xffffffa8, 0xfff80000, 0x0005e003, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac2, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffe9fc01, 0x00000000, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac2, 0xffffffff, 0xffffffff, 0xffffffff, 0xf9e87fff, 0xffc2f40f, 0x80008000, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac2, 0xffffffdb, 0xe2a6bef0, 0xffffffdc, 0x1be2734c, 0xfa768e38, 0x0fea7fff, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac2, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xfff80005, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac3, 0x7fffffff, 0xffffff80, 0x80000000, 0x00007f7f, 0x80007fff, 0x7fff7fff, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac1, 0xffffffff, 0xfffffda8, 0x00000000, 0x0004294a, 0x00040052, 0xfffef2fb, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac3, 0x80000000, 0x00000000, 0x7fffffff, 0xffffe010, 0xffe00001, 0x00001ff0, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac1, 0xffffffff, 0x5170d173, 0xffffffff, 0x509943d5, 0x8000fe0e, 0xfe51fff9, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac2, 0x0fffffff, 0xfffffff8, 0x10000000, 0x10f77036, 0xd8690007, 0x6db60004, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac1, 0xc0000000, 0x00000001, 0xc0000000, 0x00000001, 0x00000000, 0x8000003f, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac2, 0x7fffffff, 0xffffff80, 0x80000000, 0x00007efd, 0x807f0001, 0x00010004, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac3, 0xff12c914, 0x4706b369, 0xff12c914, 0x71b03367, 0x7ffd8000, 0xaaaaffff, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac1, 0x0000ffff, 0x0000ffff, 0x0000fffe, 0xfed1ce7f, 0x00ff019a, 0x7ffc6db6, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac1, 0xfffffc15, 0x279f88fc, 0xfffffc14, 0xd7af08fc, 0x80008000, 0x8000e01f, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac2, 0x0000000f, 0x6ea838f3, 0x0000000f, 0x4e0a48e4, 0x7ff907fc, 0x39477fc0, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac3, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x00000000, 0x3ffc8000, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac1, 0x00000000, 0x00006950, 0x00000000, 0x00008750, 0x000f003c, 0x0000ff80, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac0, 0x00000000, 0x00000001, 0x00000000, 0x00000001, 0xffed0000, 0x0000fffd, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac2, 0x3fffffff, 0xffffffe0, 0x3fffffff, 0xffffffe0, 0xfffd7fff, 0x00000000, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac3, 0xffffffff, 0xfffa17ca, 0xffffffff, 0xffbb9847, 0x00007fff, 0xb6db007d, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac3, 0x0001113d, 0x8e3b5ea2, 0x0001113d, 0x73031513, 0x00003671, 0x11317fff, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac3, 0x00000000, 0x0363d379, 0x00000000, 0x0302d379, 0x80000000, 0xff3effff, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac1, 0x80000000, 0x00000000, 0x7fffffff, 0xffffff4c, 0xfffa7fff, 0xffe20000, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac2, 0x00000000, 0x00000000, 0xffffffff, 0xcb29ffff, 0x7fff8000, 0x7fff1652, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac0, 0x7fffffff, 0xffffffff, 0x80000000, 0x0517ffff, 0x00000a30, 0x7fff8000, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac2, 0x00000000, 0x0000003f, 0xffffffff, 0xffea3c92, 0xd1cbff41, 0xfffde38e, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac2, 0x0022cfdc, 0xc92af564, 0x0022cfdc, 0xc93dd308, 0x0ffe0000, 0xfed28005, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac1, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffcc86a7, 0x7ff0fff9, 0x006e7ff8, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac2, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x00000000, 0x8000e007, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac3, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00038000, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac1, 0x00000000, 0x00000006, 0xffffffff, 0xfff650a1, 0x0000ff65, 0xe007f001, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac1, 0x00000000, 0x00000000, 0xffffffff, 0xeffad4a8, 0x8000039c, 0xe01f05ba, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac2, 0xe0000000, 0x00000007, 0xe0000000, 0x0011ff48, 0x7fff001f, 0xffdc0005, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac2, 0xffffffff, 0xfff8fc05, 0xffffffff, 0xf50e7c05, 0x8000f432, 0xf5f98000, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac3, 0x00000000, 0x00000000, 0x00000000, 0x3fff8000, 0x8000c001, 0x7fff0000, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac1, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffff47f7, 0x038a1c71, 0x00340000, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac2, 0x00000000, 0x00000004, 0xffffffff, 0xfafb0509, 0x5555b6db, 0x0f0f0000, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac2, 0x00000000, 0x000000ff, 0xffffffff, 0xfce5bd96, 0xe00f7fff, 0x072907fe, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac2, 0xffffe980, 0xe7bdf8a9, 0xffffe980, 0xe7b95573, 0xfffed57b, 0x01abffe4, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac1, 0x00000000, 0x00000003, 0xffffffff, 0xc048d5cb, 0xc71c8000, 0x0102801f, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac2, 0xffffd806, 0x7a69a0e1, 0xffffd806, 0x93b24539, 0x8e3803fe, 0x38e30000, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac1, 0x1fffffff, 0xfffffff8, 0x1fffffff, 0xfff88007, 0x7fff0000, 0x000f8000, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac3, 0x7fffffff, 0xffffffff, 0x80000000, 0x3ff80004, 0xffff8000, 0x00057ff0, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac3, 0x00000000, 0x00000004, 0x00000000, 0x00270004, 0x004efffa, 0x80000000, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac2, 0x00000000, 0x00000000, 0x00000000, 0x7fff0000, 0x7fff7fff, 0x80008000, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac2, 0x00000000, 0x0000038e, 0xffffffff, 0xe4927401, 0xfffe9249, 0xe15ec001, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac0, 0x00000000, 0x00000000, 0x00000000, 0x000002a3, 0xfffeffd3, 0x0000000f, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac1, 0x3fffffff, 0xfffffffe, 0x3fffffff, 0xff133892, 0x7fff801f, 0x0007fe2d, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac3, 0x7fffffff, 0xffffff80, 0x80000000, 0x0ffbff80, 0x80008000, 0x1ff80000, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac0, 0x80000000, 0x00000000, 0x7fffffff, 0xc0802392, 0xfc7f8000, 0x24928000, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac2, 0xc71c71c7, 0x1c71c71c, 0xc71c71c7, 0x1bd048c9, 0x01ad8000, 0x7fff006a, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac2, 0x00000000, 0x00000000, 0x00000000, 0x0005b6e2, 0x00010ea1, 0x0002ff9c, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac0, 0x80000000, 0x0000007f, 0x80000000, 0x01604a6a, 0x0f0f8006, 0xe89b0000, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac2, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffdac984, 0x0000fe0f, 0x001fecd5, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac0, 0xfe8f757d, 0xbc23c059, 0xfe8f757d, 0xbc99405d, 0x00ef7fff, 0x80000004, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac3, 0xc0000000, 0x00000003, 0xc0000000, 0x00000003, 0x00000000, 0xffff803f, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac2, 0xfffff842, 0x21f53073, 0xfffff842, 0x21f53043, 0x0008ffd8, 0x00060000, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac2, 0xffffffff, 0xcf3d0f96, 0xffffffff, 0xcec97333, 0xe001fffd, 0xfc630000, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac0, 0x0000002f, 0x6519b10d, 0x0000002f, 0x617c5534, 0x073b0000, 0x7ffb08a9, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac0, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0xe38e03fe, 0x00000000, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac2, 0x03ffffff, 0xfffffffe, 0x04000000, 0x0ff7810e, 0xfff97ffd, 0xe945e00f, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac2, 0x80000000, 0x00000000, 0x80000000, 0x0007fff0, 0x7fff0000, 0xfff00ffe, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac0, 0x80000000, 0x00000000, 0x80000000, 0x2492b6da, 0x7fffb6db, 0xffff7fff, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac0, 0x00000000, 0x00088eaa, 0x00000000, 0x016c39e1, 0xfff10590, 0xffe9c00f, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac2, 0xffffffff, 0xffc379d5, 0xffffffff, 0xfac623b0, 0x7fffffff, 0x09fb1fe0, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac0, 0xfffffb14, 0xe7dadbeb, 0xfffffb14, 0xe7d5943a, 0x00068003, 0xf6a3fff5, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac0, 0x80000000, 0x00000000, 0x80000000, 0x00007fff, 0xfffffff9, 0x7fff0000, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac0, 0x3fffffff, 0xffffffe0, 0x40000000, 0x0002ffe0, 0x8000fff2, 0x00060000, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac3, 0xc0000000, 0x0000000f, 0xbfffffff, 0xc0010c0b, 0x00037fff, 0xfc017fff, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac1, 0x000079c9, 0xa8334575, 0x000079c9, 0xa83346e9, 0x0006fffd, 0xffc20000, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac1, 0x000c811b, 0x0911974d, 0x000c811b, 0x0911976b, 0xffee0006, 0x0000fffb, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac3, 0x7fffffff, 0xfffffffc, 0x7fffffff, 0xfffffffc, 0x00038007, 0x00000000, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac2, 0x80000000, 0x00000000, 0x7fffffff, 0xfffffff6, 0xf53bffff, 0x0000fff6, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac1, 0xffffffff, 0xffffff00, 0x00000000, 0x0001bef2, 0xe0010000, 0x000e0ffe, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac0, 0x3fffffff, 0xfffffff0, 0x3fffffff, 0xffffc80c, 0xeed00007, 0x000007fc, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac3, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xf0041ff7, 0x7fffc001, 0x1ff80000, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac3, 0xffffffff, 0xfffc19dd, 0xffffffff, 0xd0f6c108, 0xfffe9249, 0xfffe9249, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac1, 0x80000000, 0x00000000, 0x80000000, 0x0034c062, 0x9999da9a, 0xfff8017f, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac0, 0x00000000, 0x01d0ebf0, 0x00000000, 0x01ba6ca4, 0x8000002d, 0x00007ffc, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac1, 0x00000000, 0x00000000, 0xffffffff, 0xd639d38d, 0x138f3ffe, 0x7fff7fff, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac2, 0xf0000000, 0x00000003, 0xf0000000, 0x00000003, 0x7f808001, 0x00000000, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac1, 0x71c71c71, 0xc71c71c7, 0x71c71c71, 0xb470ac84, 0x00007ffb, 0xfca72559, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac2, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffd559, 0x80001c71, 0x00010006, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac0, 0xf8000000, 0x00000003, 0xf7ffffff, 0xfffd6dbf, 0x00000009, 0x80004924, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac3, 0xffffffff, 0xfe026710, 0xffffffff, 0xfe026710, 0x00000000, 0x001f07fc, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac0, 0xffffffff, 0xfffffffd, 0x00000000, 0x0006968d, 0xff220f0f, 0x0000ff90, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac3, 0xffff83a9, 0x59b3a217, 0xffff83a9, 0x59b3a217, 0x00010000, 0x00008000, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac1, 0xf0000000, 0x00000007, 0xf0000000, 0x000013dd, 0x7ffff615, 0x00000002, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac0, 0x00000007, 0x09568d12, 0x00000007, 0x3c8a0c93, 0x00016666, 0x807f8000, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac1, 0x000003d4, 0xebe18f2f, 0x000003d4, 0xebdd0fc9, 0x00000125, 0x800003ee, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac3, 0x80000000, 0x0000003f, 0x80000000, 0x31c71cb0, 0x80001c71, 0x7fff7fff, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac3, 0xfffa4621, 0xbeeb1105, 0xfffa4621, 0xbeeb0f90, 0x0007ffee, 0x0007ffee, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac1, 0x3fffffff, 0xffffffe0, 0x3fffffff, 0xc0017edf, 0x007f7fff, 0xff007fff, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac2, 0x00000000, 0x002c2f59, 0x00000000, 0x002b3b45, 0xfffcffff, 0xc2fb0000, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac2, 0xfffffc92, 0x522e8973, 0xfffffc92, 0x521e9b71, 0x0ffeffc0, 0x00ff0000, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac0, 0x00000000, 0x1b037b3e, 0x00000000, 0x1b037b3e, 0x00000000, 0x7fff7fff, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac2, 0xffffffff, 0xfffffff0, 0xffffffff, 0xfffc10a4, 0x003f0006, 0x0ffefff7, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac2, 0x000014dc, 0x582af822, 0x000014dc, 0x5815f837, 0xffe65555, 0x0000003f, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac0, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xfdf2fbe5, 0xfffff9d9, 0x0000aaaa, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac2, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xf8007fff, 0x0000f001, 0xc0038000, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac1, 0x0be5e487, 0x6003ca86, 0x0be5e487, 0x6003ca86, 0x00000000, 0xaaaafffe, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac0, 0x80000000, 0x00000000, 0x7fffffff, 0xffffc1bc, 0xfffb0000, 0xf38c8000, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac2, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xfebd83bf, 0x050f0000, 0x3fc0004c, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac3, 0x00000000, 0x00000000, 0xffffffff, 0xfff101be, 0x7fffc007, 0xfffeffc0, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac0, 0x000006ff, 0xe1cf2bdc, 0x000006ff, 0xe1cf64c7, 0x0007e38e, 0xffff0002, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac0, 0x80000000, 0x00000000, 0x7fffffff, 0xffce0ff8, 0xfffe8000, 0x07fcff9c, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac1, 0xffffffff, 0xfffd9364, 0xffffffff, 0xfffd7e9a, 0x0000f912, 0x8000fffd, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac0, 0xffffffff, 0xffdab1fd, 0xffffffff, 0xdffb11a5, 0x00047fff, 0xf8063fc0, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac1, 0xe0000000, 0x00000007, 0xdfffffff, 0xf3d2e6a5, 0xfff0aaaa, 0x3ff0db6d, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac2, 0x00000000, 0x000000ff, 0x00000000, 0x01bc7e46, 0x80010004, 0x0379ffd0, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac1, 0xf0000000, 0x00000007, 0xf0000000, 0x07fe732b, 0x0321f003, 0xffff7fff, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac1, 0x8e38e38e, 0x38e38e38, 0x8e38e38e, 0x38eb0dfc, 0x80040000, 0x000fff62, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac0, 0xe0000000, 0x0000000f, 0xe0000000, 0x099b4cdb, 0x7fff8000, 0xcccce003, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac1, 0x1fffffff, 0xfffffff8, 0x1fffffff, 0xfffffff8, 0x0040ffff, 0x00000000, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac0, 0xffffffff, 0xfffbba3f, 0x00000000, 0x0238a350, 0x0531c9ec, 0xffff0a98, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac2, 0x7fffffff, 0xfffffffd, 0x7fffffff, 0xe38e9999, 0xc71ccccc, 0x80000003, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac2, 0x00000000, 0x0000003f, 0xffffffff, 0xc004002c, 0xfffd7ff9, 0xfffc7fff, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac2, 0xffffffff, 0xfffff197, 0xffffffff, 0xffd5f1eb, 0x00540000, 0x7fffe38e, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7fff9999, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac1, 0xfffff32e, 0x7a61c863, 0xfffff32e, 0x7a61c863, 0x8000fff8, 0x00000000, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac0, 0x55555555, 0x55555555, 0x55555555, 0x94e35557, 0x8002ff1f, 0x7fff8000, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac1, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xfc003ffe, 0x0000e001, 0x0000e001, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac3, 0x80000000, 0x00000006, 0x80000000, 0x0603e106, 0x66660005, 0xf0f07fe0, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac2, 0x80000000, 0x00000000, 0x80000000, 0x000044ed, 0x000f0005, 0x001ff1da, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac2, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x800007fc, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac2, 0x00000000, 0x00000000, 0xffffffff, 0xc000ffff, 0x7fff0000, 0x7fff8000, 0x00010000, 0x00010000
	dspckacc_astio dps.w.ph, $ac3, 0x00003469, 0x77af6dfb, 0x00003469, 0x491f8dd3, 0x80001ff8, 0xc2d77ffb, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac2, 0xffff2669, 0x49620ddd, 0xffff2669, 0x62fbdaa9, 0xc03fcccc, 0x00007fff, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac3, 0x80000000, 0x00000000, 0x80000000, 0x01283b98, 0x00000ff8, 0xfff3ed73, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac2, 0x00000000, 0x000de46e, 0x00000000, 0x000e5072, 0x0000001f, 0xfffcfc84, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac1, 0x80000000, 0x00000005, 0x7fffffff, 0xf00b1997, 0xe007ffda, 0x80003333, 0x00000000, 0x00000000
	dspckacc_astio dps.w.ph, $ac1, 0x0fffffff, 0xfffffffe, 0x10000000, 0x004d6101, 0xf6d10000, 0x086d0014, 0x00010000, 0x00010000

	writemsg "[13] Test madd"
	dspck_astio madd, 0x000007ea, 0x1c572c4f, 0xffb0dd02, 0x1884e628, 0x0d3bfa1b, 0xfa049b1b, 0x0, 0x0
	dspck_astio madd, 0xe0000000, 0x00000001, 0xe0000000, 0x00000001, 0x00000000, 0x011bc658, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0xffff323b, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xffffffff, 0x8000113a, 0xb14ea013, 0x00114bec, 0x00ff00ff, 0x0, 0x0
	dspck_astio madd, 0xc71c71c7, 0x1c71c71c, 0xc71c71c7, 0x1c71c71c, 0xffffff80, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x00000033, 0xff8cd5d2, 0x55c87fb6, 0xfea68177, 0x55555555, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xffffffff, 0x7fffa807, 0x8000aff0, 0xffff500f, 0x7fffffff, 0x0, 0x0
	dspck_astio madd, 0x80000000, 0x00000000, 0x81c38c39, 0x64a2da2d, 0x33333333, 0x08d1bd1f, 0x0, 0x0
	dspck_astio madd, 0x55555555, 0x55555555, 0x5555558e, 0x65554e33, 0xfffff8de, 0xf8000001, 0x0, 0x0
	dspck_astio madd, 0xffffffff, 0xffff6498, 0xffffffff, 0xffff6498, 0x00000000, 0x3ffffff0, 0x0, 0x0
	dspck_astio madd, 0xffffffff, 0xfffffffe, 0xffffffff, 0xfffffffe, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0x6db6db6d, 0xb6db6db6, 0x6db6db6d, 0xb6db6db6, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x00000000, 0xffffffff, 0xfffffe1f, 0x0000000d, 0xffffffdb, 0x0, 0x0
	dspck_astio madd, 0x80000000, 0x00000000, 0x7fffffae, 0x580ad64b, 0xfffffc9f, 0x182a9ad5, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x00000000, 0xfffffff5, 0x800000a8, 0x7ffffff8, 0xffffffeb, 0x0, 0x0
	dspck_astio madd, 0xe38e38e3, 0x8e38e38e, 0xe38e38e3, 0x8e38e38e, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0xffdc7f4b, 0x15144627, 0xfaa30721, 0x4e8c6ff3, 0xdb6db6db, 0x24924924, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7fffffff, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x0000003b, 0x00000000, 0x0000003b, 0x00000000, 0x1ffffffe, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xfffffffa, 0x40000000, 0x7ffffffa, 0x7fffffff, 0x80000000, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xffffffff, 0x7c066337, 0x7fffffff, 0x80000000, 0x07f33991, 0x0, 0x0
	dspck_astio madd, 0x6db6db6d, 0xb6db6db6, 0x6db6db6a, 0xb6db6db6, 0x00000006, 0x80000000, 0x0, 0x0
	dspck_astio madd, 0x80000000, 0x00000000, 0x60000007, 0xbffffff1, 0x7fffffff, 0xc000000f, 0x0, 0x0
	dspck_astio madd, 0x1c71c71c, 0x71c71c71, 0x1c71c74a, 0x71c71c15, 0x7fffffff, 0x0000005c, 0x0, 0x0
	dspck_astio madd, 0xffffffff, 0xfffffff9, 0x00000000, 0x000675b9, 0xffffb140, 0xffffffeb, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x00000000, 0xc0000000, 0x80000000, 0x7fffffff, 0x80000000, 0x0, 0x0
	dspck_astio madd, 0x07ffffff, 0xfffffffe, 0x071ac183, 0x81ca7cf7, 0xfe358307, 0x7fffffff, 0x0, 0x0
	dspck_astio madd, 0x000017d3, 0x9e7cda6b, 0x000017d3, 0x9e760aca, 0xffffffff, 0x0006cfa1, 0x0, 0x0
	dspck_astio madd, 0x3fffffff, 0xfffffff8, 0x3fffffff, 0x00000006, 0xfffffffe, 0x7ffffff9, 0x0, 0x0
	dspck_astio madd, 0x80000000, 0x00000000, 0x7f1072c1, 0x1df1a7e0, 0xfe20e582, 0x7ffffff0, 0x0, 0x0
	dspck_astio madd, 0xfc000000, 0x00000001, 0xfc000000, 0x0002c99f, 0x000032f9, 0x0000000e, 0x0, 0x0
	dspck_astio madd, 0xffffffff, 0xfffffffc, 0x00000320, 0xfffff9ba, 0x00000642, 0x7fffffff, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x0000007f, 0x33333333, 0x8000007f, 0x99999999, 0x80000000, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xffffff80, 0x8000003f, 0xfffffc00, 0xffffff80, 0x80000007, 0x0, 0x0
	dspck_astio madd, 0x06508b03, 0xae37a5e3, 0x06508b03, 0xae37a529, 0x0000001f, 0xfffffffa, 0x0, 0x0
	dspck_astio madd, 0x00125566, 0xabd5de14, 0x00f907a0, 0x65656278, 0xfcd89036, 0xb6db6db6, 0x0, 0x0
	dspck_astio madd, 0xf8000000, 0x00000001, 0xf6000000, 0x97fffffb, 0x7ffffffa, 0xfc000001, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xffffffff, 0x7fa40281, 0x044fe1f3, 0x016ff5fc, 0xc0000003, 0x0, 0x0
	dspck_astio madd, 0x66666666, 0x66666666, 0x5e666667, 0x66666666, 0x80000000, 0x0ffffffe, 0x0, 0x0
	dspck_astio madd, 0x80000000, 0x00000000, 0x80000016, 0x7fffe980, 0x7fffff80, 0x0000002d, 0x0, 0x0
	dspck_astio madd, 0x38e38e38, 0xe38e38e3, 0x38e38e38, 0xe38e38e3, 0x00ff00ff, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x99999999, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0xfffffb7b, 0x75082318, 0x0002e5d8, 0x74fc79a4, 0x24924924, 0x0014688b, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xffffffff, 0x7ffd7ffd, 0x009b00b9, 0x8000001f, 0x00050006, 0x0, 0x0
	dspck_astio madd, 0xe072cc5d, 0xb8b90a85, 0xe072cc5d, 0xb8b9ba03, 0xffffa841, 0xfffffffe, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x00000000, 0x000000d7, 0x3fc4c79c, 0xfffb83d7, 0xffd001c4, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x0000003a, 0xffffbc43, 0x8000003a, 0x00008779, 0x80000000, 0x0, 0x0
	dspck_astio madd, 0x92492492, 0x49249249, 0xd2492492, 0x49249249, 0x80000000, 0x80000000, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x00000007, 0x00000000, 0x00000007, 0x00000000, 0x1c71c71c, 0x0, 0x0
	dspck_astio madd, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0xffffe6ab, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x00000000, 0x0000004f, 0xaaaaaa5b, 0x000000ef, 0x55555555, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x33053ce3, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0x92492492, 0x49249249, 0x92492482, 0xa36ac2e2, 0x000d1d3d, 0xfffece8d, 0x0, 0x0
	dspck_astio madd, 0xe0000000, 0x00000003, 0xdfffffff, 0xfffe0005, 0x0000ffff, 0xfffffffe, 0x0, 0x0
	dspck_astio madd, 0x1c71c71c, 0x71c71c71, 0xdc71c71f, 0x71c71c6c, 0x7fffffff, 0x80000005, 0x0, 0x0
	dspck_astio madd, 0xffffffff, 0xfe46c589, 0x1ffffff7, 0x3e46c5b9, 0x3ffffff0, 0x7ffffffd, 0x0, 0x0
	dspck_astio madd, 0x07ffffff, 0xfffffffe, 0x07fffb9d, 0x800008c3, 0x80000001, 0x000008c5, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x0001e522, 0xfffffec4, 0x8001e799, 0x7fffffff, 0xfffffd89, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xffffffff, 0x70000000, 0xffffffff, 0x1ffffffe, 0x80000000, 0x0, 0x0
	dspck_astio madd, 0xcccccccc, 0xcccccccc, 0xcccd8069, 0xedb78d54, 0xff81eaa8, 0xfe934fcd, 0x0, 0x0
	dspck_astio madd, 0xffffffff, 0xfffffffc, 0xf0000000, 0xfffffffc, 0x1ffffffe, 0x80000000, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xffffffff, 0x6d097b42, 0x684bda12, 0x55555555, 0xc71c71c7, 0x0, 0x0
	dspck_astio madd, 0x1fffffff, 0xfffffffe, 0x1fffffff, 0xfffffffe, 0x00000000, 0xfffff8a8, 0x0, 0x0
	dspck_astio madd, 0x00000003, 0xbb182077, 0x00000003, 0x9b18207b, 0xfffffffe, 0x0ffffffe, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x00000000, 0xf0000001, 0x00000000, 0x1ffffffe, 0x80000000, 0x0, 0x0
	dspck_astio madd, 0xfffff0b5, 0xb030a647, 0xfffff0bd, 0x77696d78, 0x00ff00ff, 0x000007cf, 0x0, 0x0
	dspck_astio madd, 0x000b43e4, 0xbf1579a0, 0x000b43e4, 0xbf1579a0, 0x00000000, 0x80000000, 0x0, 0x0
	dspck_astio madd, 0xffffffff, 0xf7e01642, 0xc0000007, 0xf7e01633, 0x8000000f, 0x7fffffff, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x00000004, 0x00000000, 0x00000004, 0x00000000, 0x7fffffff, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x00000000, 0x00000377, 0xfffffe44, 0x49249249, 0x00000c24, 0x0, 0x0
	dspck_astio madd, 0x00000510, 0xd61702cf, 0x40000510, 0xd61702cf, 0x80000000, 0x80000000, 0x0, 0x0
	dspck_astio madd, 0xffffffff, 0xff0f4741, 0xffffffff, 0xff0f4741, 0xc0000007, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0x55555555, 0x55555555, 0x555555ab, 0xe2bc4ce3, 0xffff5393, 0xff7f7efa, 0x0, 0x0
	dspck_astio madd, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0xc0000003, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x00000000, 0x0000000f, 0xfffffc40, 0xc000000f, 0xffffffc0, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x55555555, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xffffffff, 0xbfffffdf, 0x8000003f, 0x7fffffff, 0x7fffffc0, 0x0, 0x0
	dspck_astio madd, 0x1fffffff, 0xfffffff0, 0x1fffffff, 0xfffffff0, 0x00000000, 0x80000000, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x3ffffff8, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x00d979c9, 0x0000000e, 0x80d97972, 0xffffffe3, 0x80000003, 0x0, 0x0
	dspck_astio madd, 0x66666666, 0x66666666, 0x66666666, 0x25c416af, 0xfffd7135, 0x00001945, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x00000de7, 0x00000000, 0x00000de7, 0x80000000, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xffffffe0, 0x40000000, 0x7fffffe0, 0x80000000, 0x7fffffff, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x00000000, 0x00b2f56e, 0x74d0a918, 0x0165eadd, 0x7ffffff8, 0x0, 0x0
	dspck_astio madd, 0xffffffff, 0xfffffffe, 0xff86e7b4, 0xfffffffe, 0x80000000, 0x00f23096, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xffffffff, 0x7fffffcc, 0x00000067, 0x7fffffff, 0xffffff98, 0x0, 0x0
	dspck_astio madd, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x00000000, 0xe000000f, 0x0, 0x0
	dspck_astio madd, 0xffffffff, 0xffffffc0, 0x00000000, 0x000264d6, 0xfffffff6, 0xffffc2b1, 0x0, 0x0
	dspck_astio madd, 0x80000000, 0x00000006, 0x80000000, 0x7fffff87, 0x8000007f, 0xffffffff, 0x0, 0x0
	dspck_astio madd, 0xe0000000, 0x00000003, 0xe0000000, 0x00000003, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0xffffffff, 0xfff9dd70, 0x000013e3, 0x6db097b8, 0x00002e68, 0x6db6db6d, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffc337e0, 0x0, 0x0
	dspck_astio madd, 0xffffff8a, 0xb1dbee92, 0x14e5e031, 0xcbfb4763, 0x49249249, 0x49249249, 0x0, 0x0
	dspck_astio madd, 0x80000000, 0x00000000, 0x80189cfa, 0x00000000, 0x80000000, 0xffcec60c, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x0000001f, 0xfffff1d0, 0x9001c60d, 0x0001c5ee, 0xf8000001, 0x0, 0x0
	dspck_astio madd, 0x3fffffff, 0xfffffff8, 0x31c71c72, 0x51c71c69, 0x71c71c71, 0xe0000001, 0x0, 0x0
	dspck_astio madd, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0xf0000001, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0x66666666, 0x66666666, 0x6665175d, 0xa7037280, 0xe000000f, 0x000a7846, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xffffff80, 0x40000000, 0x7fffff80, 0x7fffffff, 0x80000000, 0x0, 0x0
	dspck_astio madd, 0xffed92d5, 0x26c0d3b4, 0xffed92d7, 0x26c0d3a4, 0xfffffffc, 0x80000004, 0x0, 0x0
	dspck_astio madd, 0xb6db6db6, 0xdb6db6db, 0xb5fd1671, 0x56ce710c, 0xf8000003, 0x1bcae8bb, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xffffffff, 0x7ffd67f5, 0x20914260, 0x0014c057, 0xe0000007, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xfffffff0, 0x80000000, 0x00000ef4, 0xffffffc2, 0xffffffc2, 0x0, 0x0
	dspck_astio madd, 0xffffffff, 0xffffd836, 0xffffffff, 0xffffd836, 0x00000000, 0x80000000, 0x0, 0x0
	dspck_astio madd, 0xffffffff, 0xfffffffb, 0xffffffff, 0xfffffffb, 0x00000000, 0x80000000, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000b35, 0x0, 0x0
	dspck_astio madd, 0x80000000, 0x00000000, 0x80000000, 0x10495344, 0x00004092, 0x00004092, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x0dea8be3, 0xf64221a7, 0x485dc1f9, 0x80000003, 0x137bbcb2, 0x0, 0x0
	dspck_astio madd, 0x80000000, 0x00000000, 0x80000000, 0x0003b4f0, 0xfffc4b10, 0xffffffff, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xfffffffb, 0x7fffffff, 0xfffffffb, 0x7ffffff0, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xffffffff, 0x7ffffff9, 0x9999999f, 0x66666666, 0xfffffff0, 0x0, 0x0
	dspck_astio madd, 0xffffffff, 0xfffffe35, 0xffffffff, 0xfffffe35, 0x0000000f, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xffffffff, 0x40000002, 0xfffffffa, 0x80000005, 0x7fffffff, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x20131c81, 0xf0000007, 0xc0131c72, 0x7fffffff, 0xe000000f, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x7fffffc0, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0xfffffffe, 0xb91de955, 0xfda564af, 0xd55d3109, 0x04b5369e, 0x80000006, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xc0000007, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x0000000f, 0x00000000, 0x0000000f, 0x80000006, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xffffffff, 0x83c3c3c3, 0x9696968f, 0xc0000007, 0xf0f0f0f0, 0x0, 0x0
	dspck_astio madd, 0x80000000, 0x00000002, 0x80000000, 0x00000002, 0x00000000, 0x7fffffff, 0x0, 0x0
	dspck_astio madd, 0xfffba51e, 0xa536ddaa, 0xfffba51e, 0xa536ddaa, 0x00000000, 0x0001fe81, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x7122641e, 0xe0000009, 0xf12263a6, 0x7ffffff8, 0xc000000f, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffc0, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x0000000f, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xffffffff, 0x7fffffd2, 0x800001c6, 0xffffffa5, 0x7ffffffb, 0x0, 0x0
	dspck_astio madd, 0x80000000, 0x00000000, 0x7fee5e4e, 0x15fdf021, 0xf85292d9, 0x024bea89, 0x0, 0x0
	dspck_astio madd, 0x000413bb, 0xafb8c6ab, 0xfc0413bd, 0x2fb8c68b, 0xf8000001, 0x7fffffe0, 0x0, 0x0
	dspck_astio madd, 0xffffffff, 0xffffffe0, 0xffa48a28, 0x48038e52, 0xf0000007, 0x05b75d7e, 0x0, 0x0
	dspck_astio madd, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x03fffffe, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00082bdd, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xffffffff, 0x7fffffff, 0x80000000, 0x7fffffff, 0xffffffff, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x000495dd, 0xff33514e, 0xaa48e92f, 0x01cc890f, 0x8e38e38e, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x027ea0a2, 0x40000000, 0x027ea0a2, 0x80000000, 0x80000000, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xffffffff, 0x80000002, 0x7ffffffa, 0x00000005, 0x7fffffff, 0x0, 0x0
	dspck_astio madd, 0x80000000, 0x00000000, 0xbfffffff, 0x00000001, 0x7fffffff, 0x7fffffff, 0x0, 0x0
	dspck_astio madd, 0x80000000, 0x00000000, 0x80000000, 0x000346f7, 0xfffffffb, 0xffff5835, 0x0, 0x0
	dspck_astio madd, 0x0001d19f, 0x20a5fa03, 0x0001bb81, 0xa0a5fa03, 0x80000000, 0x00002c3b, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x00075530, 0x3fffffff, 0x00075531, 0x7fffffff, 0x7fffffff, 0x0, 0x0
	dspck_astio madd, 0xffff1b9a, 0xdbaf3253, 0x0786a322, 0xdbaf3253, 0x80000000, 0xf0f0f0f0, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x00000007, 0x3fffff80, 0x00004007, 0x7fffff80, 0x7fffff80, 0x0, 0x0
	dspck_astio madd, 0xffffffff, 0xff594f8c, 0xffffffff, 0xff595772, 0x00000006, 0x00000151, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xffffffff, 0x7e000000, 0x83fffffe, 0x7fffffff, 0xfc000001, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x00000001, 0x00000000, 0x003aeaea, 0x000007ad, 0x000007ad, 0x0, 0x0
	dspck_astio madd, 0xffffffff, 0xfffffffb, 0xfd3751a3, 0x05915cb5, 0x7fffffff, 0xfa6ea346, 0x0, 0x0
	dspck_astio madd, 0xffffffff, 0xfffffede, 0xffffffda, 0x7ffffede, 0x0000004b, 0x80000000, 0x0, 0x0
	dspck_astio madd, 0xfffffffd, 0xf69575c2, 0xfffffffe, 0x674ff42a, 0x00000007, 0x101aa458, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x0014939f, 0x00000000, 0x0014939f, 0x80000000, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0xfffffffd, 0x9e51cf8b, 0xffffffff, 0x9e51cf87, 0x00000004, 0x7fffffff, 0x0, 0x0
	dspck_astio madd, 0xc0000000, 0x00000003, 0xc0000000, 0x00000003, 0x00000000, 0xffffd631, 0x0, 0x0
	dspck_astio madd, 0xf0000000, 0x00000001, 0xe8000000, 0x90000000, 0xf0000001, 0x7fffffff, 0x0, 0x0
	dspck_astio madd, 0x80000000, 0x00000003, 0x80000000, 0x00000003, 0x00000000, 0x3fffffe0, 0x0, 0x0
	dspck_astio madd, 0x0003252e, 0xb69f700c, 0xffcf1701, 0x369f700c, 0x80000000, 0x00681c5b, 0x0, 0x0
	dspck_astio madd, 0xfc000000, 0x00000001, 0xfc000000, 0x03a4590f, 0x00001086, 0x0000386d, 0x0, 0x0
	dspck_astio madd, 0xffffffff, 0xfff9d117, 0xfffff3d2, 0xfff9d117, 0x80000000, 0x0000185a, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x000c90be, 0x03fffffe, 0x800c90be, 0xf8000003, 0x80000000, 0x0, 0x0
	dspck_astio madd, 0xc71c71c7, 0x1c71c71c, 0xc71c71c7, 0x1c71c71c, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0x1fffffff, 0xfffffffe, 0x2ffffff7, 0xe0000049, 0x80000005, 0xe000000f, 0x0, 0x0
	dspck_astio madd, 0xffffffff, 0xffffff7a, 0x00000000, 0x0147c9ba, 0xffeb835c, 0xfffffff0, 0x0, 0x0
	dspck_astio madd, 0x07ffffff, 0xfffffffc, 0xc8000000, 0x7ffffffc, 0x7fffffff, 0x80000000, 0x0, 0x0
	dspck_astio madd, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0xfffffffc, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0x00000022, 0xfb3ca75c, 0x00000022, 0xfb3ca76c, 0xfffffffc, 0xfffffffc, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x00000000, 0xfee5d86b, 0x0, 0x0
	dspck_astio madd, 0xdb6db6db, 0x6db6db6d, 0xdb6db6dd, 0x6db6db69, 0x7fffffff, 0x00000004, 0x0, 0x0
	dspck_astio madd, 0x0000d2c7, 0x86b4a129, 0x0400d2c5, 0x96b4a13e, 0xc0000003, 0xf0000007, 0x0, 0x0
	dspck_astio madd, 0x0c51f874, 0xb4db6b7a, 0x0c51f874, 0xb4db6b7a, 0x00000000, 0xffffffe7, 0x0, 0x0
	dspck_astio madd, 0xffff0000, 0xffff0000, 0xffff0000, 0xffff0000, 0x07fffffc, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x00000000, 0x3fffffe0, 0x0, 0x0
	dspck_astio madd, 0x8e38e38e, 0x38e38e38, 0x8e38e38e, 0x38e38e38, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0xffffffff, 0xffffffe0, 0xffffffff, 0xff45a550, 0x00000008, 0xffe8b4ae, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x80000000, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0xffffffea, 0xf73d2fb4, 0xffffffea, 0xf73d1bcc, 0xffffffc8, 0x0000005b, 0x0, 0x0
	dspck_astio madd, 0xffffffeb, 0x762f3464, 0xffffffec, 0xf62f3464, 0xfffffffd, 0x80000000, 0x0, 0x0
	dspck_astio madd, 0x0000ffff, 0x0000ffff, 0xe001000f, 0x0000ffff, 0x3fffffe0, 0x80000000, 0x0, 0x0
	dspck_astio madd, 0xff00ff00, 0xff00ff00, 0xff026364, 0xff00ff00, 0x80000000, 0xfffd3738, 0x0, 0x0
	dspck_astio madd, 0xffffffce, 0xc7ddbb22, 0xffffffce, 0xc7ddbb46, 0x00000003, 0x0000000c, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x000006ca, 0x00000000, 0x000006ca, 0xfda11f82, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xffffffff, 0x80001003, 0xffffffff, 0x80000000, 0xffffdff8, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x001379ca, 0xfffffff0, 0x001379ea, 0x7fffffff, 0xffffffe0, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x00000005, 0x3fffffff, 0x00000006, 0x7fffffff, 0x7fffffff, 0x0, 0x0
	dspck_astio madd, 0xcccccccc, 0xcccccccc, 0xcccccd3b, 0x4ccccccc, 0xffffff23, 0x80000000, 0x0, 0x0
	dspck_astio madd, 0xffffffff, 0xfffffffb, 0x00000000, 0x17fffff5, 0x07fffffe, 0x00000003, 0x0, 0x0
	dspck_astio madd, 0x0020d5bf, 0xfe09927b, 0x001d41ff, 0xbf72ee88, 0x14f7a245, 0xffd45329, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x00000000, 0xffffffff, 0xfffffa4a, 0x000002db, 0xfffffffe, 0x0, 0x0
	dspck_astio madd, 0xffffffff, 0xfffffffe, 0xfff00ff0, 0x03fc03fe, 0xff00ff00, 0x0ffffffc, 0x0, 0x0
	dspck_astio madd, 0x80000000, 0x00000000, 0x82830e7e, 0xaf9e3020, 0x7ffffff0, 0x05061cfe, 0x0, 0x0
	dspck_astio madd, 0x80000000, 0x00000005, 0x7fffffff, 0xfffa1e9d, 0xfffffffc, 0x0001785a, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x00000000, 0xfffdda1c, 0x00000000, 0x80000000, 0x00044bc8, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x00000000, 0x7fffffff, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xffffffff, 0x7fffea89, 0x26f1b437, 0x0005e9fc, 0xfc5edff2, 0x0, 0x0
	dspck_astio madd, 0x0072e0a3, 0x0d292f53, 0x0072e0a3, 0x0d292f53, 0x80000001, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0x8e38e38e, 0x38e38e38, 0x8e386b90, 0xb8ea1e15, 0x80000007, 0x0000effb, 0x0, 0x0
	dspck_astio madd, 0x00000001, 0xc69d20d5, 0xffffffe1, 0xc69d2115, 0x7fffffff, 0xffffffc0, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x00000000, 0x00000149, 0xffffedf4, 0xfffffd6c, 0x80000007, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x80000000, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0xffffffff, 0xfffffd7f, 0x00000000, 0x03c47df7, 0xfffffffc, 0xff0edfe2, 0x0, 0x0
	dspck_astio madd, 0x80000000, 0x0000003f, 0x80000000, 0x0000003f, 0x00000000, 0xb6db6db6, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x00000000, 0xffffffff, 0x37f33ab0, 0x0e4a0e18, 0xfffffff2, 0x0, 0x0
	dspck_astio madd, 0xffffffff, 0xfffe9300, 0xffffffff, 0xfffe9300, 0x00000000, 0x80000000, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x00000000, 0x40000000, 0x00000000, 0x80000000, 0x80000000, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0xffff6db5, 0x2e962822, 0xffff6db4, 0xe57195d8, 0xdb6db6db, 0x00000002, 0x0, 0x0
	dspck_astio madd, 0x80000000, 0x00000000, 0x7f5df778, 0x8a5368d4, 0xf65bcb0a, 0x10ce51e2, 0x0, 0x0
	dspck_astio madd, 0xffffffff, 0xfffffbf0, 0x0000001d, 0x1ffff84c, 0x000000e9, 0x1ffffffc, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xffffffff, 0x60000001, 0xffffffff, 0x80000000, 0x3ffffffc, 0x0, 0x0
	dspck_astio madd, 0xffffffff, 0xffff4ba1, 0xffffffff, 0xffff4ba1, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0x80000000, 0x00000000, 0x800038fa, 0xc9810771, 0x0078c699, 0x0078c699, 0x0, 0x0
	dspck_astio madd, 0x80000000, 0x00000003, 0x40000000, 0x80000003, 0x7fffffff, 0x80000000, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x0000003f, 0xffc00000, 0x1800003d, 0xf8000001, 0x07fffffe, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffcde4dd, 0x0, 0x0
	dspck_astio madd, 0x80000000, 0x00000001, 0x7fffffff, 0xfffec3a5, 0x00001a5d, 0xfffffff4, 0x0, 0x0
	dspck_astio madd, 0xffffffff, 0xffe8df2a, 0xffffffff, 0xbfe8df2d, 0xc0000003, 0x00000001, 0x0, 0x0
	dspck_astio madd, 0xffffc084, 0xa9d71250, 0x3fffc083, 0xa9d71251, 0x7fffffff, 0x7fffffff, 0x0, 0x0
	dspck_astio madd, 0x00621952, 0x74f665b4, 0xc0621952, 0xf4f665b4, 0x7fffffff, 0x80000000, 0x0, 0x0
	dspck_astio madd, 0xef52071c, 0xa6229407, 0xef52072b, 0xa6229353, 0x80000006, 0xffffffe2, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xffffffff, 0x7ffca15a, 0xb6e8e84b, 0xffe8697b, 0x24924924, 0x0, 0x0
	dspck_astio madd, 0xe0000000, 0x00000007, 0xe0000000, 0x014d9d93, 0x00000016, 0x000f2a12, 0x0, 0x0
	dspck_astio madd, 0x92492492, 0x49249249, 0x925914a2, 0x3726904b, 0x0ffffffe, 0x00ff00ff, 0x0, 0x0
	dspck_astio madd, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x00000000, 0x3ffffffe, 0x00000003, 0x7ffffffd, 0x7fffffff, 0x0, 0x0
	dspck_astio madd, 0x80000000, 0x00000000, 0x7fff1876, 0x00000000, 0x0001cf14, 0x80000000, 0x0, 0x0
	dspck_astio madd, 0x24924924, 0x92492492, 0x24924924, 0x91d7ac8b, 0x0016b19b, 0xfffffffb, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x00000002, 0x00000000, 0x00000002, 0xffffff80, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xfffffffe, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0x1c71c71c, 0x71c71c71, 0x1c71c71c, 0x71c71c71, 0x3fffffe0, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x00000000, 0x00000000, 0x000099f4, 0xffffff59, 0xffffff14, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x000be722, 0xc71c71c7, 0x71d30394, 0x8e38e38e, 0x7fffffff, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xff8507a5, 0x00000005, 0xffe767ee, 0x0, 0x0
	dspck_astio madd, 0x07ffffff, 0xfffffffc, 0x07fffffe, 0x38e38e34, 0x8e38e38e, 0x00000004, 0x0, 0x0
	dspck_astio madd, 0xffffffe4, 0x21d6a4a1, 0xffffffe2, 0x6453f3c1, 0xe24c9ee0, 0x0000000f, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0xffffffff, 0x8107de84, 0xfffffffe, 0x0107de84, 0x80000000, 0x00000003, 0x0, 0x0
	dspck_astio madd, 0xffffffff, 0xfffffffe, 0xffffffff, 0xfffffffe, 0x00000000, 0xffa16359, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x15317c20, 0x00000000, 0x15317c20, 0xffffffcc, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0xfffffffb, 0xd6451027, 0xfffffffb, 0xd63833bb, 0xfffffeb1, 0x000009d4, 0x0, 0x0
	dspck_astio madd, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0xf0000000, 0x00000007, 0xf3ffffff, 0x80000007, 0xf8000001, 0x80000000, 0x0, 0x0
	dspck_astio madd, 0x00000000, 0x00004990, 0xf8e38e3a, 0x871cbb60, 0xe38e38e3, 0x3ffffff0, 0x0, 0x0
	dspck_astio madd, 0xffffffff, 0xf98ad94d, 0x000002be, 0xf98ad94d, 0xfffffa82, 0x80000000, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xfffffffc, 0x80000000, 0x7fffffec, 0x7ffffff0, 0x00000001, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xfffffff8, 0x800033b9, 0xb7f26246, 0x07ec3057, 0x00068762, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xffffffff, 0xaaaaaaaa, 0x2aaaaaaa, 0x55555555, 0x7fffffff, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xffffffff, 0xbfffffff, 0x00000000, 0x7fffffff, 0x7fffffff, 0x0, 0x0
	dspck_astio madd, 0xe38e38e3, 0x8e38e38e, 0xe38e38e3, 0x8e38e38e, 0x00000000, 0x80000000, 0x0, 0x0
	dspck_astio madd, 0x00000c9f, 0x004e5a07, 0x00000c9f, 0x004e5a07, 0x0000007f, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0xffffffff, 0xffffffc0, 0xffffffff, 0xffffffc0, 0x00000018, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0x7fffffff, 0xffffffff, 0x77733209, 0x7fffffff, 0x80000000, 0x11199bed, 0x0, 0x0
	dspck_astio madd, 0x0002cb5c, 0x75ecc27a, 0x0002cb5c, 0x75ecc27a, 0xffff4350, 0x00000000, 0x0, 0x0
	dspck_astio madd, 0x80000000, 0x00000004, 0x80000016, 0xbfffff4e, 0x3ffffffe, 0x0000005b, 0x0, 0x0

	writemsg "[14] Test maddu"
	dspck_astio maddu, 0x7fffffff, 0xffffffff, 0x8f0f0f0e, 0xa5a5a5a5, 0xfffffffa, 0x0f0f0f0f, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000000, 0xfffffffd, 0x00000000, 0xfffffffa, 0x80000000, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000000, 0x80000000, 0x00000002, 0x00000002, 0x00000001, 0x0, 0x0
	dspck_astio maddu, 0x8e38e38e, 0x38e38e38, 0x8e38e390, 0x78e38e4d, 0xc0000007, 0x00000003, 0x0, 0x0
	dspck_astio maddu, 0xffffffff, 0xf485f7e8, 0x7fffffdf, 0xf485f7e8, 0x80000000, 0xffffffc0, 0x0, 0x0
	dspck_astio maddu, 0xffffc602, 0x0bedd4a3, 0x7ff8ae5c, 0x0bedd4a3, 0x80000000, 0xfff1d0b4, 0x0, 0x0
	dspck_astio maddu, 0xffffffff, 0xffffff80, 0x012825e2, 0xba0c5d48, 0xffff2bfb, 0x012826d8, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00000000, 0x0000384b, 0xffff1ed0, 0xfffffffc, 0x0000384c, 0x0, 0x0
	dspck_astio maddu, 0xfff8169f, 0xd52b1bbf, 0x7ff7c679, 0xd52bbc09, 0xffff5fb6, 0x7fffffff, 0x0, 0x0
	dspck_astio maddu, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x7ffffff9, 0x00000000, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000000, 0x80000081, 0x6217888b, 0x03903d05, 0x0000244f, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00000000, 0x1c71c71c, 0x00000000, 0x80000000, 0x38e38e38, 0x0, 0x0
	dspck_astio maddu, 0x7fffffff, 0xfffffff9, 0xfffffd75, 0x00001431, 0x7ffffffc, 0xfffffaf2, 0x0, 0x0
	dspck_astio maddu, 0x7fffffff, 0xffffffc0, 0x7fffffff, 0xffffffc0, 0x00000000, 0x0c36d40c, 0x0, 0x0
	dspck_astio maddu, 0xffffffff, 0xfffffff8, 0x3ffffffe, 0xfffffff9, 0x7fffffff, 0x7fffffff, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00000000, 0xb5a134d9, 0x722c4676, 0xf22c4676, 0xc0000001, 0x0, 0x0
	dspck_astio maddu, 0xffffffff, 0xffc5d149, 0x000c12ec, 0xffa19882, 0xfffffffd, 0x000c12ed, 0x0, 0x0
	dspck_astio maddu, 0x00670513, 0x80ef3917, 0xf7f447fb, 0x27f9179d, 0xf85cca0f, 0xff2a171a, 0x0, 0x0
	dspck_astio maddu, 0xffffffff, 0xffffffff, 0x00000003, 0xfffffde3, 0xffffff79, 0x00000004, 0x0, 0x0
	dspck_astio maddu, 0x000027ee, 0x118f3a31, 0xfffc0af4, 0x119b9116, 0xfffbe309, 0xfffffffd, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0xb165aeb7, 0x0294ce7a, 0x9cb44f99, 0x02e9dd71, 0xe2ce4602, 0x0, 0x0
	dspck_astio maddu, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x00000000, 0x7fffffff, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00000006, 0x4000003e, 0xffffff87, 0x8000007f, 0x7fffffff, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000002, 0x80000000, 0x00000002, 0x00000000, 0x00000057, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00053916, 0xffc402d5, 0x01e5222e, 0xfffffff8, 0xffc402dd, 0x0, 0x0
	dspck_astio maddu, 0xffffffff, 0xfffffffe, 0x0000001f, 0x24924913, 0x0000006d, 0x49249249, 0x0, 0x0
	dspck_astio maddu, 0xfffffdaf, 0xac101bf3, 0xbffffdad, 0x6c101bde, 0xfffffff9, 0xc0000003, 0x0, 0x0
	dspck_astio maddu, 0xffffffff, 0xfffff5d7, 0x67ddd503, 0xb0444bce, 0x7fffffff, 0xcfbbaa09, 0x0, 0x0
	dspck_astio maddu, 0x7fffffff, 0xffffffff, 0xfe000000, 0x7fffffff, 0xfc000001, 0x80000000, 0x0, 0x0
	dspck_astio maddu, 0x007cf5fa, 0x1dc4965b, 0x047cf5f9, 0x1dc4966b, 0x1ffffffc, 0x1ffffffc, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_astio maddu, 0x55555555, 0x55555555, 0x55724881, 0x53f9ef45, 0x0039e658, 0x7ffffffa, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x09e7be3a, 0x37ffffe4, 0xc9e7bdda, 0xe0000003, 0x3fffffe0, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xfffffffe, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x00000000, 0x7fffffff, 0x0, 0x0
	dspck_astio maddu, 0x000001fe, 0xef21c306, 0x800001f6, 0x6f21c30e, 0xffffffff, 0x7ffffff8, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00000063, 0x3fffffff, 0x80000063, 0x80000000, 0x7fffffff, 0x0, 0x0
	dspck_astio maddu, 0x0fffffff, 0xfffffffe, 0x10000000, 0xefffff86, 0x0ffffff8, 0x0000000f, 0x0, 0x0
	dspck_astio maddu, 0x92492492, 0x49249249, 0x92492492, 0x49249249, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_astio maddu, 0x1fffffff, 0xfffffff0, 0x5fffffff, 0xfffffff0, 0x80000000, 0x80000000, 0x0, 0x0
	dspck_astio maddu, 0x7fffffff, 0xfffffffd, 0x7fffffff, 0xfffffffd, 0x00000006, 0x00000000, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x0000001f, 0xbffffffe, 0x80000021, 0x7ffffffe, 0x7fffffff, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00000000, 0x999989af, 0x9999a983, 0x99999999, 0xffffe57b, 0x0, 0x0
	dspck_astio maddu, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xfffedf3f, 0x00000000, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000000, 0x800007ff, 0xf7fe0002, 0x0000ffff, 0x07fffffe, 0x0, 0x0
	dspck_astio maddu, 0xfc000000, 0x00000001, 0x7be65c19, 0x003347cd, 0xffccb834, 0x7fffffff, 0x0, 0x0
	dspck_astio maddu, 0xffffff91, 0x4b79b6c1, 0x1fffff8b, 0x2b79b705, 0xffffffef, 0x1ffffffc, 0x0, 0x0
	dspck_astio maddu, 0xffffffff, 0xffffffe0, 0x7ffe4028, 0x800dfe7c, 0xfffc8059, 0x7ffffffc, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00000000, 0x03ab636c, 0x6b5d12dc, 0xf8000003, 0x03c9b0f4, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x001558b0, 0x3fffffff, 0x001558b1, 0x7fffffff, 0x7fffffff, 0x0, 0x0
	dspck_astio maddu, 0x7fffffff, 0xffffffff, 0xffffc57f, 0x000074ff, 0x7fffffff, 0xffff8b00, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_astio maddu, 0x55555555, 0x55555555, 0x55555555, 0x5555558d, 0x00000002, 0x0000001c, 0x0, 0x0
	dspck_astio maddu, 0xfffffeef, 0x6427edf8, 0xfffffeef, 0x6427edf8, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_astio maddu, 0x0000001f, 0x4fe76e2a, 0x0000001f, 0x4fe76e2a, 0x00001306, 0x00000000, 0x0, 0x0
	dspck_astio maddu, 0xffffffff, 0xfe171397, 0xffffffff, 0xfe171397, 0xfffffffd, 0x00000000, 0x0, 0x0
	dspck_astio maddu, 0xffffffff, 0xffffffe0, 0x07fffffa, 0x000000e0, 0x7fffffe0, 0x0ffffff8, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000005, 0x80000000, 0x00000005, 0x00000000, 0x00d1f23e, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000005, 0x0000007a, 0xfffffc0d, 0x8000007f, 0xfffffff8, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x00000000, 0x7fffffff, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00000000, 0x00000243, 0xfffffb78, 0x7fffffff, 0x00000488, 0x0, 0x0
	dspck_astio maddu, 0xffffffff, 0xf7536e34, 0x7fffffa9, 0x775370c8, 0xffffff5b, 0x7ffffffc, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x00000000, 0x0019d51c, 0x0, 0x0
	dspck_astio maddu, 0x1fffffff, 0xfffffff8, 0x6000001f, 0x7ffffff8, 0x80000000, 0x8000003f, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x0000007f, 0x80000000, 0x000000d3, 0x00000015, 0x00000004, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000000, 0xedb6db6c, 0xa4924925, 0xdb6db6db, 0x7fffffff, 0x0, 0x0
	dspck_astio maddu, 0x000000f8, 0x328b14f1, 0x2aaaaba2, 0xb28b14f1, 0x55555555, 0x80000000, 0x0, 0x0
	dspck_astio maddu, 0x0fffffff, 0xfffffffc, 0x4fffffff, 0x7ffffffc, 0x7fffffff, 0x80000000, 0x0, 0x0
	dspck_astio maddu, 0x7fffffff, 0xffffffff, 0x80000015, 0x1c71c6c7, 0x38e38e38, 0x0000005f, 0x0, 0x0
	dspck_astio maddu, 0xffff0000, 0xffff0000, 0x3fff0000, 0x7fff0000, 0x7fffffff, 0x80000000, 0x0, 0x0
	dspck_astio maddu, 0x003eedcb, 0x8399f5aa, 0x003eedcb, 0x8399f5aa, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x0000007f, 0xf8000003, 0x8000007f, 0xf0000007, 0x80000000, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000007, 0xff6dd515, 0x812455da, 0xfedbaa2d, 0x7fffffff, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000000, 0x8f0f0f0b, 0x3c3c3c40, 0x0ffffffc, 0xf0f0f0f0, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00000004, 0xb6db6d5a, 0x92492504, 0xffffff80, 0xb6db6db6, 0x0, 0x0
	dspck_astio maddu, 0x7fffffff, 0xfffffffc, 0xfffdfcd0, 0x0004065a, 0xfffbf9a2, 0x7fffffff, 0x0, 0x0
	dspck_astio maddu, 0x38e38e38, 0xe38e38e3, 0x38e391b4, 0xe388c723, 0xfffffe70, 0x0000037c, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000000, 0xffffffff, 0x80000000, 0xffffffff, 0x80000000, 0x0, 0x0
	dspck_astio maddu, 0x7fffffff, 0xffffffff, 0x78100001, 0xf8000000, 0xfc000001, 0xfc000001, 0x0, 0x0
	dspck_astio maddu, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x7ffffffe, 0x00000000, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00000024, 0xc0000019, 0xbfffff4b, 0xfffffff9, 0xc000001f, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000000, 0x8000003f, 0x80000000, 0x0000007f, 0x80000000, 0x0, 0x0
	dspck_astio maddu, 0x1fffffff, 0xfffffff8, 0x256ad256, 0x7ffffff8, 0x80000000, 0x0ad5a4ad, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x38e38e38, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000000, 0x85a7353d, 0xd2c65610, 0xfffffff8, 0x05a7353e, 0x0, 0x0
	dspck_astio maddu, 0x92492492, 0x49249249, 0x9249249a, 0x09249059, 0x0000001f, 0x3ffffff0, 0x0, 0x0
	dspck_astio maddu, 0xffffac83, 0x13403e4f, 0xffffac83, 0x13403e4f, 0x00000000, 0xfffff96f, 0x0, 0x0
	dspck_astio maddu, 0x00000016, 0x288440c6, 0x40000016, 0x288440c6, 0x80000000, 0x80000000, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00000000, 0x0000000e, 0xd0ad2f8f, 0x0000000f, 0xfcd85881, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00000007, 0x6cb5f2b1, 0x818d590f, 0x8000003f, 0xd96be4f8, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00000005, 0x00000000, 0x00000005, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00000000, 0x80000000, 0xfffffffc, 0xfffffffe, 0x80000002, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x0000000b, 0x0007f5dc, 0x8000000b, 0x80000000, 0x000febb9, 0x0, 0x0
	dspck_astio maddu, 0xf0000000, 0x00000003, 0xf0000000, 0x00000003, 0x00000000, 0x80000001, 0x0, 0x0
	dspck_astio maddu, 0x7fffffff, 0xffffffff, 0x8150cfff, 0x1eaa8726, 0xfffffd0d, 0x0150d003, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x00000000, 0x00000299, 0x0, 0x0
	dspck_astio maddu, 0x00000014, 0x9ae8eb85, 0x24924939, 0xf656a260, 0x80000003, 0x49249249, 0x0, 0x0
	dspck_astio maddu, 0xfffe40ab, 0x2cbb3242, 0x0ffe40a3, 0x0cbb3252, 0xfffffffe, 0x0ffffff8, 0x0, 0x0
	dspck_astio maddu, 0xc0000000, 0x00000007, 0xc0000000, 0x00000007, 0x00000000, 0x80000000, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00000001, 0x7fff447e, 0x80000001, 0x80000000, 0xfffe88fd, 0x0, 0x0
	dspck_astio maddu, 0xc71c71c7, 0x1c71c71c, 0xc71c71c7, 0x1c71c71c, 0x00000000, 0x7fffffff, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x0002cd56, 0x00000000, 0x0, 0x0
	dspck_astio maddu, 0x7fffffff, 0xffffffff, 0x80000001, 0xfffffff1, 0x00000002, 0xfffffff9, 0x0, 0x0
	dspck_astio maddu, 0x7fffffff, 0xfffffffc, 0x871c71c3, 0x81c71c74, 0x71c71c71, 0x0ffffff8, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00000007, 0x7fffffcf, 0x80000066, 0x7fffffff, 0xffffffa1, 0x0, 0x0
	dspck_astio maddu, 0xaaaaaaaa, 0xaaaaaaaa, 0xa6aaa82d, 0xcaaaa822, 0xfc000001, 0xfffffd78, 0x0, 0x0
	dspck_astio maddu, 0x7fffffff, 0xffffffff, 0x80000000, 0x13fffff5, 0x00000005, 0x03fffffe, 0x0, 0x0
	dspck_astio maddu, 0xff9edb1e, 0x08c07004, 0x009d8e06, 0xd0f88652, 0xffb19bb2, 0x00ff00ff, 0x0, 0x0
	dspck_astio maddu, 0x7fffffff, 0xffffffff, 0x9ffffff0, 0x000001ff, 0x7fffffe0, 0x3ffffff0, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000000, 0x818282c8, 0x5d9bac70, 0x03050590, 0x8000001f, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x38e38e38, 0x00000000, 0x0, 0x0
	dspck_astio maddu, 0x7fffffff, 0xffffffff, 0x80000000, 0x00000589, 0x00000002, 0x000002c5, 0x0, 0x0
	dspck_astio maddu, 0xffffffff, 0xf2760d6d, 0xc71c7021, 0x643d2a1b, 0xc71c71c7, 0xfffffde2, 0x0, 0x0
	dspck_astio maddu, 0xffffffff, 0xfffffff7, 0x3fffffff, 0xfffffff7, 0x80000000, 0x80000000, 0x0, 0x0
	dspck_astio maddu, 0xfffff4f2, 0xbe4f2c0a, 0x38e3832b, 0x3e4f2c0a, 0x71c71c71, 0x80000000, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_astio maddu, 0xffffffff, 0xffffffff, 0x7fffec1b, 0xffff38e5, 0x80000005, 0xffffd82e, 0x0, 0x0
	dspck_astio maddu, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x80000000, 0x00000000, 0x0, 0x0
	dspck_astio maddu, 0xf0000000, 0x00000007, 0xf0000000, 0x00000007, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00000000, 0x00010387, 0x7ffdf8f1, 0x0002070f, 0x7fffffff, 0x0, 0x0
	dspck_astio maddu, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00000000, 0x7fffffff, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00000003, 0x00000000, 0x00000003, 0x80000000, 0x00000000, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00004efc, 0x7ffffff9, 0x80004f07, 0x7fffffff, 0xfffffff5, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00000000, 0x7e000000, 0x80000000, 0xfc000001, 0x80000000, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7fffffe0, 0x00000000, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00010d4d, 0x01c71c71, 0x4e39f0dd, 0x0ffffffc, 0x1c71c71c, 0x0, 0x0
	dspck_astio maddu, 0x0000064d, 0xc5646196, 0x800004fd, 0x456456f2, 0xfffffd57, 0x80000004, 0x0, 0x0
	dspck_astio maddu, 0xffffffff, 0xfffe758e, 0xffffffff, 0xfffe758e, 0x00000000, 0xfffffffb, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x04c74fae, 0x33333331, 0x6b2db616, 0xfffffff8, 0x33333333, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00000000, 0xe0000001, 0xbfffffd6, 0xfffffffa, 0xe0000007, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x1ffffff8, 0x00000000, 0x0, 0x0
	dspck_astio maddu, 0xf0000000, 0x00000001, 0x6ffffb95, 0x80000001, 0x80000000, 0xfffff72b, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x00000000, 0x7fffffff, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00000002, 0x00000000, 0x00000002, 0x00000000, 0xfffffd32, 0x0, 0x0
	dspck_astio maddu, 0x7fffffff, 0xffffffff, 0x83fffffe, 0xffffffff, 0x07fffffe, 0x80000000, 0x0, 0x0
	dspck_astio maddu, 0xf8000000, 0x00000001, 0xe8f0f0b3, 0xc3c3c401, 0xf0f0f0f0, 0xffffffc0, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000000, 0x80000001, 0x1c71c718, 0x0000000a, 0x1c71c71c, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x0000000f, 0x80d05620, 0x762e6c85, 0x00d05632, 0xffffea73, 0x0, 0x0
	dspck_astio maddu, 0xffffffff, 0xf01a2f3a, 0x70000007, 0x701a2f3a, 0x80000000, 0xe000000f, 0x0, 0x0
	dspck_astio maddu, 0x0006a63e, 0xec0d609e, 0x0006a63e, 0xec0d609e, 0x00000000, 0x00000006, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000000, 0x84dba689, 0xf648b2ec, 0x04dba68a, 0xfffffffe, 0x0, 0x0
	dspck_astio maddu, 0xffffffff, 0xffff88cd, 0x3fffffdf, 0xffff88cd, 0x7fffffc0, 0x80000000, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x00000000, 0x07fffffe, 0x0, 0x0
	dspck_astio maddu, 0xf0000000, 0x00000007, 0x0ffffff4, 0x00000107, 0x7ffffff0, 0x3ffffff0, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000000, 0xbfffffff, 0x80000000, 0x7fffffff, 0x80000000, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x188fc626, 0x7ffe35df, 0x98935a65, 0xfffc6bc1, 0x7fffffff, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000000, 0x7f83f0b4, 0x02e85ba4, 0xfffffffa, 0xff83f0ba, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00000000, 0x0000000e, 0x00000000, 0x80000000, 0x0000001c, 0x0, 0x0
	dspck_astio maddu, 0xffffffff, 0xfffb1ef8, 0xffffffff, 0xfffb2072, 0x0000003f, 0x00000006, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000003, 0xc0000000, 0x00000003, 0x80000000, 0x80000000, 0x0, 0x0
	dspck_astio maddu, 0xffffffff, 0xfffffffe, 0x40000006, 0xffffffef, 0x7fffffff, 0x8000000f, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x0008246c, 0x00000000, 0x0008246c, 0x00000000, 0xfffffff8, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00000000, 0x007f807f, 0x7f00ff01, 0x7fffffff, 0x00ff00ff, 0x0, 0x0
	dspck_astio maddu, 0x71c71c71, 0xc71c71c7, 0xf1c39a3d, 0xc723762d, 0xfff8fb9a, 0x7fffffff, 0x0, 0x0
	dspck_astio maddu, 0x7fffffff, 0xfffffffa, 0x80000002, 0x94f8b209, 0x0000003f, 0x0a7dda31, 0x0, 0x0
	dspck_astio maddu, 0x1fffffff, 0xfffffff8, 0x2000002f, 0x400003a9, 0x0000003f, 0xc000000f, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000000, 0xff807f80, 0x00000000, 0x80000000, 0xff00ff00, 0x0, 0x0
	dspck_astio maddu, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x00000000, 0xfffffffc, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00000000, 0x0000007b, 0x7fffff09, 0x7fffffff, 0x000000f7, 0x0, 0x0
	dspck_astio maddu, 0xffffffff, 0xfffc2ba3, 0xffffffff, 0xfffc99a4, 0x0000003f, 0x000001bf, 0x0, 0x0
	dspck_astio maddu, 0x7fffffff, 0xffffffff, 0x5ffffff8, 0xffffff8f, 0xe0000007, 0xfffffff0, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x0000007f, 0x800000ea, 0x4fffc5eb, 0x07fffffe, 0x00001d4a, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00000003, 0x26666653, 0x0ccccce3, 0x3fffffe0, 0x99999999, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x00000000, 0xc71c71c7, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x0000007f, 0xffffcf89, 0x7ffd59a2, 0xffff9f05, 0x80000007, 0x0, 0x0
	dspck_astio maddu, 0x7fffffff, 0xffffffff, 0x80000000, 0x954e660f, 0x00000d84, 0x000b0c04, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00009813, 0x00000000, 0x00009813, 0x00000000, 0x8000000f, 0x0, 0x0
	dspck_astio maddu, 0x1c71c71c, 0x71c71c71, 0x1cf1479b, 0xe9cf1479, 0x7ffffff8, 0x00ff00ff, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x2f91e634, 0x00000000, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00000131, 0xef746c23, 0xfd53dbd9, 0xef747747, 0xfffff418, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000000, 0x8000000b, 0x400001d1, 0x0000000f, 0xc000001f, 0x0, 0x0
	dspck_astio maddu, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x00000000, 0x013d4de2, 0x0, 0x0
	dspck_astio maddu, 0x7fffffff, 0xffffffe0, 0xbfffffff, 0x7fffffe0, 0x7fffffff, 0x80000000, 0x0, 0x0
	dspck_astio maddu, 0x7fffffff, 0xffffffff, 0x7ffffefc, 0x000003ff, 0xffffff00, 0xfffffffc, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00000000, 0x00193438, 0xfd25158b, 0xffffffe3, 0x00193439, 0x0, 0x0
	dspck_astio maddu, 0xffffffff, 0xf8550280, 0x0ffffffb, 0xd8550090, 0x1ffffff0, 0x8000001f, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x89172bed, 0xffffffa0, 0x89172ead, 0xffffffa8, 0xfffffff8, 0x0, 0x0
	dspck_astio maddu, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x00000000, 0x7fffffff, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00ce6f01, 0x00000005, 0x00ce6ef7, 0x7fffffff, 0x0000000a, 0x0, 0x0
	dspck_astio maddu, 0xaaaaaaaa, 0xaaaaaaaa, 0x8aaaaa8f, 0xaaaaaa8a, 0xe0000001, 0xffffffe0, 0x0, 0x0
	dspck_astio maddu, 0x0fffffff, 0xfffffff8, 0x0ffffff8, 0x00000004, 0xfffffffe, 0xfffffffa, 0x0, 0x0
	dspck_astio maddu, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x00000000, 0x0000007f, 0x0, 0x0
	dspck_astio maddu, 0x09e9a721, 0x9b487a5c, 0x08eaa620, 0x9c477b5c, 0xff00ff00, 0xffffffff, 0x0, 0x0
	dspck_astio maddu, 0xffffffff, 0xffffff21, 0xffffffff, 0xffffff21, 0xc0000001, 0x00000000, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x0000015c, 0xffee2d59, 0x4af0f94b, 0xffffed5b, 0xffee3ffd, 0x0, 0x0
	dspck_astio maddu, 0x7fffffff, 0xfffffff8, 0x7fffffff, 0xfffffff8, 0x1ffffffe, 0x00000000, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000007, 0x80000000, 0x00000007, 0x00000000, 0x38e38e38, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000000, 0x80000005, 0xd42fd82f, 0x00000035, 0x1c278b53, 0x0, 0x0
	dspck_astio maddu, 0xffffffff, 0xfff115b6, 0x0059de97, 0x38c7cd47, 0x00738be7, 0xc71c71c7, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00000000, 0x7ffffff9, 0x80000000, 0xfffffff3, 0x80000000, 0x0, 0x0
	dspck_astio maddu, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x06cfe542, 0x071c71c5, 0x3fb37382, 0x38e38e38, 0x1ffffff8, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00000000, 0x00000000, 0x1b41447d, 0x01d126b3, 0x0000000f, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000000, 0xfffffc3e, 0x00000782, 0xfffff87e, 0x7fffffff, 0x0, 0x0
	dspck_astio maddu, 0xfffac4fc, 0x89ac2465, 0x0004c00f, 0xdb90136d, 0xffffd4e8, 0x0009fb15, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000000, 0x80000007, 0x00000000, 0x80000000, 0x0000000e, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000000, 0x80000007, 0x3be51184, 0x00000024, 0x33710799, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x000078f7, 0x006f346e, 0xe4e72317, 0x09923530, 0x0b9e6896, 0x0, 0x0
	dspck_astio maddu, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x00000000, 0x009b80a3, 0x0, 0x0
	dspck_astio maddu, 0x6db6db6d, 0xb6db6db6, 0x34d1da6a, 0x61864d59, 0xfffe2345, 0xc71c71c7, 0x0, 0x0
	dspck_astio maddu, 0x7fffffff, 0xffffffff, 0x3ffffff4, 0x3fffff50, 0xc0000007, 0xffffffe7, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00001c17, 0x00051873, 0xf9619ebb, 0x0241e01a, 0x0241e01a, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x36bd3d24, 0x71c71ba6, 0x8c1293dc, 0xfffffe38, 0x71c71c71, 0x0, 0x0
	dspck_astio maddu, 0x7fffffff, 0xffffffff, 0x80000006, 0xf0981053, 0x0091369b, 0x00000c3c, 0x0, 0x0
	dspck_astio maddu, 0xffffffff, 0xffff0767, 0x0000016a, 0x7fff0767, 0x000002d5, 0x80000000, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00000005, 0x12492491, 0x2492492d, 0x7ffffffa, 0x24924924, 0x0, 0x0
	dspck_astio maddu, 0xffffff2f, 0xfa69e3a1, 0x3fffff2f, 0xfa69e3a1, 0x80000000, 0x80000000, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x028c52e8, 0x00000000, 0x028c52e8, 0x0007084a, 0x00000000, 0x0, 0x0
	dspck_astio maddu, 0xe0000000, 0x00000007, 0xe0000000, 0x00000007, 0x00000000, 0x80000007, 0x0, 0x0
	dspck_astio maddu, 0x00000046, 0xee62b809, 0x70000047, 0x6e62b809, 0x80000000, 0xe0000001, 0x0, 0x0
	dspck_astio maddu, 0x8e38e38e, 0x38e38e38, 0x8e38e48d, 0x38e2d2f4, 0x000000ff, 0xffffff44, 0x0, 0x0
	dspck_astio maddu, 0x92492492, 0x49249249, 0x92492492, 0x49249249, 0xfffffc15, 0x00000000, 0x0, 0x0
	dspck_astio maddu, 0x1c71c71c, 0x71c71c71, 0xd849e8ec, 0x2c3c9eda, 0xfa758269, 0xc0000001, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x0000001f, 0xffffff7e, 0x8000019f, 0xfffffffd, 0x7fffff80, 0x0, 0x0
	dspck_astio maddu, 0x7fffffff, 0xffffffe0, 0x7fffffff, 0xffffffe0, 0x00000000, 0x000ce333, 0x0, 0x0
	dspck_astio maddu, 0x0d8fbb41, 0x1c73dc5d, 0x8d72bf59, 0x1cadd42b, 0x7fffffff, 0xffc60832, 0x0, 0x0
	dspck_astio maddu, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x00000000, 0x80000000, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7ffffffb, 0x00000000, 0x0, 0x0
	dspck_astio maddu, 0xffffffff, 0xffdcb2ba, 0x000000a5, 0xfb1f0932, 0xfff8b054, 0x000000a6, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000000, 0xfc000001, 0x80000000, 0x80000000, 0xf8000003, 0x0, 0x0
	dspck_astio maddu, 0x7fffffff, 0xffffffff, 0x80060038, 0x7ff3ff8e, 0x000c0071, 0x7fffffff, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x00000000, 0x3fffffe0, 0x0, 0x0
	dspck_astio maddu, 0x7fffffff, 0xffffffff, 0x800000eb, 0x165494e0, 0x000007fb, 0x1d7533d3, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000000, 0x87ffffff, 0x00000000, 0x0ffffffe, 0x80000000, 0x0, 0x0
	dspck_astio maddu, 0x0000185d, 0x77927fa7, 0x0000185d, 0x77927fa7, 0x07fffffe, 0x00000000, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000001, 0x80000000, 0x00000001, 0x0000778b, 0x00000000, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000000, 0xbfffffff, 0x00000001, 0x7fffffff, 0x7fffffff, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff00, 0x00000000, 0x0, 0x0
	dspck_astio maddu, 0x7fffffff, 0xffffffff, 0x8000562c, 0x7fffffff, 0x80000000, 0x0000ac59, 0x0, 0x0
	dspck_astio maddu, 0x7fffffff, 0xffffffff, 0x80001e96, 0xffe2f6aa, 0x00001e97, 0xffffff0d, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000000, 0xa6666666, 0xd9999999, 0xc0000003, 0x33333333, 0x0, 0x0
	dspck_astio maddu, 0x1fffffff, 0xfffffff8, 0x5fffffff, 0x7ffffff8, 0x7fffffff, 0x80000000, 0x0, 0x0
	dspck_astio maddu, 0xffffffff, 0xffffff00, 0x00000098, 0xfffffe67, 0x000000ff, 0x99999999, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00000000, 0xef1f79f1, 0x49738e4d, 0xff10820b, 0xf0000007, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00000000, 0x0001df85, 0x00000000, 0x80000000, 0x0003bf0a, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000000, 0xb8e38e38, 0x80000000, 0x80000000, 0x71c71c71, 0x0, 0x0
	dspck_astio maddu, 0xffffffff, 0xfffffffe, 0xffe36072, 0x03217076, 0xffe3608e, 0xffffffe4, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000003, 0x80000000, 0x80000002, 0x7fffffff, 0x00000001, 0x0, 0x0
	dspck_astio maddu, 0xffffffff, 0xfff91d9f, 0x7ffffffe, 0xfff91d9f, 0xfffffffe, 0x80000000, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000000, 0x800011db, 0xfae22060, 0x000011dc, 0xffffb6a8, 0x0, 0x0
	dspck_astio maddu, 0xffffffff, 0x5e860602, 0xffffffff, 0x5e8cc489, 0x000000fd, 0x000006d3, 0x0, 0x0
	dspck_astio maddu, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_astio maddu, 0x00000000, 0x00000155, 0x3ffffffe, 0x80000155, 0x80000000, 0x7ffffffd, 0x0, 0x0
	dspck_astio maddu, 0x0000d6fa, 0x92c7d6ba, 0x002cd92c, 0x1377df80, 0x00580463, 0x80000002, 0x0, 0x0
	dspck_astio maddu, 0xffffca4e, 0xdb17acf9, 0x7fffc9f8, 0x5b17af8d, 0xffffff5b, 0x7ffffffc, 0x0, 0x0
	dspck_astio maddu, 0xffffffff, 0xfffffffd, 0xffffffff, 0xfffffffd, 0x00000000, 0x0ffffffc, 0x0, 0x0

	writemsg "[15] Test msub"
	dspck_astio msub, 0x7fffffff, 0xfffffff9, 0x40000000, 0xfffffff8, 0x7fffffff, 0x7fffffff, 0x0, 0x0
	dspck_astio msub, 0x0fffffff, 0xfffffffc, 0x10001354, 0xffffd952, 0xffffd956, 0x7fffffff, 0x0, 0x0
	dspck_astio msub, 0x80000000, 0x00000000, 0x7fffffff, 0x80000000, 0xffffffff, 0x80000000, 0x0, 0x0
	dspck_astio msub, 0x1fffffff, 0xfffffffe, 0x1fffffff, 0xfffffffe, 0x00000000, 0x8000007f, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x00000000, 0xffffffc0, 0x400003fc, 0x3ffffffc, 0x000000ff, 0x0, 0x0
	dspck_astio msub, 0xffffffff, 0xfffffdc7, 0xfffffffe, 0x7ffffdc7, 0x80000000, 0xfffffffd, 0x0, 0x0
	dspck_astio msub, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7ffffffb, 0x0, 0x0
	dspck_astio msub, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x0000064f, 0x00000000, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x00000000, 0x000100e4, 0xfffdfe36, 0xfffdfe36, 0x7fffffff, 0x0, 0x0
	dspck_astio msub, 0x7fffffff, 0xfffffff0, 0x800022b5, 0x7fffba85, 0x7fffffff, 0xffffba95, 0x0, 0x0
	dspck_astio msub, 0xffffffff, 0xfffffff3, 0x0000003a, 0xfffffff3, 0x80000000, 0x00000076, 0x0, 0x0
	dspck_astio msub, 0x7fffffff, 0xffffffff, 0x7ffffe89, 0x0ba42fce, 0x000007cf, 0x3004a7ff, 0x0, 0x0
	dspck_astio msub, 0xcccccccc, 0xcccccccc, 0xccc85c69, 0x4ccccccc, 0xfff71f39, 0x80000000, 0x0, 0x0
	dspck_astio msub, 0xffffffff, 0xfffffffe, 0xffffffff, 0xfffffffe, 0x0000ffff, 0x00000000, 0x0, 0x0
	dspck_astio msub, 0xffff0000, 0xffff0000, 0xffff0000, 0xffff0000, 0x00000000, 0x0ffffffe, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x0000000f, 0xffffff77, 0x24924799, 0xdb6db6db, 0xfffffc42, 0x0, 0x0
	dspck_astio msub, 0x80000000, 0x00000000, 0x7fc9d069, 0x7b17cb50, 0x0ffffff8, 0x0362f96a, 0x0, 0x0
	dspck_astio msub, 0x6db6db6d, 0xb6db6db6, 0x6db6db6d, 0xb6db6db6, 0x00000000, 0xffffe47c, 0x0, 0x0
	dspck_astio msub, 0x7fffffff, 0xffffffff, 0x80000003, 0xfffffff7, 0xfffffff8, 0x7fffffff, 0x0, 0x0
	dspck_astio msub, 0xffffffff, 0xff78ed21, 0xffffffff, 0xff78ed21, 0x11ff3312, 0x00000000, 0x0, 0x0
	dspck_astio msub, 0x7fffffff, 0xffffffff, 0x87c8a81d, 0x706eafc4, 0x7fffffff, 0xf06eafc5, 0x0, 0x0
	dspck_astio msub, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x00000000, 0xe0000001, 0x0, 0x0
	dspck_astio msub, 0x7fffffff, 0xffffffff, 0x7ffffcc6, 0x00000673, 0x7fffffff, 0x00000674, 0x0, 0x0
	dspck_astio msub, 0xf0000000, 0x00000007, 0xb000001f, 0x80000007, 0x8000003f, 0x80000000, 0x0, 0x0
	dspck_astio msub, 0xffffffff, 0xfffd15b4, 0x00000004, 0xd7fd13e3, 0x0000009b, 0xf8000003, 0x0, 0x0
	dspck_astio msub, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_astio msub, 0xf0f0f0f0, 0xf0f0f0f0, 0xf0f0f0f0, 0xf0f0f0f0, 0x0000000f, 0x00000000, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x00000000, 0x00000a66, 0x7ffeb330, 0xffffeb33, 0x7ffffff0, 0x0, 0x0
	dspck_astio msub, 0x000001bc, 0xeb36bc19, 0x000001d2, 0xeb36bab9, 0x7ffffff8, 0xffffffd4, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x00003f07, 0xc0000001, 0x00003f06, 0x7fffffff, 0x7fffffff, 0x0, 0x0
	dspck_astio msub, 0x00000024, 0x11b7df27, 0x00000087, 0x11b7df27, 0x000000c6, 0x80000000, 0x0, 0x0
	dspck_astio msub, 0x7fffffff, 0xffffffff, 0x7ffffff0, 0x0000005f, 0x80000003, 0xffffffe0, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x00000074, 0x000000c7, 0xfffff8a4, 0x00000190, 0x80000005, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x00000d09, 0x00246ddb, 0x6d253109, 0xff00ff00, 0x24924924, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x00000000, 0xf1c71c71, 0x80000000, 0xe38e38e3, 0x80000000, 0x0, 0x0
	dspck_astio msub, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x00000000, 0x00000fef, 0x0, 0x0
	dspck_astio msub, 0xffffffff, 0xffffc89c, 0xffffffc0, 0x3fffe87c, 0x000000ff, 0x3fffffe0, 0x0, 0x0
	dspck_astio msub, 0x80000000, 0x0000007f, 0x6db6db6e, 0xdb6db757, 0x7ffffffa, 0x24924924, 0x0, 0x0
	dspck_astio msub, 0x000006d1, 0x2c0ed11c, 0x000013ce, 0x2c0ec41f, 0xffffd909, 0x55555555, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7fffff80, 0x00000000, 0x0, 0x0
	dspck_astio msub, 0x7fffffff, 0xfffffff8, 0x7fffffff, 0xfffffff8, 0xcccccccc, 0x00000000, 0x0, 0x0
	dspck_astio msub, 0x80000000, 0x00000000, 0x801af064, 0x5543e6e9, 0x06bc1917, 0xfc000001, 0x0, 0x0
	dspck_astio msub, 0xe0000000, 0x00000001, 0xe0000000, 0x00000001, 0x0030397d, 0x00000000, 0x0, 0x0
	dspck_astio msub, 0x80000000, 0x00000000, 0x7ffffffe, 0x80000003, 0x00000003, 0x7fffffff, 0x0, 0x0
	dspck_astio msub, 0x7fffffff, 0xffffffff, 0x7ffe166a, 0x800f4cab, 0x80000004, 0xfffc2cd5, 0x0, 0x0
	dspck_astio msub, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_astio msub, 0x80000000, 0x00000000, 0x871c71c7, 0x071c71c6, 0x3ffffffe, 0xe38e38e3, 0x0, 0x0
	dspck_astio msub, 0xb6db6db6, 0xdb6db6db, 0xd6db6daf, 0x1b6db6ea, 0xc000000f, 0x7fffffff, 0x0, 0x0
	dspck_astio msub, 0xff00ff00, 0xff00ff00, 0xff011176, 0x7f00ff00, 0x80000000, 0x000024eb, 0x0, 0x0
	dspck_astio msub, 0x000a3ed2, 0xb6e3cbee, 0x000a3ed2, 0xb6e3cbee, 0xfffff9a0, 0x00000000, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x000000ff, 0x00000008, 0x000000ef, 0x7fffffff, 0xfffffff0, 0x0, 0x0
	dspck_astio msub, 0xb6db6db6, 0xdb6db6db, 0x76db6db9, 0xdb6db6db, 0x80000000, 0x80000006, 0x0, 0x0
	dspck_astio msub, 0x0316d902, 0xa34af328, 0x0316d902, 0xa34af328, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_astio msub, 0x000011cd, 0x90eda3a7, 0x000011cd, 0x90eda3a7, 0xffffe886, 0x00000000, 0x0, 0x0
	dspck_astio msub, 0x00007e56, 0x9ed89c04, 0x40007e56, 0x1ed89c04, 0x80000000, 0x7fffffff, 0x0, 0x0
	dspck_astio msub, 0x1fffffff, 0xfffffffe, 0x20000000, 0x0002d92e, 0x0000b64c, 0xfffffffc, 0x0, 0x0
	dspck_astio msub, 0x1fffffff, 0xfffffff0, 0x1fffffff, 0xffffb77a, 0x00000212, 0x00000023, 0x0, 0x0
	dspck_astio msub, 0x80000000, 0x00000000, 0xbffffffb, 0x00000019, 0x7ffffffb, 0x80000005, 0x0, 0x0
	dspck_astio msub, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x00000000, 0xc000001f, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x005ba7e3, 0x00000000, 0x005ba7e3, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_astio msub, 0x80000000, 0x00000000, 0x80000003, 0x4bfa8804, 0xfffd37f2, 0x00012f6e, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x000013fb, 0xfffff795, 0x0000467d, 0x7ffffffd, 0x000010d6, 0x0, 0x0
	dspck_astio msub, 0x80000000, 0x00000000, 0x81ffffff, 0x7c000001, 0xfc000001, 0x7fffffff, 0x0, 0x0
	dspck_astio msub, 0xc0000000, 0x0000001f, 0xc0000008, 0x0000000f, 0xfffffff0, 0x7fffffff, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x00000000, 0xffffffff, 0xfff42292, 0x00000075, 0x000019f6, 0x0, 0x0
	dspck_astio msub, 0x3fffffff, 0xfffffff8, 0x3fffffff, 0xfffffff8, 0xffffffe0, 0x00000000, 0x0, 0x0
	dspck_astio msub, 0x7fffffff, 0xfffffffc, 0x7f650c32, 0x8135e797, 0x0135e79b, 0x7fffffff, 0x0, 0x0
	dspck_astio msub, 0x0000a325, 0x1b6dbc2b, 0x0000a325, 0x1b6dbc2b, 0x00000000, 0x000002fc, 0x0, 0x0
	dspck_astio msub, 0x0263b7c4, 0x3d87f376, 0x0263b7c4, 0x3d87ffc4, 0xffffffff, 0x00000c4e, 0x0, 0x0
	dspck_astio msub, 0xffffffff, 0x3afbdbbb, 0x00000001, 0xbafbdbb6, 0x7fffffff, 0xfffffffb, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x00000c62, 0xfffffffc, 0x80000c69, 0x7fffffff, 0x00000007, 0x0, 0x0
	dspck_astio msub, 0x80000000, 0x00000000, 0x7fffffff, 0xfffe147a, 0xfffffffe, 0xffff0a3d, 0x0, 0x0
	dspck_astio msub, 0x7fffffff, 0xffffffff, 0x70000007, 0x7fffffff, 0x80000000, 0xe000000f, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x00000000, 0xffffffff, 0xffffff0d, 0xffffffff, 0xffffff0d, 0x0, 0x0
	dspck_astio msub, 0x7fffffff, 0xffffffff, 0x80079013, 0xce94fc48, 0x0079013d, 0xf0000003, 0x0, 0x0
	dspck_astio msub, 0x7fffffff, 0xffffffe0, 0x40000001, 0xffffffdd, 0x7ffffffd, 0x7fffffff, 0x0, 0x0
	dspck_astio msub, 0x0000ffff, 0x0000ffff, 0x00014584, 0x0000ffff, 0x80000000, 0x00008b0a, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x00000000, 0x000029cb, 0x8b721de9, 0x00708e73, 0xffa0f0cd, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_astio msub, 0x00016105, 0x98d8ef9e, 0xe0016115, 0xd8d8ef7e, 0x7fffffff, 0x3fffffe0, 0x0, 0x0
	dspck_astio msub, 0x0fffffff, 0xfffffffc, 0x0fffffff, 0xfffffffc, 0xfffffff0, 0x00000000, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x00000000, 0x001f4978, 0xffc16d0e, 0xffc16d0e, 0x7fffffff, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x005ec8cf, 0xe0000000, 0x805ec8cf, 0x80000000, 0xc0000001, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x00000000, 0x007f807f, 0x80000000, 0x80000000, 0x00ff00ff, 0x0, 0x0
	dspck_astio msub, 0x06036d31, 0xd4e8c0c4, 0x06036d31, 0xd4732c00, 0xfffffffc, 0xffe29acf, 0x0, 0x0
	dspck_astio msub, 0x00000001, 0xacf931be, 0x00000000, 0xacf931bb, 0xfffffff9, 0xdb6db6db, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x00000000, 0xffffffe0, 0x8000003f, 0x0000003f, 0x7fffffff, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x80000007, 0x00000000, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7ffffff8, 0x0, 0x0
	dspck_astio msub, 0xffffffff, 0xfff83da3, 0x00000000, 0x0057f2e3, 0xffffffc0, 0x00017ed5, 0x0, 0x0
	dspck_astio msub, 0xc0000000, 0x00000001, 0xc0000000, 0x00000001, 0x00000000, 0xfffffff3, 0x0, 0x0
	dspck_astio msub, 0x00000002, 0xb02b83e8, 0x00000002, 0xb02b83e8, 0x00000000, 0x7fffffe0, 0x0, 0x0
	dspck_astio msub, 0xcccccccc, 0xcccccccc, 0xffffffff, 0xe6666665, 0x99999999, 0x7fffffff, 0x0, 0x0
	dspck_astio msub, 0xffffffff, 0xfffff646, 0x00000000, 0xfffff646, 0x00000002, 0x80000000, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x00000001, 0xfffffff2, 0x38e38e52, 0x71c71c71, 0x0000001f, 0x0, 0x0
	dspck_astio msub, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x00000000, 0x80000000, 0x0, 0x0
	dspck_astio msub, 0x71c71c71, 0xc71c71c7, 0x71c71c71, 0xc71c71c7, 0x7ffffff0, 0x00000000, 0x0, 0x0
	dspck_astio msub, 0xffffd375, 0xe706709a, 0xffffd375, 0x0b98b9c2, 0x24924924, 0x00000006, 0x0, 0x0
	dspck_astio msub, 0xffffffed, 0x0cbdc42f, 0xf6db6da4, 0xa82b7b0d, 0xb6db6db6, 0xe0000003, 0x0, 0x0
	dspck_astio msub, 0x00000033, 0x69c5c9e1, 0x00000033, 0x69c5c9e1, 0x80000000, 0x00000000, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x0000006e, 0x00037120, 0x5e7e8244, 0xf0000007, 0x00371206, 0x0, 0x0
	dspck_astio msub, 0xffffffff, 0xfffffffe, 0xffffffff, 0xff8c0c02, 0xfffffffc, 0xffe30301, 0x0, 0x0
	dspck_astio msub, 0xffffffff, 0xffffff92, 0x03fffffd, 0xf7ffff96, 0x80000001, 0x07fffffc, 0x0, 0x0
	dspck_astio msub, 0x00000003, 0xc7a8bdc2, 0x40000003, 0x47a8bdc2, 0x80000000, 0x7fffffff, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x00000000, 0x00105539, 0x7fdf558d, 0xffdf558d, 0x7fffffff, 0x0, 0x0
	dspck_astio msub, 0x7fffffff, 0xfffffffd, 0x7ffffff7, 0xfffffffd, 0xfffffff0, 0x80000000, 0x0, 0x0
	dspck_astio msub, 0x00000f18, 0x9ad32c8b, 0x00000f1a, 0x9ad32c8b, 0x00000004, 0x80000000, 0x0, 0x0
	dspck_astio msub, 0xf0000000, 0x00000007, 0xdce455ea, 0xa6375432, 0x2637542b, 0x7fffffff, 0x0, 0x0
	dspck_astio msub, 0x66666666, 0x66666666, 0x62666668, 0x6e666662, 0x7fffffff, 0x07fffffc, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x0002ad3e, 0xc0000002, 0x0002ad3a, 0x7ffffffe, 0x7ffffffe, 0x0, 0x0
	dspck_astio msub, 0xcccccccc, 0xcccccccc, 0xcccccccc, 0xcccccae6, 0x00000001, 0x000001e6, 0x0, 0x0
	dspck_astio msub, 0x00000005, 0xe272b611, 0x2492492a, 0x994e23c7, 0xb6db6db6, 0x7fffffff, 0x0, 0x0
	dspck_astio msub, 0xdb6db6db, 0x6db6db6d, 0xdb6db5ef, 0xedb6db6d, 0x80000000, 0xfffffe29, 0x0, 0x0
	dspck_astio msub, 0xf242cc75, 0x02467cd4, 0xf242cc74, 0x82467cd4, 0x80000000, 0xffffffff, 0x0, 0x0
	dspck_astio msub, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xefeac421, 0x0084d062, 0x0000001f, 0x0, 0x0
	dspck_astio msub, 0x80000000, 0x00000000, 0x7ffffffc, 0x4924923e, 0xb6db6db6, 0xfffffff3, 0x0, 0x0
	dspck_astio msub, 0xf0000000, 0x00000003, 0xeb01db92, 0x00000003, 0x80000000, 0xf603b724, 0x0, 0x0
	dspck_astio msub, 0x7fffffff, 0xffffffff, 0x80012949, 0xffffffff, 0x80000000, 0x00025294, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x00000000, 0xffffffff, 0xffffff1f, 0x0000000f, 0x0000000f, 0x0, 0x0
	dspck_astio msub, 0x80000000, 0x0000000f, 0x80043b77, 0xfff7891f, 0x7fffffff, 0xfff78910, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x3c291b99, 0x0000003d, 0x3c291b1f, 0xffffff86, 0x7fffffff, 0x0, 0x0
	dspck_astio msub, 0xffffffff, 0xfffff6c2, 0xffffffff, 0xfffff6c2, 0x00000000, 0x7fffffff, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xfffffffb, 0x00000000, 0x0, 0x0
	dspck_astio msub, 0xffffffff, 0xfee0ff36, 0x00000000, 0x6ee0ff05, 0x00000007, 0xf0000007, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x00000000, 0xffffffff, 0xc538de82, 0x00000007, 0x08659712, 0x0, 0x0
	dspck_astio msub, 0xffffffff, 0xfffe43ab, 0x00000000, 0x0ffe43a4, 0x00000001, 0xf0000007, 0x0, 0x0
	dspck_astio msub, 0xfffffd73, 0x39c3f5aa, 0xfffffd73, 0x39c3f5aa, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x0000364b, 0xffffffff, 0xff0f7a3b, 0x00000f84, 0x00000f84, 0x0, 0x0
	dspck_astio msub, 0x80000000, 0x0000001f, 0x80000000, 0x0000001f, 0x00000000, 0x80000000, 0x0, 0x0
	dspck_astio msub, 0xfff9873f, 0x244a0fed, 0xfff9873f, 0x24414cfd, 0x00008c2f, 0x00000010, 0x0, 0x0
	dspck_astio msub, 0x039dc6dd, 0x7a4758ed, 0x039dc6bd, 0xfa47592c, 0x7fffffff, 0x0000003f, 0x0, 0x0
	dspck_astio msub, 0xfffffff8, 0x3f5ec4f0, 0x0001cdf0, 0xbf5ec4f0, 0x00039bf1, 0x80000000, 0x0, 0x0
	dspck_astio msub, 0x00000001, 0x28e115bc, 0xfffffffe, 0x2d393a9c, 0xe822c127, 0xffffffe0, 0x0, 0x0
	dspck_astio msub, 0x7fffffff, 0xffffffff, 0x7fff9d05, 0x0062faff, 0x7fffff80, 0x0000c5f6, 0x0, 0x0
	dspck_astio msub, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x000002e3, 0x00000000, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x00000004, 0xfffffffe, 0x80000010, 0x3ffffffe, 0x00000006, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x0000003f, 0xfffff39d, 0x0000003f, 0x80000000, 0xffffe73a, 0x0, 0x0
	dspck_astio msub, 0x80000000, 0x00000000, 0xbffffffe, 0x80000000, 0x7ffffffd, 0x80000000, 0x0, 0x0
	dspck_astio msub, 0xfffe6dbf, 0x5b9a00bd, 0x008379c9, 0xda8fe8a8, 0x7fffffff, 0xfef5e7eb, 0x0, 0x0
	dspck_astio msub, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_astio msub, 0xffffffff, 0xfff77cf1, 0x1bcfcca6, 0x4857e3a4, 0x7fffffff, 0xc86066b3, 0x0, 0x0
	dspck_astio msub, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x00000000, 0x7fffffff, 0x0, 0x0
	dspck_astio msub, 0x7fffffff, 0xfffffffb, 0x7fffffff, 0xfffffffb, 0x0000b239, 0x00000000, 0x0, 0x0
	dspck_astio msub, 0x00a38021, 0x4abde701, 0xf0a38021, 0xcabde701, 0x80000000, 0xe0000001, 0x0, 0x0
	dspck_astio msub, 0xc0000000, 0x0000001f, 0xc0000000, 0x0000001f, 0x00000000, 0xfffa9d9f, 0x0, 0x0
	dspck_astio msub, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x0, 0x0
	dspck_astio msub, 0xb6db6db6, 0xdb6db6db, 0xb6db6db6, 0xdb6db6db, 0x00000000, 0x80000000, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7fffffff, 0x0, 0x0
	dspck_astio msub, 0x7fffffff, 0xffffffff, 0x80000000, 0x00000077, 0xfffffff8, 0x0000000f, 0x0, 0x0
	dspck_astio msub, 0xffffffff, 0xffffffe0, 0x00000000, 0x02d0b311, 0xfff48f71, 0x0000003f, 0x0, 0x0
	dspck_astio msub, 0x33333333, 0x33333333, 0x00000000, 0x99999999, 0x66666666, 0x7fffffff, 0x0, 0x0
	dspck_astio msub, 0xffffffff, 0xfffffffc, 0x3fffffff, 0x7ffffffc, 0x7fffffff, 0x80000000, 0x0, 0x0
	dspck_astio msub, 0x80000000, 0x00000000, 0x8000000f, 0x80000000, 0x80000000, 0x0000001f, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x00000000, 0xffffffff, 0xffffffe4, 0x0000000e, 0x00000002, 0x0, 0x0
	dspck_astio msub, 0xe0000000, 0x00000007, 0xe0000000, 0x00000007, 0x0005cf66, 0x00000000, 0x0, 0x0
	dspck_astio msub, 0x7fffffff, 0xffffffff, 0x7ffffffc, 0xf0f0f0bf, 0xf0f0f0f0, 0xffffffcc, 0x0, 0x0
	dspck_astio msub, 0x80000000, 0x00000000, 0x8007494b, 0x1fc5b5a7, 0x003a4a59, 0xe0000001, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x001039ca, 0x00000000, 0x001039ca, 0x3ffffff8, 0x00000000, 0x0, 0x0
	dspck_astio msub, 0x7fffffff, 0xffffffff, 0x7ffffbcf, 0xf0004300, 0xffffbcff, 0xf0000001, 0x0, 0x0
	dspck_astio msub, 0x0001b171, 0x4c2f383a, 0x4001b16c, 0x4c2f384a, 0x7ffffff8, 0x80000002, 0x0, 0x0
	dspck_astio msub, 0x00ff00ff, 0x00ff00ff, 0x00feecde, 0x9a984a17, 0xcccccccc, 0xffff9b5e, 0x0, 0x0
	dspck_astio msub, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x00000000, 0x0000000e, 0x00000000, 0x80000000, 0x0000001c, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000002, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000000f, 0x00000000, 0x0, 0x0
	dspck_astio msub, 0x00000050, 0x9a998ea7, 0x00000050, 0xda59ce67, 0x00ff00ff, 0xffffffc0, 0x0, 0x0
	dspck_astio msub, 0xffffffff, 0x1b1536d5, 0xff807f7f, 0x39f655d5, 0xff00ff00, 0x8000001f, 0x0, 0x0
	dspck_astio msub, 0x80000000, 0x00000000, 0x7f340f68, 0x8197e12f, 0x7fffffff, 0x0197e12f, 0x0, 0x0
	dspck_astio msub, 0xf2b4a4d7, 0x7964e9af, 0xf2b4a4a9, 0xf964e9af, 0xffffffa5, 0x80000000, 0x0, 0x0
	dspck_astio msub, 0x7fffffff, 0xffffffff, 0x871c71c5, 0x5555555b, 0x1c71c71c, 0xc000000f, 0x0, 0x0
	dspck_astio msub, 0xffffffff, 0xfffffffa, 0x00000000, 0x4ec6b0c5, 0x00821b91, 0xffffff65, 0x0, 0x0
	dspck_astio msub, 0xe38e38e3, 0x8e38e38e, 0xe38e38e3, 0x8e3bbb5d, 0xfffffff9, 0x000067f9, 0x0, 0x0
	dspck_astio msub, 0x80000000, 0x00000006, 0x80000000, 0x0069dcef, 0x0000f427, 0xffffff91, 0x0, 0x0
	dspck_astio msub, 0x7fffffff, 0xffffffff, 0x7ffe2c94, 0x81cfc4a8, 0xfffc5929, 0x8000007f, 0x0, 0x0
	dspck_astio msub, 0xdd77f580, 0x9331e18a, 0xdd37f580, 0xb331e186, 0x07fffffe, 0x07fffffe, 0x0, 0x0
	dspck_astio msub, 0xe38e38e3, 0x8e38e38e, 0xe38e38e3, 0x8e38e38e, 0x00000000, 0x80000000, 0x0, 0x0
	dspck_astio msub, 0x00000059, 0x2f248d6e, 0x00000059, 0x2f248d6e, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_astio msub, 0xf0f0f0f0, 0xf0f0f0f0, 0xf0f0f0f0, 0xf0f0f0f0, 0x80000000, 0x00000000, 0x0, 0x0
	dspck_astio msub, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaca, 0xaaaaaa6a, 0xffffffc0, 0x7fffffff, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x00000f98, 0xfffed780, 0x329b954b, 0xf6449993, 0xffe1889f, 0x0, 0x0
	dspck_astio msub, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x0000007f, 0x00000000, 0x0, 0x0
	dspck_astio msub, 0xe0000000, 0x00000001, 0xe9249248, 0x00000005, 0xc0000007, 0x24924924, 0x0, 0x0
	dspck_astio msub, 0xe1d4841b, 0x83a41544, 0xe1d4841b, 0x83a41544, 0x00000000, 0xfffffffa, 0x0, 0x0
	dspck_astio msub, 0x80000000, 0x00000007, 0x80000000, 0x000796e1, 0xfffff506, 0x000000b1, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x00000005, 0x3fffffff, 0x80000005, 0x7fffffff, 0x80000000, 0x0, 0x0
	dspck_astio msub, 0xffffffff, 0xffc8ea08, 0xffca3761, 0x00347b46, 0x7fffffff, 0x006b913e, 0x0, 0x0
	dspck_astio msub, 0x7fffffff, 0xffffffff, 0x80000004, 0x6db6db7a, 0xdb6db6db, 0x0000001f, 0x0, 0x0
	dspck_astio msub, 0x7fffffff, 0xfffffff9, 0x87fffffb, 0xfffffff9, 0x0ffffff8, 0x80000000, 0x0, 0x0
	dspck_astio msub, 0x000002c5, 0x3ef67d53, 0xffff1305, 0xbef85cd2, 0x7fffffff, 0x0001df7f, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x00000000, 0x00000000, 0x01b5373c, 0xfffffffd, 0x0091bd14, 0x0, 0x0
	dspck_astio msub, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x80000000, 0x00000000, 0x0, 0x0
	dspck_astio msub, 0x80000000, 0x00000005, 0x7ffffffd, 0x00000005, 0x80000000, 0xfffffffa, 0x0, 0x0
	dspck_astio msub, 0x3fffffff, 0xfffffff0, 0x00000001, 0x7ffffff0, 0x80000003, 0x80000000, 0x0, 0x0
	dspck_astio msub, 0xc71c71c7, 0x1c71c71c, 0xc31c71c9, 0x2c71c714, 0x7ffffffe, 0x07fffffc, 0x0, 0x0
	dspck_astio msub, 0x00000839, 0x19ba9cf0, 0x00000854, 0x99ba9cf0, 0x00000037, 0x80000000, 0x0, 0x0
	dspck_astio msub, 0x7fffffff, 0xfffffffa, 0x7ffffff0, 0x80000019, 0x0000001f, 0x7fffffff, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x0000003f, 0x0003e603, 0xfff83437, 0xfff833f8, 0x7fffffff, 0x0, 0x0
	dspck_astio msub, 0xffffffff, 0xa8c61add, 0xffe2d17d, 0x290077e2, 0x003a5d05, 0x7fffffff, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x0000003f, 0xffff1124, 0x0000003f, 0x80000000, 0xfffe2248, 0x0, 0x0
	dspck_astio msub, 0xfffff17c, 0xe6b637c5, 0x3ffff17c, 0x66b637c5, 0x7fffffff, 0x80000000, 0x0, 0x0
	dspck_astio msub, 0x49249249, 0x24924924, 0x4924cd7d, 0xa491d2bb, 0xffff8997, 0x7fffffff, 0x0, 0x0
	dspck_astio msub, 0xfffffff8, 0xf2102784, 0xfffffffb, 0xf210261c, 0xe000000f, 0x00000018, 0x0, 0x0
	dspck_astio msub, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x7fffffe0, 0x00000000, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x00000000, 0x0ffffffd, 0x4000001c, 0x3ffffffc, 0xc0000007, 0x0, 0x0
	dspck_astio msub, 0xffffffff, 0x4b830639, 0x0058a1f8, 0x4ad1c247, 0x7fffffff, 0xff4ebc0e, 0x0, 0x0
	dspck_astio msub, 0x0000484f, 0x8556c9da, 0x0000484f, 0x8556c9da, 0xfe4416d8, 0x00000000, 0x0, 0x0
	dspck_astio msub, 0xffffffff, 0xfffc5b3b, 0xffffffff, 0xfffc5b3b, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_astio msub, 0x80000000, 0x00000000, 0x9ffffffe, 0x00000000, 0x3ffffffc, 0x80000000, 0x0, 0x0
	dspck_astio msub, 0xc0000000, 0x00000007, 0xf333332d, 0x0000000d, 0x8000000f, 0x66666666, 0x0, 0x0
	dspck_astio msub, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_astio msub, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x00000000, 0x00001c37, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x00000003, 0xffcdb199, 0x80649cd0, 0x7fffffff, 0x00649ccd, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x000c297f, 0x00000000, 0x4ef5190e, 0x000035e9, 0xfffe8949, 0x0, 0x0
	dspck_astio msub, 0x7fffffff, 0xffffffff, 0x7f442475, 0x45dedc55, 0x3ffffffe, 0x02ef6e2b, 0x0, 0x0
	dspck_astio msub, 0x7fffffff, 0xfffffffa, 0x7fffffff, 0xfffffffa, 0x00000000, 0x005faa47, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_astio msub, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x0000001f, 0x00000000, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x00000000, 0x3fffffff, 0x80000000, 0x80000000, 0x7fffffff, 0x0, 0x0
	dspck_astio msub, 0xffffffff, 0xfffa8dc5, 0x00000005, 0x7ffa8dc5, 0x0000000b, 0x80000000, 0x0, 0x0
	dspck_astio msub, 0xe0000000, 0x00000001, 0xe0000000, 0x00000001, 0x00000000, 0x00000002, 0x0, 0x0
	dspck_astio msub, 0x0fffffff, 0xfffffffc, 0x00000000, 0x7ffffffc, 0xe0000001, 0x80000000, 0x0, 0x0
	dspck_astio msub, 0xffffffff, 0xfe82a28a, 0x000139ba, 0x7e802f15, 0x7fffffff, 0xfffd8c8b, 0x0, 0x0
	dspck_astio msub, 0xc0000000, 0x00000007, 0xe4924924, 0xb6db6dbd, 0x7fffffff, 0xb6db6db6, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x0000003f, 0xffffffff, 0xfffffc7e, 0xffffffe1, 0xffffffe1, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00003817, 0x00000000, 0x0, 0x0
	dspck_astio msub, 0x80000000, 0x00000000, 0x78000004, 0x0ffffff8, 0x0ffffff8, 0x7fffffff, 0x0, 0x0
	dspck_astio msub, 0xf0000000, 0x00000003, 0xefffd69d, 0x00000003, 0xffffad3a, 0x80000000, 0x0, 0x0
	dspck_astio msub, 0x7fffffff, 0xffffffff, 0x7ffffce3, 0x11ce68e0, 0xc93b28a5, 0xfffff173, 0x0, 0x0
	dspck_astio msub, 0xffffffff, 0xffffff00, 0x1fffffd8, 0x80000680, 0xc000000f, 0x7fffff80, 0x0, 0x0
	dspck_astio msub, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x00000000, 0x7fffffff, 0x0, 0x0
	dspck_astio msub, 0x80000000, 0x0000003f, 0x800003c1, 0xfffc3e3f, 0xfffff87c, 0x7fffff80, 0x0, 0x0
	dspck_astio msub, 0x7fffffff, 0xffffffff, 0x7ea2fc28, 0xce29d0a3, 0x0368899a, 0x66666666, 0x0, 0x0
	dspck_astio msub, 0x00ff00ff, 0x00ff00ff, 0x20ff00fd, 0x40ff0102, 0x7fffffff, 0xc0000003, 0x0, 0x0
	dspck_astio msub, 0xffffffff, 0x0d11f651, 0x1ffffff7, 0x0d11f651, 0x80000000, 0x3ffffff0, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x00000000, 0xffffffff, 0xe0000006, 0xf0000003, 0xfffffffe, 0x0, 0x0
	dspck_astio msub, 0xf0f0f0f0, 0xf0f0f0f0, 0xf0f0f0f0, 0xf0fa3a01, 0x000000c1, 0xfffff3af, 0x0, 0x0
	dspck_astio msub, 0x80000000, 0x00000005, 0x7fe29a0e, 0xc3acbe2d, 0x007597c5, 0x3ffffff8, 0x0, 0x0
	dspck_astio msub, 0x80000000, 0x00000000, 0xbfffffff, 0x00000001, 0x7fffffff, 0x80000001, 0x0, 0x0
	dspck_astio msub, 0xf0000000, 0x00000001, 0xddb6db6d, 0x80000001, 0xdb6db6db, 0x80000000, 0x0, 0x0
	dspck_astio msub, 0xffffff0a, 0x6e28b447, 0xffffff0a, 0x6e28b447, 0x00000000, 0x3ffffffc, 0x0, 0x0
	dspck_astio msub, 0x00000000, 0x00000000, 0xfe38e38e, 0xf71c71cb, 0xf0000007, 0xe38e38e3, 0x0, 0x0
	dspck_astio msub, 0x00000005, 0xe45a1164, 0x00000005, 0xe45560c2, 0xffffffea, 0xffffc96d, 0x0, 0x0
	dspck_astio msub, 0x7fffffff, 0xfffffffc, 0x7ffffffd, 0x20ef7c00, 0xff3686b6, 0xfffffc5a, 0x0, 0x0
	dspck_astio msub, 0xf0000000, 0x00000001, 0xf0000000, 0x00000001, 0xff350964, 0x00000000, 0x0, 0x0
	dspck_astio msub, 0x80000000, 0x00000006, 0x7912cf83, 0x531e45e2, 0x80000006, 0xf2259f06, 0x0, 0x0
	dspck_astio msub, 0xffffffea, 0x7ebf78ed, 0x00001d61, 0x7eb81b2d, 0xffffc512, 0x7fffffe0, 0x0, 0x0
	dspck_astio msub, 0xe0000000, 0x0000000f, 0x1fffffd0, 0x800007cf, 0x8000001f, 0x7fffffc0, 0x0, 0x0
	dspck_astio msub, 0x7fffffff, 0xffffffff, 0x7fffffe4, 0xc71c7233, 0x000000f5, 0x1c71c71c, 0x0, 0x0

	writemsg "[16] Test msubu"
	dspck_astio msubu, 0xffffffff, 0xfffffffe, 0xfffffffe, 0x5000006a, 0x0000001b, 0x0ffffffc, 0x0, 0x0
	dspck_astio msubu, 0x80000000, 0x00000000, 0x40000000, 0x80000000, 0x80000000, 0x7fffffff, 0x0, 0x0
	dspck_astio msubu, 0x80000000, 0x00000000, 0x61000007, 0x60000018, 0xf8000003, 0x1ffffff8, 0x0, 0x0
	dspck_astio msubu, 0x3fffffff, 0xfffffff8, 0x4033111f, 0xff66cca1, 0xfffffffd, 0xffcceee3, 0x0, 0x0
	dspck_astio msubu, 0xffffffff, 0xfffffff9, 0xfffffc18, 0xfffe1447, 0x8000003f, 0x000007ce, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00000006, 0xfffff8ee, 0x000d887a, 0x00000712, 0xfffffe16, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00000000, 0xffffffff, 0x80000004, 0x3ffffffe, 0x00000002, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x000000ff, 0xfffffa5b, 0x01943a30, 0x000005a5, 0xffffb863, 0x0, 0x0
	dspck_astio msubu, 0x0000002d, 0x47f73d6a, 0xc000002d, 0xc7f73d6a, 0x7fffffff, 0x80000000, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00000003, 0x10000005, 0x9000000a, 0xf0000001, 0xfffffff9, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x0024c573, 0xd82d82d8, 0x5b2a75ce, 0xc71c71c7, 0x33333333, 0x0, 0x0
	dspck_astio msubu, 0xc0000000, 0x0000000f, 0xbffffe96, 0x0000044d, 0xfffffffd, 0x0000016a, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00000000, 0x999999bb, 0x99999978, 0x66666666, 0xffffffac, 0x0, 0x0
	dspck_astio msubu, 0xffffffff, 0xffffffdc, 0xffffffff, 0xffffffdc, 0xfffffff0, 0x00000000, 0x0, 0x0
	dspck_astio msubu, 0x80000000, 0x00000000, 0x40000000, 0x80000000, 0x80000000, 0x7fffffff, 0x0, 0x0
	dspck_astio msubu, 0xff00aefd, 0x73c61dca, 0xff00aefd, 0x73c61dca, 0x00000000, 0x71c71c71, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x1c21e374, 0x00078a61, 0x8f65ee53, 0xffffed27, 0xfff88877, 0x0, 0x0
	dspck_astio msubu, 0x1fffffff, 0xfffffffe, 0x1fffffff, 0xfffffffe, 0x7ffffff9, 0x00000000, 0x0, 0x0
	dspck_astio msubu, 0x7fffffff, 0xfffffffe, 0x7ffffa63, 0xfffffffe, 0x00000b38, 0x80000000, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00000000, 0xc0000000, 0xffffffff, 0x7fffffff, 0x7fffffff, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00000000, 0xfffffffa, 0x00000000, 0x0000000c, 0x80000000, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00a864d7, 0xffffffff, 0x80a864d8, 0x7fffffff, 0x00000001, 0x0, 0x0
	dspck_astio msubu, 0x80000000, 0x00000000, 0x80f13ad3, 0xb4c73b6a, 0xff0f082b, 0xffffbcc2, 0x0, 0x0
	dspck_astio msubu, 0x80000000, 0x00000000, 0x7fffff8a, 0xbffffc56, 0xe0000007, 0x00000086, 0x0, 0x0
	dspck_astio msubu, 0xffffffff, 0xffffff00, 0xffffffff, 0xffffff00, 0x03428034, 0x00000000, 0x0, 0x0
	dspck_astio msubu, 0x80000000, 0x00000000, 0x801a9902, 0x752788a0, 0xffe60a0d, 0xffff5ce0, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00006cd1, 0x5ffffffb, 0xc0006cd7, 0xe0000007, 0xb6db6db6, 0x0, 0x0
	dspck_astio msubu, 0xffffffff, 0xfffff43b, 0xc0000000, 0xfffff43a, 0x7fffffff, 0x7fffffff, 0x0, 0x0
	dspck_astio msubu, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x00000000, 0x014f0848, 0x0, 0x0
	dspck_astio msubu, 0xe0000000, 0x0000000f, 0xe0ff0118, 0xe718e70f, 0xff00ff00, 0xffffffe7, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x01b4db37, 0x86cce935, 0x34cc1f37, 0xf2662e88, 0x7fffff80, 0x0, 0x0
	dspck_astio msubu, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_astio msubu, 0x00000001, 0xf4f158d0, 0xffffd3eb, 0xa50763f8, 0x0ffffff8, 0x0002c165, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00000000, 0xf8000004, 0x0ffffff8, 0x7fffffff, 0x0ffffff8, 0x0, 0x0
	dspck_astio msubu, 0x80000000, 0x00000004, 0x7ff53653, 0x0015935e, 0x7fffffff, 0x0015935a, 0x0, 0x0
	dspck_astio msubu, 0x1fffffff, 0xfffffff8, 0xa0000003, 0xfffffff2, 0x7fffffff, 0xfffffffa, 0x0, 0x0
	dspck_astio msubu, 0x7fffffff, 0xffffffff, 0x7cff3c20, 0x01e07a6b, 0x0360dc5c, 0xe38e38e3, 0x0, 0x0
	dspck_astio msubu, 0xffffffff, 0xffffff80, 0xff9efe1f, 0x86ae94ae, 0xfffffbf9, 0x006101e2, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00000000, 0xfeee3cb2, 0xf54e5efe, 0x80000005, 0x0223869a, 0x0, 0x0
	dspck_astio msubu, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x00000047, 0x00000000, 0x0, 0x0
	dspck_astio msubu, 0xc0000000, 0x00000003, 0xbffffab0, 0x3fff95c8, 0x00000715, 0xc000000f, 0x0, 0x0
	dspck_astio msubu, 0xffffffff, 0xfffffcd8, 0xffffffff, 0xfffffcd8, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00000000, 0xfffd88ef, 0x7ff623be, 0x0004ee21, 0x80000002, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00000000, 0xffffff14, 0x00000760, 0xfffffff8, 0x000000ec, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00000000, 0xb6db6db7, 0x92492492, 0x92492492, 0x7fffffff, 0x0, 0x0
	dspck_astio msubu, 0xffffffff, 0xfff78198, 0xffffffff, 0xfff78198, 0x00000000, 0xffffffd9, 0x0, 0x0
	dspck_astio msubu, 0x80000000, 0x00000000, 0x40000000, 0xffffffff, 0x7fffffff, 0x7fffffff, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00000000, 0xc0000004, 0x7ffffff8, 0x7fffffff, 0x7ffffff8, 0x0, 0x0
	dspck_astio msubu, 0x7fffffff, 0xffffffff, 0x1acdf530, 0x7fffffff, 0x80000000, 0xca64159f, 0x0, 0x0
	dspck_astio msubu, 0x92492492, 0x49249249, 0x8bb90416, 0x437b1bfc, 0xfffcdb13, 0x0690351f, 0x0, 0x0
	dspck_astio msubu, 0xffffffff, 0xfffffffd, 0x7d6343ec, 0x53978299, 0xb6db6db6, 0xb6db6db6, 0x0, 0x0
	dspck_astio msubu, 0xc0000000, 0x0000001f, 0xc0000000, 0x0000001f, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_astio msubu, 0xffea00a9, 0xf7eb41a7, 0x7fea00a9, 0x77eb41ad, 0x80000002, 0xfffffffd, 0x0, 0x0
	dspck_astio msubu, 0x0b47cc33, 0x3510a0e5, 0x0b47cbb4, 0x3510b4bd, 0xffffffd8, 0x0000007f, 0x0, 0x0
	dspck_astio msubu, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00000000, 0xfffff680, 0x00000980, 0xcccccccc, 0x00000be0, 0x0, 0x0
	dspck_astio msubu, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x00000000, 0x0b2a79ab, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00000000, 0xfffd7998, 0x00000000, 0x00050cd0, 0x80000000, 0x0, 0x0
	dspck_astio msubu, 0xdb6db6db, 0x6db6db6d, 0xe8954ab2, 0x2bf0f853, 0xf2d86c2e, 0xfffffffb, 0x0, 0x0
	dspck_astio msubu, 0x1fffffff, 0xfffffff0, 0x1ffffe6b, 0x0000031a, 0x0000032a, 0x7fffffff, 0x0, 0x0
	dspck_astio msubu, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x3fffffe0, 0x00000000, 0x0, 0x0
	dspck_astio msubu, 0x0000002c, 0x8355afca, 0xecb3afa1, 0x32a2bafe, 0xfffffc14, 0x134c50d7, 0x0, 0x0
	dspck_astio msubu, 0x80000000, 0x00000005, 0x80000000, 0x00000005, 0x00000000, 0x00000005, 0x0, 0x0
	dspck_astio msubu, 0xffffffff, 0xfffffffe, 0x90000000, 0x5fffffff, 0x7fffffff, 0xe0000001, 0x0, 0x0
	dspck_astio msubu, 0x0000002e, 0x8910ff07, 0x3e88c452, 0x32ed3447, 0xf8bddf40, 0xc71c71c7, 0x0, 0x0
	dspck_astio msubu, 0x7fffffff, 0xffffffff, 0x7fff8000, 0x807fff7f, 0x0000ffff, 0x7fffff80, 0x0, 0x0
	dspck_astio msubu, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0xe0000003, 0x00000000, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x0000000f, 0x00000000, 0x0000000f, 0x3ffffffc, 0x00000000, 0x0, 0x0
	dspck_astio msubu, 0x00003c56, 0x66ba1b00, 0xfffeb6c9, 0xe4bbb236, 0x03f623ee, 0x00625583, 0x0, 0x0
	dspck_astio msubu, 0x7fffffff, 0xfffffffa, 0x05b47cf7, 0xfffffffa, 0x80000000, 0xf4970610, 0x0, 0x0
	dspck_astio msubu, 0x7fffffff, 0xffffffff, 0x03fffffe, 0x7fffffff, 0xf8000003, 0x80000000, 0x0, 0x0
	dspck_astio msubu, 0xffffffff, 0xffffff9e, 0xffffffff, 0xffffff9e, 0x00000000, 0x80000001, 0x0, 0x0
	dspck_astio msubu, 0x7fffffff, 0xffffffff, 0x7d2dc9b2, 0x85a46c9a, 0x7fffffff, 0x05a46c9b, 0x0, 0x0
	dspck_astio msubu, 0xffffffff, 0xf9d26b9a, 0xffffffff, 0xf9d26b9a, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00000021, 0x00000000, 0x00000021, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_astio msubu, 0xcccccccc, 0xcccccccc, 0xcccccccc, 0xcccccccc, 0x00000002, 0x00000000, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x0002eabb, 0x00000000, 0x0002eabb, 0x0000052b, 0x00000000, 0x0, 0x0
	dspck_astio msubu, 0x7fffffff, 0xffffffff, 0x78787878, 0x7fffffff, 0x80000000, 0x0f0f0f0f, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x0000006a, 0x00000000, 0x0000006a, 0x00000000, 0x020d49cd, 0x0, 0x0
	dspck_astio msubu, 0x00000007, 0xe3d2235c, 0x80037b0a, 0x63cb2d59, 0x7fffffff, 0xfff909fd, 0x0, 0x0
	dspck_astio msubu, 0xf0000000, 0x00000007, 0x7000000d, 0xffffffed, 0x7fffffff, 0xffffffe6, 0x0, 0x0
	dspck_astio msubu, 0xf8fd8899, 0x17f7689f, 0x790b6de2, 0x17db9e0f, 0x7fffffff, 0xffe43570, 0x0, 0x0
	dspck_astio msubu, 0x7fffffff, 0xffffffe0, 0x7fffffef, 0x5fffff5b, 0xe0000007, 0x00000013, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x0000003f, 0x00000000, 0x0000003f, 0xfffc0247, 0x00000000, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x037abdc8, 0xffffffce, 0x037b157a, 0x00000032, 0xfffffe3f, 0x0, 0x0
	dspck_astio msubu, 0xffffffa7, 0xc03cb715, 0xffffffa7, 0xc03cb715, 0x7ffffffb, 0x00000000, 0x0, 0x0
	dspck_astio msubu, 0x80000000, 0x00000000, 0x49249249, 0x80000000, 0x6db6db6d, 0x80000000, 0x0, 0x0
	dspck_astio msubu, 0x0000dfb5, 0x3c0a7bea, 0xc000df95, 0xbc0a7bea, 0x80000000, 0x8000003f, 0x0, 0x0
	dspck_astio msubu, 0xffffffff, 0xffffffff, 0x80008be1, 0x7ffee83e, 0xfffee83f, 0x7fffffff, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x1c825747, 0x80000004, 0x1c825741, 0xfffffffe, 0x7ffffffd, 0x0, 0x0
	dspck_astio msubu, 0x7fffffff, 0xffffffff, 0x7fffb021, 0x8009fbcf, 0x7ffffff0, 0x00009fbd, 0x0, 0x0
	dspck_astio msubu, 0xedef3c52, 0x66e53cae, 0xedef3c52, 0x66e53cae, 0xfffffaad, 0x00000000, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xcccccccc, 0x0, 0x0
	dspck_astio msubu, 0x7fffffff, 0xffffffff, 0xf1c71c73, 0xaaaaaaa9, 0xfffffffd, 0x8e38e38e, 0x0, 0x0
	dspck_astio msubu, 0x80000000, 0x00000000, 0x7fffbad6, 0x00008a54, 0x00008a54, 0x7fffffff, 0x0, 0x0
	dspck_astio msubu, 0x0fffffff, 0xfffffffe, 0x0fffffff, 0xfffffff5, 0x00000003, 0x00000003, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00000002, 0xffffffff, 0xffffff29, 0x00000007, 0x0000001f, 0x0, 0x0
	dspck_astio msubu, 0x80000000, 0x00000000, 0x7fffc37c, 0xfff8e8a6, 0x8000000f, 0x00007906, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00000001, 0xbfffffff, 0x00000004, 0x80000003, 0x7fffffff, 0x0, 0x0
	dspck_astio msubu, 0xfffe15e3, 0x7cbb8090, 0xfffe15e3, 0x7cbb8090, 0x00000000, 0x80000000, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00000000, 0xffffff87, 0x25a94cb1, 0x0000007f, 0xf39be531, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00000000, 0xffff540a, 0x1f38cb1c, 0x00759396, 0x01766916, 0x0, 0x0
	dspck_astio msubu, 0x7fffffff, 0xfffffffe, 0x7fffffff, 0xfffffffe, 0x8000001f, 0x00000000, 0x0, 0x0
	dspck_astio msubu, 0xffffffff, 0xfa217d54, 0xc0000000, 0xfa217d53, 0x7fffffff, 0x7fffffff, 0x0, 0x0
	dspck_astio msubu, 0xffffffff, 0xf419bc42, 0xffffffff, 0xf419bc42, 0x00000000, 0x000002df, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00000007, 0x7ffffff2, 0x00000025, 0x8000000f, 0xfffffffe, 0x0, 0x0
	dspck_astio msubu, 0xfbb0eec1, 0x328b488a, 0xfbb0ee7d, 0xb28b488a, 0x00000087, 0x80000000, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00000000, 0x800001c8, 0x80000000, 0xfffffc6f, 0x80000000, 0x0, 0x0
	dspck_astio msubu, 0x1fffffff, 0xfffffff8, 0x1fffffff, 0xfffffff8, 0xf0f0f0f0, 0x00000000, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00008301, 0xc0000011, 0x80008285, 0x3ffffffe, 0xffffffc2, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x0000003f, 0x00000000, 0x0000003f, 0xfffffa2e, 0x00000000, 0x0, 0x0
	dspck_astio msubu, 0x7fffffff, 0xffffffc0, 0x38e38e38, 0xffffffc0, 0x80000000, 0x8e38e38e, 0x0, 0x0
	dspck_astio msubu, 0x0000ffff, 0x0000ffff, 0xfc010000, 0x0800fffd, 0x07fffffe, 0x7fffffff, 0x0, 0x0
	dspck_astio msubu, 0xffffffff, 0xfffffffb, 0xffffffff, 0xfffffffb, 0x00000000, 0x00000291, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00001e54, 0xffffef77, 0x1b663fd4, 0x0072a780, 0x0024eb33, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00000000, 0xffe661c3, 0x00ccf1e8, 0x00199e3d, 0xfffffff8, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_astio msubu, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x00000000, 0x7ffffffa, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00000000, 0xf684bda1, 0x5ed097b4, 0x1c71c71c, 0x55555555, 0x0, 0x0
	dspck_astio msubu, 0x80000000, 0x00000000, 0xfffffffc, 0x00000018, 0x80000006, 0xfffffffc, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x0000000f, 0xfffa81d7, 0x800afc60, 0x7fffffff, 0x000afc51, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00000000, 0x9ffffff0, 0x80000000, 0xc000001f, 0x80000000, 0x0, 0x0
	dspck_astio msubu, 0x80000000, 0x00000000, 0x7fffffff, 0x0000516f, 0x00000001, 0xffffae91, 0x0, 0x0
	dspck_astio msubu, 0x000000f8, 0x56399121, 0xfe526437, 0x2d07f221, 0x3fffffe0, 0x06b67308, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00163269, 0x00000000, 0x0, 0x0
	dspck_astio msubu, 0xffffffff, 0xfffffffe, 0xffffffff, 0xfffff815, 0x0000002d, 0x0000002d, 0x0, 0x0
	dspck_astio msubu, 0x7fffffff, 0xffffffff, 0x40000000, 0x7fffffff, 0x7fffffff, 0x80000000, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x0000000b, 0xe6666665, 0x199999a6, 0x80000007, 0x33333333, 0x0, 0x0
	dspck_astio msubu, 0xf0000000, 0x00000001, 0xf0000000, 0x00000001, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_astio msubu, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x00000000, 0x7fffffff, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x0eb04dcd, 0x80000003, 0x0eb04dcd, 0xfffffffa, 0x80000000, 0x0, 0x0
	dspck_astio msubu, 0xffffffff, 0x9ebb1b6a, 0x800007f5, 0x1ebb0b81, 0x7fffffff, 0xfffff017, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00000007, 0xfc4309df, 0x9439d5d5, 0xfca63823, 0x03c9a726, 0x0, 0x0
	dspck_astio msubu, 0xffffffff, 0xffffffc5, 0xc0000000, 0x7fffffc5, 0x7fffffff, 0x80000000, 0x0, 0x0
	dspck_astio msubu, 0xfffffffe, 0x61915789, 0xfffffffd, 0x94c48abd, 0xcccccccc, 0x00000001, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x0000007f, 0xc0000001, 0x0000007e, 0x7fffffff, 0x7fffffff, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00000000, 0x80000004, 0x00000000, 0xfffffff8, 0x80000000, 0x0, 0x0
	dspck_astio msubu, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0xf8000001, 0x00000000, 0x0, 0x0
	dspck_astio msubu, 0x03ffffff, 0xfffffffe, 0x03fffee9, 0x00000115, 0x00000117, 0xffffffff, 0x0, 0x0
	dspck_astio msubu, 0xf8000000, 0x00000001, 0x7800052a, 0x00000001, 0x80000000, 0xfffff5ac, 0x0, 0x0
	dspck_astio msubu, 0x3fffffff, 0xfffffffc, 0x3fffffff, 0xfffffffc, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x0000007f, 0xffafa9bf, 0x4dec9e1f, 0xff982958, 0x005076e4, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00000003, 0xff08f708, 0xf700ff04, 0x00ff00ff, 0xf8000001, 0x0, 0x0
	dspck_astio msubu, 0x71c71c71, 0xc71c71c7, 0xf9c71c54, 0x371c71a8, 0xf0000001, 0x8000001f, 0x0, 0x0
	dspck_astio msubu, 0xfffff80f, 0x720bafb1, 0xbffff7ff, 0xf20bafb1, 0x80000000, 0x8000001f, 0x0, 0x0
	dspck_astio msubu, 0xffffffff, 0xfffffffe, 0xffffffea, 0x80000029, 0x7fffffff, 0x0000002b, 0x0, 0x0
	dspck_astio msubu, 0x80000000, 0x00000000, 0x5b6db6db, 0xc9249249, 0x7fffffff, 0x49249249, 0x0, 0x0
	dspck_astio msubu, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x00000000, 0x00004c2b, 0x0, 0x0
	dspck_astio msubu, 0xffffffff, 0xfffffff0, 0xbfffffff, 0xfffffff0, 0x80000000, 0x80000000, 0x0, 0x0
	dspck_astio msubu, 0xffffffff, 0xfffffe88, 0xff807f80, 0x80feff87, 0x00ff00ff, 0x7fffffff, 0x0, 0x0
	dspck_astio msubu, 0x80000000, 0x00000000, 0x69fd40e5, 0x02bf3100, 0x2c057e62, 0x7fffff80, 0x0, 0x0
	dspck_astio msubu, 0x7fffffff, 0xffffffff, 0x40000000, 0xfffffffe, 0x7fffffff, 0x7fffffff, 0x0, 0x0
	dspck_astio msubu, 0x7fffffff, 0xffffffff, 0x3fffffff, 0xffffffff, 0x80000000, 0x80000000, 0x0, 0x0
	dspck_astio msubu, 0x80000000, 0x00000000, 0x40000000, 0x00000000, 0x80000000, 0x80000000, 0x0, 0x0
	dspck_astio msubu, 0xffff7e92, 0xa1fd60f7, 0xffff7e92, 0xa1fd60f7, 0xfffffd0e, 0x00000000, 0x0, 0x0
	dspck_astio msubu, 0x0fffffff, 0xfffffff8, 0x901ded6e, 0xfffffff8, 0xffc42522, 0x80000000, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00000000, 0xf0000008, 0x1ffffff0, 0x7fffffff, 0x1ffffff0, 0x0, 0x0
	dspck_astio msubu, 0x80000000, 0x00000007, 0x80000000, 0x00000007, 0x00000000, 0xc0000007, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00000005, 0x00000000, 0x00000005, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_astio msubu, 0xffffffff, 0xffffff00, 0x82d2f0f4, 0xfa5a1d18, 0x7fffffff, 0xfa5a1e18, 0x0, 0x0
	dspck_astio msubu, 0xffffffff, 0xffffffe0, 0xffffffff, 0xffffffe0, 0x00000000, 0xc0000003, 0x0, 0x0
	dspck_astio msubu, 0x0000ffff, 0x0000ffff, 0x3c00fff9, 0xc000fff6, 0xe0000003, 0xe0000003, 0x0, 0x0
	dspck_astio msubu, 0x1fffffff, 0xfffffff8, 0x1e000001, 0x03fffff6, 0x7fffffff, 0x03fffffe, 0x0, 0x0
	dspck_astio msubu, 0x07ffffff, 0xfffffffc, 0x0d10b78f, 0x84179a4c, 0xfaef7446, 0xffffd348, 0x0, 0x0
	dspck_astio msubu, 0x80000000, 0x00000000, 0x7ffda82e, 0xaf39f01f, 0x00026b1b, 0xf80644b3, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x1c26803b, 0xfffffff5, 0xe342f214, 0x00000017, 0x71c71c71, 0x0, 0x0
	dspck_astio msubu, 0xffffffff, 0xfffffd1d, 0x00087aa1, 0x52b385fb, 0xffff4463, 0xfff840f6, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_astio msubu, 0x00062960, 0x142d3efc, 0x00062783, 0x5f5768c0, 0x0e0fa864, 0x000021e7, 0x0, 0x0
	dspck_astio msubu, 0x2dc9effb, 0x5078e410, 0xedc9effb, 0xd078e410, 0x80000000, 0x7fffffff, 0x0, 0x0
	dspck_astio msubu, 0x24924924, 0x92492492, 0xa49670c7, 0x12492492, 0x80000000, 0xfff7b0bb, 0x0, 0x0
	dspck_astio msubu, 0xffffffff, 0xffffff00, 0xffffb5d7, 0xffffff00, 0x00009450, 0x80000000, 0x0, 0x0
	dspck_astio msubu, 0x80000000, 0x00000000, 0x40000000, 0x80000000, 0x80000000, 0x7fffffff, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x01de74e5, 0xffffff3d, 0x01de75a8, 0xffffffff, 0x000000c3, 0x0, 0x0
	dspck_astio msubu, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_astio msubu, 0xffffffff, 0xfffffff9, 0xc0000034, 0xbffffe63, 0xffffff35, 0x3ffffffe, 0x0, 0x0
	dspck_astio msubu, 0x80000000, 0x00000006, 0x80000000, 0x00000006, 0x00000000, 0x0040f4c3, 0x0, 0x0
	dspck_astio msubu, 0xffffffff, 0xfffa1f46, 0x00982f95, 0xa16156d4, 0xffffcb29, 0xff680522, 0x0, 0x0
	dspck_astio msubu, 0x80000000, 0x00000000, 0x00000001, 0x7fffffff, 0x7fffffff, 0xffffffff, 0x0, 0x0
	dspck_astio msubu, 0xffffffff, 0xffc8ba9c, 0xffffffff, 0xffc8ba9c, 0xffffff80, 0x00000000, 0x0, 0x0
	dspck_astio msubu, 0xf8000000, 0x00000003, 0xf7ff872e, 0x48123473, 0x00afde54, 0x00afde54, 0x0, 0x0
	dspck_astio msubu, 0x1fffffff, 0xfffffff8, 0xdffffffe, 0xfffffffb, 0x80000003, 0x7fffffff, 0x0, 0x0
	dspck_astio msubu, 0x80000000, 0x00000001, 0x7fffe3d7, 0x00070a41, 0xffffffc0, 0x00001c29, 0x0, 0x0
	dspck_astio msubu, 0xfffe2dd6, 0xf11a0080, 0xffc086f1, 0xf11a0080, 0x007b4dca, 0x80000000, 0x0, 0x0
	dspck_astio msubu, 0xffffffff, 0xffffff27, 0xffffffff, 0xffffff27, 0x00000000, 0xffffff80, 0x0, 0x0
	dspck_astio msubu, 0xffffffff, 0xffcee797, 0x01022826, 0xd8f29997, 0xfffcd5b2, 0xff00ff00, 0x0, 0x0
	dspck_astio msubu, 0x7fffffff, 0xffffffff, 0x60000009, 0x3fffffaf, 0x3ffffff0, 0x7ffffffb, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00000001, 0xc0000001, 0x00000000, 0x7fffffff, 0x7fffffff, 0x0, 0x0
	dspck_astio msubu, 0x80000000, 0x00000000, 0x7ffffffb, 0x00000140, 0x00000005, 0xffffffc0, 0x0, 0x0
	dspck_astio msubu, 0x7fffffff, 0xfffffff8, 0x7fffffe0, 0x80000037, 0x7fffffff, 0x0000003f, 0x0, 0x0
	dspck_astio msubu, 0x00001fa6, 0x773631a4, 0xe0001fb7, 0x77363124, 0xfffffff8, 0x1ffffff0, 0x0, 0x0
	dspck_astio msubu, 0x80000000, 0x00000000, 0x8012ee16, 0x11d80000, 0xffee11d8, 0xffff0000, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00000000, 0xc0000002, 0x80000000, 0x80000000, 0x7ffffffb, 0x0, 0x0
	dspck_astio msubu, 0x80000000, 0x00000000, 0x7fffffff, 0xfcb57eb7, 0x00000003, 0x0118d5c3, 0x0, 0x0
	dspck_astio msubu, 0x00000003, 0x351ff10a, 0x00000003, 0x351ff10a, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00001365, 0xffffffba, 0x66667a11, 0x66666666, 0x000000ae, 0x0, 0x0
	dspck_astio msubu, 0x000004b1, 0x69983cd9, 0xe00004b5, 0x69983cd9, 0x3ffffff8, 0x80000000, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x0000036e, 0x8005a241, 0xffbc689e, 0xfff4bb88, 0x7ffffffa, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00000000, 0xfffffffe, 0x00000000, 0x00000004, 0x80000000, 0x0, 0x0
	dspck_astio msubu, 0x80000000, 0x00000000, 0x7ffffff1, 0x00000780, 0x00000078, 0x1ffffff0, 0x0, 0x0
	dspck_astio msubu, 0xc0000000, 0x00000001, 0xbff9dd5f, 0x57ed0020, 0x0006554b, 0xf8000003, 0x0, 0x0
	dspck_astio msubu, 0xfc000000, 0x00000001, 0xfc000000, 0x00000001, 0x00000000, 0x1c71c71c, 0x0, 0x0
	dspck_astio msubu, 0x3fffffff, 0xfffffff8, 0x801f172c, 0x407c5cb5, 0xc0000003, 0xffd68bc1, 0x0, 0x0
	dspck_astio msubu, 0x80000000, 0x00000000, 0x7fffffff, 0xfffd8b22, 0x00000766, 0x00000055, 0x0, 0x0
	dspck_astio msubu, 0x80000000, 0x00000000, 0x7fffffff, 0xff67190d, 0x0000001f, 0x0004eead, 0x0, 0x0
	dspck_astio msubu, 0x80000000, 0x00000000, 0x7fffda51, 0x1ffd7a01, 0x00002b11, 0xe000000f, 0x0, 0x0
	dspck_astio msubu, 0xfd5d4c43, 0xa13b6134, 0xfd5d4c37, 0xa13b60d4, 0x80000004, 0x00000018, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00000000, 0xffffffff, 0xffff1d1f, 0x000000f1, 0x000000f1, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00000001, 0xfffb94e3, 0x80000001, 0x80000000, 0x0008d639, 0x0, 0x0
	dspck_astio msubu, 0xffffffff, 0xfffffff0, 0xffffffe2, 0x0000002c, 0x7fffffff, 0x0000003c, 0x0, 0x0
	dspck_astio msubu, 0x00070e03, 0x97f7a85b, 0x00070e03, 0x97f7a85b, 0x00000000, 0xfffffff2, 0x0, 0x0
	dspck_astio msubu, 0xf8000000, 0x00000001, 0xf7ffff44, 0x80000178, 0x00000177, 0x7fffffff, 0x0, 0x0
	dspck_astio msubu, 0x0fffffff, 0xfffffff8, 0x0fffffff, 0xfffffff8, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x011306b6, 0xfffffff9, 0x011307dc, 0xffffffd6, 0x00000007, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xfffffffb, 0x00000000, 0x0, 0x0
	dspck_astio msubu, 0xf8000000, 0x00000003, 0xb8000010, 0x7fffffe3, 0x7fffffff, 0x7fffffe0, 0x0, 0x0
	dspck_astio msubu, 0x80000000, 0x00000000, 0x7fffffff, 0x7fffff81, 0x8000007f, 0x00000001, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x8d897496, 0xbffffffe, 0x0d89749c, 0x7fffffff, 0x80000006, 0x0, 0x0
	dspck_astio msubu, 0xffffffff, 0xffffffe4, 0xff4bf0eb, 0xdf3237cd, 0x00cdc817, 0xe0000001, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00000001, 0x00000000, 0x00000001, 0x0000e84e, 0x00000000, 0x0, 0x0
	dspck_astio msubu, 0xffffffff, 0xffffffec, 0xc0000000, 0x7fffffec, 0x7fffffff, 0x80000000, 0x0, 0x0
	dspck_astio msubu, 0xe0000000, 0x0000000f, 0xa0000000, 0x0000000f, 0x80000000, 0x80000000, 0x0, 0x0
	dspck_astio msubu, 0xfc000000, 0x00000001, 0xfb3ab669, 0xa8bb517e, 0xffff27bf, 0x00c54a3d, 0x0, 0x0
	dspck_astio msubu, 0xffffffff, 0xfc2218ff, 0xffffd159, 0x7c22764c, 0x00005d4d, 0x7fffffff, 0x0, 0x0
	dspck_astio msubu, 0x1fffffff, 0xfffffff0, 0x1fffffff, 0xfffffff0, 0x00000000, 0x000004f5, 0x0, 0x0
	dspck_astio msubu, 0xffefbf40, 0x178f5a0d, 0xffefbf40, 0x178f5a0d, 0x00000000, 0x0007af70, 0x0, 0x0
	dspck_astio msubu, 0xffffff8e, 0x6d14471f, 0x0000b5d1, 0x6d027d05, 0xffffffe7, 0xffff49d6, 0x0, 0x0
	dspck_astio msubu, 0x0fffffff, 0xfffffffc, 0x0fffffff, 0xfffffffc, 0x00000000, 0x7ffffffa, 0x0, 0x0
	dspck_astio msubu, 0x55555555, 0x55555555, 0xd55eecdd, 0xd089b115, 0x7fffffc0, 0xffecd16f, 0x0, 0x0
	dspck_astio msubu, 0x80000000, 0x00000001, 0x0de281a2, 0x80000001, 0xe43afcbb, 0x80000000, 0x0, 0x0
	dspck_astio msubu, 0xf0000000, 0x00000003, 0xf0000000, 0x00000003, 0x00000000, 0xffff0000, 0x0, 0x0
	dspck_astio msubu, 0xdb6db6db, 0x6db6db6d, 0xdb6db6db, 0x6db6db6d, 0x00000000, 0xfffc600b, 0x0, 0x0
	dspck_astio msubu, 0x71c71c71, 0xc71c71c7, 0x71c715e5, 0x578ae7e5, 0x068c761e, 0x0000ffff, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00000000, 0xfffff29a, 0x9fff9bfa, 0xf0000007, 0x00000e4a, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00000000, 0x029e7524, 0x48ac0b06, 0xfd618b21, 0xffffffba, 0x0, 0x0
	dspck_astio msubu, 0xc0000000, 0x0000000f, 0xc0000000, 0x0000000f, 0x00000000, 0x80000000, 0x0, 0x0
	dspck_astio msubu, 0x7fffffff, 0xffffffff, 0x00000003, 0xfffffff9, 0xfffffffa, 0x7fffffff, 0x0, 0x0
	dspck_astio msubu, 0x7fffffff, 0xffffffff, 0x7fffee3b, 0x00004713, 0xfffffffc, 0x000011c5, 0x0, 0x0
	dspck_astio msubu, 0x80000000, 0x00000000, 0x40000000, 0x00000000, 0x80000000, 0x80000000, 0x0, 0x0
	dspck_astio msubu, 0x0000045a, 0xedef9a30, 0xc0000457, 0xedef9a30, 0x80000006, 0x80000000, 0x0, 0x0
	dspck_astio msubu, 0x7fffffff, 0xffffffff, 0x7d39892c, 0x058ceda7, 0x7fffffff, 0x058ceda8, 0x0, 0x0
	dspck_astio msubu, 0xffffffff, 0xff9aa03c, 0xc0000000, 0x7f9aa03c, 0x80000000, 0x7fffffff, 0x0, 0x0
	dspck_astio msubu, 0xc71c71c7, 0x1c71c71c, 0xae413bc4, 0x32fef829, 0x18db3689, 0xfffffa9b, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00000009, 0x00000000, 0x00000009, 0x000000c1, 0x00000000, 0x0, 0x0
	dspck_astio msubu, 0xffffffff, 0xfffffff0, 0xc0000000, 0x7ffffff0, 0x80000000, 0x7fffffff, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x0000003f, 0xc0000000, 0x8000003f, 0x80000000, 0x7fffffff, 0x0, 0x0
	dspck_astio msubu, 0x80000000, 0x00000000, 0x00000832, 0x800062a6, 0xffffef8f, 0x80000006, 0x0, 0x0
	dspck_astio msubu, 0x00000000, 0x00000000, 0x000008d4, 0xfff85422, 0xffffff06, 0xfffff825, 0x0, 0x0
	dspck_astio msubu, 0x00447ca7, 0xb87a4605, 0xc0447ca8, 0x387a4605, 0x80000000, 0x7fffffff, 0x0, 0x0

	writemsg "[17] Test mul.ph"
	dspck_dstio mul.ph, 0x00007f5b, 0x000000a5, 0x00007fff, 0x0, 0x00200000
	dspck_dstio mul.ph, 0x00008001, 0x0000ffff, 0x0f0f7fff, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x3ff90000, 0xffff7fff, 0xc0070000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00007fff, 0x00040001, 0x00007fff, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00008000, 0x80008000, 0x800000f5, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x7fc1fb98, 0xffff7fff, 0x803f0468, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0xffe00000, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x0000ff60, 0x80000014, 0x0000fff8, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0xa9400000, 0xff5b0000, 0x7fc00000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x001028e0, 0x7fff00b9, 0xfff03fe0, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x149c0000, 0xfe340000, 0x00837fff, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x9ff10000, 0x7fff3fc0, 0xe00f8000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0xfe80ffc0, 0x7fc0ffc0, 0x80060001, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00108001, 0x7fffffff, 0xfff07fff, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0x00000000, 0x7fff000e, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0x00000000, 0x00000003, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x8000a010, 0x800003fe, 0x083d1ff8, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x8b100001, 0xc71c7fff, 0xc71c7fff, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0x00000000, 0x000b0fae, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x0000016e, 0x8000ffc3, 0x000efffa, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0xdda40000, 0x1ffc7fff, 0x00970000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x1e6e0000, 0xfffbf5ae, 0xf9ea8000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x0000df90, 0x00000ed4, 0x00000ed4, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0x00040000, 0x80000007, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0x7ffecccc, 0x80008000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0x00000000, 0x7fff0000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0xa00c7fe7, 0xfffafffb, 0x0ffe8005, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0xfffe0000, 0x00010000, 0xfffe0000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0x7ffffffe, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00199a8d, 0x0005ffd3, 0x0005e01f, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00007ffd, 0xf0f07fff, 0x00000003, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00007fe1, 0x80007fff, 0x0000001f, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x0000ffa0, 0xfc12fffc, 0x00000018, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x5cc0c390, 0x3fc007fc, 0x038dc71c, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00008000, 0x00008000, 0x00003333, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x1d560000, 0xffff8000, 0xe2aafffe, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0xfd917fdb, 0xffa70025, 0x00077fff, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x018c7808, 0xff9d00ff, 0xfffc7ff8, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x0000fe56, 0x000001aa, 0xf2ec7fff, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x63348000, 0x33338000, 0x0ffc7fff, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x000e0000, 0x80070efd, 0x00020000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0xc003001f, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x0c780000, 0xf3880000, 0x7fff0a2d, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0xffe06db4, 0x7ff00005, 0x80024924, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00020000, 0x7fff8000, 0xfffe0000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00006d1c, 0x0000010f, 0x7fff4924, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x8003f002, 0xfffd0ffe, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0xffd61dc4, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x08ae0000, 0xf752b6db, 0x7fff0000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00008000, 0x00000069, 0x09bc8000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0x00000000, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x80008000, 0x800029b1, 0x33338000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x01007004, 0x7fc007fe, 0x03fc3ffe, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x80000000, 0xf3290000, 0x8000ff07, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x3ff64008, 0x00051ffe, 0x3ffe1ffc, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x7fffe200, 0x7ffffe20, 0x00010010, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x6feb8000, 0xfff9ffff, 0xf0038000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0x00000000, 0xff8007e7, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0xd1be042a, 0xfe82ffff, 0x001ffbd6, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x7ff70000, 0xfffd0000, 0x8003c007, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0x00057fff, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00007ff2, 0x00008002, 0x7ffafff9, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00400000, 0x7fff0000, 0xffc01967, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x80020000, 0x7ffa0003, 0x55550000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0x00000000, 0xfba27ffc, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x8000fc00, 0x0003ff00, 0x80000004, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0xc9ae0e0e, 0xed290002, 0x03fe0707, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0x80000000, 0x00008000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x80006170, 0x7ffff75d, 0x80000030, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x33340000, 0x7ffe8000, 0x66660024, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0x00000000, 0x001affff, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x80008007, 0xf001fff9, 0x80007fff, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x6790e21f, 0x1ffc00ff, 0x061cfee1, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0x00008000, 0x7fff8000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x60ae0000, 0xf0030000, 0x003a8000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00009248, 0x80004924, 0x80008002, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0xaa568000, 0x807ffff3, 0xaaaa8000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x55c00001, 0xffa9ffff, 0x3fc0ffff, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0xfe900000, 0x01707ffe, 0x7fff8000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0xfe707fc1, 0xfe707fff, 0xe001003f, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x609f0000, 0x00fffffc, 0x00610000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0xfe800000, 0x80060000, 0x7fc0ff00, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x80001ff9, 0x8000ffff, 0x7fffe007, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0x00000005, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0xedc08000, 0x00498000, 0xffc0005d, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x3627b261, 0xf627c001, 0xc001f261, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00007f8d, 0xfda17fff, 0x00000073, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x80000000, 0xffff0000, 0x80008000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x80007efd, 0x80008007, 0xffc9ffdb, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0x80007fe0, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x804b0000, 0x7fff8000, 0xffb50000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x86880000, 0x8e38c001, 0xe8a70000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x000083ff, 0xfffafc01, 0x00007fff, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x2146fede, 0x7fff0091, 0xdebafffe, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000002, 0x00007fff, 0x0000fffe, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00004009, 0x0000e003, 0x0000e003, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0xff100000, 0xfff0eebe, 0x800f0000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x8000fb52, 0x8000ffff, 0x02b104ae, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0xfffb000e, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x80068000, 0x80020189, 0x00038000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x8000edb8, 0x7fff7ff8, 0x80009249, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x74272ae8, 0x7fff2aa3, 0x0bd97ff8, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x05ee0000, 0x00010000, 0x05eeffe7, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0xffc1b080, 0x803f009f, 0x7fffff80, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x8000e4a0, 0x7ffbb6db, 0x80003fe0, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x81c0fc28, 0xfff97fff, 0x7fc003d8, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x80008005, 0x80007fff, 0x8003fffb, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00008000, 0xffff0003, 0x00008000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0xe8188000, 0xffe871c7, 0x00ff8000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x5520000a, 0x0357fffe, 0x3fe0fffb, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0xfcb0fff4, 0x7fff0003, 0x0350fffc, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x0000ffc7, 0x00020039, 0x0000ffff, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00003ffd, 0x0000c003, 0xfff2ffff, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x1c720048, 0x7fff0018, 0xe38ec003, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x0000abc5, 0x8000fe95, 0xfff01c71, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00314000, 0x7ff97f80, 0x7ff97f80, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x2d9a0000, 0x0ffe8006, 0x01338000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x08000000, 0xff000329, 0xfff80000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x7fa0ffa4, 0x8003002e, 0x7fe0fffe, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x11aefed6, 0x001f7fff, 0x0092012a, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0xebf37e20, 0xfffde00f, 0x06af7fe0, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x7fdfc01c, 0x0021f007, 0x7fff0004, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0xffa050a0, 0x00061fe0, 0xfff0007b, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00008000, 0x7fff8000, 0x0000f803, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0xb6d50000, 0x000f000b, 0xb6db0000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0x00000000, 0xffe07fff, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0xbff10070, 0xc00f03f9, 0x7fff3ff0, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0xff6e0000, 0x7ffffcb1, 0x00920000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00008031, 0x8000c007, 0x8000c007, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0xdc718000, 0x1c717fff, 0xc0018000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0x06e88000, 0x0000fb00, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x7ffd0040, 0x0003ffe0, 0x7fff07fe, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x8000e9e1, 0x00091c71, 0x80001c71, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0xf4570000, 0xfdab0000, 0x0005fff9, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x80039ffa, 0xfffdf003, 0x7fff7ffe, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0xffae7a4f, 0x00521abd, 0xfffffffb, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x40e0b95d, 0xfff9ff95, 0x3fe000a9, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000004, 0x00000004, 0xf0f00001, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000096, 0x0000ffe2, 0xff80fffb, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000f61, 0x7fff807f, 0x0000801f, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0x0000fff0, 0xfda48000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0xfe440004, 0xfffeffff, 0x00defffc, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x0006139d, 0xffff04c3, 0xfffa801f, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0x3ff00000, 0x00000f3d, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00008000, 0xdf11fc0f, 0x00008000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00070000, 0x7ff98000, 0x7fff0002, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x7ff70000, 0x7ffd8000, 0x00030000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x38038000, 0xf8037fff, 0xc0018000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0x0000f007, 0x00010000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x7fcf7ecf, 0x7ff97fff, 0x00070131, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x006c0000, 0xfffd8000, 0xffdc036c, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0xd3540002, 0xe01f0002, 0xf22c0001, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x1f001485, 0xff08eed7, 0x3fe0f803, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0x0ffefff8, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x43dc7fdd, 0x1f74fffb, 0x38e38007, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0x00000c84, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x463c0000, 0x02440000, 0x801f0000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00009ff1, 0xffeb7fff, 0x0000e00f, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x7ffbc004, 0x7fff0ffe, 0x00050ffe, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00007fe1, 0x00ffffff, 0x0000801f, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x9ffdffb2, 0x7fff001a, 0xe003fffd, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00030052, 0xfff9ffae, 0xb6db7fff, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x5980de10, 0x7fc01ff0, 0x0e9ac01f, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0xffb20000, 0x004e007f, 0xffff0000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00004030, 0x00003ff0, 0x1af5fffd, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x800052d0, 0x8000f803, 0x7ffff0f0, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0x8002800f, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x80000000, 0xfffd0000, 0x80000004, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0xea9e0000, 0x002e8000, 0xff890000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x7f806666, 0x1fe06666, 0x00040001, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x0000666c, 0x0000cccc, 0x8000fff9, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0x55550000, 0x0000007f, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0x8004aaaa, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x8000804d, 0x80007fff, 0x7ff9ffb3, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x8000fffe, 0x8000fffe, 0xe0070001, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x80800000, 0x3fc00000, 0x07fe0012, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x0080d486, 0x3fe0f9ca, 0xfffc8007, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x3f460000, 0xe01fb6db, 0x7ffa0000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x7abf21bc, 0x05411ffc, 0x7fffff91, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0x80008000, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0x00000000, 0xf0070000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00060000, 0xfffa0000, 0x7fff06fb, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x0000802a, 0xfffcfff9, 0x80007ffa, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x45538000, 0x1c718000, 0xf003e007, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0x80000000, 0x00f0e003, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00020309, 0xfffeffdb, 0x7fffffeb, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x0000ffff, 0xffc6ffff, 0x80000001, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0x7fff7fff, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x0014fe04, 0xffecfffc, 0xffff807f, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0x7fff8000, 0x0000fe48, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x84448000, 0x80040001, 0x01118000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x80000000, 0x8000ff24, 0xe0070000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0xfa6b2578, 0xffff0008, 0x059504af, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0xd2b48294, 0x0a2e3ffe, 0x6db6feb6, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x63348000, 0x0ffc7fff, 0x33338000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00002110, 0x0000ffa4, 0x0000ffa4, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0xb6dbc1cc, 0x00008000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0xee990000, 0xfe6b1ff8, 0x000b8000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0xff802c9e, 0x0002f9b1, 0xffc01ffe, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0xbf047f97, 0xf0820015, 0x2f027ffb, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x0000f388, 0x80000008, 0x8002fe71, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x0000edd7, 0x8000f007, 0x0000ffb1, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x000031c0, 0x00000039, 0x3ff03fc0, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0xfffaa718, 0xfffefe74, 0x0003fcfe, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00005ee1, 0x800000ff, 0x011ac01f, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0x80000000, 0x06805555, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0x00000000, 0xe41e0000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0x0000ffdf, 0x00230000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0x00000000, 0x00000001, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x8001c925, 0x7fff7fff, 0xffffb6db, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x0010cd3e, 0xfff0e00f, 0xffff00e2, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0xfffc0000, 0xfffc10ab, 0x00010000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x83270000, 0x010d8000, 0x80037fe0, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x1fe47ffb, 0x00720005, 0x0b827fff, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x80030000, 0x7ffffff0, 0xfffd0000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0xbebe13c1, 0xe00705dd, 0xffd20135, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x01000199, 0x7f80f803, 0xfffe3333, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x6a5071b8, 0xf0f00011, 0xff0b8e38, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x0000fe30, 0x0000fff8, 0x13d2003a, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0xffc77fff, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x0980c036, 0x0980f33e, 0xfc010005, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x80007ffb, 0x7fff8005, 0x8000ffff, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00008001, 0x0000ffff, 0x7fff7fff, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0x00000000, 0xf003007f, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0xfffe0099, 0x0002ffcd, 0x7ffffffd, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0xfffa8000, 0x7ffd8000, 0x00021e89, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x0001e2c0, 0x7fffefb2, 0x7fff0060, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00108000, 0x3ffe8000, 0x7ff8ff3f, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0xd4fd0fff, 0xd4fdf001, 0x0001ffff, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0xfffbffa0, 0x80050008, 0x7ffffff4, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0xc001f83c, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0x80007fff, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0x00000000, 0x38e3ffa2, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x80000000, 0x80000000, 0x7fff807f, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0xe0108000, 0xfffe8000, 0x0ff87fff, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x8b103290, 0xc71cf934, 0xc71cf934, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0x7ffff900, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x0a900001, 0x00347fff, 0x00347fff, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0x00000000, 0x8000fffc, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0xfc017fff, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0x00000000, 0xfc110002, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00000000, 0x00008000, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00008000, 0xfd7f8000, 0x00007fff, 0x00200000, 0x00200000
	dspck_dstio mul.ph, 0x00bfa4e5, 0x00bffd6f, 0x000100eb, 0x00200000, 0x00200000

	writemsg "[18] Test mul_s.ph"
	dspck_dstio mul_s.ph, 0x00000000, 0x00000000, 0x012a0007, 0x0, 0x00000000
	dspck_dstio mul_s.ph, 0x80000000, 0x7fff0000, 0x80068000, 0x00000000, 0x00200000
	dspck_dstio mul_s.ph, 0x00007fff, 0x00000f0f, 0x00000f0f, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fffff93, 0xf989006d, 0xdb6dffff, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80008000, 0xc00ffd8a, 0x00061ffe, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80008000, 0x0297fce4, 0xf8037fff, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00008000, 0xf0037fff, 0x0000fffd, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0xe0208000, 0xffff7fff, 0x1fe0e001, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00007fff, 0x0000f003, 0x0000f003, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80000000, 0x7fc00000, 0xf0160000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80007fff, 0x0ffcf400, 0xffc0fa7d, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff0000, 0x7ffff294, 0x38e30000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x8000fff8, 0x0c320001, 0x8000fff8, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80008000, 0xe01f2492, 0x000b8000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00008000, 0x00006666, 0xffeb8006, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00007fff, 0x00009249, 0x8e38fff7, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00008000, 0xfffffedd, 0x000007fc, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff8000, 0x1ff86666, 0x2492f96f, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x8000fb3e, 0x8000ffd6, 0x0ffc001d, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00000000, 0x00000000, 0x3fc00000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff8000, 0xfff7ee64, 0xf00102aa, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80007fff, 0x7fff7fff, 0xfffe7fff, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff8000, 0x7fc05555, 0x7ffffe96, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x0ff97fff, 0xffffffe9, 0xf007e38e, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80000000, 0x00e1ff80, 0xe38e0000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80000440, 0x0006ffbc, 0x9999fff0, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff8000, 0xfffd8000, 0x80007fff, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff153c, 0xfc67f562, 0xff5bfffe, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff8000, 0x1ffec001, 0x001e1ffc, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00007fff, 0x00007fff, 0x92497fff, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00000000, 0x00000000, 0x00013ff0, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff8000, 0xffcd807f, 0xfb80129a, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80000000, 0x7ffd05cc, 0xfea90000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00e17fff, 0x000f7fff, 0x000f7fff, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff807f, 0x7fff807f, 0x3fe00001, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff7fff, 0xfffe7fff, 0x80047fff, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0xf8c78000, 0xf8c7801f, 0x00010ffe, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80000000, 0x7fff0000, 0x8000000e, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80000000, 0xfffd0000, 0x7fffc03f, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80017fff, 0xfffff232, 0x7fff8000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80007fff, 0x7ffe7fff, 0xff800010, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00008000, 0x7fff0003, 0x00008000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0xe91a0000, 0xfc2f0000, 0x0006800f, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00000000, 0x00000000, 0x00630000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff7fff, 0x1ff8001f, 0x7fff7ff0, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff7fff, 0x7fff8000, 0x7fff8000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff0000, 0x80000000, 0xf9400000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80008001, 0x088bffff, 0xfb127fff, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff2888, 0x00be0004, 0x7fff0a22, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00007fff, 0x00000004, 0x800738e3, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80000000, 0x800f0000, 0x0ffc029d, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80008000, 0x7ff0aaaa, 0xf0010002, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80000004, 0x00ca0004, 0xf0030001, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff8000, 0x8000f123, 0xf0017fff, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80008000, 0xfffb8000, 0x7fff7fff, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00000000, 0xe4ee7fff, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff0004, 0xff41fffe, 0xff41fffe, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00007fff, 0x7fff8000, 0x00008000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80007fff, 0x7ffac00f, 0x80078000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80007fff, 0x1ff0e11b, 0x80058000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00000000, 0x8000b6db, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff8000, 0x1ff8fffc, 0x71c77f80, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff0000, 0xff8f0000, 0x800f0000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80008000, 0x80007fff, 0x3ff0fc01, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80007fff, 0x1fe0000f, 0x803f7fff, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff7fff, 0x013dffe0, 0x7ffafa98, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0xf8227fff, 0x00138000, 0xff968000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7ffffaa0, 0x8000fffc, 0xffc60158, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00008000, 0x80077fe0, 0x0000ff53, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00008000, 0x00000004, 0x00798000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80007fff, 0x80007fff, 0x7ffb3fc0, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80007fff, 0x800400ff, 0x7ffe7f80, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80008000, 0x03ce0180, 0xcccc8000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80008000, 0x800f02e4, 0x7fff8000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0xff607ffb, 0x000a8005, 0xfff0ffff, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff0000, 0x7fff0000, 0x71c77ffe, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00000000, 0x00000000, 0x7fff0000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x02258000, 0x00018000, 0x02250001, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff7fff, 0xe007024a, 0xe38e0ce0, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff7fff, 0xf803007f, 0xf0f03ff0, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00007fff, 0x00008000, 0xfd898007, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00007fff, 0x00007ffd, 0x00007ff8, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80007fff, 0x6666009f, 0x800004de, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff8000, 0xf7d4febe, 0xfe107fff, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fffe2cc, 0x7ffffef5, 0x7fff001c, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0xfe500000, 0x00010000, 0xfe507fff, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff0000, 0x80070000, 0xfb560000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80007fff, 0x80006db6, 0x00046666, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff0000, 0x80000000, 0x80007fff, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff0000, 0xffeb0000, 0x92497fff, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80007fff, 0xff003333, 0x7fff7fff, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80000000, 0x7fff0000, 0x80000002, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80000000, 0x7fff0000, 0xfff37fff, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff7fff, 0xffeccccc, 0x8000b6db, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff8000, 0xc00f7fff, 0xffe18000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x8000fa18, 0x7fff00bd, 0x8000fff8, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00000000, 0x00000000, 0x7fff06eb, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80000000, 0x99990000, 0x0005db6d, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80007fff, 0x7ff98000, 0xfffd8000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00007fff, 0xf9a37ffb, 0x00000004, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80000000, 0x00220000, 0xdb6d7ffe, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00107fff, 0x0004f803, 0x0004f803, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff7fff, 0x00050ff8, 0x1c710ff8, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x8000f75a, 0x9249ffff, 0x1c7108a6, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff7fff, 0x7fff00c2, 0x7fff3ff0, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0xfe300000, 0xfffc8000, 0x00740000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80000000, 0xfffb0000, 0x7fff7fc0, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00008000, 0xfffb8000, 0x00007fff, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00007fff, 0x80006db6, 0x00001ff0, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00008004, 0x00000001, 0x80008004, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff7fff, 0x00d10004, 0x02e17fff, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0xccfccccc, 0xfffccccc, 0x0cc10001, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0xfe300000, 0x003a0000, 0xfff8ff00, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff0000, 0xffab0000, 0x924900ff, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80008000, 0x80008000, 0x7fff7fff, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00000000, 0x00000000, 0xe00f0000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0xf0040000, 0x0ffc0006, 0xffff0000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00007fff, 0x00007fff, 0x49241ff8, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00000000, 0x00000000, 0x007f001f, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00007fff, 0x0000fd45, 0x0000fddc, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00000000, 0x00000000, 0xfffafffd, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x800005f4, 0x7fff007f, 0xfe6d000c, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0xfa210000, 0x01f58000, 0xfffd0000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff8000, 0x1ff87fff, 0x00d08000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x0000ffee, 0x0000fffd, 0xf0170006, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00058000, 0xffff3ffe, 0xfffb8000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fffffd0, 0x803f000c, 0xffb2fffc, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff7fff, 0x7fffffe0, 0x7ffc8000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80008000, 0xfff100ff, 0x0fc88000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00000000, 0x7fff0057, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00008000, 0x3ff87fff, 0x0000ffc0, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff0000, 0x8000fff8, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff8000, 0xe38e00b0, 0x8007f0f0, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80000000, 0x8000f44f, 0x7fff0000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0xff608000, 0xffe08000, 0x00057fff, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x3a708000, 0x00028000, 0x1d380ffe, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80007fff, 0x800f8000, 0x001ff001, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x8000016b, 0x014c0003, 0x80030079, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80007fff, 0x8000f0f0, 0x24928007, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff8000, 0xf00305e9, 0xc00ff003, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00000000, 0x00000000, 0xff007fff, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0xaaaa0031, 0x00010007, 0xaaaa0007, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff7fff, 0x8000fff8, 0xffff8000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff8000, 0x1ffe001c, 0x7fffc00f, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff0000, 0x1b0f0000, 0x7fff8000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00000100, 0x0000fff0, 0x0000fff0, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00097fff, 0x00032492, 0x00032492, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80008000, 0x7fffb6db, 0xfff07fff, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x8000fe1c, 0xe00f0016, 0x6666ffea, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fffffe7, 0x80050005, 0xfdbefffb, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x02a47fff, 0x001a8000, 0x001a8000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff0000, 0x80028000, 0x801f0000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff0000, 0x80000000, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80008000, 0x7fffc01f, 0xfbc57fff, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00007fff, 0x0000026f, 0x7fff7fff, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x0000d300, 0x7fffffe0, 0x00000168, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00000000, 0x00000000, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff0000, 0x99997fff, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff7fff, 0xfcf67fe0, 0xfeb27fff, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff8000, 0x80007fff, 0xfffcfff8, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff0000, 0xfc0afffc, 0xe01f0000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00008000, 0xfc9adb6d, 0x00007fff, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80000000, 0x7fff0000, 0xffe08000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00000000, 0xfffd0000, 0x00003fe0, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00000000, 0x7fff0000, 0x0000c01f, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80008000, 0xffe07fff, 0x30a7fffe, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7ffff89d, 0x8000ffc3, 0xe3ef001f, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff0000, 0x80047fff, 0xff260000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff0000, 0x7fff0000, 0x0ffe00cb, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00008000, 0x0000003f, 0x0df48000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00000000, 0x032a0000, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff7fff, 0x0c448000, 0x002ff0f0, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00000000, 0x00000000, 0xff8c0018, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0xa05d7fff, 0x0003800f, 0xe01fece2, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fffc040, 0x1fe0ffff, 0x7ffc3fc0, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff7fff, 0xf8108000, 0xf003c007, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff8000, 0x7ffffffd, 0x001c2c39, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff8000, 0x7fff7fff, 0x0048803f, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80000000, 0x7fff0000, 0xfffa8000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0xfff87fff, 0xfffcc01f, 0x0002801f, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff7fff, 0xffd8263d, 0xf0013ffc, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80000000, 0xaaaa003f, 0x3fc00000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff0000, 0xfff6c01f, 0xc01f0000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff8000, 0x0043fbb6, 0x03cc7fff, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80007fff, 0xf0f0000c, 0x7fff7fff, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x1e960000, 0xf5ce0000, 0xfffd8000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff7fff, 0x002a8000, 0x7ffffcf6, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80007fff, 0x7fffc00f, 0x8000fffd, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80008000, 0x800000b1, 0x0ffe8003, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80000000, 0x8000007f, 0x1ff30000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff807f, 0x7ff0807f, 0x00170001, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff0000, 0xfff10000, 0xf0017fff, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00007fff, 0x00000ff8, 0xfffe7fff, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff8000, 0xc0f27fff, 0xffd7803f, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff7fff, 0x7fff3333, 0x7fff3333, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff7fff, 0x7fff0087, 0x00cc3fc0, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff8000, 0x7fffe003, 0x7fff0075, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80008000, 0x03fe8e38, 0x80007fff, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00000000, 0x00000000, 0x00001ff0, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0xfea07fff, 0xfffc9999, 0x0058807f, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00000000, 0x00009249, 0xffc00000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00000000, 0x00008000, 0x00040000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00000000, 0x00000000, 0x80008000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00008000, 0x02efdb6d, 0x00007fff, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff7fff, 0x80008000, 0xfc95c75c, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00000000, 0x80000000, 0x00008000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00008000, 0x7fff9249, 0x000000ff, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0xf99a7fff, 0xffd90004, 0x002a7fff, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00e17fff, 0x000f3333, 0x000f3333, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00007fff, 0x0000fc32, 0x8007f801, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff0000, 0x6db60000, 0x00020000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7ffffed9, 0xff76ffff, 0x80000127, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x0c8a7fff, 0x00037fff, 0x042e0447, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff7fff, 0x8005f803, 0xffe28000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff8000, 0x0303800f, 0x7fff7fff, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x1e2001b0, 0xfffeff94, 0xf0f0fffc, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00000000, 0x00000000, 0x000f5555, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00000000, 0x0000ffc3, 0x01c70000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80008000, 0x003f8000, 0xe38e0006, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00007fff, 0xdb6d7fff, 0x00007fff, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00000000, 0x2492e003, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80007fff, 0x8000f001, 0x7fff9249, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff8000, 0xf0038000, 0xe01f7ffc, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00457fff, 0xfffd8000, 0xffe9ffff, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80007fff, 0x8000fb8e, 0x7fff8000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff7fff, 0x7fffffda, 0x1ffce38e, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00000000, 0x00000000, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00070000, 0xffff0006, 0xfff90000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x8000f002, 0x8000ffff, 0x00150ffe, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x00000006, 0x00000001, 0xf0010006, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80008000, 0xf0db7fff, 0x7ffffff0, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80000000, 0x7fff8004, 0xfffb0000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff0000, 0x3fc0ffd5, 0x7fff0000, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80007fff, 0x807f7fff, 0x00090005, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80008000, 0x00b66666, 0xf003fffa, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x8000d654, 0x8000007f, 0x7fffffac, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff8000, 0xffcf7fff, 0xec7d8003, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff8000, 0x80001df2, 0xc71cff53, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0xff788000, 0xfffc007f, 0x0022f7fb, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x80000000, 0x3fe00000, 0x80000029, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff8000, 0x7fff000a, 0x003db6db, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff0024, 0x8000fffa, 0x8000fffa, 0x00200000, 0x00200000
	dspck_dstio mul_s.ph, 0x7fff7fff, 0x80007fff, 0xff9f0001, 0x00200000, 0x00200000

	writemsg "[19] Test mulq_rs.w"
	dspck_dstio mulq_rs.w, 0x00000151, 0xfffffeaf, 0x80000000, 0x0, 0x00000000
	dspck_dstio mulq_rs.w, 0x0017fc8f, 0xe0000007, 0xffa00dc2, 0x00000000, 0x00000000
	dspck_dstio mulq_rs.w, 0xfe9ce071, 0xc0000001, 0x02c63f1f, 0x00000000, 0x00000000
	dspck_dstio mulq_rs.w, 0x00000000, 0x7fffffff, 0x00000000, 0x00000000, 0x00000000
	dspck_dstio mulq_rs.w, 0x00000000, 0xffffffc0, 0x0003065a, 0x00000000, 0x00000000
	dspck_dstio mulq_rs.w, 0x000a50e9, 0x8000001f, 0xfff5af17, 0x00000000, 0x00000000
	dspck_dstio mulq_rs.w, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000
	dspck_dstio mulq_rs.w, 0x00000006, 0x7fffffff, 0x00000006, 0x00000000, 0x00000000
	dspck_dstio mulq_rs.w, 0xff0bda44, 0xff0bda44, 0x7fffffc0, 0x00000000, 0x00000000
	dspck_dstio mulq_rs.w, 0x00000001, 0x0000003a, 0x026b670d, 0x00000000, 0x00000000
	dspck_dstio mulq_rs.w, 0x00000001, 0xfffffcec, 0xffe29d3a, 0x00000000, 0x00000000
	dspck_dstio mulq_rs.w, 0xffffffde, 0x10d559b5, 0xffffff00, 0x00000000, 0x00000000
	dspck_dstio mulq_rs.w, 0x00000046, 0x00000046, 0x7fffffff, 0x00000000, 0x00000000
	dspck_dstio mulq_rs.w, 0x00000000, 0x00000000, 0x0000ffff, 0x00000000, 0x00000000
	dspck_dstio mulq_rs.w, 0x00000080, 0xffffff80, 0x80000006, 0x00000000, 0x00000000
	dspck_dstio mulq_rs.w, 0x00000040, 0x7fffffff, 0x00000040, 0x00000000, 0x00000000
	dspck_dstio mulq_rs.w, 0x00000000, 0x80000005, 0x00000000, 0x00000000, 0x00000000
	dspck_dstio mulq_rs.w, 0x7ffffff9, 0x7ffffffa, 0x7fffffff, 0x00000000, 0x00000000
	dspck_dstio mulq_rs.w, 0x7ffffffd, 0x7fffffff, 0x7ffffffe, 0x00000000, 0x00000000
	dspck_dstio mulq_rs.w, 0x00000056, 0x7fffff80, 0x00000056, 0x00000000, 0x00000000
	dspck_dstio mulq_rs.w, 0x00000000, 0x00000234, 0x00000000, 0x00000000, 0x00000000
	dspck_dstio mulq_rs.w, 0x006bfe19, 0x24924924, 0x0179f958, 0x00000000, 0x00000000
	dspck_dstio mulq_rs.w, 0x12492491, 0x3ffffffe, 0x24924924, 0x00000000, 0x00000000
	dspck_dstio mulq_rs.w, 0x00000096, 0xffa6fc9a, 0xffff2867, 0x00000000, 0x00000000
	dspck_dstio mulq_rs.w, 0x00000006, 0x0f0f0f0f, 0x00000035, 0x00000000, 0x00000000
	dspck_dstio mulq_rs.w, 0xffffffe1, 0x7fffffff, 0xffffffe1, 0x00000000, 0x00000000
	dspck_dstio mulq_rs.w, 0x7fffffff, 0x80000000, 0x80000000, 0x00000000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0xfffff429, 0xfffff429, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x7ffffffe, 0x7fffffff, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x01000000, 0x0ffffffc, 0x07fffffe, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000001, 0xffffffff, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x66666665, 0x66666666, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x0000001b, 0x80000007, 0xffffffe5, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x80000005, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x00000000, 0x3fffffe0, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xffffad0b, 0x80000007, 0x000052f5, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0xffff0000, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x7fffffff, 0x80000000, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000027, 0x80000006, 0xffffffd9, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x07fffffc, 0x7fffffff, 0x07fffffc, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x00000000, 0x00078e5a, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x00a1c74b, 0xffffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x7ffffff4, 0x7ffffffb, 0x7ffffff9, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xffffadf4, 0xff3e7557, 0x00364356, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x7fffffff, 0x80000000, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x000000df, 0xe000000f, 0xfffffc82, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x00000001, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000128, 0x7fffffff, 0x00000128, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x80000000, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x01abeed0, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xffff0001, 0x80000000, 0x0000ffff, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0xff58cf32, 0xfffffff8, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x00000001, 0xff00ff00, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x000b829a, 0x7fffffff, 0x000b829a, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x7fffffff, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x1ffffff0, 0x7fffffff, 0x1ffffff0, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x80000015, 0x7ffffff0, 0x80000005, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0xfffffff8, 0xfffffffc, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x80000002, 0x80000001, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xffe1aa82, 0x7fffffff, 0xffe1aa82, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0xff9b6f67, 0xfffffffa, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000004, 0x80000000, 0xfffffffc, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000006, 0x7fffffff, 0x00000006, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000007, 0x7ffffffb, 0x00000007, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xfff013c6, 0x24924924, 0xffc84534, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xfffa8d35, 0x002b965b, 0xf0000007, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xfffe43f8, 0xff411954, 0x0129b9d1, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x8000007f, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0xffffcca4, 0xfffffc33, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x7ffffffb, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x00000000, 0x7ffffff8, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x00001dad, 0xffffe01a, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xfffffffd, 0x00000007, 0xc0000007, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x01ffffff, 0xf0000003, 0xf0000003, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x00000000, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xfffffeff, 0x000005c4, 0xe9bfc5a9, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00001742, 0xffffe8be, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x7ffffffb, 0x80000000, 0x80000005, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x1ffffffe, 0x1ffffffe, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x7fffffff, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0xfffffffc, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x00000000, 0xffffff97, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xffff6e13, 0x000091ed, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000005, 0xb6db6db6, 0xfffffff8, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000038, 0x7fffffff, 0x00000038, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xf0000003, 0x7fffffff, 0xf0000003, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xf0f0f0f0, 0xf0f0f0f0, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000aee, 0xfffff512, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xf0000002, 0x0ffffffe, 0x80000001, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x00000000, 0x000000ff, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x00000000, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x0000001c, 0xffffffc0, 0xc71a53fe, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x38e38e1c, 0x71c71c71, 0x3fffffe0, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x80000005, 0x7fffffff, 0x80000004, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x8e38e38f, 0x71c71c71, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x00000000, 0xffff3933, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xffff5da6, 0x0000a25a, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000fd3, 0x7fffffff, 0x00000fd3, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xfffffb9c, 0xffffdcdf, 0x0ffffff8, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x015c1cc7, 0xfea3e339, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x00000000, 0xaaaaaaaa, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x054b7975, 0x00000001, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000003, 0x7fffffff, 0x00000003, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x011434d5, 0x49249249, 0x01e35c75, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x00000000, 0x00000007, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x00000000, 0x7fffffc0, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x353dcce8, 0x7fffffff, 0x353dcce8, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x80000005, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0xe683a401, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xfffffffc, 0xffffffe0, 0x0ed9ff25, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0xfffffff9, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x00000000, 0x8e38e38e, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xf8000002, 0x07fffffe, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xffffffd8, 0xf0000007, 0x00000140, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x0000000f, 0xff67e80c, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x7fffffff, 0x80000000, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x80000001, 0x80000000, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xfffde962, 0x0ffffffe, 0xffef4b11, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0xffffffff, 0xffffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x80000001, 0x80000000, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00574a38, 0x7fffffff, 0x00574a38, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x7fffffff, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xffffff1d, 0x000000ff, 0x8e38e38e, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0xffed1970, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xf0000009, 0xe0000003, 0x3fffffe0, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x80000000, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xff807f81, 0x00ff00ff, 0xc0000003, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x00000000, 0xf8000001, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x00000000, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xfffff2ec, 0xffffcbb0, 0x1ffffff8, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000003, 0x00000007, 0x38e38e38, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x7fffffff, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xffffffcb, 0x80000000, 0x00000035, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x7ffffffa, 0x7ffffffd, 0x7ffffffd, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000001, 0xb6db6db6, 0xfffffffe, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x12f684bd, 0x55555555, 0x1c71c71c, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x1249248d, 0x3ffffff0, 0x24924924, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0xffffffff, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xff81f884, 0x013b12b5, 0xcccccccc, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x0000006f, 0x00000d3b, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x00000000, 0x023b15c9, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0xfffffffa, 0x0014e498, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000001, 0xf0000007, 0xfffffffa, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x7ffffffd, 0x80000000, 0x80000003, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0xfffffc38, 0xfffffffc, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xffffff36, 0x7fffff80, 0xffffff36, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x00000000, 0x00ead470, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000006, 0x80000000, 0xfffffffa, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000066, 0x80000000, 0xffffff9a, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000001, 0x0ffffff8, 0x00000006, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xfffffffc, 0x1ffffff0, 0xfffffff0, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0xfffffbe1, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00034357, 0xfffcbca9, 0x8000000f, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x5e0a72ef, 0x6db6db6d, 0x6db6db6d, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x80000001, 0x80000000, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0xffffffc0, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xffffff71, 0xfffff709, 0x07fffffc, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x80000004, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00001e53, 0xffffe1ad, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0xffffffff, 0x00000004, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x00000005, 0x003d27bc, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xffffffe3, 0x0000001d, 0x80000005, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0xfffffffe, 0xe0000003, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x00000000, 0x00000003, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xfffffec3, 0xfffffd86, 0x3ffffff0, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xf8000007, 0x3fffffe0, 0xf0000007, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xfff2d687, 0x66666666, 0xffef8c29, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000002, 0x80000000, 0xfffffffe, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x7ffffff8, 0x7ffffff9, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x7ffffffe, 0x7fffffff, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x146725b0, 0xeb98da50, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0xfff7f8d8, 0xfffffffc, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x0000049a, 0x00001251, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xfffff007, 0xc000001f, 0x00001ff2, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00024b75, 0x7fffffff, 0x00024b75, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x000002ad, 0x00128096, 0x00128096, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xf1c71c72, 0x38e38e38, 0xe0000001, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x0006c160, 0x7fffffff, 0x0006c160, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0xfffffff8, 0xfffffff0, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0xc0000007, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x80000002, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x0ffffffe, 0x0ffffffe, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xfc000002, 0x80000000, 0x03fffffe, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x00000000, 0xffffffe3, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x38e38e39, 0x80000000, 0xc71c71c7, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000028, 0xffffffd8, 0x80000005, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x80000001, 0x80000000, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x00000000, 0x0ffffffe, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x80000000, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x0000000f, 0x80000001, 0xfffffff1, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xffface56, 0x0005d7df, 0x8e38e38e, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x0000000a, 0x0000000f, 0x55555555, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000002, 0xfffffffe, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x00000000, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x00000000, 0x80000004, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x00000000, 0x80000004, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xfffffffe, 0x00000002, 0x8e38e38e, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x3fffffe1, 0xc000001f, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x00000000, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0xfffffffa, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000007, 0x00000007, 0x7fffffe0, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00001bc5, 0x00001bc5, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x7ffffffe, 0x7fffffff, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x06e5c118, 0x1db69774, 0x1db69774, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00b25008, 0x80000001, 0xff4daff8, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0xf8000003, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x7fffff81, 0x80000000, 0x8000007f, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000001, 0x7fffffff, 0x00000001, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xffe01fe0, 0xff00ff00, 0x0ffffffc, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000003, 0x00020e6a, 0x00009c63, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x00000000, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x7fffffff, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xfffffff0, 0x7fffffff, 0xfffffff0, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000006, 0xfffffffa, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xc0000001, 0xc0000001, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00001866, 0x00030ccb, 0x03fffffe, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x07fffffe, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xffffffff, 0xffffffff, 0x66666666, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xffffffff, 0x71c71c71, 0xffffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xfffff312, 0xffff3f7b, 0x0898d847, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0xffffffa7, 0x00573bd0, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xffffffe1, 0x80000000, 0x0000001f, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xffffff00, 0xffffff00, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0xfffffff9, 0xfffffff9, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000002, 0x001f3444, 0x00000683, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x00000000, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x00000001, 0xfffffffd, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xfffffff7, 0x7fffffff, 0xfffffff7, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x00000000, 0xffffe06d, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xfffffffe, 0x7ffffff9, 0xfffffffe, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000104, 0x00000289, 0x33333333, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000002, 0xffffff00, 0xff00ff00, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x000003d1, 0x80000000, 0xfffffc2f, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x00000000, 0x007dd65e, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x00000000, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000000, 0x0003aa03, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x00000001, 0xff00ff00, 0xffffff99, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0x1c71c71d, 0x80000000, 0xe38e38e3, 0x00200000, 0x00200000
	dspck_dstio mulq_rs.w, 0xfffd5905, 0x03fffffe, 0xffab20ab, 0x00200000, 0x00200000

	writemsg "[20] Test mulq_s.ph"
	dspck_dstio mulq_s.ph, 0x99990000, 0x7ffffffa, 0x9999fb8b, 0x0, 0x00000000
	dspck_dstio mulq_s.ph, 0x00040090, 0xfda10091, 0xff0d7fff, 0x00000000, 0x00000000
	dspck_dstio mulq_s.ph, 0xf0040000, 0x80000000, 0x0ffc0000, 0x00000000, 0x00000000
	dspck_dstio mulq_s.ph, 0xfff70000, 0x800ffffe, 0x0009ffff, 0x00000000, 0x00000000
	dspck_dstio mulq_s.ph, 0x00000000, 0x00000023, 0x00000023, 0x00000000, 0x00000000
	dspck_dstio mulq_s.ph, 0xffff0000, 0xffff0000, 0x7fff1ffc, 0x00000000, 0x00000000
	dspck_dstio mulq_s.ph, 0x00007ff1, 0xfffe8000, 0xff5f800f, 0x00000000, 0x00000000
	dspck_dstio mulq_s.ph, 0x04540000, 0x7fff0000, 0x04551ff8, 0x00000000, 0x00000000
	dspck_dstio mulq_s.ph, 0x0001ffff, 0x00a1fdb7, 0x00cd0003, 0x00000000, 0x00000000
	dspck_dstio mulq_s.ph, 0xfffa0000, 0x05800000, 0xff8b0000, 0x00000000, 0x00000000
	dspck_dstio mulq_s.ph, 0xfff80005, 0xffe00006, 0x1fe07fff, 0x00000000, 0x00000000
	dspck_dstio mulq_s.ph, 0x00008003, 0x00008003, 0x7fff7fff, 0x00000000, 0x00000000
	dspck_dstio mulq_s.ph, 0x00000000, 0x7fff0000, 0x00000000, 0x00000000, 0x00000000
	dspck_dstio mulq_s.ph, 0x1fdee004, 0x1fe01ffc, 0x7ffa8000, 0x00000000, 0x00000000
	dspck_dstio mulq_s.ph, 0xfde20000, 0x043b0000, 0xc003c71c, 0x00000000, 0x00000000
	dspck_dstio mulq_s.ph, 0x00001948, 0xfff338e3, 0xfff338e3, 0x00000000, 0x00000000
	dspck_dstio mulq_s.ph, 0x0000ff19, 0xfec6ff19, 0x00007fff, 0x00000000, 0x00000000
	dspck_dstio mulq_s.ph, 0x005b0000, 0x7fff0000, 0x005c0002, 0x00000000, 0x00000000
	dspck_dstio mulq_s.ph, 0xffffc71d, 0x00048e38, 0xfb413ffe, 0x00000000, 0x00000000
	dspck_dstio mulq_s.ph, 0x00000000, 0x00000000, 0x55558000, 0x00000000, 0x00000000
	dspck_dstio mulq_s.ph, 0x00000000, 0x00000000, 0x00088000, 0x00000000, 0x00000000
	dspck_dstio mulq_s.ph, 0x8001fffd, 0x80000003, 0x7fff8000, 0x00000000, 0x00000000
	dspck_dstio mulq_s.ph, 0x00001fff, 0xfa028000, 0x0000e001, 0x00000000, 0x00000000
	dspck_dstio mulq_s.ph, 0x00000000, 0x1ff838e3, 0x00000000, 0x00000000, 0x00000000
	dspck_dstio mulq_s.ph, 0x00000000, 0x00000002, 0xf0070000, 0x00000000, 0x00000000
	dspck_dstio mulq_s.ph, 0x00000000, 0x00008000, 0x072f0000, 0x00000000, 0x00000000
	dspck_dstio mulq_s.ph, 0xffda0000, 0x3ffe0000, 0xffb5ff07, 0x00000000, 0x00000000
	dspck_dstio mulq_s.ph, 0xffffff00, 0xfd6e7fff, 0x001fff00, 0x00000000, 0x00000000
	dspck_dstio mulq_s.ph, 0x00551ff7, 0xaaaa1ff8, 0xff807fff, 0x00000000, 0x00000000
	dspck_dstio mulq_s.ph, 0x00000000, 0x00000000, 0xf0d1096f, 0x00000000, 0x00000000
	dspck_dstio mulq_s.ph, 0x8001c02f, 0x8000801f, 0x7fff3fe0, 0x00000000, 0x00000000
	dspck_dstio mulq_s.ph, 0x8001fffd, 0x7fffffd4, 0x800007ac, 0x00000000, 0x00000000
	dspck_dstio mulq_s.ph, 0x0000ffff, 0x7fff0007, 0x0000fddb, 0x00000000, 0x00000000
	dspck_dstio mulq_s.ph, 0x7fff7ffe, 0x80007fff, 0x80007fff, 0x00000000, 0x00200000
	dspck_dstio mulq_s.ph, 0x003be001, 0x7fffe001, 0x003c7fff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00008001, 0x00008000, 0x00067fff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x665f7fff, 0x66668000, 0x7ff88000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x7ffe8001, 0x7fff8000, 0x7fff7fff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xfffc0ffd, 0xffe00ffe, 0x0fed7fff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xffd7ff28, 0xf0f0ff28, 0x015b7f80, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x01d80012, 0x01d9002f, 0x7fff3333, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xfee37ffe, 0x011d7fff, 0x80007fff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x0000e003, 0x00003ffc, 0x0000c003, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x0000fff8, 0x0006fff8, 0x0ffe7fff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00000000, 0x00000000, 0xff510053, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x0000fdfc, 0x00000204, 0x006a803f, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xfffe0000, 0x7fff8000, 0xfffe0000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xffff0000, 0x0025e001, 0xff140000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xffffffff, 0xfffdffff, 0x00d70016, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x02a30000, 0x02a47fff, 0x7ff90000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xfffffffe, 0x00107fff, 0xfff9fffe, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00000000, 0x0000003f, 0x000f0000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x0004ffee, 0xfeb73fe0, 0xfe1bffdd, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x0000ff80, 0xffd87fff, 0xff1fff80, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x1ffd01ff, 0xc0030ffe, 0xc0030ffe, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x0000db6f, 0x09c18006, 0x00002492, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00000000, 0x001d1ff8, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x999a0000, 0x66660015, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xffff0004, 0xff468000, 0x0003fffc, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00abffff, 0x7ff90001, 0x00ace007, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00001101, 0x00152ea8, 0x00152ea8, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00016524, 0x00ff8e38, 0x00ff8e38, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00000000, 0x0000c71c, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xf802ffff, 0x80000006, 0x07fef003, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xfffd0003, 0x7ff00004, 0xfffd7fff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xffffffa3, 0xfffbcccc, 0x001f00e8, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00000000, 0x00000000, 0x8000801f, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x8001013d, 0x7ffffec3, 0x80018000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00220175, 0x80008002, 0xffdefe8a, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x0000ff00, 0x55557fff, 0x0000ff00, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xeb848001, 0x147c8000, 0x80007fff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x7ffe0000, 0x7fffe003, 0x7fff0000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x7ff9004d, 0x7fff004e, 0x7ffa7fff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x0000e202, 0x7fff807f, 0x00001e1b, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xdb6d0093, 0x7fff0094, 0xdb6d7fc0, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xffff0000, 0x00010000, 0x8000e007, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x020a0000, 0xefd7ffd9, 0xefd7ffd9, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x0000fffd, 0x49246666, 0x0000fffd, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xfff12493, 0x000fdb6d, 0x80008000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00000000, 0x801f0000, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00000000, 0x00000000, 0x0068fe27, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xe03f0000, 0x3fc0fff1, 0xc03f0000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00000001, 0xea200cf7, 0x0000000c, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00000000, 0x80000000, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xffc9ffff, 0xffc9fffc, 0x7ffe000e, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xe38f000b, 0xe38e000c, 0x7ffb7fff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00000000, 0x80000000, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x55560072, 0xaaaa0073, 0x80007fff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00060000, 0x09000001, 0x005a0fb2, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x3ffb3332, 0x80048003, 0xc003cccc, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xffc10000, 0x80007ff0, 0x003f0000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00007ffe, 0x000b7fff, 0x000b7fff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xffff0000, 0xffff0007, 0x7fff0000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xffe5feb9, 0xffe52e09, 0x7ffafc75, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x0000fffe, 0xfffb8000, 0xfffd0002, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x0000ff3f, 0xfffe0302, 0xe38ee003, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x01d00003, 0x7fff0b0a, 0x01d1002e, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xffff0000, 0x012e7fff, 0xfff70000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x0000e5e0, 0x00004924, 0x0000d248, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x0000ffff, 0x3ffc001f, 0x0002ffee, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x03088002, 0x03098000, 0x7fff7ffe, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00000000, 0x0000ff1c, 0x801ffffd, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00001caa, 0x00007fff, 0x7fff1cab, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xffff7fff, 0x00288000, 0xfefd8000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x0e370000, 0x1ffe0000, 0x38e3ffd2, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x017e0000, 0xfe420f0f, 0x92490000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xff1af384, 0x80006666, 0x00e6f066, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xc040f003, 0x8000800f, 0x3fc00ffe, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x7ffe0000, 0x7fff002a, 0x7fff0005, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00000000, 0x3f1e0000, 0x0000c001, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xe008ffff, 0x1ff8fff9, 0x80000004, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xfffcffff, 0xffe5003f, 0x11cdfffd, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00000000, 0x00000000, 0x0194000f, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xfff20000, 0x7ffffffc, 0xfff20000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00000000, 0xfe1e3ffe, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xc0070006, 0xc0078000, 0x7ffffffa, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00000100, 0x0000ff00, 0x1c718000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xf00a0000, 0x7fc0ffc9, 0xf0030000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xfffb0000, 0x80030000, 0x0005d28f, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xfc4d8001, 0xfc4d7fff, 0x7fff8000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00000000, 0x00b16666, 0x00000001, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00000001, 0x00007fff, 0x7ff80002, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x002c7ff4, 0xfb448006, 0xfb448006, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x001d0001, 0x001e0006, 0x7fff1793, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00ff0000, 0xf803fff8, 0xf0010000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x7fff0000, 0x80000000, 0x8000803f, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x49230005, 0x7fff0006, 0x49247fff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00017ffe, 0x00027fff, 0x7ffe7fff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x0000fffe, 0x00000002, 0x3fe08000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xffff0032, 0xffff7fff, 0x1ff80033, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00000024, 0xc001007f, 0xffff2492, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x8002fff1, 0x8002000f, 0x7fff8000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00060000, 0xfffa0029, 0x80000002, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xff8bfff5, 0x8000fff5, 0x00757ffa, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00000000, 0x00000000, 0x00040014, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x0000e00b, 0x00011ff8, 0x71c7800f, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00050009, 0x000600ff, 0x7fff04f2, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00000000, 0x00000000, 0x8003fffd, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x8001fff0, 0x8000fff0, 0x7fff7ffc, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x0000ffff, 0x1fe0f003, 0x00000002, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xf87cfb15, 0x0f0f7f80, 0xc01ffb11, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xfffaffde, 0x00ff0022, 0xfd0f8000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00000006, 0x00008000, 0xfffdfffa, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x0000ff80, 0xffc07fff, 0xffffff80, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00400000, 0x05b3002e, 0x05b3002e, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xffff0002, 0x0067fffe, 0xfff68000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00e00000, 0x80007ff8, 0xff200000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xffe00000, 0xffe00000, 0x7fff00ba, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xffc00000, 0x007fc5c4, 0xc03f0000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00000033, 0x0000019b, 0xf0030ff8, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xf9e7ff08, 0x71c70648, 0xf924ec4b, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x0000fffe, 0x0000001f, 0x8000f83e, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xe74dfff9, 0x80008007, 0x18b30007, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00eeffc8, 0xff12ff90, 0x80003ff8, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00000001, 0xe7817fff, 0x00000002, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x8040003e, 0x7fc07fff, 0x8000003f, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x0ff80000, 0xe00f0000, 0xc0017ffc, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xff80ffff, 0x7fffffea, 0xff80001f, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00000000, 0xc03fffc0, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00000000, 0x00008000, 0x07fc0000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xe38f0000, 0xc71c8000, 0x3ffc0000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00000000, 0x00007fff, 0xe38e0000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00008008, 0x00007ff8, 0xffff8000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x0000f878, 0x00000f0f, 0x0000c003, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x7ff80000, 0x7ffe0000, 0x7ffafff0, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x000d0000, 0xdb6d0000, 0xffd00000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x07a20000, 0x8000fff0, 0xf85efe19, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xfffd0000, 0x80003ffe, 0x00030000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xffdc0000, 0x80000034, 0x00240000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00000000, 0x7ffff007, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x1fed6db7, 0x800f9249, 0xe00f8000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00000000, 0x00000000, 0xfbbb7fff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xf8f60004, 0x8006fffb, 0x070a8007, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xfff0fae2, 0x00fd148a, 0xf868e01f, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xffff8001, 0x1ffc7fff, 0xfffc8000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x0007c002, 0x00083ffe, 0x7ffb8000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x0000fe38, 0x7fff01c8, 0x00008000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xfffe0000, 0xfff8ff00, 0x1ff80000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00000000, 0x00008005, 0xfff60000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xfffffffb, 0x0001fffb, 0x80007fff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xf15effff, 0x2492ff00, 0xcccc0002, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00010000, 0xfffd0000, 0xc00f0000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xffffc020, 0x3ffe3fe0, 0xfffe8000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x0000fffa, 0x00008000, 0x3ff00006, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x0000ffea, 0x0000ffe0, 0xfffd5555, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00000000, 0x00000000, 0x1fe0003e, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00160000, 0x07fc0000, 0x01708000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xfbe6ffff, 0xfbe6fff0, 0x7fff0268, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x0048b6db, 0x007f7fff, 0x4924b6db, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x0000feb7, 0x00077fff, 0x0003feb7, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00018003, 0x00047ffd, 0x3ffc8000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xfffffd78, 0xff7f7fc0, 0x003ffd77, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x1fff0000, 0x8000ffdc, 0xe001fffd, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xc0100000, 0x80000000, 0x3ff01ffc, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00000000, 0xffe00042, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xfff4ffc0, 0x156f0040, 0xffb98000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00000014, 0x07fc0015, 0x00007ff9, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x80073332, 0x80003333, 0x7ff97ffe, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00000000, 0x803f0000, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00000000, 0xc0010000, 0x00007ff8, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00000000, 0x00007fff, 0x14190000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xffa90000, 0x801f000f, 0x00570000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x3ffb0000, 0x3ffcc03f, 0x7fff0000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00010008, 0xe001fff8, 0xfff88000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xfff50000, 0x000b0003, 0x80070028, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00000000, 0x7fff7fff, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00000000, 0x8000e00f, 0x0000ffff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x0000ed2a, 0xfc0112d6, 0x00008005, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x0a8e001e, 0xe364003d, 0xd0c63ffe, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xfff900c9, 0x7fff8000, 0xfff9ff37, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x0000ffff, 0x80000001, 0x0000f0f0, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x1fed1ff9, 0xc007e007, 0xc01f8000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xffff0000, 0x00020003, 0xffff0b25, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x0000ff01, 0x00028000, 0x249200ff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xffff0000, 0x0ffc0000, 0xfffff007, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xfcb60193, 0x8002f9b2, 0x034ae001, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00008e38, 0xe0017fff, 0x00008e38, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00007ffe, 0xffe07fff, 0xffe07fff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xfffdfff7, 0xffe85555, 0x0fd5fff3, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x0000fffe, 0xe0407fff, 0xfffcfffe, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xffff0000, 0xfc91ff94, 0x0007ffde, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x1fff7ffe, 0xc0017fff, 0xc0017fff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xff81e676, 0x007f7fff, 0x8000e676, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x49250000, 0xb6dbfffd, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xfff40000, 0xf9170000, 0x00d7370e, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xffff0001, 0xffff8000, 0x066effff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x0000f008, 0xfe980ff8, 0x00008000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00000000, 0x0000002e, 0x00400000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00000288, 0xfffef6ce, 0x0000dcb7, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00000000, 0x00070000, 0x0005fff3, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xfffd2493, 0xe00f8000, 0x0009db6d, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xf0180002, 0xe02e014c, 0x3ff800e3, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00000000, 0x00000000, 0xfffcfdb5, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xf98f0000, 0xf31f1ffc, 0x3ffc0000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x0000ffff, 0x00001ff0, 0x0000fffc, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0xfffd0000, 0xfffd0000, 0x7fff0000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x0000ffff, 0x0001003d, 0x0ff8ffff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.ph, 0x00008003, 0x00007fff, 0xfffd8003, 0x00200000, 0x00200000

	writemsg "[21] Test mulq_s.w"
	dspck_dstio mulq_s.w, 0xff0c108a, 0x7fffffff, 0xff0c108a, 0x0, 0x00000000
	dspck_dstio mulq_s.w, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000
	dspck_dstio mulq_s.w, 0x00000003, 0xe0000003, 0xfffffff0, 0x00000000, 0x00000000
	dspck_dstio mulq_s.w, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000
	dspck_dstio mulq_s.w, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000
	dspck_dstio mulq_s.w, 0x183db574, 0x80000000, 0xe7c24a8c, 0x00000000, 0x00000000
	dspck_dstio mulq_s.w, 0x80000001, 0x80000000, 0x7fffffff, 0x00000000, 0x00000000
	dspck_dstio mulq_s.w, 0xffffffff, 0x0000001f, 0xffff35c4, 0x00000000, 0x00000000
	dspck_dstio mulq_s.w, 0x00000000, 0x00000000, 0x80000001, 0x00000000, 0x00000000
	dspck_dstio mulq_s.w, 0x00000014, 0x0002b663, 0x0003c2c1, 0x00000000, 0x00000000
	dspck_dstio mulq_s.w, 0x80000040, 0x80000000, 0x7fffffc0, 0x00000000, 0x00000000
	dspck_dstio mulq_s.w, 0xfffffffb, 0x00000009, 0xc0000001, 0x00000000, 0x00000000
	dspck_dstio mulq_s.w, 0x00000016, 0x00001668, 0x008359a8, 0x00000000, 0x00000000
	dspck_dstio mulq_s.w, 0xfffffff3, 0x0000000d, 0x80000000, 0x00000000, 0x00000000
	dspck_dstio mulq_s.w, 0x0db6db67, 0x92492492, 0xf0000007, 0x00000000, 0x00000000
	dspck_dstio mulq_s.w, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000
	dspck_dstio mulq_s.w, 0xfffffe9a, 0x7fffffff, 0xfffffe9a, 0x00000000, 0x00000000
	dspck_dstio mulq_s.w, 0x00000005, 0x00000016, 0x1ffffff8, 0x00000000, 0x00000000
	dspck_dstio mulq_s.w, 0xc0000002, 0xc0000001, 0x7ffffffd, 0x00000000, 0x00000000
	dspck_dstio mulq_s.w, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000
	dspck_dstio mulq_s.w, 0xf8000005, 0x07fffffc, 0x8000001f, 0x00000000, 0x00000000
	dspck_dstio mulq_s.w, 0x3fffffe1, 0xc000001f, 0x80000000, 0x00000000, 0x00000000
	dspck_dstio mulq_s.w, 0x7fffffff, 0x80000000, 0x80000000, 0x00000000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000950, 0xf0000001, 0xffffb57e, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xfff00096, 0x000fff6a, 0x80000005, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0xfffffff9, 0xfffffff9, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xfffed029, 0x80000004, 0x00012fd7, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x00000000, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x00000000, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x0000010c, 0xfffffef4, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xffffffff, 0x00005914, 0xfffffffa, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x0ffffffb, 0x0ffffffc, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000007, 0xfffe016e, 0xfffe016e, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000040, 0xffffffc0, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xffffffff, 0xffffffff, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0xffffffe7, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xffffc5c9, 0xffffc5c9, 0x7ffffffd, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000048, 0x0000005b, 0x66666666, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x7fffffff, 0x80000000, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x0001c5fe, 0x1ffffff0, 0x000717fa, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xfffffffd, 0x00000004, 0xb6db6db6, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000035, 0x07313e72, 0x000003b8, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x80000000, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x07878783, 0x0f0f0f0f, 0x3fffffe0, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xfffffffc, 0x80000000, 0x00000004, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x92492492, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x00000004, 0x00000004, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000003, 0x24924924, 0x0000000b, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x00000000, 0xfc000001, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x49249249, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x7fffffff, 0x80000000, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x00000000, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0xe0000001, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x80000000, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x000042ba, 0xdb6db6db, 0xffff1672, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xffff0001, 0x80000000, 0x0000ffff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xffffffff, 0x80000000, 0x00000001, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xffffffe0, 0x7fffffff, 0xffffffe0, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xfffe0898, 0x6db6db6d, 0xfffdb4b2, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x00000000, 0xf8000001, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000004, 0x80000000, 0xfffffffc, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x000018c6, 0x7fffffff, 0x000018c7, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x00000000, 0xfffffe56, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xffffffff, 0xffff2078, 0x000020b2, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000547, 0xffe601dc, 0xffe601dc, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xffffffd5, 0x0000002b, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x7ffffffe, 0x7fffffff, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0xffffffff, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xb6db6db7, 0x49249249, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xffffffff, 0xf0f8a664, 0x00000001, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x3a4591a6, 0x3a4591a7, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xfffffffe, 0x0013515a, 0xfffff583, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xffffffff, 0xffffffff, 0x0004bf5d, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0xffffff00, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00070ab3, 0xf0000003, 0xffc7aa60, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x01eb9ec6, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00001d42, 0xffffe2be, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000d04, 0x000026e8, 0x2ad42035, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x00000000, 0x00000444, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xffffffff, 0xfffea52d, 0x0000016c, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xffffffff, 0x00076c0f, 0xfffffe7a, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000005, 0x80000003, 0xfffffffa, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xe0000007, 0xe0000007, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x28a9770b, 0xd75688f5, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x00000000, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x00000000, 0x007bc9dd, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x0002b243, 0xffea6de7, 0xf0000003, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0xaaaaaaaa, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x8000000f, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xffffffef, 0xffffffeb, 0x66666666, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x00000000, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x71c71c72, 0x8e38e38e, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xffb2beb4, 0xffb2beb4, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x00000000, 0xfffffffe, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x1ffffff0, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x0000003f, 0x0000007f, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x0000007f, 0xffffff80, 0x8000007f, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xfffff873, 0x38e38e38, 0xffffef03, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0xff11e299, 0xffffff93, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x7fffffff, 0x80000000, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xffffe2c0, 0x7fffffff, 0xffffe2c0, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x92492492, 0x7fffffff, 0x92492492, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xb6db6dbf, 0xb6db6db6, 0x7ffffff0, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xffffffff, 0x00000007, 0xf0f0f0f0, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xffff45ae, 0x03fffffe, 0xffe8b5c2, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xffffffe9, 0xd216970c, 0x0000003f, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x000085ee, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0xfffffff8, 0xfbf0cdae, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xffffffd5, 0x7fffffff, 0xffffffd5, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x0000000e, 0x000000de, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x00000000, 0x80000007, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x00000000, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x71c71c72, 0x80000000, 0x8e38e38e, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0xfffffe9a, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x7fffffff, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xf6ee22d3, 0xf6ee22d3, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x0ffffff8, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x06e0d113, 0x1ffffffe, 0x1b834451, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xfffffff9, 0x00000007, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x000fedbb, 0xfff01244, 0x8000003f, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xffffffff, 0xffffffec, 0x000d133d, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x0000770c, 0xeeae9cd4, 0xfffc901a, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x00000000, 0x7fffff80, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000016, 0x7fffffff, 0x00000017, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0xffb013f5, 0xfffffffc, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x7ffffff7, 0x7fffffff, 0x7ffffff8, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xfffffffc, 0x0000000f, 0xe38e38e3, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xc0000005, 0x80000003, 0x3ffffffc, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xfd7927a7, 0x80000000, 0x0286d859, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0xfffefd47, 0xfffffffd, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x00000005, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xffffffff, 0xf8000001, 0x00000001, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0xff19d329, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x0000001a, 0xffffffe2, 0x8e38e38e, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00008b8d, 0x80000000, 0xffff7473, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x000000ae, 0x00000001, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x00000000, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0xfffffff9, 0xffde2edd, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x00000000, 0x00000007, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x0000002c, 0xfffff0a0, 0xfe8d6d48, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x7ffffffa, 0x80000006, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x00000000, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xfffffffa, 0xfffffffa, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x3e66848c, 0x3e66848d, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xff00ff01, 0x80000006, 0x00ff00ff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x1c71c71b, 0x1c71c71c, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x7ffffffe, 0x7fffffff, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0xffffff8a, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x00000000, 0xc000000f, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x0ffffffb, 0x7fffffff, 0x0ffffffc, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x0000001b, 0x00001eb2, 0x00741f18, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x7ffffffe, 0x7fffffff, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000006, 0x80000000, 0xfffffffa, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x7ffffffe, 0x7fffffff, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x00000000, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x00000000, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xfec0fe9f, 0x7fffffff, 0xfec0fe9f, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0xfffffffb, 0xfffffffa, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x00000000, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x3f336130, 0xc0cc9ece, 0x80000003, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x80000020, 0x7fffffe0, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xffffffff, 0x01671684, 0xffffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x1ffffffb, 0x1ffffffc, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0xfffffff8, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xfffe9c39, 0xfffe9c39, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xfff26d00, 0x80000000, 0x000d9300, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x0000003f, 0x00462bc5, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xffffffe5, 0xffd4233e, 0x00004d60, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x00000000, 0x55555555, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x000000ff, 0x80000007, 0xffffff00, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x80000082, 0x7ffffffc, 0x8000007f, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000001, 0x80000000, 0xffffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x7fffffff, 0x80000000, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xffffffa5, 0x03fffffe, 0xfffff4a1, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0xf8000001, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x0b1b48af, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xfee7cc77, 0xfee7cc77, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xfffed035, 0x7fffffff, 0xfffed035, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x0ffffffb, 0x7fffffff, 0x0ffffffc, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x7fffffe0, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x00000000, 0x24924924, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000665, 0x001c9d40, 0x001c9d40, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xfeec5637, 0x80000000, 0x0113a9c9, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x80000001, 0x7fffffff, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x000020f9, 0x00041f3a, 0x03fffffe, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xc0000020, 0x3fffffe0, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xfffeb505, 0xffd6a0ba, 0x03fffffe, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xffffffff, 0xfffffffa, 0x0038e08e, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x000000aa, 0xaaaaaaaa, 0xffffff00, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00009fb6, 0x80000006, 0xffff6049, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x00000000, 0x7fffffe0, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xffffffff, 0x1ffffff8, 0xfffffffe, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0xffff5c9e, 0xffff5c9e, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xffffffec, 0x00000027, 0xc0000007, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x000001a7, 0x0000069e, 0x1ffffff8, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x00000000, 0x00000a7d, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x000e65db, 0x80000000, 0xfff19a25, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x7fffffff, 0x80000000, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x00000000, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0xffffd56d, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x08d62e22, 0x08d62e23, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x01de3389, 0xfe21cc77, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x7fffff7b, 0x7fffff80, 0x7ffffffb, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xf0000002, 0x0ffffffe, 0x80000005, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x7fffffc0, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x06ea08ba, 0x06ea08bb, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xffffffff, 0x7fffffff, 0xffffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x000023a2, 0xf0000001, 0xfffee2e8, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x00000000, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x1fffffef, 0xc0000003, 0xc000001f, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x00000000, 0x80000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x000741c7, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x99999999, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xffffffff, 0x00000001, 0xffff192b, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xfffffab1, 0x80000000, 0x0000054f, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xffffffe7, 0xffffe80b, 0x0083b5b6, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x000123c5, 0x7fffffff, 0x000123c6, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00745b2f, 0xc0000001, 0xff1749a1, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x2082081f, 0x49249249, 0x38e38e38, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x99999999, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x00000000, 0x03160aab, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x7ffffffe, 0x7fffffff, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0xe000000f, 0xfffffffd, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x80000000, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x80000001, 0x80000000, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x80000000, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xfffffffa, 0x80000001, 0x00000006, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x00000000, 0xfffffffc, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x7ffffffe, 0x7fffffff, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xffffffca, 0x3ffffff8, 0xffffff95, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x039ef36c, 0xe308649b, 0xf0000001, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000295, 0x80000000, 0xfffffd6b, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x00000000, 0x00000000, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0xfe0d4e6c, 0xfffffffc, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xffffff82, 0xffffff82, 0x7fffffff, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0xffffff5c, 0xffffe198, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0x00000000, 0x00000000, 0x7ffffff8, 0x00200000, 0x00200000
	dspck_dstio mulq_s.w, 0xff92e452, 0xfe4b9148, 0x1ffffff0, 0x00200000, 0x00200000

	writemsg "[22] Test mulsa.w.ph"

	writemsg "[23] Test mult"
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x80000000, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xffffff80, 0x80001ee1, 0x8000001f, 0x000000ff, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0xfffffc4c, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xfffffff9, 0x24924910, 0x00000030, 0xdb6db6db, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xf999999a, 0x39999999, 0x33333333, 0xe0000003, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xc0000000, 0x80000000, 0x7fffffff, 0x80000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xffed55c4, 0x0012aa3c, 0xffc8014c, 0x55555555, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x0000139c, 0xbffddadb, 0xffffb18d, 0xc0000007, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x0000600e, 0xdb6c36a0, 0x24924924, 0x0002a068, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xfffff8ff, 0xd404cc78, 0x00060edd, 0xfed82ad8, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xffffffc0, 0x00000080, 0x7fffffff, 0xffffff80, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xc71c71e3, 0x71c71c80, 0x7fffffc0, 0x8e38e38e, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0xf0f0f0f0, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x3fffffbf, 0x80000080, 0x7fffff80, 0x7fffffff, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000003, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x002da41f, 0x23dbb8a8, 0x24924924, 0x013f7cda, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xfffff8bd, 0x80000000, 0x80000000, 0x00000e85, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x80000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x02ce79a3, 0xffc8bb91, 0xfffffff3, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x000003aa, 0x00000000, 0xfffff8ac, 0x80000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x000c9f35, 0xa62ea81a, 0xec8d57a7, 0xff59da56, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000007, 0x00000001, 0x00000007, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x80000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xfe3b2ec0, 0x0389a280, 0x7fffffff, 0xfc765d80, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000044, 0x7ffffeee, 0x7ffffffe, 0x00000089, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x000000d0, 0xfffffe5e, 0x7fffffff, 0x000001a2, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x07fffffe, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xffffffc0, 0x00000200, 0x7ffffffc, 0xffffff80, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xffffffd3, 0x0000005a, 0x7fffffff, 0xffffffa6, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000003, 0x5b09cf80, 0xf949ec61, 0xffffff80, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x0001c000, 0x80000000, 0xfffc7fff, 0x80000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x33333333, 0x80000000, 0x80000000, 0x99999999, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x80000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0xffffff00, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000291, 0x00000000, 0xfffffade, 0x80000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x80000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x0ffffff8, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x000001a8, 0x35cbde00, 0xfffe5622, 0xff00ff00, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xfffffff6, 0x8000010a, 0x00000026, 0xc0000007, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xffffffff, 0xff99c744, 0xfffffffe, 0x00331c5e, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x007f807f, 0x7f00ff01, 0x7fffffff, 0x00ff00ff, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x0000001f, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xffffffff, 0xa000002a, 0xf0000007, 0x00000006, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x7ffffffd, 0xffffffff, 0x80000003, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xfffffeef, 0x66666224, 0xcccccccc, 0x00000553, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0xffffffc0, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x0000001d, 0x29f3de4e, 0x0000007f, 0x3ac97ab2, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x1ffffffd, 0x80000008, 0x7ffffffe, 0x3ffffffc, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xc0000002, 0x00000000, 0x7ffffffc, 0x80000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x33333333, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xfffffffe, 0x24613100, 0xfe04abf0, 0x000000f0, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x000432ad, 0xfff79aa4, 0x0008655c, 0x7fffffff, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xffffffff, 0x88022908, 0xfffffd51, 0x002cb688, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x0000277b, 0xffffb108, 0x7fffffff, 0x00004ef8, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xffffffff, 0x80000040, 0xffffffff, 0x7fffffc0, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x80000000, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x8000007f, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xffffffe0, 0x00000040, 0xffffffc0, 0x7fffffff, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xffffffff, 0xffef3bc0, 0xffffffc0, 0x00004311, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00021873, 0x80000000, 0x80000000, 0xfffbcf19, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x000001fd, 0xe18d1db0, 0xfe0afcaa, 0xfffefb78, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x0ffffff7, 0xe0000010, 0x7fffffff, 0x1ffffff0, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x0000001b, 0xffffffcf, 0x0000003f, 0x71c71c71, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x0000007e, 0xd06923d4, 0x00c47864, 0x0000a53d, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xfffffaf6, 0x00002850, 0x80000004, 0x00000a14, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000006, 0x00000000, 0x80000000, 0xfffffff4, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0xe0000003, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x0000003f, 0x7ffffd06, 0x7ffffffa, 0x0000007f, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xffffe98e, 0x9248e13e, 0x00004e8d, 0xb6db6db6, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x3fffffbf, 0x80000080, 0x7fffffff, 0x7fffff80, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x000fa5ff, 0x80000000, 0x80000000, 0xffe0b401, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xfe000001, 0x00000000, 0x03fffffe, 0x80000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xffffff25, 0x00000000, 0x80000000, 0x000001b6, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x3fffffff, 0x00000001, 0x7fffffff, 0x7fffffff, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xffffffff, 0xfffffff9, 0x00000007, 0xffffffff, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000009, 0x80000000, 0x80000000, 0xffffffed, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x0000a809, 0x5ffabfb5, 0xe0000001, 0xfffabfb5, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xfe666667, 0x30ccccce, 0x99999999, 0x03fffffe, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x000051b2, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000006, 0xfffffff2, 0x7fffffff, 0x0000000e, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x007155c7, 0x1caa7200, 0x8e38e38e, 0xff00ff00, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x7fffff80, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000002, 0x7ffffec5, 0x8000003f, 0xfffffffb, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x0ffffff8, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0xc0000003, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x07fffffb, 0xf0000008, 0x0ffffff8, 0x7fffffff, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0xe0000001, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xfffffffd, 0x6db6db72, 0xfffffffa, 0x6db6db6d, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x0ffffffc, 0x20000015, 0x80000003, 0xe0000007, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xfffe0e21, 0x8003e3bd, 0xfffc1c43, 0x7fffffff, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xfffffff8, 0x00000010, 0xfffffff0, 0x7fffffff, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xffffffff, 0x80000001, 0xffffffff, 0x7fffffff, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xc0000001, 0xfffffffd, 0x7fffffff, 0x80000003, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x0000000f, 0x7fffffe1, 0x0000001f, 0x7fffffff, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xffaaffaa, 0xff55ff56, 0xaaaaaaaa, 0x00ff00ff, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0xc0000003, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x80000000, 0x80000000, 0xffffffff, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xd5555555, 0x80000000, 0x55555555, 0x80000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xe26e778a, 0x00000000, 0x3b2310ec, 0x80000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x3fffffff, 0x00000001, 0x7fffffff, 0x7fffffff, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00159f32, 0x00001982, 0x000000d9, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x00000029, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x7ffffff8, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x1ffffffc, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xfffffffd, 0x8000001e, 0x00000005, 0x80000006, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0xffffffed, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x1ffffffe, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x0000111d, 0x4bab939c, 0xfef9f346, 0xffef47da, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xffffffff, 0xffff9d82, 0xfffffff2, 0x00000709, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0xfffb09c5, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xff2d02c3, 0xa97e9e60, 0xf968161a, 0x1ffffff0, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0xffffffa5, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x000159d9, 0x00000000, 0x80000000, 0xfffd4c4e, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x3ffffffe, 0x00000003, 0x7fffffff, 0x7ffffffd, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000010, 0xfffffffe, 0xfffffff8, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xffffffa1, 0x999999f8, 0x66666666, 0xffffff14, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x001eebe2, 0x9721b440, 0xfa7075b8, 0xfa7075b8, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xfffffffe, 0x00000004, 0x7fffffff, 0xfffffffc, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x03ffffff, 0x80000004, 0x1ffffffe, 0x1ffffffe, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x80000000, 0xffffffff, 0x80000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0xfffffff4, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xfffffff1, 0xa4223c13, 0x001dbb2f, 0xffff845d, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x28f5c28f, 0x0a3d70a4, 0x66666666, 0x66666666, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xffffdd95, 0x000044d6, 0xffffbb2a, 0x7fffffff, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xf8e38e3c, 0x4e38e3a0, 0x3fffffe0, 0xe38e38e3, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x3fffffff, 0x00000001, 0x7fffffff, 0x7fffffff, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xfffffd32, 0xf43ba168, 0xfffeef0c, 0x02a0829e, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0xff5c6f4b, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0xe000000f, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x12492491, 0xdb6db6dc, 0x7fffffff, 0x24924924, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x002ed3b6, 0xfdce136c, 0xff44b124, 0xc0000003, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x02eb78cd, 0xfa290e64, 0x05d6f19c, 0x7fffffff, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x3fffffff, 0x00000001, 0x7fffffff, 0x7fffffff, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xffffffff, 0x80000001, 0xffffffff, 0x7fffffff, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xfffffffe, 0x80000030, 0xfffffffa, 0x3ffffff8, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000002, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x80000002, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xfff48c2c, 0x916e7a6e, 0xff48c2c9, 0x0ffffffe, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x99999999, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x3fffffff, 0x00000001, 0x7fffffff, 0x7fffffff, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x7fffffff, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x0187ef00, 0xfffe7811, 0xffffff00, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xc0000000, 0x80000000, 0x80000000, 0x7fffffff, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xfe000000, 0xbffffff0, 0x3ffffff0, 0xf8000001, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xffffffff, 0x8000001e, 0x00000002, 0xc000000f, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000007, 0x7ffffff1, 0x0000000f, 0x7fffffff, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0xfff81c0c, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xf0000001, 0x3ffffffa, 0x3ffffffe, 0xc0000003, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xc0000000, 0x80000000, 0x80000000, 0x7fffffff, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xffffffe1, 0x400001ec, 0x1ffffffe, 0xffffff0a, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x3fffffff, 0x00000001, 0x7fffffff, 0x7fffffff, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x38e38e3a, 0xe38e38e3, 0xfffffffe, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x0000039c, 0x4ffe31d8, 0x0ffffff8, 0x000039c5, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xc71c71c7, 0x80000000, 0x71c71c71, 0x80000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x35250910, 0x000074a4, 0x000074a4, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x0001cc6c, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00006834, 0xfffffffa, 0xffffeea2, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xffff21fd, 0x9a3e884e, 0xff209972, 0x00fe67df, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xffffffff, 0xff56b900, 0xfff78940, 0x00000014, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xffffffff, 0xf8000002, 0xffffffff, 0x07fffffe, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xffffffff, 0xfb83a9f5, 0x0000142f, 0xffffc71b, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x0000003d, 0x7fffff85, 0x0000007b, 0x7fffffff, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x80000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xc0000000, 0x80000000, 0x80000000, 0x7fffffff, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xc0000000, 0x80000000, 0x7fffffff, 0x80000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xffffffff, 0xffe0894c, 0x0007ddad, 0xfffffffc, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x7fffffff, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xf9d62cdf, 0x80000000, 0x80000000, 0x0c53a641, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x1fffffef, 0xc0000020, 0x3fffffe0, 0x7fffffff, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xf5ae1969, 0x94a3cd2d, 0x7fffffff, 0xeb5c32d3, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x7ffffffa, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xffffffff, 0xffffff46, 0x0000001f, 0xfffffffa, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xf8000002, 0xdfffffc8, 0x1ffffff8, 0xc0000007, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000001, 0x7ffffffd, 0x7fffffff, 0x00000003, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0xfffa8ef6, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x00ff00ff, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xffffffff, 0xfffeffce, 0x00005566, 0xfffffffd, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000002, 0x80000000, 0xfffffffb, 0x80000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x04924924, 0x36db6db8, 0x24924924, 0x1ffffffe, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xffe8787e, 0x00eb4b14, 0xffd0f0fc, 0x7ffffffb, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xfffffffe, 0x00000040, 0xfffffffc, 0x7ffffff0, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xfffffffd, 0x00000060, 0x7ffffff0, 0xfffffffa, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x80000007, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0xffffffd0, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x23925630, 0x00000006, 0x05edb908, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xc0000001, 0x7ffffffe, 0x7fffffff, 0x80000002, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xffffd5ed, 0x8003f1bc, 0xe0000003, 0x00015094, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xffc59623, 0x00000000, 0x80000000, 0x0074d3ba, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x7fffffff, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xffffffff, 0x00000000, 0x80000000, 0x00000002, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00090b11, 0x5f6f4eea, 0xff6f4eea, 0xf0000001, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x01fffffe, 0xfc000002, 0x7fffffff, 0x03fffffe, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00001756, 0x7fff73f9, 0x80000003, 0xffffd153, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xfffffd0a, 0x705814cc, 0x000184ba, 0xfe0d199e, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xf0000003, 0x9ffffff9, 0xe0000007, 0x7fffffff, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00016eb5, 0x1cf71a04, 0x00448344, 0x055a36b1, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x0000072c, 0x80000000, 0xfffff1a7, 0x80000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xffffffff, 0xfbc0adf4, 0xfffffffc, 0x010fd483, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x24924924, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x80000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xffffffe6, 0x80000000, 0x00000033, 0x80000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0xf9fa3ca4, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x07fffffc, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x0028575c, 0x7faf5147, 0x7fffffff, 0x0050aeb9, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000001, 0x80000000, 0xfffffffd, 0x80000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x0020c263, 0x493a6936, 0xffb38fc3, 0x92492492, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x92492492, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x7ffffffe, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x0000003b, 0x924923a4, 0x24924924, 0x000001a1, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x80000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x7fffffff, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x00000008, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x1ffffff0, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xffffffff, 0xffffff97, 0xfffffff9, 0x0000000f, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x6614e9cb, 0x00000003, 0x2206f899, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x80000000, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xd5555555, 0x80000000, 0x55555555, 0x80000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000010, 0xfffff780, 0x3fffffe0, 0x00000044, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xfffffffe, 0x38e38e3c, 0xfffffffc, 0x71c71c71, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000ada, 0xfffd74ac, 0xffffd494, 0xc000000f, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xfffffffe, 0x80000000, 0x00000003, 0x80000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x000e7bb8, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x06666665, 0x19999994, 0xe0000007, 0xcccccccc, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x40000000, 0x00000000, 0x80000000, 0x80000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xffffffff, 0xfffffe1e, 0xfffffffe, 0x000000f1, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x0ffffff8, 0x80000000, 0x80000000, 0xe000000f, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x3fffffbf, 0x80000080, 0x7fffffff, 0x7fffff80, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000007, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x06666664, 0xc6666668, 0x66666666, 0x0ffffffc, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0xfffffe04, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x0005f1dd, 0x00000000, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x3fffffe1, 0x000003c1, 0x8000001f, 0x8000001f, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0xfffff12d, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0xffffffff, 0xfe8fe1ac, 0xfffffffe, 0x00b80f2a, 0x0, 0x0
	dspck_astio mult, 0x0, 0x0, 0x00000000, 0x00000000, 0xc000000f, 0x00000000, 0x0, 0x0

	writemsg "[24] Test multu"
	dspck_astio multu, 0x0, 0x0, 0xfe76f09e, 0xc2ab91bb, 0xfe770721, 0xffffe95b, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x000074a2, 0xf426fd5d, 0xffffe5ff, 0x000074a3, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x8e38936d, 0xc71c91d4, 0x8e38e38e, 0xffff6fc6, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x7f8a380f, 0x80eb8fdf, 0x7fffffff, 0xff147021, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0xcccccccc, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x33333333, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x80000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x03fffffe, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x40000006, 0x7fffffe2, 0x7ffffffe, 0x8000000f, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000007, 0x7ffffff1, 0x7fffffff, 0x0000000f, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x02e86b10, 0x80000000, 0x80000000, 0x05d0d621, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x0000019a, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x000006f6, 0x3fff909c, 0x1ffffffe, 0x000037b2, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000008, 0x7fffff89, 0x7ffffff9, 0x00000011, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x92492492, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00018e61, 0xfff9c678, 0xfffffffc, 0x00018e62, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x7ffffffc, 0x00000006, 0x7fffffff, 0xfffffffa, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x0000052b, 0xfffff5a8, 0x7fffffff, 0x00000a58, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x7f473cc5, 0x80000000, 0xfe8e798b, 0x80000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0xf0000003, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x07fffffe, 0xf0000002, 0x0ffffffe, 0x7fffffff, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0xdb6cdb6d, 0x49250000, 0xdb6db6db, 0xffff0000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x0000000f, 0x00000003, 0x00000005, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x9225e90d, 0x6dc87930, 0x92492492, 0xffc257d8, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x000a182c, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x80000000, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x0630fe6a, 0x00000000, 0x80000000, 0x0c61fcd4, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x7ffffff9, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00ff00f6, 0xdd22dd2b, 0xfffff7d5, 0x00ff00ff, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0xfff85e98, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x7ffe475d, 0x0006e284, 0xfffc8ebe, 0x7ffffffe, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x7fffff06, 0x00000000, 0x80000000, 0xfffffe0c, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x7fffffff, 0x00000000, 0xfffffffe, 0x80000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0xe1000005, 0xa0000009, 0xf0000003, 0xf0000003, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x7ff24291, 0x001b7adc, 0x7fffffff, 0xffe48524, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x80000000, 0x00000001, 0x80000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x7fc59261, 0x0074db3c, 0xff8b24c4, 0x7fffffff, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x03fffffe, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x80000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x020fc465, 0xfbe07734, 0x7fffffff, 0x041f88cc, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x37fffff2, 0x3ffffff0, 0x3ffffff0, 0xe0000001, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0xfffffff9, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x018a5afd, 0x16485b28, 0x38e38e38, 0x06ee9973, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x14b59aac, 0x001069e4, 0x00000143, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x7fffffff, 0x00000000, 0xfffffffe, 0x80000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0xffff0000, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000015, 0xfffff584, 0x00000016, 0xffffff86, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x50c299ad, 0x01482b13, 0x0000003f, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x7fffffff, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x032edfac, 0x4d120538, 0x3ffffffc, 0x0cbb7eb2, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000063, 0x80000000, 0x000000c7, 0x80000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0xe000000f, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x05e1578d, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x3fffffdf, 0x80000040, 0x7fffffff, 0x7fffffc0, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x70000001, 0x60000001, 0xe0000001, 0x80000001, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x051c66dc, 0xf5c73246, 0x051c66dd, 0xfffffffe, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x7ffffff0, 0x80000000, 0xffffffe1, 0x80000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x0ffffffd, 0xa000000c, 0x1ffffffc, 0x7ffffffd, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0xfffe8fd3, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x3ffffffc, 0x80000000, 0x80000000, 0x7ffffff9, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x7ffffffe, 0x00000000, 0xfffffffc, 0x80000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0xe38e38e3, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x7ffffffc, 0x80000005, 0xfffffffb, 0x7fffffff, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x03fffffe, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x80000000, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000112, 0xfffdf3c8, 0xfffffe18, 0x00000113, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x038e38e3, 0x0e38e390, 0x1ffffffc, 0x1c71c71c, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0xf0f0f0f0, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x4000001f, 0x80000000, 0x8000003f, 0x80000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00b125e3, 0x1c9a1dfc, 0x00ec3284, 0xc000001f, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0xcccccccc, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x7ff6577f, 0xffecaefe, 0x80000001, 0xffecaefe, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0xdb6db6db, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x0000002a, 0x0000000e, 0x00000003, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x00000e71, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0xff872168, 0x00f1bd2c, 0xff87216a, 0xfffffffe, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x0ffffffc, 0x00000000, 0x1ffffff8, 0x80000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x7e68000b, 0x00000000, 0x80000000, 0xfcd00016, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0xffff0000, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000003, 0x677d987f, 0x0000ffff, 0x00036781, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x7fffffff, 0x80000000, 0x80000000, 0xffffffff, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x000003c0, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x7ff831e4, 0x80000000, 0x80000000, 0xfff063c9, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x009abdbd, 0xff654242, 0x00e81c9d, 0xaaaaaaaa, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000942, 0x38e36930, 0x00005354, 0x1c71c71c, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0xfffdaeea, 0x52fcab79, 0xffffd9b5, 0xfffdd535, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x5397829c, 0x687d6344, 0x92492492, 0x92492492, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0xc71c71c7, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x6db6ae6e, 0xb6dbb8b4, 0xffff9704, 0x6db6db6d, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x000079c8, 0x00000000, 0x0000f390, 0x80000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x7fffff89, 0x80000000, 0x80000000, 0xffffff13, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000002, 0x00000000, 0x00000004, 0x80000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x3ffffffc, 0x00000007, 0x7fffffff, 0x7ffffff9, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x00085b36, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000015, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x329161f8, 0xfcd6e9e1, 0x71c71c71, 0x71c71c71, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000fff, 0xeffe0002, 0x0000ffff, 0x0ffffffe, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x0000005c, 0x0000002e, 0x00000002, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0xffffb839, 0x0002cd62, 0xffffb843, 0xfffffff6, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x7fffceec, 0x00000000, 0x80000000, 0xffff9dd8, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0xffffcf4a, 0x004def30, 0xfffffe58, 0xffffd0f2, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x3ffffffb, 0x80000008, 0x7ffffff8, 0x7fffffff, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x7fffff24, 0x80000000, 0x80000000, 0xfffffe49, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000001, 0xfffffffc, 0x7fffffff, 0x00000004, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x000009ee, 0x5af151c4, 0x001e4dca, 0x0053e53a, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x06f539d5, 0x92a45fc4, 0x08b2884b, 0xcccccccc, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x7fc9ef10, 0xfd773484, 0xff93de16, 0x80000006, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x7fffffc6, 0x80000000, 0xffffff8d, 0x80000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x7ffffffb, 0x00000008, 0x7fffffff, 0xfffffff8, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x3fffffff, 0x80000000, 0x80000000, 0x7fffffff, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000003, 0xfc03fc00, 0x00000004, 0xff00ff00, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x7fffff15, 0x00000000, 0x80000000, 0xfffffe2a, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x3fffffff, 0x80000000, 0x80000000, 0x7fffffff, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x8000001f, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x00000074, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x000001a4, 0x00000000, 0x00000348, 0x80000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x0574b162, 0xcaca899b, 0x0574cbe1, 0xfffb24fb, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x40000000, 0x00000000, 0x80000000, 0x80000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x0efffffe, 0x4ffffffa, 0xf0000003, 0x0ffffffe, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x000000d1, 0x7ffff2e8, 0x00000346, 0x3ffffffc, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x80000000, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x3fffffff, 0x80000000, 0x80000000, 0x7fffffff, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x30000000, 0x69999999, 0x33333333, 0xf0000003, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x7fffffff, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x3fffffff, 0xffffffff, 0x80000001, 0x7fffffff, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x093a7f8a, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00007735, 0xffff88ca, 0x00007736, 0xffffffff, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x009488a6, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x7f057c01, 0x944d7360, 0x8e38e38e, 0xe4a378d0, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x0064c309, 0xfcd9e7b0, 0x00c98614, 0x7ffffffc, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x0000000f, 0x80000000, 0x80000000, 0x0000001f, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x7ffffffe, 0x80000000, 0xfffffffd, 0x80000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000003, 0xdfffffc2, 0x0000001f, 0x1ffffffe, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x0ffffff8, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x0dfb8d31, 0x6408e59d, 0x1bf71a63, 0x7fffffff, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0xffffffa0, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0xc0000003, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x40000003, 0x80000000, 0x80000007, 0x80000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0xf8000001, 0x0ffffffa, 0xf8000003, 0xfffffffe, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x0003f590, 0xfe053780, 0x7fffffc0, 0x0007eb22, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000003, 0xfff80180, 0xfffe0060, 0x00000004, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x0000001f, 0x80000000, 0x0000003f, 0x80000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00041824, 0x00000206, 0x00000206, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x749e996a, 0x96c2cd29, 0xe93d32d7, 0x7fffffff, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x3fffffff, 0x00000001, 0x7fffffff, 0x7fffffff, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x0000010f, 0x8fffbc1c, 0x000021f2, 0x07fffffe, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00878b27, 0x000066f7, 0x00000151, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000003, 0x00000000, 0x00000006, 0x80000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0xc000000f, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0xfff168d9, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00ff00fe, 0x47b847b9, 0x00ff00ff, 0xffffff47, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x7c000007, 0x50000012, 0x80000006, 0xf8000003, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00c11193, 0x0003c921, 0x00000033, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x7fffffeb, 0x00000028, 0x7fffffff, 0xffffffd8, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00003a82, 0x7ffe2bec, 0x00007505, 0x7ffffffc, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0xfffffffa, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x01145411, 0xf534b74c, 0x0228a824, 0x7ffffffb, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0xffffffdb, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x000001c0, 0x7ffffc7f, 0x00000381, 0x7fffffff, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0xf8000001, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x33333333, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000004, 0xfffffff6, 0x0000000a, 0x7fffffff, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x66666666, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x1b27e4eb, 0xa9477b41, 0xdb6db6db, 0x1fae8b13, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x0000be96, 0x0000261e, 0x00000005, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x55555551, 0xaaaaaaae, 0xfffffff6, 0x55555555, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0xe000000f, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x0003995e, 0xfff8cd42, 0xfffffffe, 0x0003995f, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x3ffffffc, 0x80000006, 0x7ffffffa, 0x7fffffff, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000018, 0xdb6db6b2, 0x0000003a, 0x6db6db6d, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x7ffff9a6, 0x80000000, 0x80000000, 0xfffff34d, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x7ffffffe, 0x80000001, 0x7fffffff, 0xffffffff, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x0000ffff, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x3fffffff, 0x80000000, 0x7fffffff, 0x80000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x0000000f, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x3fffffff, 0x00000001, 0x7fffffff, 0x7fffffff, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x5555555e, 0xfffffff6, 0xaaaaaaaa, 0x8000000f, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x80000000, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x0000045c, 0x7ffff747, 0x000008b9, 0x7fffffff, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x40000000, 0x00000000, 0x80000000, 0x80000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x0ffffffd, 0xe0000004, 0x1ffffffc, 0x7fffffff, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x0f47fd80, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x61861860, 0xf3cf3cf4, 0x92492492, 0xaaaaaaaa, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x000b3ecb, 0xbc200518, 0x000b3ede, 0xfffe6034, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x3fffffff, 0x80000000, 0x7fffffff, 0x80000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x6fffffff, 0x9fffffff, 0xe0000001, 0x7fffffff, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x965ed6bb, 0x9649f1c4, 0xc43375ce, 0xc43375ce, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x01a780d2, 0xfcb0fe5a, 0x034f01a6, 0x7fffffff, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x000147f5, 0xfffeb80a, 0x000147f6, 0xffffffff, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x0000001d, 0x1000001f, 0x0000001f, 0xf0000001, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000004, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0xff2e87d4, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x7fffffff, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000001, 0x493e3209, 0x0000001f, 0x0a9ee8d7, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x3fffffff, 0x00000001, 0x7fffffff, 0x7fffffff, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x07cebd1b, 0x00000001, 0x07cebd1b, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x0000000c, 0x8787877b, 0x000000d5, 0x0f0f0f0f, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x05d59a7e, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x7fffc139, 0x00007d8c, 0x7fffffff, 0xffff8274, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0xffaa6169, 0xffaa6169, 0x00000001, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000026, 0x00000000, 0x0000004c, 0x80000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x000021e6, 0xc9462000, 0x0000b200, 0x30c1d990, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x4000000d, 0x7fffff84, 0x8000001f, 0x7ffffffc, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x1999999a, 0x4ccccccc, 0x33333333, 0x80000004, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x7fffffc2, 0xfffffe80, 0xffffff80, 0x80000003, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x1c71c71b, 0xc71c71c8, 0x1c71c71c, 0xfffffffe, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0xeffffffb, 0x7fffffe8, 0xfffffff8, 0xf0000003, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x0000001a, 0x00000000, 0x00000034, 0x80000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x004dffc5, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0xb6db6db6, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x80000002, 0x7ffffffd, 0xffffffff, 0x80000003, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0xfffffb6c, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x3ffffff0, 0x00000000, 0x7fffffe0, 0x80000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x1fffffff, 0xa4924924, 0xe0000001, 0x24924924, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000007, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x78afbbdb, 0x1d41108c, 0x7ffffffe, 0xf15f77ba, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x7f807f80, 0x00000000, 0x80000000, 0xff00ff00, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x01865853, 0x80000000, 0x80000000, 0x030cb0a7, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x276b6547, 0x0d23cc6d, 0x00000003, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x7ffffffe, 0x80000001, 0xffffffff, 0x7fffffff, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x7fff8000, 0x00000000, 0x80000000, 0xffff0000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x3fffffff, 0x00000001, 0x7fffffff, 0x7fffffff, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x7fffffff, 0x00000000, 0xfffffffe, 0x80000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x000001e3, 0x00004dfc, 0xc000001f, 0x00000284, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0xf9e53251, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x4000003d, 0xfffffe83, 0x8000007f, 0x7ffffffd, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x40000001, 0x00000000, 0x80000002, 0x80000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x0000795a, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x003dbb65, 0x00000000, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x000024fc, 0x0000062a, 0x00000006, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0xb216ed65, 0x736f7568, 0xf9534c5c, 0xb6db6db6, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x0fcf55dc, 0xc0c2a88c, 0x0fcf55dd, 0xfffffffc, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x6db6c500, 0xb6db9316, 0x6db6db6d, 0xffffcbae, 0x0, 0x0
	dspck_astio multu, 0x0, 0x0, 0x00000000, 0x00000000, 0x00000000, 0x00ff00ff, 0x0, 0x0

	writemsg "[25] Test precr.qb.ph"
	dspck_dstio precr.qb.ph, 0x997ce000, 0xfa99ff7c, 0x1fe08000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x00000000, 0x80000000, 0x00000000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x0008ff00, 0x80000008, 0x7fff8000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xbd1e1b49, 0xe1bd001e, 0x001b9249, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xf848d166, 0x0ff80448, 0xfdd10a66, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x0600feab, 0x00068000, 0xfffe1cab, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xffff023e, 0x7fffffff, 0x0002003e, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xfe3300e6, 0xfffe3333, 0x8000fbe6, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xdbffffe9, 0xb6db7fff, 0xffffd3e9, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x00000092, 0x00000000, 0x0000f892, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x0080ff53, 0x80007f80, 0x7fff0753, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x006e0306, 0x8000ff6e, 0xe0030006, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x88dbf0f7, 0x0088b6db, 0x7ff000f7, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xaae5aac3, 0xaaaaffe5, 0xfcaa07c3, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xfdfe5549, 0xfffd3ffe, 0x55559249, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x05e1acff, 0x8005ffe1, 0x09ac7fff, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x000007fe, 0x00000000, 0xc0071ffe, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xe7fbdfde, 0xfee77ffb, 0xebdf02de, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xfe0133ff, 0x1ffe0001, 0xfd337fff, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xfa793f02, 0x7ffa0c79, 0x803f0002, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xf9ff0000, 0xfff97fff, 0x00008000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x8eff0122, 0xe38e7fff, 0xf0010022, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x00e80000, 0x0000ffe8, 0x00000000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xffffe300, 0x7fff7fff, 0xffe30000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x00ff000a, 0x00007fff, 0x0000000a, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x3fff1f00, 0xc03f7fff, 0x801f8000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x1300fff8, 0x00130000, 0x7fff3ff8, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x0000c366, 0x00000000, 0x00c36666, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xfffd0094, 0x7ffffffd, 0x80000094, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x0000e3ff, 0x00000000, 0x38e3ffff, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xfdc3f600, 0xfffdffc3, 0x02f60000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x03f800ff, 0x00031ff8, 0x00007fff, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xeb00e04a, 0xffeb8000, 0xffe0024a, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xfefffd8e, 0x0ffe7fff, 0xfffdf78e, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xfff8b901, 0x00fffff8, 0xf3b9c001, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x3a330000, 0x003a3333, 0x00008000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xff023ffe, 0x7fff8002, 0xc03f07fe, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xaae0ff02, 0xaaaaffe0, 0x7fff0002, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xffc0ff49, 0x7fff3fc0, 0x7fff3949, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xff00af00, 0x7fff8000, 0x0faf0000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xff000005, 0x7fff0000, 0x80008005, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x03000000, 0x00030000, 0x00000000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xf038fa00, 0x7ff08e38, 0xfffa8000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x0060036d, 0x00000060, 0x0003ff6d, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x00000f5c, 0x00000000, 0xf90fdd5c, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xffff3392, 0x7fffffff, 0x33332492, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x07800001, 0xf007ff80, 0xff008001, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x00fcf803, 0x80000ffc, 0x3ff8f003, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x07fffff0, 0xc0077fff, 0x7ffff0f0, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x0f354101, 0xc00fff35, 0x0441f801, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xff02fc03, 0x7fff0002, 0x3ffcf803, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xb1ffb1ff, 0x00b17fff, 0x00b17fff, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x33f005ff, 0x3333fff0, 0x80057fff, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x3fffff00, 0xc03f7fff, 0x7fff0000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xfc000000, 0x3ffc8000, 0x00000000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x09003855, 0x00098000, 0x8e385555, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xe0fff8fc, 0xffe07fff, 0xfff8fffc, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x0000240f, 0x00000000, 0x4924000f, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x07c003f0, 0xf0077fc0, 0xe003f0f0, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xff000000, 0x7fff0000, 0x00000000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x00dd0000, 0x80000cdd, 0x00000000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xe80000f8, 0xffe80000, 0x8000fff8, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x38490c04, 0x8e38f549, 0x000c8004, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xf1fef9f9, 0xfff1fffe, 0xfff97ff9, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xffa13f00, 0x7fffffa1, 0xc03f8000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x00ff00ff, 0x80007fff, 0x80007fff, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xfc000105, 0x7ffc0000, 0xf8010005, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xff000000, 0x7fff8000, 0x00000000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x0002ff49, 0x80008002, 0xffff9249, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x0100fdc8, 0x80018000, 0xfffd02c8, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xf001ff00, 0x7ff00001, 0x7fff0000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x0005f800, 0x00000005, 0x7ff88000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x00fe00fe, 0x8000fffe, 0x8000fffe, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x3fc0ff00, 0xc03f3fc0, 0x7fff0000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xf80001fd, 0x3ff88000, 0x00017ffd, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x0001ff87, 0x00000001, 0x7ffffe87, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xf96600ff, 0xfff9f566, 0x8000ffff, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x6d7efef2, 0xdb6d007e, 0x07fefff2, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xfffc0000, 0x7fff1ffc, 0x00000000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x00e2c7ff, 0x0000ffe2, 0x71c77fff, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x0001fff8, 0x8000fc01, 0x7fff1ff8, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xdb03dfc0, 0xffdb0003, 0xe6dfffc0, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xf8009200, 0x1ff88000, 0x24920000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x00801c00, 0x00007f80, 0xc71c8000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x00cc0ee4, 0x8000cccc, 0x000effe4, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x15180000, 0xfe150318, 0x80000000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xf8000000, 0x0ff88000, 0x00000000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xe1001cff, 0xfde10000, 0xc71c7fff, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x00f800f3, 0x80003ff8, 0x000035f3, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xfffe0103, 0x7fff7ffe, 0x80010003, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xfcf9fcf9, 0xfffc7ff9, 0xfffc7ff9, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x0000e300, 0x80008000, 0x38e30000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x00fffd08, 0xff007fff, 0xfffd1008, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x015cfc00, 0xfc01fb5c, 0xfffc0000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xfe130000, 0x0ffe0113, 0x00000000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x7805f001, 0x00780005, 0xf0f0c001, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x06ffff2f, 0xf0067fff, 0x7fff002f, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x000017e0, 0x80000000, 0x0a173fe0, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xf7c0061c, 0xfff73fc0, 0x8006fa1c, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xfcc400eb, 0x07fce9c4, 0xff00f3eb, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x03808fff, 0xe003ff80, 0x1c8fffff, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x3cf0fcf0, 0x003cf0f0, 0xfffcfff0, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x01f50800, 0xf001fff5, 0x00088000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xfc070f01, 0xfffcc007, 0x800fc001, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x3ff30366, 0x803ffff3, 0x00036666, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x7f5700ff, 0x2b7f0257, 0xec007fff, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xffd1c07f, 0x7fff26d1, 0x3fc0007f, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x0801c747, 0x0008f001, 0x71c7fc47, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xe0994f00, 0x7fe09999, 0x094f8000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x3c238e01, 0xff3cef23, 0xe38ec001, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x02fc0462, 0x0002fffc, 0x00040f62, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xf8018bf9, 0xfff8e001, 0x018bfff9, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xb6fff001, 0x6db6ffff, 0xfff0e001, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xed000000, 0x02ed8000, 0x00000000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xff03ff00, 0xfffff803, 0x7fff8000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xf805f805, 0xfff88005, 0xfff88005, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xe7ee3f33, 0xe2e731ee, 0x803f3333, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x00fe0000, 0x00001ffe, 0x80000000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x00f91f00, 0x8000fff9, 0xe01f0000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x89fc0000, 0xff890ffc, 0x00000000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xfb07e767, 0xfffbc007, 0xffe70167, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x3360fab6, 0x0033fe60, 0xfffa6db6, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xfb00fe00, 0x7ffb0000, 0xfffe8000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x00011c1b, 0x8000c001, 0xc71c001b, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xfff8fff8, 0x7fff1ff8, 0x7fff1ff8, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xff8f71fe, 0xfffff88f, 0x1c717ffe, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x0306fce0, 0x00038006, 0xfffc7fe0, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x000000ff, 0x00008000, 0x0000ffff, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x4a00ffcb, 0xff4a8000, 0x7ffff8cb, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x00ff3300, 0x00007fff, 0x33330000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x00e00000, 0x00003fe0, 0x00000000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x9202f8ff, 0x24920002, 0x1ff800ff, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x00fa1c00, 0x0000fffa, 0xc71c8000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x1f3fc03f, 0xc01fc03f, 0xffc0003f, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x00f00000, 0x80003ff0, 0x00000000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x24ff1e00, 0x49247fff, 0x0e1e0000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x5dff5dff, 0xfe5dffff, 0xfe5dffff, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x00c0ffea, 0x00007fc0, 0x7fff00ea, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x00000000, 0x00008000, 0x00008000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xfffff713, 0x7fff7fff, 0x01f70013, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x01c9b6de, 0x8001ffc9, 0xe4b6fcde, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x00000007, 0x00000000, 0x80008007, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xc800d151, 0x00c88000, 0xffd10351, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xeaf80000, 0xffea3ff8, 0x80000000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x92fcfc2b, 0x24923ffc, 0xfffcf72b, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xfe10a803, 0x03fe0310, 0xffa8c003, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x003f51f2, 0x8000803f, 0xfe51d6f2, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x0fbcfcff, 0x800fffbc, 0xfffc7fff, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x71000ef0, 0x1c718000, 0x0e0ef0f0, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x00ff0001, 0x80007fff, 0x00000001, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x22f0e005, 0x00221ff0, 0x11e00005, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xffa506ff, 0x7ffff8a5, 0x00067fff, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x00b9faa3, 0x8000ffb9, 0xfffaffa3, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x00f0c7fb, 0x00003ff0, 0xf3c77ffb, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xfe6dd500, 0xfffedb6d, 0xfed58000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x00ff8bf2, 0x00007fff, 0xff8bfff2, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x00ff8cf0, 0x00007fff, 0x018cf0f0, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x01003f86, 0xf8018000, 0xc03f0086, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xff008c07, 0x7fffff00, 0xf18cf007, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xfb3f3600, 0xfffb003f, 0xff360000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x000c1f00, 0x0000fc0c, 0x801f0000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x000008b1, 0x00000000, 0x0008fab1, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xaaffaaff, 0xaaaaffff, 0xaaaaffff, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x00fcfee3, 0x8000fffc, 0x07feffe3, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x0000feff, 0x80000000, 0x0ffe7fff, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x00330033, 0x80001e33, 0x80001e33, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xfc00fecc, 0x07fc8000, 0xfffecccc, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xf904ff02, 0xfff90004, 0x7fff0002, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x00fd002b, 0x0000fffd, 0x8000ff2b, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x1c6dfc00, 0xc71cdb6d, 0x1ffc8000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xf8fe49fc, 0xfff83ffe, 0x92491ffc, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xfb3f0480, 0xfffbc03f, 0x0004ff80, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xda1500f0, 0x27da0015, 0x80003ff0, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x3f00009a, 0x803f8000, 0x0000fe9a, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xaafff001, 0xaaaa7fff, 0x3ff0fc01, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x0004ff71, 0x00000004, 0x7ffff271, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x00f80000, 0x80003ff8, 0x00000000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x006a0000, 0x8000016a, 0x00000000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x01a04801, 0xf001f5a0, 0x1f480001, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x05ffffb1, 0x80057fff, 0x00ff00b1, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x0000ffff, 0x00000000, 0x7fff7fff, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x40ff40ff, 0x00407fff, 0x00407fff, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x07fff538, 0xf007ffff, 0xfff58e38, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x0000002e, 0x80008000, 0x8000df2e, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x4800b200, 0xff480000, 0xfcb28000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xc0ff0000, 0x7fc07fff, 0x00000000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x000007fc, 0x00000000, 0x00070ffc, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xff3ffffe, 0x7ffffc3f, 0x7ffffffe, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x005f00ff, 0x8000005f, 0x00007fff, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xfeff80aa, 0x07fe7fff, 0x7f80aaaa, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x0000250e, 0x00000000, 0xff25000e, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xf30100c0, 0xfff30001, 0x8000fbc0, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xfc00ffc2, 0xfffc8000, 0x7fff00c2, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xf6ff6a05, 0x00f67fff, 0xff6a0005, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x38004100, 0x8e380000, 0x01418000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x00000f00, 0x80008000, 0xe00f8000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x491cf0ff, 0x0049001c, 0xf0f07fff, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x051f16f8, 0x0005801f, 0x01161ff8, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xefb6c9f0, 0xffef6db6, 0xdac97ff0, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xff6fff6f, 0x7fffea6f, 0x7fffea6f, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x019d0000, 0x0001ff9d, 0x00000000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x00003b8b, 0x00008000, 0x003b028b, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x1a29ff06, 0x001a0029, 0x7fff8006, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xd3d2fffc, 0x1ad3f3d2, 0x7fff7ffc, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xff000000, 0x7fff8000, 0x00000000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x12f07a00, 0x00127ff0, 0xfe7a8000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xfffffa00, 0x7fff7fff, 0xfffa0000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x007a0000, 0x0000007a, 0x00000000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xfffdfffd, 0x7fff7ffd, 0x7fff7ffd, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x000003ff, 0x00000000, 0xe0037fff, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x0f010f01, 0x800ffc01, 0x800ffc01, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x0001f1fe, 0x80000001, 0xfff1fffe, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x00000003, 0x00008000, 0x00000003, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x00fb0f09, 0x80007ffb, 0xc00f0009, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x7f5501ff, 0x807f5555, 0x00017fff, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xfcff00ff, 0x0ffc7fff, 0x80007fff, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xfef8ef00, 0xfffefff8, 0xfeef0000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x03f60083, 0x0003fff6, 0x80000a83, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x1ffe0725, 0x801f1ffe, 0x00070b25, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xfffff700, 0x7fff7fff, 0xfff70000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x005c0100, 0x8000025c, 0x00010000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x0146ff00, 0x00010046, 0x7fff8000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xfff9fffe, 0x7ffffff9, 0x7ffffffe, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x1f0266e0, 0x001f0002, 0x66661fe0, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xfe00031f, 0xfffe0000, 0xc003801f, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x0000ff35, 0x00000000, 0x7fff0035, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xff00001f, 0x7fff0000, 0x8000011f, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x9c1c010a, 0xd39cc71c, 0x0001000a, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xff070077, 0x7fffc007, 0x0000ff77, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x1efe008f, 0x051efffe, 0x8000ff8f, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xbb03fec0, 0xffbbf803, 0xfffe3fc0, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x0002fe00, 0x80000002, 0x3ffe8000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xddffddff, 0xffdd7fff, 0xffdd7fff, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x00001fff, 0x00008000, 0x801f7fff, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xb6c7fe00, 0x6db6ffc7, 0x3ffe0000, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x0ff800f1, 0x000ffff8, 0x0000fff1, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x1a2c008d, 0x011aff2c, 0x0000ff8d, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x03d00209, 0x0303ffd0, 0x8002d309, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x028bfffd, 0x0002ff8b, 0xffff7ffd, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0x000000fe, 0x00000000, 0x0000fffe, 0x0, 0x0
	dspck_dstio precr.qb.ph, 0xfff90000, 0x7ffffff9, 0x00000000, 0x0, 0x0

	writemsg "[26] Test precr_sra.ph.w"
	dspck_tsimm precr_sra.ph.w, 0x00000000, 0x00000000, 0x00000000, 13
	dspck_tsimm precr_sra.ph.w, 0x00000028, 0x0000ffff, 0x00283a6e, 16
	dspck_tsimm precr_sra.ph.w, 0xffffffc0, 0x7fffffff, 0xffffffc0, 0
	dspck_tsimm precr_sra.ph.w, 0xf0f00000, 0xf0f0f0f0, 0x00000000, 0
	dspck_tsimm precr_sra.ph.w, 0x71c7fffe, 0x38e38e38, 0xfffffff0, 3
	dspck_tsimm precr_sra.ph.w, 0x000fffff, 0x7fffffff, 0xf8000003, 27
	dspck_tsimm precr_sra.ph.w, 0x00000000, 0x00004aa2, 0x00000010, 31
	dspck_tsimm precr_sra.ph.w, 0x0000fffc, 0x00000004, 0x80000000, 29
	dspck_tsimm precr_sra.ph.w, 0x55558e38, 0x55555555, 0x38e38e38, 0
	dspck_tsimm precr_sra.ph.w, 0xffff0000, 0xffffffeb, 0x000019ad, 31
	dspck_tsimm precr_sra.ph.w, 0x00000000, 0xf0000001, 0x00000000, 2
	dspck_tsimm precr_sra.ph.w, 0x00000000, 0x0ffffff8, 0x7fffffff, 31
	dspck_tsimm precr_sra.ph.w, 0x1fff1fff, 0x7fffffff, 0x7fffffff, 18
	dspck_tsimm precr_sra.ph.w, 0xffff0000, 0x7fffffff, 0x00000000, 3
	dspck_tsimm precr_sra.ph.w, 0x0000ffff, 0x00000000, 0xfffffff9, 31
	dspck_tsimm precr_sra.ph.w, 0xdb6d0734, 0xb6db6db6, 0x00073400, 8
	dspck_tsimm precr_sra.ph.w, 0x0000ffff, 0x00000000, 0xfffee2a8, 29
	dspck_tsimm precr_sra.ph.w, 0xffff0000, 0xfff8c7ef, 0x00000000, 30
	dspck_tsimm precr_sra.ph.w, 0xaa370000, 0xff0daa37, 0x00000000, 0
	dspck_tsimm precr_sra.ph.w, 0x55550000, 0x55555555, 0x80000000, 12
	dspck_tsimm precr_sra.ph.w, 0x92490000, 0x92492492, 0x00000000, 1
	dspck_tsimm precr_sra.ph.w, 0xffff0000, 0x7fffffff, 0x00000000, 3
	dspck_tsimm precr_sra.ph.w, 0x00000000, 0x00000007, 0x00000000, 30
	dspck_tsimm precr_sra.ph.w, 0x00000000, 0x7fffffff, 0x00000000, 31
	dspck_tsimm precr_sra.ph.w, 0xffffffff, 0x7fffffff, 0xfffffffd, 6
	dspck_tsimm precr_sra.ph.w, 0xffff0000, 0xff00ff00, 0x7ffffffb, 31
	dspck_tsimm precr_sra.ph.w, 0xffff0000, 0xffffffff, 0x0000245d, 31
	dspck_tsimm precr_sra.ph.w, 0xfffb007f, 0x7ffffffb, 0x8000007f, 0
	dspck_tsimm precr_sra.ph.w, 0xffe5ffff, 0xffffffe5, 0x7fffffff, 0
	dspck_tsimm precr_sra.ph.w, 0x0007ffff, 0x7fffffff, 0xfe942219, 28
	dspck_tsimm precr_sra.ph.w, 0x0000ffff, 0x00000000, 0x7fffffff, 0
	dspck_tsimm precr_sra.ph.w, 0x00ff00ff, 0x000000ff, 0x000000ff, 0
	dspck_tsimm precr_sra.ph.w, 0xffff0000, 0xffffff2f, 0x00000000, 31
	dspck_tsimm precr_sra.ph.w, 0x001f0000, 0x8000001f, 0x80000000, 0
	dspck_tsimm precr_sra.ph.w, 0x00000000, 0x3ffffffc, 0x7fffffff, 31
	dspck_tsimm precr_sra.ph.w, 0x00002492, 0x80000000, 0x92492492, 0
	dspck_tsimm precr_sra.ph.w, 0xc000f800, 0x80000000, 0xf0000001, 17
	dspck_tsimm precr_sra.ph.w, 0xffff0000, 0xc71c71c7, 0x07fffffe, 31
	dspck_tsimm precr_sra.ph.w, 0x0000ffa3, 0x80000000, 0xfffffd1d, 3
	dspck_tsimm precr_sra.ph.w, 0xffff0230, 0x7fffffff, 0x00000230, 0
	dspck_tsimm precr_sra.ph.w, 0x0000fffc, 0x00000000, 0x80000000, 29
	dspck_tsimm precr_sra.ph.w, 0x0000ffff, 0x00000006, 0x7fffffff, 9
	dspck_tsimm precr_sra.ph.w, 0x0002ffff, 0x00000005, 0x7fffffff, 1
	dspck_tsimm precr_sra.ph.w, 0xfffffef5, 0x7fffffff, 0xfffffef5, 0
	dspck_tsimm precr_sra.ph.w, 0x912b5555, 0x0832912b, 0x55555555, 0
	dspck_tsimm precr_sra.ph.w, 0xb4c30002, 0xfd05b4c3, 0x00000002, 0
	dspck_tsimm precr_sra.ph.w, 0x0000ffff, 0x0000000f, 0x7ffffff9, 4
	dspck_tsimm precr_sra.ph.w, 0xff80fff1, 0xffffff80, 0xfffffff1, 0
	dspck_tsimm precr_sra.ph.w, 0xffff0000, 0x80000000, 0x0000705a, 31
	dspck_tsimm precr_sra.ph.w, 0x0000ff00, 0x00000000, 0xffffff00, 0
	dspck_tsimm precr_sra.ph.w, 0x3af90000, 0xffba75f2, 0x80000000, 1
	dspck_tsimm precr_sra.ph.w, 0x07ffffff, 0x1ffffff0, 0xfffffeae, 18
	dspck_tsimm precr_sra.ph.w, 0xffff0000, 0xfffffff9, 0x80000000, 10
	dspck_tsimm precr_sra.ph.w, 0x00000000, 0x00000000, 0x00000049, 10
	dspck_tsimm precr_sra.ph.w, 0x0000ab83, 0x80000000, 0x000b5706, 1
	dspck_tsimm precr_sra.ph.w, 0xffc0ffc0, 0x80000000, 0x8000007f, 25
	dspck_tsimm precr_sra.ph.w, 0x00000000, 0x00000000, 0x00000002, 27
	dspck_tsimm precr_sra.ph.w, 0xffff0000, 0xffffffb1, 0x00000015, 31
	dspck_tsimm precr_sra.ph.w, 0xf83d0000, 0x00ddf07a, 0x00000000, 1
	dspck_tsimm precr_sra.ph.w, 0x0000fff8, 0x80000000, 0x3ffffff8, 0
	dspck_tsimm precr_sra.ph.w, 0x0000fffc, 0x00000000, 0x0ffffffc, 0
	dspck_tsimm precr_sra.ph.w, 0x0003ffff, 0xc0000003, 0x7fffffff, 0
	dspck_tsimm precr_sra.ph.w, 0xffff0000, 0xc0000001, 0x00000000, 31
	dspck_tsimm precr_sra.ph.w, 0xfffc0000, 0xfffffffc, 0x00000000, 0
	dspck_tsimm precr_sra.ph.w, 0xfff9ffff, 0xfffffff9, 0x7fffffff, 0
	dspck_tsimm precr_sra.ph.w, 0xffea3aef, 0xffffffea, 0xffff3aef, 0
	dspck_tsimm precr_sra.ph.w, 0xffff0003, 0xffff4871, 0x19692a52, 27
	dspck_tsimm precr_sra.ph.w, 0xfffe0000, 0xfcb6a83c, 0x00000000, 25
	dspck_tsimm precr_sra.ph.w, 0x00000000, 0x3fffffe0, 0x7ffffffc, 31
	dspck_tsimm precr_sra.ph.w, 0xc71caaaa, 0x38e38e38, 0x55555555, 1
	dspck_tsimm precr_sra.ph.w, 0x5e5cfffe, 0x00017971, 0x7ffffffa, 2
	dspck_tsimm precr_sra.ph.w, 0x00000000, 0x00000004, 0x80000000, 6
	dspck_tsimm precr_sra.ph.w, 0x00000000, 0x0001114c, 0x000000dd, 27
	dspck_tsimm precr_sra.ph.w, 0x00000001, 0x80000000, 0xf8000003, 1
	dspck_tsimm precr_sra.ph.w, 0xfc6770e9, 0xfffff8cf, 0x3142e1d3, 1
	dspck_tsimm precr_sra.ph.w, 0x9eb0f0f0, 0x00029eb0, 0xf0f0f0f0, 0
	dspck_tsimm precr_sra.ph.w, 0x000bfffe, 0x00000017, 0x7ffffffc, 1
	dspck_tsimm precr_sra.ph.w, 0x78720003, 0xeb027872, 0xf8000003, 0
	dspck_tsimm precr_sra.ph.w, 0xffff0000, 0xffffbc1b, 0x33333333, 31
	dspck_tsimm precr_sra.ph.w, 0x00000000, 0x0001bfb2, 0x7ffffffa, 31
	dspck_tsimm precr_sra.ph.w, 0xffff0000, 0x7fffffff, 0x80000000, 2
	dspck_tsimm precr_sra.ph.w, 0xfffffff1, 0x7fffffff, 0xfe67ff8f, 3
	dspck_tsimm precr_sra.ph.w, 0x6666fd7d, 0x66666666, 0xfffffd7d, 0
	dspck_tsimm precr_sra.ph.w, 0x00000000, 0x00000001, 0x0000003f, 6
	dspck_tsimm precr_sra.ph.w, 0xffffb6db, 0x7fffffff, 0xdb6db6db, 0
	dspck_tsimm precr_sra.ph.w, 0x00000000, 0x00000000, 0x014f24fb, 31
	dspck_tsimm precr_sra.ph.w, 0x6db60000, 0x6db6db6d, 0x80000000, 10
	dspck_tsimm precr_sra.ph.w, 0x00000000, 0x00000000, 0x0f0f0f0f, 31
	dspck_tsimm precr_sra.ph.w, 0xffc0bb38, 0x7fffffc0, 0x0d50bb38, 0
	dspck_tsimm precr_sra.ph.w, 0xffff0000, 0xfffffff9, 0x000001ca, 13
	dspck_tsimm precr_sra.ph.w, 0xb152ffff, 0xffff62a4, 0x7fffffff, 1
	dspck_tsimm precr_sra.ph.w, 0x0fffffff, 0x07fffffe, 0x7fffffff, 15
	dspck_tsimm precr_sra.ph.w, 0xffffffff, 0x3ffffffe, 0x7ffffffe, 1
	dspck_tsimm precr_sra.ph.w, 0xff920000, 0xffe489b1, 0x0000000b, 14
	dspck_tsimm precr_sra.ph.w, 0x34df7f80, 0x1e9469bf, 0xff00ff00, 1
	dspck_tsimm precr_sra.ph.w, 0x0000ffff, 0x02728de8, 0xffff5c80, 30
	dspck_tsimm precr_sra.ph.w, 0xffff5f0d, 0x7fffffff, 0x00045f0d, 0
	dspck_tsimm precr_sra.ph.w, 0xfffefea8, 0xfffffffe, 0xfffffea8, 0
	dspck_tsimm precr_sra.ph.w, 0x0000fc00, 0x00000000, 0xf0000001, 18
	dspck_tsimm precr_sra.ph.w, 0xffff0000, 0xff8942a6, 0x7fffffc0, 31
	dspck_tsimm precr_sra.ph.w, 0x00000000, 0x00000000, 0x00000000, 31
	dspck_tsimm precr_sra.ph.w, 0x7c470000, 0x0f88e8b9, 0x80000000, 13
	dspck_tsimm precr_sra.ph.w, 0xffff0000, 0x1ffffffc, 0x00000000, 8
	dspck_tsimm precr_sra.ph.w, 0x00000000, 0x7fffffff, 0x7fffffff, 31
	dspck_tsimm precr_sra.ph.w, 0x1249fe20, 0x00001249, 0xfffffe20, 0
	dspck_tsimm precr_sra.ph.w, 0xffff0000, 0xfffe8e4d, 0x00000007, 29
	dspck_tsimm precr_sra.ph.w, 0xffffffff, 0xfff8431e, 0xf0000001, 31
	dspck_tsimm precr_sra.ph.w, 0x00000000, 0x00011d30, 0x000003ea, 30
	dspck_tsimm precr_sra.ph.w, 0xfffefffe, 0x7ffffffa, 0x7ffffff8, 2
	dspck_tsimm precr_sra.ph.w, 0x00003fc0, 0x80000000, 0xff00ff00, 2
	dspck_tsimm precr_sra.ph.w, 0x0000ffff, 0x80000000, 0x7fffffff, 0
	dspck_tsimm precr_sra.ph.w, 0x0028ffe1, 0x0000028e, 0xfffffe18, 4
	dspck_tsimm precr_sra.ph.w, 0x00006b69, 0x80000000, 0x004c6b69, 0
	dspck_tsimm precr_sra.ph.w, 0x00010072, 0xf8000001, 0x00000072, 0
	dspck_tsimm precr_sra.ph.w, 0x5154ffff, 0xfda8aa16, 0xffffff80, 7
	dspck_tsimm precr_sra.ph.w, 0x00000000, 0x00000000, 0x00000000, 31
	dspck_tsimm precr_sra.ph.w, 0x003f0001, 0x7fffffff, 0x038f9b87, 25
	dspck_tsimm precr_sra.ph.w, 0x0fff0000, 0x3fffffe0, 0x00000000, 18
	dspck_tsimm precr_sra.ph.w, 0xfffc0000, 0xc000001f, 0x00000000, 28
	dspck_tsimm precr_sra.ph.w, 0xffff0000, 0xff00ff00, 0x00000006, 31
	dspck_tsimm precr_sra.ph.w, 0xfe40fead, 0xfffffe40, 0xfffffead, 0
	dspck_tsimm precr_sra.ph.w, 0x00000000, 0x00000000, 0x00000000, 2
	dspck_tsimm precr_sra.ph.w, 0xfcbc001a, 0xfffff978, 0x00000034, 1
	dspck_tsimm precr_sra.ph.w, 0x2492fffc, 0x24924924, 0x0ffffff8, 1
	dspck_tsimm precr_sra.ph.w, 0x65590000, 0x09f19567, 0xf8000001, 2
	dspck_tsimm precr_sra.ph.w, 0x00000000, 0x0004db12, 0x00000000, 31
	dspck_tsimm precr_sra.ph.w, 0x00070007, 0xc0000007, 0xc0000007, 0
	dspck_tsimm precr_sra.ph.w, 0x0000f807, 0x80000000, 0x00ff00ff, 5
	dspck_tsimm precr_sra.ph.w, 0x0000ffff, 0x00000000, 0x7fffffff, 6
	dspck_tsimm precr_sra.ph.w, 0x00000000, 0x00000004, 0x00000004, 3
	dspck_tsimm precr_sra.ph.w, 0x7fff0000, 0x7fffffff, 0x00000003, 16
	dspck_tsimm precr_sra.ph.w, 0xffffffff, 0xe000000f, 0xe000000f, 31
	dspck_tsimm precr_sra.ph.w, 0xfff0fff0, 0x3ffffff0, 0x3ffffff0, 0
	dspck_tsimm precr_sra.ph.w, 0xffffffff, 0xffff0000, 0xc0000001, 31
	dspck_tsimm precr_sra.ph.w, 0x0000ffff, 0x0ffffffc, 0x80000000, 31
	dspck_tsimm precr_sra.ph.w, 0x00000000, 0x80000000, 0x80000000, 15
	dspck_tsimm precr_sra.ph.w, 0x00000000, 0x3ffffffe, 0x00003717, 31
	dspck_tsimm precr_sra.ph.w, 0x00070a24, 0xc0000007, 0x00000a24, 0
	dspck_tsimm precr_sra.ph.w, 0xfffe8529, 0x3ffffffe, 0x019f8529, 0
	dspck_tsimm precr_sra.ph.w, 0xfffbff80, 0xfffffffb, 0x7fffff80, 0
	dspck_tsimm precr_sra.ph.w, 0x38e30000, 0x38e38e38, 0xfc000001, 10
	dspck_tsimm precr_sra.ph.w, 0xfffd3127, 0xfffffffa, 0xd986624f, 1
	dspck_tsimm precr_sra.ph.w, 0xfff3ffff, 0xffffff33, 0x1ffffffe, 4
	dspck_tsimm precr_sra.ph.w, 0xbbf30003, 0x0003bbf3, 0xf8000003, 0
	dspck_tsimm precr_sra.ph.w, 0xffff0000, 0xffffffe3, 0x00000000, 12
	dspck_tsimm precr_sra.ph.w, 0x9249ffff, 0x92492492, 0xfffffffd, 7
	dspck_tsimm precr_sra.ph.w, 0xffffffff, 0x80000000, 0xfffffffd, 31
	dspck_tsimm precr_sra.ph.w, 0x0000fff9, 0x001540d2, 0x99999999, 28
	dspck_tsimm precr_sra.ph.w, 0xffffffff, 0x80000000, 0x8000000f, 31
	dspck_tsimm precr_sra.ph.w, 0xffffffff, 0xfc889cce, 0x80000000, 31
	dspck_tsimm precr_sra.ph.w, 0xffea0000, 0xffffff52, 0x80000000, 3
	dspck_tsimm precr_sra.ph.w, 0x0f0f0000, 0x0f0f0f0f, 0x80000000, 0
	dspck_tsimm precr_sra.ph.w, 0xffff0000, 0x7fffffff, 0x00000000, 15
	dspck_tsimm precr_sra.ph.w, 0x38060000, 0xff13806f, 0x80000000, 4
	dspck_tsimm precr_sra.ph.w, 0xffff8d70, 0x0000ffff, 0x00008d70, 0
	dspck_tsimm precr_sra.ph.w, 0x0000fffc, 0x000000c9, 0xe000000f, 27
	dspck_tsimm precr_sra.ph.w, 0x0000f000, 0x00000002, 0x8000001f, 19
	dspck_tsimm precr_sra.ph.w, 0x00000000, 0x00000000, 0x7fffffff, 31
	dspck_tsimm precr_sra.ph.w, 0x8e38003f, 0x38e38e38, 0x0000003f, 0
	dspck_tsimm precr_sra.ph.w, 0x00b80000, 0x000000b8, 0x00000000, 0
	dspck_tsimm precr_sra.ph.w, 0xffc00000, 0x80000004, 0x00000002, 25
	dspck_tsimm precr_sra.ph.w, 0xfffffd55, 0xfffd47dc, 0xaaaaaaaa, 21
	dspck_tsimm precr_sra.ph.w, 0x00000000, 0x00000000, 0x00000000, 4
	dspck_tsimm precr_sra.ph.w, 0x837d0000, 0xfffd06fb, 0x00000000, 1
	dspck_tsimm precr_sra.ph.w, 0x00002d30, 0x00000000, 0x00016985, 3
	dspck_tsimm precr_sra.ph.w, 0x000f0007, 0x0000000f, 0x00000007, 0
	dspck_tsimm precr_sra.ph.w, 0x00010000, 0x00000001, 0x00000000, 0
	dspck_tsimm precr_sra.ph.w, 0xff800000, 0x80000000, 0x0000007f, 24
	dspck_tsimm precr_sra.ph.w, 0x0f0f0000, 0xf0f0f0f0, 0x80000000, 4
	dspck_tsimm precr_sra.ph.w, 0x0000ffff, 0x0000ffff, 0xffe2a7e0, 31
	dspck_tsimm precr_sra.ph.w, 0x00003333, 0x00000000, 0x66666666, 17
	dspck_tsimm precr_sra.ph.w, 0xfbe9fbe9, 0xfffffbe9, 0xfffffbe9, 0
	dspck_tsimm precr_sra.ph.w, 0xffccffde, 0xffffffcc, 0xffffffde, 0
	dspck_tsimm precr_sra.ph.w, 0x0000001f, 0x00000000, 0x8000001f, 0
	dspck_tsimm precr_sra.ph.w, 0x000046ab, 0x80000001, 0x00023559, 3
	dspck_tsimm precr_sra.ph.w, 0xffff0007, 0x7fffffff, 0xe000000f, 1
	dspck_tsimm precr_sra.ph.w, 0x0000ffff, 0x7fffffff, 0xffffffc3, 31
	dspck_tsimm precr_sra.ph.w, 0xffff00ef, 0x7fffffff, 0x000003be, 2
	dspck_tsimm precr_sra.ph.w, 0xffffffff, 0x7ffffffe, 0x7fffffff, 1
	dspck_tsimm precr_sra.ph.w, 0x00000000, 0x00000007, 0x00000000, 13
	dspck_tsimm precr_sra.ph.w, 0x0001ffff, 0xf0000001, 0x7fffffff, 0
	dspck_tsimm precr_sra.ph.w, 0x00460046, 0x00000235, 0x00000235, 3
	dspck_tsimm precr_sra.ph.w, 0xffff0000, 0xffffffe1, 0x80000003, 9
	dspck_tsimm precr_sra.ph.w, 0xfffffff0, 0xfffffffe, 0xffffffe0, 1
	dspck_tsimm precr_sra.ph.w, 0x00000000, 0x7ffffff8, 0x49249249, 31
	dspck_tsimm precr_sra.ph.w, 0x00000000, 0x00000000, 0x7fffffff, 31
	dspck_tsimm precr_sra.ph.w, 0xfffffff0, 0xffffffe0, 0x80000000, 27
	dspck_tsimm precr_sra.ph.w, 0xff80fff2, 0x7fffff80, 0xfffffff2, 0
	dspck_tsimm precr_sra.ph.w, 0x001fff16, 0x0000001f, 0xffffff16, 0
	dspck_tsimm precr_sra.ph.w, 0x0000ffff, 0x00000000, 0xffffffe0, 17
	dspck_tsimm precr_sra.ph.w, 0x0000ffff, 0x00000000, 0x7fffffff, 3
	dspck_tsimm precr_sra.ph.w, 0xfff8ffff, 0x0ffffff8, 0x7fffffff, 0
	dspck_tsimm precr_sra.ph.w, 0x0000de5a, 0x00000000, 0xff79698f, 10
	dspck_tsimm precr_sra.ph.w, 0xffffffff, 0xffffffd1, 0xfffffff0, 8
	dspck_tsimm precr_sra.ph.w, 0x00013908, 0x00000001, 0xfee43908, 0
	dspck_tsimm precr_sra.ph.w, 0xffffffff, 0xfffffff8, 0xfded729c, 31
	dspck_tsimm precr_sra.ph.w, 0x0000fe72, 0x00000000, 0xce5a1cb7, 21
	dspck_tsimm precr_sra.ph.w, 0x00000000, 0x00000000, 0x00000000, 0
	dspck_tsimm precr_sra.ph.w, 0xffff0000, 0xffffff00, 0x7fffffff, 31
	dspck_tsimm precr_sra.ph.w, 0x72defff8, 0x003a72de, 0x3ffffff8, 0
	dspck_tsimm precr_sra.ph.w, 0x0000dccd, 0x00000000, 0x1bdccd6d, 8
	dspck_tsimm precr_sra.ph.w, 0x98880000, 0x01e13110, 0x80000000, 1
	dspck_tsimm precr_sra.ph.w, 0xffff0000, 0x7fffffff, 0x80000000, 0
	dspck_tsimm precr_sra.ph.w, 0x0000ffff, 0x00000007, 0x80000000, 31
	dspck_tsimm precr_sra.ph.w, 0xfffaffff, 0x7ffffffa, 0x7fffffff, 0
	dspck_tsimm precr_sra.ph.w, 0xffff0001, 0xffffffff, 0x00000006, 2
	dspck_tsimm precr_sra.ph.w, 0x0000099e, 0x00000005, 0xeeb099ef, 4
	dspck_tsimm precr_sra.ph.w, 0xffff0000, 0xffffffff, 0x80000000, 0
	dspck_tsimm precr_sra.ph.w, 0xfffee60a, 0xfffffc46, 0xffcc1534, 9
	dspck_tsimm precr_sra.ph.w, 0xfffeffff, 0x80000000, 0xc000000f, 30
	dspck_tsimm precr_sra.ph.w, 0xff000000, 0xffffff00, 0x00000000, 0
	dspck_tsimm precr_sra.ph.w, 0x00070000, 0x00000007, 0x80000000, 0
	dspck_tsimm precr_sra.ph.w, 0xffef0000, 0xfffffefa, 0x80000000, 4
	dspck_tsimm precr_sra.ph.w, 0x00000000, 0x0000081f, 0x00000007, 31
	dspck_tsimm precr_sra.ph.w, 0x486effff, 0x000d21b8, 0x7fffffff, 2
	dspck_tsimm precr_sra.ph.w, 0x0000ffff, 0x7fffffff, 0x99999999, 31
	dspck_tsimm precr_sra.ph.w, 0x0000ffff, 0x00000000, 0x7fffffff, 7
	dspck_tsimm precr_sra.ph.w, 0x00000000, 0x00000000, 0x80000000, 14
	dspck_tsimm precr_sra.ph.w, 0x00000000, 0x00000000, 0x00000000, 0
	dspck_tsimm precr_sra.ph.w, 0x00000000, 0x0ffffffe, 0x00000000, 31
	dspck_tsimm precr_sra.ph.w, 0x000000ff, 0x80000000, 0x000000ff, 0
	dspck_tsimm precr_sra.ph.w, 0xff800039, 0x80000000, 0x3939e9c0, 24
	dspck_tsimm precr_sra.ph.w, 0x00000001, 0x1ffffffe, 0x7fffffff, 30
	dspck_tsimm precr_sra.ph.w, 0xffffffff, 0xffffffff, 0xfffffd61, 31
	dspck_tsimm precr_sra.ph.w, 0x00010001, 0x00000688, 0x00000688, 10
	dspck_tsimm precr_sra.ph.w, 0xb6db1c71, 0xdb6db6db, 0x8e38e38e, 3
	dspck_tsimm precr_sra.ph.w, 0x00679999, 0x000000cf, 0x33333333, 1
	dspck_tsimm precr_sra.ph.w, 0x00000000, 0x00000000, 0x00000000, 2
	dspck_tsimm precr_sra.ph.w, 0x0034ffff, 0x000068d6, 0xffffff5d, 9
	dspck_tsimm precr_sra.ph.w, 0x0000fc00, 0x00000000, 0x80000000, 21
	dspck_tsimm precr_sra.ph.w, 0x00000000, 0x80000000, 0x00000000, 8
	dspck_tsimm precr_sra.ph.w, 0x00000000, 0x7fffffff, 0x7fffffff, 31
	dspck_tsimm precr_sra.ph.w, 0x000001a6, 0x80000000, 0x0034dff6, 13
	dspck_tsimm precr_sra.ph.w, 0xffffffff, 0xffff389e, 0xffffffff, 31
	dspck_tsimm precr_sra.ph.w, 0x00007b11, 0x00000000, 0xe734f622, 1
	dspck_tsimm precr_sra.ph.w, 0x0000ffff, 0x007c388e, 0xffff2106, 25
	dspck_tsimm precr_sra.ph.w, 0x00000000, 0x80000000, 0x00000000, 0
	dspck_tsimm precr_sra.ph.w, 0xffffffff, 0x7fffffff, 0x7fffffc0, 12
	dspck_tsimm precr_sra.ph.w, 0xffff0057, 0x7fffffff, 0x00000057, 0
	dspck_tsimm precr_sra.ph.w, 0x09240000, 0x24924924, 0x00000000, 18
	dspck_tsimm precr_sra.ph.w, 0xffffffff, 0xfffffffe, 0x3ffffff8, 6

	writemsg "[27] Test precr_sra_r.ph.w"
	dspck_tsimm precr_sra_r.ph.w, 0xffe0ffe0, 0x3fffffe0, 0x3fffffe0, 0
	dspck_tsimm precr_sra_r.ph.w, 0x0000ffff, 0xc0000007, 0x80000000, 31
	dspck_tsimm precr_sra_r.ph.w, 0xfff80001, 0x7fffffc0, 0x00000004, 3
	dspck_tsimm precr_sra_r.ph.w, 0x71c70000, 0xc71c71c7, 0x00000000, 0
	dspck_tsimm precr_sra_r.ph.w, 0x00000001, 0x000000ff, 0x7ffffffe, 31
	dspck_tsimm precr_sra_r.ph.w, 0x00008e89, 0x00000002, 0x0118e88a, 4
	dspck_tsimm precr_sra_r.ph.w, 0xffffffff, 0x80000007, 0x80000000, 31
	dspck_tsimm precr_sra_r.ph.w, 0x0000aaab, 0xfffffffb, 0x55555555, 13
	dspck_tsimm precr_sra_r.ph.w, 0x00020000, 0x0000007f, 0xffffffec, 6
	dspck_tsimm precr_sra_r.ph.w, 0x0000fffe, 0x00000000, 0x7ffffffc, 1
	dspck_tsimm precr_sra_r.ph.w, 0x0000fb86, 0x00000000, 0xfffffb86, 0
	dspck_tsimm precr_sra_r.ph.w, 0x7a02ff61, 0xfffe7a02, 0xffffff61, 0
	dspck_tsimm precr_sra_r.ph.w, 0xff48ff48, 0xffffff48, 0xffffff48, 0
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0xffffcea3, 0x00000000, 31
	dspck_tsimm precr_sra_r.ph.w, 0x9cc70000, 0xffa731b1, 0x1ffffffc, 6
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x7fffffff, 0xc0000007, 7
	dspck_tsimm precr_sra_r.ph.w, 0xf0000000, 0x80000000, 0x000000ff, 19
	dspck_tsimm precr_sra_r.ph.w, 0xfff00010, 0x80000000, 0x7fffffc0, 27
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x00000000, 0x00000007, 31
	dspck_tsimm precr_sra_r.ph.w, 0x8e390000, 0x38e38e38, 0x7fffffff, 6
	dspck_tsimm precr_sra_r.ph.w, 0xfffffff9, 0x7fffffff, 0xfffffff9, 0
	dspck_tsimm precr_sra_r.ph.w, 0xfffe0000, 0x80000000, 0x0000007f, 30
	dspck_tsimm precr_sra_r.ph.w, 0x714dbe05, 0xffbee29a, 0x067b7c09, 1
	dspck_tsimm precr_sra_r.ph.w, 0xffffffff, 0x7fffffff, 0x7fffffff, 0
	dspck_tsimm precr_sra_r.ph.w, 0x00109996, 0x0000001f, 0xfff1332b, 1
	dspck_tsimm precr_sra_r.ph.w, 0xcccc11ce, 0xcccccccc, 0x000011ce, 0
	dspck_tsimm precr_sra_r.ph.w, 0x645343ef, 0x0000c8a6, 0x27ca87de, 1
	dspck_tsimm precr_sra_r.ph.w, 0x0000ffff, 0x7fffffff, 0xffffffe5, 5
	dspck_tsimm precr_sra_r.ph.w, 0xe02b0000, 0x00270156, 0x80000000, 3
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x7ffffffc, 0x00000000, 8
	dspck_tsimm precr_sra_r.ph.w, 0x80008000, 0x3ffffffc, 0x3ffffff8, 15
	dspck_tsimm precr_sra_r.ph.w, 0xfffe7d97, 0x07fffffe, 0x0fa27d97, 0
	dspck_tsimm precr_sra_r.ph.w, 0xfff00002, 0x7fffffe0, 0xc0000003, 1
	dspck_tsimm precr_sra_r.ph.w, 0x00000001, 0x00000004, 0x71c71c71, 31
	dspck_tsimm precr_sra_r.ph.w, 0x00010000, 0x7ffffff9, 0x00000288, 31
	dspck_tsimm precr_sra_r.ph.w, 0x87881ce0, 0x0f0f0f0f, 0x024839bf, 1
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x80000000, 0x80000000, 6
	dspck_tsimm precr_sra_r.ph.w, 0xfffe0001, 0x3ffffffe, 0x80000001, 0
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x00000000, 0xff8e97bb, 31
	dspck_tsimm precr_sra_r.ph.w, 0xffff0001, 0x80000000, 0x7fffffff, 31
	dspck_tsimm precr_sra_r.ph.w, 0xffff0000, 0x80000000, 0xfffffeae, 31
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x80000000, 0x7fffff80, 13
	dspck_tsimm precr_sra_r.ph.w, 0xffff0000, 0x80000000, 0xc720a895, 31
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0xfffffffa, 0x7fffffff, 7
	dspck_tsimm precr_sra_r.ph.w, 0x03dcf706, 0x0000f6f9, 0xfffdc18d, 6
	dspck_tsimm precr_sra_r.ph.w, 0xffff0000, 0x7fffffff, 0x80000000, 0
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0xfffe262b, 0xfffffa76, 24
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x80000000, 0x80000000, 0
	dspck_tsimm precr_sra_r.ph.w, 0xffc10000, 0xffffc0e6, 0x0ffffffc, 8
	dspck_tsimm precr_sra_r.ph.w, 0x00040004, 0x00000004, 0x00000004, 0
	dspck_tsimm precr_sra_r.ph.w, 0xfff20000, 0x92492492, 0x000000c9, 27
	dspck_tsimm precr_sra_r.ph.w, 0x0000999a, 0xffffffb7, 0x99999999, 12
	dspck_tsimm precr_sra_r.ph.w, 0x00010002, 0xf0000007, 0xe000000f, 3
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x000016ca, 0x00000000, 31
	dspck_tsimm precr_sra_r.ph.w, 0x096f0000, 0x00004b75, 0x00000001, 3
	dspck_tsimm precr_sra_r.ph.w, 0x00010000, 0x7fffffff, 0xc71c71c7, 31
	dspck_tsimm precr_sra_r.ph.w, 0xa80cfe4e, 0xffd4a80c, 0xfffffe4e, 0
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0xffffffff, 0x7fffffff, 8
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x00000b61, 0xe38e38e3, 31
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x80000000, 0x00000003, 3
	dspck_tsimm precr_sra_r.ph.w, 0x00060000, 0x00000059, 0xf8000003, 4
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x8000001f, 0x07fffffc, 10
	dspck_tsimm precr_sra_r.ph.w, 0xb4ef0000, 0x03769de4, 0x00000000, 5
	dspck_tsimm precr_sra_r.ph.w, 0x000001a1, 0x80000000, 0x000001a1, 0
	dspck_tsimm precr_sra_r.ph.w, 0x0000fffd, 0x00000001, 0xffffffe5, 3
	dspck_tsimm precr_sra_r.ph.w, 0xfc000000, 0x80000000, 0x00000000, 21
	dspck_tsimm precr_sra_r.ph.w, 0x00000008, 0x7fffffff, 0x0000001f, 2
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x7ffffffa, 0x7ffffffc, 6
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x0f0f0f0f, 0x00000000, 31
	dspck_tsimm precr_sra_r.ph.w, 0x00010000, 0x00000001, 0x00000000, 0
	dspck_tsimm precr_sra_r.ph.w, 0x00010000, 0x7fffffff, 0xfffeb397, 31
	dspck_tsimm precr_sra_r.ph.w, 0x66660000, 0x66666666, 0x00000000, 16
	dspck_tsimm precr_sra_r.ph.w, 0xffff0000, 0x92492492, 0x00000000, 31
	dspck_tsimm precr_sra_r.ph.w, 0xe0000000, 0xffff0000, 0x07fffffe, 3
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0xc000000f, 0xdb6db6db, 31
	dspck_tsimm precr_sra_r.ph.w, 0xffe00000, 0xffffffe0, 0x00000000, 0
	dspck_tsimm precr_sra_r.ph.w, 0xfff89999, 0x0ffffff8, 0x99999999, 0
	dspck_tsimm precr_sra_r.ph.w, 0x0000fffd, 0x00000002, 0xffffa3b3, 13
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x3fffffe0, 0x3fffffe0, 31
	dspck_tsimm precr_sra_r.ph.w, 0xf5ec0003, 0xfffff5ec, 0xf0000003, 0
	dspck_tsimm precr_sra_r.ph.w, 0x676d0000, 0x0002676d, 0x00000000, 0
	dspck_tsimm precr_sra_r.ph.w, 0x00010001, 0x7fffffff, 0x7fffffff, 31
	dspck_tsimm precr_sra_r.ph.w, 0x0000fffb, 0x7fffffff, 0xffffffec, 2
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0xf8649518, 0x00000000, 31
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x00000004, 0x00000000, 8
	dspck_tsimm precr_sra_r.ph.w, 0xe1e2db6e, 0xf0f0f0f0, 0xdb6db6db, 7
	dspck_tsimm precr_sra_r.ph.w, 0x0003fff8, 0x00000003, 0xfffffff8, 0
	dspck_tsimm precr_sra_r.ph.w, 0x00000003, 0x80000000, 0x80000006, 1
	dspck_tsimm precr_sra_r.ph.w, 0x0001fffe, 0x80000002, 0xfffffffb, 1
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x1ffffff8, 0xe000000f, 31
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x7fffffff, 0xffffffff, 1
	dspck_tsimm precr_sra_r.ph.w, 0xfff80000, 0x3ffffff0, 0x7fffffff, 1
	dspck_tsimm precr_sra_r.ph.w, 0x000038e4, 0x00000000, 0xc71c71c7, 1
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x80000000, 0x00000000, 0
	dspck_tsimm precr_sra_r.ph.w, 0x00002492, 0x00000000, 0x49249249, 5
	dspck_tsimm precr_sra_r.ph.w, 0x002d0000, 0x00005ae8, 0xfffffff0, 9
	dspck_tsimm precr_sra_r.ph.w, 0xffae0000, 0xfffffd6e, 0x00000000, 3
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x7fffffff, 0x7fffffff, 5
	dspck_tsimm precr_sra_r.ph.w, 0x80000000, 0xf0000001, 0x00000273, 13
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x00000000, 0x00000000, 1
	dspck_tsimm precr_sra_r.ph.w, 0x55550a42, 0x55555555, 0x07c29079, 6
	dspck_tsimm precr_sra_r.ph.w, 0xfb93fffc, 0xfffffb93, 0xfffffffc, 0
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0xff00ff00, 0xe76358a9, 30
	dspck_tsimm precr_sra_r.ph.w, 0xfffeffff, 0x80000000, 0xc000000f, 30
	dspck_tsimm precr_sra_r.ph.w, 0x00000002, 0xffffffff, 0x8000000f, 3
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x7ffffff9, 0x7ffffffa, 8
	dspck_tsimm precr_sra_r.ph.w, 0xe3d1fff8, 0xffdfe3d1, 0x7ffffff8, 0
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0xffffe407, 0xfffffffe, 31
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x00000320, 0xfffffff8, 31
	dspck_tsimm precr_sra_r.ph.w, 0x00000d37, 0xfffffff9, 0x0034dcb6, 10
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x80000000, 0x00000000, 8
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x00000035, 0x00000000, 8
	dspck_tsimm precr_sra_r.ph.w, 0x0000fff8, 0x00000000, 0x3ffffff0, 1
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x3ffffffc, 0x00000000, 10
	dspck_tsimm precr_sra_r.ph.w, 0xffff0000, 0xffffebc6, 0x80000000, 12
	dspck_tsimm precr_sra_r.ph.w, 0x000038e3, 0x00000000, 0xe38e38e3, 0
	dspck_tsimm precr_sra_r.ph.w, 0x00010001, 0x7ffffff0, 0x7fffffff, 31
	dspck_tsimm precr_sra_r.ph.w, 0xeb0f8e39, 0x00075875, 0xc71c71c7, 3
	dspck_tsimm precr_sra_r.ph.w, 0x00005ae3, 0x00000000, 0x00005ae3, 0
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x0000774b, 0x0000774b, 19
	dspck_tsimm precr_sra_r.ph.w, 0x0223fffc, 0x00000446, 0x1ffffff8, 1
	dspck_tsimm precr_sra_r.ph.w, 0x00030000, 0x80000003, 0x00000000, 0
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x00000000, 0x00000000, 6
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0xffffc3b4, 0x00000000, 31
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0xff00ff00, 0x00018f10, 27
	dspck_tsimm precr_sra_r.ph.w, 0x150b1f10, 0x0010a85b, 0x0000f87d, 3
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x0000006d, 0x00033da5, 31
	dspck_tsimm precr_sra_r.ph.w, 0x002cfe00, 0x0ae3bff1, 0x80000000, 22
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0xffffffff, 0x00000000, 24
	dspck_tsimm precr_sra_r.ph.w, 0x00010000, 0xe0000001, 0x00000000, 0
	dspck_tsimm precr_sra_r.ph.w, 0x0000ffff, 0x80000007, 0xffffe93d, 13
	dspck_tsimm precr_sra_r.ph.w, 0x0000fffe, 0xffffffff, 0xffffffe0, 4
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x7fffffff, 0x7fffffff, 2
	dspck_tsimm precr_sra_r.ph.w, 0xf7ebf7eb, 0x0003f7eb, 0x0003f7eb, 0
	dspck_tsimm precr_sra_r.ph.w, 0xe45c003f, 0xffcce45c, 0x0000003f, 0
	dspck_tsimm precr_sra_r.ph.w, 0x00000001, 0xfd467217, 0x7fffffff, 31
	dspck_tsimm precr_sra_r.ph.w, 0x00074f22, 0xf0000007, 0xed2e4f22, 0
	dspck_tsimm precr_sra_r.ph.w, 0x00010000, 0x0000005c, 0x7fffffff, 6
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x00000000, 0xf3f39787, 31
	dspck_tsimm precr_sra_r.ph.w, 0xffffffff, 0xfffffffa, 0xfffffffa, 3
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0xffffffc0, 0x80000000, 9
	dspck_tsimm precr_sra_r.ph.w, 0x8a5d0000, 0x007c8a5d, 0x00000000, 0
	dspck_tsimm precr_sra_r.ph.w, 0xffff0000, 0x80000003, 0xfffea149, 31
	dspck_tsimm precr_sra_r.ph.w, 0xfffffff0, 0x7fffffff, 0xfffffff0, 0
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x7fffffff, 0x00000000, 3
	dspck_tsimm precr_sra_r.ph.w, 0xffffffff, 0x80000000, 0x80000000, 31
	dspck_tsimm precr_sra_r.ph.w, 0xffeb0fdb, 0xffffffeb, 0x01d00fdb, 0
	dspck_tsimm precr_sra_r.ph.w, 0x0000fe1d, 0x00000000, 0xfffff874, 2
	dspck_tsimm precr_sra_r.ph.w, 0xfffed715, 0x1ffffffc, 0xe4c3ae2a, 1
	dspck_tsimm precr_sra_r.ph.w, 0xcc260000, 0x03e61329, 0xc000001f, 7
	dspck_tsimm precr_sra_r.ph.w, 0xffff0000, 0x80000000, 0x0001cdbc, 31
	dspck_tsimm precr_sra_r.ph.w, 0x00030000, 0xe0000003, 0x00000000, 0
	dspck_tsimm precr_sra_r.ph.w, 0x0005b8cd, 0x80000005, 0x0014b8cd, 0
	dspck_tsimm precr_sra_r.ph.w, 0x0000ffff, 0x00000000, 0xf8000003, 27
	dspck_tsimm precr_sra_r.ph.w, 0xfff003d2, 0xfffffff0, 0x000003d2, 0
	dspck_tsimm precr_sra_r.ph.w, 0xffe00000, 0x7fffffc0, 0x00000000, 1
	dspck_tsimm precr_sra_r.ph.w, 0xfffcfffc, 0x7ffffff0, 0x1ffffff0, 2
	dspck_tsimm precr_sra_r.ph.w, 0x00000040, 0xffffffa3, 0x7fffffff, 25
	dspck_tsimm precr_sra_r.ph.w, 0xfab9005a, 0xfffffab9, 0x0000005a, 0
	dspck_tsimm precr_sra_r.ph.w, 0xe0000000, 0x80000001, 0x00000000, 18
	dspck_tsimm precr_sra_r.ph.w, 0x978676f6, 0xffa65e16, 0x0001dbd7, 2
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x02c51b17, 0x02c51b17, 31
	dspck_tsimm precr_sra_r.ph.w, 0x948e0000, 0xff14a470, 0x80000000, 3
	dspck_tsimm precr_sra_r.ph.w, 0xc0000000, 0xe0000007, 0x8000003f, 15
	dspck_tsimm precr_sra_r.ph.w, 0xffff0000, 0x80000000, 0x00000000, 31
	dspck_tsimm precr_sra_r.ph.w, 0x00000004, 0x80000000, 0x80000004, 0
	dspck_tsimm precr_sra_r.ph.w, 0x0000fffc, 0x00000000, 0x7ffffffc, 0
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x7ffffffb, 0x8000003f, 12
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x0002cce6, 0x07fffffc, 31
	dspck_tsimm precr_sra_r.ph.w, 0xf299aa30, 0xfffff299, 0xfffeaa30, 0
	dspck_tsimm precr_sra_r.ph.w, 0x00000002, 0xe0000007, 0x00000060, 6
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x7fffffff, 0x00000000, 3
	dspck_tsimm precr_sra_r.ph.w, 0xfe000000, 0x80000000, 0x0002471b, 22
	dspck_tsimm precr_sra_r.ph.w, 0x24920000, 0x92492492, 0xffffffff, 3
	dspck_tsimm precr_sra_r.ph.w, 0xffff0000, 0x80000000, 0x00000000, 31
	dspck_tsimm precr_sra_r.ph.w, 0x2ba5fffc, 0xfff82ba5, 0x07fffffc, 0
	dspck_tsimm precr_sra_r.ph.w, 0xff00356e, 0xffffff00, 0x0121356e, 0
	dspck_tsimm precr_sra_r.ph.w, 0x66663c60, 0x66666666, 0xd0c23c60, 0
	dspck_tsimm precr_sra_r.ph.w, 0x00002492, 0x00000001, 0x92492492, 15
	dspck_tsimm precr_sra_r.ph.w, 0xffbfffff, 0xffffffbf, 0x7fffffff, 0
	dspck_tsimm precr_sra_r.ph.w, 0xc7450008, 0xffde3a28, 0x8000003f, 3
	dspck_tsimm precr_sra_r.ph.w, 0x0000b6db, 0x7fffffff, 0xdb6db6db, 3
	dspck_tsimm precr_sra_r.ph.w, 0xc0000000, 0x80000000, 0x00000000, 17
	dspck_tsimm precr_sra_r.ph.w, 0x00ad0000, 0x000acd12, 0x00000005, 12
	dspck_tsimm precr_sra_r.ph.w, 0xbdee0000, 0xff9d7bdc, 0x00000000, 1
	dspck_tsimm precr_sra_r.ph.w, 0x001b3333, 0x0000006b, 0xcccccccc, 2
	dspck_tsimm precr_sra_r.ph.w, 0x81480000, 0x0140a402, 0xe000000f, 7
	dspck_tsimm precr_sra_r.ph.w, 0x0503ffe0, 0x00a05c2c, 0xfffc0bb1, 13
	dspck_tsimm precr_sra_r.ph.w, 0x830c0001, 0x007c185d, 0xe0000007, 3
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x00000000, 0xfbae5c82, 31
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x80000000, 0x7fffffff, 2
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x00003423, 0x00007446, 30
	dspck_tsimm precr_sra_r.ph.w, 0x0000001f, 0x00000000, 0x8000001f, 0
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x00000002, 0x00000000, 31
	dspck_tsimm precr_sra_r.ph.w, 0xffb7664a, 0x0928ffb7, 0xff89664a, 0
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x7fffffff, 0x0ffffffe, 8
	dspck_tsimm precr_sra_r.ph.w, 0x00010000, 0x7fffffff, 0x1ffffffc, 31
	dspck_tsimm precr_sra_r.ph.w, 0x00040000, 0x7fffffff, 0xffffffe0, 29
	dspck_tsimm precr_sra_r.ph.w, 0x0000fff7, 0x00000815, 0xf7723f4f, 24
	dspck_tsimm precr_sra_r.ph.w, 0x00fffffe, 0x00ff00ff, 0x7ffffffe, 0
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x80000000, 0x80000000, 0
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x00000001, 0x00000000, 31
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x7fffffff, 0x1ffffffe, 6
	dspck_tsimm precr_sra_r.ph.w, 0x0000ffff, 0xff2e1e63, 0x80000000, 31
	dspck_tsimm precr_sra_r.ph.w, 0x0000fffd, 0x7fffffff, 0xfffffffa, 1
	dspck_tsimm precr_sra_r.ph.w, 0x6db70000, 0xdb6db6db, 0x80000000, 11
	dspck_tsimm precr_sra_r.ph.w, 0x141f0001, 0xff00507d, 0x00000002, 2
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x80000000, 0x00000000, 1
	dspck_tsimm precr_sra_r.ph.w, 0x0000ffff, 0x80000000, 0x7fffffff, 0
	dspck_tsimm precr_sra_r.ph.w, 0x2e9d0000, 0xfff2e9cd, 0x00000000, 4
	dspck_tsimm precr_sra_r.ph.w, 0xffd8fc00, 0xfb087aa5, 0x80000000, 21
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x33333333, 0xffffe715, 31
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x7fffffff, 0x7fffffff, 3
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x00000000, 0xe000000f, 31
	dspck_tsimm precr_sra_r.ph.w, 0x00033c3c, 0x0000000d, 0xf0f0f0f0, 2
	dspck_tsimm precr_sra_r.ph.w, 0xfff8ffff, 0x3ffffff8, 0x7fffffff, 0
	dspck_tsimm precr_sra_r.ph.w, 0xff800000, 0x8000001f, 0xffffff00, 24
	dspck_tsimm precr_sra_r.ph.w, 0x0000ffff, 0x00000000, 0x80000000, 31
	dspck_tsimm precr_sra_r.ph.w, 0x0000ffb7, 0x00000000, 0xffdbb2cf, 15
	dspck_tsimm precr_sra_r.ph.w, 0x2c03d9c7, 0x0002c033, 0xf39d9c77, 4
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0xffffffff, 0xffffff2b, 31
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0xffffffff, 0x07fffffe, 11
	dspck_tsimm precr_sra_r.ph.w, 0x40000000, 0x7fffffe0, 0xffff0000, 17
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x80000000, 0x00000003, 13
	dspck_tsimm precr_sra_r.ph.w, 0x00010001, 0x7fffffff, 0x7fffffff, 31
	dspck_tsimm precr_sra_r.ph.w, 0x0000b9b9, 0x00000002, 0xff1dcdc4, 3
	dspck_tsimm precr_sra_r.ph.w, 0x000f0000, 0x0000000f, 0x00000000, 0
	dspck_tsimm precr_sra_r.ph.w, 0x00010000, 0x0000003f, 0x00000000, 6
	dspck_tsimm precr_sra_r.ph.w, 0xfff801e6, 0x7ffffff8, 0x000001e6, 0
	dspck_tsimm precr_sra_r.ph.w, 0xffff0000, 0x80000000, 0xffffffe4, 31
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x80000000, 0x00000000, 1
	dspck_tsimm precr_sra_r.ph.w, 0x00000013, 0x3ffffff0, 0x000004cf, 6
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0xffffffea, 0xc0000003, 7
	dspck_tsimm precr_sra_r.ph.w, 0x000034c6, 0x80000000, 0xffff34c6, 0
	dspck_tsimm precr_sra_r.ph.w, 0xfffefe02, 0xfffffec1, 0x00ff00ff, 7
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x00000000, 0x80000000, 0
	dspck_tsimm precr_sra_r.ph.w, 0xe000e000, 0x80000000, 0x80000000, 18
	dspck_tsimm precr_sra_r.ph.w, 0x9b7fffff, 0x005c9b7f, 0x7fffffff, 0
	dspck_tsimm precr_sra_r.ph.w, 0x00000000, 0x8000003f, 0x80000003, 14
	dspck_tsimm precr_sra_r.ph.w, 0x0000bd45, 0x80000000, 0x1c7b7a8a, 1
	dspck_tsimm precr_sra_r.ph.w, 0xffd70000, 0xffffffad, 0x00000000, 1

	writemsg "[28] Test prepend"
	dspck_tsimm prepend, 0x5ffff0df, 0xffff86fc, 0xfffffe02, 3
	dspck_tsimm prepend, 0x00000000, 0x00000000, 0xfffffe06, 0
	dspck_tsimm prepend, 0x0fffffff, 0x7fffffff, 0x80000000, 3
	dspck_tsimm prepend, 0x80000000, 0x80000000, 0x00000000, 0
	dspck_tsimm prepend, 0x00000000, 0x00000000, 0xffffff23, 0
	dspck_tsimm prepend, 0x01feed28, 0xff76947a, 0x00000000, 7
	dspck_tsimm prepend, 0x00000035, 0x00000035, 0xffffffc0, 0
	dspck_tsimm prepend, 0x80000000, 0x80000000, 0x01130b02, 0
	dspck_tsimm prepend, 0x7ffffffe, 0x7ffffffe, 0xc0000001, 0
	dspck_tsimm prepend, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0
	dspck_tsimm prepend, 0x1a75980e, 0x1a75980e, 0x1b4c3c1e, 0
	dspck_tsimm prepend, 0x7fffffff, 0xffffffff, 0x7ffffffc, 1
	dspck_tsimm prepend, 0x00060000, 0xc0000003, 0x00000000, 13
	dspck_tsimm prepend, 0x7fffffff, 0xfffffffe, 0x00000000, 1
	dspck_tsimm prepend, 0xfffffffe, 0x1ffffffe, 0x7fffffff, 31
	dspck_tsimm prepend, 0x00000000, 0x00000000, 0x00000000, 0
	dspck_tsimm prepend, 0xfffffb50, 0x7fffffff, 0xfffffda8, 31
	dspck_tsimm prepend, 0x6b2c0000, 0xc0000007, 0xfffff6b2, 12
	dspck_tsimm prepend, 0x0015491f, 0x002a923e, 0x1ffffff8, 1
	dspck_tsimm prepend, 0x00000021, 0xfffffee4, 0x00000010, 31
	dspck_tsimm prepend, 0xf6ecdac9, 0xf8034c6b, 0xfb766d64, 31
	dspck_tsimm prepend, 0xb7ffffff, 0x7ffffffb, 0x0000002b, 4
	dspck_tsimm prepend, 0xfffffffa, 0xfffffffa, 0x7fffffff, 0
	dspck_tsimm prepend, 0xffaaaaaa, 0x55555555, 0x7fffffff, 9
	dspck_tsimm prepend, 0x00016000, 0x80000000, 0x80000005, 18
	dspck_tsimm prepend, 0x7fffffff, 0x7fffffff, 0x000004fc, 0
	dspck_tsimm prepend, 0x00000000, 0x0035d189, 0x80000000, 31
	dspck_tsimm prepend, 0x8000007f, 0x8000007f, 0xff00ff00, 0
	dspck_tsimm prepend, 0xaf600000, 0x00000000, 0x03557af6, 12
	dspck_tsimm prepend, 0x000000e3, 0x000000e3, 0x0008f4ab, 0
	dspck_tsimm prepend, 0x00000000, 0x00000000, 0x00000000, 2
	dspck_tsimm prepend, 0x61e1e1e1, 0x0f0f0f0f, 0x00000003, 3
	dspck_tsimm prepend, 0x002559bf, 0x002559bf, 0xdb6db6db, 0
	dspck_tsimm prepend, 0x19999999, 0x66666666, 0x7fffff80, 2
	dspck_tsimm prepend, 0xe85fb7d6, 0x80000000, 0xfa17edf5, 30
	dspck_tsimm prepend, 0x6b800000, 0xc0000001, 0x00003cb5, 7
	dspck_tsimm prepend, 0xc71c71c7, 0xc71c71c7, 0x00000335, 0
	dspck_tsimm prepend, 0x8000001f, 0x8000001f, 0xfffffef3, 0
	dspck_tsimm prepend, 0x00200000, 0x00000006, 0x80000002, 12
	dspck_tsimm prepend, 0x50c7ffff, 0xffffffd5, 0xf8c02863, 15
	dspck_tsimm prepend, 0x0008fd99, 0x33299df8, 0x000011fb, 25
	dspck_tsimm prepend, 0x00f00000, 0x00000000, 0xc000000f, 12
	dspck_tsimm prepend, 0x00000000, 0x00000001, 0x00000000, 31
	dspck_tsimm prepend, 0xebffffff, 0x7ffffffb, 0x7ffffffd, 5
	dspck_tsimm prepend, 0xffffffc0, 0x80000000, 0x7fffffff, 25
	dspck_tsimm prepend, 0xc0ffffff, 0x0ffffffc, 0x0ffffffc, 4
	dspck_tsimm prepend, 0x8000003f, 0xfffffe6a, 0xc000001f, 31
	dspck_tsimm prepend, 0x7face03a, 0xfeb380e9, 0x7ffffffd, 2
	dspck_tsimm prepend, 0x3ffffffd, 0x7ffffffa, 0x00000000, 1
	dspck_tsimm prepend, 0xe0000003, 0x8000000f, 0xdb6db6db, 2
	dspck_tsimm prepend, 0x001548ff, 0xfffd232e, 0x00001548, 24
	dspck_tsimm prepend, 0x6000000f, 0xc000001f, 0x00000000, 1
	dspck_tsimm prepend, 0x000000cc, 0x33333333, 0x00000000, 22
	dspck_tsimm prepend, 0x00000004, 0x0000db1b, 0xc0000001, 30
	dspck_tsimm prepend, 0x01ffffff, 0xffffffff, 0xe0000007, 10
	dspck_tsimm prepend, 0x80000000, 0x00000000, 0xffffff5f, 1
	dspck_tsimm prepend, 0x0000007e, 0x0d2efcd1, 0x8000003f, 31
	dspck_tsimm prepend, 0xda000000, 0x00000000, 0xffffff6d, 7
	dspck_tsimm prepend, 0x00040d38, 0x00081a70, 0xe4606c5a, 1
	dspck_tsimm prepend, 0xc0000007, 0x80000000, 0xe0000003, 31
	dspck_tsimm prepend, 0x00000000, 0x00000000, 0xfff9ab12, 0
	dspck_tsimm prepend, 0xffffffff, 0x80000000, 0x7fffffff, 31
	dspck_tsimm prepend, 0x00007fff, 0xffffd894, 0x00000000, 17
	dspck_tsimm prepend, 0xffed5610, 0x0ffffffe, 0xfff6ab08, 31
	dspck_tsimm prepend, 0x00000002, 0x80000000, 0x00000000, 30
	dspck_tsimm prepend, 0x0019ffff, 0x7fffffff, 0x00000006, 14
	dspck_tsimm prepend, 0xe0000000, 0x80000000, 0x7fffffff, 2
	dspck_tsimm prepend, 0x003ffffc, 0xfffff23b, 0x00000000, 10
	dspck_tsimm prepend, 0x00000001, 0x80000000, 0x80000000, 31
	dspck_tsimm prepend, 0x00000011, 0x00000011, 0x7fffffff, 0
	dspck_tsimm prepend, 0x7ffffffd, 0xfffffffa, 0x1c71c71c, 1
	dspck_tsimm prepend, 0xe6666666, 0xcccccccc, 0xf8000001, 1
	dspck_tsimm prepend, 0x00000001, 0x80000000, 0x80000000, 31
	dspck_tsimm prepend, 0xfdb739b8, 0xfdb739b8, 0x000000e1, 0
	dspck_tsimm prepend, 0x00000fff, 0x7fffffff, 0x80000000, 19
	dspck_tsimm prepend, 0x7ffff90b, 0xfffff216, 0x80000000, 1
	dspck_tsimm prepend, 0x00000000, 0x3ffffff8, 0x00000000, 31
	dspck_tsimm prepend, 0xfea7a4f9, 0xfea7a4f9, 0xfffffffe, 0
	dspck_tsimm prepend, 0xfffffffe, 0x7fffffff, 0x7fffffff, 31
	dspck_tsimm prepend, 0x0000033f, 0x7fffffff, 0x00000006, 25
	dspck_tsimm prepend, 0x8e7fffff, 0x7fffffff, 0x8e38e38e, 8
	dspck_tsimm prepend, 0xfffffffc, 0x00000000, 0xfffffffe, 31
	dspck_tsimm prepend, 0x7fffffff, 0x7fffffff, 0x00000000, 0
	dspck_tsimm prepend, 0xffffff4e, 0x80000000, 0xffffffd3, 30
	dspck_tsimm prepend, 0xf0000001, 0xf0000001, 0x00000006, 0
	dspck_tsimm prepend, 0x000017ff, 0xfffffff8, 0x00000002, 21
	dspck_tsimm prepend, 0x49666666, 0x66666666, 0x49249249, 8
	dspck_tsimm prepend, 0x000001fe, 0x7fffffff, 0x000000ff, 31
	dspck_tsimm prepend, 0x1ffffff8, 0x1ffffff8, 0x80000001, 0
	dspck_tsimm prepend, 0xffffff97, 0xe0000003, 0xffffffcb, 31
	dspck_tsimm prepend, 0xfffec8d0, 0xfffb2342, 0x0000001f, 2
	dspck_tsimm prepend, 0x40000000, 0x80000000, 0xfffffffe, 1
	dspck_tsimm prepend, 0x03fffffe, 0x03fffffe, 0x00000c17, 0
	dspck_tsimm prepend, 0x80000000, 0x00000000, 0xc0000003, 1
	dspck_tsimm prepend, 0xcea81fff, 0x03fffffe, 0xfffd39d5, 13
	dspck_tsimm prepend, 0xc0000c64, 0x0003192a, 0x0000d270, 6
	dspck_tsimm prepend, 0x000001ff, 0x3ffffffe, 0x00000000, 21
	dspck_tsimm prepend, 0x20000000, 0x80000000, 0x80000000, 2
	dspck_tsimm prepend, 0xfec42a9c, 0x1ffffff0, 0xff62154e, 31
	dspck_tsimm prepend, 0xf973ffff, 0x7fffffff, 0xffffff2e, 13
	dspck_tsimm prepend, 0x7c000000, 0xf8000001, 0x80000000, 1
	dspck_tsimm prepend, 0x0000006f, 0x7fffffff, 0xe0000003, 27
	dspck_tsimm prepend, 0x6d17c000, 0xe000000f, 0x0000368b, 15
	dspck_tsimm prepend, 0x0000003f, 0x7fffffff, 0x80000000, 25
	dspck_tsimm prepend, 0x18000000, 0x0000029c, 0x00001460, 10
	dspck_tsimm prepend, 0x59a85fba, 0xfdd559c5, 0x000acd42, 19
	dspck_tsimm prepend, 0xe7ffffff, 0x3ffffff8, 0x0081575f, 3
	dspck_tsimm prepend, 0xffffed07, 0xffffed07, 0x00000000, 0
	dspck_tsimm prepend, 0x4fffffff, 0x7fffffff, 0x00000002, 3
	dspck_tsimm prepend, 0xf8ffffff, 0x3fffffe0, 0x07fffffe, 6
	dspck_tsimm prepend, 0x000a559a, 0x000a559a, 0x7fffffff, 0
	dspck_tsimm prepend, 0x0f261bcd, 0x1e4c379a, 0x00000ae6, 1
	dspck_tsimm prepend, 0x00000000, 0x00000001, 0xfffffff0, 1
	dspck_tsimm prepend, 0xe0000bcb, 0x0000bcb1, 0xfffffffe, 4
	dspck_tsimm prepend, 0x8010c97e, 0x002192fc, 0x7fffffff, 1
	dspck_tsimm prepend, 0x00000000, 0x00000000, 0xfffff7e4, 1
	dspck_tsimm prepend, 0x7ffffff0, 0x7ffffff0, 0x00000000, 0
	dspck_tsimm prepend, 0xdffffffe, 0x7ffffff8, 0x80000007, 2
	dspck_tsimm prepend, 0xfffffff5, 0xfffffffa, 0xfffffffa, 31
	dspck_tsimm prepend, 0x7ffffffa, 0x7ffffffa, 0x7fffffff, 0
	dspck_tsimm prepend, 0x00000000, 0x00000000, 0x7ffffff0, 0
	dspck_tsimm prepend, 0x000001ff, 0x8000001f, 0x000000ff, 31
	dspck_tsimm prepend, 0x00000000, 0x00000000, 0x00000000, 27
	dspck_tsimm prepend, 0x00083a04, 0x00107408, 0x07fffffc, 1
	dspck_tsimm prepend, 0xfffffffe, 0x7fffffff, 0x7fffffff, 31
	dspck_tsimm prepend, 0xffffc25d, 0xaaaaaaaa, 0xffffe12e, 31
	dspck_tsimm prepend, 0x0003e000, 0xf8000001, 0x00000000, 14
	dspck_tsimm prepend, 0x29fc2bb3, 0x29fc2bb3, 0x80000000, 0
	dspck_tsimm prepend, 0xffffa900, 0x000036c7, 0xfffffd48, 27
	dspck_tsimm prepend, 0xffffffba, 0xffffffba, 0x0f0f0f0f, 0
	dspck_tsimm prepend, 0x00000017, 0xffffc303, 0x80000005, 30
	dspck_tsimm prepend, 0x07fffe00, 0xffff0000, 0x00000003, 7
	dspck_tsimm prepend, 0xfffffff7, 0xf0000003, 0xfffffffe, 29
	dspck_tsimm prepend, 0xffe97f08, 0x00000005, 0xfff4bf84, 31
	dspck_tsimm prepend, 0xfffcc6a5, 0xfffcc6a5, 0x7fffffff, 0
	dspck_tsimm prepend, 0xe0000003, 0xe0000003, 0x66666666, 0
	dspck_tsimm prepend, 0xe0000000, 0x00000000, 0x00000827, 3
	dspck_tsimm prepend, 0xf8000000, 0x80000000, 0x7fffffff, 4
	dspck_tsimm prepend, 0xe0000003, 0xe0000003, 0x80000000, 0
	dspck_tsimm prepend, 0x24924940, 0x80000000, 0x92492492, 25
	dspck_tsimm prepend, 0x000001f9, 0x000001f9, 0x1ce10bb3, 0
	dspck_tsimm prepend, 0xfffe0000, 0x00000000, 0x3ffffffc, 17
	dspck_tsimm prepend, 0x0000728f, 0xfffffffe, 0x00001ca3, 30
	dspck_tsimm prepend, 0xfe1db4e0, 0x00000de7, 0xfff0eda7, 27
	dspck_tsimm prepend, 0x07fffffe, 0x0ffffffc, 0x00000000, 1
	dspck_tsimm prepend, 0x80f31ed7, 0x01e63dae, 0x8000007f, 1
	dspck_tsimm prepend, 0xf0000000, 0x80000000, 0x000072d7, 3
	dspck_tsimm prepend, 0xfffffff4, 0x000d0717, 0xfffffffa, 31
	dspck_tsimm prepend, 0x007fffff, 0xfffffff8, 0x80000000, 9
	dspck_tsimm prepend, 0x00000000, 0x00000000, 0x00000000, 0
	dspck_tsimm prepend, 0xe0000006, 0x00006000, 0xf0000003, 31
	dspck_tsimm prepend, 0xf8ffffff, 0x7fffffff, 0x07fffffc, 7
	dspck_tsimm prepend, 0x001fffff, 0x7fffffff, 0x00000000, 10
	dspck_tsimm prepend, 0xffffffec, 0xffffffd8, 0x00000003, 1
	dspck_tsimm prepend, 0xffdfffff, 0x7fffffff, 0x7fffffff, 10
	dspck_tsimm prepend, 0x0000003f, 0x0000003f, 0x0000003f, 0
	dspck_tsimm prepend, 0x00fe67cb, 0xfe67cb2a, 0x00000000, 8
	dspck_tsimm prepend, 0xffe00014, 0x0000a3af, 0x7fffffff, 11
	dspck_tsimm prepend, 0x80000000, 0x80000000, 0xe0000003, 0
	dspck_tsimm prepend, 0x03999999, 0x33333333, 0x00000007, 9
	dspck_tsimm prepend, 0xffffc400, 0x00000022, 0xfffffff1, 22
	dspck_tsimm prepend, 0xaffffe94, 0xffffe940, 0x00a6984a, 4
	dspck_tsimm prepend, 0x02000000, 0x80000000, 0x00000000, 6
	dspck_tsimm prepend, 0xffffe59b, 0xffffe59b, 0x80000000, 0
	dspck_tsimm prepend, 0x04000000, 0x80000000, 0x80000000, 5
	dspck_tsimm prepend, 0xffff0000, 0x00000000, 0x7fffffc0, 22
	dspck_tsimm prepend, 0x01fc0000, 0x00000334, 0x8000007f, 14
	dspck_tsimm prepend, 0x7ffffff0, 0x7ffffff0, 0xfffffffe, 0
	dspck_tsimm prepend, 0x0ff00ff0, 0xff00ff00, 0x00000000, 4
	dspck_tsimm prepend, 0x00001fff, 0x3ffffffe, 0x80000000, 17
	dspck_tsimm prepend, 0x00000001, 0x80000000, 0x80000000, 31
	dspck_tsimm prepend, 0x012b9440, 0x2b9440fc, 0x00000001, 8
	dspck_tsimm prepend, 0x72000000, 0x00000002, 0xffffd5c8, 10
	dspck_tsimm prepend, 0xfff138af, 0xfff138af, 0x80000000, 0
	dspck_tsimm prepend, 0x00000000, 0x00000000, 0x00000000, 16
	dspck_tsimm prepend, 0xe3000000, 0x00000002, 0xe38e38e3, 8
	dspck_tsimm prepend, 0xf4911d04, 0xf4911d04, 0x8000007f, 0
	dspck_tsimm prepend, 0x7ffffff0, 0x7ffffff0, 0x00000000, 0
	dspck_tsimm prepend, 0x09ffe215, 0xffe21573, 0xffffe109, 8
	dspck_tsimm prepend, 0x7fffffff, 0x7fffffff, 0xc890ef17, 0
	dspck_tsimm prepend, 0x52000000, 0x80000001, 0xfffdb214, 6
	dspck_tsimm prepend, 0x0000000f, 0xfee9b599, 0x00000000, 28
	dspck_tsimm prepend, 0x7ffff4ab, 0xffffe956, 0x0000016c, 1
	dspck_tsimm prepend, 0x007ff716, 0xffee2d5e, 0x00000000, 9
	dspck_tsimm prepend, 0xfffffffe, 0xfffffffe, 0x00000000, 0
	dspck_tsimm prepend, 0xd9ffffec, 0xfffff66c, 0xfffff66c, 7
	dspck_tsimm prepend, 0x00000000, 0x00000fb4, 0x80000000, 15
	dspck_tsimm prepend, 0xe0000000, 0x00000000, 0x7fffffff, 3
	dspck_tsimm prepend, 0x00000735, 0x00000735, 0xffffffff, 0
	dspck_tsimm prepend, 0x90000000, 0x80000000, 0x1ffffffc, 3
	dspck_tsimm prepend, 0x000000ff, 0xffffb926, 0x00000000, 24
	dspck_tsimm prepend, 0x00002b8d, 0x00002b8d, 0x8000007f, 0
	dspck_tsimm prepend, 0xc0000000, 0x00000000, 0x00000017, 2
	dspck_tsimm prepend, 0x80000000, 0x80000000, 0xff9a0952, 0
	dspck_tsimm prepend, 0x0f76e7cf, 0x0f76e7cf, 0x0f76e7cf, 0
	dspck_tsimm prepend, 0x38e38e38, 0x7fffffff, 0x1c71c71c, 31
	dspck_tsimm prepend, 0xea000000, 0x80000001, 0xfffffffa, 6
	dspck_tsimm prepend, 0x03fffffd, 0xfffff747, 0x0000000f, 10
	dspck_tsimm prepend, 0x01f80000, 0xe0000007, 0xe0000007, 10
	dspck_tsimm prepend, 0xfffffdbf, 0xffff6c3a, 0xffffffed, 27
	dspck_tsimm prepend, 0x000464c3, 0x7fffffff, 0x00008c98, 29
	dspck_tsimm prepend, 0x80000004, 0x80000004, 0x00000000, 0
	dspck_tsimm prepend, 0x00000128, 0x00000128, 0x0000003c, 0
	dspck_tsimm prepend, 0x2002c2ed, 0x00161769, 0x00de5fe1, 3
	dspck_tsimm prepend, 0x00001fff, 0xffffff80, 0xf0000007, 22
	dspck_tsimm prepend, 0xfffe0000, 0x00000e92, 0x7fffffff, 15
	dspck_tsimm prepend, 0x0001fffe, 0x00000000, 0x0000ffff, 31
	dspck_tsimm prepend, 0xffffffff, 0xe0000001, 0x7fffffff, 31
	dspck_tsimm prepend, 0x01ffffff, 0x7fffffff, 0x00000000, 6
	dspck_tsimm prepend, 0xfffffc19, 0xfffffe0c, 0xfffffe0c, 31
	dspck_tsimm prepend, 0x40000000, 0x80000000, 0x00084488, 1
	dspck_tsimm prepend, 0xe0000000, 0x80000000, 0x7fffffff, 2
	dspck_tsimm prepend, 0x00000001, 0x80000000, 0x80000000, 31
	dspck_tsimm prepend, 0xfff80000, 0x00000000, 0xfffffffe, 14
	dspck_tsimm prepend, 0x00000001, 0xc71c71c7, 0x00000000, 31
	dspck_tsimm prepend, 0x00010000, 0x80000000, 0x00000000, 15
	dspck_tsimm prepend, 0x83fffffe, 0x07fffffc, 0x0001594b, 1
	dspck_tsimm prepend, 0x00800000, 0x80000000, 0x80000000, 8
	dspck_tsimm prepend, 0x1ffffff0, 0x1ffffff0, 0x8000007f, 0
	dspck_tsimm prepend, 0x3ff28345, 0xffca0d15, 0x7ffffff8, 2
	dspck_tsimm prepend, 0x00000001, 0xfffffffc, 0x00000000, 31
	dspck_tsimm prepend, 0x00000000, 0x00000002, 0x80000000, 4
	dspck_tsimm prepend, 0xa4f1ca00, 0x80000000, 0x00293c72, 22
	dspck_tsimm prepend, 0xe03fffff, 0xffffff58, 0xffffff80, 10
	dspck_tsimm prepend, 0x001fe01f, 0x00ff00ff, 0x80000000, 3
	dspck_tsimm prepend, 0xe1e1e1e1, 0xffffff80, 0xf0f0f0f0, 31
	dspck_tsimm prepend, 0x56c7a000, 0x000037a4, 0x0012b63d, 19
	dspck_tsimm prepend, 0xf07fffff, 0x3ffffff8, 0xfffffff8, 7
	dspck_tsimm prepend, 0xfffa4948, 0x00000000, 0xffff4929, 29
	dspck_tsimm prepend, 0xfffffff8, 0xfffffff0, 0xf8000003, 1
	dspck_tsimm prepend, 0xffffff00, 0x00000000, 0x7fffffff, 24
	dspck_tsimm prepend, 0x00120000, 0x00000007, 0x00000009, 15
	dspck_tsimm prepend, 0xffc1ffff, 0xffffff9d, 0xffffffe0, 15
	dspck_tsimm prepend, 0x0000007f, 0xfffe3d99, 0x80000000, 25
	dspck_tsimm prepend, 0x00000000, 0x00000000, 0x00000000, 7
	dspck_tsimm prepend, 0xfde6992d, 0x80000005, 0xfef34c96, 31
	dspck_tsimm prepend, 0xffffffff, 0xffffffe8, 0x7fffffff, 29
	dspck_tsimm prepend, 0x1ffffff0, 0x00000000, 0x0ffffff8, 31
	dspck_tsimm prepend, 0x7ffffffe, 0x7ffffffe, 0xff0fceda, 0
	dspck_tsimm prepend, 0x00000000, 0x00000000, 0x0002e398, 0

	writemsg "[29] Test shra.qb"
	dspck_dtsaio shra.qb, 0x00ff0000, 0x00ff3f01, 6, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x003fe138, 0x007fc371, 1, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00000000, 0x00000000, 4, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00000701, 0x01001d04, 2, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x0300fffc, 0x6d18fd87, 5, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x0dffc3ff, 0x0dffc3ff, 0, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00ff05ff, 0x00ff14ff, 2, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x000003ff, 0x000e35f9, 4, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x01ff0000, 0x06ff0000, 2, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xf9f800f5, 0xcfc705aa, 3, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00ff0000, 0x02bf0900, 7, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00000000, 0x00000214, 5, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00ffffff, 0x00ffffff, 1, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x87080001, 0x87080001, 0, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xf1000300, 0xe3000701, 1, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x030300ff, 0x7f7000ff, 5, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xff0000ff, 0xff0100ff, 2, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xff05ff07, 0xff59ff78, 4, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00ff0000, 0x00ff001c, 6, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xff00ff02, 0xff01ff04, 1, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xff0cfe01, 0xff0cfe01, 0, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x0000ff00, 0x0000ff00, 0, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xff0f0e00, 0xff1e1c00, 1, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xff000000, 0x8f070d04, 7, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00000003, 0x06000039, 4, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x000f00f0, 0x000f00f0, 0, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00000100, 0x01010f00, 3, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00000004, 0x00000008, 1, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00000000, 0x0d070300, 7, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xfafc00ff, 0xaac700ff, 4, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xffff00ff, 0xffff00ff, 7, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x0cffff00, 0x66ffff03, 3, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x06e700e6, 0x1b9f0199, 2, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xfb040000, 0xdb240000, 3, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x0efe0304, 0x38f90f12, 2, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00e00300, 0x00810f00, 2, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00000000, 0x00000000, 7, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xe61f0803, 0x997c200f, 2, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00ffff00, 0x72e3ff00, 7, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xf00f0809, 0x807e404d, 3, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x0ef3ffed, 0x1ce7ffdb, 1, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00fffff1, 0x04ffff8e, 3, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00ff0100, 0x00f91101, 4, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x007f2001, 0x007f2001, 0, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00000000, 0x00000000, 1, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xfb0f09ff, 0xef3f27ff, 2, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00023f00, 0x00047e00, 1, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00ff0000, 0x1fff0006, 7, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x000000ff, 0x020700ff, 7, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xff003e03, 0xff007c06, 1, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xf800feff, 0x8100e7ff, 4, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x541ecfbf, 0x541ecfbf, 0, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x1500f701, 0x2a00ef03, 1, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x0000ff00, 0x3000f100, 7, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xfd0300fe, 0xaa7e00c7, 5, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00ff0009, 0x02ff0048, 3, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x000000ff, 0x010000ff, 4, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xff00fe00, 0xff00aa19, 6, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xff000000, 0x9208001c, 7, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x000000ff, 0x130003e7, 7, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xfffff000, 0xffffc102, 2, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x07000319, 0x0e000733, 1, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xff000000, 0xff00011e, 6, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00000000, 0x00000000, 4, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xff00f000, 0xff01e000, 1, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x0100ffff, 0x7a04ffff, 6, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xff000200, 0xff000b01, 2, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xefff0100, 0xbfff0600, 2, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x03ffff00, 0x70f1ff00, 5, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x03f80301, 0x3f8e3019, 4, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00000000, 0x00027c03, 7, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xf9003c01, 0xf9003c01, 0, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xff0000fe, 0xf8112e99, 6, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xff0006f5, 0xff0030aa, 3, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00000000, 0x00000000, 5, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00000000, 0x0c050204, 6, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00000000, 0x00000000, 3, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00ffff00, 0x01ffff00, 5, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xf3000100, 0xcc000400, 2, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00000000, 0x0220077f, 7, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x01000010, 0x03010020, 1, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x01ff0009, 0x07ff0124, 2, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xfffc0000, 0xffe10301, 3, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xfe0400f8, 0xf02000c1, 3, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xff000012, 0xff010024, 1, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00000000, 0x001b0603, 5, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x0000ff00, 0x3e1bff02, 6, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xfd3301ff, 0xfd3301ff, 0, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xfc070000, 0xe33d0000, 3, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x0000ff02, 0x0000ff02, 0, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x023706e0, 0x046e0cc0, 1, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xc3ff0700, 0xc3ff0700, 0, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x0000f806, 0x00008166, 4, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x60ff0105, 0x60ff0105, 0, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xf3ff0100, 0x99ff0800, 3, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00000004, 0x03010046, 4, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00000001, 0x0c00102b, 5, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x0001ff00, 0x0660f93c, 6, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xff000df3, 0xff0036cc, 2, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x0000ff03, 0x0102ff3b, 4, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xff0003ff, 0xff000fff, 2, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00038103, 0x00038103, 0, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x03ff00f6, 0x1cff00b6, 3, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xf600030a, 0xdb010e2b, 2, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x02ff0300, 0x24ff3a00, 4, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x000000ff, 0x3f1000ff, 7, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00e00f00, 0x01c11e01, 1, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xff00f900, 0xff009900, 4, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xfe000000, 0xc31b0400, 5, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x38ff00c3, 0x70ff0087, 1, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xff0000ff, 0x8e0009f9, 7, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00000000, 0x00010001, 4, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00000000, 0x00000000, 7, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x0901d500, 0x1303aa00, 1, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xff0000ff, 0xff0007ff, 7, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x06fff803, 0x6aff8138, 4, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00f30300, 0x019f1c03, 3, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x0002ffff, 0x0027fff0, 4, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00fe0000, 0x00f80000, 2, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00000000, 0x021f0049, 7, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00000301, 0x061b6f24, 5, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x0700016c, 0x0700016c, 0, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xfc03ff00, 0x817fff00, 5, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00000000, 0x00000000, 3, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xff00ff00, 0x8e00cf00, 7, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xfd000000, 0xaa1a0e1f, 5, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00ffff01, 0x00ffff01, 0, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x01ffff01, 0x18f0ff1a, 4, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xff0000ff, 0xff003fcf, 7, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xf00001f9, 0x81000ccf, 3, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xff00ff00, 0xff00ff02, 5, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00000000, 0x00000000, 2, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x0000ff00, 0x0000ff24, 7, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x129f0908, 0x129f0908, 0, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x1b0000ff, 0x6d0001ff, 2, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x0f0007ff, 0x3d001fff, 2, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00ffff00, 0x1ee7c700, 7, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xff030000, 0xff1d0000, 3, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xff000000, 0xf90e0159, 7, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xff030200, 0xff332b00, 4, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00ffff00, 0x00c7e700, 6, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x1c08ffff, 0x7120ffff, 2, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xffffff00, 0xff99c300, 7, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x000000ff, 0x030800aa, 7, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xfe000001, 0xdf171c20, 5, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xff000000, 0xff08331c, 7, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x02001c00, 0x05003800, 1, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x0102ffff, 0x1820f8ff, 4, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00000002, 0x0001024d, 5, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00ffff01, 0x00ffc160, 6, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00000100, 0x06054800, 6, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00010003, 0x0e1a0638, 4, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x0000ffff, 0x0000ffff, 6, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x01030700, 0x040e1f01, 2, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xfd0000f8, 0xdb00068e, 4, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x05000001, 0x2f000008, 3, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xff09ffff, 0xff48ffff, 3, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x0002e101, 0x000a8706, 2, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00ff0000, 0x0dff001f, 6, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00fe00ff, 0x03cc00ff, 5, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00000000, 0x00000000, 1, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00000000, 0x00000000, 1, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x0f0614ff, 0x1f0c29ff, 1, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xff0000ff, 0xc30f05ff, 7, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00000000, 0x001f1509, 6, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00000000, 0x00000000, 5, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xff00ffff, 0xe00affff, 7, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xeaf00006, 0xaac00018, 2, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x0000fc02, 0x00009f47, 5, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x0006ffff, 0x0118ffff, 2, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xcc090000, 0xcc090000, 0, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x000000fc, 0x000700e0, 3, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xe300f13e, 0xc701e37c, 1, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x0000ff38, 0x0000ff70, 1, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xff0600f0, 0xff0600f0, 0, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x60c30dff, 0x60c30dff, 0, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xfffc0000, 0xfde70001, 3, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x06c00700, 0x06c00700, 0, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00ffff00, 0x00f1ff0c, 6, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xffb61fff, 0xffb61fff, 0, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00010000, 0x01330700, 5, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00fe00ff, 0x018f02ff, 6, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x0465cc0e, 0x0465cc0e, 0, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xff0000ff, 0xff0700ff, 4, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xfff600ff, 0xffb600ff, 3, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00ff01ff, 0x00ff38e0, 5, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x000000ff, 0x000f1eff, 7, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xe3021701, 0xe3021701, 0, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00ff0a00, 0x00ff5403, 3, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xfc000000, 0x80000100, 5, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xff0000ff, 0xff000fff, 7, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x0f000300, 0x1f000700, 1, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x0fff0007, 0x7fff003f, 3, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00000000, 0x00000000, 0, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00000100, 0x32287e00, 6, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00020004, 0x00160320, 3, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xfefeff00, 0x819ffe10, 6, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00ff0300, 0x03ff7f00, 5, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x01ffff00, 0x24ffff00, 5, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x000000ff, 0x000000ff, 6, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x06ff6000, 0x06ff6000, 0, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xffffff03, 0xffffff03, 0, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x000c0700, 0x00331c00, 2, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xffc79f04, 0xffc79f04, 0, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xe3ffffff, 0xc7ffffff, 1, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00ff041c, 0x00ff1371, 2, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x000001fe, 0x000038df, 5, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00000000, 0x03000c01, 5, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xfff9f101, 0xfccf8e0f, 3, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xfffe0000, 0xffe10100, 4, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xff0106f6, 0xf90d36b6, 3, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xc75500ff, 0xc75500ff, 0, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x1ee30001, 0x3dc70103, 1, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x0000000a, 0x00010755, 3, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00000000, 0x0201003f, 7, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x1f7e0e00, 0x1f7e0e00, 0, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00000000, 0x02003f01, 6, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xff000000, 0xc1660d07, 7, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xfffeff00, 0xffc7ff00, 5, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xf206ff00, 0x9231ff01, 3, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x000300ff, 0x007f0efc, 5, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x0000fc00, 0x0c00c00f, 4, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00ff0100, 0x08ff3c01, 5, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x096071ff, 0x096071ff, 0, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x3f0300ff, 0x7e0600ff, 1, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x0630ff30, 0x0c60ff60, 1, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xe3133849, 0xe3133849, 0, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xff01ff02, 0xff1efe20, 4, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x05000002, 0x5504002d, 4, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x02000e00, 0x15007102, 3, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x018e030c, 0x018e030c, 0, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00000003, 0x0101033e, 4, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00000113, 0x00010227, 1, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x0001fcf8, 0x070ee1c0, 3, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x000000ff, 0x020000ff, 4, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x0cff0fff, 0x60ff78ff, 3, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x0001ff00, 0x0103ff01, 1, 0x0, 0x0
	dspck_dtsaio shra.qb, 0xff010000, 0xff170600, 4, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x010000ff, 0x783a04db, 6, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x0c0e3200, 0x181d6500, 1, 0x0, 0x0
	dspck_dtsaio shra.qb, 0x00000000, 0x00000000, 5, 0x0, 0x0

	writemsg "[30] Test shra_r.qb"
	dspck_dtsaio shra_r.qb, 0x01060078, 0x01060078, 0, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x0001fe00, 0x001acc00, 5, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00003100, 0x00003100, 0, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x0111e7ff, 0x0111e7ff, 0, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00020400, 0xff080e00, 2, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0x0bff0002, 5, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0xe0051f1e, 6, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000008, 0x0000001e, 2, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000100, 0x15047cff, 7, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0xf9100005, 0xc77e0129, 3, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x10020000, 0x200400ff, 1, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x706d0d09, 0x706d0d09, 0, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x0000ff00, 0x0101bf01, 6, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x10100000, 0x1f1fffff, 1, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x3e000000, 0x7cffffff, 1, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0x0607ff11, 6, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0xff00030f, 7, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0xe0f907ff, 0xe0f907ff, 0, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0x00000000, 3, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0x100fffff, 6, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000200, 0x080b781e, 6, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0x00000000, 4, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0x20c71c30, 7, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000004, 0x0000ff07, 1, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x009905ff, 0x009905ff, 0, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000001, 0x24010049, 7, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x0a000000, 0x26ff0100, 2, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00f01e00, 0x00bf7800, 2, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0xdbffe019, 0xdbffe019, 0, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00001007, 0x00ff200e, 1, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x01000000, 0x54c7001e, 7, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x0007f500, 0x0038aafd, 3, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x000002fd, 0x06033b92, 5, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0x00000000, 1, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00040001, 0xff470016, 4, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x000e070f, 0x001b0d1e, 1, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00f208e0, 0xffc72080, 2, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0x00ff0000, 2, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x99180083, 0x99180083, 0, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0xdb010300, 7, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0x00000000, 5, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x0100050f, 0x09012478, 3, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000300, 0xff006d0d, 5, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x0c000800, 0x60ff3c01, 3, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x02020000, 0x1b21ff00, 4, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0xf2000005, 0xc701ff12, 2, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0xff00000b, 0xff00000b, 0, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00f90003, 0xff8fff30, 4, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0x04ffe7ff, 6, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x0c0005cc, 0x0c0005cc, 0, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0x00ff0700, 4, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x02000003, 0x0700000c, 2, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00ff0200, 0x00fd03ff, 1, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00010000, 0x00550eff, 6, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0x0400ff00, 7, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0xff000000, 0xe0ffff01, 5, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x11010c00, 0x220218ff, 1, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0x000a00ff, 6, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00060500, 0xff0b0aff, 1, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x0000f701, 0x0100db04, 2, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0x00000000, 4, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x01010000, 0x3e260101, 6, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x000001ff, 0x000001ff, 0, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x0001ff00, 0x0838cf00, 6, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x000010f0, 0xff0040bf, 2, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x0000ff00, 0x0300990f, 7, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x1000f41f, 0x3e00cf7c, 2, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x20793338, 0x20793338, 0, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x000000ff, 0x0f00ff87, 7, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x001c011c, 0x00370238, 1, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0x03000003, 3, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0x00070000, 4, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0xef00ff03, 7, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x1e13000d, 0x1e13000d, 0, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0x00000000, 3, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0x080c00ff, 5, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0x00f90000, 5, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x000d0300, 0x001a0600, 1, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x18f7ff01, 0x18f7ff01, 0, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0x00000000, 2, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x0000fa05, 0x00ffe715, 2, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x04000b00, 0x230055ff, 3, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000108, 0x01ff0420, 2, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x000000ff, 0x00f901aa, 7, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000300, 0x07006602, 5, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000100, 0x02ff08fd, 4, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x4002e800, 0x7f03cfff, 1, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x000300fe, 0x000bfff7, 2, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000100, 0x02001300, 5, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00c8000c, 0x008fff17, 1, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x0a9f000e, 0x0a9f000e, 0, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x0000003e, 0x00ff007c, 1, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x020002fe, 0x1dff18e0, 4, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x000002fd, 0x00000fe7, 3, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x000100fe, 0x032c00c1, 5, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0xff080001, 7, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x000200fe, 0xff4df9c0, 5, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x06001f00, 0x18ff7c00, 2, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0xb601ffff, 0xb601ffff, 0, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x30f40933, 0x60e71166, 1, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0xf20003f0, 0x92031b81, 3, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0x00000000, 4, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00350037, 0x0069006e, 1, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0xfe020000, 0x817303ff, 6, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00020100, 0xff3f19ff, 5, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x25ee3c08, 0x49db780f, 1, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0xffff0003, 0xffff0003, 0, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x000000fa, 0xffffff9f, 4, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0x07ff0000, 7, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00010001, 0x007f0052, 7, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x0000fe10, 0x0000ef7e, 3, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0xaa0000ff, 0xaa0000ff, 0, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x12070b02, 0x240e1503, 1, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0xf0080000, 0xc01e0001, 2, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x0000000f, 0x02010075, 3, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0xee000c01, 0xb6003003, 2, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0xff000905, 6, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0xe1000103, 0x8300020c, 2, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0xff000000, 0xe3000000, 5, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x10070800, 0x7e383cff, 3, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000008, 0x0000003c, 3, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0xff00f700, 0xf900b603, 3, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00ff0100, 0xffcc35ff, 6, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x0000fa01, 0x0101e703, 2, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0xfa010002, 0xcf0b010e, 3, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x05fa1004, 0x26cc7e21, 3, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0x02010303, 5, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0xffff00ff, 3, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0xff101ce0, 6, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00010001, 0xff2dff18, 5, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x03000002, 0x6000ff35, 5, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000001, 0xe3ff1020, 6, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x0eeb0100, 0x36aa0300, 2, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00030000, 0x01300000, 4, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00fd0100, 0xfff30501, 2, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x0000fc06, 0x00fff70c, 1, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x0001fe01, 0xff409f40, 6, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0x00000000, 0, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x0408fd08, 0x0e20f31e, 2, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x24ff609f, 0x24ff609f, 0, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x01000000, 0x66ffff2a, 7, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x09fd0e00, 0x12f91c00, 1, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0xfff30192, 0xfff30192, 0, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00080000, 0x013f0000, 3, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x0c00011f, 0x0c00011f, 0, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00ff0101, 0xfff70709, 3, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x01000101, 0x06fe0408, 3, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00080000, 0x067eff00, 4, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000100, 0x00ff7802, 7, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00020010, 0x0003ff1f, 1, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00010000, 0xff550002, 7, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x2500f001, 0x2500f001, 0, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000110, 0xff00011f, 1, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x000000ff, 0x30000083, 7, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000100, 0x15ff7806, 7, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x100b0500, 0x100b0500, 0, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00e40000, 0xff8fffff, 2, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x000500f9, 0xfd4eff8f, 4, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000002, 0x00000c30, 5, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00070000, 0xff390000, 3, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0x00000000, 2, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x02030003, 0x080cff0c, 2, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00f80005, 0xff83014d, 4, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00010100, 0x007e41f1, 7, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0x011b0304, 6, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x02fe0000, 0x30bf0300, 5, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0x0100f00c, 5, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0xfdfd0000, 0xf3f30101, 2, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x01040000, 0x1f7ffe04, 5, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x1e04010f, 0x3b08021e, 1, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x0100fe00, 0x2b00c700, 5, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0xffff0000, 3, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x0002ffe0, 0xff04fdc0, 1, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0x00ff0802, 6, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x008e0600, 0x008e0600, 0, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0xffccfc3e, 7, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x04010010, 0x04010010, 0, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0x00000000, 0, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0x00030000, 6, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00010000, 0xff7e000f, 7, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x0c0000e2, 0x170000c3, 1, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x02ff0400, 0x3fe07f03, 5, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0x0112000c, 6, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x7f0000e1, 0x7f0000e1, 0, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000001, 0x0100055d, 6, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x04000100, 0x46000f01, 4, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0x00000000, 4, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0xe79f0106, 0xe79f0106, 0, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x24618f00, 0x24618f00, 0, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00e74900, 0x00e74900, 0, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x000200fe, 0x0c7f0a99, 6, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0x090efd07, 6, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x000000ff, 0x000001db, 6, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00e00403, 0xff810e0d, 2, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0xf3090300, 0x994918ff, 3, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x09000000, 0x49000000, 3, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x79ff3018, 0x79ff3018, 0, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x000000ff, 0xff0100f9, 3, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0x00e1ff03, 7, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x04fe0002, 0x71c1f13a, 5, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x01010001, 0x2416f117, 5, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0xff000000, 0xef0c0200, 5, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0xc800001c, 0x8fff0038, 1, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x07f200fc, 0x389201e3, 3, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00010000, 0x3f4000ff, 7, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00100100, 0x003f02ff, 2, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00380000, 0x00380000, 0, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x020a0013, 0x0927ff4d, 2, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x18c0e004, 0x18c0e004, 0, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x000000ff, 0x3f03ef87, 7, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x001f7cff, 0x001f7cff, 0, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x000006ff, 0xff0066f0, 4, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00ff06fc, 0x02f733e0, 3, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00010002, 0x0005010e, 3, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0x00000000, 4, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x1c00f700, 0x1c00f700, 0, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x0800fc00, 0x7fffc3f9, 4, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0x1fc30fc3, 7, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00f20000, 0xff8e0000, 3, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0x0aff0000, 6, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000100, 0x010a551c, 6, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000100, 0x00ff1804, 5, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00010000, 0x001affff, 5, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00020000, 0x0007ff00, 2, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0xff0fffff, 7, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00020002, 0x01070006, 2, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x07010003, 0x7213ff2a, 4, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x03000000, 0x0aff0100, 2, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x000000ff, 0xf80003e1, 5, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0xc33c3302, 7, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x68ff00ff, 0x68ff00ff, 0, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x040000ff, 0x71fff0df, 5, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0xffff0100, 7, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0x00000000, 3, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0x003c1fe1, 7, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0xc2d5e600, 0x83aaccff, 1, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x01000000, 0x1400ff00, 5, 0x0, 0x0
	dspck_dtsaio shra_r.qb, 0x00000000, 0x02011cff, 6, 0x0, 0x0

	writemsg "[31] Test shrav.qb"
	dspck_dstio shrav.qb, 0x00000000, 0x02020003, 0xafd3a2af, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00000000, 0x04000101, 0x3fa6c62b, 0x0, 0x0
	dspck_dstio shrav.qb, 0x0000ff0e, 0x0100ff1c, 0xc0a75279, 0x0, 0x0
	dspck_dstio shrav.qb, 0xfcfcfc03, 0x9f8f8061, 0x2dd91095, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00ff6007, 0x00ff6007, 0x00000000, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00000000, 0x39010030, 0xb35f4bd6, 0x0, 0x0
	dspck_dstio shrav.qb, 0x0100ff00, 0x0c00ff00, 0xb39018b3, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00000000, 0x00000000, 0xdd9d8345, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00000000, 0x0009010d, 0x117dc387, 0x0, 0x0
	dspck_dstio shrav.qb, 0x165b1edf, 0x165b1edf, 0x8bdd73b0, 0x0, 0x0
	dspck_dstio shrav.qb, 0xff00ffff, 0xff00ffff, 0xa882ebfc, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00000000, 0x01000b00, 0xa1f78da5, 0x0, 0x0
	dspck_dstio shrav.qb, 0xff0000f8, 0xff0000c1, 0xc240332b, 0x0, 0x0
	dspck_dstio shrav.qb, 0x1f002b00, 0x3f005600, 0x9d77deb9, 0x0, 0x0
	dspck_dstio shrav.qb, 0xff00ff00, 0x87188134, 0x98ddb447, 0x0, 0x0
	dspck_dstio shrav.qb, 0xff00ffff, 0x8204819f, 0x8204819f, 0x0, 0x0
	dspck_dstio shrav.qb, 0xfcfff00e, 0xe1ff8071, 0xe85e9f4b, 0x0, 0x0
	dspck_dstio shrav.qb, 0x01ff0000, 0x36ff0000, 0x63dc6b55, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00000100, 0x070e6610, 0x96ce4886, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00021e08, 0x00053c10, 0x061c5191, 0x0, 0x0
	dspck_dstio shrav.qb, 0x0001040f, 0x0306103f, 0x49591efa, 0x0, 0x0
	dspck_dstio shrav.qb, 0xffff019f, 0xffff019f, 0x2e3876b8, 0x0, 0x0
	dspck_dstio shrav.qb, 0x47394dc0, 0x47394dc0, 0x47394dc0, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00000000, 0x00000000, 0xf5574786, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00bf8700, 0x00bf8700, 0x42635220, 0x0, 0x0
	dspck_dstio shrav.qb, 0xfe0000ff, 0xb60000ff, 0x15d4257e, 0x0, 0x0
	dspck_dstio shrav.qb, 0x1f00d512, 0x3f00aa24, 0xdf5baef1, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00f90000, 0x06cc0500, 0x06ec25e3, 0x0, 0x0
	dspck_dstio shrav.qb, 0xfeff0000, 0x99e70302, 0xe9b3a706, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00f37c00, 0x00f37c00, 0x0dbd3a00, 0x0, 0x0
	dspck_dstio shrav.qb, 0x01051207, 0x0517491c, 0x0f07fe0a, 0x0, 0x0
	dspck_dstio shrav.qb, 0x0106001f, 0x0106001f, 0x8f132c78, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00ffff00, 0x00ffff03, 0x2945c7ed, 0x0, 0x0
	dspck_dstio shrav.qb, 0x0001fd00, 0x062cb11d, 0x062cb11d, 0x0, 0x0
	dspck_dstio shrav.qb, 0xff0000ff, 0xe00c08ff, 0xac63fe5d, 0x0, 0x0
	dspck_dstio shrav.qb, 0xff010000, 0xff3f0203, 0xbe03f215, 0x0, 0x0
	dspck_dstio shrav.qb, 0x02ff0dff, 0x08ff37ff, 0x0b8206a2, 0x0, 0x0
	dspck_dstio shrav.qb, 0x05000000, 0x5b030d01, 0xefe6d0f4, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00000000, 0x00000000, 0x417f4151, 0x0, 0x0
	dspck_dstio shrav.qb, 0x380022ff, 0x380022ff, 0x21b5f3f0, 0x0, 0x0
	dspck_dstio shrav.qb, 0x0d0a1402, 0x352a530a, 0x352a530a, 0x0, 0x0
	dspck_dstio shrav.qb, 0x03ff0000, 0x33ff070c, 0x49b3c244, 0x0, 0x0
	dspck_dstio shrav.qb, 0xff0100ff, 0xff0c00ff, 0xf802e8c3, 0x0, 0x0
	dspck_dstio shrav.qb, 0x0000ffff, 0x0006ffff, 0x0e271af5, 0x0, 0x0
	dspck_dstio shrav.qb, 0x0b700000, 0x0b700000, 0x00000000, 0x0, 0x0
	dspck_dstio shrav.qb, 0x000300f8, 0x000600f1, 0xd4bc0121, 0x0, 0x0
	dspck_dstio shrav.qb, 0x000100fe, 0x042001cf, 0x87f2742d, 0x0, 0x0
	dspck_dstio shrav.qb, 0x0000ff00, 0x0500ff03, 0x36e58b23, 0x0, 0x0
	dspck_dstio shrav.qb, 0x01000000, 0x06000202, 0x3f6da0fa, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00fb0101, 0x00db0b0a, 0xa68689f3, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00000001, 0x00051a27, 0x06d1563d, 0x0, 0x0
	dspck_dstio shrav.qb, 0x000000ff, 0x000300ff, 0x93639cc4, 0x0, 0x0
	dspck_dstio shrav.qb, 0x0f010000, 0x7e080000, 0x859a2a53, 0x0, 0x0
	dspck_dstio shrav.qb, 0x0100ff03, 0x0800ff1f, 0x66c89803, 0x0, 0x0
	dspck_dstio shrav.qb, 0xffff0407, 0xffff111c, 0x173c43e2, 0x0, 0x0
	dspck_dstio shrav.qb, 0x1bff00fb, 0x37ff01f7, 0x60ab3591, 0x0, 0x0
	dspck_dstio shrav.qb, 0x0000f0fb, 0x0000c0ef, 0xe332bb62, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00000000, 0x3f060f1f, 0x3695b34f, 0x0, 0x0
	dspck_dstio shrav.qb, 0xfe000700, 0xef037100, 0xa8a15ae4, 0x0, 0x0
	dspck_dstio shrav.qb, 0x0003ff00, 0x1e6dff00, 0xcd7da8bd, 0x0, 0x0
	dspck_dstio shrav.qb, 0x0000f707, 0x0000f707, 0x00000000, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00000107, 0x00001e71, 0xc58eccb4, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_dstio shrav.qb, 0xff0000ff, 0xff020bff, 0x86423814, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00f00003, 0x00e10107, 0x4d551709, 0x0, 0x0
	dspck_dstio shrav.qb, 0x05ffff00, 0x29ffff00, 0x32044deb, 0x0, 0x0
	dspck_dstio shrav.qb, 0xff000000, 0xff010202, 0x9c48e7a5, 0x0, 0x0
	dspck_dstio shrav.qb, 0x000000ff, 0x000018c3, 0x315e3446, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00ff0000, 0x00ff0004, 0xc41aca7e, 0x0, 0x0
	dspck_dstio shrav.qb, 0x000101ff, 0x050f0eff, 0x94849dbb, 0x0, 0x0
	dspck_dstio shrav.qb, 0x000001fe, 0x001d36c3, 0xc39610f5, 0x0, 0x0
	dspck_dstio shrav.qb, 0xff0001ff, 0xff0309ff, 0x4ed1528b, 0x0, 0x0
	dspck_dstio shrav.qb, 0xe0fd04ff, 0x83f710ff, 0xac920fca, 0x0, 0x0
	dspck_dstio shrav.qb, 0x0000f000, 0x0100c103, 0x06a82daa, 0x0, 0x0
	dspck_dstio shrav.qb, 0x02ffff00, 0x24fdff01, 0xf20a70a4, 0x0, 0x0
	dspck_dstio shrav.qb, 0x7840fff7, 0x7840fff7, 0x1924ffd8, 0x0, 0x0
	dspck_dstio shrav.qb, 0x03ff24ff, 0x03ff24ff, 0x0619b520, 0x0, 0x0
	dspck_dstio shrav.qb, 0x04ff098e, 0x04ff098e, 0xe6650048, 0x0, 0x0
	dspck_dstio shrav.qb, 0x0eff0001, 0x1cff0003, 0xea144cb1, 0x0, 0x0
	dspck_dstio shrav.qb, 0xff0100ff, 0xdb7e06ff, 0xdfa828de, 0x0, 0x0
	dspck_dstio shrav.qb, 0xff000100, 0xfc0c3c00, 0x5911f40d, 0x0, 0x0
	dspck_dstio shrav.qb, 0x01e40000, 0x05920300, 0x19d88f1a, 0x0, 0x0
	dspck_dstio shrav.qb, 0xffffffe0, 0xffffffc0, 0x651ab179, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00330016, 0x00330016, 0x86d483b8, 0x0, 0x0
	dspck_dstio shrav.qb, 0x01000008, 0x0f000040, 0xff5594a3, 0x0, 0x0
	dspck_dstio shrav.qb, 0xff010300, 0xff030600, 0x4b9c7bd9, 0x0, 0x0
	dspck_dstio shrav.qb, 0x0000000e, 0x0000001c, 0xd4498c01, 0x0, 0x0
	dspck_dstio shrav.qb, 0x000000ff, 0x007102ff, 0xb63d928f, 0x0, 0x0
	dspck_dstio shrav.qb, 0xf0001938, 0xe1013370, 0x501b0be9, 0x0, 0x0
	dspck_dstio shrav.qb, 0xe008ff00, 0xc111ff00, 0x0f48f791, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00010400, 0x01030901, 0x03bec071, 0x0, 0x0
	dspck_dstio shrav.qb, 0xff3e3002, 0xff7c6004, 0x1408a259, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00000000, 0x00000000, 0xab16062d, 0x0, 0x0
	dspck_dstio shrav.qb, 0x000000ff, 0x30003efc, 0xd50a4476, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00000000, 0x02010006, 0x19f2191b, 0x0, 0x0
	dspck_dstio shrav.qb, 0x03ff03fd, 0x66f371bd, 0x66f371bd, 0x0, 0x0
	dspck_dstio shrav.qb, 0x0b0bff06, 0x0b0bff06, 0x537ca288, 0x0, 0x0
	dspck_dstio shrav.qb, 0x0ef900ff, 0x3be703ff, 0x0314e022, 0x0, 0x0
	dspck_dstio shrav.qb, 0x000000fe, 0x000803aa, 0x78d420d6, 0x0, 0x0
	dspck_dstio shrav.qb, 0x000600c1, 0x000c0083, 0x2ecd3cc9, 0x0, 0x0
	dspck_dstio shrav.qb, 0xffffffff, 0xffffbf8e, 0x96dd54e7, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00f11f00, 0x00c77c01, 0xd2c78f22, 0x0, 0x0
	dspck_dstio shrav.qb, 0x000006ff, 0x000a60f7, 0x6deed8ac, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00000000, 0x00090000, 0x8c623acd, 0x0, 0x0
	dspck_dstio shrav.qb, 0x0001f803, 0x04118133, 0xdfc175a4, 0x0, 0x0
	dspck_dstio shrav.qb, 0x07f3f300, 0x1fcccc00, 0x874135ba, 0x0, 0x0
	dspck_dstio shrav.qb, 0xf9ff10c0, 0xf9ff10c0, 0x00000000, 0x0, 0x0
	dspck_dstio shrav.qb, 0x000000ff, 0x17070c8e, 0x24d2eb27, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00ff00ff, 0x00aa00aa, 0xe98fb6c7, 0x0, 0x0
	dspck_dstio shrav.qb, 0x010cff33, 0x010cff33, 0xb92126d0, 0x0, 0x0
	dspck_dstio shrav.qb, 0x0007ffff, 0x003cffff, 0x85da748b, 0x0, 0x0
	dspck_dstio shrav.qb, 0x0100fc00, 0x33008702, 0xa5e7f1e5, 0x0, 0x0
	dspck_dstio shrav.qb, 0x0000ff00, 0x0001f100, 0x39b74ddd, 0x0, 0x0
	dspck_dstio shrav.qb, 0x000000f1, 0x000000f1, 0x00000000, 0x0, 0x0
	dspck_dstio shrav.qb, 0x000000c7, 0x0000008f, 0xa5d38501, 0x0, 0x0
	dspck_dstio shrav.qb, 0xd33be338, 0xa676c771, 0xa676c771, 0x0, 0x0
	dspck_dstio shrav.qb, 0xfe000001, 0xe100001f, 0xd257bb44, 0x0, 0x0
	dspck_dstio shrav.qb, 0xfffffc00, 0xffffe000, 0x80856f23, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00000000, 0x00000033, 0xfca7c1af, 0x0, 0x0
	dspck_dstio shrav.qb, 0x0b000005, 0x1600000a, 0xfcf17749, 0x0, 0x0
	dspck_dstio shrav.qb, 0x0300c300, 0x07008700, 0xf7d6c109, 0x0, 0x0
	dspck_dstio shrav.qb, 0x01fc0000, 0x10cf0001, 0xbdf51434, 0x0, 0x0
	dspck_dstio shrav.qb, 0x0000fd00, 0x0300db00, 0xd5835b3c, 0x0, 0x0
	dspck_dstio shrav.qb, 0x2a300707, 0x55610e0f, 0x4a0f2999, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00ff0000, 0x00ff0031, 0x542810b7, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00fcff00, 0x07cfff01, 0xd483ba64, 0x0, 0x0
	dspck_dstio shrav.qb, 0x0000ff00, 0x0007ff00, 0x939cb144, 0x0, 0x0
	dspck_dstio shrav.qb, 0x0100ff00, 0x6018ff0c, 0xda2ae0a6, 0x0, 0x0
	dspck_dstio shrav.qb, 0x1d000574, 0x1d000574, 0x81c54170, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00000000, 0x00000000, 0xd90eac9c, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00000000, 0x02000100, 0x45fa4234, 0x0, 0x0
	dspck_dstio shrav.qb, 0x000000fc, 0x05021692, 0xd2a97325, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00ff0000, 0x15c00000, 0x26163786, 0x0, 0x0
	dspck_dstio shrav.qb, 0x000208ff, 0x010510ff, 0x5642cae9, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00ffff00, 0x07ffff01, 0x06c6977d, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00000000, 0x00000000, 0xcf158188, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00000000, 0x00000000, 0x89751668, 0x0, 0x0
	dspck_dstio shrav.qb, 0x0000ffe1, 0x0000ffc3, 0x051fe121, 0x0, 0x0
	dspck_dstio shrav.qb, 0x0f1400f6, 0x3f5200da, 0x3f5200da, 0x0, 0x0
	dspck_dstio shrav.qb, 0x180d0100, 0x311a0200, 0x1fc3d561, 0x0, 0x0
	dspck_dstio shrav.qb, 0x0c00ff01, 0x1900ff02, 0x85158e01, 0x0, 0x0
	dspck_dstio shrav.qb, 0xff0001f8, 0xff0008c0, 0x42ddc17b, 0x0, 0x0
	dspck_dstio shrav.qb, 0x000001ff, 0x00001cff, 0xd8c9f45c, 0x0, 0x0
	dspck_dstio shrav.qb, 0x010000ff, 0x040001ff, 0x3655c3c2, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00000000, 0x00000000, 0xea33d1d2, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00000000, 0x00070001, 0x58f8fe47, 0x0, 0x0
	dspck_dstio shrav.qb, 0xff041800, 0xff041800, 0xe459f6d8, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00ff0000, 0x04e32426, 0x42839a26, 0x0, 0x0
	dspck_dstio shrav.qb, 0x02030000, 0x0b0e0200, 0x3c75a952, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00f8f0ff, 0x00c181ff, 0xafd45b2b, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00000000, 0x00301e00, 0xa85dfb5f, 0x0, 0x0
	dspck_dstio shrav.qb, 0xff000000, 0xff006601, 0x7d9c855f, 0x0, 0x0
	dspck_dstio shrav.qb, 0xff06001b, 0xff18006d, 0x1dcd6cf2, 0x0, 0x0
	dspck_dstio shrav.qb, 0x01000003, 0x0b000018, 0x3f66acf3, 0x0, 0x0
	dspck_dstio shrav.qb, 0xff000000, 0xff000204, 0xc90e2906, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00fe00f8, 0x04e00383, 0xeeb69444, 0x0, 0x0
	dspck_dstio shrav.qb, 0x000c00ff, 0x006000ff, 0xe8ac4013, 0x0, 0x0
	dspck_dstio shrav.qb, 0xff02fe01, 0xe155c625, 0xe155c625, 0x0, 0x0
	dspck_dstio shrav.qb, 0xff010000, 0xff180300, 0x00f72d24, 0x0, 0x0
	dspck_dstio shrav.qb, 0xff00ffff, 0x8e48fff1, 0x7b3afccf, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00060416, 0x00060416, 0xde10aa60, 0x0, 0x0
	dspck_dstio shrav.qb, 0x001c1205, 0x00714914, 0xd51c7482, 0x0, 0x0
	dspck_dstio shrav.qb, 0xff020002, 0xff4e005f, 0xe30ca9f5, 0x0, 0x0
	dspck_dstio shrav.qb, 0xff0000ff, 0xfd0100bf, 0x46699ddf, 0x0, 0x0
	dspck_dstio shrav.qb, 0x0000ff00, 0x0101ff04, 0x25bb8687, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00000000, 0x00000000, 0x96640109, 0x0, 0x0
	dspck_dstio shrav.qb, 0x36000b00, 0x6d001600, 0xc4451731, 0x0, 0x0
	dspck_dstio shrav.qb, 0xe300ff30, 0xc700ff60, 0x52d5c559, 0x0, 0x0
	dspck_dstio shrav.qb, 0x380f17ff, 0x701e2eff, 0xf200a999, 0x0, 0x0
	dspck_dstio shrav.qb, 0x2e000700, 0x5c000e00, 0xf33d2349, 0x0, 0x0
	dspck_dstio shrav.qb, 0xff000701, 0xff007119, 0xda59fd44, 0x0, 0x0
	dspck_dstio shrav.qb, 0xff01ff00, 0xf710ff01, 0x2ef51474, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00ff0107, 0x00ff1d70, 0x4923c7e4, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00000100, 0x113a4923, 0x742077fe, 0x0, 0x0
	dspck_dstio shrav.qb, 0xff381800, 0xff703100, 0x3b772a49, 0x0, 0x0
	dspck_dstio shrav.qb, 0x0103ff00, 0x0103ff00, 0x42bfc240, 0x0, 0x0
	dspck_dstio shrav.qb, 0x1a01effd, 0x1a01effd, 0x71d8f2c8, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00010001, 0x00680147, 0x5b418ea6, 0x0, 0x0
	dspck_dstio shrav.qb, 0xff010006, 0xff16076d, 0xf6845a7c, 0x0, 0x0
	dspck_dstio shrav.qb, 0x000302fc, 0x12704b8f, 0x897b354d, 0x0, 0x0
	dspck_dstio shrav.qb, 0xffff0a01, 0xffff2906, 0x91185112, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00000000, 0x00000000, 0x2afc9373, 0x0, 0x0
	dspck_dstio shrav.qb, 0xff030000, 0xff1e0000, 0xc08259b3, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00000000, 0x00030f0e, 0x9ed5dad4, 0x0, 0x0
	dspck_dstio shrav.qb, 0xff0000fe, 0xc01c0081, 0xa8c7260e, 0x0, 0x0
	dspck_dstio shrav.qb, 0x020000ea, 0x090001aa, 0x82443f9a, 0x0, 0x0
	dspck_dstio shrav.qb, 0xff000000, 0xff000000, 0xd8801cd3, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00000000, 0x37000001, 0x24480ffe, 0x0, 0x0
	dspck_dstio shrav.qb, 0x03ff3800, 0x06ff7100, 0x5fcde621, 0x0, 0x0
	dspck_dstio shrav.qb, 0xe3cc0fff, 0xe3cc0fff, 0x80546498, 0x0, 0x0
	dspck_dstio shrav.qb, 0x000000ff, 0x060000ff, 0xa63e71eb, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00000000, 0x00000000, 0xef98b601, 0x0, 0x0
	dspck_dstio shrav.qb, 0x0007f800, 0x077e8301, 0x8fd74ca4, 0x0, 0x0
	dspck_dstio shrav.qb, 0x0001f340, 0x0001f340, 0xf9525288, 0x0, 0x0
	dspck_dstio shrav.qb, 0x07000000, 0x7e040000, 0x2b9b0454, 0x0, 0x0
	dspck_dstio shrav.qb, 0xff031d01, 0xff031d01, 0x3723b810, 0x0, 0x0
	dspck_dstio shrav.qb, 0x080c001e, 0x080c001e, 0x27388b78, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00fc0000, 0x00e70002, 0xfd5731ab, 0x0, 0x0
	dspck_dstio shrav.qb, 0xff010001, 0xf37c3066, 0xadf6eeee, 0x0, 0x0
	dspck_dstio shrav.qb, 0x03010000, 0x7c380000, 0x6273b78d, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00030000, 0x16730000, 0x2ff34b55, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00ff0303, 0x00ff0606, 0x9e9bf481, 0x0, 0x0
	dspck_dstio shrav.qb, 0x81000003, 0x81000003, 0x877e1140, 0x0, 0x0
	dspck_dstio shrav.qb, 0x03000003, 0x32000c30, 0xcac0f81c, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00ff00ff, 0x00ff00ff, 0xf0769d3e, 0x0, 0x0
	dspck_dstio shrav.qb, 0xff0003fb, 0xfe021edb, 0x3fde5653, 0x0, 0x0
	dspck_dstio shrav.qb, 0xfeff00fd, 0xccff00b6, 0xa1455fad, 0x0, 0x0
	dspck_dstio shrav.qb, 0xff0600f8, 0xff3103c7, 0xce48298b, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00000000, 0x00000000, 0x8e94e6c8, 0x0, 0x0
	dspck_dstio shrav.qb, 0xffff02ff, 0xffff17ff, 0xc64cbde3, 0x0, 0x0
	dspck_dstio shrav.qb, 0xf801df00, 0xf103bf00, 0xb7c8b3c1, 0x0, 0x0
	dspck_dstio shrav.qb, 0xff00ff00, 0xff02ff1e, 0xeaff692d, 0x0, 0x0
	dspck_dstio shrav.qb, 0xf9000000, 0x92000108, 0xcd1eda74, 0x0, 0x0
	dspck_dstio shrav.qb, 0x09066699, 0x09066699, 0xba540f48, 0x0, 0x0
	dspck_dstio shrav.qb, 0x3c0000ff, 0x780000ff, 0xbd382b61, 0x0, 0x0
	dspck_dstio shrav.qb, 0xf10700f3, 0xf10700f3, 0x96530318, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00fffe00, 0x1fff9203, 0xf6b888b6, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00010003, 0x0012053f, 0xd4bedd14, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00ff0000, 0x03ff0302, 0xe69bf4bc, 0x0, 0x0
	dspck_dstio shrav.qb, 0x0006fcf1, 0x0035e38e, 0xce0b293b, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00fffe00, 0x01e3bf10, 0xb6ff1c56, 0x0, 0x0
	dspck_dstio shrav.qb, 0x000000f1, 0x000103c7, 0xeb1baaa2, 0x0, 0x0
	dspck_dstio shrav.qb, 0x1df00007, 0x3be0000e, 0x13eefe49, 0x0, 0x0
	dspck_dstio shrav.qb, 0x000600ff, 0x0c6000ff, 0x6d6530cc, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00ff010d, 0x00ff010d, 0x76c2f0d8, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00000000, 0x0001786d, 0x933f62cf, 0x0, 0x0
	dspck_dstio shrav.qb, 0xff0000fe, 0xff0500f0, 0x0700174b, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00f3f000, 0x009f8301, 0x07c93ba3, 0x0, 0x0
	dspck_dstio shrav.qb, 0xfcff0000, 0x87ff0000, 0xd7adcf45, 0x0, 0x0
	dspck_dstio shrav.qb, 0x0003fb04, 0x0118db22, 0x9edbd473, 0x0, 0x0
	dspck_dstio shrav.qb, 0x000000ff, 0x000e00ff, 0x30b7e6ff, 0x0, 0x0
	dspck_dstio shrav.qb, 0xcc000701, 0xcc000701, 0x00000000, 0x0, 0x0
	dspck_dstio shrav.qb, 0x121aff04, 0x2535ff08, 0x09d93101, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00fff9ff, 0x03ffccff, 0x8388608b, 0x0, 0x0
	dspck_dstio shrav.qb, 0xf804ea1f, 0xe010aa7c, 0xee906422, 0x0, 0x0
	dspck_dstio shrav.qb, 0xf800ff00, 0xf101ff00, 0xbcbb8611, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00ff0400, 0x00f04000, 0xd26579c4, 0x0, 0x0
	dspck_dstio shrav.qb, 0x00000000, 0x60007800, 0xe87d4f0f, 0x0, 0x0
	dspck_dstio shrav.qb, 0x0000ff00, 0x0000b604, 0x08b5b807, 0x0, 0x0
	dspck_dstio shrav.qb, 0x020f031f, 0x041f063e, 0xc1b93021, 0x0, 0x0

	writemsg "[32] Test shrav_r.qb"
	dspck_dstio shrav_r.qb, 0x01000000, 0x3301040f, 0x242d09be, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x08ef04ff, 0x08ef04ff, 0x00000000, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0xff000000, 0xefff0300, 0x60471685, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x02f81700, 0x09e15c00, 0xb8f4bda2, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x550000f1, 0x550000f1, 0x93bd72c0, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x023a2500, 0x047349ff, 0x1512c6c1, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00f10006, 0xff870031, 0x5a89d3fb, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0x0023f800, 0xb60ef5cf, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0xff110949, 0xff110949, 0xd2e09ff0, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x0000ff00, 0x00009f0f, 0xfe907307, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0xf00b0102, 0x81550611, 0xd5b7e94b, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x39e80e01, 0x71cf1c01, 0x28f5f269, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0x00ef0003, 0x2687028f, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000004, 0x0001003e, 0xe45d186c, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x010f01e4, 0x011e01c7, 0xcee65491, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x000001ff, 0x07007e83, 0x17124257, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0xffff00fd, 0xd0e0fca5, 0xd0e0fca5, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x000904fe, 0xff4922f3, 0xaa1589b3, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x111fe219, 0x457a8762, 0x457a8762, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000001, 0x18000078, 0xfe0946a7, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x01000000, 0x71000fc3, 0xe027864f, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x920f055c, 0x920f055c, 0x00000000, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00010002, 0x00050013, 0x46bb17bb, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x02000004, 0x3507f878, 0xc84e5045, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00fe1c00, 0xfff77100, 0x96f1736a, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0xff000a04, 0xff000a04, 0x00000000, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00ff0000, 0x1081ffff, 0xbbd479f7, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0x00000000, 0x70562009, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0xdb000000, 0xb6ffffff, 0xceeb3209, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0xbf5be101, 0xbf5be101, 0x638a5990, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00060000, 0xff300000, 0xc6c80193, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0xf8f80600, 0x83876000, 0x16aff16c, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0xff0500ff, 0xff0500ff, 0xa37e4968, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000300, 0x00003603, 0x451d55fc, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0xf700000a, 0xb6ff0052, 0xc97e86ab, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x0d000200, 0x33ff0600, 0x9894bee2, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00ff0000, 0x008e18ff, 0x364d3e67, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0x1fffff00, 0xc9033376, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0x00ff0000, 0x0536ff89, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000001, 0x0fff0579, 0xf61738e7, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0x032c0000, 0x2a826707, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x06030115, 0x170b0455, 0xc1ae0e2a, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00ff0000, 0x00aaffff, 0xcbacb87e, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0xff02ff01, 0xd46bb34e, 0xd46bb34e, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0xe7fe2bff, 0xe7fe2bff, 0x00000000, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0x06030300, 0x0008459e, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00001000, 0xff0040ff, 0xb93b915a, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x02020100, 0x677f4a06, 0x9f141b8e, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000100, 0xff005500, 0xe4397cfe, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x02000000, 0x49000300, 0x17825ba5, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x01f100ff, 0x01e100fe, 0x03fc3491, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0x0012000f, 0xc931e687, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0xfc09000e, 0xdf440171, 0xdfaac933, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0x0000ff07, 0x1986bee4, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000001, 0xfff00054, 0xc8d79356, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0x09ff0000, 0xbbc8f8f6, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x0000ff00, 0x06ffc707, 0xe90b9db6, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x301a0027, 0x6033004e, 0x07dcb981, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0x00000000, 0x73bef463, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x01180002, 0x045e0008, 0x98da93ea, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0xfafc0000, 0xe7f00000, 0x54b35ef2, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x1a3efcff, 0x337cf8fd, 0xa36a5c11, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0xfe000000, 0x87e00013, 0x4d8800ae, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x06000000, 0x3000fd00, 0xe412b51b, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x4901ff49, 0x4901ff49, 0x00000000, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x010100fe, 0x38200083, 0xf5b9c7e6, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00050000, 0x0049fe00, 0x463b491c, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0x00ffffff, 0xe53983a5, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00fe0000, 0x1487ff01, 0x682f399e, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0x00ff01ff, 0x395b152d, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000103, 0x0d001b66, 0x9b1936a5, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0xff00feff, 0x7c8e6786, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0x1e000100, 0xc771647f, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000200, 0x00ff0400, 0x36e1a469, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0xffff1cfc, 0xffff1cfc, 0x877b2530, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0xff260205, 0x9900067f, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0x00000000, 0x2371af46, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0xffc75500, 0xffc75500, 0xfb9fb348, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000b00, 0x00005500, 0x38ed940b, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0xe8f8f205, 0x9fdfc713, 0xc2cd014a, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x01000b01, 0x01001601, 0xa5f80111, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x020c0000, 0x0730ff00, 0x528e8c4a, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000001, 0x0000ff24, 0xd47c0d7e, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x01df0000, 0x01df0000, 0x00000000, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x06fe03ff, 0x58df31f4, 0x58df31f4, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0xfd000000, 0xe700ff00, 0xc410611b, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x000000ff, 0x00030fdf, 0xd2494f75, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x000000fc, 0x00f9ffc1, 0xd9d062f4, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0xffdb3ed0, 0xfeb67c9f, 0x304ab6a9, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x01000002, 0x04010007, 0x37ea5b1a, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x49ff6681, 0x49ff6681, 0x0b6ea420, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x010d1504, 0x010d1504, 0x83e09d28, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x020000fe, 0x61ff009f, 0x2f50a106, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00ff03ef, 0x00ff03ef, 0x54d09060, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x0d8c5298, 0x0d8c5298, 0x0d8c5298, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000300, 0x000362f3, 0xa5e9ccb5, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0x00000000, 0x040a201b, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0xfc1a0000, 0xf06600ff, 0x6a9c5e7a, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00010000, 0xff08ff00, 0x074eb1a3, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00290000, 0x00290000, 0x93762660, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x02000000, 0x3800ff00, 0x48a9cdc5, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x0701cd02, 0x0e019904, 0xe4498451, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x0a0ef900, 0x0a0ef900, 0x00000000, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00e40208, 0xff8e061e, 0xeeab1a0a, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0xff003e00, 0xa79b2f47, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00020200, 0xff434001, 0xe7617b0d, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000100, 0xff207e00, 0x5af39467, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00010001, 0xc443e76f, 0xc443e76f, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x01000100, 0x3f00490b, 0xafee0fd6, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00010701, 0x00010e02, 0x7410a9a9, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000002, 0x00000008, 0x30f14b02, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x0a008100, 0x0a008100, 0x0dd94070, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0xff000200, 0xec0327fc, 0xec0327fc, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00080001, 0x037c0011, 0xadeff08c, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000400, 0x00007eff, 0x5e569c2d, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x0008303e, 0x000f607c, 0x9cd3b211, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x010000ff, 0x43ff06cc, 0x78a57306, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00020000, 0x007c05ff, 0xea658946, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0x00000000, 0xc03dde95, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x01000000, 0x0c0104ff, 0xf68aca14, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x051b0305, 0x051b0305, 0xf1384590, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x81190e00, 0x81190e00, 0xbfd1e558, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0x00ff0000, 0x206b0a24, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00ff00ff, 0x11990e8f, 0x11990e8f, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00020000, 0x00040000, 0x4f7dd351, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x0a02f000, 0x2908bf00, 0x0fa650ca, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x01010101, 0x13162424, 0xd31bd115, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00030000, 0x00600008, 0x0e771295, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x02000000, 0x4d0200f1, 0x8d564cd5, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0xff00876d, 0xff00876d, 0xb4f870e0, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x010100fe, 0x403a029f, 0x5ca38336, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x02000000, 0x4900ffff, 0x6c565805, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x000000ff, 0xcf020083, 0x407e9f27, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x070600ff, 0x070600ff, 0x0c048ac0, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x05020000, 0x4d1e0000, 0x74d658c4, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0x00000000, 0x808f85aa, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x0014e002, 0x004e8007, 0x4f7e36c2, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00ff00fe, 0x18c30383, 0x6f593c76, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000005, 0xff00000a, 0xd31ffe59, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0xdb7e0500, 0xdb7e0500, 0x5a21c1c0, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00f8fd00, 0x0087cf01, 0xab4fe12c, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x920a0325, 0x920a0325, 0xf2b828f0, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0xfe000001, 0xe7020712, 0x42284324, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000200, 0x00017109, 0x42efba8e, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x02020600, 0x0d0c3303, 0x20ee61db, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x0000fe00, 0x0500cf07, 0xd61058bd, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0xf803fff8, 0x22ff6da4, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000004, 0xffff0038, 0xee761a1c, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0xf7081eff, 0xf7081eff, 0xeb44b7f8, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x0138db00, 0x0138db00, 0x00000000, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00050000, 0x0155ffff, 0x3d63281c, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x04000000, 0x10010000, 0x1385a6e2, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x09000000, 0x490301ff, 0x76f7c833, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x0100f300, 0x07019900, 0x308ece2b, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0xf700ff07, 0x3ff4817e, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0x00000000, 0xa5fb9a3f, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000008, 0x00ff0278, 0xf0f3a2ec, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x02000002, 0x3301013e, 0xf7f185cd, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x01010000, 0x625e083c, 0xed380d7f, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x02010002, 0x361b0839, 0xf6d339b5, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x20010502, 0x7f021206, 0x662ff09a, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x003801ff, 0x003801ff, 0x0dff0f30, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00100401, 0x00400e02, 0x1f4f656a, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00040200, 0x000e0700, 0xf27342ba, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0xffe3208e, 0xffe3208e, 0x17ba7058, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0xeb00e415, 0xaa008f53, 0xfc013b02, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00ff0000, 0x0edb0101, 0x10b7c7d6, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0x0003ff01, 0xb799731e, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x07160000, 0x0e2b00ff, 0xc919bf81, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x0210006e, 0x0210006e, 0x00000000, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0x00000000, 0x1f1cf245, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0xff150cff, 0xff150cff, 0xf379eda8, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000100, 0xfffd2410, 0x0be3f526, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000002, 0x0408ff6d, 0x0daf8956, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x0000fc00, 0xfcff8000, 0xbeed5325, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0x07fe01c0, 0xcfed84ff, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0x09ffc303, 0x06c567c7, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x02020000, 0x493e01ff, 0xcd1f25fd, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00ff0203, 0x03e33955, 0xa367eb2d, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0x00000000, 0xc96c5e96, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x78009900, 0x78009900, 0xb3665bb0, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x0000c100, 0xff008100, 0x23b16a21, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00400020, 0x007fff3f, 0x4bc39d21, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x71e7df02, 0x71e7df02, 0x00000000, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0xfff00600, 0x9ec54cc6, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00010001, 0x0632ff3f, 0x98ad56be, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x01010202, 0x01020403, 0x371bb129, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00ff0000, 0xffaa0000, 0x33c4022f, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0x000104ff, 0xda281adc, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x0401f9e6, 0x0f02e399, 0x4b81eec2, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x000000ff, 0xffff04cf, 0x41c8f006, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000100, 0x000578ff, 0xa7934b3f, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0xe4000102, 0xc7000104, 0x0f3d95a9, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x06c93e00, 0x0c927c00, 0x00785d99, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00007e00, 0x00007e00, 0x1b2347d0, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x02000101, 0x06ff0402, 0xda698eaa, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0xf700001f, 0xdbff007c, 0x75cf352a, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0xf700000a, 0xb955a7e6, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0x00000000, 0xb46ce47c, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x04000202, 0x1e000f10, 0xed948deb, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x0000ff00, 0x09ef9ffe, 0x5b4e52ef, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00040000, 0xff73ff04, 0xe7a5fc7d, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000100, 0x030049ff, 0xdc2991be, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0x00000000, 0x0c8e982b, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0x07090d00, 0x4ff82c0f, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0xfffd0004, 0x12ad99bc, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x04000002, 0x3effff1f, 0x4e8a4e8c, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0xff000000, 0xc0021e07, 0x049f2bae, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0xe0e70c02, 0xc38d562f, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0xff0000ff, 0x8f1c0080, 0xa425a9cf, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0x00000000, 0xe81d3790, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00ff0000, 0x00cc0001, 0x9f2d62a6, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x04000003, 0x7101ff67, 0xe22220b5, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0x00000000, 0x32ab766e, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0xf20500f7, 0x922500b6, 0xe9644183, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0x1e0035ff, 0x502a8edf, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000004, 0x00ffff0e, 0xc76337ba, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00c1ff07, 0x00c1ff07, 0x6b3899d8, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0x00000000, 0x66854f6b, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x01fd0001, 0x1899ff13, 0xa977a60d, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00fe0000, 0x04b60302, 0xd7d19e45, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x01d01c00, 0x029f3700, 0x51bd5929, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x043801db, 0x043801db, 0x1c65f388, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0x0000000e, 0x67925dfe, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x02000000, 0x30ff00ff, 0x79699c05, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x55ff0104, 0x55ff0104, 0x4a05a198, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0xff000000, 0xf8ff0000, 0x7debe48b, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0x1400000f, 0x00be0856, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x010c1892, 0x010c1892, 0x5fb16428, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x01010000, 0x7c781304, 0xdadc334f, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000200, 0xff00600a, 0xb96f1cfe, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0x00ff00ff, 0x8c1d6ddc, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x00000000, 0xf11c0703, 0x3bd612be, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x2d030000, 0x59050000, 0x7b8773e9, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x02fcf500, 0x10e1aaff, 0x14b53d2b, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x04040810, 0x1c1c3e7e, 0x7edfdbbb, 0x0, 0x0
	dspck_dstio shrav_r.qb, 0x02fcf800, 0x18c18300, 0xaa7d35d4, 0x0, 0x0

	writemsg "[33] Test shrl.ph"
	dspck_dtsaio shrl.ph, 0x00000000, 0x00000000, 4, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x0fff0fc5, 0xfff7fc52, 4, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00010000, 0xfb362492, 15, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00001fff, 0x0000fffb, 3, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x000f000c, 0xfffbc71c, 12, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000000, 0x7fff7fff, 15, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00200000, 0x807f0000, 10, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000000, 0x00010001, 3, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x07fe07f8, 0xffceff10, 5, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x001c0001, 0x1c7101a9, 8, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00010000, 0x1c7103fe, 12, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00c70000, 0xc71c0006, 8, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x09241ffd, 0x4924ffe8, 3, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00380038, 0xe38ee00f, 10, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000000, 0x00000000, 10, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x000e0000, 0xe003001f, 12, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x3fc03fe2, 0xff00ff8b, 2, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x03ff0000, 0x7fff0000, 5, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000000, 0x00000000, 9, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00010001, 0xfc01b6db, 15, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x007c0040, 0xf9938000, 9, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x000003ff, 0x00007fff, 5, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x0007007f, 0x07fc7fff, 8, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x001e0100, 0x0f0f8000, 7, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x01ff0000, 0xffaf001f, 7, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00030000, 0xfffe0000, 14, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00010001, 0xfe3f8000, 15, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00010000, 0x7fff1dbb, 14, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00010001, 0x0b5f0ffc, 11, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00ff007f, 0xfff67fff, 8, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x020001ff, 0x80007fff, 6, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00c000ff, 0xc001fffc, 8, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x07ff3ffd, 0x1ffefff6, 2, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x0003001f, 0x007f03fe, 5, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000000, 0x000001a9, 12, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00070000, 0x7fc004b9, 12, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000000, 0x00000000, 3, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x1ffe2000, 0x7ff88000, 2, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x1fff1fff, 0x7fff7fff, 2, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x000003c0, 0x0006f001, 6, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x0030003f, 0xc003fff4, 10, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x60077fff, 0xc00ffffe, 1, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x001c001f, 0xe001ffef, 11, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x07ff0000, 0x7fff0000, 4, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000004, 0x00018002, 13, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000000, 0x00000000, 12, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x007f7fff, 0x007f7fff, 0, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00040000, 0x80000000, 13, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x40003fff, 0x80007fff, 1, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x003f0020, 0xffeb8000, 10, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00031ffc, 0x000d7ff0, 2, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000000, 0x16de0003, 14, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x1c710391, 0x38e30722, 1, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00030000, 0xe38e0000, 14, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x007f0040, 0xffc08000, 9, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x801fcd54, 0x801fcd54, 0, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000000, 0x00000000, 11, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x7fe07f8b, 0xffc0ff17, 1, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x7ff00000, 0xffe00000, 1, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00070003, 0x39dc1fe0, 11, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000000, 0x00000000, 11, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x80000002, 0x80000002, 0, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x008000e1, 0x8000e14a, 8, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000000, 0x00060000, 8, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000018, 0x04ccc001, 11, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000000, 0x00000000, 14, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x1fff0fff, 0xfffd7fff, 3, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000040, 0x000a8000, 9, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x7fff7fff, 0x7fff7fff, 0, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x3ffb3fff, 0xffefffff, 2, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x0fff0000, 0x7fff0000, 3, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x0080007f, 0x80007ff9, 8, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x000003ff, 0x00011ff8, 3, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000007, 0x0356fe0f, 13, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00080007, 0x80007ffc, 12, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000000, 0x00137fc0, 15, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x007f0100, 0x3fe08000, 7, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000000, 0x00000000, 0, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00030000, 0xf00301dc, 14, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000000, 0x00000000, 10, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x02000000, 0x80030000, 6, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x001f6666, 0x003fcccc, 1, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000000, 0x00030003, 10, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x03fa031b, 0xfe8fc6df, 6, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x001b1000, 0x00dc8000, 3, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000000, 0x00000006, 7, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x001f0019, 0x7fff6666, 10, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x007f0000, 0xffe4017a, 9, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000fff, 0x00007fff, 3, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x0010001f, 0x8000fff5, 11, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x35f20001, 0xd7ca0005, 2, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x000f0080, 0x0ffc8003, 8, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x08000000, 0x80040000, 4, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x3fff7d81, 0x7ffffb02, 1, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x03ff07c0, 0x7ffff803, 5, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00070000, 0xfc880075, 13, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x1fff3fff, 0x7ffdfffe, 2, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00070006, 0xffffdb6d, 13, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000001, 0x7fff9249, 15, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00020000, 0x80000001, 14, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00002000, 0x00008000, 2, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00e30012, 0xe38e127f, 8, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000000, 0x3ff00000, 15, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x0000007f, 0x00007ffd, 8, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x000301ff, 0x00fb7fff, 6, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x003f001f, 0xfffa7fff, 10, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x03c30ffe, 0x0f0f3ff8, 2, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000000, 0x00000003, 7, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00010001, 0xf12e801f, 15, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x0000076d, 0x0000edba, 5, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x03ff03fd, 0xffffff5b, 6, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x02490fe9, 0x2492fe9d, 4, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x0000003f, 0x00001ffe, 7, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00040000, 0x80000000, 13, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x01ff0043, 0x1ffe0433, 4, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x0000000f, 0x0000f003, 12, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00020001, 0x92497fc0, 14, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x01ff03ff, 0x7ffffffe, 6, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x03ff0ffe, 0x3ff8ffec, 4, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00010001, 0xfffd8000, 15, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x1fff01ff, 0xfffd0ff8, 3, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00010000, 0x7ffb0000, 14, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x001f0030, 0x7fffc00f, 10, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00030003, 0x7fff7fff, 13, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00010001, 0x800f803f, 15, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x001f0000, 0x7fff0000, 10, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x7fff07fc, 0x7fff07fc, 0, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x07800666, 0xf001cccc, 5, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x007f0000, 0x7ffa0000, 8, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000125, 0x000024ba, 5, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x040003ff, 0x80007ffc, 5, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x0002007f, 0x00b41ffc, 6, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x0fff0000, 0x7ffa0000, 3, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00030001, 0xf0037fff, 14, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x000000e0, 0x0000e01f, 8, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000000, 0x00000000, 10, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x07ff0000, 0xfffc0000, 5, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x0001001f, 0x0d0fffa0, 11, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00ff0000, 0xffff0033, 8, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00020000, 0x80001c71, 14, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x100001e1, 0x80000f0f, 3, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00310000, 0xc71c0000, 10, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x040003ff, 0x80007fff, 5, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000002, 0x00008000, 14, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000040, 0x00808005, 9, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000010, 0x00048000, 11, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x04fd07ff, 0x27ec3ffc, 3, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x0001000f, 0x0fa67f80, 11, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000002, 0x003f8007, 14, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000000, 0x00000000, 4, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00070007, 0x7fff7fff, 12, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x01ff01ff, 0xfffdfffe, 7, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x007f0000, 0xffd80000, 9, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x0000007f, 0x00007fff, 8, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00ff007f, 0x7fff3fc0, 7, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000003, 0x00d3f801, 14, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x1fff0000, 0x7fff0000, 2, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000007, 0x0143f5ce, 13, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00010001, 0xcbe08003, 15, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x1fff0002, 0xfffb0011, 3, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000000, 0x00000000, 2, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x03ff0000, 0xffcc0000, 6, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000000, 0x00000200, 14, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00100003, 0x80001ff0, 11, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000000, 0x000000ff, 15, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x007f003f, 0xfe867fff, 9, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000ffc, 0x00000ffc, 0, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x03e00049, 0xf8011252, 6, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00070000, 0xfffd0003, 13, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x07ff0e00, 0x7fffe007, 4, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000007, 0x001b7fff, 12, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x20003ffa, 0x8000ffea, 2, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x8000cd47, 0x8000cd47, 0, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000000, 0x001b0001, 5, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00030000, 0x0f0f0000, 10, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00030000, 0x7f801ffe, 13, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00070007, 0x1ff01daa, 10, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00100007, 0x80003fc0, 11, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000000, 0x00000000, 11, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000000, 0x00000000, 15, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x000d0000, 0x00d00000, 4, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00020003, 0x8000ffff, 14, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x0fff0000, 0x7fff0000, 3, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00040006, 0x8000c007, 13, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x0c030fff, 0xc03ffffc, 4, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000003, 0x0000ff1b, 14, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x003f0031, 0xfffec71c, 10, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00070004, 0xffd98002, 13, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00fe00ff, 0xfe6eff94, 8, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x020000ff, 0x80043fe0, 6, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000000, 0x00000000, 6, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x3fff3fff, 0x7fff7fff, 1, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00003fff, 0x0000ffff, 2, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x38e35b6d, 0x71c7b6db, 1, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x009d0000, 0x09d70004, 4, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x0aaa0803, 0xaaaa803f, 4, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00080008, 0x803f8007, 12, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000000, 0x00000000, 13, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x78137fff, 0xf027fffe, 1, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x40024000, 0x80058000, 1, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00030000, 0x3ffc0000, 12, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x01ff0049, 0xff802492, 7, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x1ff9000b, 0xffc9005b, 3, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00030000, 0xcccc0041, 14, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x0000001f, 0x0000fe0a, 11, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00010000, 0x80000000, 15, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x0010001f, 0x807ff801, 11, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00008000, 0x00008000, 0, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x0008000f, 0x8000fb96, 12, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x0000000f, 0x0000fef9, 12, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x007f0040, 0xfef68000, 9, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x0fff0001, 0xfffc0013, 4, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00070007, 0xffd9e003, 13, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x0000007f, 0x00067fc0, 8, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000000, 0x00010000, 8, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x1fff3fff, 0x7ffffffc, 2, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x002a003f, 0x55557ffc, 9, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x001f0001, 0xff220ffe, 11, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000000, 0x00480000, 11, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x7fffe003, 0x7fffe003, 0, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00030002, 0xfea18e38, 14, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x008000db, 0x8000db6d, 8, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x01ff01ff, 0xfffefffc, 7, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000002, 0x01538002, 14, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x000f0000, 0x3fc00000, 10, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000001, 0x00000005, 2, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000000, 0x00000000, 7, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x000001c7, 0x0000e38e, 7, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00030000, 0xc71c0000, 14, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x007f0007, 0xffd80e1d, 9, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x0000002d, 0x03feb6db, 10, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x40000000, 0x80000000, 1, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000000, 0x00000000, 15, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x001c0010, 0xe38e8000, 11, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x00000000, 0x00007fff, 15, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x20003ffd, 0x8002fff4, 2, 0x0, 0x0
	dspck_dtsaio shrl.ph, 0x07ff0003, 0x7fff0033, 4, 0x0, 0x0

	writemsg "[34] Test shrlv.ph"
	dspck_dstio shrlv.ph, 0x80001ffe, 0x80001ffe, 0x00000000, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00070001, 0xfff53333, 0x3815c9ad, 0x0, 0x0
	dspck_dstio shrlv.ph, 0xfffdff23, 0xfffdff23, 0x4e836a20, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x001b001f, 0xdb6dffff, 0x66d24b3b, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000000, 0x00000005, 0x2059cb19, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x001f001f, 0xfffcfff9, 0x1138d8db, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00040000, 0x80001ffe, 0x0c5ccedd, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x0feb0000, 0xfeb80000, 0xdcdf6034, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000010, 0x00048000, 0x59fd687b, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00030012, 0x06b22492, 0x448c9f49, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x01e00000, 0xf00e0000, 0x31bba6f7, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x000007ff, 0x0000fff4, 0x025a9815, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00001ffc, 0x0002ffe5, 0x4ac0b643, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x7e003ff0, 0xfc017fe0, 0x086f9ee1, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x01720150, 0x5ca35416, 0x5ca35416, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x03f303f0, 0xfceefc01, 0xd5e8b646, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x0000007f, 0x00187fff, 0x18318df8, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000001, 0x3ffc7fff, 0xaece87fe, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x07f807fe, 0xff0effdd, 0x38b51875, 0x0, 0x0
	dspck_dstio shrlv.ph, 0xfd7f3333, 0xfd7f3333, 0x89feb4d0, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00ff07ff, 0x0ffe7fff, 0x8003d454, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x000f0007, 0xfffd7ffa, 0x5b427c2c, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000000, 0x00000000, 0xab0ee5b0, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x0008000f, 0x8005ffff, 0x13be73ac, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000001, 0x1ffc7fff, 0xb05e134e, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000020, 0x00008000, 0x51ecdcaa, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00ff0000, 0x7fff0000, 0x58d7fab7, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x000f000f, 0xfff6ffff, 0xc4d9c01c, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000000, 0x00000000, 0x0b813c8a, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000078, 0x000bf007, 0x401a8529, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x0008000c, 0x8000c853, 0x389594dc, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x07ff0800, 0x7fff8000, 0x13e88bf4, 0x0, 0x0
	dspck_dstio shrlv.ph, 0xfff51fe0, 0xfff51fe0, 0x00000000, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00e00000, 0xe0010000, 0xe9cc1168, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x01000000, 0x80000000, 0x380e6e67, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x000f0010, 0x7fff8000, 0x0315280b, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x020003ff, 0x8000fffd, 0x0c532bb6, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000000, 0x00000000, 0x15290b12, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x003300da, 0x066e1b59, 0xb482d2d5, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x003f001f, 0xff897fff, 0x62064a7a, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000000, 0x03fe0006, 0xfcfd57fe, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000000, 0x00000004, 0xd3fe9f73, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000000, 0x00000000, 0x309a1fc6, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x0003007d, 0x07fcfb58, 0xcbab8f29, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x001d0011, 0x0758046f, 0xe1bf1846, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000003, 0x3fc0e00f, 0x395a470e, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x03fef007, 0x03fef007, 0x00000000, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000000, 0x00000000, 0xbf14b400, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x11260024, 0x11260024, 0x00000000, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000001, 0x5136fa9f, 0x5136fa9f, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x003f0040, 0x7fff8000, 0xe0e04679, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000100, 0x00018000, 0x6b0ee687, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x007f0000, 0xff8c0004, 0x20a06ac9, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00040000, 0x80000000, 0x90f923bd, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x07ed0000, 0xfdbf0002, 0xf4a97d05, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x0ffc3e00, 0x3ff0f801, 0x4844d9e2, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x003f0000, 0x7ffd0000, 0x04ddd8c9, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x000001ff, 0x0000ffff, 0xf1dd3c57, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000010, 0x035b801f, 0xa52c2fbb, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000000, 0x00000000, 0xd0be099e, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x07fc0400, 0xff808000, 0x0ddbf085, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x000000fc, 0x0000fc36, 0xae6c51c8, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x07ff03ff, 0xfffd7fff, 0x43189025, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000000, 0x7fff0000, 0xa679b7ff, 0x0, 0x0
	dspck_dstio shrlv.ph, 0xfffcfc09, 0xfffcfc09, 0x00000000, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00010000, 0x3ff01ffc, 0xe10483ad, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x0000078e, 0x0002f1de, 0x83c9bed5, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x1fff2000, 0x7fff8000, 0x17e071b2, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000057, 0x0000015d, 0x5b2d1752, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x0000e007, 0x0000e007, 0x00000000, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x001f00cc, 0x1fe0cccc, 0x04795338, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00010002, 0x553ab1ae, 0x553ab1ae, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x64484000, 0xc8918000, 0x62fa20e1, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00ff007f, 0xfff07ff9, 0xfc5faa38, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x0fff0000, 0xfff10000, 0x1b365e04, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x1fff0fff, 0xfffa7fff, 0xac8b8483, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000000, 0x00000000, 0xb47e2a1a, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000000, 0x00001ff0, 0xd64022ae, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x02000000, 0x80040000, 0x5f307386, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00010000, 0x01880000, 0x4475b3b8, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x001f0000, 0xfffe007f, 0xfc18fe2b, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x07ff0fff, 0x7ffffffc, 0x5944b7c4, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x40003ffd, 0x80007ffb, 0x669ee441, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x3fe91fff, 0xffa47fff, 0x94583a12, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000000, 0x003f019b, 0x422f026c, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x40007fee, 0x8000ffdc, 0xf91dab61, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x000003ff, 0x0001ffe9, 0x554897a6, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000000, 0x00000000, 0x37b91bab, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x012403ff, 0x24927fff, 0xb726d8f5, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00020000, 0x10350763, 0x83b1f64b, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000000, 0x00000000, 0x9487082f, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x01c70003, 0x38e3007f, 0x71bba4b5, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x3fe40090, 0xff910243, 0xbe658982, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x0000dde1, 0x0000dde1, 0x00000000, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000000, 0x7fff0000, 0x55f4898f, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x80000994, 0x80000994, 0x7901da20, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x020001ff, 0x80007fff, 0xc4c25336, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x000003ff, 0x0020fffd, 0xa7d861f6, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000000, 0x00000000, 0x4c29ed09, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000004, 0x01e18000, 0x2ce1bb0d, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000000, 0x00000000, 0x4f17250a, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x000001fe, 0x0006ff3d, 0x3948b837, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000010, 0x00008003, 0x152f5f7b, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x07ff1fff, 0x1ffe7fff, 0x5fa8e602, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x000103ff, 0x00277ff9, 0x4c2af275, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x003f0015, 0xffff5555, 0x3460057a, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000001, 0x00007fff, 0x0e7615de, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x007f0000, 0x7ff80000, 0x2c0f8e08, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000020, 0x00008000, 0x97f23f7a, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00010003, 0x3ffc7fff, 0xedb171cd, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000000, 0x00000000, 0x467096da, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00141f67, 0x00a1fb3a, 0xa78af053, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x0e7b0c00, 0xe7b9c003, 0xd30ef944, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00003c01, 0x0000f007, 0x8302e082, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00e00006, 0xe00f06b2, 0xee95bd18, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00ff0000, 0x1ffe0002, 0x13514835, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x1fff0fff, 0xfffd7fff, 0xd54e95d3, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x003f003f, 0xfffefff2, 0xcc87c3fa, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000000, 0x00040295, 0x2c42599b, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00c41fff, 0x03137fff, 0x6104a862, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x6db60000, 0x6db60000, 0x709b11e0, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x003f003f, 0xfff8fff9, 0x545450da, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000000, 0x007f0002, 0x7fcd7e6d, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00030000, 0x7fff0017, 0x0e08407d, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00030000, 0x33330000, 0xc182ac2c, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00230020, 0x8e388000, 0x30dda44a, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000001, 0x7fffb6db, 0x1b9a83af, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x0000000d, 0x0000d967, 0x6d9aaa6c, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x199901e1, 0xcccc0f0f, 0x3a5318a3, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x0fe200b6, 0xfe2b0b62, 0xa216cf74, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x001c007f, 0x38e3ff81, 0x4858edf9, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000000, 0x07fe01cb, 0xc81e90cc, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00010000, 0xfc01014a, 0x30b7f88f, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x0003001f, 0x0c887ff8, 0x1f97133a, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x80007fff, 0x80007fff, 0xc9295bb0, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x008000e0, 0x8000e01f, 0xbbbe9e68, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x0060007f, 0xc01ffff8, 0xc7cdbda9, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x07fd03ff, 0xffa97fff, 0x3cdb6085, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x007f0000, 0xffc00000, 0xf33401a9, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000001, 0x0000ffef, 0x91a9c83f, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00200000, 0x80000000, 0xcbad4e0a, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x1fff000d, 0x7fff0036, 0x111e2072, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x1c713fee, 0x71c7ffb9, 0x4b998f22, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x020003e0, 0x8000f803, 0xf24f4c36, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x000000ff, 0x001fff6b, 0xdaa71b18, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x0000003f, 0x0238ffe0, 0x3c15b6fa, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00010001, 0x80008000, 0x7838256f, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000800, 0x00008000, 0xf4ab3504, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000000, 0x0000004f, 0x6dfdcfbd, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x1ff81ff8, 0x1ff81ff8, 0x74dced40, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00710180, 0x38e3c01f, 0x09804e37, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x05768000, 0x05768000, 0x26707240, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000000, 0x00000000, 0x49a3e60a, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x0000018c, 0x00000632, 0x2fb9cec2, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x2000000d, 0x80030035, 0xabe958c2, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x0001001c, 0x0ffee38e, 0xeb2b266b, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000200, 0x00008000, 0xc22b8f96, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00070000, 0xfffc0005, 0x1ae8fc8d, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000000, 0x00000000, 0xf0e98239, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x0975000a, 0x0975000a, 0x00000000, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000000, 0x00000007, 0x348f0396, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00010003, 0x7fffff7d, 0x198aecce, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x0fff0fff, 0x7fff7fff, 0x598e8ed3, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000000, 0x00000000, 0xfdda32a8, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x03f90000, 0xfe6c0002, 0xc8ba2496, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x000c07fe, 0x0189ffd2, 0xb6ef89c5, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x1fff2000, 0x7fff8000, 0x52fbcdd2, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000000, 0x000000f1, 0x77db9978, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x3ff82000, 0xffe08000, 0x142abe02, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x010001ff, 0x8003fffd, 0x8d576df7, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x0100001f, 0x80000ffe, 0x5c205077, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x40004000, 0x80008000, 0x6cd7dad1, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00070000, 0xfff8000a, 0x5a20231d, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x000007ff, 0x0000fffe, 0x97dc1bc5, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x000007ff, 0x0004ffff, 0x5882b3f5, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00ff0000, 0xff80003f, 0x7706d078, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000020, 0x00008000, 0x3db5290a, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000db6, 0x0000db6d, 0xb989b284, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x0000001f, 0x0000fff8, 0xa2f67c7b, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x03ff03ff, 0xfffeffff, 0x80fafaf6, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x080007ff, 0x80007fff, 0xeddc0bc4, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x0c000f0f, 0xc001f0f0, 0x26fda924, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000001, 0x00008000, 0xfdb7deef, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x040007af, 0x8000f5fd, 0x0c5110f5, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x03e00000, 0xf8010007, 0xdb1bbfa6, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00010002, 0x7fff8000, 0x89b8da4e, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x007f0000, 0xfffe0006, 0xb248ae79, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00030000, 0x7ff800f9, 0xccad0f4d, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00080000, 0x80000000, 0x08bc2f7c, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x001f0010, 0xff008000, 0x0d060f8b, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x008000ff, 0x8000fffd, 0x1101b038, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x000001ff, 0x0000ff80, 0x2b8d6dc7, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x007b3ff0, 0x007b3ff0, 0x00000000, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x17f3125e, 0xbf9d92f3, 0xbf9d92f3, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00010001, 0xf803fff4, 0x9347887f, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x07ff0fc2, 0x7ffffc2b, 0x7fd4b604, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x3fff7f9b, 0x7fffff37, 0xd1837a51, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x008c00ce, 0x8c30ce18, 0x8c30ce18, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00010001, 0xffdafdc0, 0x19e15c9f, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x049600fe, 0x92c21fc5, 0x92c21fc5, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000004, 0x00008003, 0x01b37bbd, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000c71, 0x0000c71c, 0x3ab39334, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x000f0007, 0xfaff7fff, 0xedf43a8c, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x000707ff, 0x00717ffc, 0x1460b684, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00020003, 0x9999c003, 0x2c980d8e, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00001ff4, 0x0000ffa6, 0x7267cb13, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x000f0008, 0xf8018005, 0x9ff74a2c, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00010000, 0xf0f07f80, 0x2242505f, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x3fff0003, 0xffff000f, 0xda1c89a2, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x000001e0, 0x0008f007, 0x00ae2c77, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x007f01ff, 0x3ffcfff7, 0x8ee68f87, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x08000016, 0x80000166, 0x07499164, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000000, 0x00000000, 0xfc0ee4ec, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x0000001f, 0x0000fff0, 0x04b633fb, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000008, 0x00008000, 0x15c0274c, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x7ffd7ffd, 0xfffafffa, 0x7337d061, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00200015, 0x807f5555, 0xdfbea0da, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x400377d2, 0x8006efa4, 0x31220071, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x0c710000, 0xc71c000e, 0x9c1ec864, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x001f001f, 0xfca5ffb4, 0x9373ddcb, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x03ff003c, 0xfffe0f36, 0x78d15b96, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00030003, 0xe01ffffe, 0xa4e9f9de, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000000, 0x00007fff, 0xe040783f, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000003, 0x00003ffe, 0xf76b2d5c, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x003f0000, 0xfffe000d, 0x319bb95a, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x000f0008, 0xffff8000, 0xafd2ac4c, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x0000007f, 0x00fffffd, 0x9f497189, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00010000, 0x80000000, 0x61e03e6f, 0x0, 0x0
	dspck_dstio shrlv.ph, 0xb6db0000, 0xb6db0000, 0x00000000, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00800000, 0x807f0000, 0x48557c78, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x3fff0000, 0x7fff0000, 0x0e4da731, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00800000, 0x80060001, 0x85f65858, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000f80, 0x0009f801, 0xc3fcd024, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x00000003, 0x0000fffb, 0x5830059e, 0x0, 0x0
	dspck_dstio shrlv.ph, 0x0000000a, 0x00000154, 0xc719a275, 0x0, 0x0

	writemsg "[35] Test subu.ph"
	dspck_dstio subu.ph, 0x0f47f8f0, 0x003700ec, 0xf0f007fc, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x8043fffb, 0x7ffffffb, 0xffbc0000, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0xff847100, 0xff8b8004, 0x00070f04, 0x00000000, 0x00000000
	dspck_dstio subu.ph, 0x7f818152, 0x80008000, 0x007ffeae, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x02774000, 0x02753ffe, 0xfffefffe, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x00b6e004, 0x00b50000, 0xffff1ffc, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0xffa7f8ee, 0xffe3f8ec, 0x003cfffe, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0xffce0ff7, 0xffce0ff8, 0x00000001, 0x00000000, 0x00000000
	dspck_dstio subu.ph, 0x0003ffc6, 0x0000ffca, 0xfffd0004, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x3fe03ffe, 0x3fe03ffe, 0x00000000, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x0076034c, 0x0076034c, 0x00000000, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x0001f7c2, 0x8000f801, 0x7fff003f, 0x00000000, 0x00000000
	dspck_dstio subu.ph, 0x7fff0165, 0x7fff0164, 0x0000ffff, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x815d8004, 0x7fff8000, 0xfea2fffc, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0xfffc4036, 0x7ff97fc0, 0x7ffd3f8a, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x14dc0001, 0xfffb8000, 0xeb1f7fff, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0xc0204ccd, 0xc0018000, 0xffe13333, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x3990ce2b, 0x3a89cccc, 0x00f9fea1, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x800301b5, 0x000201b5, 0x7fff0000, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x000dfffa, 0xfffefffa, 0xfff10000, 0x00000000, 0x00000000
	dspck_dstio subu.ph, 0x7ff92b49, 0x80000f0f, 0x0007e3c6, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x092b4ccd, 0xcf638000, 0xc6383333, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x8e2f55d5, 0xfff6007f, 0x71c7aaaa, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0xffe3ef13, 0xffe3e003, 0x0000f0f0, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x80058000, 0x00000000, 0x7ffb8000, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x00000002, 0x00000002, 0x00000000, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x08818fff, 0x00010ffe, 0xf7807fff, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0xb33303ae, 0x3333033f, 0x8000ff91, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x00000000, 0x0015c003, 0x0015c003, 0x00000000, 0x00000000
	dspck_dstio subu.ph, 0x0f7fff00, 0x0ffeff00, 0x007f0000, 0x00000000, 0x00000000
	dspck_dstio subu.ph, 0x87fd0000, 0x07fc0000, 0x7fff0000, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x7ff8e869, 0x7ffff003, 0x0007079a, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x0008471d, 0x80078000, 0x7fff38e3, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x800c0003, 0x7ffffffb, 0xfff3fff8, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x8012878e, 0x000c8004, 0x7ffaf876, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x1ffe8000, 0x1ffe8000, 0x00000000, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0xe38bf6bf, 0xe38efe19, 0x0003075a, 0x00000000, 0x00000000
	dspck_dstio subu.ph, 0x80017fff, 0x00007fff, 0x7fff0000, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0xffb1666a, 0xffe70003, 0x00369999, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x0000800f, 0x8000000f, 0x80008000, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x106c7fd7, 0x02c97fff, 0xf25d0028, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x7003c004, 0xf0030000, 0x80003ffc, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0xfff98000, 0x7ff87fff, 0x7fffffff, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x07fe72ff, 0x07fcf33e, 0xfffe803f, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x80018001, 0x00000000, 0x7fff7fff, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x0000ff88, 0x7fffff85, 0x7ffffffd, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0xc7198021, 0xc71c0020, 0x00037fff, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0xfa9a1c72, 0xfa9ae38e, 0x0000c71c, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x00eaffef, 0x0000ffee, 0xff16ffff, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x70eb0004, 0x7ffa8004, 0x0f0f8000, 0x00000000, 0x00000000
	dspck_dstio subu.ph, 0xfff9ff39, 0xfffaff39, 0x00010000, 0x00000000, 0x00000000
	dspck_dstio subu.ph, 0x00000001, 0x00000000, 0x0000ffff, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x3ffeffcb, 0x3ffeffcb, 0x00000000, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x00008001, 0x7fff0000, 0x7fff7fff, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x80003f79, 0x7fff3ff8, 0xffff007f, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x3b9dfc01, 0x1bbcfc01, 0xe01f0000, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x8038fff5, 0x0037fff1, 0x7ffffffc, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x0046fff3, 0x0000fff6, 0xffba0003, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x7ffffe83, 0xfffffe83, 0x80000000, 0x00000000, 0x00000000
	dspck_dstio subu.ph, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000
	dspck_dstio subu.ph, 0x7f687ff9, 0xff687fff, 0x80000006, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x10cfafe8, 0x00002fef, 0xef318007, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x8001e38d, 0x0000e38e, 0x7fff0001, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x8075f5ca, 0x00790000, 0x80040a36, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0xff55d546, 0xff525555, 0xfffd800f, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x80030fff, 0x7fff0006, 0xfffcf007, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x5b757ffc, 0x80070000, 0x24928004, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0xd5508002, 0x55550001, 0x80057fff, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0xfffbfffd, 0x00000000, 0x00050003, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0xffff0001, 0xffff8000, 0x00007fff, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0xc002f839, 0x0000f841, 0x3ffe0008, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0xfffc0045, 0x0000003f, 0x0004fffa, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x00710001, 0xfffe8000, 0xff8d7fff, 0x00000000, 0x00000000
	dspck_dstio subu.ph, 0x80088d72, 0x00008e38, 0x7ff800c6, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0xfffd0001, 0xfffd8000, 0x00007fff, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x0ffb849c, 0x0ffc051b, 0x0001807f, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x80070004, 0x80007fff, 0xfff97ffb, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0xfe1e0808, 0xfe1b00c7, 0xfffdf8bf, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0xed7cfa6d, 0xedbbfa33, 0x003fffc6, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x00808001, 0x00000000, 0xff807fff, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0xfffd0959, 0x7ffd03fe, 0x8000faa5, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0xe0017269, 0xffff9249, 0x1ffe1fe0, 0x00000000, 0x00000000
	dspck_dstio subu.ph, 0xb42bffaf, 0xf41bffbd, 0x3ff0000e, 0x00000000, 0x00000000
	dspck_dstio subu.ph, 0x3fe187af, 0x00007ff0, 0xc01ff841, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x0000ffd8, 0x0000ffd6, 0x0000fffe, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0xe0027ff0, 0x0000ffef, 0x1ffe7fff, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0xf0090000, 0x00050000, 0x0ffc0000, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x000d1289, 0x00020359, 0xfff5f0d0, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x80060005, 0x80078004, 0x00017fff, 0x00000000, 0x00000000
	dspck_dstio subu.ph, 0x00000000, 0x275d7fff, 0x275d7fff, 0x00000000, 0x00000000
	dspck_dstio subu.ph, 0x7ff5ffc0, 0x80007fff, 0x000b803f, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x7a0b5556, 0xfa0b0000, 0x8000aaaa, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x00008002, 0x80008000, 0x8000fffe, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x00000000, 0xc00ffff1, 0xc00ffff1, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x800136db, 0x0000b6db, 0x7fff8000, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0xfffa0000, 0x1ff88000, 0x1ffe8000, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x80010003, 0x00000000, 0x7ffffffd, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x7ffa8002, 0xfff90001, 0x7fff7fff, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x00000000, 0xffcf0007, 0xffcf0007, 0x00000000, 0x00000000
	dspck_dstio subu.ph, 0xffd43fc1, 0x00020000, 0x002ec03f, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x45598000, 0xf0030000, 0xaaaa8000, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x8004ff4c, 0x00040000, 0x800000b4, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x36dc8ffc, 0xb6db0ffc, 0x7fff8000, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x0000b1a8, 0x00003fe0, 0x00008e38, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0xbfc176eb, 0x3fc0b6db, 0x7fff3ff0, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x7ff58e40, 0x80000007, 0x000b71c7, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x00000000, 0x7fff0007, 0x7fff0007, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x8a5d55d5, 0x0a5d007f, 0x8000aaaa, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x80027ff9, 0x00010000, 0x7fff8007, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x7faefffc, 0x80007fff, 0x00528003, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0xe0127fff, 0x00028000, 0x1ff00001, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x7ffefef2, 0x7ffe0000, 0x0000010e, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0xfc00e980, 0xfc01ffff, 0x0001167f, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x00637804, 0x0063f803, 0x00007fff, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x554fffe1, 0xfff90000, 0xaaaa001f, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x00788008, 0x00000000, 0xff887ff8, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x00000000, 0x7fff0000, 0x7fff0000, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x00087ffb, 0x8000fffa, 0x7ff87fff, 0x00000000, 0x00000000
	dspck_dstio subu.ph, 0xfcbe8040, 0x00000045, 0x03428005, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x0006f0f0, 0x0005f0f0, 0xffff0000, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x0080e007, 0x0000e007, 0xff800000, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x7ffb0406, 0xfffa0007, 0x7ffffc01, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0xa4b2ffff, 0x2492ffff, 0x7fe00000, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0xb8e36010, 0x7fff8000, 0xc71c1ff0, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x005c7fff, 0x03767fff, 0x031a0000, 0x00000000, 0x00000000
	dspck_dstio subu.ph, 0xfffb2492, 0x00002492, 0x00050000, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x00000000, 0x71c77fff, 0x71c77fff, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x60038000, 0x7fff0000, 0x1ffc8000, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x4ac4fe24, 0x0ae3fe25, 0xc01f0001, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x00007ffc, 0x7ffffffc, 0x7fff8000, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x80000005, 0x00000007, 0x80000002, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x7ff507fe, 0x7fff0001, 0x000af803, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x7ff9dc91, 0xfff9c01f, 0x8000e38e, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0xf73f0082, 0xfa37007d, 0x02f8fffb, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x00008381, 0x80008000, 0x8000fc7f, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x03fffff0, 0x0000ffff, 0xfc01000f, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x12518000, 0x92490000, 0x7ff88000, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x1fe0ffc9, 0x1fe0ffcc, 0x00000003, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0xe0091ffc, 0x00011ffc, 0x1ff80000, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x0ff98000, 0xfffc0000, 0xf0038000, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x801f4040, 0x800f8000, 0xfff03fc0, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x3fe37fc5, 0x3ff07fff, 0x000d003a, 0x00000000, 0x00000000
	dspck_dstio subu.ph, 0x7ffb0002, 0xfffb0002, 0x80000000, 0x00000000, 0x00000000
	dspck_dstio subu.ph, 0xf8fefffa, 0xf8fe7fff, 0x00008005, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x333453d4, 0x0000d3db, 0xcccc8007, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x6658fffe, 0xfff1fffe, 0x99990000, 0x00000000, 0x00000000
	dspck_dstio subu.ph, 0x7ffc8042, 0xfffc0041, 0x80007fff, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x1f9c81c4, 0xffbb01c3, 0xe01f7fff, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000
	dspck_dstio subu.ph, 0x7fa07ff9, 0x7fff8003, 0x005f000a, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x7ffa70f0, 0xfff97fff, 0x7fff0f0f, 0x00000000, 0x00000000
	dspck_dstio subu.ph, 0x7f4bff03, 0xffcafffa, 0x807f00f7, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x00007ffa, 0x00008000, 0x00000006, 0x00000000, 0x00000000
	dspck_dstio subu.ph, 0x7ffcf884, 0xfffcf884, 0x80000000, 0x00000000, 0x00000000
	dspck_dstio subu.ph, 0x8002fffd, 0x7fff7ffc, 0xfffd7fff, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x707203ff, 0xf0720000, 0x8000fc01, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x8000000d, 0x00000000, 0x8000fff3, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x4010f1c5, 0x80007ffd, 0x3ff08e38, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x7ffac003, 0x7ffaffff, 0x00003ffc, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x00e0d392, 0x00fff003, 0x001f1c71, 0x00000000, 0x00000000
	dspck_dstio subu.ph, 0x00008001, 0x80008000, 0x8000ffff, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0xb6dc8003, 0x00008000, 0x4924fffd, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x800ffff9, 0x000afff9, 0x7ffb0000, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0xb8e3ffb7, 0x7ffffff6, 0xc71c003f, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x800704de, 0x800704de, 0x00000000, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0xfff87bd3, 0xfff57fe0, 0xfffd040d, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x00018020, 0x8000001f, 0x7fff7fff, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x7ff9fff8, 0x7ff8fffe, 0xffff0006, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x7fa273cb, 0x7fc0f3cb, 0x001e8000, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x00000000, 0x15632492, 0x15632492, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x1ff25fc1, 0x1ff83fe0, 0x0006e01f, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x0f13bcf1, 0x00001246, 0xf0ed5555, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x5556fe11, 0x0000fa71, 0xaaaafc60, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0xc0070a19, 0xc007006d, 0x0000f654, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x80023fe4, 0x80003fe0, 0xfffefffc, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x7ffd7fae, 0xffffffad, 0x80027fff, 0x00000000, 0x00000000
	dspck_dstio subu.ph, 0xfffa7c02, 0xfffa8000, 0x000003fe, 0x00000000, 0x00000000
	dspck_dstio subu.ph, 0x4dbaffff, 0xe003ffff, 0x92490000, 0x00000000, 0x00000000
	dspck_dstio subu.ph, 0x062effff, 0x00037fff, 0xf9d58000, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0xa0017c21, 0x1ffcfc01, 0x7ffb7fe0, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x8024ffff, 0x00237fff, 0x7fff8000, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x2000f985, 0x3ff0fc01, 0x1ff0027c, 0x00000000, 0x00000000
	dspck_dstio subu.ph, 0x7d7683ff, 0xfd6f03fe, 0x7ff97fff, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0xd556e351, 0x5555e38e, 0x7fff003d, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x8163cccc, 0x0163cccc, 0x80000000, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0xff99ffde, 0xff8afffb, 0xfff1001d, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0xfdd93ff5, 0x00001ffc, 0x0227e007, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x0000dffa, 0x00001ff8, 0x00003ffe, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x07fba413, 0xfffc7f80, 0xf801db6d, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x8ffcb9ba, 0x8003aaaa, 0xf007f0f0, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x7ff39ffc, 0xfff27fff, 0x7fffe003, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0xfffa0f0f, 0xfffa0f0f, 0x00000000, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x00e6fffe, 0x00000000, 0xff1a0002, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x07ff01c1, 0x07feffe0, 0xfffffe1f, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0xf0038006, 0xf0037fff, 0x0000fff9, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0xfffce020, 0x00000000, 0x00041fe0, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x00058001, 0x7fff0000, 0x7ffa7fff, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x3ff1ff83, 0x0000ff82, 0xc00fffff, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0xff748001, 0xfff30000, 0x007f7fff, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x0248fffe, 0x0248fffe, 0x00000000, 0x00000000, 0x00000000
	dspck_dstio subu.ph, 0x0f0fdb31, 0xffffdb6d, 0xf0f0003c, 0x00000000, 0x00000000
	dspck_dstio subu.ph, 0xc00f8003, 0xc00f8003, 0x00000000, 0x00000000, 0x00000000
	dspck_dstio subu.ph, 0xe2afc022, 0xfffbc01f, 0x1d4cfffd, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x00000000, 0x7ffb8000, 0x7ffb8000, 0x00000000, 0x00000000
	dspck_dstio subu.ph, 0x3ff88005, 0x3ff80000, 0x00007ffb, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x49480ffc, 0x49240ffc, 0xffdc0000, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0xff817fd2, 0x8000ffd1, 0x807f7fff, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x796c8086, 0xf96b807f, 0x7ffffff9, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0xf8018001, 0xf8010000, 0x00007fff, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0xdff6fc38, 0xe00f0000, 0x001903c8, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x8020065a, 0x8000ff39, 0xffe0f8df, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x803f0f78, 0x003f07fc, 0x8000f884, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0xdb6e0003, 0x00000000, 0x2492fffd, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x0ff00029, 0x0ff00029, 0x00000000, 0x00000000, 0x00000000
	dspck_dstio subu.ph, 0xfa747fb8, 0x001cffb7, 0x05a87fff, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x9ff67ff4, 0x7ff9fff4, 0xe0038000, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x7ff30000, 0x7fff7fff, 0x000c7fff, 0x00000000, 0x00000000
	dspck_dstio subu.ph, 0x1fbd8000, 0xffc08000, 0xe0030000, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x00000e12, 0x00000e12, 0x00000000, 0x00000000, 0x00000000
	dspck_dstio subu.ph, 0x7f8a8001, 0x80000000, 0x00767fff, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x80231ffc, 0x00231ffc, 0x80000000, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x81bffd18, 0x01bf003f, 0x80000327, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x8f0f333d, 0x7fff0009, 0xf0f0cccc, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x0070802a, 0x00728003, 0x0002ffd9, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x40020001, 0x3ffe8000, 0xfffc7fff, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x0000f803, 0x0000f803, 0x00000000, 0x00000000, 0x00000000
	dspck_dstio subu.ph, 0xffee0001, 0xfffe8000, 0x00107fff, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x9249801b, 0x92490017, 0x00007ffc, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x7ffb0e0f, 0x7fff0000, 0x0004f1f1, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x81210f0f, 0x01210f0f, 0x80000000, 0x00000000, 0x00100000
	dspck_dstio subu.ph, 0x8001f989, 0x8000f989, 0xffff0000, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x87ff7fb3, 0x07fefff2, 0x7fff803f, 0x00100000, 0x00100000
	dspck_dstio subu.ph, 0x60078005, 0xe007fffd, 0x80007ff8, 0x00000000, 0x00000000
	dspck_dstio subu.ph, 0x87fea534, 0x7fff2534, 0xf8018000, 0x00100000, 0x00100000

	writemsg "[36] Test subu_s.ph"
	dspck_dstio subu_s.ph, 0x4008019c, 0x8000019c, 0x3ff80000, 0x00000000, 0x00000000
	dspck_dstio subu_s.ph, 0x00007f50, 0x00008000, 0x000100b0, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x7fedaaaa, 0xffe6ffff, 0x7ff95555, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x00000981, 0x0019fffa, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x60010000, 0xe003f3f1, 0x8002ffff, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x71330023, 0x7f800023, 0x0e4d0000, 0x00000000, 0x00000000
	dspck_dstio subu_s.ph, 0x7ffe8000, 0x80008000, 0x00020000, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x7fabf071, 0x7fffff80, 0x00540f0f, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x0000010f, 0x0001010f, 0xffe30000, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x7fff8003, 0x7ffffffd, 0x00007ffa, 0x00000000, 0x00000000
	dspck_dstio subu_s.ph, 0x0000403f, 0x7fc0c03f, 0xfffc8000, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x1cdf1ff8, 0x7fff7fff, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x471d01fd, 0x8000fffe, 0x38e3fe01, 0x00000000, 0x00000000
	dspck_dstio subu_s.ph, 0x00000000, 0x3ff00ff8, 0xe0017fc0, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00030031, 0x00050037, 0x00020006, 0x00000000, 0x00000000
	dspck_dstio subu_s.ph, 0x0ff90000, 0xfffa0000, 0xf0017ff8, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x00000000, 0x807f000f, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x0000fff7, 0x03fafff9, 0x80030002, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0xda050000, 0xdb6d0000, 0x01680000, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x3fff0000, 0x7ffb0103, 0x3ffc9999, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x7c740001, 0x7fff8000, 0x038b7fff, 0x00000000, 0x00000000
	dspck_dstio subu_s.ph, 0x00000000, 0x00000000, 0x1ffe7ffa, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00007fbf, 0x7fc07ffe, 0xf0f0003f, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00007ff9, 0x7ff9fff9, 0x80078000, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x7ffd0000, 0x80003ffc, 0x0003fbaa, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0xffc70001, 0xffc78000, 0x00007fff, 0x00000000, 0x00000000
	dspck_dstio subu_s.ph, 0xa0030ff8, 0xe0010ff8, 0x3ffe0000, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00008b6e, 0x0000fd35, 0x000071c7, 0x00000000, 0x00000000
	dspck_dstio subu_s.ph, 0x00000000, 0x00000cde, 0x80018000, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x00000019, 0xff678000, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x00003ffe, 0x00053ffe, 0xff000000, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x3ff90001, 0xfffa8000, 0xc0017fff, 0x00000000, 0x00000000
	dspck_dstio subu_s.ph, 0xdffdd110, 0xfff9e01f, 0x1ffc0f0f, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x7ffc0000, 0xfffc0245, 0x8000ffc5, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000008, 0x0000ffe8, 0x3ffeffe0, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x0000e38e, 0x7ffcffff, 0x807f1c71, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x0000fbdf, 0x8000fffc, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x0006fbc8, 0x8005fffc, 0x7fff0434, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x0000f801, 0x0000f801, 0x80000000, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x06fd18e5, 0x070338e3, 0x00061ffe, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x800001ce, 0x80008000, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x000721a9, 0xfed1b6db, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x7fff0000, 0x7fff0000, 0x00000000, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x49238000, 0x4924ffff, 0x00017fff, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00007ffb, 0x66668000, 0xe0070005, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0xffbaf752, 0xfffffffb, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x000000ff, 0xffc08000, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x07fc0000, 0x07fc07fc, 0x0000fffe, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x00006b3a, 0xf7817fff, 0xfd7a14c5, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x00003ff0, 0x07feffff, 0x7fffc00f, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x0000ffdb, 0x7fffffdb, 0x803f0000, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x00007fff, 0x0028fe2a, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x2fe40000, 0xf0030005, 0xc01f007f, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0xdfa30128, 0xff9b0128, 0x1ff80000, 0x00000000, 0x00000000
	dspck_dstio subu_s.ph, 0x00000000, 0x00000000, 0x7ffa0000, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x638fc003, 0x8000c003, 0x1c710000, 0x00000000, 0x00000000
	dspck_dstio subu_s.ph, 0x00007fff, 0x00007fff, 0xffc50000, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x36dc0000, 0xb6db7fff, 0x7fff7fff, 0x00000000, 0x00000000
	dspck_dstio subu_s.ph, 0x00000000, 0x00018000, 0x8000fffc, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x0000ff6b, 0x0000ff6b, 0x80050000, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0xeeeb0000, 0xeeeb38e3, 0x0000ffdb, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000001, 0x007e8000, 0x1ff87fff, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x0003638e, 0x7fff7fff, 0x7ffc1c71, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x3fe80000, 0xc0070000, 0x801f7fff, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x14340000, 0xffff0000, 0xebcbfffe, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0xff290000, 0xff2d0000, 0x0004e01f, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x80000005, 0xffff7fff, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x036103fe, 0x03fe03fe, 0x009d0000, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x6666f007, 0xfffffffc, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x0000807f, 0x0000807f, 0x00000000, 0x00000000, 0x00000000
	dspck_dstio subu_s.ph, 0x00000000, 0x00007fff, 0x00008000, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x09880000, 0x09888000, 0x00008000, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x7fff0000, 0x80001e0a, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x00000000, 0x00050ff8, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x00040000, 0x00090000, 0x00058000, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x001f0000, 0x801f3ff8, 0x80008000, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x00001fe0, 0x0ffc8000, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0xfffc6db6, 0xfffc6db6, 0x00000000, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x0001dfe7, 0x8000dfe7, 0x7fff0000, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x0e561ffc, 0x0ff8ffff, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x7fda0000, 0x80000000, 0x002600ad, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00007f00, 0x0000ff00, 0x00008000, 0x00000000, 0x00000000
	dspck_dstio subu_s.ph, 0x00008000, 0x00018000, 0xaaaa0000, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x8000c03f, 0x8000f332, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x7f840006, 0x80008000, 0x007c7ffa, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0xc01f0000, 0xc03f8000, 0x0020f0de, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0xff7a0000, 0xfff8fa66, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0xc003002d, 0xc003002d, 0x00000000, 0x00000000, 0x00000000
	dspck_dstio subu_s.ph, 0x00000000, 0x0000ffe8, 0xfffffffe, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x00000000, 0x00000ffe, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x6b3d0000, 0x7fff0000, 0x14c20002, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0xffe7003f, 0xffe7003f, 0x00000000, 0x00000000
	dspck_dstio subu_s.ph, 0x00000000, 0x7fffe00f, 0xc3dbffff, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x012b0000, 0x012b7fff, 0x0000fff0, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x0000c76f, 0x8000d504, 0x80000d95, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x744d03b1, 0x7fff03b8, 0x0bb20007, 0x00000000, 0x00000000
	dspck_dstio subu_s.ph, 0x7f57e00f, 0x8000e00f, 0x00a90000, 0x00000000, 0x00000000
	dspck_dstio subu_s.ph, 0x0002002f, 0x001dfffa, 0x001bffcb, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x8e380000, 0x8e388000, 0x0000ffa0, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x7fff0003, 0x7fff0003, 0x00000000, 0x00000000
	dspck_dstio subu_s.ph, 0x00000000, 0x00000001, 0x00000001, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x3dde0000, 0xffff8000, 0xc2218000, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00007ff9, 0x007b7fff, 0xdb6d0006, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00008006, 0xffc78006, 0xffff0000, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x0000e7f5, 0x0003e7f6, 0xffd90001, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x19996007, 0x9999e007, 0x80008000, 0x00000000, 0x00000000
	dspck_dstio subu_s.ph, 0x00000000, 0x00000000, 0x7ffc8000, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x000016c2, 0x0000e38e, 0x7ffbcccc, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x7fff0000, 0x7fff0000, 0x00008000, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x00061a54, 0x00061a54, 0x00000000, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x0000fb7b, 0x07fcfb96, 0x7fff001b, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x03ac003c, 0x1fe00063, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x000036cc, 0x7fc07ff0, 0xfffd4924, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0xff673ffe, 0xffffffff, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00007ffd, 0x1e797fff, 0x80000002, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x3f330000, 0xff340004, 0xc001ff80, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x15950000, 0x5555003f, 0x3fc0fc01, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x79dd0000, 0x7ffa03a5, 0x061d2492, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00550000, 0x0e140000, 0x0dbf0000, 0x00000000, 0x00000000
	dspck_dstio subu_s.ph, 0x00000000, 0x00360000, 0x007cfe89, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x0000000f, 0x0006000f, 0xffc00000, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x3ffc0000, 0xff89f003, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0xc0030000, 0xf0077fff, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x7fda7fe4, 0x80007fff, 0x0026001b, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x7ffd0000, 0xfffc0000, 0x7fff0000, 0x00000000, 0x00000000
	dspck_dstio subu_s.ph, 0x00000000, 0x000f7ffa, 0x1c71f2c4, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x00000000, 0x7fff7fff, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x0ead0000, 0xe38e7fff, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x0000e003, 0x803fffc3, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x7fff8000, 0xf470ff39, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00017f40, 0x0001ff3f, 0x00007fff, 0x00000000, 0x00000000
	dspck_dstio subu_s.ph, 0x00000000, 0x7fff0000, 0xfffef001, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x00001fd0, 0x00003fc0, 0x80001ff0, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x03cd0000, 0x03cf003d, 0x0002f001, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x7ffd00ff, 0x800000ff, 0x00030000, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00024001, 0x8001c001, 0x7fff8000, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000006, 0x00008006, 0xffd58000, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0xdfe40000, 0xe0030001, 0x001f0380, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x7fff803f, 0x7fffff76, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x00377fff, 0xff007fff, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000002, 0x80048002, 0xf0038000, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0xc001f003, 0xc001f003, 0x00000000, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00001963, 0x00003953, 0x80051ff0, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x7fc027d2, 0x80008005, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x7fff7fff, 0xff417fff, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x00000000, 0xfff8000d, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x7fe07fff, 0x7ffff803, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0xfcb08004, 0xfcb08004, 0x00000000, 0x00000000, 0x00000000
	dspck_dstio subu_s.ph, 0x0004fff9, 0xfffefff9, 0xfffa0000, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x7f1b0000, 0xff1b0007, 0x80008000, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x00000000, 0x007ffffe, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x00000000, 0xfef8f46d, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00008005, 0x0000fffe, 0xffe07ff9, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x00000000, 0x80007ffe, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x00001171, 0x0012f172, 0xe003e001, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x00006719, 0x00dd7fff, 0x800018e6, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x70018002, 0xf0018002, 0x80000000, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0xff6a0000, 0xfffb7fff, 0x00918e38, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x00000000, 0xfff9100e, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x08aa0000, 0xe8ad0003, 0xe003ff53, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x7fc00000, 0xffc07fff, 0x80008003, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x0000789b, 0x00017fff, 0xf49e0764, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x00000000, 0x0000fff8, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0xfeeb0000, 0xffea8000, 0x00ffe38e, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x80000000, 0x80007fff, 0x00007fff, 0x00000000, 0x00000000
	dspck_dstio subu_s.ph, 0xfffb0000, 0xfffb0ffc, 0x00007fff, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0xf001efa8, 0xf001efb1, 0x00000009, 0x00000000, 0x00000000
	dspck_dstio subu_s.ph, 0x0000003f, 0x00007fff, 0x004f7fc0, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x7ffe197a, 0x7ffe7fe0, 0x00006666, 0x00000000, 0x00000000
	dspck_dstio subu_s.ph, 0x00001ff9, 0x7ffffffc, 0xfffee003, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x000048d1, 0x80004924, 0x80000053, 0x00000000, 0x00000000
	dspck_dstio subu_s.ph, 0x00090000, 0x8002e01f, 0x7ff9ff80, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0xffb9000e, 0xffb9000f, 0x00000001, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x6004df6f, 0xe001e003, 0x7ffd0094, 0x00000000, 0x00000000
	dspck_dstio subu_s.ph, 0x70f00000, 0x7fff800f, 0x0f0fffff, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000009, 0x7fff8001, 0xf0037ff8, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x7ffd0000, 0x80007ffb, 0x0003803f, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x009403fe, 0x7fff8000, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x19000001, 0x19000001, 0x00000000, 0x00000000, 0x00000000
	dspck_dstio subu_s.ph, 0x00006004, 0x00068000, 0x7fc01ffc, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0xfffd8001, 0xfffd8001, 0x00000000, 0x00000000, 0x00000000
	dspck_dstio subu_s.ph, 0x7ffe7fff, 0x80007fff, 0x00020000, 0x00000000, 0x00000000
	dspck_dstio subu_s.ph, 0x3ff60001, 0x3ffc8000, 0x00067fff, 0x00000000, 0x00000000
	dspck_dstio subu_s.ph, 0x00000000, 0x00030003, 0xfa0d1ff0, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x00000000, 0xc0038000, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0xfffd0012, 0xfffdfff2, 0x0000ffe0, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0xb7240000, 0xf007000d, 0x38e3ffdd, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x124d0000, 0x1ffe8000, 0x0db1aaaa, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x22220000, 0xcccc0000, 0xaaaa0000, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x7fff8000, 0xf30effff, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x00000000, 0x00548003, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x8000c003, 0x8000c003, 0x00000000, 0x00000000
	dspck_dstio subu_s.ph, 0x02a20000, 0xffff8003, 0xfd5dfde3, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x3df40000, 0x3fc0000f, 0x01ccfd82, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x40080000, 0xc0071fe0, 0x7fff8000, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00007ff3, 0x2634fff6, 0xffe28003, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x00007fff, 0x7ffffff0, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0xfee47f81, 0xff008000, 0x001c007f, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x1ffc0000, 0xf803fff8, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x0000601f, 0x0ffe7fff, 0xc0071fe0, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x1ffc0002, 0x7ff08000, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x80000000, 0x80000000, 0x0000fffe, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x00000000, 0x7fff0000, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x00008000, 0x7fe0ffff, 0xf8037fff, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x7fff38e3, 0x7fff8000, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x248c0000, 0xfff98000, 0xdb6d8007, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0xfffe00c2, 0xfffe00c2, 0x00000000, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0xb6db0000, 0xb6dbe713, 0x0000fffe, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00006008, 0x0000e007, 0x80007fff, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x00000000, 0x8000c00f, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x8000c007, 0xfffffe44, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x00001ff0, 0x00003ff8, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x1ff082a2, 0x1ff08e38, 0x00000b96, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x0000eb0f, 0x1ffceb10, 0x1ffc0001, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x0000ffff, 0x0000ffff, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00009238, 0x00009249, 0xfe070011, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x00007f01, 0x0000ff00, 0x00057fff, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000060, 0x000f007f, 0x8000001f, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x92490000, 0xcafefffc, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x40090003, 0xc0018003, 0x7ff88000, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x3ffc7fff, 0xfffbfee3, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x7fff8000, 0xffeffff1, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x0000f0f0, 0x0000f0f0, 0x00630000, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0xc0010004, 0xfe7b8000, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0xdfe2ffcb, 0xe001fff0, 0x001f0025, 0x00000000, 0x00000000
	dspck_dstio subu_s.ph, 0x00000000, 0x00000000, 0x00037ffb, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x7ffa7fff, 0x7ffa7fff, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00340000, 0xffeef3a0, 0xffbaffe0, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0xfffc7e0f, 0xfffcfd8f, 0x00007f80, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x7fff0000, 0x7fff040e, 0x0000fc42, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x7fff1ff0, 0x7fffdb6d, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0x800fcccc, 0xffd1e007, 0x00000000, 0x00100000
	dspck_dstio subu_s.ph, 0xfde40000, 0xfe1b002d, 0x003707c1, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0xfe100010, 0xffff0010, 0x01ef0000, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00007f18, 0x8000ff17, 0xc00f7fff, 0x00100000, 0x00100000
	dspck_dstio subu_s.ph, 0x00000000, 0xe0018000, 0xffa7fff0, 0x00100000, 0x00100000

	writemsg "[37] Test subuh.qb"
	dspck_dstio subuh.qb, 0x00f97100, 0x012fe3ff, 0x003c00ff, 0x0, 0x0
	dspck_dstio subuh.qb, 0x610100a6, 0xc303000c, 0x000000c0, 0x0, 0x0
	dspck_dstio subuh.qb, 0x638b7f01, 0xff15ff03, 0x38ff0000, 0x0, 0x0
	dspck_dstio subuh.qb, 0x0081087f, 0x050011ff, 0x05fd0001, 0x0, 0x0
	dspck_dstio subuh.qb, 0x1f7f767f, 0x3effffff, 0x00001200, 0x0, 0x0
	dspck_dstio subuh.qb, 0x810019d5, 0x020237aa, 0xff0205ff, 0x0, 0x0
	dspck_dstio subuh.qb, 0x0580e57f, 0x0c0002ff, 0x02ff3800, 0x0, 0x0
	dspck_dstio subuh.qb, 0xd9800e03, 0x92001e07, 0xdfff0100, 0x0, 0x0
	dspck_dstio subuh.qb, 0x7f417ffd, 0xfffffff8, 0x007c00fd, 0x0, 0x0
	dspck_dstio subuh.qb, 0x000847fe, 0x00118f14, 0x00010017, 0x0, 0x0
	dspck_dstio subuh.qb, 0xc6f07f1b, 0x0e59ff3c, 0x81790005, 0x0, 0x0
	dspck_dstio subuh.qb, 0x3800c597, 0xefff7e0e, 0x7efff3df, 0x0, 0x0
	dspck_dstio subuh.qb, 0x3ce67f29, 0x7839ff6b, 0x006c0119, 0x0, 0x0
	dspck_dstio subuh.qb, 0x0180f4fe, 0x0200e000, 0x00fff803, 0x0, 0x0
	dspck_dstio subuh.qb, 0x03096182, 0xff20ff04, 0xf80d3cff, 0x0, 0x0
	dspck_dstio subuh.qb, 0x7f0dec00, 0xff1a0e00, 0x00003500, 0x0, 0x0
	dspck_dstio subuh.qb, 0x2f2ac993, 0x7e550426, 0x1f0071ff, 0x0, 0x0
	dspck_dstio subuh.qb, 0x077f0603, 0x0fff0c06, 0x00000000, 0x0, 0x0
	dspck_dstio subuh.qb, 0x43ff7f00, 0xff00ff00, 0x78010000, 0x0, 0x0
	dspck_dstio subuh.qb, 0xe1ff008e, 0x8f00001b, 0xcc0100fe, 0x0, 0x0
	dspck_dstio subuh.qb, 0x04116af8, 0x0922fff0, 0x00002aff, 0x0, 0x0
	dspck_dstio subuh.qb, 0xe6fc0080, 0x00000000, 0x330700ff, 0x0, 0x0
	dspck_dstio subuh.qb, 0x5adf06fe, 0xc71f0c00, 0x13600003, 0x0, 0x0
	dspck_dstio subuh.qb, 0x8310fd11, 0x02ff003d, 0xfcdf051b, 0x0, 0x0
	dspck_dstio subuh.qb, 0xd6fe7500, 0x0500f301, 0x58030901, 0x0, 0x0
	dspck_dstio subuh.qb, 0x054f47c2, 0x0a9fff3b, 0x000170b6, 0x0, 0x0
	dspck_dstio subuh.qb, 0x00185cb9, 0x01ffc300, 0x00cf0b8e, 0x0, 0x0
	dspck_dstio subuh.qb, 0xc1e7dd87, 0x81012b00, 0xff3270f1, 0x0, 0x0
	dspck_dstio subuh.qb, 0x22007fea, 0x5803ff08, 0x13030033, 0x0, 0x0
	dspck_dstio subuh.qb, 0xf4783f8c, 0x01f17f07, 0x180000ef, 0x0, 0x0
	dspck_dstio subuh.qb, 0x7402003f, 0xff050081, 0x17000003, 0x0, 0x0
	dspck_dstio subuh.qb, 0x07fc0400, 0x83011000, 0x75080700, 0x0, 0x0
	dspck_dstio subuh.qb, 0x0080007e, 0xff00fffd, 0xffffff00, 0x0, 0x0
	dspck_dstio subuh.qb, 0x7f4f8836, 0xffff0f70, 0x0060ff04, 0x0, 0x0
	dspck_dstio subuh.qb, 0x7fa00019, 0xff3f0033, 0x00ff0000, 0x0, 0x0
	dspck_dstio subuh.qb, 0x78e56400, 0xf003e0ff, 0x003818ff, 0x0, 0x0
	dspck_dstio subuh.qb, 0xfe7b6a8e, 0x00fff300, 0x04081fe3, 0x0, 0x0
	dspck_dstio subuh.qb, 0x02fd00ba, 0x7a000074, 0x760600ff, 0x0, 0x0
	dspck_dstio subuh.qb, 0x82020b07, 0x0304190e, 0xff000200, 0x0, 0x0
	dspck_dstio subuh.qb, 0x007d5f00, 0x01ffbf01, 0x00040000, 0x0, 0x0
	dspck_dstio subuh.qb, 0xff000011, 0x00000040, 0x0200001d, 0x0, 0x0
	dspck_dstio subuh.qb, 0x37807a82, 0x7300ff03, 0x04ff0aff, 0x0, 0x0
	dspck_dstio subuh.qb, 0x4c06d5fe, 0xf80caa00, 0x5f00ff04, 0x0, 0x0
	dspck_dstio subuh.qb, 0xd13c4181, 0x1e79f301, 0x7c0070ff, 0x0, 0x0
	dspck_dstio subuh.qb, 0xd78acdf5, 0x040c0866, 0x55f86d7c, 0x0, 0x0
	dspck_dstio subuh.qb, 0x2c817f82, 0x6601ff03, 0x0eff00fe, 0x0, 0x0
	dspck_dstio subuh.qb, 0x01c70802, 0x03751505, 0x00e70500, 0x0, 0x0
	dspck_dstio subuh.qb, 0x00000000, 0x9fff0000, 0x9fff0000, 0x0, 0x0
	dspck_dstio subuh.qb, 0xc4ff00ff, 0x0f000000, 0x87020002, 0x0, 0x0
	dspck_dstio subuh.qb, 0xe6e307f7, 0x00010e0e, 0x333a001f, 0x0, 0x0
	dspck_dstio subuh.qb, 0x200e90c0, 0x401d0001, 0x0000e080, 0x0, 0x0
	dspck_dstio subuh.qb, 0x7c76071c, 0xf9ff103f, 0x00130106, 0x0, 0x0
	dspck_dstio subuh.qb, 0x00000000, 0x0e0200f1, 0x0e0200f1, 0x0, 0x0
	dspck_dstio subuh.qb, 0xc97db37f, 0x00ff33ff, 0x6d05cc00, 0x0, 0x0
	dspck_dstio subuh.qb, 0x721c7710, 0xff39ff4a, 0x1a01102a, 0x0, 0x0
	dspck_dstio subuh.qb, 0x00000000, 0x080805ff, 0x080805ff, 0x0, 0x0
	dspck_dstio subuh.qb, 0x37fc2508, 0x7e00c31f, 0x1007780f, 0x0, 0x0
	dspck_dstio subuh.qb, 0x11803e7d, 0x24007cff, 0x01ff0005, 0x0, 0x0
	dspck_dstio subuh.qb, 0x79f428fc, 0xffcf8103, 0x0ce7300b, 0x0, 0x0
	dspck_dstio subuh.qb, 0xc060c5f7, 0x00c04001, 0x7f00b613, 0x0, 0x0
	dspck_dstio subuh.qb, 0x0002ba00, 0x00050300, 0x00018f00, 0x0, 0x0
	dspck_dstio subuh.qb, 0x3fedca80, 0xff190400, 0x803f70ff, 0x0, 0x0
	dspck_dstio subuh.qb, 0x41c1fef9, 0xff0200f1, 0x7c8003ff, 0x0, 0x0
	dspck_dstio subuh.qb, 0x9cc4ff80, 0x00000000, 0xc77801ff, 0x0, 0x0
	dspck_dstio subuh.qb, 0x7f5b607f, 0xffb6c1ff, 0x00000000, 0x0, 0x0
	dspck_dstio subuh.qb, 0x78080002, 0xf1100004, 0x00000000, 0x0, 0x0
	dspck_dstio subuh.qb, 0xc080fe80, 0x00000000, 0x80ff03ff, 0x0, 0x0
	dspck_dstio subuh.qb, 0x7ef1ebff, 0xfc0b4700, 0x00297002, 0x0, 0x0
	dspck_dstio subuh.qb, 0x9080efab, 0x0000c055, 0xe0ffe1ff, 0x0, 0x0
	dspck_dstio subuh.qb, 0x0363e603, 0x07c7001c, 0x00003316, 0x0, 0x0
	dspck_dstio subuh.qb, 0x818f0086, 0x01000003, 0xffe100f7, 0x0, 0x0
	dspck_dstio subuh.qb, 0xe64761cc, 0x00ffff01, 0x33713c68, 0x0, 0x0
	dspck_dstio subuh.qb, 0x7ffd4618, 0xff328f30, 0x01370200, 0x0, 0x0
	dspck_dstio subuh.qb, 0x0040efc8, 0xffff148f, 0xff7e35ff, 0x0, 0x0
	dspck_dstio subuh.qb, 0xe8607f87, 0xcfc0ff0e, 0xff0000ff, 0x0, 0x0
	dspck_dstio subuh.qb, 0xf883e53f, 0x08052a7e, 0x18ff6000, 0x0, 0x0
	dspck_dstio subuh.qb, 0x07bfb583, 0x0e183905, 0x0099cfff, 0x0, 0x0
	dspck_dstio subuh.qb, 0x00611f1f, 0x01ff40ff, 0x003c02c1, 0x0, 0x0
	dspck_dstio subuh.qb, 0xa52c00dd, 0x00660007, 0xb60e004d, 0x0, 0x0
	dspck_dstio subuh.qb, 0x3738f5ff, 0x6e7104f0, 0x000019f1, 0x0, 0x0
	dspck_dstio subuh.qb, 0x00f800e6, 0x01000000, 0x000f0033, 0x0, 0x0
	dspck_dstio subuh.qb, 0x9e194f17, 0x2cffff3c, 0xefcc600e, 0x0, 0x0
	dspck_dstio subuh.qb, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_dstio subuh.qb, 0x86fc8000, 0x00000000, 0xf307ff00, 0x0, 0x0
	dspck_dstio subuh.qb, 0x2da0f1f1, 0x5b1f0000, 0x00df1e1e, 0x0, 0x0
	dspck_dstio subuh.qb, 0x00f07f8d, 0x00e0ff09, 0x00ff01ef, 0x0, 0x0
	dspck_dstio subuh.qb, 0x3ef4ff82, 0x7edffe04, 0x02f7ffff, 0x0, 0x0
	dspck_dstio subuh.qb, 0x96eaf047, 0x2c4d58ff, 0xff787871, 0x0, 0x0
	dspck_dstio subuh.qb, 0xfbfe8182, 0x00010103, 0x0904ffff, 0x0, 0x0
	dspck_dstio subuh.qb, 0x0518fee8, 0x0a380f00, 0x00071330, 0x0, 0x0
	dspck_dstio subuh.qb, 0xfb07ffac, 0x00f10018, 0x0ae302bf, 0x0, 0x0
	dspck_dstio subuh.qb, 0x9880c46f, 0x300000e0, 0xffff7801, 0x0, 0x0
	dspck_dstio subuh.qb, 0x5e7f7184, 0xc3fff300, 0x060010f8, 0x0, 0x0
	dspck_dstio subuh.qb, 0xf3803cd5, 0x04007800, 0x1eff0055, 0x0, 0x0
	dspck_dstio subuh.qb, 0x22777921, 0xc1fffd49, 0x7c100a06, 0x0, 0x0
	dspck_dstio subuh.qb, 0x5a01f703, 0xcc033d07, 0x18004f01, 0x0, 0x0
	dspck_dstio subuh.qb, 0x0866f7ff, 0x10ff6d00, 0x00337f02, 0x0, 0x0
	dspck_dstio subuh.qb, 0x00000000, 0xf9030cff, 0xf9030cff, 0x0, 0x0
	dspck_dstio subuh.qb, 0xf0fafa4e, 0xdf0b07fd, 0xff161260, 0x0, 0x0
	dspck_dstio subuh.qb, 0xe5faf003, 0x05f3000e, 0x3aff1f07, 0x0, 0x0
	dspck_dstio subuh.qb, 0xe20080f0, 0x15ff0000, 0x51ffff20, 0x0, 0x0
	dspck_dstio subuh.qb, 0x7f35003e, 0xff710081, 0x00060004, 0x0, 0x0
	dspck_dstio subuh.qb, 0x19901c08, 0x4d003840, 0x1ae0002f, 0x0, 0x0
	dspck_dstio subuh.qb, 0x805b707b, 0x00b6fffc, 0xff001e06, 0x0, 0x0
	dspck_dstio subuh.qb, 0x0c787989, 0x1ef1f302, 0x050000f0, 0x0, 0x0
	dspck_dstio subuh.qb, 0x007f0606, 0x00ff0c0c, 0x00000000, 0x0, 0x0
	dspck_dstio subuh.qb, 0x7ff859f7, 0xff00b6cf, 0x000f03e0, 0x0, 0x0
	dspck_dstio subuh.qb, 0x07fd002f, 0x11001f5e, 0x02061f00, 0x0, 0x0
	dspck_dstio subuh.qb, 0xfd8880d0, 0x000f0000, 0x06ffff60, 0x0, 0x0
	dspck_dstio subuh.qb, 0x660100ff, 0xff03ff00, 0x3200ff02, 0x0, 0x0
	dspck_dstio subuh.qb, 0x84cdea80, 0x010b5400, 0xf8717fff, 0x0, 0x0
	dspck_dstio subuh.qb, 0x7dbaff81, 0xff35fe02, 0x05c1ffff, 0x0, 0x0
	dspck_dstio subuh.qb, 0x00d08f00, 0x00991cff, 0x00f9fdff, 0x0, 0x0
	dspck_dstio subuh.qb, 0xfffb7fff, 0x0005ff00, 0x010e0001, 0x0, 0x0
	dspck_dstio subuh.qb, 0xfc7f3dcc, 0x00fff927, 0x07007f8f, 0x0, 0x0
	dspck_dstio subuh.qb, 0x7ff91d08, 0xff00fd3f, 0x000dc32e, 0x0, 0x0
	dspck_dstio subuh.qb, 0x81af0f8c, 0x01411f18, 0xffe301ff, 0x0, 0x0
	dspck_dstio subuh.qb, 0xf2ad0f18, 0xe321554b, 0xffc7371a, 0x0, 0x0
	dspck_dstio subuh.qb, 0xd718fcff, 0x0355f800, 0x5524ff01, 0x0, 0x0
	dspck_dstio subuh.qb, 0x0cdd0341, 0x18040783, 0x00490001, 0x0, 0x0
	dspck_dstio subuh.qb, 0x12004ee1, 0x3c00c001, 0x1800243f, 0x0, 0x0
	dspck_dstio subuh.qb, 0x7e00a633, 0xff0402ff, 0x0203b699, 0x0, 0x0
	dspck_dstio subuh.qb, 0x2c0ff073, 0x991fdfff, 0x4001ff19, 0x0, 0x0
	dspck_dstio subuh.qb, 0x77840073, 0xff00ffe7, 0x10f7ff00, 0x0, 0x0
	dspck_dstio subuh.qb, 0x008000be, 0x00000000, 0x00ff0083, 0x0, 0x0
	dspck_dstio subuh.qb, 0xd5f1f002, 0x00000005, 0x551e2000, 0x0, 0x0
	dspck_dstio subuh.qb, 0x72057b00, 0xfdccf900, 0x18c10300, 0x0, 0x0
	dspck_dstio subuh.qb, 0x7977ff82, 0xf3ff1c03, 0x00101dff, 0x0, 0x0
	dspck_dstio subuh.qb, 0xff7fc8f1, 0x00ff0838, 0x01007855, 0x0, 0x0
	dspck_dstio subuh.qb, 0x0f5f8503, 0x1fc10907, 0x0002ff00, 0x0, 0x0
	dspck_dstio subuh.qb, 0x3c9a00fc, 0x781400f8, 0x00df00ff, 0x0, 0x0
	dspck_dstio subuh.qb, 0x7c7cfb00, 0xffffc300, 0x0707cc00, 0x0, 0x0
	dspck_dstio subuh.qb, 0x7f90c20e, 0xff1f001c, 0x01ff7c00, 0x0, 0x0
	dspck_dstio subuh.qb, 0xd32c00f4, 0x5d780130, 0xb6200047, 0x0, 0x0
	dspck_dstio subuh.qb, 0xe109f05f, 0xc11f60bf, 0xff0c7f00, 0x0, 0x0
	dspck_dstio subuh.qb, 0x38abfe88, 0x71170010, 0x00c103ff, 0x0, 0x0
	dspck_dstio subuh.qb, 0x7fc635fe, 0xff70bf02, 0x00e35506, 0x0, 0x0
	dspck_dstio subuh.qb, 0xc7ff0ef1, 0x8e02e002, 0xff03c31f, 0x0, 0x0
	dspck_dstio subuh.qb, 0x7847b8fc, 0xf8990038, 0x070b8f3f, 0x0, 0x0
	dspck_dstio subuh.qb, 0x7f004428, 0xffffc055, 0x00ff3805, 0x0, 0x0
	dspck_dstio subuh.qb, 0x0e05e3fe, 0x30110200, 0x13063c03, 0x0, 0x0
	dspck_dstio subuh.qb, 0x1d00f102, 0x78010005, 0x3e001e00, 0x0, 0x0
	dspck_dstio subuh.qb, 0x01ffd780, 0x02020000, 0x000352ff, 0x0, 0x0
	dspck_dstio subuh.qb, 0xfe05197d, 0x030a3cff, 0x06000905, 0x0, 0x0
	dspck_dstio subuh.qb, 0x7cc47476, 0xff0cfffc, 0x0783170f, 0x0, 0x0
	dspck_dstio subuh.qb, 0x9f01abdb, 0x01035500, 0xc301ff49, 0x0, 0x0
	dspck_dstio subuh.qb, 0x7a3c4c5f, 0xfff199df, 0x0b790020, 0x0, 0x0
	dspck_dstio subuh.qb, 0x607bf08e, 0xfff90700, 0x3f0226e3, 0x0, 0x0
	dspck_dstio subuh.qb, 0x7c010082, 0xff020003, 0x060000ff, 0x0, 0x0
	dspck_dstio subuh.qb, 0x99817f00, 0x0102ff00, 0xcfff0100, 0x0, 0x0
	dspck_dstio subuh.qb, 0x03e8c992, 0xf7cf0224, 0xf0ff70ff, 0x0, 0x0
	dspck_dstio subuh.qb, 0xe9798103, 0x02f3013c, 0x3000ff35, 0x0, 0x0
	dspck_dstio subuh.qb, 0xc49aab9e, 0x00000000, 0x78ccaac3, 0x0, 0x0
	dspck_dstio subuh.qb, 0xb2a4804c, 0x584700aa, 0xf3ffff11, 0x0, 0x0
	dspck_dstio subuh.qb, 0x7f803c06, 0xff007c10, 0x00ff0304, 0x0, 0x0
	dspck_dstio subuh.qb, 0x01642d87, 0x03cc5b0e, 0x000401ff, 0x0, 0x0
	dspck_dstio subuh.qb, 0x2f7f024c, 0x5fff0699, 0x00010100, 0x0, 0x0
	dspck_dstio subuh.qb, 0x77e200ff, 0xef000101, 0x003c0002, 0x0, 0x0
	dspck_dstio subuh.qb, 0x00000b00, 0x01011700, 0x00000000, 0x0, 0x0
	dspck_dstio subuh.qb, 0x7f7ee8c2, 0xffffcf7c, 0x0003fff7, 0x0, 0x0
	dspck_dstio subuh.qb, 0x095f7101, 0x18c0ff03, 0x06011c00, 0x0, 0x0
	dspck_dstio subuh.qb, 0x7cf833f4, 0xff0066c7, 0x061000df, 0x0, 0x0
	dspck_dstio subuh.qb, 0xff0f09e2, 0x7f331200, 0x8114003c, 0x0, 0x0
	dspck_dstio subuh.qb, 0x920e77c0, 0x24fff30e, 0xffe3058e, 0x0, 0x0
	dspck_dstio subuh.qb, 0x6f5bfefd, 0xdfb60001, 0x01000406, 0x0, 0x0
	dspck_dstio subuh.qb, 0x8023032c, 0x00b6077e, 0xff700026, 0x0, 0x0
	dspck_dstio subuh.qb, 0x9698009e, 0x2b00ff3c, 0xffcfffff, 0x0, 0x0
	dspck_dstio subuh.qb, 0x00e40078, 0x0801fff1, 0x0738ff00, 0x0, 0x0
	dspck_dstio subuh.qb, 0x6dfe0219, 0xfd000432, 0x23030000, 0x0, 0x0
	dspck_dstio subuh.qb, 0x02000678, 0x04ff0cff, 0x00ff000e, 0x0, 0x0
	dspck_dstio subuh.qb, 0x8ff4a2ff, 0x00df0409, 0xe1f7c00b, 0x0, 0x0
	dspck_dstio subuh.qb, 0x00ec00ae, 0x00180040, 0x003f00e3, 0x0, 0x0
	dspck_dstio subuh.qb, 0x0063b8f9, 0x01ff0206, 0x00389213, 0x0, 0x0
	dspck_dstio subuh.qb, 0x00fc809b, 0x00010035, 0x0009ffff, 0x0, 0x0
	dspck_dstio subuh.qb, 0xe6fec900, 0xcc009202, 0xff03ff01, 0x0, 0x0
	dspck_dstio subuh.qb, 0x837f9d78, 0x06ff01ff, 0xff01c70f, 0x0, 0x0
	dspck_dstio subuh.qb, 0xecab0400, 0x15550800, 0x3cff0000, 0x0, 0x0
	dspck_dstio subuh.qb, 0xea810212, 0x10000624, 0x3cfe0100, 0x0, 0x0
	dspck_dstio subuh.qb, 0x1f430769, 0xff878fff, 0xc101812d, 0x0, 0x0
	dspck_dstio subuh.qb, 0x828d7f74, 0x0318ffff, 0xfffe0117, 0x0, 0x0
	dspck_dstio subuh.qb, 0x007bf8ff, 0x01fff003, 0x0109ff04, 0x0, 0x0
	dspck_dstio subuh.qb, 0x00a6fb03, 0x01190608, 0x01cc0f01, 0x0, 0x0
	dspck_dstio subuh.qb, 0x8f8208f3, 0x1e011402, 0xfffc031c, 0x0, 0x0
	dspck_dstio subuh.qb, 0x3efa807f, 0x7e0100ff, 0x010cff01, 0x0, 0x0
	dspck_dstio subuh.qb, 0x00f503f1, 0x000e0fdf, 0x002409fd, 0x0, 0x0
	dspck_dstio subuh.qb, 0x8aed2066, 0x053e41ff, 0xf0630033, 0x0, 0x0
	dspck_dstio subuh.qb, 0x80018100, 0x00030101, 0xff00ff00, 0x0, 0x0
	dspck_dstio subuh.qb, 0xd0490087, 0x1f92000e, 0x7f0000ff, 0x0, 0x0
	dspck_dstio subuh.qb, 0x6f7f7f00, 0xdfffff00, 0x01000000, 0x0, 0x0
	dspck_dstio subuh.qb, 0x960000e8, 0x1dff0001, 0xf1ff0030, 0x0, 0x0
	dspck_dstio subuh.qb, 0xffede781, 0x00194c01, 0x023e7eff, 0x0, 0x0
	dspck_dstio subuh.qb, 0x00000000, 0x1c0101ff, 0x1c0101ff, 0x0, 0x0
	dspck_dstio subuh.qb, 0x61012b49, 0xc30256ff, 0x0000006c, 0x0, 0x0
	dspck_dstio subuh.qb, 0x40247fee, 0x81ffff00, 0x00b60024, 0x0, 0x0
	dspck_dstio subuh.qb, 0xc018a743, 0x07f015ff, 0x87c0c778, 0x0, 0x0
	dspck_dstio subuh.qb, 0x6d08700a, 0xdb10e115, 0x00000000, 0x0, 0x0
	dspck_dstio subuh.qb, 0x54e094fc, 0xfd811c00, 0x55c1f308, 0x0, 0x0
	dspck_dstio subuh.qb, 0xf2ff80fc, 0x00000006, 0x1c01ff0d, 0x0, 0x0
	dspck_dstio subuh.qb, 0x37810001, 0x70010005, 0x01ff0002, 0x0, 0x0
	dspck_dstio subuh.qb, 0x40703cfe, 0x81ff7800, 0x001f0004, 0x0, 0x0
	dspck_dstio subuh.qb, 0x3300ff11, 0xc7ff0060, 0x60ff013e, 0x0, 0x0
	dspck_dstio subuh.qb, 0xa97f0800, 0x51ff1400, 0xff010300, 0x0, 0x0
	dspck_dstio subuh.qb, 0x06908110, 0x0e2002ff, 0x02ffffdf, 0x0, 0x0
	dspck_dstio subuh.qb, 0x0ed5fe81, 0x1c000001, 0x005503ff, 0x0, 0x0
	dspck_dstio subuh.qb, 0x7d414300, 0xff8effff, 0x050c78ff, 0x0, 0x0
	dspck_dstio subuh.qb, 0x079f3337, 0x0e3dff7f, 0x00ff9910, 0x0, 0x0
	dspck_dstio subuh.qb, 0x4701005f, 0x8f0301bf, 0x00000000, 0x0, 0x0
	dspck_dstio subuh.qb, 0xfe4f301f, 0x009f9fff, 0x03003ec1, 0x0, 0x0
	dspck_dstio subuh.qb, 0x369fd185, 0x70022408, 0x03c381fe, 0x0, 0x0
	dspck_dstio subuh.qb, 0x07ff80ff, 0xff070000, 0xf009ff01, 0x0, 0x0
	dspck_dstio subuh.qb, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_dstio subuh.qb, 0x87f6001e, 0x0e00ffff, 0xff14ffc3, 0x0, 0x0
	dspck_dstio subuh.qb, 0xee8078e4, 0x0c00ff07, 0x2fff0f3f, 0x0, 0x0
	dspck_dstio subuh.qb, 0xb0039a00, 0x002601ff, 0x9f1fccff, 0x0, 0x0
	dspck_dstio subuh.qb, 0x1e7b3682, 0x3df9ff03, 0x010392ff, 0x0, 0x0
	dspck_dstio subuh.qb, 0x0003c70c, 0x00ff8e18, 0x00f9ff00, 0x0, 0x0
	dspck_dstio subuh.qb, 0x0eb3ad1c, 0x1d663cfc, 0x00ffe1c3, 0x0, 0x0
	dspck_dstio subuh.qb, 0xa4818f1e, 0x45011e3c, 0xfcffff00, 0x0, 0x0
	dspck_dstio subuh.qb, 0x00001917, 0x00003332, 0x00000004, 0x0, 0x0
	dspck_dstio subuh.qb, 0x161f2c35, 0xf9bfb66b, 0xcc805d00, 0x0, 0x0
	dspck_dstio subuh.qb, 0x0cff87ff, 0x99000000, 0x8002f101, 0x0, 0x0
	dspck_dstio subuh.qb, 0x8c60b80b, 0x00c0001c, 0xe7008f06, 0x0, 0x0
	dspck_dstio subuh.qb, 0xf4f1497f, 0x3c7192ff, 0x538f0000, 0x0, 0x0
	dspck_dstio subuh.qb, 0xce1b002e, 0x0c3c006a, 0x7006000e, 0x0, 0x0
	dspck_dstio subuh.qb, 0x81ca0088, 0x01020f04, 0xff6d0ef3, 0x0, 0x0
	dspck_dstio subuh.qb, 0x6e8aac81, 0xff132801, 0x23ffcfff, 0x0, 0x0
	dspck_dstio subuh.qb, 0xf2f0f8e4, 0x00000000, 0x1c200f38, 0x0, 0x0
	dspck_dstio subuh.qb, 0x0700007f, 0x0f0000ff, 0x00000000, 0x0, 0x0
	dspck_dstio subuh.qb, 0x00ff8207, 0xff00030f, 0xff01ff00, 0x0, 0x0
	dspck_dstio subuh.qb, 0xfea2825b, 0x010403db, 0x05bfff24, 0x0, 0x0
	dspck_dstio subuh.qb, 0x0a473f87, 0x158e7f0e, 0x000000ff, 0x0, 0x0
	dspck_dstio subuh.qb, 0x4370419d, 0x87e0ff02, 0x00007cc7, 0x0, 0x0
	dspck_dstio subuh.qb, 0x7f71e7b0, 0xfffd0460, 0x001a36ff, 0x0, 0x0
	dspck_dstio subuh.qb, 0x00000000, 0x00ff0099, 0x00ff0099, 0x0, 0x0
	dspck_dstio subuh.qb, 0xac7e1f2c, 0x19fc3f58, 0xc1000000, 0x0, 0x0
	dspck_dstio subuh.qb, 0x00e80fef, 0x00cf2b33, 0x00fe0c55, 0x0, 0x0
	dspck_dstio subuh.qb, 0x00000000, 0x0e3fff00, 0x0e3fff00, 0x0, 0x0
	dspck_dstio subuh.qb, 0x817280fe, 0x01ff0000, 0xff1bff03, 0x0, 0x0
	dspck_dstio subuh.qb, 0xd8638166, 0x8fcc01ff, 0xdf05ff33, 0x0, 0x0
	dspck_dstio subuh.qb, 0xf89acb83, 0x08001d06, 0x18cc87ff, 0x0, 0x0
	dspck_dstio subuh.qb, 0x43c99b83, 0x87921103, 0x00ffdbfc, 0x0, 0x0
	dspck_dstio subuh.qb, 0xfe4b0273, 0x02ff3dff, 0x06683818, 0x0, 0x0
	dspck_dstio subuh.qb, 0x0064814b, 0x71cc0199, 0x7103ff03, 0x0, 0x0

	writemsg "[38] Test subuh_r.qb"
	dspck_dstio subuh_r.qb, 0xffea298d, 0x0004b601, 0x023165e7, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x0f007e44, 0x40ffff87, 0x22ff0400, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x3a80387f, 0x7fff70ff, 0x0b000001, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x0cb90b0f, 0x1c00251d, 0x058f1000, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x4a2557c8, 0xc355bf00, 0x300c1270, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x7eff6a83, 0xff00e305, 0x04030fff, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x00790004, 0x07ff00ff, 0x080e00f8, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x7f807ff9, 0xffffff00, 0x0100010e, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x32250178, 0x7f4a0ef0, 0x1c010c00, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x2e7c5a82, 0x64ffff00, 0x08074bfc, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x003e48fd, 0x007eff05, 0x0003700c, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xe1e719f9, 0x00003100, 0x3e33000f, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x1e81fc81, 0x3f00f700, 0x04ffffff, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x000c0000, 0xffff00ff, 0xffe701ff, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x0be7157f, 0x16003ffe, 0x01321600, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xf1a4002e, 0x000a015b, 0x1fc30100, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xff40920d, 0x018e0419, 0x030ee100, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xf9621989, 0x00e03f10, 0x0e1c0eff, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x00020900, 0x00031200, 0x00000000, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xc1952699, 0x70086030, 0xefdf14ff, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x8133891f, 0x00ff013e, 0xff99ef01, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xd082f89a, 0x8f000003, 0xeffd10cf, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xe2e73fcb, 0x0100ff23, 0x3d33818e, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x00fd00b9, 0x00000000, 0x0007008e, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xb90066e0, 0x0000ff09, 0x8f013349, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x780d0003, 0xf0190006, 0x00000000, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x66e8cec2, 0xffcf0000, 0x33ff657c, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x397deec3, 0xf0ff1b00, 0x7f06407b, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xf0a110d6, 0x00012000, 0x20c00055, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x94050432, 0x270e0767, 0xff040003, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xf400cd7c, 0x040099f7, 0x1c00ff00, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x81b48102, 0x00670003, 0xffffff00, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x806ec2b9, 0xffe10100, 0x00067e8f, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x70121801, 0xe7239201, 0x07006200, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x15057cf4, 0x2b1fff00, 0x01160819, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x38f164ff, 0x8f00c700, 0x201e0002, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x7c028500, 0xffff0200, 0x07fcf900, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x016e3e07, 0x01db7fff, 0x000003f1, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xfe027d7f, 0x0705ffff, 0x0c020601, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x10f26433, 0x1f01c77c, 0x001d0017, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x7f8278fc, 0xff02fc02, 0x02ff0c0a, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x60910180, 0xc00001ff, 0x00df0000, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x73041c01, 0xffff3b04, 0x19f70303, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x02baf30e, 0x0302e3ff, 0x008efde3, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xb17bfe81, 0x41ff0001, 0xe00904ff, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xf4fe87fc, 0xaa190cc3, 0xc31dffcc, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x02001081, 0x0401ff00, 0x0001dfff, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xc0f02539, 0x7e048771, 0xff243d00, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x930081b9, 0x00000000, 0xdb00ff8f, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x0978fc92, 0xf8ff001c, 0xe71009f8, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xf881cfef, 0x0e000d01, 0x1fff7024, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xff6d0802, 0x00e0102b, 0x02070027, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x00f7cb01, 0x00003f03, 0x0113aa01, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x098100f9, 0x2000ff01, 0x0effff10, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x9d800055, 0x38ffffaa, 0xff00ff00, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x847fb068, 0x00ff5dfd, 0xf802fe2d, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x280248ac, 0x710d8f16, 0x220900bf, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x0111097e, 0x01257cff, 0x00046b04, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xfff7803c, 0x0000ffff, 0x03130087, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x847c302b, 0x00ff6056, 0xf8080000, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xd0148000, 0x1028ffff, 0x710000ff, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x84cb6e00, 0x070ddb00, 0xff780000, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x02003840, 0x04006f80, 0x00000000, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x338b81ec, 0x66150000, 0x00ffff28, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xd60480fa, 0x01fffff3, 0x55f800ff, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xc1f83403, 0x0055e310, 0x7f667c0a, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x4300e380, 0x990000ff, 0x14003b00, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xf6e479bf, 0x00c7fe04, 0x14ff0c87, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x00da0007, 0xff7fff0e, 0xffccff00, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x0400ff0c, 0x07000078, 0x00010360, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x2e7f9b00, 0xe3ff34ff, 0x8702ffff, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x02636efc, 0x03c7e305, 0x0001070d, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x3cfd707a, 0x7d00e0ff, 0x0606000c, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x00c702ff, 0xff7e031e, 0xfff10021, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x03401a7f, 0x058033ff, 0x00000002, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xf11424b7, 0xe18e556d, 0xff660eff, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x0500a1fd, 0x100000f7, 0x0700bffd, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x800501fa, 0xff0a0300, 0x0000010c, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x00000000, 0x0002782a, 0x0002782a, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x0100fe33, 0x01000080, 0x0000051a, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x37ca01e9, 0x7c000204, 0x0e6c0032, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x06fd3a3c, 0x6c007583, 0x6107010c, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x01708a73, 0x01df03f8, 0x0000f013, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x52b8f9d2, 0xbf010002, 0x1c920f5f, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xe298f7b1, 0xc30ae060, 0xffdbf3ff, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x88e58211, 0x002f0083, 0xf066fc62, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x85843fe4, 0x0206f9c7, 0xf8ff7cff, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xc1b5ce7d, 0x800300ff, 0xff996405, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x00000000, 0x00ff2007, 0x00ff2007, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xd17fa0c8, 0x28ff3e1e, 0x8701ff8f, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x00000000, 0x0f030100, 0x0f030100, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x81810002, 0x0000fff3, 0xffffffef, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x72de6801, 0xe300ff02, 0x00453000, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x9ce82ad0, 0x3730559f, 0xff6001ff, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x04b91888, 0xff038000, 0xf89250f0, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x0400001c, 0x07000037, 0x00000000, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x81002d16, 0x00ff923e, 0xffff3812, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x797543c5, 0xf1ffc308, 0x00163e7f, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x81710188, 0x00e1010e, 0xff0000ff, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x81000082, 0x01000000, 0xff0000fd, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x00000000, 0x13180833, 0x13180833, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x374100c6, 0xfff7ff0a, 0x9275ff7e, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x1f2790b1, 0x7dcf0000, 0x4081e19f, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x04fe1900, 0x07f836ff, 0x00fc04ff, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xc4fffaac, 0x04000138, 0x7c020de0, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x80000106, 0xff00010b, 0x00000000, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x0080e889, 0x00ff0f10, 0x000040ff, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xe0b7c107, 0x3f060028, 0x7f997f1b, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x398d41c1, 0x71188102, 0x00ff0081, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x37018480, 0x6d0206ff, 0x0000ff00, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x8f0ae8cc, 0x003a0278, 0xe32733e1, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xc250f1f5, 0x83dfe008, 0xff40ff1f, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x84847b10, 0x0707ff33, 0xffff0a14, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x017c80ff, 0x1ff7ff00, 0x1e000002, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x052bec05, 0x0bff000a, 0x01aa2900, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x08648000, 0x10c7ff00, 0x00000000, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x91298042, 0x2054ff83, 0xff020000, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x42308003, 0x8360ff12, 0x0001000d, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x801f0000, 0xff3d0000, 0x00000000, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x01045212, 0x0c08bf23, 0x0b011c00, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x03ffc106, 0x0500100e, 0x00038f02, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xecf00005, 0x58df000d, 0x80ff0003, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xfe036af0, 0x1be1ffdf, 0x1fdb2bff, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x0034fc48, 0xff73008f, 0xff0b0800, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x0201a268, 0x0d0124df, 0x0a00e110, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x3e390581, 0x7c780900, 0x000600ff, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x826c8000, 0x02ffff00, 0xfe270000, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x5bd6d380, 0xb60125ff, 0x01558000, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x1f02390f, 0xfe03802b, 0xc1000e0e, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x690000e4, 0xffffffc7, 0x2effffff, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x78816287, 0xff00ff0c, 0x10ff3cff, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x6f3fc111, 0xff7e003f, 0x22017f1e, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x610b0407, 0xc116070e, 0x00000000, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x80b2d8ff, 0xff638e00, 0x00ffdf03, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xfe7e88f6, 0x02ff0f0a, 0x0703ff1f, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x05e8021f, 0x0a18043d, 0x00480000, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x9e7a8100, 0x1fff0101, 0xe30bff01, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xfda0ca88, 0x00000000, 0x06c16df1, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xdc7a8080, 0x00ffffff, 0x490c0000, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x7cfb79e8, 0xff00f1c7, 0x080b00f7, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x300f0b5e, 0xe73e16ff, 0x87200044, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x07820c7f, 0x0d02ffff, 0x00ffe701, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x375b8511, 0xffb60322, 0x9200f900, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x11ff3702, 0x2502ff03, 0x03049200, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x00000000, 0xff0b011c, 0xff0b011c, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x4281d679, 0xff0178fc, 0x7cffcc0b, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x78800702, 0xf0ff0e03, 0x00000000, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x02012180, 0x040141ff, 0x00000000, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x0001018d, 0x0002ff18, 0x0000feff, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x7ac004e7, 0xf301080c, 0x0081013f, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xa0009f02, 0x3eff0105, 0xffffc301, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xc47eb97a, 0x87ff00f3, 0xff038f00, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x4200fe00, 0xff000e00, 0x7c001300, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x00ebff81, 0x00550000, 0x008002ff, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xa102d362, 0x400499e1, 0xff00f31e, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x1c500304, 0x389f0507, 0x00000000, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xff998181, 0x00000000, 0x03cfffff, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xa26f8031, 0x04dffff3, 0xc1010092, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xe1fc2b80, 0x000755ff, 0x3e100000, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xf5777e90, 0x19fffd00, 0x2f1101e0, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x83807c87, 0x04ffff0d, 0xff0007ff, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x010f0ae7, 0x191e1800, 0x18000433, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x030000e2, 0x0e000003, 0x0900003f, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xfb0300ed, 0x0a06ff01, 0x1500ff27, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x05007fe5, 0x0a03ff01, 0x00030238, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xb479ff84, 0x66ff0006, 0xff0e03ff, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x81f4f9ee, 0x0106022e, 0xff1e1152, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x01ffc300, 0x01010000, 0x00037b00, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xff00fdfb, 0x00000000, 0x0300070a, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xeef481f8, 0x00000007, 0x2418ff18, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xfdfc807e, 0x7106ffff, 0x780e0003, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x253a7e62, 0xb673ffc3, 0x6d000400, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x76ff78e5, 0xef06ff03, 0x03090f39, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xff1a0300, 0x013306ff, 0x030000ff, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x897f8158, 0x0aff00b6, 0xf802ff07, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x7cf68131, 0xf7000076, 0x0015ff14, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xfa06e931, 0x132a0af0, 0x201e398e, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x393cc1b0, 0x717c005e, 0x00047eff, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x0a07401e, 0x140e7f3c, 0x00000000, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x78020100, 0xff060100, 0x0f020000, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x819d8000, 0x0039ffff, 0xffff00ff, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xf1fce91e, 0x0107013c, 0x20103000, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xa02dfdf1, 0x076092e0, 0xc70799ff, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x00000000, 0xefff7107, 0xefff7107, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x3931ec80, 0x717f01ff, 0x001e2a00, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x807fb237, 0xffff3f7e, 0x0001db10, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xc2009078, 0x83001ef7, 0xff01ff07, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x70ebe74c, 0xff4600cf, 0x1f713337, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x5f38fb08, 0xc07104ff, 0x03020ef0, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x5f6f0081, 0xbfe10700, 0x010308ff, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x807ffb88, 0xffff000e, 0x00010aff, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x0ccf0191, 0x497e0220, 0x32e100ff, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xf93a07c8, 0x00920e0f, 0x0f1f007f, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x6020ef82, 0xc03f1b03, 0x00003eff, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x00e20f81, 0x01006600, 0x013d49ff, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x0e66ff15, 0xfce1002a, 0xe1150300, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xd7d4307f, 0x1f2460ff, 0x717c0002, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x209a6e81, 0x9f33ff00, 0x60ff24ff, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x805a807d, 0xffc0ffff, 0x000c0006, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x0e7e2d10, 0x1efff32e, 0x0303990e, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x39022a89, 0x80035410, 0x0e0000ff, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x5c460bc1, 0xbf8f1701, 0x0703017f, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x0a183f00, 0x16ff7f00, 0x02cf0200, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x92200efa, 0x223f1c00, 0xff00000c, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xfc01b9c0, 0x00010000, 0x08008f80, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x3933d6ac, 0x7166aa57, 0x0000ffff, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x0f880540, 0x1e0e0b80, 0x00ff0200, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xe93f08fe, 0x00ff2800, 0x2e811805, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x7318380e, 0xe730701c, 0x01000000, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x6100007f, 0xc10000fe, 0x00000000, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x66088071, 0xcc10ffe1, 0x00000000, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xfdd3ad80, 0xf8240fff, 0xff7fb600, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xf8008480, 0x0f0000ff, 0x1f00f900, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x0ea87906, 0x1c10ff0f, 0x01c10e03, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x00558100, 0x00ff00ff, 0x0055ffff, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x400f80e8, 0x80ffffcf, 0x00e100ff, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x009a20fe, 0xff333f05, 0xffff000a, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x967b483f, 0x0fffff99, 0xe30a701c, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x3ea1424e, 0xff00879f, 0x83bf0403, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x00000000, 0xff0106aa, 0xff0106aa, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x190100aa, 0x3301ff14, 0x0200ffc0, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x7fc18d28, 0xff811855, 0x02ffff05, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xc0000100, 0x000002ff, 0x810000ff, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x7c00d49a, 0xf8001833, 0x000070ff, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x00000000, 0x00b620ff, 0x00b620ff, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x815b3ff1, 0x00ffff00, 0xfe49811e, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xdc504993, 0xb69f9200, 0xff0000db, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x046e3b8b, 0x07e07c05, 0x000507ef, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x24351981, 0xc3fc6000, 0x7c922eff, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x0070830f, 0x00df041e, 0x0000ff00, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x0f1e3e98, 0x1e3eff2c, 0x010383fc, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x690000f8, 0xe10002e7, 0x0f0103f8, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x5e70128e, 0xc0e02702, 0x050004e7, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xe6bd7bc3, 0x0a78ff7c, 0x3fff09f7, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xf2638104, 0xe0ff000b, 0xfc3aff03, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0xf5001802, 0x01003024, 0x18010020, 0x0, 0x0
	dspck_dstio subuh_r.qb, 0x013300f7, 0x01ffff01, 0x0099ff13, 0x0, 0x0

	writemsg "[39] Test addqh.ph"
	dspck_dstio addqh.ph, 0x24914000, 0x49247ffe, 0xffff0003, 0x0, 0x0
	dspck_dstio addqh.ph, 0x499dfffc, 0x7fff7ff9, 0x133b8000, 0x0, 0x0
	dspck_dstio addqh.ph, 0x21effc3c, 0x03fe315c, 0x3fe0c71c, 0x0, 0x0
	dspck_dstio addqh.ph, 0x3fffbf8f, 0x7fff8000, 0x0000ff1f, 0x0, 0x0
	dspck_dstio addqh.ph, 0xc0420001, 0x00050002, 0x807f0000, 0x0, 0x0
	dspck_dstio addqh.ph, 0x07fd0006, 0x0003000d, 0x0ff80000, 0x0, 0x0
	dspck_dstio addqh.ph, 0x00022db6, 0x0004db6d, 0x00007fff, 0x0, 0x0
	dspck_dstio addqh.ph, 0xffff00f9, 0x8000fff4, 0x7fff01ff, 0x0, 0x0
	dspck_dstio addqh.ph, 0x0000c001, 0x00000000, 0x00008002, 0x0, 0x0
	dspck_dstio addqh.ph, 0xc0030443, 0x8000088a, 0x0007fffc, 0x0, 0x0
	dspck_dstio addqh.ph, 0xf78015e5, 0xf0010bdb, 0xff001ff0, 0x0, 0x0
	dspck_dstio addqh.ph, 0x00031fea, 0x000dffd8, 0xfffa3ffc, 0x0, 0x0
	dspck_dstio addqh.ph, 0x09190ea3, 0xfffafd4a, 0x12381ffc, 0x0, 0x0
	dspck_dstio addqh.ph, 0xefcf3ff3, 0xe01fffe7, 0xff807fff, 0x0, 0x0
	dspck_dstio addqh.ph, 0xc32d7fff, 0x065a7fff, 0x80007fff, 0x0, 0x0
	dspck_dstio addqh.ph, 0x30033ffd, 0xe007fffc, 0x7fff7fff, 0x0, 0x0
	dspck_dstio addqh.ph, 0xc7185c71, 0x8e3838e3, 0xfff87fff, 0x0, 0x0
	dspck_dstio addqh.ph, 0xc6718000, 0x807f8000, 0x0c648000, 0x0, 0x0
	dspck_dstio addqh.ph, 0xfc46fffb, 0xf88d0000, 0x0000fff6, 0x0, 0x0
	dspck_dstio addqh.ph, 0xffffdf7d, 0x7fffdb6d, 0x8000e38e, 0x0, 0x0
	dspck_dstio addqh.ph, 0x1fe0fe02, 0x3fc00003, 0x0000fc01, 0x0, 0x0
	dspck_dstio addqh.ph, 0xce38c000, 0x1c710000, 0x80008000, 0x0, 0x0
	dspck_dstio addqh.ph, 0x3fffd555, 0x7fffaaaa, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.ph, 0xf0033ffc, 0xe0077ff9, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.ph, 0x7ffebcf7, 0x7fff803f, 0x7ffef9af, 0x0, 0x0
	dspck_dstio addqh.ph, 0xf3c0c3fe, 0xe78007fc, 0x00008000, 0x0, 0x0
	dspck_dstio addqh.ph, 0x0000fffb, 0x0000fff6, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.ph, 0x103dffff, 0x007f8000, 0x1ffc7fff, 0x0, 0x0
	dspck_dstio addqh.ph, 0x401cc006, 0x7ffffffd, 0x003a800f, 0x0, 0x0
	dspck_dstio addqh.ph, 0x021e7fff, 0x021e7fff, 0x021e7fff, 0x0, 0x0
	dspck_dstio addqh.ph, 0xa2f0d8e7, 0xc5e0b6db, 0x8000faf4, 0x0, 0x0
	dspck_dstio addqh.ph, 0xfff8ce38, 0x001f8000, 0xffd21c71, 0x0, 0x0
	dspck_dstio addqh.ph, 0x03fedb6d, 0x03fedb6d, 0x03fedb6d, 0x0, 0x0
	dspck_dstio addqh.ph, 0x3ffffff8, 0x7ffffff0, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.ph, 0x17f3c71c, 0x3fe00000, 0xf0078e38, 0x0, 0x0
	dspck_dstio addqh.ph, 0xe00200af, 0xfffefffe, 0xc0070161, 0x0, 0x0
	dspck_dstio addqh.ph, 0xf004401d, 0x00027fff, 0xe007003c, 0x0, 0x0
	dspck_dstio addqh.ph, 0x3f960000, 0x7fff0000, 0xff2e0000, 0x0, 0x0
	dspck_dstio addqh.ph, 0x05cff005, 0x0000e001, 0x0b9e0009, 0x0, 0x0
	dspck_dstio addqh.ph, 0xfdd23ffe, 0xffa07fff, 0xfc04fffe, 0x0, 0x0
	dspck_dstio addqh.ph, 0xcd550000, 0xcd550000, 0xcd550000, 0x0, 0x0
	dspck_dstio addqh.ph, 0x0c21f382, 0x0002ff91, 0x1841e774, 0x0, 0x0
	dspck_dstio addqh.ph, 0xfc010dfe, 0xf8031ffc, 0x0000fc01, 0x0, 0x0
	dspck_dstio addqh.ph, 0x3bf02450, 0xf8017fff, 0x7fe0c8a1, 0x0, 0x0
	dspck_dstio addqh.ph, 0x185affd2, 0xf0bc0181, 0x3ff8fe23, 0x0, 0x0
	dspck_dstio addqh.ph, 0x0785bfff, 0x0f0fffff, 0xfffc8000, 0x0, 0x0
	dspck_dstio addqh.ph, 0xec20be41, 0xe00f8000, 0xf832fc82, 0x0, 0x0
	dspck_dstio addqh.ph, 0xc0025fef, 0x00043fe0, 0x80007fff, 0x0, 0x0
	dspck_dstio addqh.ph, 0xfff73fff, 0xffe07fff, 0x000e0000, 0x0, 0x0
	dspck_dstio addqh.ph, 0xc000c007, 0x00008000, 0x8000000f, 0x0, 0x0
	dspck_dstio addqh.ph, 0xc2020e0a, 0x04041c14, 0x80000000, 0x0, 0x0
	dspck_dstio addqh.ph, 0x3fff036b, 0x7fff06d7, 0xffff0000, 0x0, 0x0
	dspck_dstio addqh.ph, 0x4e3800a6, 0x1c7102f9, 0x7ffffe53, 0x0, 0x0
	dspck_dstio addqh.ph, 0xfffdf205, 0x000003fc, 0xfffae00f, 0x0, 0x0
	dspck_dstio addqh.ph, 0xf5c8003c, 0xea5d0005, 0x01330074, 0x0, 0x0
	dspck_dstio addqh.ph, 0xb803c002, 0xf0018006, 0x8005ffff, 0x0, 0x0
	dspck_dstio addqh.ph, 0xc003c010, 0x00018000, 0x80050020, 0x0, 0x0
	dspck_dstio addqh.ph, 0x3c561c71, 0x38b538e3, 0x3ff80000, 0x0, 0x0
	dspck_dstio addqh.ph, 0x40950e34, 0x7ffffff7, 0x012c1c71, 0x0, 0x0
	dspck_dstio addqh.ph, 0xc0003fff, 0x80000000, 0x00007fff, 0x0, 0x0
	dspck_dstio addqh.ph, 0xfc2fd75d, 0x001f1c71, 0xf83f9249, 0x0, 0x0
	dspck_dstio addqh.ph, 0x5999022f, 0x7fff0458, 0x33330007, 0x0, 0x0
	dspck_dstio addqh.ph, 0xf3260006, 0xe0010000, 0x064b000c, 0x0, 0x0
	dspck_dstio addqh.ph, 0xffebb878, 0xffd88000, 0xfffef0f0, 0x0, 0x0
	dspck_dstio addqh.ph, 0x8000cccc, 0x80009999, 0x80000000, 0x0, 0x0
	dspck_dstio addqh.ph, 0x3ffff031, 0x0000e003, 0x7fff005f, 0x0, 0x0
	dspck_dstio addqh.ph, 0x47470670, 0x7f800000, 0x0f0f0ce0, 0x0, 0x0
	dspck_dstio addqh.ph, 0x0ffeec4a, 0x1ffed8ab, 0xfffeffe9, 0x0, 0x0
	dspck_dstio addqh.ph, 0x03f9ffec, 0x07fcffd9, 0xfff70000, 0x0, 0x0
	dspck_dstio addqh.ph, 0x38e3c924, 0x00000000, 0x71c79249, 0x0, 0x0
	dspck_dstio addqh.ph, 0xeaed0015, 0xaaaa002b, 0x2b300000, 0x0, 0x0
	dspck_dstio addqh.ph, 0xf35a407f, 0xe6b47fff, 0x000100ff, 0x0, 0x0
	dspck_dstio addqh.ph, 0xf8763511, 0xf0f0fc6c, 0xfffc6db6, 0x0, 0x0
	dspck_dstio addqh.ph, 0xfe2603ff, 0x00000000, 0xfc4c07fe, 0x0, 0x0
	dspck_dstio addqh.ph, 0xc00013b2, 0x00002747, 0x8000001d, 0x0, 0x0
	dspck_dstio addqh.ph, 0x40013ffe, 0x0003fffd, 0x7fff7fff, 0x0, 0x0
	dspck_dstio addqh.ph, 0xa38e0921, 0x80009249, 0xc71c7ff9, 0x0, 0x0
	dspck_dstio addqh.ph, 0xfff8bc03, 0x80008003, 0x7ff0f803, 0x0, 0x0
	dspck_dstio addqh.ph, 0xf8463fff, 0xf08d7fff, 0x0000ffff, 0x0, 0x0
	dspck_dstio addqh.ph, 0xffe3d907, 0xffc08000, 0x0007320e, 0x0, 0x0
	dspck_dstio addqh.ph, 0x1b6dffff, 0x7fff8000, 0xb6db7fff, 0x0, 0x0
	dspck_dstio addqh.ph, 0x001f3fff, 0x803f7fff, 0x7fff0000, 0x0, 0x0
	dspck_dstio addqh.ph, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.ph, 0x01003fff, 0xfe020000, 0x03fe7fff, 0x0, 0x0
	dspck_dstio addqh.ph, 0xf94ee071, 0x0000fffb, 0xf29cc0e7, 0x0, 0x0
	dspck_dstio addqh.ph, 0xff9ec00a, 0xff3c0005, 0x0000800f, 0x0, 0x0
	dspck_dstio addqh.ph, 0x3003fb87, 0xe007f6c8, 0x7fff0046, 0x0, 0x0
	dspck_dstio addqh.ph, 0xffcffe4c, 0xff9efc99, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.ph, 0x4096199c, 0x01343333, 0x7ff80006, 0x0, 0x0
	dspck_dstio addqh.ph, 0xbfff001b, 0xffff0001, 0x80000035, 0x0, 0x0
	dspck_dstio addqh.ph, 0xbffdff0f, 0xfffbfe1f, 0x80000000, 0x0, 0x0
	dspck_dstio addqh.ph, 0xfff83fff, 0x7ff00000, 0x80017fff, 0x0, 0x0
	dspck_dstio addqh.ph, 0xca63e002, 0x14c7c001, 0x80000004, 0x0, 0x0
	dspck_dstio addqh.ph, 0xffffc020, 0x00000001, 0xfffe803f, 0x0, 0x0
	dspck_dstio addqh.ph, 0xfffc0000, 0xfff80001, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.ph, 0xffff0032, 0x7fff0064, 0x80000000, 0x0, 0x0
	dspck_dstio addqh.ph, 0x3ffb0000, 0x7ffa0000, 0xfffd0000, 0x0, 0x0
	dspck_dstio addqh.ph, 0xbeb3af32, 0xfd638000, 0x8003de64, 0x0, 0x0
	dspck_dstio addqh.ph, 0xc039fed1, 0x8000fda2, 0x00730000, 0x0, 0x0
	dspck_dstio addqh.ph, 0xfe540000, 0x00000000, 0xfca80000, 0x0, 0x0
	dspck_dstio addqh.ph, 0x3ffe78e3, 0xfffd71c7, 0x7fff7fff, 0x0, 0x0
	dspck_dstio addqh.ph, 0x7fff07fc, 0x7fff07fc, 0x7fff07fc, 0x0, 0x0
	dspck_dstio addqh.ph, 0x7ff7c016, 0x7fffffed, 0x7ff0803f, 0x0, 0x0
	dspck_dstio addqh.ph, 0xf0b70ff0, 0x00000000, 0xe16f1fe0, 0x0, 0x0
	dspck_dstio addqh.ph, 0x47fe4001, 0x7fff0003, 0x0ffe7fff, 0x0, 0x0
	dspck_dstio addqh.ph, 0x0f85bff1, 0x1f028000, 0x0009ffe3, 0x0, 0x0
	dspck_dstio addqh.ph, 0xdb6dbf80, 0xb6dbff00, 0x00008000, 0x0, 0x0
	dspck_dstio addqh.ph, 0x003f0006, 0x007f000c, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.ph, 0xfffd8000, 0x7ffb8000, 0x80008000, 0x0, 0x0
	dspck_dstio addqh.ph, 0xbfdc3fff, 0xffb87fff, 0x80000000, 0x0, 0x0
	dspck_dstio addqh.ph, 0x00020000, 0x00040000, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.ph, 0x2636ffa7, 0x7fff000f, 0xcc6eff40, 0x0, 0x0
	dspck_dstio addqh.ph, 0x7fffe003, 0x7fffe003, 0x7fffe003, 0x0, 0x0
	dspck_dstio addqh.ph, 0x402eeccb, 0x005d3ffe, 0x7fff9999, 0x0, 0x0
	dspck_dstio addqh.ph, 0x4033ccce, 0x7ff80003, 0x006f9999, 0x0, 0x0
	dspck_dstio addqh.ph, 0x201f8000, 0xc03f8000, 0x7fff8000, 0x0, 0x0
	dspck_dstio addqh.ph, 0xf800fde6, 0x00000000, 0xf001fbcd, 0x0, 0x0
	dspck_dstio addqh.ph, 0x000f26d6, 0x00700db4, 0xffaf3ff8, 0x0, 0x0
	dspck_dstio addqh.ph, 0xf007ee48, 0xe00fe003, 0xfffffc8e, 0x0, 0x0
	dspck_dstio addqh.ph, 0x33f1fff7, 0x71c70003, 0xf61cffeb, 0x0, 0x0
	dspck_dstio addqh.ph, 0xffff02f6, 0xffff02f6, 0xffff02f6, 0x0, 0x0
	dspck_dstio addqh.ph, 0x80000003, 0x80000007, 0x80000000, 0x0, 0x0
	dspck_dstio addqh.ph, 0x7fffdfe0, 0x7fff8000, 0x7fff3fc0, 0x0, 0x0
	dspck_dstio addqh.ph, 0x4001bffe, 0x00038000, 0x7ffffffc, 0x0, 0x0
	dspck_dstio addqh.ph, 0xfffe7ffc, 0xfffe7ffc, 0xfffe7ffc, 0x0, 0x0
	dspck_dstio addqh.ph, 0xffff3ffc, 0xffff7fff, 0xfffffffa, 0x0, 0x0
	dspck_dstio addqh.ph, 0x404144a2, 0x1a1c0946, 0x66667fff, 0x0, 0x0
	dspck_dstio addqh.ph, 0xffff1be1, 0x7fff3fc0, 0x8000f803, 0x0, 0x0
	dspck_dstio addqh.ph, 0xc003ffff, 0x00068000, 0x80007fff, 0x0, 0x0
	dspck_dstio addqh.ph, 0xfff2fffc, 0xffe4fff8, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.ph, 0x05f09b6d, 0xfffd8000, 0x0be4b6db, 0x0, 0x0
	dspck_dstio addqh.ph, 0x3ffd2aaa, 0x7fff5555, 0xfffc0000, 0x0, 0x0
	dspck_dstio addqh.ph, 0x022ec3bb, 0x045d0776, 0x00008000, 0x0, 0x0
	dspck_dstio addqh.ph, 0xcb888e38, 0xcb888e38, 0xcb888e38, 0x0, 0x0
	dspck_dstio addqh.ph, 0xe01bc001, 0xc03f8000, 0xfff70002, 0x0, 0x0
	dspck_dstio addqh.ph, 0x3cff1e30, 0x7fff1ff0, 0xfa001c71, 0x0, 0x0
	dspck_dstio addqh.ph, 0x8000c016, 0x8000002c, 0x80008000, 0x0, 0x0
	dspck_dstio addqh.ph, 0xf801ffff, 0xfffcffff, 0xf0070000, 0x0, 0x0
	dspck_dstio addqh.ph, 0x47b88000, 0x0ff08000, 0x7f808000, 0x0, 0x0
	dspck_dstio addqh.ph, 0x0000ffff, 0x00000000, 0x0000ffff, 0x0, 0x0
	dspck_dstio addqh.ph, 0xbfff4001, 0xffff0003, 0x80007fff, 0x0, 0x0
	dspck_dstio addqh.ph, 0x1ff7fff9, 0x3fe00001, 0x000ffff2, 0x0, 0x0
	dspck_dstio addqh.ph, 0xf7d207f9, 0xffa2f003, 0xf0031ff0, 0x0, 0x0
	dspck_dstio addqh.ph, 0x018902df, 0x000705b8, 0x030c0006, 0x0, 0x0
	dspck_dstio addqh.ph, 0xf8033d7a, 0xf0077fff, 0x0000faf6, 0x0, 0x0
	dspck_dstio addqh.ph, 0xffbd3ff5, 0xfffcfff2, 0xff7e7ff9, 0x0, 0x0
	dspck_dstio addqh.ph, 0xc000ecbb, 0x8000f5e9, 0x0000e38e, 0x0, 0x0
	dspck_dstio addqh.ph, 0xfff309d7, 0xffe713b0, 0x0000ffff, 0x0, 0x0
	dspck_dstio addqh.ph, 0xfd35e2e9, 0xfaa50000, 0xffc5c5d3, 0x0, 0x0
	dspck_dstio addqh.ph, 0xbe00dff8, 0x80003ff0, 0xfc018000, 0x0, 0x0
	dspck_dstio addqh.ph, 0xfd45db6d, 0xfa86b6db, 0x00040000, 0x0, 0x0
	dspck_dstio addqh.ph, 0x8002c001, 0x80008000, 0x80050003, 0x0, 0x0
	dspck_dstio addqh.ph, 0xff42d555, 0x00010000, 0xfe84aaaa, 0x0, 0x0
	dspck_dstio addqh.ph, 0x2b463801, 0x7ffff003, 0xd68e7fff, 0x0, 0x0
	dspck_dstio addqh.ph, 0x01243fff, 0x02467fff, 0x00020000, 0x0, 0x0
	dspck_dstio addqh.ph, 0xc007e001, 0x800fc003, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.ph, 0xfffc0fc8, 0x80001ff8, 0x7ff9ff99, 0x0, 0x0
	dspck_dstio addqh.ph, 0xc0000ff8, 0x00010000, 0x80001ff0, 0x0, 0x0
	dspck_dstio addqh.ph, 0x000a3fff, 0x00000000, 0x00147fff, 0x0, 0x0
	dspck_dstio addqh.ph, 0xc3ab8003, 0x07578000, 0x80008006, 0x0, 0x0
	dspck_dstio addqh.ph, 0xffdee007, 0xffc0c00f, 0xfffc0000, 0x0, 0x0
	dspck_dstio addqh.ph, 0x2003fffe, 0x7ffffffd, 0xc0070000, 0x0, 0x0
	dspck_dstio addqh.ph, 0x00297fff, 0x01017fff, 0xff517fff, 0x0, 0x0
	dspck_dstio addqh.ph, 0x80000e3d, 0x80001c71, 0x80000009, 0x0, 0x0
	dspck_dstio addqh.ph, 0x3ff25ffe, 0x7fff3ffe, 0xffe57fff, 0x0, 0x0
	dspck_dstio addqh.ph, 0xf678dff0, 0xf0f0ffe0, 0xfc01c001, 0x0, 0x0
	dspck_dstio addqh.ph, 0xfffffffd, 0xfffffffd, 0xfffffffd, 0x0, 0x0
	dspck_dstio addqh.ph, 0xf801f1c7, 0xf0030000, 0x0000e38e, 0x0, 0x0
	dspck_dstio addqh.ph, 0xc000fff0, 0x00000000, 0x8000ffe0, 0x0, 0x0
	dspck_dstio addqh.ph, 0x80007fff, 0x80007fff, 0x80007fff, 0x0, 0x0
	dspck_dstio addqh.ph, 0xfff6200f, 0xffec7fff, 0x0000c01f, 0x0, 0x0
	dspck_dstio addqh.ph, 0xf1c7ffff, 0x00000000, 0xe38efffe, 0x0, 0x0
	dspck_dstio addqh.ph, 0x0517ffaa, 0x0000ff16, 0x0a2e003f, 0x0, 0x0
	dspck_dstio addqh.ph, 0xf00f41bd, 0xe01f037c, 0x00007fff, 0x0, 0x0
	dspck_dstio addqh.ph, 0x3ffe0000, 0x7ffd0001, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.ph, 0x0225f80e, 0x0002f007, 0x04480016, 0x0, 0x0
	dspck_dstio addqh.ph, 0xcc510003, 0xff090006, 0x99990000, 0x0, 0x0
	dspck_dstio addqh.ph, 0x1c934005, 0x4924000b, 0xf0037fff, 0x0, 0x0
	dspck_dstio addqh.ph, 0xbf98c9da, 0xff3113b4, 0x80008000, 0x0, 0x0
	dspck_dstio addqh.ph, 0xa56bc004, 0xcad48000, 0x80020008, 0x0, 0x0
	dspck_dstio addqh.ph, 0xc00236de, 0x80050006, 0x00006db6, 0x0, 0x0
	dspck_dstio addqh.ph, 0x3ffd004c, 0x7ffffffe, 0xfffb009b, 0x0, 0x0
	dspck_dstio addqh.ph, 0x3e8058e2, 0x7ff071c7, 0xfd103ffe, 0x0, 0x0
	dspck_dstio addqh.ph, 0x0eedc110, 0xfddd01a1, 0x1ffe807f, 0x0, 0x0
	dspck_dstio addqh.ph, 0xefd70110, 0xffa80220, 0xe0070000, 0x0, 0x0
	dspck_dstio addqh.ph, 0xfc15fffe, 0xf840fffc, 0xffeb0000, 0x0, 0x0
	dspck_dstio addqh.ph, 0xf879c47b, 0x0003803f, 0xf0f008b7, 0x0, 0x0
	dspck_dstio addqh.ph, 0x08b0ffe0, 0x0db28000, 0x03ae7fc0, 0x0, 0x0
	dspck_dstio addqh.ph, 0xfae70000, 0xf5ce0000, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.ph, 0x2aaaff67, 0x0000fcb3, 0x5555021c, 0x0, 0x0
	dspck_dstio addqh.ph, 0xc71effe8, 0x0005fff9, 0x8e38ffd8, 0x0, 0x0
	dspck_dstio addqh.ph, 0xc3fe8000, 0x07fc8000, 0x80008000, 0x0, 0x0
	dspck_dstio addqh.ph, 0x0001ff7f, 0x0002ff00, 0x0000ffff, 0x0, 0x0
	dspck_dstio addqh.ph, 0x1338ffff, 0x3ffcffff, 0xe674ffff, 0x0, 0x0
	dspck_dstio addqh.ph, 0xc001fffc, 0x80000000, 0x0002fff8, 0x0, 0x0
	dspck_dstio addqh.ph, 0x00003ff8, 0x0000fff2, 0x00007fff, 0x0, 0x0
	dspck_dstio addqh.ph, 0xc0150000, 0x002a3ffe, 0x8000c003, 0x0, 0x0
	dspck_dstio addqh.ph, 0xc71c0000, 0xc71c0000, 0xc71c0000, 0x0, 0x0
	dspck_dstio addqh.ph, 0xc89d0800, 0x92490004, 0xfef20ffc, 0x0, 0x0
	dspck_dstio addqh.ph, 0xd657c000, 0x02050000, 0xaaaa8000, 0x0, 0x0
	dspck_dstio addqh.ph, 0xe007a00f, 0x0000c01f, 0xc00f8000, 0x0, 0x0
	dspck_dstio addqh.ph, 0x8000fffc, 0x80000000, 0x8000fff8, 0x0, 0x0
	dspck_dstio addqh.ph, 0xc07fc000, 0x80000000, 0x00ff8000, 0x0, 0x0
	dspck_dstio addqh.ph, 0x014dc002, 0x029c8000, 0xfffe0004, 0x0, 0x0
	dspck_dstio addqh.ph, 0x3ff80111, 0x7ff00222, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.ph, 0xfff6005e, 0xfff0ffea, 0xfffc00d2, 0x0, 0x0
	dspck_dstio addqh.ph, 0x8000ce13, 0x8000ce13, 0x8000ce13, 0x0, 0x0
	dspck_dstio addqh.ph, 0xb009fffc, 0xe00f7ff8, 0x80048000, 0x0, 0x0
	dspck_dstio addqh.ph, 0x00019555, 0x00008000, 0x0003aaaa, 0x0, 0x0
	dspck_dstio addqh.ph, 0xfbc0bfff, 0xe003fffd, 0x177d8002, 0x0, 0x0
	dspck_dstio addqh.ph, 0xe00f007e, 0xc01f00fc, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.ph, 0xf2f18002, 0x05e18004, 0xe0018000, 0x0, 0x0
	dspck_dstio addqh.ph, 0xffff0048, 0x7ffffd97, 0x800002f9, 0x0, 0x0
	dspck_dstio addqh.ph, 0xf0102b8c, 0xe0034924, 0x001d0df4, 0x0, 0x0
	dspck_dstio addqh.ph, 0xfff50036, 0x000a0098, 0xffe0ffd5, 0x0, 0x0
	dspck_dstio addqh.ph, 0xff52c001, 0xfeac8000, 0xfff90003, 0x0, 0x0
	dspck_dstio addqh.ph, 0x05fa26e6, 0xe01f3309, 0x2bd61ac4, 0x0, 0x0
	dspck_dstio addqh.ph, 0xc0003fff, 0x80007fff, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.ph, 0x00003fff, 0x00000000, 0x00007fff, 0x0, 0x0
	dspck_dstio addqh.ph, 0xffdcfc01, 0xffaa0000, 0x000ff803, 0x0, 0x0
	dspck_dstio addqh.ph, 0xfff919d3, 0x00000000, 0xfff233a6, 0x0, 0x0
	dspck_dstio addqh.ph, 0x000101bf, 0x000203fe, 0x0000ff81, 0x0, 0x0
	dspck_dstio addqh.ph, 0x3f933c28, 0xff2e3852, 0x7ff93ffe, 0x0, 0x0
	dspck_dstio addqh.ph, 0x00004786, 0x00000f0f, 0x00007ffd, 0x0, 0x0
	dspck_dstio addqh.ph, 0x80000ffa, 0x8000fffd, 0x80001ff8, 0x0, 0x0
	dspck_dstio addqh.ph, 0xffff3fff, 0x80000000, 0x7fff7fff, 0x0, 0x0
	dspck_dstio addqh.ph, 0xc0bb200f, 0x0157c01f, 0x801f7fff, 0x0, 0x0
	dspck_dstio addqh.ph, 0xe79e3fff, 0x24927fff, 0xaaaa0000, 0x0, 0x0
	dspck_dstio addqh.ph, 0x5feff006, 0x3fe0e00f, 0x7ffffffe, 0x0, 0x0
	dspck_dstio addqh.ph, 0xbfff02fd, 0xffffff80, 0x8000067b, 0x0, 0x0
	dspck_dstio addqh.ph, 0x4002fffe, 0x0005fffc, 0x7fff0000, 0x0, 0x0
	dspck_dstio addqh.ph, 0x3fa4e081, 0xff49c003, 0x7fff00ff, 0x0, 0x0
	dspck_dstio addqh.ph, 0x3fff0000, 0x7fff0000, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.ph, 0xc0000002, 0x80000005, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.ph, 0xffeeb88b, 0xffe5e2df, 0xfff88e38, 0x0, 0x0
	dspck_dstio addqh.ph, 0x1f21fffc, 0xfffbfff8, 0x3e480000, 0x0, 0x0
	dspck_dstio addqh.ph, 0xd3d78000, 0x80008000, 0x27af8000, 0x0, 0x0
	dspck_dstio addqh.ph, 0x012cc011, 0x02558000, 0x00030022, 0x0, 0x0
	dspck_dstio addqh.ph, 0x0070c00d, 0x0000fffb, 0x00e0801f, 0x0, 0x0
	dspck_dstio addqh.ph, 0xc0031ffb, 0x00071ffe, 0x80001ff8, 0x0, 0x0
	dspck_dstio addqh.ph, 0x4a96fffe, 0x152d0000, 0x7ffffffc, 0x0, 0x0

	writemsg "[40] Test addqh_r.ph"
	dspck_dstio addqh_r.ph, 0x5feebfff, 0x7ffbfffe, 0x3fe08000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x0001060c, 0x00020c18, 0x0000ffff, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xf4f5fff9, 0xfffcfff2, 0xe9edffff, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xe000391e, 0x80037fc0, 0x3ffcf27b, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x3ffcf588, 0x7fffeb10, 0xfff90000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x4000f06f, 0x7fff00be, 0x0000e01f, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x40030000, 0x00068000, 0x7fff7fff, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x00a40007, 0x00ff000e, 0x00490000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x135dc000, 0x06c18007, 0x1ff8fff8, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xfffd054b, 0xfff90aea, 0x0000ffac, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x0004c001, 0x00078002, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xe0020000, 0xc0030000, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x0005bffa, 0x000f8000, 0xfffbfff4, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x3c0040fc, 0xf8017fff, 0x7fff01f9, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x38ed8003, 0x00128000, 0x71c78005, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xffff3fd0, 0xfffd7fc0, 0x0000ffe0, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x0fedffff, 0xfffe7ffd, 0x1fdc8000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xcb2047fb, 0xc9747ffd, 0xcccc0ff8, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xb0082ffe, 0x8000e001, 0xe00f7ffa, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x088cc526, 0x1117f803, 0x00009249, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xc00d4953, 0x80007fff, 0x001a12a6, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x76db3fc0, 0x6db60000, 0x7fff7f80, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xffdfbff3, 0xfffdffe6, 0xffc08000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x4ffc000e, 0x7fff001c, 0x1ff80000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xbfe3f7f1, 0xffc6f001, 0x8000ffe0, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xffbf1620, 0xfffffdb2, 0xff7e2e8e, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x4000bfff, 0x7ffffffe, 0x00008000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x3ffefffa, 0xfffde003, 0x7fff1ff0, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xc0161ff8, 0x80050000, 0x00263ff0, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xb333fff4, 0xccccffe9, 0x9999fffe, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x00002fff, 0xffffe003, 0x00007ffa, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x0750400f, 0x0ea37fff, 0xfffc001f, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xffff0000, 0xffff0000, 0xffff0000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x30010c2d, 0xe0031866, 0x7ffffff3, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xc000ff4a, 0x8000fe93, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x1f08ffbb, 0x3e140000, 0xfffbff76, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x3ffff6d2, 0xffff0000, 0x7fffeda3, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x0000eedf, 0x00000000, 0x0000ddbe, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x7ff85ffe, 0x7ff07fff, 0x7fff3ffc, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x0001000f, 0x0002801f, 0x00007fff, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xc0033d92, 0x8000fb24, 0x00067fff, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x1ff22ab4, 0x7fe00013, 0xc0035555, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xffff0000, 0xffff0000, 0xffff0000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x078823df, 0x000007fe, 0x0f0f3fc0, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x7fff07ff, 0x7fff0ffe, 0x7fff0000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x2691ffff, 0x49248000, 0x03fe7ffd, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x40000007, 0x00000000, 0x7fff000d, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x0000c401, 0xffff07fe, 0x00008004, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xfcd9ffff, 0xfd46ffff, 0xfc6bffff, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xffffff34, 0x3ffcfe69, 0xc001ffff, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x7fc00ffe, 0x7fc00ffe, 0x7fc00ffe, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x44f338da, 0x7fff6db6, 0x09e603fe, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xffafff3a, 0xff5dfe70, 0x00000003, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x1c280ff8, 0xfffd0000, 0x38531ff0, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x0000c05a, 0x7fff00b3, 0x80008000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x0000dff9, 0x7ffffff1, 0x8000c001, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x11c707fe, 0x238d0004, 0x00010ff8, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x2a6b8000, 0xff808000, 0x55558000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xf8e4bfe3, 0x71c7ffc5, 0x80018000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x3f4807fb, 0xfe910ff8, 0x7ffffffe, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xe279c000, 0xc4f28000, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x0ffe1fe4, 0x1ffcffd8, 0x00003ff0, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x0000fffe, 0x80008000, 0x7fff7ffc, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x47ff3ff4, 0x7fff3ff0, 0x0ffe3ff8, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xff310000, 0xff610000, 0xff00ffff, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xfd700003, 0x00000000, 0xfae00005, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x0000fff7, 0x0000ffef, 0x0000ffff, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xc0010ccc, 0x80009999, 0x00017fff, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x4b5bc08d, 0x16b6803f, 0x7fff00da, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x03a4fff0, 0x03a4fff0, 0x03a4fff0, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x1ffc2000, 0x3ff80003, 0x00003ffc, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x00203ff0, 0x00000000, 0x003f7fe0, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xe00103eb, 0xfffeffff, 0xc00307d6, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x7fff000a, 0x7fff0013, 0x7fff0000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x00070032, 0x000a0066, 0x0004fffe, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xe008c0be, 0xc00f8000, 0x0000017c, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xffed0a23, 0xffda093f, 0x00000b07, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xffebc000, 0x00000000, 0xffd68000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x400047ee, 0x7fff7fe0, 0x00000ffc, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x3fe08000, 0x3fe08000, 0x3fe08000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x4000e666, 0x00000000, 0x7fffcccc, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x1d6ffff1, 0xffffffe0, 0x3ade0001, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x1fe0f8e4, 0x3fc08000, 0xffff71c7, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x400cbfd9, 0x7ff9ffaf, 0x001f8003, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x03fde672, 0x07fc0018, 0xfffecccc, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x00015ff0, 0x00003fe0, 0x00027fff, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x000f0001, 0x00060001, 0x00170000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xf1c7407e, 0xe38e7fc0, 0xffff013c, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xf801ffdb, 0x00000000, 0xf001ffb5, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x00021ffe, 0x00000000, 0x00033ffc, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x0924ffe3, 0x7fffffc0, 0x92490005, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xc1bf0000, 0x80007fff, 0x037e8000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x401ac000, 0x7fff8000, 0x00350000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xf800c000, 0xf0010000, 0xfffe8000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x36db3fde, 0x00007fff, 0x6db6ffbd, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xe37dff9c, 0xc00f0000, 0x06ebff38, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x400b0013, 0x00170016, 0x7fff000f, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x3ec44ffe, 0xfd8c1ffc, 0x7ffc7fff, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x07fc0000, 0x0ff80000, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xbff80028, 0xffef001c, 0x80000033, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xfe5a033c, 0xfcad06b1, 0x0006ffc6, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xffff0003, 0xfffd0000, 0x00000005, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xfffe0000, 0xfffc0000, 0x0000ffff, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x1fe4c007, 0xffcc8000, 0x3ffc000e, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xfffd1d44, 0xffff3fc0, 0xfffafac7, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x7fe0087e, 0x7fc010fc, 0x7fff0000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x02ebffd0, 0x01d8ff9f, 0x03fe0000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x00018000, 0x00018000, 0x00008000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x803f004e, 0x803f004e, 0x803f004e, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x3ff0bff2, 0x7fe08003, 0x0000ffe1, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x007ffc77, 0x00fff0f0, 0xffff07fe, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x3ffd4000, 0xfffb0000, 0x7fff7fff, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x000000fe, 0x000000fe, 0x000000fe, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xbfffffd1, 0x8000fff9, 0xfffeffa8, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x40004000, 0x00007fff, 0x7fff0000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xc000083f, 0x0000007f, 0x80000ffe, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x401f7fff, 0x7fff7fff, 0x003f7fff, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xc0000005, 0x0000ffeb, 0x8000001f, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x001ebf26, 0xfffcfe4c, 0x003f8000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xbfab7fff, 0xff557fff, 0x80007fff, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x3c20c008, 0x7ffa000f, 0xf8458000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x01564ff8, 0x02ad1ff0, 0xffff7fff, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x3ffebfd9, 0xfffd801f, 0x7fffff92, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x47fffffd, 0x0ffefffa, 0x7fff0000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x0076bffe, 0x0000fffc, 0x00ec8000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xfe8b0000, 0x00000000, 0xfd160000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xffe1c000, 0x00018000, 0xffc0ffff, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x00003fe0, 0x0000ffc0, 0x00007fff, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x4000ff3a, 0x7fffff73, 0x0000ff00, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x3334fff4, 0x0001ffeb, 0x6666fffc, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x00914000, 0x031d0000, 0xfe057fff, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x800001ce, 0x80000000, 0x8000039c, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x3ffa4000, 0x7ffc7fff, 0xfff80000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xfc01400a, 0xf0030014, 0x07fe7fff, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x4232fce5, 0x7ffff9c9, 0x04650000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x0000bffd, 0x8000fffa, 0x7fff8000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xeae70000, 0xd5a90000, 0x00250000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x27df4003, 0x0ffe0006, 0x3fc07fff, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xfffcffae, 0x0000ffff, 0xfff8ff5c, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x00031fe0, 0x00050000, 0x00003fc0, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xfed84000, 0xfdb47fff, 0xfffb0000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x03df0011, 0x07fe0006, 0xffc0001b, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x119afffe, 0x119afffe, 0x119afffe, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x00002e23, 0x80003333, 0x7fff2913, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xdfe0ffff, 0x3fc0fffe, 0x80000000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xd555c93a, 0x0000002b, 0xaaaa9249, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x73330000, 0x7fff8000, 0x66667fff, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x00002492, 0x00000000, 0x00004924, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x3ffd0017, 0x7fff0061, 0xfffaffcd, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xfe280000, 0xfc4f8000, 0x00007fff, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xc00c7fff, 0x80027fff, 0x00167fff, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x00008000, 0xffff8000, 0x00018000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x2aa60788, 0x55550000, 0xfff60f0f, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xc3fe023c, 0x80000479, 0x07fcffff, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x4000078b, 0x00000006, 0x7fff0f0f, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xb801402c, 0xf0017fff, 0x80000059, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xfffeff7f, 0xfffcfffe, 0x0000ff00, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xfe264000, 0x00000000, 0xfc4b7fff, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x0fffbff3, 0x1ffeffe6, 0x00008000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xdfeef01c, 0xff9c0018, 0xc03fe01f, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xc000c000, 0x00008000, 0x8000ffff, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x7fdc4032, 0x7fc00065, 0x7ff87fff, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x00107fff, 0x00007fff, 0x001f7fff, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x00000004, 0x00050001, 0xfffb0006, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xff7d0032, 0xfeff0006, 0xfffb005d, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x40d1c001, 0x7ff88000, 0x01aa0001, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xc000fdf9, 0x0000fc01, 0x8000fff0, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x1b9e7fee, 0x375c7fe0, 0xffdf7ffb, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x3ff94009, 0x7fff0012, 0xfff27fff, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x95570814, 0x8004002c, 0xaaaa0ffc, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xbfffee11, 0x8000e001, 0xfffefc21, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xbf0ec1ff, 0xfe1c8000, 0x800003fe, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xc3923fbb, 0xc0077fff, 0xc71cff77, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x803f7ffa, 0x803f7ffa, 0x803f7ffa, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xc0001237, 0x80001c71, 0x000007fc, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xe00441ff, 0x000003fe, 0xc0077fff, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x00003ffc, 0x80007ff8, 0x7fff0000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x3fff1fe0, 0xffff0000, 0x7fff3fc0, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x0000f043, 0x0000007f, 0x0000e007, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x00003fc0, 0x00007f80, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x2aa98000, 0xfffd8000, 0x55558000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x3ffff860, 0x7fff0000, 0xfffef0bf, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x4000c000, 0x7fff8000, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xffff0001, 0xfff80001, 0x00060001, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xfff91b6b, 0xfff27ffa, 0x0000b6db, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xc0000002, 0x00000000, 0x80000004, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xf47af551, 0xf8033ff8, 0xf0f0aaaa, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xc925c000, 0x00008000, 0x92490000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xf7f2e561, 0xf00303a6, 0xffe0c71c, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x5c71c000, 0x7fff8000, 0x38e30000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x1fe01265, 0x00000ad3, 0x3fc019f7, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xe7e9c019, 0xc007002b, 0x0fca8006, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x4187bea9, 0x7ffffd51, 0x030f8000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x5fe85fff, 0x3fe03ffe, 0x7ff07fff, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x2491c3fe, 0x492407fc, 0xfffd8000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xf879fff2, 0xf0f00000, 0x0002ffe3, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x40412003, 0x7fffc007, 0x00837fff, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x4003e58a, 0x0006fffe, 0x7fffcb15, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x0003fffe, 0x0006fffb, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x4fffc36c, 0x7fff803f, 0x1ffe0699, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xcccd0003, 0x99990006, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x0002ffff, 0x00000000, 0x0004fffd, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xcccf1d19, 0x00053a31, 0x99990000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xf7ff4007, 0xf0017fff, 0xfffc000f, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xcccd38e4, 0x999971c7, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xb96cefc8, 0xf2d8fc01, 0x8000e38e, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x7fbee008, 0x7ffb0001, 0x7f80c00f, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xc0043f90, 0x00087fff, 0x8000ff20, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xfb09bfff, 0xf6168002, 0xfffbfffc, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x4003bffd, 0x00078000, 0x7ffffffa, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x43ff0000, 0x07fe7fff, 0x7fff8000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x5ff0fffb, 0x7ffffff9, 0x3fe0fffd, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xc002eff9, 0x8000ffeb, 0x0004e007, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xc24b8000, 0x80018000, 0x04948000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x76db41ff, 0x6db67fff, 0x7fff03fe, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xa0213000, 0x8002e001, 0xc03f7fff, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x53c05ff8, 0x27817fff, 0x7fff3ff0, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xf8041000, 0xf0070001, 0x00001ffe, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x020232f3, 0x03feff80, 0x00066666, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xff0efffe, 0xff0efffe, 0xff0efffe, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x003efe5f, 0x007f0000, 0xfffcfcbd, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xbff03000, 0xffe07fff, 0x8000e001, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x119d4000, 0x33330000, 0xf0077fff, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xc0003ff8, 0x80007ff0, 0x0000ffff, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x023102dc, 0x00000000, 0x046205b8, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xfd870924, 0xfff57fff, 0xfb189249, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x07fa000f, 0xfffc001f, 0x0ff8fffe, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xb0ff0000, 0xe1fd0000, 0x80000000, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x3fff3be1, 0x7ffff801, 0xffff7fc0, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xc007ffe4, 0xc007ffe4, 0xc007ffe4, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xede476db, 0xfbc67fff, 0xe0016db6, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0xbffefe68, 0x8000fffb, 0xfffcfcd5, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x0001bffc, 0x00018000, 0x0001fff8, 0x0, 0x0
	dspck_dstio addqh_r.ph, 0x0000ffda, 0xffffffd4, 0x0000ffe0, 0x0, 0x0

	writemsg "[41] Test subqh.ph"
	dspck_dstio subqh.ph, 0xffb9d590, 0xff620075, 0xfff05555, 0x0, 0x0
	dspck_dstio subqh.ph, 0xdb6ec05f, 0xb6db807f, 0xffffffc0, 0x0, 0x0
	dspck_dstio subqh.ph, 0x00000000, 0x7fff0000, 0x7fff0000, 0x0, 0x0
	dspck_dstio subqh.ph, 0xfc01ffff, 0xf803fffe, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x410507b2, 0x021aff6b, 0x800ff007, 0x0, 0x0
	dspck_dstio subqh.ph, 0xbff9006b, 0x800000d4, 0x000dfffd, 0x0, 0x0
	dspck_dstio subqh.ph, 0xf8040000, 0x00007fff, 0x0ff87fff, 0x0, 0x0
	dspck_dstio subqh.ph, 0x1c2cfff8, 0x2db40000, 0xf55b000f, 0x0, 0x0
	dspck_dstio subqh.ph, 0x3ff8a054, 0x7fffc0a8, 0x000f7fff, 0x0, 0x0
	dspck_dstio subqh.ph, 0xc0003fff, 0x00007fff, 0x7fff0000, 0x0, 0x0
	dspck_dstio subqh.ph, 0xfff5eff7, 0xfff1ffec, 0x00061ffe, 0x0, 0x0
	dspck_dstio subqh.ph, 0xff80bff6, 0x0000ffec, 0x00ff7fff, 0x0, 0x0
	dspck_dstio subqh.ph, 0xfff10000, 0xffe18000, 0xfffe8000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x1000fcb7, 0x3ffeff00, 0x1ffe0591, 0x0, 0x0
	dspck_dstio subqh.ph, 0x002038e4, 0x00000000, 0xffc08e38, 0x0, 0x0
	dspck_dstio subqh.ph, 0xbffd4004, 0xfffa0009, 0x7fff8000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x0002ffef, 0x0000ffe0, 0xfffb0001, 0x0, 0x0
	dspck_dstio subqh.ph, 0x0000079a, 0x00000f7d, 0x00000049, 0x0, 0x0
	dspck_dstio subqh.ph, 0x0000c56c, 0x80000ad7, 0x80007fff, 0x0, 0x0
	dspck_dstio subqh.ph, 0x07ff3f83, 0x0ffe7fff, 0x000000f9, 0x0, 0x0
	dspck_dstio subqh.ph, 0xbf5f0000, 0x801f0000, 0x01610000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x3fb9bbcd, 0xff738000, 0x80000865, 0x0, 0x0
	dspck_dstio subqh.ph, 0x0001f248, 0x0003e487, 0x0000fff7, 0x0, 0x0
	dspck_dstio subqh.ph, 0xc3fffe89, 0x80000000, 0xf80102ed, 0x0, 0x0
	dspck_dstio subqh.ph, 0x7fff31c7, 0x7fffe38e, 0x80008000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x038a01cc, 0x0315ff9a, 0xfc01fc01, 0x0, 0x0
	dspck_dstio subqh.ph, 0xc04643ff, 0x008b07fe, 0x7fff8000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x00005ffe, 0x00007fff, 0xffffc003, 0x0, 0x0
	dspck_dstio subqh.ph, 0x3fffc000, 0x7fff8000, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x56d70ffe, 0x3ff81ffc, 0x92490000, 0x0, 0x0
	dspck_dstio subqh.ph, 0xffff0001, 0x00000000, 0x0001fffe, 0x0, 0x0
	dspck_dstio subqh.ph, 0x00000000, 0xf81f7fff, 0xf81f7fff, 0x0, 0x0
	dspck_dstio subqh.ph, 0x35e20000, 0xfe0e0000, 0x92490000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x00000000, 0x0000fff9, 0x0000fff9, 0x0, 0x0
	dspck_dstio subqh.ph, 0xc000bff9, 0x0000fff1, 0x7fff7fff, 0x0, 0x0
	dspck_dstio subqh.ph, 0xc001fffa, 0x8002fff4, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x4603fffc, 0x7fff0000, 0xf3f80007, 0x0, 0x0
	dspck_dstio subqh.ph, 0xffff41f5, 0xffff03eb, 0x00008000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x000050ae, 0x80007fff, 0x8000dea2, 0x0, 0x0
	dspck_dstio subqh.ph, 0xfffeff46, 0xfffcfe8d, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x266601ff, 0x7fff0000, 0x3333fc01, 0x0, 0x0
	dspck_dstio subqh.ph, 0xf081c04c, 0x00fa0098, 0x1ff87fff, 0x0, 0x0
	dspck_dstio subqh.ph, 0x3fe00c4a, 0x7ffffff5, 0x003fe760, 0x0, 0x0
	dspck_dstio subqh.ph, 0x7fffe022, 0x7fffc03f, 0x8000fffa, 0x0, 0x0
	dspck_dstio subqh.ph, 0x47ff3ff8, 0x7fff0000, 0xf001800f, 0x0, 0x0
	dspck_dstio subqh.ph, 0x40d2f007, 0x01a5e00f, 0x80000000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x00407fff, 0x00017fff, 0xff808000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x4003ff3a, 0x7fffff1a, 0xfff800a5, 0x0, 0x0
	dspck_dstio subqh.ph, 0xffff0e6f, 0xfffe1cd7, 0x0000fff8, 0x0, 0x0
	dspck_dstio subqh.ph, 0x8002c035, 0x8003006a, 0x7fff7fff, 0x0, 0x0
	dspck_dstio subqh.ph, 0x8000bff8, 0x80008000, 0x7fff000f, 0x0, 0x0
	dspck_dstio subqh.ph, 0xbfed0000, 0xffda0000, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh.ph, 0xc0004ffc, 0x80001ff8, 0x00008000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x40030062, 0x7fff00c3, 0xfff9ffff, 0x0, 0x0
	dspck_dstio subqh.ph, 0x00000010, 0x00000000, 0x0000ffe0, 0x0, 0x0
	dspck_dstio subqh.ph, 0x03fec010, 0x00000000, 0xf8037fe0, 0x0, 0x0
	dspck_dstio subqh.ph, 0xfa8303ff, 0xf5040000, 0xfffef801, 0x0, 0x0
	dspck_dstio subqh.ph, 0xfffdff7c, 0x80000000, 0x80060107, 0x0, 0x0
	dspck_dstio subqh.ph, 0xbf96dc72, 0xff2b8000, 0x7fffc71c, 0x0, 0x0
	dspck_dstio subqh.ph, 0x30070002, 0xe00f0004, 0x80000000, 0x0, 0x0
	dspck_dstio subqh.ph, 0xc000e003, 0x8000c007, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x0000c925, 0x00000000, 0x00006db6, 0x0, 0x0
	dspck_dstio subqh.ph, 0x00000000, 0xfff90000, 0xfff90000, 0x0, 0x0
	dspck_dstio subqh.ph, 0xff15c713, 0xfe378e38, 0x000d0011, 0x0, 0x0
	dspck_dstio subqh.ph, 0xc01fffe0, 0x803f7fc0, 0x00007fff, 0x0, 0x0
	dspck_dstio subqh.ph, 0xfffefffd, 0xfffd0000, 0x00000006, 0x0, 0x0
	dspck_dstio subqh.ph, 0x3ffbffff, 0xfff7fffe, 0x8000ffff, 0x0, 0x0
	dspck_dstio subqh.ph, 0x0ffe00bd, 0x1ffc017a, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x0000e669, 0x8000cccc, 0x8000fffa, 0x0, 0x0
	dspck_dstio subqh.ph, 0xffff3fff, 0xfffffffe, 0x00008000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x7ffc39b4, 0x7ff8f369, 0x80008000, 0x0, 0x0
	dspck_dstio subqh.ph, 0xf805c000, 0x00038000, 0x0ff80000, 0x0, 0x0
	dspck_dstio subqh.ph, 0xbfff00aa, 0x8000016a, 0x00020015, 0x0, 0x0
	dspck_dstio subqh.ph, 0xebfe0001, 0xdb6d0000, 0x0370fffe, 0x0, 0x0
	dspck_dstio subqh.ph, 0x00002000, 0x00007ff8, 0x00003ff8, 0x0, 0x0
	dspck_dstio subqh.ph, 0x3f7e0040, 0xfefc007f, 0x8000fffe, 0x0, 0x0
	dspck_dstio subqh.ph, 0x3fbf08e1, 0x7f8011c1, 0x0001fffe, 0x0, 0x0
	dspck_dstio subqh.ph, 0xc004dffe, 0x80078000, 0xfffec003, 0x0, 0x0
	dspck_dstio subqh.ph, 0xfe10f010, 0xfc270000, 0x00061fe0, 0x0, 0x0
	dspck_dstio subqh.ph, 0x1ffdfffb, 0xfffe0006, 0xc003000f, 0x0, 0x0
	dspck_dstio subqh.ph, 0x00000000, 0xfff60000, 0xfff60000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x40073fff, 0x7fff7fff, 0xfff00000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x07ffc96a, 0x0ffe8001, 0x0000ed2d, 0x0, 0x0
	dspck_dstio subqh.ph, 0xc000f47d, 0x00000000, 0x7fff1706, 0x0, 0x0
	dspck_dstio subqh.ph, 0x005d4000, 0x003b0001, 0xff808000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x00cefbfd, 0x005ff803, 0xfec30008, 0x0, 0x0
	dspck_dstio subqh.ph, 0xfffe3fff, 0xfffc7fff, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x80000400, 0x800007fe, 0x7ffffffe, 0x0, 0x0
	dspck_dstio subqh.ph, 0x3fffc003, 0x7fff0001, 0x00007ffa, 0x0, 0x0
	dspck_dstio subqh.ph, 0xc0001ff9, 0x00000002, 0x7fffc00f, 0x0, 0x0
	dspck_dstio subqh.ph, 0x407fc002, 0x7fff8000, 0xff00fffc, 0x0, 0x0
	dspck_dstio subqh.ph, 0x00000000, 0x001e007f, 0x001e007f, 0x0, 0x0
	dspck_dstio subqh.ph, 0x0e8cc02a, 0x1d1d0045, 0x00057ff0, 0x0, 0x0
	dspck_dstio subqh.ph, 0xffe11213, 0x00042492, 0x0042006b, 0x0, 0x0
	dspck_dstio subqh.ph, 0x8040f02f, 0x807fe01f, 0x7fffffc0, 0x0, 0x0
	dspck_dstio subqh.ph, 0xfef21ff2, 0xffc60024, 0x01e1c03f, 0x0, 0x0
	dspck_dstio subqh.ph, 0xc0033fbf, 0x8000fffe, 0xfffa807f, 0x0, 0x0
	dspck_dstio subqh.ph, 0x0000c000, 0x7fff8000, 0x7fff0000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x0801cffe, 0x000a8000, 0xf007e003, 0x0, 0x0
	dspck_dstio subqh.ph, 0xfffcdfd0, 0x3ff0ff80, 0x3ff83fe0, 0x0, 0x0
	dspck_dstio subqh.ph, 0xfff0233b, 0x7fe0e00f, 0x7fff9999, 0x0, 0x0
	dspck_dstio subqh.ph, 0x7fff00b2, 0x7fff016c, 0x80000007, 0x0, 0x0
	dspck_dstio subqh.ph, 0xbfb21ac0, 0x8000f582, 0x009cc001, 0x0, 0x0
	dspck_dstio subqh.ph, 0xddb81066, 0xe0031ffe, 0x2492ff31, 0x0, 0x0
	dspck_dstio subqh.ph, 0x400e2492, 0x7fff4924, 0xffe30000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x8001583e, 0x80017ff8, 0x7fffcf7b, 0x0, 0x0
	dspck_dstio subqh.ph, 0xffee4005, 0x001f000a, 0x00428000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x1ff4c34c, 0x7fe08000, 0x3ff8f967, 0x0, 0x0
	dspck_dstio subqh.ph, 0x1555ffe8, 0x7fffffff, 0x5555002f, 0x0, 0x0
	dspck_dstio subqh.ph, 0x1fdd1ff0, 0x3fc00000, 0x0006c01f, 0x0, 0x0
	dspck_dstio subqh.ph, 0xfbfe8040, 0xfff8807f, 0x07fc7fff, 0x0, 0x0
	dspck_dstio subqh.ph, 0xc02d7fdf, 0x80007fc0, 0xffa68001, 0x0, 0x0
	dspck_dstio subqh.ph, 0x0139216e, 0x02723fc0, 0x0000fce3, 0x0, 0x0
	dspck_dstio subqh.ph, 0xbfc03eec, 0x80007fff, 0x007f0227, 0x0, 0x0
	dspck_dstio subqh.ph, 0x7fffd556, 0x7fff0002, 0x80005555, 0x0, 0x0
	dspck_dstio subqh.ph, 0x0fa88000, 0x1c718000, 0xfd207fff, 0x0, 0x0
	dspck_dstio subqh.ph, 0xe492c924, 0x8000db6d, 0xb6db4924, 0x0, 0x0
	dspck_dstio subqh.ph, 0xc000c71c, 0x80018e38, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x0003300f, 0x00077fff, 0x00001fe0, 0x0, 0x0
	dspck_dstio subqh.ph, 0x3fc0400f, 0xff807fff, 0x8000ffe0, 0x0, 0x0
	dspck_dstio subqh.ph, 0xb005c040, 0xe0030000, 0x7ff87f80, 0x0, 0x0
	dspck_dstio subqh.ph, 0xf165ffdc, 0x000000b6, 0x1d3500fe, 0x0, 0x0
	dspck_dstio subqh.ph, 0xffffd369, 0x00000d39, 0x00016666, 0x0, 0x0
	dspck_dstio subqh.ph, 0xc000401f, 0x0000003f, 0x7fff8000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x38032ff7, 0xf0071ffe, 0x8000c00f, 0x0, 0x0
	dspck_dstio subqh.ph, 0xf1b00074, 0x035e00e8, 0x1ffe0000, 0x0, 0x0
	dspck_dstio subqh.ph, 0xe02004ba, 0x0000097e, 0x3fc00009, 0x0, 0x0
	dspck_dstio subqh.ph, 0x7fffdb6d, 0x7fffb6db, 0x80000001, 0x0, 0x0
	dspck_dstio subqh.ph, 0xfa49ff47, 0x048efe8e, 0x0ffc0000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x00038000, 0x7fff8000, 0x7ff87fff, 0x0, 0x0
	dspck_dstio subqh.ph, 0xb1c7e8f3, 0xe38ed1f6, 0x7fff000f, 0x0, 0x0
	dspck_dstio subqh.ph, 0x07883fff, 0x0000fffe, 0xf0f08000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x00000000, 0xc03f6666, 0xc03f6666, 0x0, 0x0
	dspck_dstio subqh.ph, 0x1d7b0fe7, 0xfffcffd0, 0xc505e001, 0x0, 0x0
	dspck_dstio subqh.ph, 0x39c53ff9, 0x7fff7fff, 0x0c74000d, 0x0, 0x0
	dspck_dstio subqh.ph, 0x36dbff90, 0x6db6ff3f, 0xffff001f, 0x0, 0x0
	dspck_dstio subqh.ph, 0xc71c4000, 0x00000000, 0x71c78000, 0x0, 0x0
	dspck_dstio subqh.ph, 0xc000fff0, 0x00008000, 0x7fff801f, 0x0, 0x0
	dspck_dstio subqh.ph, 0x3fc3c7ff, 0x00050ffe, 0x807f7fff, 0x0, 0x0
	dspck_dstio subqh.ph, 0xb002f2d7, 0xe0030001, 0x7fff1a53, 0x0, 0x0
	dspck_dstio subqh.ph, 0x00001800, 0x7fff3ffc, 0x7fff0ffc, 0x0, 0x0
	dspck_dstio subqh.ph, 0x4ff837ae, 0x7fffef5c, 0xe00f8000, 0x0, 0x0
	dspck_dstio subqh.ph, 0xffb2f001, 0xff67fffb, 0x00031ff8, 0x0, 0x0
	dspck_dstio subqh.ph, 0x00000001, 0x00000000, 0x0000fffe, 0x0, 0x0
	dspck_dstio subqh.ph, 0x40070000, 0x7ffffffe, 0xfff0fffe, 0x0, 0x0
	dspck_dstio subqh.ph, 0xfffd1fff, 0x00000000, 0x0006c001, 0x0, 0x0
	dspck_dstio subqh.ph, 0x00000000, 0x3e278000, 0x3e278000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x401cc001, 0x7ffc0000, 0xffc47ffd, 0x0, 0x0
	dspck_dstio subqh.ph, 0xdd03009b, 0xe01f0143, 0x2619000c, 0x0, 0x0
	dspck_dstio subqh.ph, 0xc0293b91, 0x807ff723, 0x002d8000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x7fffe34e, 0x7fffc71c, 0x8000007f, 0x0, 0x0
	dspck_dstio subqh.ph, 0xc0403fff, 0x80000000, 0xff808001, 0x0, 0x0
	dspck_dstio subqh.ph, 0xf5640921, 0xeac89249, 0x00008006, 0x0, 0x0
	dspck_dstio subqh.ph, 0x3ffe6492, 0xfffd4924, 0x80008000, 0x0, 0x0
	dspck_dstio subqh.ph, 0xdffc0000, 0x3ff80000, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh.ph, 0x3ff7ce39, 0x7fff8000, 0x0011e38e, 0x0, 0x0
	dspck_dstio subqh.ph, 0x4ff0e003, 0x7fffc007, 0xe01f0000, 0x0, 0x0
	dspck_dstio subqh.ph, 0xff1a300d, 0xffff7ffa, 0x01ca1fe0, 0x0, 0x0
	dspck_dstio subqh.ph, 0x8000fc02, 0x80000000, 0x7fff07fc, 0x0, 0x0
	dspck_dstio subqh.ph, 0x004e5fff, 0x009c3ffe, 0x00008000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x3ffdbfe2, 0x7ffa8000, 0x0000003b, 0x0, 0x0
	dspck_dstio subqh.ph, 0x4039401c, 0x00727fff, 0x8000ffc7, 0x0, 0x0
	dspck_dstio subqh.ph, 0x5ff80003, 0x7fff0004, 0xc00ffffd, 0x0, 0x0
	dspck_dstio subqh.ph, 0x3fff1ff0, 0xffff3fe0, 0x80000000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x00003f61, 0x7ffffec3, 0x7fff8000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x0000ffe7, 0x00000000, 0x00000031, 0x0, 0x0
	dspck_dstio subqh.ph, 0xff9b1b6b, 0xff36b6db, 0xffff8004, 0x0, 0x0
	dspck_dstio subqh.ph, 0xfffe4000, 0x00000000, 0x00048000, 0x0, 0x0
	dspck_dstio subqh.ph, 0xffc0fff8, 0x00000000, 0x007f000f, 0x0, 0x0
	dspck_dstio subqh.ph, 0xc001bffb, 0x0001fff5, 0x7fff7fff, 0x0, 0x0
	dspck_dstio subqh.ph, 0x004009a1, 0x0001e00f, 0xff80cccc, 0x0, 0x0
	dspck_dstio subqh.ph, 0xbffccffc, 0xfff88000, 0x7fffe007, 0x0, 0x0
	dspck_dstio subqh.ph, 0x0044ff08, 0x0246fe10, 0x01bdffff, 0x0, 0x0
	dspck_dstio subqh.ph, 0x4913f1b5, 0x7ff80000, 0xedd11c95, 0x0, 0x0
	dspck_dstio subqh.ph, 0x07847fff, 0xfff87fff, 0xf0f08000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x00000000, 0x80000000, 0x80000000, 0x0, 0x0
	dspck_dstio subqh.ph, 0xf8274000, 0xf0940000, 0x00458000, 0x0, 0x0
	dspck_dstio subqh.ph, 0xfe61ddba, 0xfcc0e007, 0xfffe2492, 0x0, 0x0
	dspck_dstio subqh.ph, 0xe6661f87, 0xccccff10, 0xffffc001, 0x0, 0x0
	dspck_dstio subqh.ph, 0x32480394, 0x24920728, 0xc0010000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x04007fff, 0x00017fff, 0xf8018000, 0x0, 0x0
	dspck_dstio subqh.ph, 0xfbb8ffff, 0xf5e9fffd, 0xfe79fffe, 0x0, 0x0
	dspck_dstio subqh.ph, 0x1ffec05e, 0x3ffc00bc, 0x00007fff, 0x0, 0x0
	dspck_dstio subqh.ph, 0x3ffffff3, 0x7fff8006, 0x0000801f, 0x0, 0x0
	dspck_dstio subqh.ph, 0x20070000, 0xc00f0000, 0x8000ffff, 0x0, 0x0
	dspck_dstio subqh.ph, 0x000010fa, 0x000021f5, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x00000000, 0x8000fe19, 0x8000fe19, 0x0, 0x0
	dspck_dstio subqh.ph, 0x7fff3fff, 0x7fffffff, 0x80008000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x1fab0145, 0x3f57028a, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x20004001, 0x7fff0002, 0x3ffe8000, 0x0, 0x0
	dspck_dstio subqh.ph, 0xff59c000, 0xfeb38001, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.ph, 0xbbd31c71, 0x800038e3, 0x085a0000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x00013ffd, 0x00000000, 0xfffe8006, 0x0, 0x0
	dspck_dstio subqh.ph, 0xbffa067f, 0xfff4007f, 0x7ffff380, 0x0, 0x0
	dspck_dstio subqh.ph, 0xc0043ffe, 0x0007fffc, 0x7fff8000, 0x0, 0x0
	dspck_dstio subqh.ph, 0xfcd9f054, 0xf9badb6d, 0x0008fac4, 0x0, 0x0
	dspck_dstio subqh.ph, 0x4000b008, 0x00008000, 0x80001ff0, 0x0, 0x0
	dspck_dstio subqh.ph, 0xffd40000, 0x00048000, 0x005b8000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x1ff6003d, 0xfff00079, 0xc003fffe, 0x0, 0x0
	dspck_dstio subqh.ph, 0x3fff0000, 0x7fff0000, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.ph, 0xc00344c6, 0x8000098d, 0xfff98000, 0x0, 0x0
	dspck_dstio subqh.ph, 0xe661c004, 0xcccc0000, 0x000a7ff8, 0x0, 0x0
	dspck_dstio subqh.ph, 0xa02ff4ed, 0xc03fe9db, 0x7fe00000, 0x0, 0x0
	dspck_dstio subqh.ph, 0xf0010000, 0xe0030000, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.ph, 0xc020b6db, 0x8000db6d, 0xffc06db6, 0x0, 0x0
	dspck_dstio subqh.ph, 0x3feaedb6, 0x7ffadb6d, 0x00260000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x00750004, 0x007f0000, 0xff94fff8, 0x0, 0x0
	dspck_dstio subqh.ph, 0x4ffcefbf, 0x7ffffc01, 0xe0071c82, 0x0, 0x0
	dspck_dstio subqh.ph, 0x00003fff, 0x7fff7fff, 0x7fff0000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x00000000, 0x01457fff, 0x01457fff, 0x0, 0x0
	dspck_dstio subqh.ph, 0x36b70001, 0xed6f001f, 0x8000001d, 0x0, 0x0
	dspck_dstio subqh.ph, 0x0403c239, 0x07fc8000, 0xfff6fb8d, 0x0, 0x0
	dspck_dstio subqh.ph, 0xfdf9a001, 0xfff08000, 0x03fe3ffe, 0x0, 0x0
	dspck_dstio subqh.ph, 0xbe32d555, 0x8000aaaa, 0x039c0000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x3f864008, 0xff0d0010, 0x80008000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x00003ffd, 0x00000000, 0x00008006, 0x0, 0x0
	dspck_dstio subqh.ph, 0xe003c000, 0xc0078000, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x00007fff, 0x7fff7fff, 0x7fff8000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x4fd0f820, 0x7fc0003d, 0xe01f0ffc, 0x0, 0x0
	dspck_dstio subqh.ph, 0x7333fffc, 0x66660000, 0x80000008, 0x0, 0x0
	dspck_dstio subqh.ph, 0xfff7048b, 0xfff50000, 0x0006f6e9, 0x0, 0x0
	dspck_dstio subqh.ph, 0xbf4a4000, 0x80060000, 0x01718000, 0x0, 0x0
	dspck_dstio subqh.ph, 0xbc0301b9, 0x80050006, 0x07fefc93, 0x0, 0x0
	dspck_dstio subqh.ph, 0xff98ffff, 0x00048000, 0x00d38002, 0x0, 0x0
	dspck_dstio subqh.ph, 0x24707fff, 0x0ffc7fff, 0xc71c8001, 0x0, 0x0
	dspck_dstio subqh.ph, 0xc801c001, 0x8004ffff, 0xf0017ffc, 0x0, 0x0
	dspck_dstio subqh.ph, 0xffc4ffbf, 0x0000fffe, 0x0077007f, 0x0, 0x0
	dspck_dstio subqh.ph, 0xc0477fff, 0x007f7fff, 0x7ff08000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x001fb971, 0x803f8000, 0x80000d1d, 0x0, 0x0
	dspck_dstio subqh.ph, 0x0083c011, 0x00098000, 0xff03ffdd, 0x0, 0x0
	dspck_dstio subqh.ph, 0x3ffdf001, 0x7fffe003, 0x00040000, 0x0, 0x0
	dspck_dstio subqh.ph, 0x3ffe1fe0, 0xfffd3fc0, 0x80000000, 0x0, 0x0
	dspck_dstio subqh.ph, 0xfff2d000, 0x00011ffe, 0x001d7ffd, 0x0, 0x0
	dspck_dstio subqh.ph, 0x0e5836e6, 0x003f7fff, 0xe38e1232, 0x0, 0x0
	dspck_dstio subqh.ph, 0x00803330, 0x00ff6666, 0xffff0006, 0x0, 0x0

	writemsg "[42] Test subqh_r.ph"
	dspck_dstio subqh_r.ph, 0xbfe10af9, 0x8000cccc, 0x003fb6db, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xc01cffe0, 0x0036ffc0, 0x7fff0000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xe01d3010, 0xc03f7fff, 0x00051fe0, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x40002002, 0x0000c003, 0x80008000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xeee1fffe, 0xfdba8000, 0x1ff88005, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x4002c000, 0x00038000, 0x80000000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x40004000, 0x7fff7fff, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xc9250003, 0x0000fff8, 0x6db6fff3, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x43ff1b6e, 0x7fffb6db, 0xf8018000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x00010bbb, 0x0000ff00, 0xffffe78a, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x00000000, 0xf0030000, 0xf0030000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x4001c004, 0x00028000, 0x8000fff9, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xc041feea, 0x807ffdd4, 0xfffd0000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xf87cfffc, 0x0007fff8, 0x0f0f0000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xc001003b, 0x80000000, 0xffffff8a, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x4000ffff, 0x7ffffffe, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xc0010000, 0x00018000, 0x7fff8000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x3ffdc000, 0x00008000, 0x80060001, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xfff32b09, 0xffe5d611, 0x00008000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x00133fff, 0xfff5fffe, 0xffcf8000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x0000ffe1, 0x00008000, 0x0000803f, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xd99a3c01, 0x3333f801, 0x7fff8000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x0002dfb4, 0x0003c01f, 0x000000b7, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x0855c001, 0x07560000, 0xf6ad7fff, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x4001bff1, 0x7fff8000, 0xfffe001f, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x0259ffff, 0x2492fffe, 0x1fe00000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x4fffc008, 0x1ffe000e, 0x80007fff, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xc0404080, 0x80007fff, 0xff80ff00, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xc008fe03, 0x800ffc01, 0x0000fffb, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x19ae1ff1, 0x33333fe0, 0xffd7fffe, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x0001f802, 0x0000fffc, 0xfffe0ff8, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x163ecf4f, 0xfffe8004, 0xd382e167, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x1ff80041, 0x3ff00001, 0x0000ff80, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x11aff017, 0x036ce01f, 0xe00ffff1, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xf4fafc17, 0xe9f3fc01, 0x000003d4, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x4000db6d, 0x0000b6db, 0x80000002, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x0fac3801, 0x1f557fff, 0xfffe0ffe, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xffff0000, 0xfffc0000, 0xfffe0000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x2038bf0f, 0x3ffcfe1c, 0xff8d7fff, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x00012010, 0x0002c01f, 0x00008000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xffc10000, 0xff808000, 0xffff8001, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xbe03fff0, 0xfc01fffb, 0x7ffb001c, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x0003011d, 0x0002fc82, 0xfffdfa48, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xc0000000, 0x80000000, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xfb364ffc, 0xf8011ff8, 0x01968000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xbaf74003, 0xf5e57fff, 0x7ff8fffa, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x40001ff1, 0x00000000, 0x8000c01f, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x0000ebf5, 0x0000fffd, 0x00002813, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xe003f1c7, 0xc007fffe, 0x00021c71, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xfc01ffff, 0x0000fffd, 0x07fe0000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xc2000062, 0x03fefffd, 0x7fffff3a, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xbffd4035, 0xfff8006a, 0x7fff8000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x031f0020, 0x0636ffff, 0xfff9ffc0, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xc045bf41, 0x807f8001, 0xfff60180, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x0000045a, 0x7fff01f5, 0x7ffff941, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xfccef02c, 0x00030050, 0x06671ff8, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x36dccff1, 0x00011fe0, 0x92497fff, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xf009c020, 0x00018000, 0x1ff0ffc0, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xd55900ae, 0x00060004, 0x5555fea8, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xe00a18f7, 0x00043333, 0x3ff00145, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x4040c00f, 0x007f801f, 0x80000002, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x5ffcc018, 0x7fff001f, 0xc0077ff0, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x3ffcf018, 0x7fffe01f, 0x0007fff0, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x0000f30d, 0x7fffe61a, 0x7fff0000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xfff90000, 0xfff10000, 0x00000001, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x00000000, 0x7fffff71, 0x7fffff71, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x38023fe1, 0x7fff7fc0, 0x0ffcfffe, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xa004f816, 0x80000029, 0x3ff80ffe, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x80010006, 0x8000ffcc, 0x7fffffc0, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xbf4b000b, 0xfe85fffd, 0x7ff0ffe7, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x80010000, 0x80007fff, 0x7fff7fff, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x7fe00ffd, 0x7fc00ffc, 0x8001f003, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x00000000, 0x71c77fff, 0x71c77fff, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xfe33c023, 0xfc6b8000, 0x0005ffbb, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xd812124a, 0xf0030000, 0x3fe0db6d, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xfe88b804, 0x00018000, 0x02f10ff8, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xc00ec788, 0x80000f0f, 0xffe47fff, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xcffdbfff, 0x80008001, 0xe0070004, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x31c7407f, 0x7fff7fff, 0x1c71ff02, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xfffef1c8, 0xfffb0000, 0xffff1c71, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x08341001, 0x00691ffe, 0xf001fffc, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x436f4000, 0x06de7fff, 0x80000000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x4000fd9b, 0x7fff0000, 0xffff04cb, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x00150000, 0x001f7fff, 0xfff57fff, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x010fc090, 0x02210119, 0x00037ff9, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x3fe2f969, 0x7ffff243, 0x003cff71, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xff8dd001, 0x00058003, 0x00ece001, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x0071ffc1, 0x00e50001, 0x0004007f, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xf0100002, 0xe01f0003, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x3bfdd03f, 0xf8011ffe, 0x80077f80, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xc78b0000, 0x0f0f7ffe, 0x7ff97fff, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x0110c001, 0x00000000, 0xfde17fff, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xff5f05ff, 0xfbf30ffc, 0xfd3503fe, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x400ff802, 0x0021ffff, 0x80040ffc, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x8003014b, 0x80020064, 0x7ffcfdcf, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x3334ffef, 0x0001fffa, 0x9999001d, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x0ccda760, 0x9999800f, 0x8000314f, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x80000060, 0x7fff003f, 0x8000ff80, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x00134000, 0x00057fff, 0xffe00000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x4000c001, 0x00000000, 0x80007fff, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x00000000, 0xfc260a01, 0xfc260a01, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x1ff8a00a, 0xffff800f, 0xc00f3ffc, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x1fe81ff2, 0xffef3fe0, 0xc01ffffc, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x199ad555, 0x0000aaaa, 0xcccc0000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xf9d878e4, 0x03ac71c7, 0x0ffc8000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xc46a0002, 0x08cd8004, 0x7ff98000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xbffe3ffe, 0x80000000, 0x00058005, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xc0313ff9, 0x80007fff, 0xff9e000d, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xffefeaab, 0xffdd5555, 0xffff7fff, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x0ec2bfff, 0xfd92fffd, 0xe00f7fff, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x0002fff1, 0xffffffff, 0xfffc001e, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xc0038000, 0x80057fff, 0x00008000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xc0013ffc, 0x0000fff8, 0x7fff8000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xc0234010, 0x0025001f, 0x7fe08000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xbf40bfff, 0x80008000, 0x01800002, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x3f800001, 0x7fff0000, 0x00ffffff, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x0000c001, 0xffff8000, 0x0000ffff, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xfffcc000, 0x0007ffff, 0x000f7fff, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xfea80000, 0xfd500000, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xff802010, 0xff007fff, 0x00003fe0, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xeff5eb71, 0xffe6d6ce, 0x1ffcffec, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x40f2fff9, 0x02230000, 0x803f000f, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xc0dcf2b3, 0x01b70001, 0x7fff1a9b, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x00070000, 0x10090000, 0x0ffc0000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xf2df8003, 0xe0038000, 0xfa467ffa, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x0000f010, 0x7fffe01f, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xf8983eb9, 0xf130fd72, 0x00008000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x02b0dffa, 0x0520c003, 0xffc10010, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xdb6e0000, 0x00000000, 0x49240000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x3ffc1ef1, 0x7ff03fe0, 0xfff801ff, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xff9cc000, 0x00028000, 0x00ca0000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xc002eda9, 0x8000db6d, 0xfffc001b, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x4788bffd, 0x7fff8000, 0xf0f00007, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xf1fbffe1, 0x00660000, 0x1c71003f, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x3bffdcec, 0x7ffcf2bb, 0x07fe38e3, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x003dfbfd, 0x0003fae4, 0xff8902ea, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x03ff871d, 0x07fe8e38, 0x00007fff, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x1b6ad805, 0x7ff8c001, 0x49240ff8, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x00dd4004, 0x00000007, 0xfe468000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x0c5c0200, 0x18b70000, 0x0000fc01, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x00004748, 0xffff0f0f, 0x0000807f, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x0c850000, 0xfc970000, 0xe38e0000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x0001fff9, 0x00007ff0, 0xfffe7fff, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x0006f001, 0x000ae003, 0xfffe0002, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xe010fe01, 0x00000000, 0x3fe003fe, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x80043fe1, 0x80070000, 0x7fff803f, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x1e6ef01d, 0x38e30038, 0xfc081ffe, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xbf81c000, 0xff008000, 0x7fff0000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xf9013fff, 0xf2017fff, 0x00000002, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x00040000, 0x00020000, 0xfffb0000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xf739c001, 0xfe4a8000, 0x0fd8fffe, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xc000ffeb, 0x8000ffd6, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x016fe38f, 0x00000000, 0xfd2338e3, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xf5623fed, 0xf36dffe0, 0x08a98007, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x0000e390, 0x0000c71c, 0x0000fffc, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x0002c000, 0x7fff8000, 0x7ffc0000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xb87a1ffb, 0x80033ffe, 0x0f0f0009, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x5ffcff86, 0x3ff80001, 0x800000f6, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xfffe47fc, 0x80007fff, 0x8005f007, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x00030008, 0x0006000f, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x7ffef7c5, 0x7ffbff80, 0x80000ff7, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xf7bc0006, 0x00000000, 0x1089fff5, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x8000ffea, 0x7fffffea, 0x80000016, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xebebc0db, 0xfff901b5, 0x28247fff, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x0000c005, 0x7fff0003, 0x7fff7ff9, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x5fe04000, 0x3fc00000, 0x80008000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xf009c002, 0x00010000, 0x1ff07ffc, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x0000b39e, 0xffffe73b, 0x00007fff, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x40004000, 0x7fff7fff, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x00000000, 0xe01f807f, 0xe01f807f, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xbf5c03ff, 0x800007fe, 0x01480000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x871ded35, 0x8e38e01f, 0x7fff05b6, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x01a70033, 0x00d70000, 0xfd89ff9b, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x0003c000, 0x0000fffe, 0xfffa7fff, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xffce3334, 0x00010000, 0x00669999, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xfff10020, 0x00007fff, 0x001f7fc0, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x36dfc010, 0x00060000, 0x92497fe0, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x00122020, 0x0024c03f, 0x00008000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xff664001, 0xfdcc0001, 0xff008000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x0ccdb503, 0x9999ea04, 0x80007fff, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x3ffec012, 0xfffc8007, 0x8000ffe3, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xc001bf75, 0x0000807f, 0x7fff0195, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x3ffd404d, 0x7ffa0099, 0x00008000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x00001009, 0xffff1ff8, 0x0000ffe6, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xbffc3002, 0xfff77fff, 0x7fff1ffc, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xbfc5f003, 0xff88e007, 0x7fff0002, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xb8010000, 0xf001fff8, 0x7ffffff9, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xfc0a07bd, 0x0012ff80, 0x07fef007, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xe0001231, 0xc00f0465, 0x000fe003, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xffe3c003, 0xffc48000, 0xfffefffa, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x3d660197, 0x7fff0087, 0x0534fd5a, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xbff40820, 0x80000ff8, 0x0019ffb9, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xf2b25ffd, 0xe64a7ffd, 0x00e7c003, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x406af00c, 0x00d40008, 0x80001ff0, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x00000000, 0x7fff0002, 0x7fff0002, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x3f0affec, 0x7fff0001, 0x01ec0029, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x5ffcfffd, 0x3ff80000, 0x80000006, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xc0434000, 0x80000000, 0xff7a8000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x00003ffe, 0x8000fffb, 0x80008000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x0ffbe38e, 0xfff9c71c, 0xe0030000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xc1740000, 0x80060000, 0xfd1e0000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x46cc1ff7, 0x1fe0fffd, 0x9249c00f, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xffe4f164, 0x0000e622, 0x0038035b, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xc00001ff, 0x800003fe, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xdffeff34, 0xc001fff6, 0x0006018e, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x1c72ffb9, 0x0000fff0, 0xc71c007f, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x40690fee, 0x7fffffea, 0xff2ee00f, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xbfece010, 0xffd7c01f, 0x7fff0000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x3c021b6e, 0xf803b6db, 0x80008000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x00001e31, 0x7ffe1c71, 0x7fffe00f, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x40000001, 0x00000000, 0x8000ffff, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x01230000, 0x00000000, 0xfdba0000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x40004001, 0x7fff0002, 0x00008000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x3fe8c402, 0x7fff8004, 0x002ff801, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x80102004, 0x801f7fff, 0x7fff3ff8, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xfc27fffe, 0xf853fffc, 0x00060000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x5ffc3ffd, 0x7ffa7fff, 0xc0030006, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xf666f327, 0x1ffee64d, 0x33330000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x0fc800df, 0xff9701bd, 0xe0070000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x00000000, 0x0000ffff, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x09234000, 0x92497fff, 0x8003ffff, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x40623d6b, 0x7ffffb54, 0xff3c807f, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x0010fbe9, 0x001ff803, 0xffff0032, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x9b6e4000, 0x80000000, 0x49248000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x3ffc0000, 0x7ff80000, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x00770000, 0xfff57fff, 0xff077fff, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x8002c046, 0x8002000c, 0x7fff7f80, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xf61d3f3b, 0x00047fff, 0x13cb018a, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x4fff4017, 0x7fff7fff, 0xe001ffd1, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xffee0000, 0xffd60000, 0xfffa0000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x6a9b0725, 0x7fe00e4c, 0xaaaa0002, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x3ffd11ed, 0x7fffff47, 0x0006db6d, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xfffddfff, 0xffffc001, 0x00060004, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xdb6bbfdd, 0xfffa803f, 0x49240086, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x00000000, 0x80000000, 0x80000000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xf6f3bf06, 0xede6fe0b, 0x00007fff, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x00002d33, 0x00001a66, 0x0000c001, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x2f30c0b2, 0xde608000, 0x8000fe9c, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x1c1f0022, 0x383e0044, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0xf004dc22, 0xe007f83b, 0x00003ff8, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x000000c8, 0x0000007f, 0x0000feef, 0x0, 0x0
	dspck_dstio subqh_r.ph, 0x3940ff95, 0x71c7fffd, 0xff4800d3, 0x0, 0x0

	writemsg "[43] Test addqh.w"
	dspck_dstio addqh.w, 0xff6f3d59, 0x00000000, 0xfede7ab3, 0x0, 0x0
	dspck_dstio addqh.w, 0x0203217d, 0x000642fd, 0x03fffffe, 0x0, 0x0
	dspck_dstio addqh.w, 0x40000001, 0x7fffffff, 0x00000003, 0x0, 0x0
	dspck_dstio addqh.w, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.w, 0xc0000000, 0x00000000, 0x80000000, 0x0, 0x0
	dspck_dstio addqh.w, 0xfffff48f, 0xffffe920, 0xffffffff, 0x0, 0x0
	dspck_dstio addqh.w, 0xffffffff, 0x80000000, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh.w, 0xfff71220, 0xffee1fbf, 0x00000481, 0x0, 0x0
	dspck_dstio addqh.w, 0x3fffffff, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.w, 0xfffffffa, 0xfffffffa, 0xfffffffb, 0x0, 0x0
	dspck_dstio addqh.w, 0xfffffffe, 0x00000000, 0xfffffffc, 0x0, 0x0
	dspck_dstio addqh.w, 0xfffffc9d, 0x00000000, 0xfffff93b, 0x0, 0x0
	dspck_dstio addqh.w, 0xbfffffae, 0x80000000, 0xffffff5c, 0x0, 0x0
	dspck_dstio addqh.w, 0xffffffff, 0x7fffffff, 0x80000000, 0x0, 0x0
	dspck_dstio addqh.w, 0xbffffdc5, 0x80000000, 0xfffffb8a, 0x0, 0x0
	dspck_dstio addqh.w, 0xfe2cab6a, 0xfc600dbd, 0xfff94917, 0x0, 0x0
	dspck_dstio addqh.w, 0x1ffffff5, 0x3fffffe0, 0x0000000a, 0x0, 0x0
	dspck_dstio addqh.w, 0x00000045, 0x00000082, 0x00000008, 0x0, 0x0
	dspck_dstio addqh.w, 0xf8000001, 0x00000000, 0xf0000003, 0x0, 0x0
	dspck_dstio addqh.w, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.w, 0x1fffffc7, 0x7fffff80, 0xc000000f, 0x0, 0x0
	dspck_dstio addqh.w, 0xfffffb40, 0x00000000, 0xfffff681, 0x0, 0x0
	dspck_dstio addqh.w, 0x3fffffbf, 0x7fffff80, 0xfffffffe, 0x0, 0x0
	dspck_dstio addqh.w, 0xc7ffffff, 0x80000000, 0x0ffffffe, 0x0, 0x0
	dspck_dstio addqh.w, 0x00008065, 0x0000000d, 0x000100be, 0x0, 0x0
	dspck_dstio addqh.w, 0x80000002, 0x80000000, 0x80000004, 0x0, 0x0
	dspck_dstio addqh.w, 0x00000000, 0x00000000, 0x00000001, 0x0, 0x0
	dspck_dstio addqh.w, 0xf6db6df6, 0x6db6db6d, 0x8000007f, 0x0, 0x0
	dspck_dstio addqh.w, 0xc0000000, 0x00000000, 0x80000000, 0x0, 0x0
	dspck_dstio addqh.w, 0x0000024e, 0x00000000, 0x0000049d, 0x0, 0x0
	dspck_dstio addqh.w, 0x3ffff2a5, 0x7fffffff, 0xffffe54c, 0x0, 0x0
	dspck_dstio addqh.w, 0xfffffff8, 0x80000000, 0x7ffffff0, 0x0, 0x0
	dspck_dstio addqh.w, 0xc8000002, 0x80000007, 0x0ffffffe, 0x0, 0x0
	dspck_dstio addqh.w, 0x2aaaaaaa, 0x00000000, 0x55555555, 0x0, 0x0
	dspck_dstio addqh.w, 0x00000000, 0x00000001, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.w, 0xc0000000, 0x00000000, 0x80000000, 0x0, 0x0
	dspck_dstio addqh.w, 0xfef8701b, 0x00000000, 0xfdf0e037, 0x0, 0x0
	dspck_dstio addqh.w, 0xbfffde84, 0x8000007f, 0xffffbc89, 0x0, 0x0
	dspck_dstio addqh.w, 0x000001d6, 0x0000068d, 0xfffffd1f, 0x0, 0x0
	dspck_dstio addqh.w, 0x00000003, 0x00000000, 0x00000007, 0x0, 0x0
	dspck_dstio addqh.w, 0x32cb2cb2, 0x1c71c71c, 0x49249249, 0x0, 0x0
	dspck_dstio addqh.w, 0x00000003, 0x00000000, 0x00000007, 0x0, 0x0
	dspck_dstio addqh.w, 0x3fffffe0, 0xffffffe0, 0x7fffffe0, 0x0, 0x0
	dspck_dstio addqh.w, 0x80000000, 0x80000000, 0x80000000, 0x0, 0x0
	dspck_dstio addqh.w, 0x3ffffffd, 0xfffffffc, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh.w, 0xc0000000, 0x00000000, 0x80000000, 0x0, 0x0
	dspck_dstio addqh.w, 0x00000002, 0x00000000, 0x00000004, 0x0, 0x0
	dspck_dstio addqh.w, 0x078787a7, 0x0f0f0f0f, 0x0000003f, 0x0, 0x0
	dspck_dstio addqh.w, 0x0009a9ea, 0xffffffff, 0x001353d5, 0x0, 0x0
	dspck_dstio addqh.w, 0x3ffffffc, 0x7fffffff, 0xfffffffa, 0x0, 0x0
	dspck_dstio addqh.w, 0x40000000, 0x7ffffffc, 0x00000004, 0x0, 0x0
	dspck_dstio addqh.w, 0x0a1439fc, 0x009de2c8, 0x138a9131, 0x0, 0x0
	dspck_dstio addqh.w, 0x40000001, 0x00000003, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh.w, 0x00000004, 0x00000004, 0x00000004, 0x0, 0x0
	dspck_dstio addqh.w, 0x3ffffffc, 0x7ffffffe, 0xfffffffb, 0x0, 0x0
	dspck_dstio addqh.w, 0xedb6db6d, 0xdb6db6db, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.w, 0xdaee365b, 0xff00ff00, 0xb6db6db6, 0x0, 0x0
	dspck_dstio addqh.w, 0xc00ab1c0, 0x80000007, 0x00156379, 0x0, 0x0
	dspck_dstio addqh.w, 0xffffffff, 0x00000000, 0xffffffff, 0x0, 0x0
	dspck_dstio addqh.w, 0xf7fffffe, 0xf0000001, 0xfffffffb, 0x0, 0x0
	dspck_dstio addqh.w, 0xfffffe63, 0x00000000, 0xfffffcc7, 0x0, 0x0
	dspck_dstio addqh.w, 0xf7fffca4, 0xf0000007, 0xfffff942, 0x0, 0x0
	dspck_dstio addqh.w, 0x38e38e38, 0x38e38e38, 0x38e38e38, 0x0, 0x0
	dspck_dstio addqh.w, 0xffeddc38, 0xffdbb57e, 0x000002f2, 0x0, 0x0
	dspck_dstio addqh.w, 0x3fffc6eb, 0xffff8dd8, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh.w, 0x40000003, 0x7fffffff, 0x00000007, 0x0, 0x0
	dspck_dstio addqh.w, 0xdfffffe3, 0xffffffa7, 0xc000001f, 0x0, 0x0
	dspck_dstio addqh.w, 0xbff6e6d6, 0xffedcdac, 0x80000000, 0x0, 0x0
	dspck_dstio addqh.w, 0x2aaad101, 0x00004cae, 0x55555555, 0x0, 0x0
	dspck_dstio addqh.w, 0xff807fbf, 0xff00ff00, 0x0000007f, 0x0, 0x0
	dspck_dstio addqh.w, 0x3fffffff, 0x00000000, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh.w, 0xffffffe2, 0x80000004, 0x7fffffc0, 0x0, 0x0
	dspck_dstio addqh.w, 0x3ffffffe, 0x7fffffff, 0xfffffffe, 0x0, 0x0
	dspck_dstio addqh.w, 0xffffffff, 0x80000000, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh.w, 0xfe000000, 0xfc000001, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.w, 0x43fffffd, 0x07fffffc, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh.w, 0x002b158f, 0x00562b46, 0xffffffd8, 0x0, 0x0
	dspck_dstio addqh.w, 0xc0000002, 0x00000003, 0x80000001, 0x0, 0x0
	dspck_dstio addqh.w, 0x09fffffd, 0x0ffffffc, 0x03fffffe, 0x0, 0x0
	dspck_dstio addqh.w, 0x00000005, 0x00000005, 0x00000006, 0x0, 0x0
	dspck_dstio addqh.w, 0x087f807e, 0x00ff00ff, 0x0ffffffe, 0x0, 0x0
	dspck_dstio addqh.w, 0x3e8d552c, 0x7fffffff, 0xfd1aaa59, 0x0, 0x0
	dspck_dstio addqh.w, 0x0000006e, 0x0000003f, 0x0000009e, 0x0, 0x0
	dspck_dstio addqh.w, 0x400097ab, 0x00012f58, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh.w, 0xfffffffe, 0x7ffffffc, 0x80000000, 0x0, 0x0
	dspck_dstio addqh.w, 0x3fffffff, 0x00000000, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh.w, 0xff774142, 0xfeee8285, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.w, 0x1000c7c8, 0x00018f95, 0x1ffffffc, 0x0, 0x0
	dspck_dstio addqh.w, 0x40000002, 0x00000005, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh.w, 0x03ef6066, 0xffdec0cf, 0x07fffffe, 0x0, 0x0
	dspck_dstio addqh.w, 0xffb63183, 0xff6c6306, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.w, 0xff807f83, 0xff00ff00, 0x00000007, 0x0, 0x0
	dspck_dstio addqh.w, 0x5ffffffd, 0x7fffffff, 0x3ffffffc, 0x0, 0x0
	dspck_dstio addqh.w, 0xffffff00, 0xffffff00, 0xffffff00, 0x0, 0x0
	dspck_dstio addqh.w, 0x000144dc, 0x000289b9, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.w, 0xbf8d4ed6, 0x80000003, 0xff1a9daa, 0x0, 0x0
	dspck_dstio addqh.w, 0xfe7f4090, 0xfcfe8121, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.w, 0x03c898ae, 0x0791315c, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.w, 0xc56173b3, 0x0ac2e760, 0x80000007, 0x0, 0x0
	dspck_dstio addqh.w, 0xffffffff, 0x80000000, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh.w, 0xfffffffb, 0xfffffffe, 0xfffffff8, 0x0, 0x0
	dspck_dstio addqh.w, 0xf800aeb7, 0x00015d68, 0xf0000007, 0x0, 0x0
	dspck_dstio addqh.w, 0x2aaaaaaa, 0x55555555, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.w, 0x0000f569, 0x0001eb4f, 0xffffff83, 0x0, 0x0
	dspck_dstio addqh.w, 0x0800001d, 0x0ffffffc, 0x0000003f, 0x0, 0x0
	dspck_dstio addqh.w, 0x0005ce3e, 0xffffffdd, 0x000b9ca0, 0x0, 0x0
	dspck_dstio addqh.w, 0xdc71c71c, 0x80000000, 0x38e38e38, 0x0, 0x0
	dspck_dstio addqh.w, 0x1ffffffc, 0x00000018, 0x3fffffe0, 0x0, 0x0
	dspck_dstio addqh.w, 0x43efada4, 0x7fffffff, 0x07df5b49, 0x0, 0x0
	dspck_dstio addqh.w, 0x01b25e99, 0xfffffffd, 0x0364bd35, 0x0, 0x0
	dspck_dstio addqh.w, 0x0000c659, 0x00018cb3, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.w, 0x38e38e4e, 0x71c71c71, 0x0000002c, 0x0, 0x0
	dspck_dstio addqh.w, 0x80000000, 0x80000000, 0x80000000, 0x0, 0x0
	dspck_dstio addqh.w, 0x000000ff, 0x000000ff, 0x000000ff, 0x0, 0x0
	dspck_dstio addqh.w, 0xc0000000, 0x00000000, 0x80000000, 0x0, 0x0
	dspck_dstio addqh.w, 0xbffff5bb, 0xffffeb77, 0x80000000, 0x0, 0x0
	dspck_dstio addqh.w, 0xbfff800f, 0xffff0000, 0x8000001f, 0x0, 0x0
	dspck_dstio addqh.w, 0xd5555555, 0xaaaaaaaa, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.w, 0xd5555555, 0x00000000, 0xaaaaaaaa, 0x0, 0x0
	dspck_dstio addqh.w, 0xdbb34f6b, 0x008b3121, 0xb6db6db6, 0x0, 0x0
	dspck_dstio addqh.w, 0x00000c75, 0x00000000, 0x000018eb, 0x0, 0x0
	dspck_dstio addqh.w, 0xffffffe0, 0xffffffc0, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.w, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh.w, 0x9555555c, 0xaaaaaaaa, 0x8000000f, 0x0, 0x0
	dspck_dstio addqh.w, 0x4076b0e8, 0x7ffffffc, 0x00ed61d4, 0x0, 0x0
	dspck_dstio addqh.w, 0x2aaaaaaa, 0x55555555, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.w, 0xfff3652d, 0xffe6c981, 0x000000da, 0x0, 0x0
	dspck_dstio addqh.w, 0x44b02eb9, 0x7ffffff8, 0x09605d7a, 0x0, 0x0
	dspck_dstio addqh.w, 0x0013efed, 0x00209236, 0x00074da5, 0x0, 0x0
	dspck_dstio addqh.w, 0xbffffffd, 0x80000000, 0xfffffffb, 0x0, 0x0
	dspck_dstio addqh.w, 0x00000338, 0x00000671, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.w, 0x3f6a238c, 0x7ffffff8, 0xfed44720, 0x0, 0x0
	dspck_dstio addqh.w, 0x64924924, 0x7fffffff, 0x49249249, 0x0, 0x0
	dspck_dstio addqh.w, 0x38000000, 0x7fffffff, 0xf0000001, 0x0, 0x0
	dspck_dstio addqh.w, 0xffffffff, 0x80000000, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh.w, 0xc0000000, 0x00000000, 0x80000001, 0x0, 0x0
	dspck_dstio addqh.w, 0xfffffffd, 0x00000000, 0xfffffffb, 0x0, 0x0
	dspck_dstio addqh.w, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.w, 0xe19050bf, 0x00000001, 0xc320a17e, 0x0, 0x0
	dspck_dstio addqh.w, 0x3fffffff, 0x00000000, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh.w, 0xc0000006, 0x0000000c, 0x80000000, 0x0, 0x0
	dspck_dstio addqh.w, 0x00000002, 0x00000004, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.w, 0x001ed11f, 0x00000000, 0x003da23f, 0x0, 0x0
	dspck_dstio addqh.w, 0xc0000000, 0x80000000, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.w, 0xbfffffff, 0x80000000, 0xffffffff, 0x0, 0x0
	dspck_dstio addqh.w, 0x3ffeb2f4, 0xfffd65f8, 0x7ffffff0, 0x0, 0x0
	dspck_dstio addqh.w, 0xffffffff, 0x80000000, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh.w, 0xcccc7814, 0x99999999, 0xffff5690, 0x0, 0x0
	dspck_dstio addqh.w, 0xc000000b, 0xc0000007, 0xc000000f, 0x0, 0x0
	dspck_dstio addqh.w, 0xf8000002, 0xf0000007, 0xfffffffe, 0x0, 0x0
	dspck_dstio addqh.w, 0xffff2888, 0xffff2888, 0xffff2888, 0x0, 0x0
	dspck_dstio addqh.w, 0xbfffff80, 0xffffff00, 0x80000000, 0x0, 0x0
	dspck_dstio addqh.w, 0xdb6db675, 0xffffff35, 0xb6db6db6, 0x0, 0x0
	dspck_dstio addqh.w, 0xc0000000, 0x80000000, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.w, 0xc0000003, 0x80000000, 0x00000007, 0x0, 0x0
	dspck_dstio addqh.w, 0x3ffffffe, 0xfffffffe, 0x7ffffffe, 0x0, 0x0
	dspck_dstio addqh.w, 0x3fffff7f, 0x7fffffff, 0xffffff00, 0x0, 0x0
	dspck_dstio addqh.w, 0x59999989, 0x33333333, 0x7fffffe0, 0x0, 0x0
	dspck_dstio addqh.w, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.w, 0xf0000007, 0xf0000007, 0xf0000007, 0x0, 0x0
	dspck_dstio addqh.w, 0xc00000d4, 0x80000002, 0x000001a7, 0x0, 0x0
	dspck_dstio addqh.w, 0xdffffffe, 0x80000000, 0x3ffffffc, 0x0, 0x0
	dspck_dstio addqh.w, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.w, 0x3fffffff, 0x00000000, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh.w, 0x1ff102a8, 0x3ffffff0, 0xffe20561, 0x0, 0x0
	dspck_dstio addqh.w, 0xc0000000, 0x80000000, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.w, 0xbff42c92, 0xffe85925, 0x80000000, 0x0, 0x0
	dspck_dstio addqh.w, 0xf1c71c71, 0xaaaaaaaa, 0x38e38e38, 0x0, 0x0
	dspck_dstio addqh.w, 0x00023367, 0xfffffffc, 0x000466d2, 0x0, 0x0
	dspck_dstio addqh.w, 0xf8000003, 0xf0000007, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.w, 0xff807f80, 0x00000000, 0xff00ff00, 0x0, 0x0
	dspck_dstio addqh.w, 0x40027c25, 0x7fffffff, 0x0004f84b, 0x0, 0x0
	dspck_dstio addqh.w, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.w, 0x3f9fcf15, 0xff3f9e2c, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh.w, 0xfff9c870, 0x00000005, 0xfff390dc, 0x0, 0x0
	dspck_dstio addqh.w, 0x3fffffff, 0x00000000, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh.w, 0x3fc25387, 0xff84a710, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh.w, 0xbffffd58, 0xfffffab0, 0x80000000, 0x0, 0x0
	dspck_dstio addqh.w, 0xb904c03b, 0x80000000, 0xf2098076, 0x0, 0x0
	dspck_dstio addqh.w, 0xfffffff2, 0xffffffe4, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.w, 0x3f00ae1d, 0xfe015c3c, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh.w, 0xbffffff9, 0xfffffff2, 0x80000000, 0x0, 0x0
	dspck_dstio addqh.w, 0xbfffff4a, 0x80000000, 0xfffffe94, 0x0, 0x0
	dspck_dstio addqh.w, 0xbfe01fc0, 0xffc03f80, 0x80000000, 0x0, 0x0
	dspck_dstio addqh.w, 0xc0008001, 0x80000003, 0x0000ffff, 0x0, 0x0
	dspck_dstio addqh.w, 0x3ffff7d1, 0xffffefa4, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh.w, 0x40002914, 0x00005249, 0x7fffffe0, 0x0, 0x0
	dspck_dstio addqh.w, 0x221d4ee8, 0x043a9df1, 0x3fffffe0, 0x0, 0x0
	dspck_dstio addqh.w, 0x80000000, 0x80000000, 0x80000000, 0x0, 0x0
	dspck_dstio addqh.w, 0xff020def, 0xfe041bde, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.w, 0xfffffffd, 0x7ffffffb, 0x80000000, 0x0, 0x0
	dspck_dstio addqh.w, 0x00000000, 0xfffffffb, 0x00000006, 0x0, 0x0
	dspck_dstio addqh.w, 0xc00000cb, 0x80000000, 0x00000196, 0x0, 0x0
	dspck_dstio addqh.w, 0x0cd25a83, 0x0b4505df, 0x0e5faf28, 0x0, 0x0
	dspck_dstio addqh.w, 0x0ffffff6, 0x1ffffff0, 0xfffffffd, 0x0, 0x0
	dspck_dstio addqh.w, 0xffffd176, 0xffffffff, 0xffffa2ed, 0x0, 0x0
	dspck_dstio addqh.w, 0xc0000000, 0x00000001, 0x80000000, 0x0, 0x0
	dspck_dstio addqh.w, 0x4ffffffa, 0x1ffffff8, 0x7ffffffd, 0x0, 0x0
	dspck_dstio addqh.w, 0xd491985f, 0xaaaaaaaa, 0xfe788615, 0x0, 0x0
	dspck_dstio addqh.w, 0x40000036, 0x7ffffffe, 0x0000006f, 0x0, 0x0
	dspck_dstio addqh.w, 0x3fffffff, 0x00000000, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh.w, 0xffffff80, 0xffffff00, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.w, 0x00000016, 0x00000023, 0x00000009, 0x0, 0x0
	dspck_dstio addqh.w, 0x3e000000, 0x7fffffff, 0xfc000001, 0x0, 0x0
	dspck_dstio addqh.w, 0x1ffffff8, 0x3ffffff0, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.w, 0xc0000000, 0x80000000, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.w, 0xbfff66e1, 0xfffecdc2, 0x80000000, 0x0, 0x0
	dspck_dstio addqh.w, 0xf0000000, 0x00000000, 0xe0000001, 0x0, 0x0
	dspck_dstio addqh.w, 0x3fffffff, 0x00000000, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh.w, 0xfc000005, 0x00000007, 0xf8000003, 0x0, 0x0
	dspck_dstio addqh.w, 0xffffffda, 0xffffffda, 0xffffffda, 0x0, 0x0
	dspck_dstio addqh.w, 0xc0000000, 0x80000000, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.w, 0xb0000003, 0x80000000, 0xe0000007, 0x0, 0x0
	dspck_dstio addqh.w, 0xc0000018, 0xfffffff1, 0x8000003f, 0x0, 0x0
	dspck_dstio addqh.w, 0xe000001b, 0x3ffffff8, 0x8000003f, 0x0, 0x0
	dspck_dstio addqh.w, 0x1d986f80, 0x3b6f4028, 0xffc19ed9, 0x0, 0x0
	dspck_dstio addqh.w, 0x0aaaaaae, 0xc0000007, 0x55555555, 0x0, 0x0
	dspck_dstio addqh.w, 0x1248fe2b, 0x24924924, 0xffffb333, 0x0, 0x0
	dspck_dstio addqh.w, 0x0001ca6e, 0x000394cd, 0x0000000f, 0x0, 0x0
	dspck_dstio addqh.w, 0x80000000, 0x80000000, 0x80000000, 0x0, 0x0
	dspck_dstio addqh.w, 0xf7e0ad68, 0xffc15ad0, 0xf0000001, 0x0, 0x0
	dspck_dstio addqh.w, 0x80000002, 0x80000004, 0x80000000, 0x0, 0x0
	dspck_dstio addqh.w, 0x00000003, 0x00000000, 0x00000006, 0x0, 0x0
	dspck_dstio addqh.w, 0xfffffff1, 0x00000000, 0xffffffe3, 0x0, 0x0
	dspck_dstio addqh.w, 0x0e38e38e, 0x1c71c71c, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.w, 0x00000004, 0x00000008, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.w, 0xffffffff, 0x7fffffff, 0x80000000, 0x0, 0x0
	dspck_dstio addqh.w, 0x52492491, 0x7fffffff, 0x24924924, 0x0, 0x0
	dspck_dstio addqh.w, 0x3e8c09b9, 0x7fffffff, 0xfd181374, 0x0, 0x0
	dspck_dstio addqh.w, 0xbfffffff, 0x8000003f, 0xffffffc0, 0x0, 0x0
	dspck_dstio addqh.w, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.w, 0x3fffffff, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.w, 0x000000eb, 0x000001d7, 0x00000000, 0x0, 0x0
	dspck_dstio addqh.w, 0x3fffed54, 0x7fffffe0, 0xffffdac9, 0x0, 0x0
	dspck_dstio addqh.w, 0xfc000000, 0x00000000, 0xf8000001, 0x0, 0x0
	dspck_dstio addqh.w, 0xbf0e62c0, 0x80000000, 0xfe1cc581, 0x0, 0x0
	dspck_dstio addqh.w, 0x3249248a, 0x3ffffff0, 0x24924924, 0x0, 0x0
	dspck_dstio addqh.w, 0xf0000004, 0x00000001, 0xe0000007, 0x0, 0x0
	dspck_dstio addqh.w, 0x7ffffffa, 0x7ffffffa, 0x7ffffffa, 0x0, 0x0
	dspck_dstio addqh.w, 0xe0014d4c, 0x00029a79, 0xc000001f, 0x0, 0x0
	dspck_dstio addqh.w, 0x07878797, 0x0f0f0f0f, 0x0000001f, 0x0, 0x0
	dspck_dstio addqh.w, 0x80000000, 0x80000000, 0x80000000, 0x0, 0x0
	dspck_dstio addqh.w, 0x3ffffffd, 0xfffffffc, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh.w, 0x003d608a, 0x0002bc6f, 0x007804a6, 0x0, 0x0

	writemsg "[44] Test addqh_r.w"
	dspck_dstio addqh_r.w, 0x001c2e53, 0xffffffed, 0x00385cb8, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xd55557da, 0x0000050a, 0xaaaaaaaa, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x07ffffff, 0x00000000, 0x0ffffffe, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xc07f8083, 0x00ff00ff, 0x80000007, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x40000000, 0x00000000, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x3fffff92, 0xffffffa4, 0x7fffff80, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x00000a36, 0x0000146b, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xc0000003, 0x00000000, 0x80000006, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xffce4ead, 0x000021b8, 0xff9c7ba2, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x00000000, 0x7fffffff, 0x80000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xfbff2863, 0xfffe50c3, 0xf8000003, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x006b3544, 0x00d66a89, 0xfffffffe, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xfb87c222, 0xc3dc5111, 0x33333333, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xc0000001, 0x00000001, 0x80000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xc0737f9f, 0x80000000, 0x00e6ff3d, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x0000021b, 0x00000435, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x0e4639b4, 0x001aac4b, 0x1c71c71c, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x40000000, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xe0000017, 0xc000000f, 0x0000001f, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xe0000004, 0xe0000001, 0xe0000007, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xbfffffff, 0x80000000, 0xfffffffd, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x00000004, 0x00000007, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x02022147, 0x03fffffe, 0x0004428f, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xbfffcea2, 0x80000004, 0xffff9d40, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x0000023f, 0x000004a2, 0xffffffdb, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xff4bf5da, 0xfe97eba2, 0x00000012, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xfffffff7, 0x00000000, 0xffffffed, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xfffffff6, 0xffffffec, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xd8000002, 0xf0000003, 0xc0000001, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xfe2b8f23, 0xfe2b8f23, 0xfe2b8f23, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x7ffffff0, 0x7fffffe0, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xc2f27694, 0x80000000, 0x05e4ed28, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xc0000001, 0x00000001, 0x80000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xfffff9a5, 0x00000000, 0xfffff349, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x33333333, 0x66666666, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x20000000, 0xc0000001, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x00000000, 0x80000000, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xfe000001, 0xfc000001, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x36db68c5, 0x6db6db6d, 0xfffff61d, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x000000ee, 0x00000003, 0x000001d9, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x40000000, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xc71c71c7, 0x00000000, 0x8e38e38e, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x4000007f, 0x000000ff, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x3fffd85e, 0xffffb0bc, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xfffffe9b, 0xfffffd36, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x00000000, 0x80000000, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xbffff359, 0x80000000, 0xffffe6b2, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x00079fed, 0x000f3fda, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xf8000001, 0x00000000, 0xf0000001, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xc0000002, 0x80000004, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x07bc1ffd, 0xfff8f339, 0x0f7f4cc0, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x20000001, 0x7fffffff, 0xc0000003, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xfc57b223, 0xffffffc0, 0xf8af6486, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x24924925, 0x49249249, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x47fffffe, 0x7fffffff, 0x0ffffffc, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xffffd536, 0xffffaa6c, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x00000011, 0x0000001f, 0x00000003, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x03979f3a, 0x00000000, 0x072f3e73, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x3ff806f1, 0xfff00de3, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x7ffffff0, 0x7fffffe0, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xc0000000, 0x00000000, 0x80000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x007e6f6e, 0x00ff00ff, 0xfffddddc, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xffcd1c51, 0x0000003f, 0xff9a3862, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xbb6a9bf9, 0xf6d537f2, 0x80000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x00008c1a, 0x00011833, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x40000000, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xcccccccd, 0x00000000, 0x99999999, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x78e38e38, 0x71c71c71, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x3ffffffe, 0xfffffffd, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x1ffffffe, 0x00000000, 0x3ffffffc, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xfffffdfe, 0xfffffdfe, 0xfffffdfe, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xffebcf00, 0xffd79eff, 0xffffff00, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x4ffffff7, 0x7ffffffe, 0x1ffffff0, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xf878787b, 0xf0f0f0f0, 0x00000006, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x2ffffffd, 0x1ffffffc, 0x3ffffffe, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xec9a775a, 0xffff4359, 0xd935ab5b, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xe0000002, 0x00000000, 0xc0000003, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xc0000008, 0x8000000f, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xffffffbf, 0xffffff80, 0xfffffffd, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x0000000f, 0x00000000, 0x0000001d, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xc0000000, 0xffffffff, 0x80000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x00002f90, 0xfffffffb, 0x00005f25, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xdb6ee8cf, 0xb6db6db6, 0x000263e8, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x40000003, 0x7fffffff, 0x00000006, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xbf030c41, 0x80000000, 0xfe061881, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xbf8dec7a, 0x80000001, 0xff1bd8f3, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xffcac1e3, 0xfffffff8, 0xff9583ce, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xd5555555, 0xaaaaaaaa, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xfffffff8, 0x00000000, 0xfffffff0, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x80000000, 0x80000000, 0x80000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x0003b152, 0x000af736, 0xfffc6b6e, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x40000000, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xff00ff00, 0xff00ff00, 0xff00ff00, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x40000000, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xd5555556, 0xaaaaaaaa, 0x00000002, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x1c71c720, 0x38e38e38, 0x00000007, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x80000000, 0x80000000, 0x80000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xf9906a36, 0xf378b685, 0xffa81de6, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xf8015b6a, 0x0002b6d2, 0xf0000001, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x01d83e62, 0x00000000, 0x03b07cc3, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x0005d570, 0x000baadf, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x00000000, 0x00000003, 0xfffffffd, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x08000006, 0x0ffffffe, 0x0000000e, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xff00ff00, 0xff00ff00, 0xff00ff00, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x3ffbc0cd, 0x7fffffff, 0xfff7819a, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x07fffffb, 0x0ffffff8, 0xfffffffe, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x0000033f, 0x00000681, 0xfffffffc, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x00008000, 0x0000ffff, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x3ffffff0, 0x00000000, 0x7fffffe0, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xf7ffffd7, 0xffffffac, 0xf0000001, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xe38e38e6, 0xc71c71c7, 0x00000005, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xffd22f1c, 0xfffffff0, 0xffa45e47, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x3fffffc0, 0x00000000, 0x7fffff80, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x78e38e19, 0x71c71c71, 0x7fffffc0, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x20000000, 0xc0000001, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xf1c71c62, 0xe38e38e3, 0xffffffe0, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xfde8abd7, 0xfbd157ad, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xfffffd4e, 0xfffffa9b, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x80000000, 0x80000000, 0x80000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x80000000, 0x80000000, 0x80000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x00089cd9, 0xfffffffe, 0x001139b4, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x3fffffff, 0xffffffff, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x40000000, 0x7ffffffb, 0x00000004, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xffffffff, 0x00000000, 0xfffffffd, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xd5555558, 0xaaaaaaaa, 0x00000006, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xedb6db6e, 0x00000000, 0xdb6db6db, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xf1b6db6d, 0xdb6db6db, 0x07fffffe, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x40000000, 0x00000000, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x332937e8, 0x66666666, 0xffec096a, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xe0000004, 0x00000000, 0xc0000007, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xc0000f2d, 0x80000000, 0x00001e59, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xfb4d222c, 0xfb4d222c, 0xfb4d222c, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x40000007, 0x7fffffff, 0x0000000f, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xfff2720c, 0xffe4e418, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xc0000001, 0x80000000, 0x00000002, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x00000000, 0x80000000, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x02000001, 0x03fffffe, 0x00000004, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x00000160, 0x000002c0, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x404316be, 0x00862d7d, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x000000d2, 0x00000000, 0x000001a4, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x00000002, 0x00000005, 0xffffffff, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x40000000, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xc00000b7, 0x80000000, 0x0000016d, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x3fff1ad6, 0xfffe35cb, 0x7fffffe0, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xfeca0cca, 0xfd94533c, 0xffffc658, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xfd7c9654, 0xfa792698, 0x00800610, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x0ffffffc, 0x00000000, 0x1ffffff8, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xfffed677, 0x0000029d, 0xfffdaa51, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xc00019b9, 0x80000000, 0x00003371, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xeffffff9, 0xe0000001, 0xfffffff0, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xfc000000, 0xf8000003, 0xfffffffc, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x8ccccccd, 0x99999999, 0x80000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x0fffb73b, 0xffff6e78, 0x1ffffffe, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xfff4e911, 0xfffa944b, 0xffef3dd6, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x000734ec, 0x000e69d6, 0x00000002, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xffffff72, 0x00000000, 0xfffffee3, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x40000000, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xbfcd0886, 0x80000000, 0xff9a110b, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x0793bc28, 0x0793bc28, 0x0793bc28, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xffffffd6, 0x00000000, 0xffffffab, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x4c294f11, 0x7fffffff, 0x18529e22, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x00000054, 0x00000000, 0x000000a7, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x3fffffc0, 0x7fffffff, 0xffffff80, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xf3333333, 0x80000000, 0x66666666, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xfffffffe, 0x7ffffffb, 0x80000001, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x00002e1a, 0x000070b7, 0xffffeb7c, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xffd905d7, 0xffb4030a, 0xfffe08a3, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xedededee, 0x0f0f0f0f, 0xcccccccc, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x5ffffff0, 0x7fffffff, 0x3fffffe0, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x3b33332f, 0x66666666, 0x0ffffff8, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xfffff2ad, 0x00000000, 0xffffe559, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xc0000005, 0x00000009, 0x80000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xc0000001, 0x00000001, 0x80000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x36db6db9, 0x6db6db6d, 0x00000005, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x00000002, 0x7fffffff, 0x80000005, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x00000001, 0x00000002, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xc0000058, 0x80000000, 0x000000af, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xbcccccce, 0xe0000003, 0x99999999, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xf7ff8002, 0xffff0000, 0xf0000003, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x1ffffff9, 0x00000002, 0x3ffffff0, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xc0000005, 0x80000000, 0x00000009, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xc0000005, 0x00000009, 0x80000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xe38e38e2, 0xc71c71c7, 0xfffffffd, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x00387f01, 0x00711173, 0xffffec8f, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xc0000008, 0x8000000f, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xffffffe0, 0x00000000, 0xffffffc0, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x80000000, 0x80000000, 0x80000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xbffffffd, 0x80000000, 0xfffffff9, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xc0000002, 0x00000004, 0x80000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xbfffc643, 0xffff8c86, 0x80000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x0000001f, 0xfffffffe, 0x0000003f, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xbfff8000, 0x80000000, 0xffff0000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xf0000080, 0x000000ff, 0xe0000001, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x00000017, 0x0000002f, 0xfffffffe, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x3ffffff0, 0x7fffffe0, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xc0000000, 0x00000000, 0x80000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xe0000004, 0xc0000007, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x40000000, 0x00000000, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xf8787878, 0x00000000, 0xf0f0f0f0, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xfffa8163, 0xfffffff8, 0xfff502cd, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x24924925, 0x49249249, 0x00000001, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xbfff77a4, 0xfffeef40, 0x80000007, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xbff2bb9c, 0x80000001, 0xffe57736, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xc15f7fad, 0x80000000, 0x02beff5a, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xfdc65340, 0xfb8ca680, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xc0000690, 0x80000001, 0x00000d1e, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xb290f262, 0xe521e4c3, 0x80000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x00003e81, 0x00007cff, 0x00000003, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xb1c71c74, 0xe38e38e3, 0x80000005, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x00000003, 0x00000000, 0x00000006, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x1f807f7c, 0x3ffffff8, 0xff00ff00, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xfff7827d, 0xfff7827d, 0xfff7827d, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x40088cfb, 0x001119f8, 0x7ffffffe, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xe38e3cb7, 0xc71c71c7, 0x000007a7, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x3fffffe3, 0xffffffc9, 0x7ffffffc, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xf5c71c70, 0xe38e38e3, 0x07fffffc, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x3ffff9e6, 0x7ffffffb, 0xfffff3d0, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x003ed38d, 0x007da71b, 0xfffffffe, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x3fffffff, 0x7ffffffa, 0x00000003, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x7fffffff, 0x7fffffff, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x40000006, 0x0000000c, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x3fffffff, 0xfffffffe, 0x7fffffff, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x0003a055, 0x00000000, 0x000740a9, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xc0000003, 0xffffffff, 0x80000007, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x009322ba, 0x00000000, 0x01264574, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x0012afc2, 0x00000668, 0x0025591c, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xf8000083, 0xf0000007, 0x000000ff, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xf1c71c72, 0xe38e38e3, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x400000ce, 0x7fffffff, 0x0000019c, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x0000006b, 0x00000000, 0x000000d5, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xfed45432, 0xfda8a765, 0x000000ff, 0x0, 0x0
	dspck_dstio addqh_r.w, 0xffffffe0, 0xffffffc0, 0x00000000, 0x0, 0x0
	dspck_dstio addqh_r.w, 0x40000000, 0x7fffffff, 0x00000000, 0x0, 0x0

	writemsg "[45] Test subqh.w"
	dspck_dstio subqh.w, 0x40000000, 0x00000000, 0x80000000, 0x0, 0x0
	dspck_dstio subqh.w, 0x00000002, 0xfffffffc, 0xfffffff8, 0x0, 0x0
	dspck_dstio subqh.w, 0x000001cf, 0xfffffff9, 0xfffffc5b, 0x0, 0x0
	dspck_dstio subqh.w, 0xffffffff, 0xffffffff, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.w, 0x0ffffffd, 0xfffffffe, 0xe0000003, 0x0, 0x0
	dspck_dstio subqh.w, 0xf1c71c73, 0xe38e38e3, 0xfffffffc, 0x0, 0x0
	dspck_dstio subqh.w, 0x40072e8c, 0x7ffffff8, 0xfff1a2df, 0x0, 0x0
	dspck_dstio subqh.w, 0xffff94d2, 0xffff29a5, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.w, 0x00000000, 0x7fffffff, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh.w, 0xef8d03bd, 0xdf1a077b, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.w, 0xefffffff, 0xfffffffc, 0x1ffffffe, 0x0, 0x0
	dspck_dstio subqh.w, 0xc0000010, 0x00000018, 0x7ffffff8, 0x0, 0x0
	dspck_dstio subqh.w, 0x43fffffa, 0x07fffffc, 0x80000007, 0x0, 0x0
	dspck_dstio subqh.w, 0xbfffffcf, 0x80000007, 0x00000069, 0x0, 0x0
	dspck_dstio subqh.w, 0xbf2a3e1a, 0xfe547c33, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh.w, 0xc0000023, 0x80000006, 0xffffffc0, 0x0, 0x0
	dspck_dstio subqh.w, 0x07fffffc, 0x0ffffff8, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.w, 0x78e38e38, 0x7fffffff, 0x8e38e38e, 0x0, 0x0
	dspck_dstio subqh.w, 0x38e380c1, 0xffffe510, 0x8e38e38e, 0x0, 0x0
	dspck_dstio subqh.w, 0xc0008000, 0x80000000, 0xffff0000, 0x0, 0x0
	dspck_dstio subqh.w, 0x03935765, 0x00000000, 0xf8d95135, 0x0, 0x0
	dspck_dstio subqh.w, 0xffffffff, 0xffffffff, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.w, 0xc0000000, 0x00000000, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh.w, 0xc0000007, 0x0000000e, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh.w, 0xffedf426, 0xffdbe85d, 0x00000010, 0x0, 0x0
	dspck_dstio subqh.w, 0x0000011a, 0x0000023a, 0x00000005, 0x0, 0x0
	dspck_dstio subqh.w, 0x41ac198f, 0x7ffffff8, 0xfca7ccd9, 0x0, 0x0
	dspck_dstio subqh.w, 0x00000003, 0x7fffffff, 0x7ffffff9, 0x0, 0x0
	dspck_dstio subqh.w, 0xc0000020, 0x00000021, 0x7fffffe0, 0x0, 0x0
	dspck_dstio subqh.w, 0xbffffffd, 0xfffffffa, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh.w, 0xff1f0938, 0x00000000, 0x01c1ed8f, 0x0, 0x0
	dspck_dstio subqh.w, 0x01f31c43, 0xffe63888, 0xfc000001, 0x0, 0x0
	dspck_dstio subqh.w, 0x7ffffffd, 0x7fffffff, 0x80000005, 0x0, 0x0
	dspck_dstio subqh.w, 0x0ccccccc, 0x7fffffff, 0x66666666, 0x0, 0x0
	dspck_dstio subqh.w, 0x3ffffffc, 0xffffffff, 0x80000007, 0x0, 0x0
	dspck_dstio subqh.w, 0xadb6db6e, 0xdb6db6db, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh.w, 0x1c398ddd, 0x00000000, 0xc78ce445, 0x0, 0x0
	dspck_dstio subqh.w, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.w, 0xffe4e571, 0xffc9c9e2, 0xffffff00, 0x0, 0x0
	dspck_dstio subqh.w, 0xfffee4e2, 0xfffe5537, 0x00008b73, 0x0, 0x0
	dspck_dstio subqh.w, 0xfffd2c0b, 0xffff0000, 0x0004a7ea, 0x0, 0x0
	dspck_dstio subqh.w, 0x3fd334e4, 0x7ffffffd, 0x00599635, 0x0, 0x0
	dspck_dstio subqh.w, 0x0e38e90e, 0x1c71c71c, 0xfffff500, 0x0, 0x0
	dspck_dstio subqh.w, 0xcffffff8, 0x80000000, 0xe000000f, 0x0, 0x0
	dspck_dstio subqh.w, 0xfffffffe, 0x00000000, 0x00000004, 0x0, 0x0
	dspck_dstio subqh.w, 0x4000000c, 0x00000018, 0x80000000, 0x0, 0x0
	dspck_dstio subqh.w, 0x00000000, 0x00000000, 0xffffffff, 0x0, 0x0
	dspck_dstio subqh.w, 0xffa1a497, 0xffffff80, 0x00bcb652, 0x0, 0x0
	dspck_dstio subqh.w, 0x40000000, 0x00000000, 0x80000000, 0x0, 0x0
	dspck_dstio subqh.w, 0x4000003f, 0x7fffffff, 0xffffff80, 0x0, 0x0
	dspck_dstio subqh.w, 0xbf807f80, 0x80000000, 0x00ff00ff, 0x0, 0x0
	dspck_dstio subqh.w, 0x07576dca, 0x0eaedb95, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.w, 0xd4cccccc, 0x0ffffffe, 0x66666666, 0x0, 0x0
	dspck_dstio subqh.w, 0x3fffff6d, 0xfffffedb, 0x80000000, 0x0, 0x0
	dspck_dstio subqh.w, 0x00000002, 0x00000000, 0xfffffffc, 0x0, 0x0
	dspck_dstio subqh.w, 0x40000002, 0x7fffffff, 0xfffffffa, 0x0, 0x0
	dspck_dstio subqh.w, 0xffffff80, 0xffffff00, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.w, 0xc9249247, 0xfffffffc, 0x6db6db6d, 0x0, 0x0
	dspck_dstio subqh.w, 0x40000000, 0x00000000, 0x80000000, 0x0, 0x0
	dspck_dstio subqh.w, 0x05e03a4e, 0xfff7f3dd, 0xf4377f41, 0x0, 0x0
	dspck_dstio subqh.w, 0x80000001, 0x80000000, 0x7ffffffd, 0x0, 0x0
	dspck_dstio subqh.w, 0xe66664e6, 0xfffffd00, 0x33333333, 0x0, 0x0
	dspck_dstio subqh.w, 0x0000b407, 0x00016802, 0xfffffff3, 0x0, 0x0
	dspck_dstio subqh.w, 0x00000189, 0x000002f2, 0xffffffe0, 0x0, 0x0
	dspck_dstio subqh.w, 0x3ffc3657, 0xfff86caf, 0x80000000, 0x0, 0x0
	dspck_dstio subqh.w, 0xdff8bda6, 0xfff17b4a, 0x3ffffffe, 0x0, 0x0
	dspck_dstio subqh.w, 0xc1835749, 0x0306ae91, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh.w, 0x07fffede, 0x0ffffff8, 0x0000023b, 0x0, 0x0
	dspck_dstio subqh.w, 0x3ffffff0, 0x00000000, 0x8000001f, 0x0, 0x0
	dspck_dstio subqh.w, 0xe0000004, 0xc000000f, 0x00000007, 0x0, 0x0
	dspck_dstio subqh.w, 0x00000000, 0x80000000, 0x80000000, 0x0, 0x0
	dspck_dstio subqh.w, 0x3ff77753, 0xffeeeea7, 0x80000000, 0x0, 0x0
	dspck_dstio subqh.w, 0x80000000, 0x80000000, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh.w, 0xcffffffe, 0x80000000, 0xe0000003, 0x0, 0x0
	dspck_dstio subqh.w, 0x0e36c890, 0xfffbca03, 0xe38e38e3, 0x0, 0x0
	dspck_dstio subqh.w, 0xfffffffd, 0xfffffffb, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.w, 0x3ffffe2c, 0x7fffffff, 0x000003a6, 0x0, 0x0
	dspck_dstio subqh.w, 0xbfff4575, 0x80000000, 0x00017515, 0x0, 0x0
	dspck_dstio subqh.w, 0xc00004b7, 0x80000003, 0xfffff694, 0x0, 0x0
	dspck_dstio subqh.w, 0xc0000000, 0x80000000, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.w, 0xbffffff8, 0xffffffeb, 0x7ffffffb, 0x0, 0x0
	dspck_dstio subqh.w, 0x3fffffbd, 0x7fffffe0, 0x00000066, 0x0, 0x0
	dspck_dstio subqh.w, 0x00000000, 0x7fffffff, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh.w, 0x105324c2, 0x00a6498c, 0xe0000007, 0x0, 0x0
	dspck_dstio subqh.w, 0x2000000f, 0xc000001f, 0x80000001, 0x0, 0x0
	dspck_dstio subqh.w, 0xc000000f, 0x8000001f, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.w, 0x0001894e, 0x00031261, 0xffffffc5, 0x0, 0x0
	dspck_dstio subqh.w, 0x3ffffffe, 0x7fffffff, 0x00000003, 0x0, 0x0
	dspck_dstio subqh.w, 0xf80b23d0, 0xf0f0f0f0, 0x00daa950, 0x0, 0x0
	dspck_dstio subqh.w, 0x07c00d4c, 0x0ffffffc, 0x007fe564, 0x0, 0x0
	dspck_dstio subqh.w, 0x3fffffbb, 0xfffffff6, 0x8000007f, 0x0, 0x0
	dspck_dstio subqh.w, 0x400075bb, 0x7fffffff, 0xffff1489, 0x0, 0x0
	dspck_dstio subqh.w, 0xbf6334b0, 0x80000000, 0x013996a0, 0x0, 0x0
	dspck_dstio subqh.w, 0xc3fffffe, 0x80000000, 0xf8000003, 0x0, 0x0
	dspck_dstio subqh.w, 0x00000000, 0x0000021e, 0x0000021e, 0x0, 0x0
	dspck_dstio subqh.w, 0x36db6db7, 0x00000001, 0x92492492, 0x0, 0x0
	dspck_dstio subqh.w, 0xc0000000, 0x80000000, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.w, 0xc0434639, 0x8000001f, 0xff7973ad, 0x0, 0x0
	dspck_dstio subqh.w, 0xffffd64d, 0x00000000, 0x00005365, 0x0, 0x0
	dspck_dstio subqh.w, 0xeb20f296, 0xc000000f, 0xe9be1ae2, 0x0, 0x0
	dspck_dstio subqh.w, 0xc0000001, 0x80000002, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.w, 0xbfffffc0, 0xffffff80, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh.w, 0xeaaaaaab, 0x80000000, 0xaaaaaaaa, 0x0, 0x0
	dspck_dstio subqh.w, 0x18000003, 0xf0000007, 0xc0000001, 0x0, 0x0
	dspck_dstio subqh.w, 0xbea0ad0c, 0x80000005, 0x02bea5ec, 0x0, 0x0
	dspck_dstio subqh.w, 0x00000009, 0x00000012, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.w, 0x000d812e, 0x001b025c, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.w, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.w, 0xf8787875, 0xfffffff9, 0x0f0f0f0f, 0x0, 0x0
	dspck_dstio subqh.w, 0xf6ce4183, 0xfffde50e, 0x12616208, 0x0, 0x0
	dspck_dstio subqh.w, 0x3fffffff, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.w, 0x36db6db5, 0xfffffffc, 0x92492492, 0x0, 0x0
	dspck_dstio subqh.w, 0xbc000002, 0xf8000003, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh.w, 0x3fffffff, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.w, 0xfffffffc, 0x00000000, 0x00000007, 0x0, 0x0
	dspck_dstio subqh.w, 0xdffffffc, 0x3ffffff8, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh.w, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.w, 0x00000000, 0x7fffffff, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh.w, 0xc0000000, 0x00000000, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh.w, 0x00206760, 0x00029488, 0xffc1c5c8, 0x0, 0x0
	dspck_dstio subqh.w, 0xc000000a, 0x80000000, 0xffffffeb, 0x0, 0x0
	dspck_dstio subqh.w, 0x7fffffff, 0x7fffffff, 0x80000000, 0x0, 0x0
	dspck_dstio subqh.w, 0x76db6db6, 0x6db6db6d, 0x80000000, 0x0, 0x0
	dspck_dstio subqh.w, 0x10000008, 0x1ffffffe, 0xffffffee, 0x0, 0x0
	dspck_dstio subqh.w, 0x000009b0, 0x00001360, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.w, 0xbf94ea3f, 0xf0f0f0f0, 0x71c71c71, 0x0, 0x0
	dspck_dstio subqh.w, 0x40000000, 0x7fffffff, 0xffffffff, 0x0, 0x0
	dspck_dstio subqh.w, 0x02242312, 0x0448a055, 0x00005a30, 0x0, 0x0
	dspck_dstio subqh.w, 0x3ffff1b4, 0xffffe368, 0x80000000, 0x0, 0x0
	dspck_dstio subqh.w, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.w, 0x7fffffff, 0x7fffffff, 0x80000000, 0x0, 0x0
	dspck_dstio subqh.w, 0x00000002, 0x00000004, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.w, 0x3ffffff8, 0xfffffff0, 0x80000000, 0x0, 0x0
	dspck_dstio subqh.w, 0x0fffffff, 0x1ffffffc, 0xfffffffe, 0x0, 0x0
	dspck_dstio subqh.w, 0xc71c06f7, 0x8e38e38e, 0x0000d59f, 0x0, 0x0
	dspck_dstio subqh.w, 0xffffcc01, 0xffff9802, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.w, 0x40000071, 0x7fffffff, 0xffffff1d, 0x0, 0x0
	dspck_dstio subqh.w, 0xbffffd5c, 0x80000000, 0x00000547, 0x0, 0x0
	dspck_dstio subqh.w, 0x400006c3, 0x7fffffff, 0xfffff279, 0x0, 0x0
	dspck_dstio subqh.w, 0x40000000, 0x00000000, 0x80000000, 0x0, 0x0
	dspck_dstio subqh.w, 0x00000000, 0x8000000f, 0x8000000f, 0x0, 0x0
	dspck_dstio subqh.w, 0x00000007, 0x0000000f, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.w, 0xb6e5ed26, 0x80000000, 0x123425b3, 0x0, 0x0
	dspck_dstio subqh.w, 0xbfffff8b, 0xffffff15, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh.w, 0x4000007f, 0x7fffffff, 0xffffff00, 0x0, 0x0
	dspck_dstio subqh.w, 0x0000007f, 0x000000ff, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.w, 0x8ccccccd, 0x80000000, 0x66666666, 0x0, 0x0
	dspck_dstio subqh.w, 0x3fffff9b, 0x7fffffff, 0x000000c8, 0x0, 0x0
	dspck_dstio subqh.w, 0xc9249249, 0x00000000, 0x6db6db6d, 0x0, 0x0
	dspck_dstio subqh.w, 0xfffffd6d, 0xfffffad2, 0xfffffff8, 0x0, 0x0
	dspck_dstio subqh.w, 0xc05a2b05, 0x00b455eb, 0x7fffffe0, 0x0, 0x0
	dspck_dstio subqh.w, 0xf8000002, 0x00000000, 0x0ffffffc, 0x0, 0x0
	dspck_dstio subqh.w, 0xce38e38e, 0x80000000, 0xe38e38e3, 0x0, 0x0
	dspck_dstio subqh.w, 0x00000010, 0x00000000, 0xffffffe0, 0x0, 0x0
	dspck_dstio subqh.w, 0x4000000f, 0x0000001f, 0x80000000, 0x0, 0x0
	dspck_dstio subqh.w, 0x76db6db6, 0x6db6db6d, 0x80000000, 0x0, 0x0
	dspck_dstio subqh.w, 0x245f6257, 0x49249249, 0x0065cd9b, 0x0, 0x0
	dspck_dstio subqh.w, 0xfff90c88, 0x00000000, 0x000de6ef, 0x0, 0x0
	dspck_dstio subqh.w, 0x3fffffff, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.w, 0xb0000008, 0x80000000, 0x1ffffff0, 0x0, 0x0
	dspck_dstio subqh.w, 0x3f69acda, 0x7fffffff, 0x012ca64a, 0x0, 0x0
	dspck_dstio subqh.w, 0x0000001c, 0x00000002, 0xffffffca, 0x0, 0x0
	dspck_dstio subqh.w, 0x47ffffff, 0x7fffffff, 0xf0000001, 0x0, 0x0
	dspck_dstio subqh.w, 0x7fffffff, 0x7fffffff, 0x80000000, 0x0, 0x0
	dspck_dstio subqh.w, 0x3fffffff, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.w, 0xbed9f06a, 0x8000000f, 0x024c1f3b, 0x0, 0x0
	dspck_dstio subqh.w, 0xbfffff81, 0xffffff02, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh.w, 0x00007ffc, 0xfffffff8, 0xffff0000, 0x0, 0x0
	dspck_dstio subqh.w, 0xe30e12e7, 0xe28decea, 0x1c71c71c, 0x0, 0x0
	dspck_dstio subqh.w, 0xf1c71c52, 0xffffffc1, 0x1c71c71c, 0x0, 0x0
	dspck_dstio subqh.w, 0x0000d973, 0x0001739e, 0xffffc0b7, 0x0, 0x0
	dspck_dstio subqh.w, 0xe1bd3033, 0x037a605e, 0x3ffffff8, 0x0, 0x0
	dspck_dstio subqh.w, 0xc0000003, 0x80000006, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.w, 0x4000001f, 0x0000003f, 0x80000000, 0x0, 0x0
	dspck_dstio subqh.w, 0xdb6db6de, 0x00000005, 0x49249249, 0x0, 0x0
	dspck_dstio subqh.w, 0x7fffffff, 0x7fffffff, 0x80000000, 0x0, 0x0
	dspck_dstio subqh.w, 0xc0003cd9, 0x8000007f, 0xffff86cc, 0x0, 0x0
	dspck_dstio subqh.w, 0x00000053, 0xfffffff9, 0xffffff53, 0x0, 0x0
	dspck_dstio subqh.w, 0x00000001, 0x00000003, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.w, 0x0000001e, 0xfffffe63, 0xfffffe27, 0x0, 0x0
	dspck_dstio subqh.w, 0xffffffff, 0x00000000, 0x00000001, 0x0, 0x0
	dspck_dstio subqh.w, 0x00000001, 0x0000000a, 0x00000008, 0x0, 0x0
	dspck_dstio subqh.w, 0xdfffffff, 0x80000000, 0xc0000001, 0x0, 0x0
	dspck_dstio subqh.w, 0xf34e99c0, 0xe784bb19, 0x00e78799, 0x0, 0x0
	dspck_dstio subqh.w, 0x3ffffffc, 0x7ffffff8, 0xffffffff, 0x0, 0x0
	dspck_dstio subqh.w, 0x3fffffff, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.w, 0x0000007f, 0xfffffffe, 0xffffff00, 0x0, 0x0
	dspck_dstio subqh.w, 0x80000000, 0x80000000, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh.w, 0xbffc0915, 0xfff81228, 0x7ffffffe, 0x0, 0x0
	dspck_dstio subqh.w, 0x0000049b, 0x000000ff, 0xfffff7c8, 0x0, 0x0
	dspck_dstio subqh.w, 0x000056e0, 0x00015b1a, 0x0000ad5a, 0x0, 0x0
	dspck_dstio subqh.w, 0x4e38e38e, 0x7fffffff, 0xe38e38e3, 0x0, 0x0
	dspck_dstio subqh.w, 0x00029102, 0x000521e5, 0xffffffe0, 0x0, 0x0
	dspck_dstio subqh.w, 0x00000000, 0x00000010, 0x00000010, 0x0, 0x0
	dspck_dstio subqh.w, 0x52492492, 0x24924924, 0x80000000, 0x0, 0x0
	dspck_dstio subqh.w, 0xfbffffff, 0xfffffffc, 0x07fffffe, 0x0, 0x0
	dspck_dstio subqh.w, 0x00000002, 0x00000001, 0xfffffffc, 0x0, 0x0
	dspck_dstio subqh.w, 0xbffefb51, 0x80000001, 0x0002095e, 0x0, 0x0
	dspck_dstio subqh.w, 0x12343403, 0xffd61ee2, 0xdb6db6db, 0x0, 0x0
	dspck_dstio subqh.w, 0xc9249251, 0x92492492, 0xfffffff0, 0x0, 0x0
	dspck_dstio subqh.w, 0x00000001, 0x00000002, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.w, 0x3ffead8b, 0xfffd5b16, 0x80000000, 0x0, 0x0
	dspck_dstio subqh.w, 0x111a2950, 0x023452a1, 0xe0000001, 0x0, 0x0
	dspck_dstio subqh.w, 0xc0000000, 0x80000000, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.w, 0xe0001c7d, 0xc0000003, 0xffffc708, 0x0, 0x0
	dspck_dstio subqh.w, 0xfffffff8, 0x00000000, 0x0000000f, 0x0, 0x0
	dspck_dstio subqh.w, 0x12492482, 0x24924924, 0x0000001f, 0x0, 0x0
	dspck_dstio subqh.w, 0x3ffffcaf, 0x7fffffc0, 0x00000662, 0x0, 0x0
	dspck_dstio subqh.w, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.w, 0xeaaaaaab, 0x55555555, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh.w, 0x80000001, 0x80000000, 0x7ffffffd, 0x0, 0x0
	dspck_dstio subqh.w, 0x00000000, 0x1db10c4b, 0x1db10c4b, 0x0, 0x0
	dspck_dstio subqh.w, 0xfffffffd, 0x00000000, 0x00000005, 0x0, 0x0
	dspck_dstio subqh.w, 0x3fffffe0, 0x7fffffff, 0x0000003f, 0x0, 0x0
	dspck_dstio subqh.w, 0x3ffffffa, 0xfffffffa, 0x80000005, 0x0, 0x0
	dspck_dstio subqh.w, 0xd8787888, 0xc000001f, 0x0f0f0f0f, 0x0, 0x0
	dspck_dstio subqh.w, 0x00000000, 0x80000000, 0x80000000, 0x0, 0x0
	dspck_dstio subqh.w, 0xc0000002, 0x00000000, 0x7ffffffb, 0x0, 0x0
	dspck_dstio subqh.w, 0xffffb823, 0xffff704b, 0x00000005, 0x0, 0x0
	dspck_dstio subqh.w, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.w, 0xc0000000, 0x00000000, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh.w, 0x00000000, 0x7fffffff, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh.w, 0xe0000002, 0xc000000f, 0x0000000b, 0x0, 0x0
	dspck_dstio subqh.w, 0x7fffffff, 0x7fffffff, 0x80000000, 0x0, 0x0
	dspck_dstio subqh.w, 0x3fc87d59, 0xff90fb32, 0x8000007f, 0x0, 0x0
	dspck_dstio subqh.w, 0xbfffffda, 0x80000006, 0x00000051, 0x0, 0x0
	dspck_dstio subqh.w, 0x0dd0d75a, 0xfc000001, 0xe05e514d, 0x0, 0x0
	dspck_dstio subqh.w, 0x00000000, 0x7fffffff, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh.w, 0x403ce94e, 0x7fffffff, 0xff862d63, 0x0, 0x0
	dspck_dstio subqh.w, 0x00000000, 0xffffffff, 0xffffffff, 0x0, 0x0
	dspck_dstio subqh.w, 0x80000000, 0x80000000, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh.w, 0xc0000000, 0x00000000, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh.w, 0x0260df06, 0x03fffffe, 0xff3e41f2, 0x0, 0x0
	dspck_dstio subqh.w, 0xfffffffb, 0x00000000, 0x0000000a, 0x0, 0x0
	dspck_dstio subqh.w, 0x80000000, 0x80000000, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh.w, 0x045c6e60, 0x00368e02, 0xf77db141, 0x0, 0x0
	dspck_dstio subqh.w, 0xc1a2e7f1, 0x0345cfdd, 0x7ffffffb, 0x0, 0x0
	dspck_dstio subqh.w, 0xffffffc0, 0x00000000, 0x0000007f, 0x0, 0x0
	dspck_dstio subqh.w, 0xf0000008, 0x0000000f, 0x1ffffffe, 0x0, 0x0
	dspck_dstio subqh.w, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_dstio subqh.w, 0xbfffffff, 0x80000000, 0x00000001, 0x0, 0x0
	dspck_dstio subqh.w, 0x4ffffffc, 0x1ffffff8, 0x80000000, 0x0, 0x0

	writemsg "[46] Test subqh_r.w"
	dspck_dstio subqh_r.w, 0xffffffff, 0x7ffffffc, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x3ffffff3, 0x00000004, 0x8000001f, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x3b0ded23, 0x7fffffff, 0x09e425ba, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xffff6353, 0x00000000, 0x0001395a, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x00000000, 0x00488e7e, 0x00488e7e, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xce38e38f, 0x80000000, 0xe38e38e3, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x31c71c70, 0xe38e38e3, 0x80000003, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x00872e0d, 0x010e5c19, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xffdde0b5, 0xffbbc97c, 0x00000812, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x3fc71e03, 0x7fffffff, 0x0071c3fa, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xff89baf8, 0x0000001d, 0x00ec8a2e, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xc0000002, 0x80000000, 0xfffffffc, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xfffff93b, 0xfffff276, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xc0000010, 0x00000000, 0x7fffffe0, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xfffff1fb, 0xffffe3f3, 0xfffffffd, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xffff9171, 0x000022e1, 0x0000ffff, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x00000002, 0x00000004, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xc0000001, 0x00000000, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xc00002c5, 0x00000583, 0x7ffffff9, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xde000005, 0xfc000001, 0x3ffffff8, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xffffffff, 0x00000000, 0x00000002, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xedb6db6b, 0xdb6db6db, 0x00000005, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x3fffff9a, 0x7ffffffa, 0x000000c7, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x80000000, 0x7fffffff, 0x80000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x000003fe, 0x00000800, 0x00000005, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xa6666667, 0xcccccccc, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x3fffb09e, 0xffff613c, 0x80000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x12492492, 0x24924924, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x1ffffffe, 0x3ffffffe, 0x00000003, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x0000001c, 0x7ffffff8, 0x7fffffc0, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x00000000, 0x7fffffff, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xfffe2283, 0xfffffed4, 0x0003b9ce, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xf1c64eb3, 0xfffe6481, 0x1c71c71c, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xc0000011, 0x00000020, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xc0000040, 0x00000000, 0x7fffff80, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x40000003, 0x7fffffff, 0xfffffffa, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xa0000002, 0x80000001, 0x3ffffffe, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x40000000, 0x00000000, 0x80000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x17fffffd, 0x0ffffffc, 0xe0000003, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x00000019, 0x0000003f, 0x0000000e, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x4000004e, 0x7fffffff, 0xffffff63, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xfffa5206, 0xfff4bb71, 0x00001766, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x00000001, 0x00000001, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xd0000000, 0x80000000, 0xe0000001, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x00000008, 0x0000000f, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xfffffb5d, 0x00000000, 0x00000947, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x95555556, 0xaaaaaaaa, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x40000000, 0x00000000, 0x80000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xedb6e224, 0x00000d6c, 0x24924924, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x00000004, 0xffffffff, 0xfffffff8, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x01304bc6, 0x0000000b, 0xfd9f687f, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x3c000002, 0x7fffffff, 0x07fffffc, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x3ffffff0, 0x7fffffff, 0x0000001f, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x3ffffffe, 0x00000000, 0x80000004, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x00000001, 0x7fffffff, 0x7ffffffe, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xfffffffe, 0x00000000, 0x00000004, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xbfffffa2, 0x80000004, 0x000000c1, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x40000010, 0x00000020, 0x80000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xfffb06b9, 0xfff60d71, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x00000000, 0x80000000, 0x80000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xc0000005, 0x00000008, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x000001c7, 0xfffffff8, 0xfffffc6b, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xc4000000, 0x07fffffe, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x4fffffff, 0x7fffffff, 0xe0000001, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x00000000, 0x80000000, 0x80000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xffffe055, 0xfffffffd, 0x00003f53, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x09624045, 0xfffffc0a, 0xed3b7b80, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x36db6db7, 0x00000000, 0x92492492, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x40000080, 0x000000ff, 0x80000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x1dee5b50, 0x3be82111, 0x000b6a71, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xa0000001, 0xc0000001, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x36db6df7, 0x0000007f, 0x92492492, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xffff24e1, 0xfffe3d5c, 0xfffff39a, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x00000004, 0x00000000, 0xfffffff9, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xc924924a, 0x00000000, 0x6db6db6d, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x40000000, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x3f3b9830, 0x7fffffff, 0x0188cf9f, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x40000eb2, 0x00001d64, 0x80000001, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xf8000001, 0x00000000, 0x0ffffffe, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xfffff693, 0xfffffff9, 0x000012d4, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xe0000002, 0x3ffffffc, 0x7ffffff8, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xfffffffd, 0xfffffffa, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x4000791b, 0x0000f236, 0x80000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xffffffe5, 0x00000009, 0x0000003f, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x00000000, 0x7fffffff, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xffffffe1, 0x00000000, 0x0000003f, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xfffffffe, 0x7ffffffb, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xc0000000, 0x80000000, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x40000000, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x00000020, 0x0000003f, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x400016d4, 0x00002da7, 0x80000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xefffa3ce, 0xe000000f, 0x0000b874, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x0000000f, 0x0000001d, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xc0000002, 0x80000000, 0xfffffffd, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xd8000003, 0xf0000001, 0x3ffffffc, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x0000000e, 0xffffff9b, 0xffffff80, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x3ff8eab8, 0xfff1d573, 0x80000003, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x4055317a, 0x00aa62f3, 0x80000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xff688053, 0x0000001f, 0x012eff79, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xc000041e, 0x00000838, 0x7ffffffd, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xc001e15d, 0x0003c2b8, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x3ffffffd, 0x7fffffff, 0x00000006, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xc71c718c, 0xffffff89, 0x71c71c71, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x20000000, 0x00000000, 0xc0000001, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x1000017d, 0x1ffffff8, 0xfffffcfe, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x40000000, 0x00000000, 0x80000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xc0000000, 0x80000000, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xfb5dbcbf, 0x00000000, 0x09448683, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xfffffff1, 0x7fffffe0, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xbffffcaf, 0xfffff95c, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x0000037c, 0x000006f8, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xc08c8a8b, 0x01191514, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xff63dc33, 0x00000000, 0x0138479b, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xff523fac, 0x00000000, 0x015b80a8, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x40000002, 0x7fffffff, 0xfffffffb, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x00000000, 0x7fffffff, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xd5555555, 0xaaaaaaaa, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x3e000001, 0xfc000001, 0x80000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x40000000, 0x7fffffff, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xfdfffff3, 0xffffffe4, 0x03fffffe, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xc0000008, 0x8000000f, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xc0000001, 0x00000000, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x0200001f, 0x0000003f, 0xfc000001, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x01f2725a, 0x03fffffe, 0x001b1b4a, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xbfea0af9, 0xffd415f1, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xfffac2a9, 0xfff58552, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x00000430, 0x00000846, 0xffffffe6, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x4000012a, 0x00000254, 0x80000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xccccccca, 0x99999999, 0x00000005, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xc0000000, 0x80000000, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xc000386c, 0x00007057, 0x7fffff80, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xf1c71cf2, 0x000000ff, 0x1c71c71c, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xfffffffc, 0x1ffffff0, 0x1ffffff8, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x95555556, 0x80000000, 0x55555555, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xf1c71c71, 0xfffffffe, 0x1c71c71c, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x4002c377, 0x7fffff80, 0xfffa7893, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xfff485a0, 0xffe90b40, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xbfffffb7, 0xffffff6d, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x00000165, 0xfffffffc, 0xfffffd33, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xffffff80, 0xffffff00, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xe4924926, 0x49249249, 0x7ffffffe, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xfffffe93, 0xfffffd26, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x03878789, 0x0f0f0f0f, 0x07fffffe, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x00000004, 0x00000000, 0xfffffff8, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xe6666667, 0x00000000, 0x33333333, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xc0004bdf, 0x80000000, 0xffff6842, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xcd96d052, 0x1b2da0a2, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x07ffffff, 0x0ffffffe, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x80000001, 0x80000000, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x80000000, 0x7fffffff, 0x80000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xc0000001, 0x00000000, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xf7ffff48, 0xf0000007, 0x00000177, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xfbfffc7c, 0xf8000001, 0x00000709, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xc000005d, 0x000000b9, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x00000008, 0x00000000, 0xfffffff0, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xffa3bd56, 0xffc442a7, 0x007cc7fc, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x00011efa, 0x00000000, 0xfffdc20d, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x402580d4, 0x7fffff80, 0xffb4fdd9, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x0000000f, 0x0000001b, 0xfffffffe, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xe0000001, 0x00000000, 0x3ffffffe, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xc0000ec0, 0x00001d7e, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xffff7a5b, 0xfffef4b5, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x80000001, 0x80000000, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x16db6dbb, 0x6db6db6d, 0x3ffffff8, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x00000052, 0x00000000, 0xffffff5d, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xe0000001, 0xc0000001, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xb1c71c72, 0xe38e38e3, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x051c79f3, 0x0a38f3e5, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x00000000, 0xfffffffe, 0xffffffff, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xffffffff, 0x7ffffffd, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x40000000, 0x00000000, 0x80000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xbffffffe, 0x80000000, 0x00000004, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xe9c71c74, 0xe38e38e3, 0x0ffffffc, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xc0000000, 0x80000000, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xfffff1e1, 0x0000001f, 0x00001c5d, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x3ffffffd, 0xfffffffa, 0x80000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x3f304cb7, 0xfe60996d, 0x80000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x00000000, 0x1ffffffe, 0x1ffffffe, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xfddf601d, 0xfffb717e, 0x043cb145, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xfffffe59, 0xffffffa2, 0x000002f1, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x41ffffff, 0x03fffffe, 0x80000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xffee8aec, 0xffdd15f6, 0x0000001f, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x3ffffff9, 0x00000000, 0x8000000f, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xfff9b067, 0x000192c2, 0x000e31f5, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x0138583e, 0x0270b07b, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x52492492, 0x24924924, 0x80000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x0005ef18, 0x000bdd2f, 0xffffff00, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xbffffffe, 0xfffffffa, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x40000001, 0x7fffffff, 0xfffffffe, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xd5555556, 0x00000000, 0x55555555, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x40000008, 0x0000000f, 0x80000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xc8000003, 0x0ffffffe, 0x7ffffff9, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xe6666667, 0x33333333, 0x66666666, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xd555553a, 0xaaaaaaaa, 0x00000037, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x43ffffff, 0x7fffffff, 0xf8000001, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xa0000004, 0x80000000, 0x3ffffff8, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x40000000, 0x00000000, 0x80000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x76db6db7, 0x7fffffff, 0x92492492, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x3fffffa4, 0xffffff47, 0x80000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x40000256, 0x7ffffff0, 0xfffffb44, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x03fccfc0, 0xfff99f81, 0xf8000001, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x00000169, 0x0000003f, 0xfffffd6d, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x000036cc, 0x00006d99, 0x00000001, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x40000000, 0x00000000, 0x80000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x00000000, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xc0000001, 0x00000000, 0x7ffffffe, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x07fffffe, 0x0ffffffc, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x01ffffff, 0x03fffffe, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x3f769ced, 0xfeed39d9, 0x80000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xc928f7da, 0x92492492, 0xfff734de, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xc0000001, 0x00000001, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xc00089a4, 0x80000000, 0xfffeecb9, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x0001e8c1, 0xffffffff, 0xfffc2e7e, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x040001c0, 0x00000383, 0xf8000003, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xc0000000, 0x80000000, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xfffe677c, 0x00000005, 0x0003310d, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x007f8080, 0x00000000, 0xff00ff00, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xc0000002, 0x00000003, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xa38e38e4, 0xc71c71c7, 0x7fffffff, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x00000003, 0x00000006, 0x00000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x3fffebd9, 0xffffd7b2, 0x80000000, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x384f2cdc, 0x7ffffffb, 0x0f61a643, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xffdc404b, 0xffffff16, 0x00477e80, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x06196184, 0x0c313aef, 0xfffe77e8, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xbfffe9cf, 0x80000003, 0x00002c65, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xff61cc0c, 0xfec39819, 0x00000001, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xffffffff, 0xffffffff, 0x00000002, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xffb8e420, 0xfe72c740, 0xff00ff00, 0x0, 0x0
	dspck_dstio subqh_r.w, 0xfffffff9, 0x00000000, 0x0000000f, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x00000000, 0xffbf1455, 0xffbf1455, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x00000399, 0x00000000, 0xfffff8cf, 0x0, 0x0
	dspck_dstio subqh_r.w, 0x00000020, 0x7fffffff, 0x7fffffc0, 0x0, 0x0

	writemsg "[47] Test dpax.w.ph"
	dspck_astio dpax.w.ph, 0xffcc0271, 0xca18bc2e, 0xffcc0271, 0xca57d72e, 0xfb808000, 0x0000f1fa, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xfffffffe, 0x23cfbe27, 0xfffffffe, 0x1d2fbe27, 0x0ff80d40, 0x80000000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xffcca479, 0xd7f08525, 0xffcca479, 0xd7f40525, 0x80000000, 0x7ffffff9, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x7fffffff, 0xfffffffa, 0x80000000, 0x00750010, 0xff00ffea, 0x7fff8000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xe0000000, 0x00000001, 0xdfffffff, 0xffff8003, 0x00008002, 0x00018000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0xfff6fe31, 0x00000000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xffffe83c, 0x7ee98f5a, 0xffffe83c, 0x7ee99763, 0x00010000, 0xfb9a0809, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x0077b797, 0x00000000, 0x0077b797, 0x01aa7ff8, 0x00000000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x80000000, 0x00000000, 0x80000000, 0x0c988000, 0xe6f08000, 0xffdf8000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xffffffff, 0xff389ae7, 0xffffffff, 0xff389ae7, 0x00000000, 0x00030006, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xffffff55, 0x4ce6cffe, 0xffffff55, 0x4d31e1e9, 0xfb4ffe59, 0xfffcf001, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xffffffff, 0xff764a9a, 0xffffffff, 0xbf764aba, 0x7fff3ff0, 0xfffe8000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xffed545b, 0xba8b4081, 0xffed545b, 0xba8b4081, 0x00000000, 0x7fff0000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x80000000, 0x00000000, 0x80000000, 0x02de41b6, 0x7fff05f4, 0x7fe0ffca, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x8e38e38e, 0x38e38e38, 0x8e38e38e, 0x38f888f8, 0x00007fe0, 0x002a7ffa, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x003959f5, 0xc83b70dd, 0x003959f5, 0xc85db054, 0x0e5ec001, 0xff770000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x0000000c, 0x4b8b9d19, 0x0000000c, 0x4b92db66, 0xc00f8000, 0x0000ffe3, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x00006e32, 0x00000000, 0x0001ade7, 0x0000fffb, 0xc00f7fff, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x80000000, 0x00000000, 0x7fffffff, 0xffffffe1, 0x001f0a00, 0x0000ffff, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xf0f0f0f0, 0xf0f0f0f0, 0xf0f0f0f0, 0xf0f3dc7f, 0x000efc7d, 0xff2bfff8, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x00000005, 0x00000000, 0x3f8d80e9, 0x00e37fff, 0x7fff8001, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x1fffffff, 0xfffffff0, 0x20000000, 0x007f5245, 0x0ee400ff, 0x7ffffffd, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x80000000, 0x00000000, 0x7fffffff, 0x80010000, 0x80008000, 0x7fff7fff, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x00000000, 0x00000000, 0x0004056c, 0xff00e1aa, 0xffde0002, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x00000000, 0x00000000, 0x400fffdf, 0x7fff7fff, 0x00227fff, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x00000000, 0x00000000, 0x2aaa71cb, 0xaaaa1c71, 0xfffb8000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x80000000, 0x00000000, 0x7fffffff, 0xfff15a90, 0x800000b8, 0x007e001e, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x3fffffff, 0xfffffff8, 0x40000000, 0x010d6008, 0x0ff88000, 0xffe40ffe, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xe0203fbf, 0x00003fc0, 0x80010000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xfd466820, 0x00ff3333, 0xf260ffff, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x0fffffff, 0xfffffffc, 0x10000000, 0x002dcbf4, 0x0ffcee0b, 0xfd740001, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x24924924, 0x92492492, 0x24924924, 0x524aa490, 0x7fff7fff, 0x80000002, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xffffffff, 0xe66b6847, 0xffffffff, 0xe658686d, 0xffed7fff, 0xffed7fff, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x80000000, 0x00000000, 0x7fffffff, 0xfffe148d, 0x07cd0000, 0xfc76ffc1, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x0000007f, 0x00000000, 0x0000007f, 0x0f0f0388, 0x00000000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x000006af, 0xabcceced, 0x000006af, 0x72e894b5, 0xff807fff, 0x8e380194, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xfe629883, 0x067c0000, 0x7ff0c03f, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xc0000000, 0x00000003, 0xbfffffff, 0xfff8f032, 0x2585801f, 0xfffeffc9, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x10b8748a, 0x743c61f0, 0x10b8748a, 0x6cb896c3, 0xffde0f0f, 0x803fffff, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x008405b0, 0x557c83bc, 0x008405b0, 0x5709a350, 0x00243ff0, 0x06065555, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xffffffff, 0xffe5a17f, 0x00000000, 0x3fe5a17f, 0x8000ffac, 0x00008000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0ffef098, 0x7fff0587, 0x00031ffc, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x00000012, 0x00000000, 0x00400012, 0x0000ff80, 0x80000f0f, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x00001250, 0x00000000, 0x0003df0a, 0x001effc8, 0x33337fff, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x66666666, 0x66666666, 0x66666666, 0x76628666, 0x1ff80002, 0x1ffc7fff, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x00000004, 0x00000000, 0x3fdfffc5, 0x003f807f, 0x80007fff, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x00000000, 0x00000000, 0x170b47a0, 0xe8f48004, 0xe8f48004, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x80000000, 0x00000000, 0x7fffffff, 0xffff3380, 0x001f0199, 0xff800000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xffffffff, 0xffffffff, 0x00000000, 0x00000095, 0x80000032, 0x00030000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x00000000, 0xffffffff, 0xfd8893bc, 0x13bcfffd, 0x0000e001, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x0b4f9e09, 0x00000000, 0x0b211fda, 0x80050000, 0x0ffc005d, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x00000000, 0x00000000, 0x00030100, 0xff808000, 0xfffafffe, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x80000000, 0x00000001, 0x80000000, 0x3fd80011, 0x80007ff0, 0x7fff003f, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xff013549, 0x681031d4, 0xff013549, 0x68130382, 0xf001ffed, 0xffe7ffd3, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xc0000000, 0x00000007, 0xbfffffff, 0xff809ee8, 0x0000801f, 0x00ff0a86, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x00000000, 0xffffffff, 0xbfbf01c0, 0x8000fef9, 0x3fc07fff, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x00000000, 0xffffffff, 0xfffb000a, 0x7ffffffb, 0x7ffffffb, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x00000000, 0xffffffff, 0xfb6ff842, 0x0ff8ffff, 0x00e6b6db, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x0000088e, 0xffffffff, 0xffb9b579, 0x1c717ffc, 0xff58007b, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x0000000e, 0x00000000, 0x03fdf812, 0x7fff7fff, 0x07fefffe, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x66666666, 0x66666666, 0x66666666, 0xe6666666, 0x80008000, 0x80008000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xffffffff, 0xecf94b29, 0x00000000, 0x25df4b25, 0x00048e38, 0x80007fff, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x7fffffff, 0xffffffff, 0x80000000, 0x04020001, 0x8000fffe, 0x7ffff7fa, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x80000000, 0x00000000, 0x7fffffff, 0xc0028000, 0x7ffb0000, 0xfffd8000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xf255837f, 0x47886f17, 0xf255837f, 0x0788f7b3, 0x8000ffe3, 0xffb47fff, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x80000000, 0x00000000, 0x80000000, 0x00027ffb, 0x00058000, 0x00007fff, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x03e1cdf8, 0xa96c16d6, 0x03e1cdf8, 0xe97096d6, 0xfff08000, 0x80078000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xd9e94f4d, 0x9d784e3b, 0xd9e94f4d, 0x3d7a8e38, 0x7fff7fff, 0xc0038000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x3fffffff, 0xfffffff8, 0x40000000, 0x0003fff0, 0x7fff7fff, 0x00080000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x80000000, 0x00000000, 0x80000000, 0x1006fc7a, 0x1fc800ca, 0x2d997ff8, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x00000000, 0x00000000, 0x154a9560, 0x00003fe0, 0x55558000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xffffffd8, 0x79c870b1, 0xffffffd8, 0x8c1ef049, 0x7ffc8000, 0xdb6d001a, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x00000000, 0xffffffff, 0xffff36bb, 0xe003fffc, 0x2a520001, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x0000f2f5, 0x7c6b1ec2, 0x0000f2f5, 0x3c689ec8, 0x7fff8000, 0x7ffffffa, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0xf0037fff, 0x00000000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xffffffff, 0xffffd533, 0xffffffff, 0xe001152f, 0x3ffc8000, 0x00028001, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xffffffff, 0xffffffc0, 0xffffffff, 0xfffe904a, 0xf8030017, 0xf8030017, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xfffce093, 0x7f16d58e, 0xfffce093, 0xc3a910fb, 0xdb6d8000, 0x8000e001, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xe0000000, 0x00000007, 0xe0000000, 0x00097ff4, 0x3a807fff, 0x00130000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffe5807f, 0xffff8000, 0x0035ff80, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x80000000, 0x00000000, 0x80000000, 0x01e1c1e2, 0x1ffe0000, 0x03540f0f, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xffffffff, 0xffffff00, 0x00000000, 0x00150ee6, 0x8000fcd2, 0xfffbffd6, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xf4d6bbe0, 0xd4af2714, 0xf4d6bbe0, 0xd4af0be0, 0xfffe000a, 0xfd2aff6c, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xffffffff, 0xfffe180f, 0xffffffff, 0xfffe180f, 0x0ff87fff, 0x00000000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x00000006, 0x00000000, 0x012afdb0, 0xc0037fff, 0x02560000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00064bde, 0x6def2da8, 0x00064bde, 0x6def2da8, 0x00008001, 0x000038e3, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x001f0000, 0xf5fa0000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xffffffff, 0xfffabeee, 0xffffffff, 0xc002beee, 0x80000000, 0x66667ff0, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x00000000, 0x00000000, 0x000a4200, 0x00000328, 0x03400000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x7fffffff, 0xffffffff, 0x80000000, 0x04877fff, 0x80008000, 0x0000f6f1, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x1fffffff, 0xfffffff8, 0x1fffffff, 0xfe048377, 0x0040fc01, 0x7fff0ffe, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x38e38e38, 0xe38e38e3, 0x38e38e38, 0xe38f38e1, 0x00027fff, 0x00020000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xffffffff, 0xfdb52b6d, 0xffffffff, 0xddb62b6d, 0xfffc3ffe, 0x80000000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xffffffff, 0xffffff86, 0xffffffff, 0xff5b89a5, 0x052400ff, 0x0005e001, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x80000000, 0x00000000, 0x80000000, 0x3ffe405a, 0x8000e00f, 0x00068002, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffe07fff, 0x00008000, 0x003f001d, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00002dcb, 0xf9bc70cf, 0x00002dcb, 0xe2d9b0df, 0x2dc53ff0, 0xffff8000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x3fffffff, 0xfffffffc, 0x40000000, 0x0001000c, 0xe0018000, 0xfffa0010, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xff4e7ffd, 0x00028000, 0x01657fff, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x3fffffff, 0xfffffffe, 0x40000000, 0x1c733e1f, 0x38e307fc, 0x003f7fff, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x0f0f0f0f, 0x0f0f0f0f, 0x0f0f0f0f, 0x0f0f0f0f, 0x00000000, 0xe30bfff4, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x38e38e38, 0xe38e38e3, 0x38e38e38, 0xe38e38e3, 0x00000000, 0x00000000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xf0000000, 0x00000007, 0xefffffff, 0xff92052f, 0x80047ffa, 0xff240000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xffffffff, 0xf576e81f, 0xffffffff, 0xf576e81f, 0x00000000, 0x01dbff60, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xfc000000, 0x00000001, 0xfc000000, 0x000a8001, 0x00008000, 0xffeb7fff, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x0011e31c, 0x00000000, 0x000d822a, 0xff00c00f, 0x0012ffe2, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x000068c0, 0x00000000, 0x000ee8a3, 0x7fff0000, 0xfff5001d, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xfaa7727f, 0x051b8000, 0x0fc77f80, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x00000000, 0xffffffff, 0xffff8018, 0x80007ff8, 0xfffdfffe, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x00000000, 0x00157fc0, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x80000000, 0x00000000, 0x80000000, 0x0144fd76, 0x0ff87fff, 0x028a0000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xf8000000, 0x00000003, 0xf7ffffff, 0xbfd81c3f, 0x07fc7fff, 0x8000faf1, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xffffffff, 0xfffffffe, 0x00000000, 0x009a9c28, 0x0da2ff80, 0xe2c90a45, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x00000004, 0x00000000, 0x000015e8, 0x00000579, 0x00048000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x000db8ca, 0xe62a7100, 0x000db8ca, 0xe62be7f4, 0x0007007f, 0x02f10033, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x80000000, 0x00000000, 0x7fffffff, 0xff6a2e0d, 0x0000e003, 0x04afe001, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x00066c49, 0x00000000, 0x377af3dc, 0x7fffc01f, 0xfd976db6, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x80000000, 0x00000000, 0x80000000, 0x0152375f, 0xfffc3cdd, 0x05977fff, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x80000000, 0x00000002, 0x80000000, 0x071bb8e4, 0xc0070000, 0x8000e38e, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xfffffffb, 0x9491ad9b, 0xfffffffb, 0x9491ad9b, 0xe0010000, 0xe0010000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xffffffff, 0xfffffe04, 0x00000000, 0x078a7e04, 0xf0ac003f, 0x80008000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xffd7c53c, 0x5cd959a6, 0xffd7c53c, 0x5a0cf1f3, 0xfff97fff, 0xfa66eb0b, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x80000000, 0x00000000, 0x7fffffff, 0xf00398e9, 0xe00700e2, 0xfff87fff, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x00000000, 0xffffffff, 0xfffffc02, 0x03fe0000, 0x0000ffff, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x71c71c71, 0xc71c71c7, 0x71c71c71, 0x9428d7af, 0x7fff9999, 0x7fff007f, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x66666666, 0x66666666, 0x66666666, 0x60058ba6, 0x0004e66b, 0x3fc08000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x000a003a, 0x00000000, 0x3fe8c312, 0xffa87fc0, 0x7fff0227, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xffffffff, 0xffff84fb, 0xffffffff, 0xfffc48e3, 0x80060f0f, 0xfffc0006, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x00000000, 0x00000000, 0x079a525f, 0xf0caffff, 0x7fff8003, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x00000000, 0x00000000, 0x00007ffc, 0x7ffc3fe0, 0x00000001, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x0003000e, 0x5fa455fd, 0x0003000e, 0x200724bd, 0x03148000, 0x7fff1ff0, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x002a020e, 0x00000000, 0x1272dd7c, 0x80007fff, 0x24920000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x1fffffff, 0xfffffffc, 0x20000000, 0x00000ff8, 0xfffc0000, 0xccccfc01, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x80000000, 0x00000000, 0x7fffffff, 0xfffc43b1, 0x0000c03f, 0x000f1c71, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x80000000, 0x00000000, 0x7fffffff, 0xfb0e8930, 0xf62c008e, 0xf2567ffd, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00001534, 0xe6fbfbaf, 0x00001534, 0xe8421aad, 0xe38efffe, 0x0000f489, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x7fffffff, 0xffffffff, 0x80000000, 0x10d7ffff, 0x80008000, 0x0000de50, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x80000000, 0x00000000, 0x7fffffff, 0xffffeec6, 0x000a0000, 0x0000fe47, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xfa24204c, 0x272c952e, 0xfa24204c, 0x2824f0a3, 0x8000ffef, 0xb6dbfe19, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x7fffffff, 0xffffffff, 0x80000000, 0x202eb020, 0x807f7fff, 0x7fff3fe0, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000fffc, 0x00000000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x000d0000, 0x000d0000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xfffffffc, 0xe50728f9, 0xfffffffd, 0x49912909, 0x7ff0b6db, 0x80007fff, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x00000000, 0xffffffff, 0xfff95548, 0x7ff0000f, 0x8e380000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x3fffffff, 0xfffffff8, 0x3fffffff, 0xff00c7f5, 0xfc017fff, 0x00013ffe, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x00000000, 0xffffffff, 0xe0100000, 0x7fff8000, 0x3fe00000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x0000000a, 0xd15c588b, 0x0000000a, 0xd15c588b, 0x0000ff00, 0x00000000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xffc813c6, 0xc149c5e6, 0xffc813c7, 0x0149c5e6, 0x80000000, 0xe0078000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x7fffffff, 0xffffffff, 0x80000000, 0x05084908, 0x00017ff8, 0x0a129999, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xf0000000, 0x00000007, 0xf0000000, 0x00000007, 0xffe50000, 0xff270000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xf0000000, 0x00000001, 0xf0000000, 0x08848001, 0x8000edc8, 0x8000012f, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000074, 0x1b0038de, 0x00000074, 0x1b36b871, 0x7fffff94, 0x0000006d, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xf0000000, 0x00000001, 0xefffffff, 0xffff2c61, 0xfff00000, 0x7fff0d3a, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x80000000, 0x00000000, 0x7fffffff, 0xfff91c64, 0xf803003e, 0xe38e0000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xfe125772, 0x6b08c6aa, 0xfe125772, 0x6b095ed4, 0x00020006, 0xeeb27fff, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x00000000, 0x00000000, 0x1ff88000, 0x00008000, 0xc00ffffd, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xffff0000, 0xffff0000, 0xffff0000, 0xf5667ffa, 0x7fff8000, 0x15370006, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x80000000, 0x00000000, 0x7fffffff, 0xf0009fff, 0x00007fff, 0xe0018003, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x7fffffff, 0xffffffff, 0x80000000, 0x0001ffbf, 0x00027ff0, 0x00027ff0, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x7fffffff, 0xffffffff, 0x80000000, 0x00000229, 0xfffdfff8, 0x0113fc6a, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x0016ab99, 0x4543824b, 0x0016ab99, 0x254b823b, 0x00018000, 0x3ff0fff0, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xe0000000, 0x00000007, 0xdfffffff, 0xfb81bbc9, 0xe01f8000, 0x07fe03fe, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x0ffc0000, 0x0ffc0000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x00000006, 0x00000000, 0x00000004, 0xffff0001, 0xffff0001, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xe0000000, 0x0000000f, 0xe0000000, 0x0000000f, 0x00000000, 0x8000803f, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x1fffffff, 0xfffffff8, 0x20000000, 0x00017ff5, 0x7fff0000, 0x00000003, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x00000000, 0x00000000, 0x1ff67e85, 0x807f3ff0, 0x7ff0fffb, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00007fff, 0x00007fff, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xfc000000, 0x00000001, 0xfc000000, 0x00000001, 0x000c0000, 0x00000000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x7fffffff, 0xfffffffe, 0x7fffffff, 0xfffa5b77, 0x24927fff, 0xfffbffea, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xffffffff, 0xffd3e3a7, 0xffffffff, 0xffe36388, 0x001f0000, 0xf0037fff, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xfd0a0000, 0x00000000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x00000000, 0xfe687fe0, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xbfc7d4e3, 0x7fffc71c, 0x00ff8000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x7fffffff, 0xfffffff9, 0x7fffffff, 0x8002fff5, 0x80048000, 0x7fff7fff, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x7fffffff, 0xffffffff, 0x80000000, 0x30039ff8, 0x8000e007, 0x7fff8000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x7fffffff, 0xffffffff, 0x80000000, 0x00077ff0, 0x7fff000f, 0x7fff0000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x7fffffff, 0xffffffff, 0x80000000, 0x0148886e, 0xffc07fff, 0x0291ffd4, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x0007ffe0, 0x00000000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xc0000000, 0x00000003, 0xbfffffff, 0xffc82eab, 0xf801000c, 0xeb5106dc, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x80000000, 0x00000000, 0x7fffffff, 0xffffffc8, 0xffc80000, 0x00000001, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x0000003f, 0x00000000, 0x0000003f, 0xfdfffffe, 0x00000000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xf0000000, 0x00000003, 0xefffffff, 0xff43804b, 0x0179ffee, 0xfffc8000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xffffffff, 0xfe8ad804, 0xffffffff, 0xfe8adde2, 0x02ef0000, 0x7fff0002, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xff00ff00, 0xff00ff00, 0xff00ff00, 0xff00febe, 0xfffdfff7, 0x00050007, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x7fffffff, 0xffffffc0, 0x7fffffff, 0xc04d7f26, 0x7fff8000, 0x7fff009a, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x92492492, 0x49249249, 0x92492492, 0x49249249, 0xe7848006, 0x00000000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xb6db6db6, 0xdb6db6db, 0xb6db6db6, 0xdb41b6db, 0x80000059, 0x8000ffff, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xfffffff8, 0x43399daf, 0xfffffff8, 0x42529daf, 0x00008000, 0x01ce0000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xffffffff, 0xfc4d31dc, 0xffffffff, 0xfc4d31dc, 0x7fff07fc, 0x00000000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x00000000, 0x00000000, 0x000a806d, 0x80038007, 0x002bffc0, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xf8782d2f, 0x0000f0f0, 0x7ffd0000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x80000000, 0x00000000, 0x7fffffff, 0xfff40000, 0x00008000, 0x0018ffff, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x1fffffff, 0xfffffff8, 0x20000000, 0x004b843b, 0x00970002, 0x026d7fff, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000004, 0x68c0a988, 0x00000004, 0xb8b82989, 0x80007fff, 0x7fffe00f, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xffffffeb, 0x78c2edb5, 0xffffffeb, 0x78b6b66e, 0x0000057f, 0xfdc77fff, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xfff0eef5, 0x51889b89, 0xfff0eef5, 0x51889b89, 0x9249c03f, 0x00000000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x00000000, 0xffffffff, 0xf84ab6fc, 0xc09e0f91, 0xc09e0f91, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x00000004, 0x00000000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x0000006e, 0xffffffff, 0xbfd880be, 0xffb07fff, 0x80007fff, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x80000000, 0x00000000, 0x80000000, 0x40000000, 0x80000000, 0x00c28000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x00000187, 0x00000000, 0x00000187, 0x6db63fe0, 0x00000000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x3425d915, 0x16035ef6, 0x3425d915, 0x15836ef6, 0xff807ff0, 0xff807ff0, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x00000007, 0x00000000, 0x00000007, 0x155a0000, 0x7fff0000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x80000000, 0x00000000, 0x80000000, 0x09d149d4, 0x7ffa3fe0, 0x000313a2, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x00000000, 0x00000000, 0x00001b20, 0x00207fff, 0x000000d9, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x00008000, 0x00007ff0, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x33333333, 0x33333333, 0x33333333, 0x33333397, 0xffcc0005, 0x00140000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x0fffffff, 0xfffffff8, 0x0fffffff, 0xffec09f8, 0x7fc00003, 0x0000ffd8, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x00000000, 0x00000000, 0x000106ed, 0x03147fff, 0xffff007f, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x000f7e5b, 0xffffffff, 0xbf12f5dc, 0xe01f8003, 0x7fff07fc, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x80000000, 0x00000000, 0x7fffffff, 0xffffe7dc, 0x0024fff0, 0xfff4ff4f, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x0000007f, 0x00000000, 0x003d3375, 0x00000099, 0x66660000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x000085a0, 0x00000000, 0x000085a0, 0x0000ff91, 0x00000000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x00000004, 0x00000000, 0x0475c622, 0x800001de, 0xffe1f714, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xfffffe4d, 0xae92c158, 0xfffffe4d, 0xcaf3c158, 0x7ff08000, 0xc73e0000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xc0000000, 0x0000000f, 0xbfffffff, 0xfffe7ff3, 0x0007fffc, 0x80078000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xffffbb1d, 0x43b25b1f, 0xffffbb1d, 0x43b25b1f, 0x00000000, 0xcccce01f, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xe023feff, 0x80008004, 0xffc03ff8, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x1c71c71c, 0x71c71c71, 0x1c71c71c, 0x71c71c71, 0xffe50087, 0x00000000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xe0000000, 0x0000000f, 0xdfffffff, 0xfffff3c7, 0x020cfffd, 0x020cfffd, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x7fffffff, 0xfffffffc, 0x7fffffff, 0xfffffffc, 0x00000000, 0xfb1ef803, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00001313, 0xa71010dc, 0x00001313, 0xa6e69284, 0x7ffffeab, 0x8000fe58, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x80000000, 0x00000000, 0x80000000, 0x00020017, 0xfff8ffff, 0xffd1c003, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xffffffff, 0xffffffc0, 0xffffffff, 0xffffffd0, 0xfffe8006, 0x0000fff8, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x005ac344, 0x00000000, 0x005ac6bf, 0xfed7fff8, 0x0000fffd, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x18931984, 0x9e5fb4f4, 0x18931984, 0x9e5fb4f4, 0x000008e3, 0x000008e3, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x7fffffff, 0xffffffff, 0x80000000, 0x0006aab7, 0xc71c0000, 0x01beffe2, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xf8e2fc4a, 0xccbc94c7, 0xf8e2fc4a, 0xcbfa964b, 0xfe7cff9a, 0x00007fff, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x00000ea5, 0xffffffff, 0xfe7150b5, 0x7ff87fc0, 0xfcfbffe6, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x0006b784, 0xffffffff, 0xffa3b698, 0x7fff01b2, 0x800000ec, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xffffffff, 0xfffffffd, 0xffffffff, 0xe02fba8b, 0x807f000f, 0x00b23fe0, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xffffffff, 0xfffffffc, 0x00000000, 0x0007c39a, 0xffa50007, 0x7ffff401, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x7fffffff, 0xfffffffd, 0x80000000, 0x00187f9b, 0x7fff8002, 0xffcf0000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xffffffff, 0xfffffffa, 0xffffffff, 0xffff01c4, 0xfffe0002, 0x00e47fff, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xfffd5af3, 0x7fffdb6d, 0x007f001f, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000ffff, 0x00000000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x3fffffff, 0xfffffff8, 0x3fffffff, 0xfffffff8, 0x00017fff, 0x00000000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x80000000, 0x00000000, 0x7fffffff, 0xfd8ea1cf, 0x00ff0801, 0xc0078e38, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x00000000, 0x00000000, 0x00000000, 0x04078000, 0x80008000, 0xf7f10000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x80000000, 0x00000007, 0x7fffffff, 0xfffb0011, 0xfffb7fff, 0xfffb7fff, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xc71c71c7, 0x1c71c71c, 0xc71c71c7, 0x1c61c73c, 0x7fffffe0, 0x7fff0000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x8e38e38e, 0x38e38e38, 0x8e38e38d, 0xf903a2d8, 0x7fc00a50, 0x00028000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x1fffffff, 0xfffffff8, 0x1fffffff, 0xdb6f36d6, 0x042db6db, 0x7ffa0000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x80000000, 0x00000000, 0x7fffffff, 0xe6663334, 0xccccf371, 0x00007fff, 0x0, 0x0
	dspck_astio dpax.w.ph, 0xfffffffb, 0x69d2cb92, 0xfffffffb, 0x6e6ed51c, 0xffffefde, 0xb6dbfd60, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x80000000, 0x0000000f, 0x80000000, 0x3ff6000f, 0x80008000, 0x00148000, 0x0, 0x0
	dspck_astio dpax.w.ph, 0x0fffffff, 0xfffffffe, 0x10000000, 0x4000002e, 0x8000fffa, 0xfff88000, 0x0, 0x0

	writemsg "[48] Test dpsx.w.ph"
	dspck_astio dpsx.w.ph, 0x00000000, 0x00002f6a, 0x00000000, 0x03c83547, 0x92491ff8, 0x000108d3, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x00000000, 0xffffffff, 0xffd31d0f, 0x3fe0ffc7, 0x168700c8, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xc0000000, 0x00000001, 0xbfffffff, 0xc0010000, 0x7fff7fff, 0x00007fff, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x0000036b, 0x077a03a6, 0x0000036a, 0xc77a03a6, 0x00008000, 0x80007fff, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x00952fec, 0xffffffff, 0xf8b934e7, 0x01c91f5a, 0x38e37fff, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x00000000, 0x7fffffff, 0xf1776268, 0xe38ef009, 0xfafe8003, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xffffffff, 0xfffffff3, 0xffffffff, 0xc0ddf436, 0x7fff01ab, 0x80077ff0, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x000b4598, 0x7860d4a7, 0x000b4598, 0x786454a7, 0xffe40007, 0x80000000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x0000920f, 0xffffffff, 0xffcf059c, 0x7fff00d1, 0x0ffc0049, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffa4b7b3, 0xffb7f803, 0xf0017fff, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xfc010015, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x00000002, 0x00000000, 0x00000002, 0x00000000, 0x8000ffd2, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xfffff873, 0x03c6ffff, 0x00000002, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xffffffff, 0xe9e8a7d3, 0xffffffff, 0xe9d3297b, 0x7fff3fc0, 0x00060028, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xffffffff, 0xfffffffb, 0xffffffff, 0xffec0023, 0x7fff0000, 0x00000028, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x00000000, 0x00000000, 0x002e0000, 0x0000005c, 0x8000e003, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00003d56, 0xd2c15fd1, 0x00003d56, 0xd2c15fd1, 0xfff88000, 0x00000000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xfc000000, 0x00000001, 0xfc000000, 0x00000001, 0x00000000, 0x7fff7fff, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xffff0000, 0xffff0000, 0xffff0000, 0xfffe012a, 0xfed80002, 0x7fff0001, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x00000000, 0x00000000, 0x3fff8000, 0x002d7fff, 0x80000000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xe0000000, 0x00000007, 0xe0000000, 0x3ffe883d, 0x7fff020d, 0xfffc8002, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffff803f, 0x00007fc0, 0x0001fff3, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x00000000, 0x80000000, 0x00037fe4, 0x00007ffc, 0xfff90000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xfffef0fe, 0x8000fc7b, 0xffb30000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x1fffffff, 0xfffffffe, 0x1fffffff, 0xfffffffe, 0x7fff8000, 0x00000000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xf0f0f0f0, 0xf0f0f0f0, 0xf0f0f0f0, 0xfb365ad0, 0x1ed0b6db, 0x0000aaaa, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xffff70ee, 0x0f042e88, 0xffff70ee, 0x0f092e7e, 0x7ffffffb, 0x7ffffffb, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x7fffffff, 0xffffffc0, 0x7fffffff, 0xe666b29f, 0x00077fff, 0x3333000c, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x00000001, 0x00000000, 0x0003fc01, 0x0000fff8, 0x7f808003, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000fff8, 0x00002492, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x04fd00ff, 0x800003fe, 0x800003fe, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x0000ffff, 0x0000ffff, 0x0000ffff, 0x0018b892, 0xff95053b, 0xfb770000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x033172c2, 0x00000000, 0x03358aa2, 0x05fa8001, 0x0008fffc, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x0fffffff, 0xfffffff8, 0x10000000, 0x0000624a, 0x01b3f9ac, 0x000ffffe, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x00000000, 0x7fffffff, 0xf0038000, 0x7fffe007, 0x80000000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x0000007f, 0x80000000, 0x00817f7f, 0xff008000, 0x00037fff, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x7fffffff, 0xffffffff, 0x80000000, 0x0029da05, 0x03feffec, 0x7f80f803, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000076, 0x22a330e7, 0x00000076, 0x22a03147, 0x0006c001, 0x00007ff0, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x00000000, 0x08223fc0, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x33333333, 0x33333333, 0x33333333, 0x498db953, 0x0c3138e3, 0x80007fe0, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xffffffff, 0xfffffff7, 0xffffffff, 0xfffffff7, 0x00000000, 0xf8010ffc, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000fd1, 0x941a16c2, 0x00000fd1, 0x941a16c2, 0x80000000, 0xfffc0000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x0000003f, 0xffffffff, 0xbf7b003f, 0x80008000, 0xfef68000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x00000006, 0x00000000, 0x00000006, 0x0001fa45, 0x00000000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xffffffff, 0xf9f06eaf, 0xffffffff, 0xf9e80851, 0x7ffe6666, 0x00150000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x00000736, 0x00000000, 0x012c9e61, 0x0259fffe, 0x0f1b8003, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xcccccccc, 0xcccccccc, 0xcccccccc, 0xcccccccc, 0x00000000, 0x7ffffe10, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x00000000, 0x7fffffff, 0xf2bfe482, 0xd6c300fe, 0x8000aaaa, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xdb6db6db, 0x6db6db6d, 0xdb6db6db, 0x6db7db6b, 0xc00ffffe, 0x7fff0000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x0000000a, 0xffffffff, 0xfffa0016, 0x8000000c, 0x7fff0000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x00000000, 0x7fffffff, 0xffce0064, 0x00000064, 0x7fffc00f, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xffffffff, 0xff043c0e, 0xffffffff, 0xff5c6eec, 0x0006fe56, 0x33338000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x1fffffff, 0xfffffff0, 0x1fffffff, 0xfffffff0, 0x00000000, 0x0001fffe, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xffffffff, 0xffff80d4, 0xffffffff, 0xffff80d4, 0x00000000, 0xfffa8000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x00000000, 0x80000000, 0x18c86851, 0x7ffff30f, 0x0002ce6f, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000024, 0x8f22c155, 0x00000024, 0x8f21c155, 0x80000001, 0x8000fffd, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x00000000, 0xfff4005d, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x00000000, 0x7fffffff, 0xffcd479d, 0x00f47fff, 0xfff938e3, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x00000000, 0x00000000, 0x0281bf68, 0x0000ebed, 0x1ff8fff9, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x00000001, 0x7fffffff, 0xffff3333, 0x9999f0f0, 0x0000fffe, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xff6b010f, 0xd0cd0002, 0x02fcfcd8, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x0000001f, 0x80000000, 0x007ff8ef, 0x078dff00, 0x7f80fff0, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xe0000000, 0x00000003, 0xdfffffff, 0xfffffffc, 0x00010000, 0x3ffc0007, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x00000000, 0xffffffff, 0xfe0103fe, 0x7fff0000, 0x7fff03fe, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xffffffff, 0xfffffff9, 0xffffffff, 0xfce5253d, 0x00000636, 0x7ffa5555, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x00000128, 0xffffffff, 0xcccfcdf2, 0x00007ff9, 0x6666ffc0, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x00000000, 0x80000000, 0x00e5fe34, 0xff1a7fff, 0xff1a7fff, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x07ffffff, 0xfffffffe, 0x08000000, 0x0000112c, 0x05ba0000, 0x7ffffffd, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x00000000, 0x7fffffff, 0xffff2a0f, 0x00d40001, 0x02c500ff, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x00000000, 0x7fffffff, 0xfd1d0b8c, 0xf4740000, 0xe694c001, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x0a6f6607, 0x1efa9e25, 0x0a6f6607, 0x1efb7418, 0x2a01fffe, 0x7ffa0001, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffff7fff, 0xffff0000, 0xffff8000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xffffffff, 0xfffffffd, 0xffffffff, 0xbffff7bd, 0xfd408000, 0x8000fffd, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x00000000, 0x80000000, 0x38e3dff4, 0x8000fffd, 0x1ffc71c7, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xffff7043, 0xbf88adca, 0xffff7043, 0xbf88adca, 0x8000012f, 0x00000000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x00000003, 0x00000000, 0x00276083, 0xfa20ffff, 0xff0006b4, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x00000000, 0x00000000, 0x1812b202, 0x0c346666, 0xc0011ffe, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x00000000, 0x800f0004, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x07e413dd, 0x00000000, 0x07e313df, 0x00007fff, 0x00028000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xe0000000, 0x0000000f, 0xdfffffff, 0xf007000f, 0x8000ffef, 0x8000e01f, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x00000000, 0xffffffff, 0xff350b1a, 0xff358007, 0xff358007, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xf0000000, 0x00000001, 0xf0000000, 0x00000001, 0xfe2e0000, 0xfffe0000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xffffffff, 0xfffffffe, 0x00000000, 0x07363aba, 0xe00f8005, 0x0f0ffd77, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x1ff8e007, 0x00000000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xe0037fff, 0x800007fe, 0x0000c007, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x00014485, 0xffffffff, 0xfd6f4a89, 0xfff97fff, 0x05240020, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x00003ffc, 0x00000000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x00000014, 0x00000000, 0x001a7294, 0xff288000, 0xffff1ff0, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x000005d6, 0xf4ab40d9, 0x000005d6, 0xf4cea0d2, 0xff007fff, 0xfff91fe0, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x00000000, 0x7fffffff, 0xf004fff9, 0x7fff8000, 0xe003fff9, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xffffffaa, 0x29390e59, 0xffffffaa, 0x28b847a8, 0x000fff00, 0x80000d3f, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0xf7c80000, 0x80000000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x0003b7d7, 0x00000000, 0x10009807, 0x801ffff9, 0x3ffe1ffe, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x07fe8006, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x00000004, 0xffffffff, 0xfa9ca1f8, 0xf8161954, 0x0e778000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xffffffff, 0xfff96dca, 0xffffffff, 0xf801cda9, 0xc001c001, 0xe01f0002, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x7fffffff, 0xfffffffc, 0x80000000, 0x07fea008, 0x1ffc0000, 0x0047c003, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x00000000, 0x7fffffff, 0xe38e47f4, 0x80010001, 0xf0f0c71c, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x0dcc0000, 0x00090000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x00000001, 0xffffffff, 0xe008373f, 0x00073ff0, 0x7fff013e, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xf0000000, 0x00000001, 0xf0000000, 0x00000001, 0x71c7fff4, 0x00000000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x7fffffff, 0xffffffff, 0x80000000, 0x00003ffd, 0xe001fffd, 0x00000002, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xffffffff, 0xf11dfd4f, 0xffffffff, 0xf0128589, 0x2492ffe0, 0x5555079b, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xd5d529aa, 0xff005555, 0x80007fff, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xfffe5659, 0xa74f6473, 0xfffe5659, 0xa94d6cef, 0x800507fc, 0xc01f0000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000007, 0x51b5bd6c, 0x00000007, 0x55b03d6c, 0x80000000, 0x000107f5, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x0000001f, 0x80000000, 0x0fee820f, 0x7fffe01f, 0x7ff00000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x00007ffa, 0x0000fe64, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x07ffffff, 0xfffffffc, 0x07ffffff, 0xe666e662, 0x7ffe1ffe, 0x00003333, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xffffffff, 0xffffef5a, 0xffffffff, 0xbffdc558, 0xff127fff, 0x7ff8f8d5, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x00000000, 0x00000000, 0x132bd9a8, 0x80010000, 0x7fff2658, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x0000ec51, 0xffffffff, 0xe1e2f3d1, 0xc001f0f0, 0x1ff88000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x0fffffff, 0xfffffff8, 0x0fffffff, 0xfffce318, 0xfffd1fe0, 0x00190000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x00000003, 0x7fffffff, 0xfffe107f, 0x00000ffc, 0x001ffc4b, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x00000000, 0x80000000, 0x02a294cc, 0x3ffcffe8, 0xfff5f575, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xff00ff00, 0xff00ff00, 0xff00ff00, 0xbf02ff03, 0x80007fff, 0x00038007, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xe0000000, 0x00000007, 0xdfffffff, 0xfffb802a, 0xfff98000, 0xfff70005, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x0000007f, 0x80000000, 0x26ac5078, 0x8000f007, 0xc0015555, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffe6b82d, 0xec14ffff, 0x6666feb6, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x3fffffff, 0xfffffff0, 0x40000000, 0x000005f0, 0xfffa0006, 0xff000000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xffffffff, 0xfffffff8, 0x00000000, 0x02017f2c, 0x03d03ffe, 0xff9a8000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x00000000, 0x7fffffff, 0xffec00c8, 0x00008005, 0xffd800ff, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xfffffcf6, 0xfff93581, 0x0000ff91, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xffffffff, 0xffffffe8, 0xffffffff, 0xbb9f0449, 0x55557fff, 0x7fff0d26, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x00000000, 0x80000000, 0x00bb4976, 0xfe9efeb6, 0x07fc7fff, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x00000000, 0x7fffffff, 0xff0037fd, 0x0000f801, 0xe003ff00, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x00000003, 0x7fffffff, 0xc0030004, 0x00078000, 0x80009249, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x00000000, 0x7fffffff, 0xfffa8000, 0x00008000, 0xfff50000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xffffffff, 0xffbf07f5, 0xffffffff, 0xffbc07db, 0x7fffffe0, 0x8000ffe6, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xff92db59, 0xe0f2153f, 0xff92db59, 0xa0f1fe47, 0x8000008c, 0x002a8000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x0000003f, 0x7fffffff, 0xccd2af81, 0x00ee8000, 0x9999f959, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x00000000, 0x80000000, 0x07ff0000, 0x00000ffe, 0x80008005, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x0037dc2c, 0x00000000, 0x4ff6dcab, 0x7fff8000, 0x1ffe807f, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x7fffffff, 0xffffffff, 0x80000000, 0x3fe0003e, 0x7fff4924, 0x0000803f, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0xb6db0000, 0xe0070000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xffffffd8, 0xa5e1ab49, 0xffffffd8, 0xe5e12b49, 0xc0018000, 0x7fff0000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffb58e5d, 0x7ffa01d0, 0x80000265, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x07ffffff, 0xfffffffe, 0x07ffffff, 0xc001fffb, 0x7ffd7fff, 0x00007fff, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x7fffffff, 0xffffffff, 0x80000000, 0x00008bfe, 0xfffc0039, 0xffc91ff0, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x7fffffff, 0xffffffff, 0x80000000, 0x000000c5, 0xffdfff60, 0x00000006, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x7fffffff, 0xffffffc0, 0x7fffffff, 0xffffffc0, 0xff6be01f, 0x00000000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x018d0143, 0xb9740aeb, 0x018d0143, 0xb92e55b3, 0x1f1800ee, 0x3fe00055, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x7fffffff, 0xffffffc0, 0x7fffffff, 0xf43f91ad, 0x7ffffffa, 0xff121781, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x00000048, 0x00000f0f, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x0001397d, 0x8018a206, 0x0001397d, 0x7200903b, 0x7ffb3fc0, 0xff801c71, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x00000000, 0xffffffff, 0xfff48000, 0x0f088000, 0xffe90000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x00000000, 0x80000000, 0x0000008d, 0xffc0ffff, 0x01cdfffb, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x00000000, 0x7fffffff, 0xfffb85ad, 0x0003b6db, 0xfff0f801, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xfffff0e5, 0xdeafdd22, 0xfffff0e5, 0xdebb4c1d, 0x00ff00b7, 0xf007fffc, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xffffffff, 0xfffffcd5, 0xffffffff, 0xfff8fce3, 0x0000000e, 0x7ffffe35, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000344, 0xc75e94f9, 0x00000344, 0xcf5a6511, 0x00000ff8, 0x8003ff08, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xfffecccd, 0xedc66666, 0x00030000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x01f1d0d3, 0x00000000, 0x01f1d0d3, 0x000c7fff, 0x00000000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xb6db6db6, 0xdb6db6db, 0xb6db6db6, 0xdb662863, 0xe38efff4, 0xfffcffbc, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x24924924, 0x92492492, 0x24924924, 0x924c2290, 0x80000006, 0xd5ab0004, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x1fffffff, 0xfffffff0, 0x1fffffff, 0xf1ca0491, 0x71c7ffed, 0xf7131ff8, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x0000003e, 0x57f1e1af, 0x0000003e, 0x3d3ff722, 0x7fff7ffe, 0xe00f5555, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x07ffffff, 0xfffffffe, 0x08000000, 0x00037fe9, 0x00000007, 0x80037ffc, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x0000003f, 0x80000000, 0x1000c040, 0xe003c001, 0x7fff8000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xffffffff, 0xffffa0a8, 0x00000000, 0x00058408, 0x000cf1b0, 0xfffe8000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x55558000, 0x00000000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x8e38e38e, 0x38e38e38, 0x8e38e38e, 0x78a38e38, 0x7f800000, 0x1ffe8000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x00000000, 0x80000000, 0x0bd37f9c, 0x1743ff9c, 0x7fff8000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xf0000000, 0x00000007, 0xf0000000, 0x002dffab, 0x2492fffa, 0x0000febe, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x0000000f, 0x7fffffff, 0xe0008011, 0xc0030002, 0x7fff8000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0xffa00000, 0x00000000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x1fffffff, 0xfffffffe, 0x1fffffff, 0xfffffffe, 0x00000000, 0x00010025, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xdb6db6db, 0x6db6db6d, 0xdb6db6db, 0x6e0f8563, 0x1c717fff, 0xff50fffa, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000e6c, 0x2cf185fa, 0x00000e6b, 0xf9be193c, 0x00059999, 0x8000fc26, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x00000001, 0x00000000, 0x00000e15, 0x0385e003, 0x0000fffc, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x00000000, 0x80000000, 0x0000008d, 0x00050001, 0x0004ffe3, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x7fffffff, 0xffffffff, 0x80000000, 0x2007d466, 0xffa3c007, 0x7fff1fe0, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xfc04feee, 0x00113fc0, 0x0ffc0001, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x3a19a389, 0x00000000, 0x3a21f266, 0x1ffcf007, 0x0005ffc0, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xffffff7f, 0xb24c0ece, 0xffffff7f, 0xb24c0ece, 0x3ff0ffff, 0x00000000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xffffffff, 0xffe96e44, 0xffffffff, 0xfbe92ea4, 0x1ff08000, 0xf8010006, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xffffffff, 0xfffffe87, 0xffffffff, 0xd00b7e87, 0x80001ff8, 0x8000801f, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x0fffffff, 0xfffffff8, 0x10000000, 0x1c71c714, 0x003dc71c, 0x7fff0000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x7fffffff, 0xffffffff, 0x80000000, 0x0069a7ce, 0x1c71fff0, 0x8004fc01, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x00000000, 0x80000000, 0x00338000, 0x0067ffff, 0x00008000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xffffffff, 0xfffffffc, 0x00000000, 0x006901e6, 0xfffefcba, 0x1fe05555, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x7fffffff, 0xfffffffd, 0x7fffffff, 0xfffffffd, 0x00000000, 0x006adb6d, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x00000102, 0xffffffff, 0xf8dfbebb, 0x7fff07fe, 0xf3570f0b, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xf000ffff, 0x0001e001, 0x80008000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xffffffff, 0xfffff7fd, 0xffffffff, 0xfffff7fd, 0x00000000, 0x00000623, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x03726678, 0x379f21d3, 0x03726678, 0x379f21d3, 0x00008000, 0x00007fff, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xffff0000, 0xffff0000, 0xffff0000, 0xfffe8000, 0x00008000, 0xfffffff0, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x00000000, 0xffffffff, 0xeffd0000, 0x8000fff9, 0x8000e001, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x00000000, 0x80000000, 0x03329667, 0x00003333, 0xf0038002, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x00000000, 0x00000000, 0x000f1a6a, 0xc2980006, 0x005d003f, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x8e38e38e, 0x38e38e38, 0x8e38e38e, 0x38e2e692, 0x0000c81e, 0xfffde57d, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x0f0ffffc, 0x00000000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xc000f729, 0x800202f2, 0x00038000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xffffffff, 0xfffffff0, 0xffffffff, 0xff577ea0, 0xfffffe08, 0xaaaa8000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x99999999, 0x99999999, 0x99999999, 0x99999999, 0x49240000, 0xe1d50000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xffffff12, 0x1b257b7a, 0xffffff12, 0x1b35fb5a, 0xffe08000, 0x00017fff, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xfffff8d0, 0x68ef9c7c, 0xfffff8d0, 0x68ef9c7c, 0x80000000, 0x80000000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xfffffffb, 0x469d3791, 0xfffffffb, 0x4356b7e2, 0x3fe00e07, 0x3bb90003, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x00000000, 0x80000000, 0x00000252, 0x0000fffa, 0x0063ff80, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x33333333, 0x33333333, 0x33333333, 0x4cd2b327, 0x80007fff, 0xfff43333, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x99999999, 0x99999999, 0x99999999, 0xd97f9819, 0x3ff07fc0, 0x8000ffe8, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xffffffff, 0xd2e75f8b, 0xffffffff, 0xefb033d6, 0x39cb0000, 0x0079807f, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x00000000, 0x7fffffff, 0xff1f0000, 0x00038000, 0xfe3e0000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x00000002, 0x00000000, 0x0056f258, 0x00020185, 0xc71cc00f, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x00000000, 0x7fffffff, 0xffc92498, 0xfff8ff80, 0x92490003, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xffffffff, 0xfffffffb, 0xffffffff, 0xf80478ac, 0xff95f007, 0x80000253, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x00000007, 0xffffffff, 0xf0150007, 0x00008000, 0xe02a0194, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x0000006d, 0x3fa9cd30, 0x0000006d, 0x3fadf504, 0xfff10048, 0xfe8e3ffc, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x00000001, 0x7fffffff, 0xfffe0001, 0x8000fffe, 0x8000fffe, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x0ac9c25a, 0x00000000, 0x0acdfa0d, 0xfb490000, 0x001b00e5, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xffffff65, 0xd48b4c13, 0xffffff65, 0xd0d74c04, 0xf8897fff, 0xfff18000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0x7ffffffd, 0x7fff0003, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xffffffff, 0xffffffe0, 0xffffffff, 0xfd7e67fc, 0x0000f001, 0xd7e4fffa, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x0000000a, 0xffffffff, 0xffccc1b4, 0xfff83ffe, 0x00cd0002, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x00000000, 0x7fffffff, 0xf51683fe, 0xaaaa3ffc, 0x00ffe003, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x7fffffff, 0xffffffff, 0x80000000, 0x07fdffff, 0x0ffc0000, 0xfffd8000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xf8055f45, 0xc01ff003, 0xc01ff003, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xffffffff, 0xfffe9c56, 0xffffffff, 0xfffe9c56, 0x80000000, 0xf8010000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x00000000, 0x7fffffff, 0xff1a3358, 0x0f56f008, 0x00000efc, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x92492492, 0x49249249, 0x92492492, 0x334074ed, 0xdca67fff, 0x3ffc4924, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x0000007f, 0x7fffffff, 0xfff1c0f8, 0xe0010007, 0xc001ff80, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xfffe945c, 0xb2ef1065, 0xfffe945c, 0xb2ef13e5, 0xfc01ff80, 0x00070000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x33333333, 0x33333333, 0x33333333, 0x33346b4b, 0xfffbfff8, 0xff2b3fc0, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xfff85a2d, 0x00e23275, 0xfff85a2d, 0x00e23275, 0xe001002e, 0x00000000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x00000000, 0xffffffff, 0xc0004017, 0x3ff87fff, 0x7fff0003, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xfffffffe, 0xb0add741, 0xfffffffe, 0xa54325fb, 0x0eda07fc, 0x7ff87fff, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xffffffdb, 0xfcbd2611, 0xffffffdb, 0xc98a7e58, 0x7ffffffb, 0xfd2d6666, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x00000000, 0x80000000, 0x00007e92, 0xfff50001, 0x8003ffdf, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x00000006, 0xffffffff, 0xff800506, 0xf8038005, 0xff000000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7fff3fe0, 0x00000000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xc000fffe, 0x7fff0000, 0x00057fff, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x00000000, 0x00000000, 0x01df0e8b, 0xff807fff, 0xfc8b4924, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xfff8aae2, 0x83eb47c3, 0xfff8aae2, 0x806ea5f2, 0xf903e01f, 0x000f8000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x7fffffff, 0xffffffff, 0x80000000, 0x0011373f, 0xffbc3fc0, 0xffff3fe0, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xffffffff, 0xfffffffd, 0xffffffff, 0xffff7e6e, 0xffff0051, 0x00058006, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xf0f0f0f0, 0xf0f0f0f0, 0xf0f0f0f0, 0xf8eea9b8, 0xf0013352, 0x00077ffa, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xffffffff, 0xffffffff, 0xffffffff, 0xf99c800b, 0xcccc0000, 0xc01fe00f, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x000000ff, 0x00000000, 0x7fc000ff, 0x80007fc0, 0x80007fc0, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffff39ba, 0xe003001b, 0x03cafffd, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00fe65fc, 0x4cf3252d, 0x00fe65fc, 0x6cd36576, 0xc03f000a, 0xffff7fff, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x80000000, 0x00000000, 0x7fffffff, 0xc0000000, 0x80008000, 0x80000000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xffff9dad, 0x9b20bcbf, 0xffff9dad, 0xb4b21653, 0x3ff00004, 0x7fff9999, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x00000000, 0x00000000, 0x000844f6, 0xffc07fff, 0xfff60d14, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xffffcd70, 0x878ab614, 0xffffcd70, 0xc78cb614, 0x00057fff, 0x80008000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xfffff607, 0x4e30d872, 0xfffff607, 0x4e301834, 0x00ff7fff, 0x0002ffc0, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xffffffbd, 0xc6f0c624, 0xffffffbd, 0xc6ef49a4, 0x00070004, 0x80007f80, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x00000000, 0x00000000, 0x12380004, 0x1c713ffc, 0xf0018000, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0xfe986b7c, 0xe5856df2, 0xfe986b7c, 0xe18775ee, 0x000007fc, 0x7fff0001, 0x0, 0x0
	dspck_astio dpsx.w.ph, 0x00000000, 0x00000001, 0x00000000, 0x3ffffffd, 0x7ffffffe, 0x3ffe8000, 0x0, 0x0

	writemsg "[49] Test dpaqx_s.w.ph"
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0x7fffffff, 0xffffffff, 0x80000000, 0x05946d31, 0xdb6d8000, 0xfa51005d, 0x00000000, 0x00000000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0xffff2cd6, 0xf91307af, 0xffff2cd6, 0xf8d4c631, 0x8000007f, 0xc03fffff, 0x00000000, 0x00000000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0x6db6db6d, 0xb6db6db6, 0x6db6db6d, 0x5f1df8de, 0xdb6d7fff, 0xcccc7fe0, 0x00010000, 0x00010000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x7fffffff, 0xffffffff, 0x80000000, 0x7fbc03bf, 0x7ff8ffc5, 0x7ff87fff, 0x00010000, 0x00010000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x00000000, 0x00000000, 0xffffffff, 0xffffffe8, 0xfffcff1f, 0x00000003, 0x00010000, 0x00010000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0x80000000, 0x00000000, 0x7fffffff, 0xffef9dc8, 0xf995fd15, 0x010300d1, 0x00000000, 0x00000000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x24924924, 0x92492492, 0x24924924, 0x92502496, 0x7ffefff8, 0x8000ffff, 0x00010000, 0x00010000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0xe0000000, 0x00000001, 0xe0000000, 0x000059b9, 0xfff4e00f, 0x0000fc43, 0x00010000, 0x00010000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0xff00ff00, 0xff00ff00, 0xff00ff00, 0xff30fea0, 0x00300000, 0x7fff7fff, 0x00000000, 0x00000000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x80000000, 0x00000000, 0x80000000, 0x00994ab2, 0xfe260517, 0x0f0f0000, 0x00010000, 0x00010000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0x07ffffff, 0xfffffffc, 0x07ffffff, 0xffb4fffc, 0x0007004b, 0x80000000, 0x00010000, 0x00010000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xf2db9dbb, 0x00007ffa, 0xf2dbfffd, 0x00010000, 0x00010000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0x6db6db6d, 0xb6db6db6, 0x6db6db6d, 0xb6db6db6, 0x00000000, 0x000f8001, 0x00010000, 0x00010000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0x7fffffff, 0xffffffff, 0x80000000, 0x7ffe0011, 0x7ffffffe, 0xfffc7fff, 0x00000000, 0x00000000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x80000000, 0x00000000, 0x7fffffff, 0xfff60014, 0x00007fff, 0xfff60004, 0x00000000, 0x00000000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x00000000, 0x00000000, 0x00000000, 0x8064ff35, 0x00658000, 0x80007fff, 0x00000000, 0x00020000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0xfe5f10c3, 0xe760a390, 0xfe5f10c3, 0xeb23d032, 0xde5f7fff, 0x03bffff0, 0x00020000, 0x00020000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0xffffffff, 0xfffffffe, 0x00000000, 0x6465fffe, 0x80008000, 0xaaaaf0f0, 0x00020000, 0x00020000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x80000000, 0x00000000, 0x80000000, 0x0b951e8a, 0x00db3fe0, 0x157f7fff, 0x00030000, 0x00030000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0x00000000, 0x00000000, 0x00000000, 0x36db9249, 0x80007fff, 0xb6db8000, 0x00020000, 0x000a0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x00000000, 0xff147f80, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x4924c71c, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x04684d7d, 0x07fe7fff, 0x0377ff25, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x00000000, 0x00000000, 0xffffffff, 0xffd90040, 0x7fff8000, 0x0007ffe0, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x000000cf, 0x9a5c8bed, 0x000000cf, 0x7f3b824f, 0x1ff0003f, 0x7fff9249, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0x0fffffff, 0xfffffffe, 0x10000000, 0x0001ffbe, 0x00100000, 0xfff80ffe, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0x7fffffff, 0xffffffff, 0x80000000, 0x552bffe7, 0xfffdaaaa, 0x803ffff6, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffa300b9, 0x7fff8001, 0x0000ffa3, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x00000000, 0x00000000, 0xffffffff, 0xfffa000c, 0x00006db6, 0xfff90000, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x00000000, 0x00000004, 0x00000000, 0x003f4342, 0xffffff04, 0xe003db6d, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x0fffffff, 0xfffffff8, 0x10000000, 0x7ffee4c6, 0x80010001, 0xf2678000, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x00000000, 0x6304bc88, 0x00000000, 0x62f35b60, 0x8000f007, 0x0234ffcb, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0xffffffff, 0xffffffe8, 0xffffffff, 0xdb75dd20, 0x7fe00006, 0xfa0adb6d, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0x00000000, 0x00000000, 0x00000000, 0x000f1c9c, 0xffe0ffda, 0x38e38000, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x00000000, 0x00000003, 0xffffffff, 0xa5fadb71, 0x80009249, 0x7fffec4f, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0x00000000, 0x0000000f, 0xffffffff, 0xfffff905, 0x00000035, 0xffef7fff, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x3fffffff, 0xffffffe0, 0x3fffffff, 0xfffdffe0, 0x01ac0002, 0x80000000, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x00000000, 0x00000000, 0xffffffff, 0xedb82494, 0x80006db6, 0x7fff7ffd, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0xffffffff, 0xfffffffb, 0x00000000, 0x0007fffb, 0x0000fff8, 0x80007fff, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x3fffffff, 0xfffffff8, 0x3fffffff, 0xfffffff8, 0x7fff8000, 0x00000000, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0xfc000000, 0x00000001, 0xfc000000, 0x3ff10001, 0x00008000, 0xc00f0005, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xff2a4acf, 0xde8c3ffc, 0x24924924, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0x00000000, 0x00000000, 0x00000000, 0x0001ffec, 0x0002fffc, 0x00007ffb, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x00000000, 0x000002aa, 0x00000000, 0x000401aa, 0xfffffc01, 0xff800000, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x80000000, 0x00000002, 0x80000000, 0x000205b4, 0x0000cc3b, 0xfffb0000, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0x7fffffff, 0xffffffff, 0x80000000, 0x00000047, 0x1ff00024, 0x00010000, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x0012900a, 0x0e63ded6, 0x0012900a, 0x0e61ded6, 0x00000002, 0x8000001c, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x00000000, 0x00000000, 0xffffffff, 0xfff9b250, 0xff80fe1b, 0xfff8066c, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0x33333333, 0x33333333, 0x33333332, 0xb3353237, 0x7fffc03f, 0xfffe8000, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x0000000f, 0x00007fff, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0xf8000000, 0x00000001, 0xf7ffffff, 0x00210001, 0x7fe07fff, 0x80008000, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x00000000, 0x38e30006, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0x00000788, 0x9cf9f5fb, 0x00000788, 0x9cf9f5c3, 0x0000fffe, 0x000e8001, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0xf8000000, 0x00000001, 0xf8000000, 0x0046fd3f, 0x00300047, 0x7ff90003, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8000e003, 0x00000000, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0x7fffffff, 0xffffffff, 0x7fffffff, 0x801fffc1, 0x7fff0000, 0xcccc801f, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x7fffffff, 0xfffffffe, 0x7fffffff, 0xf883ce44, 0x0ff8ff21, 0xb6dbc003, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xff3dec21, 0x0611807f, 0x0000f001, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x7fffffff, 0xfffffff8, 0x7fffffff, 0xf7d91fde, 0x9249f803, 0x7ffe0031, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0xffffffff, 0xffffff00, 0x00000000, 0x3ff0ff00, 0x00008000, 0xc00fc003, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0xffffffff, 0xffe241e9, 0xffffffff, 0xffe56f15, 0x80000f0f, 0x000afffe, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0x00000000, 0x00000000, 0xffffffff, 0xffffff88, 0x0000fffc, 0x000f0065, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0x00000000, 0x00000004, 0xffffffff, 0x7805bf8c, 0x7fffe00f, 0x1ffc8000, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0xc0000000, 0x00000007, 0xbfffffff, 0x70cef337, 0x80007ff8, 0xf0cd7fff, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x80000000, 0x00000000, 0x80000000, 0x00000f80, 0xff08fffc, 0x0000fff8, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0xffffffff, 0xfffffff7, 0xffffffff, 0xe78c30e3, 0xe78afffe, 0x80007fff, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0x24924924, 0x92492492, 0x24924924, 0x1249e496, 0x8000ffff, 0x1ffe7fff, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x00000000, 0x00000000, 0xffffffff, 0x80010000, 0xe0018000, 0x7fff0000, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x7fffffff, 0xffffffff, 0x80000000, 0x7f7e89b7, 0x7ffffea5, 0x002c7f80, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x00000000, 0xe0011c71, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0xfffffffa, 0x3271a679, 0xfffffff9, 0xb2aea679, 0x80008000, 0x00037fc0, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0x00000000, 0x00000000, 0x00000000, 0x00084bde, 0xf8019999, 0xffffff88, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0xffffffff, 0xffffff8e, 0xffffffff, 0xf0071f80, 0x056b7fff, 0xf0070000, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x7fffffff, 0xffffffff, 0x7fffffff, 0x7e333a5f, 0x0ffe7ffa, 0x8000f168, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0x00000000, 0x00000001, 0xffffffff, 0xfc41ff01, 0xff808000, 0x03fec001, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0x00000000, 0x00000018, 0xffffffff, 0xf6a49bf0, 0x8000fe99, 0xcccc09eb, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0xe0000000, 0x00000007, 0xe0000000, 0x000183b7, 0x00037fff, 0x000115f3, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0x0fffffff, 0xfffffffc, 0x0fffffff, 0xfffffffc, 0x0000fffd, 0x00000000, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0x7fffffff, 0xffffffff, 0x80000000, 0x0000002f, 0xfffc8000, 0x0000fffa, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0xffffffff, 0xffffff32, 0x00000000, 0x00016ed6, 0x00170000, 0xf8e007fe, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0xffffffff, 0x1585a691, 0xfffffffe, 0x95a72df3, 0x7ffff0f0, 0xfff3801f, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0x1fffffff, 0xfffffffc, 0x20000000, 0x000000ac, 0x3ff00058, 0x00010000, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0xdcbc91a8, 0x8b369f8f, 0xdcbc91a8, 0x8b3edd7f, 0xfc010000, 0x2d2cfef8, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x80000000, 0x00000000, 0x7fffffff, 0xfffa0000, 0x80007fff, 0x00000006, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x00003f5b, 0x0f60cd1e, 0x00003f5b, 0x0f60cd1e, 0x00008000, 0x00008000, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0x80000000, 0x00000000, 0x80000000, 0x000000ba, 0xfffeffe1, 0xfffd0000, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0xffffffff, 0xffffffe0, 0xffffffff, 0xf007ffe0, 0x0ff80006, 0x00008000, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x00000000, 0x00000005, 0x00000000, 0x44840005, 0x8000e00f, 0x8000db6d, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x00000001, 0xd93ec0f4, 0x00000001, 0xd91fc0f4, 0x7ffe8000, 0x001f0000, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x00000000, 0x00000000, 0xffffffff, 0xc0257fb6, 0x7fff7fff, 0x001ec007, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0xffffffff, 0xfffffffb, 0x00000000, 0x0000fff7, 0x8002ff4e, 0x0000ffff, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0x0fffffff, 0xfffffffe, 0x10000000, 0x7f69b805, 0x49248000, 0x8000fef9, 0x000a0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0xffffffff, 0x4ecd37bf, 0xfffffffe, 0xdd5e386f, 0xff7c8000, 0x71c7aaaa, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x7fffffff, 0xffffffff, 0x80000000, 0x00b1bb1d, 0x07407fff, 0x00b1000d, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0x80000000, 0x00000000, 0x7fffffff, 0xeb1ac922, 0xb6db0005, 0x0fef2492, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xa75e1a0c, 0xfca5ff86, 0xf0f07ffd, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0xc0000000, 0x0000000f, 0xc0000000, 0x2493020f, 0x8000fff8, 0xffe0db6d, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0x00000000, 0x00000007, 0xffffffff, 0xffe5ff3d, 0xffe57f80, 0x00017fff, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x80000000, 0x00000000, 0x80000000, 0x1ffbc008, 0x00007fff, 0x1ffcffff, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x09f1ffe0, 0x00000000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x00000000, 0x0000007f, 0x00000000, 0x000333bf, 0xfff8e001, 0x0000cccc, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x3fffffff, 0xfffffffc, 0x3fffffff, 0xff6b3298, 0xfffffb59, 0x0ffe0000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x80000000, 0x0000001f, 0x80000000, 0x3ffb8027, 0x00007fff, 0x3ffc0000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0xf0f0f0f0, 0xf0f0f0f0, 0xf0f0f0f0, 0x83558304, 0xffff6db6, 0x801f0000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0xffbf0e92, 0xd352c2a3, 0xffbf0e92, 0xd34bc2b1, 0x7fff0000, 0x0000fff9, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x00000000, 0xd2690abc, 0x00000000, 0x526a2aba, 0x8000ffff, 0xf0017fff, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0xffffffff, 0xff71ddae, 0x00000000, 0x32a47700, 0x8006ffff, 0x801fcccc, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x00000000, 0x2c2db31a, 0x00000000, 0x1e8f2012, 0x8000e001, 0x367c0000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0xfffffff8, 0x167a2b30, 0xfffffff8, 0x167b47a4, 0xfffbf001, 0x0000e38e, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaa2, 0x00b60004, 0xffff0000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0xffffffff, 0xfffffffb, 0xffffffff, 0x800ec6f5, 0x001f8000, 0x7fff38e3, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0x00000000, 0x00000000, 0xffffffff, 0xfffbf808, 0xfffc0004, 0xff007fff, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0xffeca179, 0x9c0defe7, 0xffeca179, 0xa328844f, 0xfffd38e3, 0x0ffc00c0, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x7fffffff, 0xfffffffa, 0x7fffffff, 0xfc00dfee, 0x0000e003, 0x0ffe0006, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0xfffffe6e, 0x201ba127, 0xfffffe6d, 0xa014a127, 0x7fff0008, 0x80008000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x00000000, 0x00000000, 0xffffffff, 0xfe4f6b2e, 0xb6db0000, 0x999902f5, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0x00000000, 0x0000007f, 0x00000000, 0x0ffee081, 0x7fff0ffe, 0x7fff0001, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0xffffffff, 0xfffffffe, 0xffffffff, 0x8004fff6, 0xc0078004, 0x7fff0000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0x0fffffff, 0xfffffff8, 0x10000000, 0x4924fff8, 0x7fc08000, 0xb6db0000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0x00000000, 0x00000000, 0x00000000, 0x1863fffe, 0x92498003, 0x55558000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x80000000, 0x00000000, 0x80000000, 0x000026ac, 0x00000006, 0x03398000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0x1fffffff, 0xfffffffe, 0x20000000, 0x7ffe0120, 0x7ffffffc, 0xffdc7fff, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x00000000, 0x00000000, 0x00000000, 0x00400000, 0xffc07f80, 0x00008000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0xf0000000, 0x00000001, 0xefffffff, 0xfff80011, 0x0000fff8, 0x7fff8000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x3fffffff, 0xfffffffc, 0x3fffffff, 0xfffffffc, 0x00000000, 0xfffeffe0, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0x00000000, 0x00000007, 0xffffffff, 0xffffffe7, 0x0000fff8, 0x000207a4, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0x80000000, 0x00000000, 0x7fffffff, 0xff7c0000, 0x00840000, 0x00698000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x80000000, 0x0000007f, 0x80000000, 0x00000043, 0x031cfffa, 0x00050000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0xffffffff, 0xf8704678, 0xffffffff, 0xf8704678, 0xf058800f, 0x00000000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x80000000, 0x0000007f, 0x7fffffff, 0xfff324df, 0xfffe0026, 0xdb6d7fff, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0x0f0f0f0f, 0x0f0f0f0f, 0x0f0f0f0f, 0x58313cef, 0x49241ffc, 0xfffb7fff, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0xfffffffc, 0x9321c3c0, 0xfffffffc, 0x92cbc46c, 0x0000ffaa, 0x7ffffffb, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0x00000000, 0x00000003, 0x00000000, 0x00015555, 0x000038e3, 0x00037f80, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0xffffffff, 0xfff40401, 0x00000000, 0x0dc7e859, 0xf5177fff, 0x02eb8001, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x00000000, 0x00000000, 0xffffffff, 0xffe67a34, 0x001a06ca, 0x00098000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0xe0000000, 0x00000001, 0xe0000000, 0x80000000, 0x80000000, 0x80048000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x80000000, 0x0000003f, 0x7fffffff, 0x8009002f, 0x7fff7fff, 0x00088000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x00000000, 0x00000000, 0x00000000, 0x1fff0000, 0x8000fffa, 0x8000e007, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0xc71c71c7, 0x1c71c71c, 0xc71c71c7, 0x1ce2c63c, 0xffff7fff, 0x00708000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x00000000, 0x00000000, 0xffffffff, 0xff2b63f0, 0xff8271c7, 0xff10ff44, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xf266fffb, 0x8000fffe, 0x00010d99, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x7fffffff, 0xffffffff, 0x80000000, 0x07c5007f, 0xf7fbffc0, 0x7fff8000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0x00000000, 0x00000000, 0x00000000, 0x7ffe0002, 0x00007fff, 0x7fff7fff, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0xffffffff, 0xfffffff2, 0xffffffff, 0xffffff2a, 0x0001fffc, 0x00190000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0x33333333, 0x33333333, 0x33333333, 0xb3190b24, 0x8000029b, 0xfafb8000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x3fffffff, 0xfffffff0, 0x3fffffff, 0xfffe0004, 0x7fffffff, 0xfff8fffe, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0x3fffffff, 0xfffffff0, 0x40000000, 0x0251fb50, 0x80007fff, 0x0250fffe, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0x00cf4fc0, 0x55a72693, 0x00cf4fc0, 0x55b72613, 0x00100000, 0x00007ffc, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0xc71c0000, 0x00000000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x80000000, 0x00000000, 0x80000000, 0x3fa20000, 0xc01f8000, 0x003f8000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0x0fffffff, 0xfffffff8, 0x10000000, 0x001087b0, 0x02123fc0, 0x000003fe, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0xffffffff, 0xfff466a6, 0x00000000, 0x198d19da, 0x00013ffe, 0x33330000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x00000000, 0x0000000f, 0xffffffff, 0xffff000f, 0x80007fff, 0x00000001, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0xffffe351, 0x19cff3df, 0xffffe351, 0x1a35d2c3, 0xffe15555, 0x0093f003, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x00000000, 0x00000000, 0x00000000, 0x00034480, 0x0000e5dc, 0xfff07fff, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0xfffffc7c, 0x3136be68, 0xfffffc7c, 0x4f2db500, 0xc00f8000, 0x0008c3f4, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x0001e5cd, 0x994d42cb, 0x0001e5cd, 0x994d42cb, 0x80000000, 0x80000000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x03ffffff, 0xfffffffe, 0x03ffffff, 0xf7ff0ff8, 0x7fff0004, 0x8000f803, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0xffffffff, 0xfff8ebaa, 0xffffffff, 0x8012dda0, 0x801ff9e6, 0x007f7fff, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0x00000000, 0x00000000, 0x00000000, 0x1175dd14, 0x7fff71c7, 0x00001176, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0x00000017, 0xc417ec8c, 0x00000017, 0xc43cec90, 0xfffeffd9, 0x80007fff, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0x00014957, 0xb94c731c, 0x00014957, 0xb9501dca, 0x0001e38e, 0xfff47fff, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x1fffffff, 0xfffffff0, 0x20000000, 0x006122d0, 0xff8f097a, 0x0563059e, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x00000000, 0x00229851, 0x00000000, 0x00229851, 0x00000e45, 0x00000015, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x6db6db6d, 0xb6db6db6, 0x6db6db6d, 0xb6db6db6, 0x003f000e, 0x00000000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x7fffffff, 0xffffffc0, 0x7fffffff, 0xfff9bfc6, 0xffff9249, 0x00071ffc, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x7fffffff, 0xffffffff, 0x80000000, 0x00077fdf, 0xe0018002, 0x1ff88000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0x00000000, 0x2aaad1ad, 0x00000000, 0x2983380d, 0x66668000, 0x012e0008, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xe0070000, 0xe0070000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x00000000, 0x00000000, 0xffffffff, 0xfed3701a, 0x7fffdb6d, 0xfffbfed2, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0xffffffff, 0xfffff372, 0xffffffff, 0xbdbd59da, 0x7fff0f0f, 0x8000cccc, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0xffffffff, 0xfffffffc, 0xffffffff, 0xe7e90c14, 0xe3e50002, 0x001f6db6, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0x7fffffff, 0xfffffff9, 0x7fffffff, 0xf84bacab, 0x71c7ff97, 0x8000f6df, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0x000106ee, 0xa5857119, 0x000106ee, 0x8589b0fb, 0xe003fff8, 0x00007ffb, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x00000000, 0x00000000, 0x00000000, 0x3ff70020, 0x80007fff, 0x7ff03ff8, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0x03ffffff, 0xfffffffe, 0x03ffffff, 0xfffa282a, 0x001800a9, 0x001ee003, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0x00000000, 0x00000013, 0xffffffff, 0xc2f00013, 0x8000fd50, 0x80003fc0, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x00000000, 0x00000000, 0xffffffff, 0xc00bfff0, 0x80008001, 0xfff83ffc, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0x7fffffff, 0xfffffffd, 0x7fffffff, 0xfffffffd, 0x80007fff, 0x00000000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x00000000, 0x00000000, 0xffffffff, 0xe03a3522, 0xe00f002b, 0x7fe07fff, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x8000003f, 0x00000000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0xffffffff, 0xfffffe44, 0x00000000, 0x81c1fabe, 0x0ffc7fff, 0x71c77fff, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x801ffff8, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0x80000000, 0x00000000, 0x7fffffff, 0xfff607c0, 0xffe0fff0, 0x000027e1, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x00000000, 0x00000000, 0xffffffff, 0xcbec8822, 0x7ffff003, 0xffffcbec, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0x80000000, 0x00000000, 0x7fffffff, 0xfffc0000, 0x0004fffe, 0x00008000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0x00000000, 0x00000005, 0x00000000, 0x00000005, 0x7fff0000, 0x7fff0000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0xffffffff, 0xfffffcec, 0xffffffff, 0xd821fcec, 0x80008000, 0x1fe007fe, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0xfc0b2f8e, 0x51a4180a, 0xfc0b2f8e, 0x51a4055a, 0x005cfff3, 0x005cfff3, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0xffffffff, 0xfffffffe, 0xffffffff, 0xfffffffe, 0x01058e38, 0x00000000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x00000000, 0x00000000, 0x00000000, 0x11440c4e, 0x00037ff9, 0x1145ffae, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0x1fffffff, 0xfffffff8, 0x20000000, 0x000198d8, 0xfff08000, 0xfffe0339, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0xfffff13e, 0x47048cc4, 0xfffff13e, 0x06a28da8, 0x80007fff, 0xff8e3ff0, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffa017, 0xfc010006, 0xfc010006, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x80000000, 0x00000004, 0x7fffffff, 0xfffd000a, 0x7fff0000, 0x8004fffd, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x00000000, 0x00000000, 0xffffffff, 0x80010000, 0x800f8000, 0x7fff0000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0x7fffffff, 0xfffffff8, 0x80000000, 0x00f8fe06, 0x7fff0000, 0x7fff00f9, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0x00000000, 0x00000000, 0x00000000, 0x0006ffe4, 0xfff900ff, 0x00008002, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0x7fffffff, 0xffffffff, 0x80000000, 0x666d38ef, 0x8e389999, 0x8000fff9, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x7fffffff, 0xfffffffc, 0x80000000, 0x01cbb22e, 0x03e9807f, 0x00273fc0, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x00000000, 0x0031b553, 0xffffffff, 0x8033b551, 0x00008001, 0x7fff0003, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x0000a24f, 0x8215c333, 0x0000a24f, 0xb8654371, 0x80008001, 0xc01f0991, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x00d7d86e, 0xc845e3f6, 0x00d7d86e, 0xc845500e, 0xfff6ffff, 0x3ffe00ff, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0xf0000000, 0x00000007, 0xefffffff, 0xffe40727, 0xff8e8000, 0x001cfff8, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0xfffa49e9, 0x7af19a01, 0xfffa49e9, 0x7ae0ff5d, 0xfe867fff, 0xfffe04f2, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x00000000, 0x000003fe, 0x00000000, 0x000003fe, 0x00000000, 0xffdf0000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x00000000, 0x0006ac2f, 0xffffffff, 0xe015aa6f, 0x7fe0ff17, 0x0000e007, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x3fffffff, 0xfffffffc, 0x40000000, 0x7ff9588a, 0x026d8002, 0x80060047, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x80030000, 0x00000000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0x80000000, 0x00000000, 0x7fffffff, 0xffffffe4, 0x00000002, 0xfff97ffb, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x7fffffff, 0xffffffff, 0x80000000, 0x10657ba7, 0xf003068b, 0x07fc8000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x00000000, 0xd66fd94c, 0x00000000, 0xd65eec6c, 0xffbcffef, 0x7f80fffc, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0xf0000000, 0x00000007, 0xf0000000, 0x00000007, 0x00007fe0, 0x00007fff, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0x71c71c71, 0xc71c71c7, 0x71c71c71, 0xc73871c7, 0x8000ffe5, 0x8000ffff, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xef13ffff, 0x80008000, 0xf0f01ffc, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x00000000, 0xfffd8000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0x0fffffff, 0xfffffffc, 0x0fffffff, 0xfffffffc, 0x80017fff, 0x00000000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x00000000, 0x0004fa09, 0x00000000, 0x00d472c5, 0xe00fff40, 0x8000ffc2, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x000019d6, 0x25d2e61a, 0x000019d6, 0x25d2e61a, 0x00000000, 0x007f0001, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0xffffffff, 0xfffffffb, 0xffffffff, 0xfffffffb, 0x00000000, 0x00008000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0x00000000, 0x00000000, 0xffffffff, 0xfc004d44, 0xfffde00f, 0x0ffc6db6, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xce3fffff, 0x8000fe8d, 0x80003333, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0x00000002, 0x77029de6, 0x00000002, 0x77029de6, 0x0000ffb5, 0x00000000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0xfffff9e6, 0xd57b1bc1, 0xfffff9e6, 0xc633f18f, 0x1ff0fd49, 0xe01fc00f, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0x00000000, 0x00000007, 0x00000000, 0x00000007, 0x00000000, 0xfd7ef003, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x00001c0d, 0xdcaa4259, 0x00001c0d, 0xdcbc4235, 0x7fff0009, 0x7fff0009, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0x7fffffff, 0xffffff80, 0x7fffffff, 0x8000ff80, 0x80000000, 0x7fff7fff, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x80000000, 0x00000002, 0x7fffffff, 0xfa180002, 0x800001d1, 0x000005e8, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x7fffffff, 0xffffffe0, 0x80000000, 0x04def622, 0x7fe07fff, 0x04df0000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0xffffffff, 0xfffbee6c, 0x00000000, 0x3ff8ee6c, 0x80000000, 0xf001c003, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0x80000000, 0x00000000, 0x7fffffff, 0x8002b414, 0xffc17fff, 0x8000fc8a, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0xffffffff, 0xff546bd0, 0xffffffff, 0xff586bd0, 0xf003fffc, 0x80000000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0x24924924, 0x92492492, 0x24924924, 0x92492492, 0xf5e80000, 0x80000000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0x7fffffff, 0xfffffffb, 0x7fffffff, 0xf5a7ffff, 0x7fff0a56, 0x8000fffe, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0x00000000, 0x00000528, 0xffffffff, 0xff72e8f2, 0xf82ff932, 0x7fff9999, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0x00000000, 0x00000000, 0x00000000, 0x00dae090, 0xf0f0ffff, 0xfff8f8bc, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x0000ffff, 0x0000ffff, 0x0000fffe, 0xffb107ff, 0xffd03ffc, 0xff008000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0x0fffffff, 0xfffffffe, 0x0fffffff, 0x8004fffe, 0x8000fffc, 0x80007fff, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0xffffffff, 0xfffffffd, 0xffffffff, 0xaaaaaaa9, 0x7fff8000, 0x0000aaaa, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0x0fffffff, 0xfffffff8, 0x10000000, 0x000dffea, 0x00000015, 0x55553c28, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac1, 0x00000000, 0x00000000, 0x00000000, 0x24f94f56, 0x8000fd5b, 0xfff1db07, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac3, 0x80000000, 0x0000003f, 0x7fffffff, 0xf9082a17, 0x00027ffd, 0xf9067fff, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0x80000000, 0x00000000, 0x80000000, 0x0a7f4d02, 0xdb6dc03f, 0xffe8db6d, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac0, 0x80000000, 0x0000003f, 0x7fffffff, 0xffc23e3f, 0x000f7f80, 0xffc20000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0xf0000000, 0x00000003, 0xefffffff, 0xfff471cd, 0xfff3e186, 0x000071c7, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xfffc03fe, 0x00000000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0x7fffffff, 0xfffffff8, 0x80000000, 0x7f7efdf8, 0x7f80ff80, 0x00037fff, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0xffffffff, 0xfffe99c9, 0xffffffff, 0xfffe99c9, 0x00000000, 0x0000f801, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_s.w.ph, $ac2, 0x80000000, 0x00000000, 0x80000000, 0x1872bff8, 0xe38e3ffc, 0xf8018000, 0x000f0000, 0x000f0000

	writemsg "[50] Test dpaqx_sa.w.ph"
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0xffffffff, 0xe0000003, 0xffffffff, 0xa57e0003, 0x80008000, 0xcccc6db6, 0x00000000, 0x00000000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0xffffffff, 0xf88d618b, 0xffffffff, 0xf887a56b, 0xfffcfe2e, 0x007a7fff, 0x00010000, 0x00010000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0xffffffff, 0x80000000, 0xffffffff, 0x800f1c6e, 0x000071c7, 0x00118002, 0x00010000, 0x00010000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0xffffffff, 0x80000000, 0xffffffff, 0xbfef8020, 0x00007fff, 0x3ff0ffff, 0x00010000, 0x00010000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0x00000000, 0x000140d3, 0xffffffff, 0xfffe40d9, 0x7fff6666, 0x0000fffd, 0x00010000, 0x00010000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0xffffffff, 0xe5e57930, 0xffffffff, 0xe5de793e, 0x00007fff, 0xfff90000, 0x00010000, 0x00010000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0x00000000, 0x07361af3, 0x00000000, 0x07501abf, 0x7fff0018, 0x7fff0002, 0x00010000, 0x00010000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0xffffffff, 0x80000000, 0xffffffff, 0x80000000, 0x09fa7ff0, 0x80008006, 0x00010000, 0x00030000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0x00000000, 0x00000000, 0x00000000, 0x00008010, 0xfff87ff8, 0x000107fe, 0x00030000, 0x00030000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0x00000000, 0x324df2ec, 0x00000000, 0x3257f2d8, 0x00007fff, 0x000a3ffc, 0x00030000, 0x00030000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0xffffffff, 0xfffffffe, 0x00000000, 0x0001ffe2, 0x0000fffe, 0x80070000, 0x00020000, 0x00020000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0x00000000, 0x00000000, 0x00000000, 0x3330666a, 0x7fff3ffe, 0x6666ffff, 0x00020000, 0x00020000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0xffffffff, 0xffffffff, 0xffffffff, 0xc04ef87f, 0xc00ffff1, 0xffc07f80, 0x00020000, 0x00020000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0xffffffff, 0x80000000, 0xffffffff, 0x80000032, 0x0000fffb, 0xfffb07e8, 0x00020000, 0x00020000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0xffffffff, 0xecf8827c, 0xffffffff, 0xecf87bdc, 0xffc0ffe8, 0xfffe000e, 0x00020000, 0x00020000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0x00000000, 0x01ccab39, 0x00000000, 0x01cca86d, 0xe38efffe, 0x00b30000, 0x00020000, 0x00020000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x80030000, 0x7f800000, 0x00030000, 0x00030000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0x00000000, 0x38e38e38, 0x00000000, 0x4a5d7e40, 0xf6827fff, 0x07fc8000, 0x00030000, 0x00030000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0x00000000, 0x00000000, 0xffffffff, 0xffef0770, 0xf0078000, 0x00000088, 0x00030000, 0x00030000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0x00000000, 0x7ffffffa, 0x00000000, 0x7fffffff, 0x33330008, 0x7f80fff9, 0x00030000, 0x000b0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0xffffffff, 0x80000000, 0xffffffff, 0x80000000, 0xe38ec00f, 0x3ff80007, 0x000a0000, 0x000b0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0x00000000, 0x38e38e38, 0x00000000, 0x393a8e38, 0x80008000, 0xffa90000, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0xffffffff, 0xfffffffb, 0xffffffff, 0xfffffffb, 0x00390001, 0x00000000, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0x00000000, 0x7fffffff, 0x00000000, 0x003fffff, 0x00008000, 0x7fc07fff, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0xffffffff, 0x80000000, 0xffffffff, 0xc103fd0c, 0xc01f3ff8, 0x7ffbfde2, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0x00000000, 0x00000001, 0x00000000, 0x00000001, 0x0000f0f0, 0x00008004, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0x00000000, 0x0003f46b, 0xffffffff, 0xf0f4e62b, 0xfff47ff8, 0xf0f0fff8, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0x00000000, 0x00000000, 0x00000000, 0x02aa0000, 0x0000fd56, 0x80007ffa, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0xffffffff, 0x80000003, 0xffffffff, 0x80000000, 0x0000003f, 0xfff3e003, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0x00000000, 0x7ffffffb, 0x00000000, 0x7ffd4c1b, 0x0f0f0171, 0xff100000, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0xffffffff, 0xfffffff7, 0x00000000, 0x7ffe391f, 0xffc97fff, 0x7fffff7b, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0xffffffff, 0xfffffffe, 0x00000000, 0x69512d5b, 0x8000e951, 0x7fff8000, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0x00000000, 0x7fffffc0, 0x00000000, 0x7fffffc0, 0x00000000, 0x000e0007, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0xffffffff, 0xfffffffe, 0xffffffff, 0xfffffffe, 0x00000000, 0x80028004, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0x00000000, 0x00000009, 0x00000000, 0x00000009, 0x8000c00f, 0x00000000, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0xffffffff, 0x80000004, 0xffffffff, 0x80000000, 0x8000fff8, 0x000f3ffe, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0xffffffff, 0xfffffff1, 0x00000000, 0x2492fff1, 0x8000c007, 0x0000db6d, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0xffffffff, 0xfffffffb, 0x00000000, 0x0005c713, 0x8e380004, 0x7ffffffe, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0xffffffff, 0xc14f86eb, 0xffffffff, 0xc46a80b5, 0x8000031b, 0x7fff0000, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0xffffffff, 0x80000005, 0xffffffff, 0x8021db55, 0x7fffb6db, 0xffed0017, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0xffffffff, 0xff6e72de, 0xffffffff, 0xff74f100, 0x7fff000f, 0x3ff0ffff, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0x00000000, 0x7fffffff, 0x00000000, 0x7fffffff, 0x7fe0fff2, 0x00000000, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0xffffffff, 0xffaff986, 0xffffffff, 0xffb6f978, 0x00000007, 0x7fff0699, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0x00000000, 0x7fffffff, 0x00000000, 0x4001a6a9, 0xfffbc001, 0x7ffffc22, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0x00000000, 0x00000000, 0xffffffff, 0xffff0000, 0x80008000, 0x00010000, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0xffffffff, 0x80000003, 0xffffffff, 0xb3340003, 0x8000fafe, 0x0000cccc, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0xffffffff, 0xfffffff7, 0xffffffff, 0xfc9d31a7, 0xf274fff0, 0x00241ffe, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0x00000000, 0x00000000, 0x00000000, 0x0882eefa, 0x7fff0087, 0x7fff07fc, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0x00000000, 0x00003cf0, 0x00000000, 0x00003cf0, 0x00000000, 0xfffce007, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0x00000000, 0x00000000, 0x00000000, 0x7fa9c8d7, 0xfc7e8000, 0x80000c4a, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0xffffffff, 0xfffffff0, 0x00000000, 0x4920184c, 0x7fffe38e, 0x000f4924, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0x00000000, 0x00004275, 0x00000000, 0x1fde1a81, 0x00051fe0, 0x7fffcf2e, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0xffffffff, 0x80000000, 0xffffffff, 0x935162de, 0xffd81351, 0x7ffffe48, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0xffffffff, 0xfffffffc, 0x00000000, 0x001c9f44, 0x1c71800f, 0xff8afe6e, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0xffffffff, 0xdb6db6db, 0xffffffff, 0xdb7cb6bd, 0xffcf000f, 0x7fff0000, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0xffffffff, 0x80000000, 0xffffffff, 0x80000000, 0xc00f0005, 0x7fff3fe0, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0x00000000, 0x00000000, 0x00000000, 0x003b4548, 0x800001c6, 0x0406ffd3, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0x00000000, 0x00000000, 0xffffffff, 0xc01f7fba, 0x00047fff, 0xc01fffff, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0x00000000, 0x7fffffff, 0x00000000, 0x7fffffff, 0x3fc00111, 0x80007fff, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0xffffffff, 0xfffffd52, 0x00000000, 0x03fbfe52, 0x00007fc0, 0x03fe1169, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0x00000000, 0x006f440d, 0xffffffff, 0xf075647f, 0x7ffffffe, 0x3fe0f007, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0x00000000, 0x7ffffffb, 0x00000000, 0x60102a55, 0xff758000, 0x1ff0ffd9, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0x00000000, 0x7fffffff, 0x00000000, 0x7fffffff, 0x80008000, 0xfffbff3f, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0x00000000, 0x0f0f0f0f, 0x00000000, 0x0f0f0f0f, 0x00000000, 0x1f378000, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0xffffffff, 0xfffffe62, 0xffffffff, 0xfffffe62, 0x00000000, 0xff327ff0, 0x000a0000, 0x000a0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0x00000000, 0x0000014c, 0x00000000, 0x7ffff125, 0x8000000d, 0xff618000, 0x000b0000, 0x000b0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0xffffffff, 0x99999999, 0xffffffff, 0x80000000, 0xfb9f8000, 0x49240020, 0x000b0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0x00000000, 0x7fffffff, 0x00000000, 0x7fffffff, 0xf0017fff, 0x7fffff80, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0x00000000, 0x00000000, 0x00000000, 0x0021d94c, 0x2d3e005f, 0x07fc004f, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0x00000000, 0x0076af00, 0x00000000, 0x0076af00, 0xfff90000, 0x00000000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0xffffffff, 0x80000000, 0xffffffff, 0x80000000, 0x7fffffff, 0x7ff98000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0x00000000, 0x00000000, 0xffffffff, 0x809bfe92, 0xffe4807f, 0x7fff8002, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0xffffffff, 0xc0000003, 0xffffffff, 0xbfc02003, 0xffe07fc0, 0xffe07fc0, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0xffffffff, 0x80000000, 0xffffffff, 0x80000000, 0x00000000, 0xff70f25f, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0x00000000, 0x00000102, 0x00000000, 0x00d30cde, 0x80000045, 0x0016ff2d, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0xffffffff, 0x80000000, 0xffffffff, 0xffffffff, 0x80000000, 0x0f0f8000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0xffffffff, 0x80000000, 0xffffffff, 0x80000000, 0x80008000, 0x1fe00000, 0x000e0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0xffffffff, 0x80000000, 0xffffffff, 0x80000000, 0xfffe0000, 0x005d7fff, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0x00000000, 0x7fffffff, 0x00000000, 0x7fb6a85b, 0xfefffaa0, 0xfffe2492, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0x00000000, 0x000676a7, 0x00000000, 0x000676a7, 0xffff0000, 0x00000000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0x00000000, 0x00000000, 0x00000000, 0x7fffffff, 0x8000e2a7, 0x80008000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0x00000000, 0x00001d74, 0x00000000, 0x00001e28, 0x00020000, 0x1ffc002d, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0xffffffff, 0x8000007f, 0xffffffff, 0x8000007f, 0xfffc5555, 0x00000000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0x00000000, 0x1ffffff0, 0xffffffff, 0xb999fff0, 0x00ff6666, 0x80000000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0x00000000, 0x7fffffff, 0x00000000, 0x7ff5806b, 0x1fe0000f, 0xaaaafffe, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0x00000000, 0x55555555, 0x00000000, 0x7fffffff, 0x2fa80000, 0x80067fff, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0xffffffff, 0x8000003f, 0x00000000, 0x0000003e, 0x80001ff0, 0x00008000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0x00000000, 0x7fffffff, 0x00000000, 0x7fffffff, 0xfbeefffd, 0x03fe8000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0x00000000, 0x00000000, 0x00000000, 0x00725318, 0xff8cfa0b, 0x00248000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0x00000000, 0x00000000, 0xffffffff, 0xe99839be, 0x7fffe997, 0x7ff90000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0x00000000, 0x7fffffff, 0x00000000, 0x7fffffff, 0x0000ffe4, 0xffda8004, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0x00000000, 0x3ffffff8, 0x00000000, 0x3ffffff8, 0xf7a80000, 0x00000000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0xffffffff, 0xfe9512f0, 0x00000000, 0x7f281558, 0x7ffffe84, 0xcccc7ffc, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0xffffffff, 0xf0000003, 0xffffffff, 0xf002fffd, 0x7ffff0f0, 0x00000003, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0xffffffff, 0xff5a604a, 0x00000000, 0x075abf9a, 0xf80316b8, 0x00138000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0x00000000, 0x00000000, 0x00000000, 0x0feb0400, 0x00057fc0, 0x0ff88000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0xffffffff, 0x80000000, 0xffffffff, 0x80000000, 0x00000000, 0x80006666, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0x00000000, 0x00000000, 0x00000000, 0x0000264c, 0x8000fccf, 0xfffa0000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0x00000000, 0x00000000, 0xffffffff, 0xf9130dda, 0xf9130064, 0x00007fff, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0xffffffff, 0xffe76797, 0xffffffff, 0xf7d68095, 0x3fe07fff, 0xf801ffdc, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0x00000000, 0x00000003, 0x00000000, 0x00125559, 0x3ffcfff9, 0xf9d30024, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0xffffffff, 0xfffc3a24, 0x00000000, 0x0722b9a6, 0xc007f8de, 0x8000fff7, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0x00000000, 0x49249249, 0x00000000, 0x7fffffff, 0xc0070000, 0x80078000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0x00000000, 0x333d62fd, 0x00000000, 0x333d62fd, 0x00590000, 0x00590000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0x00000000, 0x55555555, 0xffffffff, 0xd5555557, 0x8000ffff, 0x7fff7fff, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0x00000000, 0x7fffffff, 0x00000000, 0x7fffffff, 0xe6458001, 0x00008000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0xffffffff, 0xfffffffe, 0xffffffff, 0xfffffffe, 0x00000000, 0x073f8006, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0x00000000, 0x0004819e, 0x00000000, 0x0004ba20, 0x1fe00009, 0xff990001, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0xffffffff, 0xf8000003, 0xffffffff, 0xf7ff0007, 0xffffffff, 0x7fffffff, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0x00000000, 0x000179e7, 0xffffffff, 0xf00979e7, 0x00008000, 0x0ff87fff, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0x00000000, 0x0cbac798, 0x00000000, 0x0ca9c7ba, 0xfcc0ffef, 0x7fff0000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0xffffffff, 0x80000000, 0xffffffff, 0x80000000, 0xe00ffff0, 0x00000000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0x00000000, 0x000053c0, 0x00000000, 0x000053c0, 0x00000000, 0x7ff9e007, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0x00000000, 0x00000000, 0x00000000, 0x0013ffd8, 0x7fff000a, 0x7fff000a, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0x00000000, 0x00000001, 0x00000000, 0x01320605, 0xffeafece, 0x8000ffdd, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0x00000000, 0x00000000, 0x00000000, 0x0ffca012, 0xf0038000, 0x00008003, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0x00000000, 0x7fffffff, 0xffffffff, 0xffe38475, 0x8005f5f8, 0x01b87fff, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0xffffffff, 0x80000000, 0xffffffff, 0x80000000, 0x03771ff0, 0x00000000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0xffffffff, 0xff719f94, 0xffffffff, 0xffb09dc6, 0x003ffff8, 0x00157fff, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0x00000000, 0x0000003f, 0x00000000, 0x0000003f, 0x00008000, 0x00000000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0x00000000, 0x00000fea, 0xffffffff, 0x80000000, 0x800003fa, 0xdb6d7f80, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0x00000000, 0x000001ae, 0xffffffff, 0xfffffbd2, 0x000f0000, 0xfff7ffce, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0x00000000, 0x7fffffff, 0x00000000, 0x7fffffff, 0x7fff0000, 0x7fff7fff, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0x00000000, 0x00001bec, 0x00000000, 0x003509d2, 0xc2e9fd33, 0xfc01ffc0, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0xffffffff, 0xfffb6123, 0xffffffff, 0xa4936123, 0x2db48000, 0x2db48000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0x00000000, 0x7fffffff, 0x00000000, 0x7fffffff, 0x80000000, 0x3ff8fc5f, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0xffffffff, 0xffffc18d, 0xffffffff, 0xffffc18d, 0x00000000, 0x00007fff, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0x00000000, 0x7fffffff, 0x00000000, 0x7fffffff, 0x80008000, 0xfc548000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0xffffffff, 0xfffc5700, 0x00000000, 0x7fffffff, 0x7ffffa96, 0x80007ff8, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0xffffffff, 0xf7c140e2, 0x00000000, 0x37bdc0ec, 0xc0010000, 0x001c8005, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0xffffffff, 0xdb6db6db, 0xffffffff, 0xd53050eb, 0x0000c618, 0x0dcb7fff, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0xffffffff, 0x80000000, 0xffffffff, 0x8005fff4, 0x7fff0003, 0x7fff0003, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0x00000000, 0x000001f0, 0xffffffff, 0xffffd108, 0x0c3a0000, 0xd148fffe, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0x00000000, 0x00000003, 0x00000000, 0x00000003, 0x00038001, 0x00000000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0x00000000, 0x6db6db6d, 0x00000000, 0x6db0d0dd, 0x000000ca, 0xfc2c1fe0, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0x00000000, 0x7fffffff, 0x00000000, 0x71132c51, 0xf803c00f, 0x1fe0f003, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xfff800fb, 0x00000000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0x00000000, 0x00000000, 0xffffffff, 0xe49376e4, 0x71c77fff, 0x00ffe007, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0x00000000, 0x7fffffff, 0x00000000, 0x7fffffff, 0x00008000, 0x0000f803, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0x00000000, 0x00062f91, 0x00000000, 0x2003ef95, 0x7fff0000, 0x7fff1ffe, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0xffffffff, 0xfffffff0, 0x00000000, 0x01c5ca98, 0xc71cc71c, 0xfc010002, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0x00000000, 0x00000000, 0xffffffff, 0xfedc1764, 0x00018000, 0x01240bb2, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0xffffffff, 0xffffffff, 0x00000000, 0x0001d303, 0xfffa5555, 0x0000d915, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0x00000000, 0x0000ffff, 0x00000000, 0x71c61c73, 0x7fff38e3, 0x7fff38e3, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0xffffffff, 0x80000000, 0xffffffff, 0x81e9fc2c, 0x034f7fff, 0xff146db6, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0x00000000, 0x00000000, 0x00000000, 0x00099362, 0xf626f007, 0xffc7ffe0, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0x00000000, 0x0063eed7, 0x00000000, 0x0063eed7, 0x00000000, 0x7f800016, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0xffffffff, 0xfe9b0f10, 0xffffffff, 0xfe9b7c54, 0x05680006, 0xc01f0051, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0xffffffff, 0x80000000, 0xffffffff, 0x8003ffe0, 0x0000fff0, 0xe0010000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0xffffffff, 0xfffffffc, 0xffffffff, 0xffb82e5c, 0x0000f8d0, 0x04ff0061, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0xffffffff, 0xfffff883, 0x00000000, 0x7f8bf96a, 0x80007fff, 0xff8c8000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0x00000000, 0x00000001, 0x00000000, 0x00009bed, 0xfcaa8000, 0xffff000f, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0x00000000, 0x1f505597, 0xffffffff, 0xbf4215b5, 0x1ff07fff, 0x80017fff, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0x00000000, 0x0668bf07, 0xffffffff, 0xe670bef3, 0x00028000, 0x1ff8fffb, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0xffffffff, 0xc0000003, 0xffffffff, 0xdff8ffc7, 0x8000fffe, 0x000fe007, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0x00000000, 0x0000003f, 0xffffffff, 0xfffb003f, 0x00000005, 0x8000fffb, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0x00000000, 0x046ccb93, 0x00000000, 0x04d4879b, 0xfffb03fe, 0x0cfe0000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0x00000000, 0x00ff00ff, 0x00000000, 0x00ff00ff, 0x00000000, 0x7f808003, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0xffffffff, 0xf9bdee71, 0xffffffff, 0xf9bbee75, 0x00007fff, 0xfffecaf1, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0x00000000, 0x00075732, 0x00000000, 0x00075732, 0x2d250000, 0x2d250000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0x00000000, 0x00000004, 0x00000000, 0x7fffffff, 0x80008000, 0x80008000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0x00000000, 0x0000599b, 0x00000000, 0x0000599b, 0xfffc0000, 0x00000000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0x00000000, 0x7fffffff, 0x00000000, 0x740f882b, 0xf6468000, 0x02377ff9, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0x00000000, 0x00000000, 0xffffffff, 0x80000000, 0x00d37fff, 0x80008000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0x00000000, 0x7fffffe0, 0x00000000, 0x7fffffe0, 0x80000000, 0x49240000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0xffffffff, 0xffffffcc, 0xffffffff, 0xfff800cc, 0x8000fff8, 0x1ff00006, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0x00000000, 0x00000000, 0xffffffff, 0xca06af80, 0x92497f80, 0x00ac3fc0, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0xffffffff, 0xe0000001, 0xffffffff, 0xe0080001, 0xfffbfffd, 0x80008000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0xffffffff, 0xfffffc66, 0xffffffff, 0xfffffc64, 0xc71cffff, 0x00010000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0x00000000, 0x49249249, 0xffffffff, 0xc92a923f, 0x80050000, 0xfffe7fff, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0xffffffff, 0x80000000, 0xffffffff, 0x81fee00a, 0x0ffbfe01, 0x8000ffff, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0xffffffff, 0xffffff2c, 0xffffffff, 0xff319e1c, 0x00ce001f, 0xfe4e8005, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0xffffffff, 0xc0000003, 0xffffffff, 0xdacb90c3, 0x80001b7a, 0x7ff000ab, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7fff000b, 0x00000000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0xffffffff, 0x80000000, 0xffffffff, 0x80000000, 0xedeb1ff0, 0x00007fff, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0xffffffff, 0xfff49a0a, 0x00000000, 0x0620a728, 0x0cbb7fff, 0x062c0001, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0xffffffff, 0x80000000, 0xffffffff, 0x80000000, 0x00140000, 0x000a8000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0x00000000, 0x7fffffff, 0x00000000, 0x76b9124f, 0x001f7fff, 0xf69a7ffe, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0xffffffff, 0x80000000, 0xffffffff, 0x80000000, 0x0ffe8000, 0x00000000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0xffffffff, 0xffece62f, 0xffffffff, 0xffe80297, 0x0011000b, 0xc71c0000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0xffffffff, 0x80000000, 0xffffffff, 0x8007ec08, 0x8000007f, 0x07fc0000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0x00000000, 0x00000000, 0xffffffff, 0xffc80370, 0xfff8ffc8, 0x7ff80001, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0xffffffff, 0x80000000, 0xffffffff, 0x8001bf44, 0xfffd7fff, 0x0001e01f, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0x00000000, 0x7fffffff, 0x00000000, 0x7ffffe5b, 0x0004000f, 0xfff20000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0x00000000, 0x002a6d51, 0xffffffff, 0xfdf90e8b, 0x078e3363, 0xfa81003b, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0x00000000, 0x7fffffff, 0x00000000, 0x78e463e9, 0xc71c0003, 0x000f0ffe, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0x00000000, 0x7fffffff, 0x00000000, 0x7fffffff, 0x00000000, 0x00000000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0xffffffff, 0x8000001f, 0xffffffff, 0x8000001f, 0x0005db6d, 0x00000000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0xffffffff, 0xffffff7e, 0xffffffff, 0xff56e35a, 0xc0036db6, 0x000f016c, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0x00000000, 0x6db6db6d, 0x00000000, 0x6fb5b2dd, 0x6db6012a, 0x6db6012a, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0x00000000, 0x7ffffffe, 0x00000000, 0x7fffffff, 0x8000ff59, 0x06d38000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0x00000000, 0x1ffffff0, 0x00000000, 0x2c92b712, 0xe6d5f575, 0xfffec00f, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0x00000000, 0x00000000, 0xffffffff, 0xfc01b6e0, 0x03fcfffc, 0x49248000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0x00000000, 0x24924924, 0x00000000, 0x24924924, 0x00000000, 0x000e7fff, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0x00000000, 0x7fffffff, 0x00000000, 0x7fffffff, 0x7ffd07fc, 0x55551fe0, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0xffffffff, 0x80000000, 0xffffffff, 0x80000000, 0x00000000, 0x7ffff74a, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0xffffffff, 0xffffcbb8, 0xffffffff, 0xc0eb49e2, 0x7fff0000, 0x006ac0eb, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0x00000000, 0x037df97e, 0xffffffff, 0x839df940, 0x801f7fff, 0x00007fff, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0x00000000, 0x00000047, 0x00000000, 0x000e002b, 0xfff98001, 0xfff98001, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0xffffffff, 0xc0000003, 0xffffffff, 0xc0000003, 0x6666ffff, 0x00000000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0x00000000, 0x00004b97, 0x00000000, 0x00004b97, 0x00000000, 0x00030111, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0xffffffff, 0x92492492, 0xffffffff, 0x9249648a, 0x00000001, 0x1ffc0004, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0xffffffff, 0xff00ff00, 0xffffffff, 0xff013ec2, 0x3ffcffff, 0xe01f0000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0xffffffff, 0xcfdad684, 0xffffffff, 0xcfdad6c0, 0x0000fffa, 0xfffbe493, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0xffffffff, 0xffffe46d, 0xffffffff, 0xffffe44d, 0x00000002, 0xfff80004, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0xffffffff, 0xffffcaaa, 0xffffffff, 0xfff9cbf2, 0xfff5ffc8, 0xff564924, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0x00000000, 0x0000000f, 0x00000000, 0x00000123, 0x00060000, 0xfe200017, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0xffffffff, 0x80000000, 0xffffffff, 0x80010000, 0x80001ff0, 0x0000ffff, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0xffffffff, 0x80000000, 0xffffffff, 0x80000000, 0x00003ff8, 0x0000807f, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0x00000000, 0x00000000, 0xffffffff, 0xf0635618, 0x0ffeaaaa, 0xff6e8000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0x00000000, 0x0001d4b0, 0x00000000, 0x7fffffff, 0x7fff8005, 0xffeb7fff, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0xffffffff, 0x80000000, 0xffffffff, 0x80000000, 0x1c71c147, 0x00000000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0x00000000, 0x7ffffffb, 0x00000000, 0x7ffffffb, 0x00000000, 0x0000fffd, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0xffffffff, 0xffffff80, 0x00000000, 0x0014ff56, 0x7fff0015, 0x7fff0000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0xffffffff, 0xf8000001, 0xffffffff, 0xc0fd0001, 0x00248000, 0x37030000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0xffffffff, 0xd097284c, 0xffffffff, 0xd099284c, 0x80000000, 0x0000fffe, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0x00000000, 0x7ffffffc, 0x00000000, 0x7fffffff, 0xfffcfff5, 0x0000fff6, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0x00000000, 0x00ff00ff, 0x00000000, 0x00ff00ff, 0xfc450000, 0xfff00000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0x00000000, 0x00000000, 0x00000000, 0x3148d154, 0x7fc07fff, 0x05162c49, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0xffffffff, 0xdb6db6db, 0xffffffff, 0xc9a05e1f, 0x7fffc001, 0x03a9f007, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0xffffffff, 0x80000000, 0xffffffff, 0x80000000, 0xc001c01f, 0x00003ffe, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0xffffffff, 0xfffff251, 0xffffffff, 0xfffdf255, 0xfffe0000, 0xff9e7fff, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0x00000000, 0x00000000, 0x00000000, 0x0002c020, 0xfffdffff, 0x1ff08000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0x00000000, 0x0000000c, 0x00000000, 0x7ffeff96, 0x7ffffffc, 0xe00f7fff, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0xffffffff, 0xc000000f, 0xffffffff, 0xbf01000f, 0x00008000, 0x00ffaaaa, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0xffffffff, 0x80000000, 0xffffffff, 0x80000000, 0x00000509, 0x00000000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0xffffffff, 0xdb6db6db, 0xffffffff, 0xdb611a63, 0x19bcfff4, 0x3fc0ffdf, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0x00000000, 0x7fffffff, 0x00000000, 0x7fffffff, 0x7fff8000, 0x00000002, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0x00000000, 0x6db6db6d, 0x00000000, 0x0002b6fb, 0x9249ffef, 0xf0f07fff, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0xffffffff, 0xfffffffd, 0xffffffff, 0xff00b9c5, 0x7ffb0003, 0x1d4cff00, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0xffffffff, 0xffffc14b, 0x00000000, 0x38afe0d9, 0x38b4068f, 0x00c97fe0, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0x00000000, 0x7fffffff, 0x00000000, 0x7fa86da9, 0x004f000f, 0xb6db8000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0x00000000, 0x1ffffff8, 0x00000000, 0x6924fdf8, 0x80000004, 0xffc0b6db, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0xffffffff, 0xc000001f, 0xffffffff, 0xbffe6d3f, 0x1ff80007, 0xfea0fffa, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0xffffffff, 0x80000000, 0xffffffff, 0x80000000, 0x1ff8e001, 0x492400ff, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0x00000000, 0x00000000, 0x00000000, 0x0012ffda, 0x7fe07fff, 0x00130000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0xffffffff, 0xffffffff, 0x00000000, 0x01cfffff, 0xff2e8000, 0xff028000, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0x00000000, 0x000007b4, 0x00000000, 0x30b05b14, 0x7ff93fc0, 0x7ffff0f0, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0x00000000, 0x00000000, 0xffffffff, 0xffe764c8, 0x0064e38e, 0x0000e081, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac3, 0xffffffff, 0xc0000003, 0xffffffff, 0xbf913411, 0xff929999, 0x00017fff, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0xffffffff, 0xf8000001, 0xffffffff, 0xf8000001, 0x00000000, 0x8005c71c, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac0, 0x00000000, 0x7fffffff, 0x00000000, 0x7fffffff, 0xfffffe9f, 0xffb43fe0, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0x00000000, 0x7fffffff, 0x00000000, 0x7fffffff, 0x7fff7fff, 0x00000558, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac1, 0xffffffff, 0x80000000, 0xffffffff, 0x80000000, 0xf82c0000, 0x1fe00000, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0xffffffff, 0xfffffffc, 0x00000000, 0x00026ccc, 0x00560000, 0xfff7039c, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0xffffffff, 0xfffffffc, 0xffffffff, 0xfe00efe0, 0x07fefe7b, 0x0000e007, 0x000f0000, 0x000f0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0xffffffff, 0xf1ad5eb4, 0xffffffff, 0xf1ad5eb4, 0x00000000, 0x00057fff, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0xffffffff, 0xfffffff0, 0xffffffff, 0xfffffff8, 0xffff0000, 0x0000fffc, 0x000e0000, 0x000e0000
	dspckacc_astio dpaqx_sa.w.ph, $ac2, 0xffffffff, 0x80000000, 0xffffffff, 0x80eb0000, 0xff157fff, 0x00008000, 0x000e0000, 0x000e0000

	writemsg "[51] Test dpsqx_s.w.ph"
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x00000000, 0x00000000, 0x00000000, 0x2492b6da, 0xdb6d8000, 0x00007fff, 0x00000000, 0x00000000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0xffffffff, 0xffffffc4, 0x00000000, 0x00feff84, 0xffe08000, 0x00ffffff, 0x00010000, 0x00010000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0x00000000, 0x00000001, 0x00000000, 0x7fff0001, 0x000b8000, 0x7fff0000, 0x00000000, 0x00000000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x00000000, 0x00000001, 0x00000000, 0x4d748fad, 0x55557fff, 0xdd21c01f, 0x00000000, 0x00000000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0x00000000, 0x00000000, 0x00000000, 0x00005244, 0x00000db6, 0xfffd0000, 0x00010000, 0x00010000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x80000000, 0x00000000, 0x7fffffff, 0xffc054e0, 0xfff0c003, 0xff80028f, 0x00000000, 0x00000000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x7fffffff, 0xfffffff8, 0x7fffffff, 0xfffffff8, 0x92490000, 0x80070000, 0x00010000, 0x00010000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0x00003f63, 0xe876f2fc, 0x00003f63, 0xe876f2fc, 0x00000000, 0x001f3fe0, 0x00000000, 0x00000000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x7fffffff, 0xfffffffc, 0x80000000, 0x0055ffa6, 0xff297fff, 0x00003333, 0x00000000, 0x00000000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x00000000, 0x00000013, 0xffffffff, 0xffc98e23, 0x0006feaf, 0xe95e9249, 0x00000000, 0x00000000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0x0208d1d3, 0xddcccf9f, 0x0208d1d3, 0xddcce11b, 0x000201f8, 0xfffcff91, 0x00000000, 0x00000000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffffff, 0x00000000, 0xfffdf0f0, 0x00010000, 0x00010000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0xc0000000, 0x00000001, 0xbfffffff, 0xed386571, 0x02d07ffd, 0x0ff87fff, 0x00000000, 0x00000000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0xf0000000, 0x00000003, 0xefffffff, 0xfc01fff5, 0xfffffc01, 0x80007ff9, 0x00000000, 0x00000000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0xffffffff, 0xfff660c2, 0xffffffff, 0xfffc06c0, 0xfffb0003, 0xe4547fff, 0x00010000, 0x00010000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x00000000, 0x0000001f, 0xffffffff, 0x80000020, 0x80000000, 0xf8038000, 0x00000000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0xf8000000, 0x00000003, 0xf7ffffff, 0xcccd6669, 0x7fff01bb, 0x00003333, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0xf0000000, 0x00000007, 0xf0000000, 0x0000a105, 0x04c0ffff, 0x7fff000a, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x00000000, 0x00000000, 0xffffffff, 0xffd3a2c6, 0xfe9d0000, 0x0000f001, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0xfffffffe, 0x6b07649d, 0xfffffffe, 0x6b17647d, 0xfff00000, 0x7fff7fff, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0x00001915, 0x9091c8b8, 0x00001915, 0x8ff6fb5a, 0xffc6ff87, 0x99998000, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x55555555, 0x55555555, 0x55555555, 0xd5545555, 0x8000001b, 0x00007fff, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0xffffffff, 0xfffff945, 0xffffffff, 0xfffcf96f, 0xffe9fffd, 0x80070000, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0x3fffffff, 0xfffffffc, 0x40000000, 0x8662c002, 0x80007fff, 0xe0036666, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0x55555555, 0x55555555, 0x55555555, 0x554e15cd, 0x1ffc000e, 0x3ffc0001, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0x00000000, 0x0000000f, 0xffffffff, 0xf9f02f83, 0x05b5b6db, 0xff617fff, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x00000000, 0x00000000, 0x00000000, 0x01cd0b40, 0xfc01040a, 0x001039c0, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x00000000, 0x01e46e08, 0x00000000, 0x81c46e46, 0x80067fff, 0x801f0000, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0xfffbff4d, 0x000a549d, 0xfffbff4c, 0xe13f9233, 0x025a7fff, 0x1c717fff, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0xb6db6db6, 0xdb6db6db, 0xb6db6db6, 0xdb6db6db, 0x00000000, 0x80000000, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x0129823f, 0xffcee007, 0xffe27fff, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0xffffff03, 0x35e13d56, 0xffffff03, 0x35e220e6, 0xc71c3fe0, 0x00000002, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0x80000000, 0x00000000, 0x80000000, 0x00030006, 0x00017fff, 0xfffdfffa, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xfffcf7f3, 0xfffdff32, 0xfffb8000, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0x0000006b, 0xb4ed34b8, 0x0000006b, 0xb25330b8, 0xff808000, 0xfd66fffc, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0xffffffff, 0xe6377963, 0xffffffff, 0xe6377963, 0x00000000, 0xfffd7fff, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0xffffffbc, 0x1d56b826, 0xffffffbc, 0x1d59b826, 0x80008007, 0x80007ffc, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0x1fffffff, 0xfffffff0, 0x1fffffff, 0xfffffff0, 0xfffdc8dd, 0x00000000, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0xfffff704, 0x127e1c68, 0xfffff704, 0x127e1c5c, 0x00060000, 0x00690001, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x00000000, 0x00001e7a, 0xffffffff, 0xff55727a, 0xff000000, 0x014aaaaa, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0x7fffffff, 0xffffffff, 0x80000000, 0x0000018b, 0x00420000, 0xfe66fffd, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x1fffffff, 0xfffffff0, 0x1fffffff, 0xff95fff0, 0xff96f46c, 0x00008000, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x00000000, 0x00000004, 0x00000000, 0x0045ff78, 0x00007fff, 0xffbaffe9, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x80000000, 0x00000005, 0x7fffffff, 0xfc040801, 0x7fff8000, 0x000203fe, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0xe38e38e3, 0x8e38e38e, 0xe38e38e3, 0x8e38e38e, 0xf0f00000, 0x00000000, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0x00000000, 0x48d1a39a, 0x00000000, 0x48f2a3a0, 0x8000ffff, 0x00030021, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0x0000000c, 0x0c497530, 0x0000000c, 0x0c4b7512, 0xfffd8000, 0x0002fffb, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0x00000000, 0x00000006, 0xffffffff, 0xc0027d28, 0x3ffe016d, 0x00017fff, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x00000001, 0x0f639f38, 0x00000000, 0x8f6c9f28, 0x00007fff, 0x7ff88000, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0x7fffffff, 0xffffffff, 0x80000000, 0x55166513, 0x7fff003f, 0x7fe0aaaa, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0x00000000, 0x000001b4, 0x00000000, 0x000400ec, 0x0000ff11, 0x02248000, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0xffffffff, 0xfffffffd, 0xffffffff, 0xf017387b, 0xfffce00f, 0xc03ffffc, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x00000000, 0x00000000, 0x00000000, 0x0ffe0000, 0x0ffe0000, 0x80008000, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0xc0000000, 0x00000003, 0xc0000000, 0x2489db43, 0xdb6d803f, 0x00007fe0, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x7fffffff, 0xffffffff, 0x80000000, 0x0004fb27, 0x00140000, 0x0018e01f, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0xffffffff, 0xfff86f81, 0xffffffff, 0xfff86f7d, 0x00000001, 0x00027f80, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0x3fffffff, 0xffffffe0, 0x3fffffff, 0xffffffe0, 0x07fe0000, 0x03fe0000, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0xfffffef0, 0xc81352f5, 0xfffffef0, 0xc7ef93c3, 0x011771c7, 0x00010ffe, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x0061adb8, 0x892ce692, 0x0061adb8, 0x8951e648, 0x7fff0000, 0x0000ffdb, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xc0082497, 0xc0070004, 0xdb6d8000, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0xfc000000, 0x00000001, 0xfbffffff, 0xf0041ff9, 0x00000ffc, 0x7fff0000, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x80000000, 0x00000000, 0x80000000, 0x0033ff98, 0xf003ffcc, 0x7fff0000, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x0000495f, 0xaca5aaeb, 0x0000495f, 0xad3e97cb, 0xfecef001, 0x00003ff8, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x00000000, 0x0000006b, 0x00000000, 0x0001a08d, 0x014f0000, 0x8000ff61, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x01ebf1a4, 0xfb3cb2c6, 0x01ebf1a4, 0xa5e8b2b2, 0x7ffbaaaa, 0x8000fffe, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0x000002dc, 0x9e9a53c7, 0x000002dc, 0x1e9c53c5, 0x02eb7fff, 0x7fff0000, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x80000000, 0x00000005, 0x80000000, 0x00000005, 0x00017fff, 0x00000000, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x063a150b, 0x5ca2e025, 0x063a150b, 0x5c9ce025, 0x80000000, 0x036cfffa, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x00000000, 0x00000000, 0x00000000, 0x40000000, 0xc0018000, 0x7fff8000, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0xffffffff, 0xffffff06, 0x00000000, 0x000eff06, 0x0000000f, 0x80000000, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xfba50006, 0x00000000, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0x00000001, 0xbfa5a453, 0x00000001, 0xbf8cd953, 0xfffa7fff, 0x0016c467, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0x00000000, 0x2a110863, 0x00000000, 0x2614e781, 0x00070ffc, 0x1ff0f007, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0xf0000000, 0x00000003, 0xf0000000, 0x00010c43, 0x01880001, 0x8000fffc, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0xfc000000, 0x00000001, 0xfc000000, 0x68e309a7, 0x6db67fff, 0x04d38000, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0xff626849, 0xa8847aae, 0xff626849, 0xa83c5af4, 0x012fffff, 0x7fff1ee4, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x80000000, 0x00000000, 0x7fffffff, 0xf0021ffc, 0x7fff0005, 0x00000ffe, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x00000000, 0x00000394, 0xffffffff, 0x924b0394, 0x80008000, 0x92490002, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffffff5f, 0xfff00000, 0xc007fffb, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0x00000000, 0x76c21a35, 0x00000000, 0x86c01a35, 0x800f8000, 0x0ffe0000, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0xffffe162, 0xc09e823b, 0xffffe162, 0xc09e823b, 0x0000e38e, 0x00000000, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x80000000, 0x00000000, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0x80000000, 0x00000007, 0x7fffffff, 0xfeae07f3, 0xf8037ffd, 0x01520000, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0xffffffdd, 0xd34a8b05, 0xffffffdd, 0x534c8b03, 0x00007fff, 0x7fffe50d, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0xffffc42c, 0x8501eb4b, 0xffffc42c, 0x850122f5, 0xfffa800f, 0xffff04a1, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0x00000000, 0x00000005, 0x00000000, 0x00021e89, 0x07a10002, 0x8000fffe, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0xffffffff, 0xfffffbda, 0x00000000, 0x0000ca8e, 0x00010cec, 0xfff80006, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0xffffffff, 0xfffffb03, 0xffffffff, 0x80017ab0, 0xe0078000, 0x80000006, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0x00000eef, 0xa2626579, 0x00000eef, 0x2266db99, 0x8004ff70, 0x00698000, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0x1fffffff, 0xfffffff8, 0x20000000, 0xfff6fff8, 0x80007ff8, 0x80007fff, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x00000000, 0x00000003, 0x00000000, 0x00257095, 0xc03fffea, 0x7fff001f, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0xffffffff, 0xfffffffb, 0x00000000, 0x8000ffef, 0x7fff7ffb, 0x8000fffa, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0xffff852f, 0x4788b9a2, 0xffff852f, 0x317c3942, 0x3ff08000, 0xe9f2fffd, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0xffffffff, 0xffffff80, 0xffffffff, 0xffffff80, 0xdb6d7fff, 0x00000000, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x00000000, 0x00000078, 0x00000000, 0x00002146, 0xffef3ffe, 0x000000f7, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x80000000, 0x00000000, 0x80000000, 0x3ffc0000, 0x3ffc0000, 0x3ffe8000, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0xffffffff, 0xfffff783, 0xffffffff, 0x2491f783, 0x80009249, 0x80009249, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x7fffffff, 0xffffffff, 0x80000000, 0x001448fb, 0x7fff6db6, 0xfffbfff0, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x80000000, 0x00000000, 0x7fffffff, 0xcccc0000, 0xcccc0000, 0x00058000, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0xffffffff, 0xffffff00, 0xffffffff, 0xffffff00, 0x00000000, 0xfff03ff0, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x7fffffff, 0xffffffff, 0x80000000, 0x00080def, 0x0007fff8, 0x7fffff00, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0x7fffffff, 0xffffffff, 0x80000000, 0x0006ffff, 0x80000000, 0x00000007, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0xffffffff, 0xffffff00, 0x00000000, 0x0347fbb8, 0x55550000, 0x7ffffb14, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x80000000, 0x00000000, 0x80000000, 0x00670000, 0x80001437, 0x00000067, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xf6e0123f, 0x0ff87fff, 0x00004924, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0x7fffffff, 0xffffffff, 0x80000000, 0x03fb807f, 0x1c71f801, 0x3fc00000, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0xfffffed5, 0x6eb30c90, 0xfffffed5, 0x8e8c1450, 0x7fe00000, 0xffffe01f, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0x03892485, 0xe4c0f937, 0x03892485, 0xe4d7f889, 0x7ffffffc, 0xfff0ffe9, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0x00000000, 0x00000000, 0x00000000, 0x03570000, 0x80008000, 0x03550002, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0x80000000, 0x00000000, 0x7fffffff, 0xfffe01fc, 0x07fefffe, 0x807f0000, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x07ffffff, 0xfffffffc, 0x08000000, 0x000026ca, 0xffff8000, 0x00001367, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0x7fffffff, 0xfffffff9, 0x80000000, 0x1b6ca48d, 0xe0010000, 0x1e426db6, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x3fffffff, 0xfffffffc, 0x40000000, 0x7fed0d10, 0x00ff7fff, 0x800f017b, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x00000000, 0x02834930, 0x00000000, 0x02834930, 0xf5f87fff, 0x00000000, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0xc0000000, 0x00000003, 0xbfffffff, 0xfffe38e3, 0xc71c007f, 0x0000fffc, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0x80000000, 0x00000000, 0x7fffffff, 0xe3da01b6, 0x0986801f, 0xe003cccc, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0001000e, 0x00000000, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0xffffffff, 0xfffef704, 0x00000000, 0x03fbf784, 0x7fc0fbc2, 0x0000fc01, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x00000000, 0x00000265, 0x00000000, 0x7fff0265, 0x80000000, 0x000f7fff, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x00019da7, 0xd2dfd8fe, 0x00019da7, 0xd333b9ae, 0x80008e38, 0xee630ffc, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0x00000000, 0x00000000, 0x00000000, 0x219e0000, 0x80003ffe, 0x8000e1a0, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0x00051a30, 0x93e3d658, 0x00051a31, 0x93e1d658, 0x80008000, 0x7fff7fff, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0xffe52dd0, 0xb6a53cf9, 0xffe52dd0, 0xb6a50d05, 0xcccc07fe, 0x00030000, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x00000000, 0x002f9747, 0x00000000, 0x002fe233, 0x80002576, 0xffff0000, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x0f0f0f0f, 0x0f0f0f0f, 0x0f0f0f0f, 0x0f819c0f, 0x0000ff1a, 0x3fc0cccc, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x00000000, 0xc003f77c, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0xffffffff, 0x4a719a07, 0xffffffff, 0x7c329a07, 0x31c4fffd, 0x80008000, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x00000000, 0x00000005, 0xffffffff, 0xf461af61, 0x7ffff99d, 0xf0f00ade, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x3fffffff, 0xfffffffe, 0x3fffffff, 0xfffffffe, 0x80008000, 0x00000000, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0x00000000, 0x000011ed, 0x00000000, 0x000011ed, 0x3ff80000, 0xffc00000, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x00000000, 0x00000015, 0xffffffff, 0xc2c20015, 0x800002b3, 0x8000c00f, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x80000000, 0x00000000, 0x80000000, 0x0000fffe, 0x7fff7fff, 0x0000ffff, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0x00000000, 0x00000003, 0x00000000, 0x0015e35d, 0x800038e3, 0xffd10001, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x80000000, 0x00000000, 0x7fffffff, 0xffffc2d4, 0x0000020a, 0x000f1ffc, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x00000000, 0x00000001, 0x00000000, 0x00000001, 0x80058000, 0x00000000, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0x7fffffff, 0xfffffff0, 0x7fffffff, 0x7ffffff1, 0x80000000, 0x00008000, 0x00020000, 0x00060000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x00000000, 0x00079c4b, 0x00000000, 0x00084f97, 0xffa60143, 0x000000ff, 0x00060000, 0x00060000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0xf0000000, 0x00000003, 0xf0000000, 0x7ff9ff03, 0x8000ff80, 0xffff7ffa, 0x00070000, 0x00070000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x80000000, 0x00000000, 0x80000000, 0x06120000, 0x06228000, 0xfff08000, 0x00070000, 0x00070000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0x0fffffff, 0xfffffffc, 0x10000000, 0x0060d9b8, 0x1ffc0f0f, 0xfff2fe83, 0x00070000, 0x00070000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x80000000, 0x00000000, 0x7fffffff, 0xfffb17f0, 0xe3740000, 0x0000ffea, 0x00060000, 0x00060000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0x7fffffff, 0xfffffff0, 0x7fffffff, 0xff73fff0, 0xff640010, 0x80008000, 0x00060000, 0x00060000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0xffffffff, 0xe03e6b1c, 0xffffffff, 0xe03e6a9c, 0xffff0000, 0xf0f0ffc0, 0x00060000, 0x00060000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x00000104, 0xeff86417, 0x00000104, 0xf7f6041d, 0xfffd8000, 0x07fef001, 0x00060000, 0x00060000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x80007fff, 0x00000000, 0x00070000, 0x00070000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0xc0000000, 0x00000003, 0xbfffffff, 0x8004fff7, 0x7fff8002, 0x80030000, 0x00060000, 0x00060000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0x80000000, 0x0000007f, 0x80000000, 0x0000007f, 0x00000000, 0x807f0135, 0x00060000, 0x00060000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0x00000000, 0x00000005, 0xffffffff, 0xffffff15, 0xc01fffe2, 0xfffc0000, 0x00060000, 0x00060000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0xffffffff, 0xfea6d946, 0x00000000, 0x53fbd9a0, 0x55550003, 0xfff18000, 0x00060000, 0x00060000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x7fffffff, 0xfffffff0, 0x7fffffff, 0xfffffff0, 0x00000000, 0x00000000, 0x00060000, 0x00060000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0xffffffff, 0xffef3e2c, 0xffffffff, 0xffef3e2c, 0x00000000, 0x8000ffde, 0x00070000, 0x00070000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0x80000000, 0x00000000, 0x7fffffff, 0xfffffffe, 0xffffffff, 0x7fff8000, 0x00070000, 0x00070000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0x00000000, 0x00000000, 0x00000000, 0x0005fff4, 0x7ffffffd, 0x7ffffffd, 0x00070000, 0x00070000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0xffffffff, 0xffea7dbf, 0x00000000, 0x1c5b7cc1, 0x1c71007f, 0x00018000, 0x00060000, 0x00060000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0xffffff9c, 0xa2f00fdf, 0xffffff9c, 0xa318a265, 0x00473ff0, 0x0000b6db, 0x00070000, 0x00070000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x7fffffff, 0xffffffff, 0x80000000, 0x000018c7, 0x003d021a, 0x0000ffcc, 0x00070000, 0x00070000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0x7fffffff, 0xfffffffc, 0x7fffffff, 0xfffffffc, 0x00001ffc, 0x00003fe0, 0x00060000, 0x00060000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xffd0ffff, 0x00008000, 0xffd1028d, 0x00070000, 0x00070000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x0001ff9e, 0x00000000, 0x00070000, 0x00070000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0xffffffff, 0xfff31e51, 0xffffffff, 0xfff32a07, 0xfa257fc0, 0x00000001, 0x00070000, 0x00070000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0x7fffffff, 0xfffffff8, 0x7fffffff, 0xfffffff8, 0x00000fc1, 0x00000000, 0x00070000, 0x00070000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0xff00ff00, 0xff00ff00, 0xff00ff00, 0xff00ff00, 0x8000fff8, 0x00000000, 0x00060000, 0x00060000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x0fffffff, 0xfffffffc, 0x0fffffff, 0xf005ff7c, 0xfffc3ff0, 0x1ffc0000, 0x00070000, 0x00070000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x80000000, 0x00000000, 0x7fffffff, 0xf0070000, 0xf0077fff, 0x00008000, 0x00070000, 0x00070000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x00000000, 0x0057f0ac, 0x00000000, 0x8037f0ac, 0x00008000, 0x7fe07ffa, 0x00060000, 0x00060000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0x7fffffff, 0xffffffff, 0x80000000, 0x5f724e7f, 0x8000209d, 0x7fc07fff, 0x00060000, 0x00060000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0x00000000, 0x00007c33, 0xffffffff, 0xfffc7c3b, 0x00000004, 0x7fff9249, 0x00070000, 0x00070000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0x003b0adf, 0x88661e68, 0x003b0adf, 0x884ad91c, 0x1ff009ce, 0xfec500ce, 0x00070000, 0x00070000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x7fffffff, 0xffffffff, 0x7fffffff, 0x7ffd0006, 0x00038000, 0x80007fff, 0x00060000, 0x00060000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0xffff2817, 0x84076dc7, 0xffff2817, 0x84326d71, 0xffd50000, 0xfff87fff, 0x00070000, 0x00070000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0x00015b6b, 0xe56bd5cd, 0x00015b6b, 0xe56ad5dd, 0x1ffee007, 0x00000004, 0x00060000, 0x00060000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0xb6db6db6, 0xdb6db6db, 0xb6db6db6, 0x7168a629, 0x1fe08001, 0x99990e8a, 0x00060000, 0x00060000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x0000000a, 0xa1b1b7c6, 0x0000000a, 0xa29ffc86, 0x4924febc, 0x8000fc28, 0x00060000, 0x00060000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x00000000, 0x000ac690, 0x00000000, 0x0006c9d2, 0x0004fff9, 0x003b7fff, 0x00070000, 0x00070000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0xffffffff, 0xfffffffc, 0x00000000, 0x7ff8fffc, 0x80008000, 0x00007ff9, 0x00060000, 0x00060000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0x00000000, 0x00000edc, 0xffffffff, 0x40208e9d, 0x80003fe0, 0x7fff8000, 0x00060000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0xffe8a740, 0x6aed4a59, 0xffe8a740, 0x6aed4a59, 0x00067fff, 0x00000000, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0x00078846, 0x1555102f, 0x00078846, 0x1654783b, 0x0000e003, 0x03feffff, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x80000000, 0x00000000, 0x7fffffff, 0x80dbfe86, 0x801fff43, 0x7fff8000, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x7fffffff, 0xfffffffb, 0x80000000, 0x00000037, 0x0000000f, 0xfffef007, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0xffffffff, 0xfffffffb, 0x00000000, 0x0006cfe5, 0x000d38e3, 0xfff8dfef, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x00000000, 0x00000000, 0xffffffff, 0xfffdfff6, 0xdb6d0000, 0x7ffffff9, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0x8e38e38e, 0x38e38e38, 0x8e38e38e, 0x3a768b12, 0xff227fff, 0xfe6d0000, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0xffffffff, 0xfffe3805, 0xffffffff, 0xfffd5875, 0x00250ff8, 0x00070000, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x0062b411, 0x30dbf45f, 0x0062b410, 0xbf15d78d, 0xfffc7fff, 0x71c7fff4, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x00f3f0be, 0x2efcd0a6, 0x00f3f0be, 0x2f02ce6a, 0x005b7fff, 0xfffbfe9b, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x000000e8, 0x5d89b153, 0x000000e8, 0x47616e13, 0x800015e6, 0x7ff0ffbb, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x7fffffff, 0xffffffff, 0x80000000, 0x03e95ee3, 0xfc01e12a, 0x0f0f0918, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x00000001, 0x6ea2d64b, 0x00000001, 0x6ef6d64b, 0x0054aaaa, 0x00008000, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0x00000000, 0x00000000, 0x00000000, 0x8f0e0000, 0x7fff8000, 0x0f0f8000, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x00ff00ff, 0x00ff00ff, 0x00ff00ff, 0x00f8010d, 0x00000007, 0x7fff7fff, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x80000000, 0x00000000, 0x7fffffff, 0xffff8780, 0xf0f08006, 0x0000fffc, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0xffffffff, 0xfffe2a94, 0xffffffff, 0xfffe4a8c, 0x0ffc0001, 0x0000ffff, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x00000000, 0x00000000, 0x00000000, 0x7f702cae, 0xfb627ff9, 0x803ff801, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x00000122, 0x832b01c4, 0x00000122, 0x8316a6d0, 0xb6db004d, 0x1ff0fffe, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x0000b153, 0xa32a28ae, 0x0000b154, 0x230428a4, 0x801ffffa, 0xffdb7ff9, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0x7fffffff, 0xfffffffa, 0x80000000, 0x671300fc, 0x00d87fff, 0x99999999, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x00000000, 0x00000000, 0xffffffff, 0xf804104c, 0x07fcfff9, 0x00067fff, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0x00000000, 0x00000000, 0xffffffff, 0xf8019000, 0x07fee001, 0xfffe7fff, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x00000000, 0x00000000, 0xffffffff, 0xf8020fc4, 0xfff907fe, 0x7ffffffc, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x80000000, 0x00000007, 0x7fffffff, 0xeb9cda0d, 0xf46b801f, 0xe0037fe0, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x7fffffff, 0xffffffc0, 0x80000000, 0x0040fcd0, 0x3ffc0012, 0x8000ffa2, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0xc71c71c7, 0x1c71c71c, 0xc71c71c7, 0x24706728, 0x0ffc8006, 0x0001c003, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0x1fffffff, 0xfffffffc, 0x20000000, 0x0005fffc, 0x80000000, 0x80010006, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0x80000000, 0x00000000, 0x80000000, 0x00000000, 0x7ffa7fff, 0x00000000, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0x00000000, 0x00000000, 0x00000000, 0x010cfde6, 0x7ffffff3, 0x7fffff00, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0x7fffffff, 0xffffffff, 0x80000000, 0x000001b7, 0x00048000, 0x0000ffc9, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0xffffffff, 0xe8486105, 0xffffffff, 0xce18cfb3, 0x0000e5cf, 0x80070006, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0x80000000, 0x00000000, 0x80000000, 0x7ff0001e, 0x00007fff, 0x800f02a6, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0xffffffff, 0xfffffef0, 0xffffffff, 0xfc0606e4, 0x7fff03f5, 0x7fff0005, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0x00000000, 0x00000064, 0xffffffff, 0xcccd66ca, 0x00003333, 0x7fff8000, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0x00000000, 0x00000000, 0xffffffff, 0xffe0740e, 0x3287e00f, 0xff80ffff, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0x0fffffff, 0xfffffffe, 0x10000000, 0x2aad8000, 0x80005555, 0xc0030005, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0x80000000, 0x00000000, 0x80000000, 0x0eeee002, 0xfef0f001, 0x7fff8000, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0xffffffff, 0xfe876f58, 0xffffffff, 0xfe391ab2, 0xaaaa0053, 0x7fff0007, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0x00000000, 0x00000000, 0x00000000, 0x0000043c, 0x010d0001, 0xfffcfffe, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0xffffffff, 0xfffffff9, 0x00000000, 0x71737f85, 0x8e380ffe, 0x028f7ffd, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0xffffffff, 0xfffe33c5, 0xffffffff, 0xffd533d1, 0x80008006, 0xffffffd8, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x00005270, 0x0fa26952, 0x00005270, 0x0f719bc2, 0xfc01cccc, 0xff860000, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x00000000, 0x00000000, 0xffffffff, 0xfffc0000, 0x80000000, 0x8000fffc, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0xffffffff, 0xfffffe27, 0xffffffff, 0x8800ee2d, 0xf8038000, 0x80047fff, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0xc0000000, 0x00000001, 0xbfffffff, 0xffffff8d, 0x0000ffe3, 0xfffefafe, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x80000000, 0x00000000, 0x7fffffff, 0xffbe11b2, 0x80000003, 0xfd0dffbe, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0xffffffff, 0xfffffffe, 0xffffffff, 0xc0027ffa, 0x00003ffe, 0x7fffff2f, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0xffffa9c9, 0x4e755172, 0xffffa9c9, 0x52c649cc, 0x0451ffee, 0x00078001, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffdd803f, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0x80000000, 0x00000000, 0x7fffffff, 0xfffe3c20, 0xfff1ff5a, 0x0000f0f0, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x7fffffff, 0xffffffe0, 0x7fffffff, 0xfe2a2708, 0x1ffc807f, 0xfe5c00ce, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xe007d9a7, 0x01141ffe, 0x7fe000ff, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0x7fffffff, 0xfffffffa, 0x80000000, 0x2a95d530, 0xffffc01f, 0x5555ffe6, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x00000000, 0x0000003f, 0x00000000, 0x0f0f003f, 0x0f0f0000, 0x7ffc8000, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x80000000, 0x00000001, 0x7fffffff, 0xc03f0001, 0x9999c03f, 0x80000000, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffe87fff, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0x7fffffff, 0xfffffffe, 0x7fffffff, 0xfffffffe, 0x80009249, 0x00000000, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0x7fffffff, 0xffffffff, 0x80000000, 0x0002feb5, 0x0003ffff, 0xff5b8000, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0x00000000, 0xf311d96e, 0x00000000, 0xf213db4c, 0x7fff0ffe, 0xfff800ff, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x00000000, 0x000003e9, 0x00000000, 0x000003e9, 0x00008000, 0x0000e0d1, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff008000, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x80000000, 0x0000000f, 0x7fffffff, 0xffe80023, 0x0019800f, 0x00017fff, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0x00000641, 0xb58ec28c, 0x00000641, 0x9ae4e7e2, 0x12ab8000, 0xf8017fff, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x7fffffff, 0xffffffff, 0x80000000, 0x7ffbffff, 0x80003ffe, 0x80003ffe, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0xc71c71c7, 0x1c71c71c, 0xc71c71c7, 0x1c71c71c, 0x00000000, 0x00009999, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0x7fffffff, 0xffffffff, 0x7fffffff, 0x7ffc0000, 0xfffc8000, 0x80008000, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0xffffff80, 0xacac92de, 0xffffff80, 0x2ca992e6, 0x7fff0005, 0x7fff7fff, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac0, 0x7fffffff, 0xffffffff, 0x7fffffff, 0xfdcbffff, 0xfdcc0000, 0x80008000, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0xffffffff, 0xfffffffb, 0xffffffff, 0x7fad01ee, 0xffad8000, 0x80008003, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_s.w.ph, $ac3, 0x00000000, 0x00000000, 0xffffffff, 0xfffff4ce, 0x7fffffff, 0xfa670000, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_s.w.ph, $ac2, 0x80000000, 0x00000000, 0x7fffffff, 0xfff083e0, 0x1fe0001f, 0x3ff00000, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_s.w.ph, $ac1, 0x00000000, 0x000008ee, 0x00000000, 0x00006a26, 0x00cc0001, 0x0000ffc3, 0x000e0000, 0x000e0000

	writemsg "[52] Test dpsqx_sa.w.ph"
	dspckacc_astio dpsqx_sa.w.ph, $ac0, 0xffffffff, 0xffffffe7, 0x00000000, 0x0050ffe7, 0x8000ffe0, 0x00000051, 0x00000000, 0x00000000
	dspckacc_astio dpsqx_sa.w.ph, $ac1, 0xffffffff, 0x80000000, 0xffffffff, 0x80000000, 0xfffffff8, 0xfe1afff8, 0x00000000, 0x00020000
	dspckacc_astio dpsqx_sa.w.ph, $ac2, 0x00000000, 0x00000001, 0x00000000, 0x0144cbeb, 0x0a07fffc, 0x7ffff001, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_sa.w.ph, $ac3, 0x00000000, 0x005e8cd9, 0xffffffff, 0x80608cd7, 0x7fff0000, 0xf0017fff, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_sa.w.ph, $ac2, 0xffffffff, 0x99999999, 0xffffffff, 0x99999999, 0x00000006, 0x00000006, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_sa.w.ph, $ac2, 0x00000000, 0x007cd308, 0x00000000, 0x007b365c, 0x00070ebd, 0x00070ebd, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_sa.w.ph, $ac1, 0xffffffff, 0xffffffd4, 0x00000000, 0x7fff00d4, 0x00017fff, 0x8000ff80, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_sa.w.ph, $ac2, 0xffffffff, 0xfffffffb, 0x00000000, 0x03c80efb, 0x80001ff8, 0xf0f00005, 0x00020000, 0x00020000
	dspckacc_astio dpsqx_sa.w.ph, $ac0, 0xffffffff, 0x80000000, 0xffffffff, 0x800b3278, 0x0006fff0, 0x7ffa6666, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_sa.w.ph, $ac1, 0xffffffff, 0xfc000001, 0xffffffff, 0xfbe80031, 0x7ffffffa, 0x7fff001e, 0x00030000, 0x00030000
	dspckacc_astio dpsqx_sa.w.ph, $ac2, 0x00000000, 0x7ffffffd, 0x00000000, 0x7fffffff, 0x29ac1fe0, 0xffda000b, 0x00030000, 0x00070000
	dspckacc_astio dpsqx_sa.w.ph, $ac0, 0x00000000, 0x00000000, 0x00000000, 0x2472b6da, 0x8000db6d, 0x7fffffe0, 0x00070000, 0x00070000
	dspckacc_astio dpsqx_sa.w.ph, $ac3, 0x00000000, 0x7ffffffd, 0x00000000, 0x7fffffff, 0xdb6d8000, 0x7ffffffa, 0x00070000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac3, 0xffffffff, 0xffffffe2, 0xffffffff, 0x8001def3, 0xfff18000, 0x80000ff8, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac0, 0x00000000, 0x00000000, 0x00000000, 0x0000835a, 0x03eefffd, 0x1c710005, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac3, 0x00000000, 0x7ffffff8, 0x00000000, 0x165faaa2, 0xebb47fff, 0x55558000, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac0, 0x00000000, 0x000002e1, 0x00000000, 0x00004af7, 0xfffc0269, 0xfff1fff9, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac2, 0xffffffff, 0x80000000, 0xffffffff, 0x8c0c9084, 0x0062f0f0, 0x6666003f, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac0, 0xffffffff, 0x92492492, 0xffffffff, 0x924224a0, 0x7fff7fff, 0x00070000, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac0, 0xffffffff, 0xfffca267, 0xffffffff, 0xfffd05af, 0x08460000, 0x8006fffa, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac0, 0x00000000, 0x00000000, 0x00000000, 0x7fffffff, 0x7fff0015, 0x80008000, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac1, 0xffffffff, 0xaaaaaaaa, 0xffffffff, 0xaaaaaaaa, 0x7ffff0f0, 0x00000000, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac0, 0x00000000, 0x00000b8e, 0xffffffff, 0xe90a7b6e, 0x00027ff8, 0x16f63fe0, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac1, 0xffffffff, 0xffffff80, 0xffffffff, 0x80000000, 0x80008000, 0x8000aaaa, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac0, 0x00000000, 0x00000000, 0x00000000, 0x7ffef004, 0xfc018000, 0x7ffffffe, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac3, 0x00000000, 0x7fffffff, 0x00000000, 0x7fffffff, 0x0000c90c, 0x7fffdcec, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac0, 0x00000000, 0x0000005a, 0x00000000, 0x0000005a, 0x0ff80006, 0x00000000, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac3, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0000ffde, 0x00000000, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac2, 0xffffffff, 0xffffffff, 0x00000000, 0x10e6de3b, 0x00017fff, 0xef187ffa, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac3, 0x00000000, 0x0520cc81, 0x00000000, 0x0520cc81, 0xfffe8000, 0x00000000, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac1, 0x00000000, 0x00ff00ff, 0x00000000, 0x7fffffff, 0x00057fff, 0x80007fff, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac2, 0x00000000, 0x7fffffff, 0x00000000, 0x7fffffff, 0x80070004, 0xff887ffd, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac2, 0xffffffff, 0x80000000, 0xffffffff, 0xbff019e0, 0x3ff000cf, 0xfff08000, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac2, 0x00000000, 0x1ffffffe, 0x00000000, 0x20000fde, 0x0000007f, 0xfff07fff, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac2, 0xffffffff, 0x80000002, 0xffffffff, 0x80000002, 0x7fffffc0, 0x00000000, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac2, 0x00000000, 0x0000003a, 0x00000000, 0x0000003a, 0x001f8000, 0x00000000, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac2, 0x00000000, 0x7fffffff, 0x00000000, 0x7fffffff, 0x00577fff, 0x80000001, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac0, 0xffffffff, 0xffffff00, 0xffffffff, 0x8020fef0, 0xfff87fe0, 0x7fff0003, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac1, 0x00000000, 0x00000013, 0x00000000, 0x7c01080f, 0x800003fe, 0x7fff7fff, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac0, 0xffffffff, 0xffffffff, 0x00000000, 0x7fef5577, 0x7fff1c71, 0x0003800f, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac2, 0x00000000, 0x00003a28, 0x00000000, 0x7f843c56, 0x00077f80, 0x8003800f, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac0, 0x00000000, 0x7fffffff, 0x00000000, 0x1fe3fff9, 0x7ffd1fe0, 0x80007fff, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac1, 0xffffffff, 0xffffce35, 0xffffffff, 0x9248ee2d, 0x8000fc01, 0x00049249, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac1, 0x00000000, 0x00000000, 0xffffffff, 0x8002d5be, 0x7fff0260, 0xffd37fff, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac1, 0x00000000, 0x00000000, 0xffffffff, 0xffff0002, 0x00007fff, 0x00010c61, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac0, 0xffffffff, 0xffffff8d, 0xffffffff, 0xf0069bc5, 0x8004ffff, 0x8e38f007, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac3, 0xffffffff, 0x80000007, 0xffffffff, 0x80000000, 0xff70ff54, 0xff70ff54, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac3, 0xffffffff, 0x80000000, 0xffffffff, 0x80000000, 0x7fff7fff, 0x7fff7fff, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac3, 0xffffffff, 0xff3744f1, 0xffffffff, 0xff28425b, 0x80000329, 0x03530006, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac1, 0xffffffff, 0xffff7ffd, 0xffffffff, 0x80011223, 0xfe847fff, 0x7fffffdb, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac0, 0x00000000, 0x00000437, 0xffffffff, 0xf47cd219, 0x7fff136e, 0x49240069, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac1, 0xffffffff, 0xf4b2f5c7, 0xffffffff, 0xb551a685, 0xe01fe070, 0x8000803f, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac2, 0x00000000, 0x00000000, 0xffffffff, 0xffff0001, 0x80008000, 0x7fff8000, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac1, 0x00000000, 0x00000072, 0x00000000, 0x3fa11ff2, 0x7fc00000, 0xc8f8c03f, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac1, 0x00000000, 0x7ffffff9, 0x00000000, 0x4047f7f9, 0x00007f80, 0x3ff8fee5, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac0, 0xffffffff, 0x80000000, 0xffffffff, 0x80001ba0, 0xfff0fc9f, 0x000000dd, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac2, 0x00000000, 0x000149e8, 0xffffffff, 0xf89b5920, 0xffff0766, 0x7fff0036, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac1, 0x00000000, 0x7fffffff, 0x00000000, 0x60209fb9, 0xf0017fff, 0x1fe00003, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac0, 0x00000000, 0x7fffffff, 0x00000000, 0x400877cf, 0x3ff8fff8, 0xff7e7fff, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac1, 0xffffffff, 0x80000000, 0xffffffff, 0x80000000, 0x0000f801, 0xc0012492, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac3, 0xffffffff, 0x80000000, 0xffffffff, 0xc376fd80, 0x8000f8fb, 0x3fc03ff8, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac1, 0xffffffff, 0xffffc00a, 0xffffffff, 0xdf510168, 0x7fff7fff, 0x00b31ffc, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac3, 0x00000000, 0x0000ffff, 0xffffffff, 0xf8145a0f, 0xfe338005, 0xf8130003, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac0, 0xffffffff, 0xffd65ca2, 0xffffffff, 0xffd65ca2, 0x00010000, 0x00010000, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac3, 0x00000000, 0x00017b63, 0xffffffff, 0xc0187b43, 0xc007fff0, 0x7fff8000, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac1, 0x00000000, 0x00000000, 0xffffffff, 0xfb740918, 0x00007fff, 0x048c7fff, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac2, 0x00000000, 0x0024c304, 0x00000000, 0x0024d04e, 0xff430000, 0x80000009, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac1, 0x00000000, 0x00000000, 0x00000000, 0x000001bc, 0x0000ff91, 0x0002000f, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac0, 0xffffffff, 0xffffffff, 0xffffffff, 0x8001e809, 0x7fff0003, 0x03fe7fff, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac0, 0x00000000, 0x004281fc, 0x00000000, 0x004281fc, 0x00000000, 0x00001efe, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac1, 0xffffffff, 0x80000000, 0xffffffff, 0x80000000, 0x03860040, 0x00000000, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac1, 0x00000000, 0x7fffffff, 0x00000000, 0x60037fe7, 0x7ffa0000, 0x00001ffe, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac3, 0xffffffff, 0x80000006, 0xffffffff, 0x80000000, 0x800500b2, 0x33330000, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac2, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffbf8006, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac3, 0x00000000, 0x7ffffffe, 0x00000000, 0x7fffffff, 0x00003fe0, 0xfffc9249, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac1, 0xffffffff, 0xe0000003, 0xffffffff, 0xffe0c041, 0x00047fff, 0xe01f0000, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac1, 0xffffffff, 0x80000000, 0xffffffff, 0x80000000, 0xc03f0000, 0x3ffc8001, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac2, 0x00000000, 0x7fffffff, 0x00000000, 0x7ffeffff, 0x80000000, 0x7fffffff, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac1, 0x00000000, 0x1c71c71c, 0x00000000, 0x1c55e79e, 0xc003ffdf, 0x807f000a, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac2, 0x00000000, 0x7fffffff, 0x00000000, 0x7fffffff, 0x007c8000, 0xfffae001, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac3, 0xffffffff, 0xf8000003, 0xffffffff, 0x80000000, 0x00008000, 0x8000fffe, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac0, 0x00000000, 0x7ffffffb, 0x00000000, 0x7ffffffb, 0x8000f007, 0x00000000, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac2, 0x00000000, 0x1ffffff8, 0x00000000, 0x23fdfff8, 0x8000fc2f, 0x000003fe, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac0, 0x00000000, 0x1ffffff8, 0x00000000, 0x2123fb68, 0x00008002, 0x01243ff8, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac3, 0xffffffff, 0xfffffff8, 0xffffffff, 0xfffffff8, 0xf7b90000, 0x00000000, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac2, 0x00000000, 0x7fffff80, 0x00000000, 0x7ffaaa20, 0xfffcaaaa, 0xfffcaaaa, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac1, 0x00000000, 0x000001ad, 0xffffffff, 0xfc994b21, 0xf0f0fffd, 0x3ffee30c, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac1, 0xffffffff, 0x80000000, 0xffffffff, 0xfff8000e, 0x00078000, 0x7fff7fff, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac1, 0x00000000, 0x02e6cef6, 0x00000000, 0x02e8244e, 0x00000003, 0xc71cfff3, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac3, 0xffffffff, 0xffacf75a, 0xffffffff, 0xffacf264, 0x007f0000, 0xc0010005, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac0, 0x00000000, 0x00000195, 0xffffffff, 0x8400f995, 0x7fff7fff, 0x7ffffc01, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac0, 0xffffffff, 0xc000001f, 0x00000000, 0x3f6ee63d, 0xf8037fff, 0x8000f6fb, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac1, 0x00000000, 0x7fffffc0, 0x00000000, 0x7fffffff, 0xfffa7fff, 0xc01fdb6d, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac3, 0x00000000, 0x00000000, 0x00000000, 0x003fff80, 0x7fff0038, 0x0000ffc0, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac1, 0x00000000, 0x7fffffff, 0x00000000, 0x7fffffff, 0x01563ffc, 0x80008000, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac2, 0x00000000, 0x00000c4a, 0x00000000, 0x00000c4a, 0x00000000, 0xfff6004f, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac0, 0x00000000, 0x00000000, 0xffffffff, 0xffefffca, 0x8000ffff, 0xffe5fff0, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac1, 0x00000000, 0x00000000, 0xffffffff, 0xee8c0000, 0x0000ee8c, 0x80008000, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac1, 0x00000000, 0x7fffffff, 0x00000000, 0x7f7ff9f3, 0xfff5ff80, 0x8001ffae, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac3, 0xffffffff, 0x80000000, 0xffffffff, 0x80000000, 0x00780017, 0x00003ffe, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac0, 0xffffffff, 0x80000000, 0xffffffff, 0x80000000, 0xb6db8000, 0xf77cfdec, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac0, 0xffffffff, 0x80000001, 0xffffffff, 0x80000000, 0x80000000, 0x8003800f, 0x000e0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac1, 0x00000000, 0x7fffffff, 0x00000000, 0x7fffffff, 0x7fff0000, 0x8000aaaa, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac0, 0xffffffff, 0xfffff68f, 0x00000000, 0x0040f487, 0x00410000, 0x00318004, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac2, 0xffffffff, 0xffffff00, 0xffffffff, 0xfff8ff0e, 0x7fffc00f, 0x00000007, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac0, 0x00000000, 0x07fffffc, 0x00000000, 0x07fffffc, 0xffc0fec4, 0x00000000, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac0, 0x00000000, 0x0f0f0f0f, 0x00000000, 0x0ef00f4d, 0x7ffffffa, 0x0000001f, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac3, 0xffffffff, 0xfffffffb, 0xffffffff, 0x8e75fd13, 0x80068e38, 0x8000003e, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac1, 0xffffffff, 0xfffffe6f, 0x00000000, 0x0003e1df, 0x1c717ffc, 0xfffdfffc, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac2, 0xffffffff, 0xc000000f, 0xffffffff, 0xc13a92c1, 0x92490000, 0x8000016f, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac1, 0xffffffff, 0xffa79b42, 0xffffffff, 0xffa79b42, 0xf0d9027c, 0x00000000, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac2, 0x00000000, 0x7fffffc0, 0x00000000, 0x7fffac6e, 0xffd30000, 0x7fffff13, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac0, 0x00000000, 0x7fffffff, 0x00000000, 0x7fffffff, 0x00c6f801, 0x7fff8000, 0x000e0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac1, 0xffffffff, 0x80000006, 0xffffffff, 0x8001fffe, 0x00020000, 0x000d8002, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac2, 0xffffffff, 0x80000000, 0xffffffff, 0x80000000, 0xff1a274e, 0x0004fffa, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac1, 0x00000000, 0x35e594be, 0x00000000, 0x35e44320, 0xfff9e38e, 0xfffef003, 0x000e0000, 0x000e0000
	dspckacc_astio dpsqx_sa.w.ph, $ac0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03fe0000, 0x03fe0000, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac2, 0xffffffff, 0x80000000, 0xffffffff, 0xf1c71c70, 0x8e388000, 0x00007fff, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac1, 0x00000000, 0x000058b2, 0x00000000, 0x000058b2, 0x00000000, 0x7ffffffc, 0x000f0000, 0x000f0000
	dspckacc_astio dpsqx_sa.w.ph, $ac1, 0xffffffff, 0xfffffffc, 0x00000000, 0x00012494